#include "trig.h"

const s16 gSineTable[0x500] = 
{
    Q_2_14(0),                 /* sin(0*π/512) */
    Q_2_14(0.00613588),        /* sin(1*π/512) */
    Q_2_14(0.01227154),        /* sin(2*π/512) */
    Q_2_14(0.01840673),        /* sin(3*π/512) */
    Q_2_14(0.02454123),        /* sin(4*π/512) */
    Q_2_14(0.03067480),        /* sin(5*π/512) */
    Q_2_14(0.03680722),        /* sin(6*π/512) */
    Q_2_14(0.04293826),        /* sin(7*π/512) */
    Q_2_14(0.04906767),        /* sin(8*π/512) */
    Q_2_14(0.05519524),        /* sin(9*π/512) */
    Q_2_14(0.06132074),        /* sin(10*π/512) */
    Q_2_14(0.06744392),        /* sin(11*π/512) */
    Q_2_14(0.07356456),        /* sin(12*π/512) */
    Q_2_14(0.07968244),        /* sin(13*π/512) */
    Q_2_14(0.08579731),        /* sin(14*π/512) */
    Q_2_14(0.09190896),        /* sin(15*π/512) */
    Q_2_14(0.09801714),        /* sin(16*π/512) */
    Q_2_14(0.10412163),        /* sin(17*π/512) */
    Q_2_14(0.11022221),        /* sin(18*π/512) */
    Q_2_14(0.11631863),        /* sin(19*π/512) */
    Q_2_14(0.12241068),        /* sin(20*π/512) */
    Q_2_14(0.12849811),        /* sin(21*π/512) */
    Q_2_14(0.13458071),        /* sin(22*π/512) */
    Q_2_14(0.14065824),        /* sin(23*π/512) */
    Q_2_14(0.14673047),        /* sin(24*π/512) */
    Q_2_14(0.15279719),        /* sin(25*π/512) */
    Q_2_14(0.15885814),        /* sin(26*π/512) */
    Q_2_14(0.16491312),        /* sin(27*π/512) */
    Q_2_14(0.17096189),        /* sin(28*π/512) */
    Q_2_14(0.17700422),        /* sin(29*π/512) */
    Q_2_14(0.18303989),        /* sin(30*π/512) */
    Q_2_14(0.18906866),        /* sin(31*π/512) */
    Q_2_14(0.19509032),        /* sin(32*π/512) */
    Q_2_14(0.20110463),        /* sin(33*π/512) */
    Q_2_14(0.20711138),        /* sin(34*π/512) */
    Q_2_14(0.21311032),        /* sin(35*π/512) */
    Q_2_14(0.21910124),        /* sin(36*π/512) */
    Q_2_14(0.22508391),        /* sin(37*π/512) */
    Q_2_14(0.23105811),        /* sin(38*π/512) */
    Q_2_14(0.23702361),        /* sin(39*π/512) */
    Q_2_14(0.24298018),        /* sin(40*π/512) */
    Q_2_14(0.24892761),        /* sin(41*π/512) */
    Q_2_14(0.25486566),        /* sin(42*π/512) */
    Q_2_14(0.26079412),        /* sin(43*π/512) */
    Q_2_14(0.26671276),        /* sin(44*π/512) */
    Q_2_14(0.27262136),        /* sin(45*π/512) */
    Q_2_14(0.27851969),        /* sin(46*π/512) */
    Q_2_14(0.28440754),        /* sin(47*π/512) */
    Q_2_14(0.29028468),        /* sin(48*π/512) */
    Q_2_14(0.29615089),        /* sin(49*π/512) */
    Q_2_14(0.30200595),        /* sin(50*π/512) */
    Q_2_14(0.30784964),        /* sin(51*π/512) */
    Q_2_14(0.31368174),        /* sin(52*π/512) */
    Q_2_14(0.31950203),        /* sin(53*π/512) */
    Q_2_14(0.32531029),        /* sin(54*π/512) */
    Q_2_14(0.33110631),        /* sin(55*π/512) */
    Q_2_14(0.33688985),        /* sin(56*π/512) */
    Q_2_14(0.34266072),        /* sin(57*π/512) */
    Q_2_14(0.34841868),        /* sin(58*π/512) */
    Q_2_14(0.35416353),        /* sin(59*π/512) */
    Q_2_14(0.35989504),        /* sin(60*π/512) */
    Q_2_14(0.36561300),        /* sin(61*π/512) */
    Q_2_14(0.37131719),        /* sin(62*π/512) */
    Q_2_14(0.37700741),        /* sin(63*π/512) */
    Q_2_14(0.38268343),        /* sin(64*π/512) */
    Q_2_14(0.38834505),        /* sin(65*π/512) */
    Q_2_14(0.39399204),        /* sin(66*π/512) */
    Q_2_14(0.39962420),        /* sin(67*π/512) */
    Q_2_14(0.40524131),        /* sin(68*π/512) */
    Q_2_14(0.41084317),        /* sin(69*π/512) */
    Q_2_14(0.41642956),        /* sin(70*π/512) */
    Q_2_14(0.42200027),        /* sin(71*π/512) */
    Q_2_14(0.42755509),        /* sin(72*π/512) */
    Q_2_14(0.43309382),        /* sin(73*π/512) */
    Q_2_14(0.43861624),        /* sin(74*π/512) */
    Q_2_14(0.44412214),        /* sin(75*π/512) */
    Q_2_14(0.44961133),        /* sin(76*π/512) */
    Q_2_14(0.45508359),        /* sin(77*π/512) */
    Q_2_14(0.46053871),        /* sin(78*π/512) */
    Q_2_14(0.46597650),        /* sin(79*π/512) */
    Q_2_14(0.47139674),        /* sin(80*π/512) */
    Q_2_14(0.47679923),        /* sin(81*π/512) */
    Q_2_14(0.48218377),        /* sin(82*π/512) */
    Q_2_14(0.48755016),        /* sin(83*π/512) */
    Q_2_14(0.49289819),        /* sin(84*π/512) */
    Q_2_14(0.49822767),        /* sin(85*π/512) */
    Q_2_14(0.50353838),        /* sin(86*π/512) */
    Q_2_14(0.50883014),        /* sin(87*π/512) */
    Q_2_14(0.51410274),        /* sin(88*π/512) */
    Q_2_14(0.51935599),        /* sin(89*π/512) */
    Q_2_14(0.52458968),        /* sin(90*π/512) */
    Q_2_14(0.52980362),        /* sin(91*π/512) */
    Q_2_14(0.53499762),        /* sin(92*π/512) */
    Q_2_14(0.54017147),        /* sin(93*π/512) */
    Q_2_14(0.54532499),        /* sin(94*π/512) */
    Q_2_14(0.55045797),        /* sin(95*π/512) */
    Q_2_14(0.55557023),        /* sin(96*π/512) */
    Q_2_14(0.56066158),        /* sin(97*π/512) */
    Q_2_14(0.56573181),        /* sin(98*π/512) */
    Q_2_14(0.57078075),        /* sin(99*π/512) */
    Q_2_14(0.57580819),        /* sin(100*π/512) */
    Q_2_14(0.58081396),        /* sin(101*π/512) */
    Q_2_14(0.58579786),        /* sin(102*π/512) */
    Q_2_14(0.59075970),        /* sin(103*π/512) */
    Q_2_14(0.59569930),        /* sin(104*π/512) */
    Q_2_14(0.60061648),        /* sin(105*π/512) */
    Q_2_14(0.60551104),        /* sin(106*π/512) */
    Q_2_14(0.61038281),        /* sin(107*π/512) */
    Q_2_14(0.61523159),        /* sin(108*π/512) */
    Q_2_14(0.62005721),        /* sin(109*π/512) */
    Q_2_14(0.62485949),        /* sin(110*π/512) */
    Q_2_14(0.62963824),        /* sin(111*π/512) */
    Q_2_14(0.63439328),        /* sin(112*π/512) */
    Q_2_14(0.63912444),        /* sin(113*π/512) */
    Q_2_14(0.64383154),        /* sin(114*π/512) */
    Q_2_14(0.64851440),        /* sin(115*π/512) */
    Q_2_14(0.65317284),        /* sin(116*π/512) */
    Q_2_14(0.65780669),        /* sin(117*π/512) */
    Q_2_14(0.66241578),        /* sin(118*π/512) */
    Q_2_14(0.66699992),        /* sin(119*π/512) */
    Q_2_14(0.67155895),        /* sin(120*π/512) */
    Q_2_14(0.67609270),        /* sin(121*π/512) */
    Q_2_14(0.68060100),        /* sin(122*π/512) */
    Q_2_14(0.68508367),        /* sin(123*π/512) */
    Q_2_14(0.68954054),        /* sin(124*π/512) */
    Q_2_14(0.69397146),        /* sin(125*π/512) */
    Q_2_14(0.69837625),        /* sin(126*π/512) */
    Q_2_14(0.70275474),        /* sin(127*π/512) */
    Q_2_14(0.70710678),        /* sin(128*π/512) */
    Q_2_14(0.71143220),        /* sin(129*π/512) */
    Q_2_14(0.71573083),        /* sin(130*π/512) */
    Q_2_14(0.72000251),        /* sin(131*π/512) */
    Q_2_14(0.72424708),        /* sin(132*π/512) */
    Q_2_14(0.72846439),        /* sin(133*π/512) */
    Q_2_14(0.73265427),        /* sin(134*π/512) */
    Q_2_14(0.73681657),        /* sin(135*π/512) */
    Q_2_14(0.74095113),        /* sin(136*π/512) */
    Q_2_14(0.74505779),        /* sin(137*π/512) */
    Q_2_14(0.74913639),        /* sin(138*π/512) */
    Q_2_14(0.75318680),        /* sin(139*π/512) */
    Q_2_14(0.75720885),        /* sin(140*π/512) */
    Q_2_14(0.76120239),        /* sin(141*π/512) */
    Q_2_14(0.76516727),        /* sin(142*π/512) */
    Q_2_14(0.76910334),        /* sin(143*π/512) */
    Q_2_14(0.77301045),        /* sin(144*π/512) */
    Q_2_14(0.77688847),        /* sin(145*π/512) */
    Q_2_14(0.78073723),        /* sin(146*π/512) */
    Q_2_14(0.78455660),        /* sin(147*π/512) */
    Q_2_14(0.78834643),        /* sin(148*π/512) */
    Q_2_14(0.79210658),        /* sin(149*π/512) */
    Q_2_14(0.79583690),        /* sin(150*π/512) */
    Q_2_14(0.79953727),        /* sin(151*π/512) */
    Q_2_14(0.80320753),        /* sin(152*π/512) */
    Q_2_14(0.80684755),        /* sin(153*π/512) */
    Q_2_14(0.81045720),        /* sin(154*π/512) */
    Q_2_14(0.81403633),        /* sin(155*π/512) */
    Q_2_14(0.81758481),        /* sin(156*π/512) */
    Q_2_14(0.82110251),        /* sin(157*π/512) */
    Q_2_14(0.82458930),        /* sin(158*π/512) */
    Q_2_14(0.82804505),        /* sin(159*π/512) */
    Q_2_14(0.83146961),        /* sin(160*π/512) */
    Q_2_14(0.83486287),        /* sin(161*π/512) */
    Q_2_14(0.83822471),        /* sin(162*π/512) */
    Q_2_14(0.84155498),        /* sin(163*π/512) */
    Q_2_14(0.84485357),        /* sin(164*π/512) */
    Q_2_14(0.84812034),        /* sin(165*π/512) */
    Q_2_14(0.85135519),        /* sin(166*π/512) */
    Q_2_14(0.85455799),        /* sin(167*π/512) */
    Q_2_14(0.85772861),        /* sin(168*π/512) */
    Q_2_14(0.86086694),        /* sin(169*π/512) */
    Q_2_14(0.86397286),        /* sin(170*π/512) */
    Q_2_14(0.86704625),        /* sin(171*π/512) */
    Q_2_14(0.87008699),        /* sin(172*π/512) */
    Q_2_14(0.87309498),        /* sin(173*π/512) */
    Q_2_14(0.87607009),        /* sin(174*π/512) */
    Q_2_14(0.87901223),        /* sin(175*π/512) */
    Q_2_14(0.88192126),        /* sin(176*π/512) */
    Q_2_14(0.88479710),        /* sin(177*π/512) */
    Q_2_14(0.88763962),        /* sin(178*π/512) */
    Q_2_14(0.89044872),        /* sin(179*π/512) */
    Q_2_14(0.89322430),        /* sin(180*π/512) */
    Q_2_14(0.89596625),        /* sin(181*π/512) */
    Q_2_14(0.89867447),        /* sin(182*π/512) */
    Q_2_14(0.90134885),        /* sin(183*π/512) */
    Q_2_14(0.90398929),        /* sin(184*π/512) */
    Q_2_14(0.90659570),        /* sin(185*π/512) */
    Q_2_14(0.90916798),        /* sin(186*π/512) */
    Q_2_14(0.91170603),        /* sin(187*π/512) */
    Q_2_14(0.91420976),        /* sin(188*π/512) */
    Q_2_14(0.91667906),        /* sin(189*π/512) */
    Q_2_14(0.91911385),        /* sin(190*π/512) */
    Q_2_14(0.92151404),        /* sin(191*π/512) */
    Q_2_14(0.92387953),        /* sin(192*π/512) */
    Q_2_14(0.92621024),        /* sin(193*π/512) */
    Q_2_14(0.92850608),        /* sin(194*π/512) */
    Q_2_14(0.93076696),        /* sin(195*π/512) */
    Q_2_14(0.93299280),        /* sin(196*π/512) */
    Q_2_14(0.93518351),        /* sin(197*π/512) */
    Q_2_14(0.93733901),        /* sin(198*π/512) */
    Q_2_14(0.93945922),        /* sin(199*π/512) */
    Q_2_14(0.94154407),        /* sin(200*π/512) */
    Q_2_14(0.94359346),        /* sin(201*π/512) */
    Q_2_14(0.94560733),        /* sin(202*π/512) */
    Q_2_14(0.94758559),        /* sin(203*π/512) */
    Q_2_14(0.94952818),        /* sin(204*π/512) */
    Q_2_14(0.95143502),        /* sin(205*π/512) */
    Q_2_14(0.95330604),        /* sin(206*π/512) */
    Q_2_14(0.95514117),        /* sin(207*π/512) */
    Q_2_14(0.95694034),        /* sin(208*π/512) */
    Q_2_14(0.95870347),        /* sin(209*π/512) */
    Q_2_14(0.96043052),        /* sin(210*π/512) */
    Q_2_14(0.96212140),        /* sin(211*π/512) */
    Q_2_14(0.96377607),        /* sin(212*π/512) */
    Q_2_14(0.96539444),        /* sin(213*π/512) */
    Q_2_14(0.96697647),        /* sin(214*π/512) */
    Q_2_14(0.96852209),        /* sin(215*π/512) */
    Q_2_14(0.97003125),        /* sin(216*π/512) */
    Q_2_14(0.97150389),        /* sin(217*π/512) */
    Q_2_14(0.97293995),        /* sin(218*π/512) */
    Q_2_14(0.97433938),        /* sin(219*π/512) */
    Q_2_14(0.97570213),        /* sin(220*π/512) */
    Q_2_14(0.97702814),        /* sin(221*π/512) */
    Q_2_14(0.97831737),        /* sin(222*π/512) */
    Q_2_14(0.97956977),        /* sin(223*π/512) */
    Q_2_14(0.98078528),        /* sin(224*π/512) */
    Q_2_14(0.98196387),        /* sin(225*π/512) */
    Q_2_14(0.98310549),        /* sin(226*π/512) */
    Q_2_14(0.98421009),        /* sin(227*π/512) */
    Q_2_14(0.98527764),        /* sin(228*π/512) */
    Q_2_14(0.98630810),        /* sin(229*π/512) */
    Q_2_14(0.98730142),        /* sin(230*π/512) */
    Q_2_14(0.98825757),        /* sin(231*π/512) */
    Q_2_14(0.98917651),        /* sin(232*π/512) */
    Q_2_14(0.99005821),        /* sin(233*π/512) */
    Q_2_14(0.99090264),        /* sin(234*π/512) */
    Q_2_14(0.99170975),        /* sin(235*π/512) */
    Q_2_14(0.99247953),        /* sin(236*π/512) */
    Q_2_14(0.99321195),        /* sin(237*π/512) */
    Q_2_14(0.99390697),        /* sin(238*π/512) */
    Q_2_14(0.99456457),        /* sin(239*π/512) */
    Q_2_14(0.99518473),        /* sin(240*π/512) */
    Q_2_14(0.99576741),        /* sin(241*π/512) */
    Q_2_14(0.99631261),        /* sin(242*π/512) */
    Q_2_14(0.99682030),        /* sin(243*π/512) */
    Q_2_14(0.99729046),        /* sin(244*π/512) */
    Q_2_14(0.99772307),        /* sin(245*π/512) */
    Q_2_14(0.99811811),        /* sin(246*π/512) */
    Q_2_14(0.99847558),        /* sin(247*π/512) */
    Q_2_14(0.99879546),        /* sin(248*π/512) */
    Q_2_14(0.99907773),        /* sin(249*π/512) */
    Q_2_14(0.99932238),        /* sin(250*π/512) */
    Q_2_14(0.99952942),        /* sin(251*π/512) */
    Q_2_14(0.99969882),        /* sin(252*π/512) */
    Q_2_14(0.99983058),        /* sin(253*π/512) */
    Q_2_14(0.99992470),        /* sin(254*π/512) */
    Q_2_14(0.99998118),        /* sin(255*π/512) */
    Q_2_14(1),                 /* sin(256*π/512) */
    Q_2_14(0.99998118),        /* sin(257*π/512) */
    Q_2_14(0.99992470),        /* sin(258*π/512) */
    Q_2_14(0.99983058),        /* sin(259*π/512) */
    Q_2_14(0.99969882),        /* sin(260*π/512) */
    Q_2_14(0.99952942),        /* sin(261*π/512) */
    Q_2_14(0.99932238),        /* sin(262*π/512) */
    Q_2_14(0.99907773),        /* sin(263*π/512) */
    Q_2_14(0.99879546),        /* sin(264*π/512) */
    Q_2_14(0.99847558),        /* sin(265*π/512) */
    Q_2_14(0.99811811),        /* sin(266*π/512) */
    Q_2_14(0.99772307),        /* sin(267*π/512) */
    Q_2_14(0.99729046),        /* sin(268*π/512) */
    Q_2_14(0.99682030),        /* sin(269*π/512) */
    Q_2_14(0.99631261),        /* sin(270*π/512) */
    Q_2_14(0.99576741),        /* sin(271*π/512) */
    Q_2_14(0.99518473),        /* sin(272*π/512) */
    Q_2_14(0.99456457),        /* sin(273*π/512) */
    Q_2_14(0.99390697),        /* sin(274*π/512) */
    Q_2_14(0.99321195),        /* sin(275*π/512) */
    Q_2_14(0.99247953),        /* sin(276*π/512) */
    Q_2_14(0.99170975),        /* sin(277*π/512) */
    Q_2_14(0.99090264),        /* sin(278*π/512) */
    Q_2_14(0.99005821),        /* sin(279*π/512) */
    Q_2_14(0.98917651),        /* sin(280*π/512) */
    Q_2_14(0.98825757),        /* sin(281*π/512) */
    Q_2_14(0.98730142),        /* sin(282*π/512) */
    Q_2_14(0.98630810),        /* sin(283*π/512) */
    Q_2_14(0.98527764),        /* sin(284*π/512) */
    Q_2_14(0.98421009),        /* sin(285*π/512) */
    Q_2_14(0.98310549),        /* sin(286*π/512) */
    Q_2_14(0.98196387),        /* sin(287*π/512) */
    Q_2_14(0.98078528),        /* sin(288*π/512) */
    Q_2_14(0.97956977),        /* sin(289*π/512) */
    Q_2_14(0.97831737),        /* sin(290*π/512) */
    Q_2_14(0.97702814),        /* sin(291*π/512) */
    Q_2_14(0.97570213),        /* sin(292*π/512) */
    Q_2_14(0.97433938),        /* sin(293*π/512) */
    Q_2_14(0.97293995),        /* sin(294*π/512) */
    Q_2_14(0.97150389),        /* sin(295*π/512) */
    Q_2_14(0.97003125),        /* sin(296*π/512) */
    Q_2_14(0.96852209),        /* sin(297*π/512) */
    Q_2_14(0.96697647),        /* sin(298*π/512) */
    Q_2_14(0.96539444),        /* sin(299*π/512) */
    Q_2_14(0.96377607),        /* sin(300*π/512) */
    Q_2_14(0.96212140),        /* sin(301*π/512) */
    Q_2_14(0.96043052),        /* sin(302*π/512) */
    Q_2_14(0.95870347),        /* sin(303*π/512) */
    Q_2_14(0.95694034),        /* sin(304*π/512) */
    Q_2_14(0.95514117),        /* sin(305*π/512) */
    Q_2_14(0.95330604),        /* sin(306*π/512) */
    Q_2_14(0.95143502),        /* sin(307*π/512) */
    Q_2_14(0.94952818),        /* sin(308*π/512) */
    Q_2_14(0.94758559),        /* sin(309*π/512) */
    Q_2_14(0.94560733),        /* sin(310*π/512) */
    Q_2_14(0.94359346),        /* sin(311*π/512) */
    Q_2_14(0.94154407),        /* sin(312*π/512) */
    Q_2_14(0.93945922),        /* sin(313*π/512) */
    Q_2_14(0.93733901),        /* sin(314*π/512) */
    Q_2_14(0.93518351),        /* sin(315*π/512) */
    Q_2_14(0.93299280),        /* sin(316*π/512) */
    Q_2_14(0.93076696),        /* sin(317*π/512) */
    Q_2_14(0.92850608),        /* sin(318*π/512) */
    Q_2_14(0.92621024),        /* sin(319*π/512) */
    Q_2_14(0.92387953),        /* sin(320*π/512) */
    Q_2_14(0.92151404),        /* sin(321*π/512) */
    Q_2_14(0.91911385),        /* sin(322*π/512) */
    Q_2_14(0.91667906),        /* sin(323*π/512) */
    Q_2_14(0.91420976),        /* sin(324*π/512) */
    Q_2_14(0.91170603),        /* sin(325*π/512) */
    Q_2_14(0.90916798),        /* sin(326*π/512) */
    Q_2_14(0.90659570),        /* sin(327*π/512) */
    Q_2_14(0.90398929),        /* sin(328*π/512) */
    Q_2_14(0.90134885),        /* sin(329*π/512) */
    Q_2_14(0.89867447),        /* sin(330*π/512) */
    Q_2_14(0.89596625),        /* sin(331*π/512) */
    Q_2_14(0.89322430),        /* sin(332*π/512) */
    Q_2_14(0.89044872),        /* sin(333*π/512) */
    Q_2_14(0.88763962),        /* sin(334*π/512) */
    Q_2_14(0.88479710),        /* sin(335*π/512) */
    Q_2_14(0.88192126),        /* sin(336*π/512) */
    Q_2_14(0.87901223),        /* sin(337*π/512) */
    Q_2_14(0.87607009),        /* sin(338*π/512) */
    Q_2_14(0.87309498),        /* sin(339*π/512) */
    Q_2_14(0.87008699),        /* sin(340*π/512) */
    Q_2_14(0.86704625),        /* sin(341*π/512) */
    Q_2_14(0.86397286),        /* sin(342*π/512) */
    Q_2_14(0.86086694),        /* sin(343*π/512) */
    Q_2_14(0.85772861),        /* sin(344*π/512) */
    Q_2_14(0.85455799),        /* sin(345*π/512) */
    Q_2_14(0.85135519),        /* sin(346*π/512) */
    Q_2_14(0.84812034),        /* sin(347*π/512) */
    Q_2_14(0.84485357),        /* sin(348*π/512) */
    Q_2_14(0.84155498),        /* sin(349*π/512) */
    Q_2_14(0.83822471),        /* sin(350*π/512) */
    Q_2_14(0.83486287),        /* sin(351*π/512) */
    Q_2_14(0.83146961),        /* sin(352*π/512) */
    Q_2_14(0.82804505),        /* sin(353*π/512) */
    Q_2_14(0.82458930),        /* sin(354*π/512) */
    Q_2_14(0.82110251),        /* sin(355*π/512) */
    Q_2_14(0.81758481),        /* sin(356*π/512) */
    Q_2_14(0.81403633),        /* sin(357*π/512) */
    Q_2_14(0.81045720),        /* sin(358*π/512) */
    Q_2_14(0.80684755),        /* sin(359*π/512) */
    Q_2_14(0.80320753),        /* sin(360*π/512) */
    Q_2_14(0.79953727),        /* sin(361*π/512) */
    Q_2_14(0.79583690),        /* sin(362*π/512) */
    Q_2_14(0.79210658),        /* sin(363*π/512) */
    Q_2_14(0.78834643),        /* sin(364*π/512) */
    Q_2_14(0.78455660),        /* sin(365*π/512) */
    Q_2_14(0.78073723),        /* sin(366*π/512) */
    Q_2_14(0.77688847),        /* sin(367*π/512) */
    Q_2_14(0.77301045),        /* sin(368*π/512) */
    Q_2_14(0.76910334),        /* sin(369*π/512) */
    Q_2_14(0.76516727),        /* sin(370*π/512) */
    Q_2_14(0.76120239),        /* sin(371*π/512) */
    Q_2_14(0.75720885),        /* sin(372*π/512) */
    Q_2_14(0.75318680),        /* sin(373*π/512) */
    Q_2_14(0.74913639),        /* sin(374*π/512) */
    Q_2_14(0.74505779),        /* sin(375*π/512) */
    Q_2_14(0.74095113),        /* sin(376*π/512) */
    Q_2_14(0.73681657),        /* sin(377*π/512) */
    Q_2_14(0.73265427),        /* sin(378*π/512) */
    Q_2_14(0.72846439),        /* sin(379*π/512) */
    Q_2_14(0.72424708),        /* sin(380*π/512) */
    Q_2_14(0.72000251),        /* sin(381*π/512) */
    Q_2_14(0.71573083),        /* sin(382*π/512) */
    Q_2_14(0.71143220),        /* sin(383*π/512) */
    Q_2_14(0.70710678),        /* sin(384*π/512) */
    Q_2_14(0.70275474),        /* sin(385*π/512) */
    Q_2_14(0.69837625),        /* sin(386*π/512) */
    Q_2_14(0.69397146),        /* sin(387*π/512) */
    Q_2_14(0.68954054),        /* sin(388*π/512) */
    Q_2_14(0.68508367),        /* sin(389*π/512) */
    Q_2_14(0.68060100),        /* sin(390*π/512) */
    Q_2_14(0.67609270),        /* sin(391*π/512) */
    Q_2_14(0.67155895),        /* sin(392*π/512) */
    Q_2_14(0.66699992),        /* sin(393*π/512) */
    Q_2_14(0.66241578),        /* sin(394*π/512) */
    Q_2_14(0.65780669),        /* sin(395*π/512) */
    Q_2_14(0.65317284),        /* sin(396*π/512) */
    Q_2_14(0.64851440),        /* sin(397*π/512) */
    Q_2_14(0.64383154),        /* sin(398*π/512) */
    Q_2_14(0.63912444),        /* sin(399*π/512) */
    Q_2_14(0.63439328),        /* sin(400*π/512) */
    Q_2_14(0.62963824),        /* sin(401*π/512) */
    Q_2_14(0.62485949),        /* sin(402*π/512) */
    Q_2_14(0.62005721),        /* sin(403*π/512) */
    Q_2_14(0.61523159),        /* sin(404*π/512) */
    Q_2_14(0.61038281),        /* sin(405*π/512) */
    Q_2_14(0.60551104),        /* sin(406*π/512) */
    Q_2_14(0.60061648),        /* sin(407*π/512) */
    Q_2_14(0.59569930),        /* sin(408*π/512) */
    Q_2_14(0.59075970),        /* sin(409*π/512) */
    Q_2_14(0.58579786),        /* sin(410*π/512) */
    Q_2_14(0.58081396),        /* sin(411*π/512) */
    Q_2_14(0.57580819),        /* sin(412*π/512) */
    Q_2_14(0.57078075),        /* sin(413*π/512) */
    Q_2_14(0.56573181),        /* sin(414*π/512) */
    Q_2_14(0.56066158),        /* sin(415*π/512) */
    Q_2_14(0.55557023),        /* sin(416*π/512) */
    Q_2_14(0.55045797),        /* sin(417*π/512) */
    Q_2_14(0.54532499),        /* sin(418*π/512) */
    Q_2_14(0.54017147),        /* sin(419*π/512) */
    Q_2_14(0.53499762),        /* sin(420*π/512) */
    Q_2_14(0.52980362),        /* sin(421*π/512) */
    Q_2_14(0.52458968),        /* sin(422*π/512) */
    Q_2_14(0.51935599),        /* sin(423*π/512) */
    Q_2_14(0.51410274),        /* sin(424*π/512) */
    Q_2_14(0.50883014),        /* sin(425*π/512) */
    Q_2_14(0.50353838),        /* sin(426*π/512) */
    Q_2_14(0.49822767),        /* sin(427*π/512) */
    Q_2_14(0.49289819),        /* sin(428*π/512) */
    Q_2_14(0.48755016),        /* sin(429*π/512) */
    Q_2_14(0.48218377),        /* sin(430*π/512) */
    Q_2_14(0.47679923),        /* sin(431*π/512) */
    Q_2_14(0.47139674),        /* sin(432*π/512) */
    Q_2_14(0.46597650),        /* sin(433*π/512) */
    Q_2_14(0.46053871),        /* sin(434*π/512) */
    Q_2_14(0.45508359),        /* sin(435*π/512) */
    Q_2_14(0.44961133),        /* sin(436*π/512) */
    Q_2_14(0.44412214),        /* sin(437*π/512) */
    Q_2_14(0.43861624),        /* sin(438*π/512) */
    Q_2_14(0.43309382),        /* sin(439*π/512) */
    Q_2_14(0.42755509),        /* sin(440*π/512) */
    Q_2_14(0.42200027),        /* sin(441*π/512) */
    Q_2_14(0.41642956),        /* sin(442*π/512) */
    Q_2_14(0.41084317),        /* sin(443*π/512) */
    Q_2_14(0.40524131),        /* sin(444*π/512) */
    Q_2_14(0.39962420),        /* sin(445*π/512) */
    Q_2_14(0.39399204),        /* sin(446*π/512) */
    Q_2_14(0.38834505),        /* sin(447*π/512) */
    Q_2_14(0.38268343),        /* sin(448*π/512) */
    Q_2_14(0.37700741),        /* sin(449*π/512) */
    Q_2_14(0.37131719),        /* sin(450*π/512) */
    Q_2_14(0.36561300),        /* sin(451*π/512) */
    Q_2_14(0.35989504),        /* sin(452*π/512) */
    Q_2_14(0.35416353),        /* sin(453*π/512) */
    Q_2_14(0.34841868),        /* sin(454*π/512) */
    Q_2_14(0.34266072),        /* sin(455*π/512) */
    Q_2_14(0.33688985),        /* sin(456*π/512) */
    Q_2_14(0.33110631),        /* sin(457*π/512) */
    Q_2_14(0.32531029),        /* sin(458*π/512) */
    Q_2_14(0.31950203),        /* sin(459*π/512) */
    Q_2_14(0.31368174),        /* sin(460*π/512) */
    Q_2_14(0.30784964),        /* sin(461*π/512) */
    Q_2_14(0.30200595),        /* sin(462*π/512) */
    Q_2_14(0.29615089),        /* sin(463*π/512) */
    Q_2_14(0.29028468),        /* sin(464*π/512) */
    Q_2_14(0.28440754),        /* sin(465*π/512) */
    Q_2_14(0.27851969),        /* sin(466*π/512) */
    Q_2_14(0.27262136),        /* sin(467*π/512) */
    Q_2_14(0.26671276),        /* sin(468*π/512) */
    Q_2_14(0.26079412),        /* sin(469*π/512) */
    Q_2_14(0.25486566),        /* sin(470*π/512) */
    Q_2_14(0.24892761),        /* sin(471*π/512) */
    Q_2_14(0.24298018),        /* sin(472*π/512) */
    Q_2_14(0.23702361),        /* sin(473*π/512) */
    Q_2_14(0.23105811),        /* sin(474*π/512) */
    Q_2_14(0.22508391),        /* sin(475*π/512) */
    Q_2_14(0.21910124),        /* sin(476*π/512) */
    Q_2_14(0.21311032),        /* sin(477*π/512) */
    Q_2_14(0.20711138),        /* sin(478*π/512) */
    Q_2_14(0.20110463),        /* sin(479*π/512) */
    Q_2_14(0.19509032),        /* sin(480*π/512) */
    Q_2_14(0.18906866),        /* sin(481*π/512) */
    Q_2_14(0.18303989),        /* sin(482*π/512) */
    Q_2_14(0.17700422),        /* sin(483*π/512) */
    Q_2_14(0.17096189),        /* sin(484*π/512) */
    Q_2_14(0.16491312),        /* sin(485*π/512) */
    Q_2_14(0.15885814),        /* sin(486*π/512) */
    Q_2_14(0.15279719),        /* sin(487*π/512) */
    Q_2_14(0.14673047),        /* sin(488*π/512) */
    Q_2_14(0.14065824),        /* sin(489*π/512) */
    Q_2_14(0.13458071),        /* sin(490*π/512) */
    Q_2_14(0.12849811),        /* sin(491*π/512) */
    Q_2_14(0.12241068),        /* sin(492*π/512) */
    Q_2_14(0.11631863),        /* sin(493*π/512) */
    Q_2_14(0.11022221),        /* sin(494*π/512) */
    Q_2_14(0.10412163),        /* sin(495*π/512) */
    Q_2_14(0.09801714),        /* sin(496*π/512) */
    Q_2_14(0.09190896),        /* sin(497*π/512) */
    Q_2_14(0.08579731),        /* sin(498*π/512) */
    Q_2_14(0.07968244),        /* sin(499*π/512) */
    Q_2_14(0.07356456),        /* sin(500*π/512) */
    Q_2_14(0.06744392),        /* sin(501*π/512) */
    Q_2_14(0.06132074),        /* sin(502*π/512) */
    Q_2_14(0.05519524),        /* sin(503*π/512) */
    Q_2_14(0.04906767),        /* sin(504*π/512) */
    Q_2_14(0.04293826),        /* sin(505*π/512) */
    Q_2_14(0.03680722),        /* sin(506*π/512) */
    Q_2_14(0.03067480),        /* sin(507*π/512) */
    Q_2_14(0.02454123),        /* sin(508*π/512) */
    Q_2_14(0.01840673),        /* sin(509*π/512) */
    Q_2_14(0.01227154),        /* sin(510*π/512) */
    Q_2_14(0.00613588),        /* sin(511*π/512) */
    Q_2_14(0),                 /* sin(512*π/512) */
    Q_2_14(-0.00613588),       /* sin(513*π/512) */
    Q_2_14(-0.01227154),       /* sin(514*π/512) */
    Q_2_14(-0.01840673),       /* sin(515*π/512) */
    Q_2_14(-0.02454123),       /* sin(516*π/512) */
    Q_2_14(-0.03067480),       /* sin(517*π/512) */
    Q_2_14(-0.03680722),       /* sin(518*π/512) */
    Q_2_14(-0.04293826),       /* sin(519*π/512) */
    Q_2_14(-0.04906767),       /* sin(520*π/512) */
    Q_2_14(-0.05519524),       /* sin(521*π/512) */
    Q_2_14(-0.06132074),       /* sin(522*π/512) */
    Q_2_14(-0.06744392),       /* sin(523*π/512) */
    Q_2_14(-0.07356456),       /* sin(524*π/512) */
    Q_2_14(-0.07968244),       /* sin(525*π/512) */
    Q_2_14(-0.08579731),       /* sin(526*π/512) */
    Q_2_14(-0.09190896),       /* sin(527*π/512) */
    Q_2_14(-0.09801714),       /* sin(528*π/512) */
    Q_2_14(-0.10412163),       /* sin(529*π/512) */
    Q_2_14(-0.11022221),       /* sin(530*π/512) */
    Q_2_14(-0.11631863),       /* sin(531*π/512) */
    Q_2_14(-0.12241068),       /* sin(532*π/512) */
    Q_2_14(-0.12849811),       /* sin(533*π/512) */
    Q_2_14(-0.13458071),       /* sin(534*π/512) */
    Q_2_14(-0.14065824),       /* sin(535*π/512) */
    Q_2_14(-0.14673047),       /* sin(536*π/512) */
    Q_2_14(-0.15279719),       /* sin(537*π/512) */
    Q_2_14(-0.15885814),       /* sin(538*π/512) */
    Q_2_14(-0.16491312),       /* sin(539*π/512) */
    Q_2_14(-0.17096189),       /* sin(540*π/512) */
    Q_2_14(-0.17700422),       /* sin(541*π/512) */
    Q_2_14(-0.18303989),       /* sin(542*π/512) */
    Q_2_14(-0.18906866),       /* sin(543*π/512) */
    Q_2_14(-0.19509032),       /* sin(544*π/512) */
    Q_2_14(-0.20110463),       /* sin(545*π/512) */
    Q_2_14(-0.20711138),       /* sin(546*π/512) */
    Q_2_14(-0.21311032),       /* sin(547*π/512) */
    Q_2_14(-0.21910124),       /* sin(548*π/512) */
    Q_2_14(-0.22508391),       /* sin(549*π/512) */
    Q_2_14(-0.23105811),       /* sin(550*π/512) */
    Q_2_14(-0.23702361),       /* sin(551*π/512) */
    Q_2_14(-0.24298018),       /* sin(552*π/512) */
    Q_2_14(-0.24892761),       /* sin(553*π/512) */
    Q_2_14(-0.25486566),       /* sin(554*π/512) */
    Q_2_14(-0.26079412),       /* sin(555*π/512) */
    Q_2_14(-0.26671276),       /* sin(556*π/512) */
    Q_2_14(-0.27262136),       /* sin(557*π/512) */
    Q_2_14(-0.27851969),       /* sin(558*π/512) */
    Q_2_14(-0.28440754),       /* sin(559*π/512) */
    Q_2_14(-0.29028468),       /* sin(560*π/512) */
    Q_2_14(-0.29615089),       /* sin(561*π/512) */
    Q_2_14(-0.30200595),       /* sin(562*π/512) */
    Q_2_14(-0.30784964),       /* sin(563*π/512) */
    Q_2_14(-0.31368174),       /* sin(564*π/512) */
    Q_2_14(-0.31950203),       /* sin(565*π/512) */
    Q_2_14(-0.32531029),       /* sin(566*π/512) */
    Q_2_14(-0.33110631),       /* sin(567*π/512) */
    Q_2_14(-0.33688985),       /* sin(568*π/512) */
    Q_2_14(-0.34266072),       /* sin(569*π/512) */
    Q_2_14(-0.34841868),       /* sin(570*π/512) */
    Q_2_14(-0.35416353),       /* sin(571*π/512) */
    Q_2_14(-0.35989504),       /* sin(572*π/512) */
    Q_2_14(-0.36561300),       /* sin(573*π/512) */
    Q_2_14(-0.37131719),       /* sin(574*π/512) */
    Q_2_14(-0.37700741),       /* sin(575*π/512) */
    Q_2_14(-0.38268343),       /* sin(576*π/512) */
    Q_2_14(-0.38834505),       /* sin(577*π/512) */
    Q_2_14(-0.39399204),       /* sin(578*π/512) */
    Q_2_14(-0.39962420),       /* sin(579*π/512) */
    Q_2_14(-0.40524131),       /* sin(580*π/512) */
    Q_2_14(-0.41084317),       /* sin(581*π/512) */
    Q_2_14(-0.41642956),       /* sin(582*π/512) */
    Q_2_14(-0.42200027),       /* sin(583*π/512) */
    Q_2_14(-0.42755509),       /* sin(584*π/512) */
    Q_2_14(-0.43309382),       /* sin(585*π/512) */
    Q_2_14(-0.43861624),       /* sin(586*π/512) */
    Q_2_14(-0.44412214),       /* sin(587*π/512) */
    Q_2_14(-0.44961133),       /* sin(588*π/512) */
    Q_2_14(-0.45508359),       /* sin(589*π/512) */
    Q_2_14(-0.46053871),       /* sin(590*π/512) */
    Q_2_14(-0.46597650),       /* sin(591*π/512) */
    Q_2_14(-0.47139674),       /* sin(592*π/512) */
    Q_2_14(-0.47679923),       /* sin(593*π/512) */
    Q_2_14(-0.48218377),       /* sin(594*π/512) */
    Q_2_14(-0.48755016),       /* sin(595*π/512) */
    Q_2_14(-0.49289819),       /* sin(596*π/512) */
    Q_2_14(-0.49822767),       /* sin(597*π/512) */
    Q_2_14(-0.50353838),       /* sin(598*π/512) */
    Q_2_14(-0.50883014),       /* sin(599*π/512) */
    Q_2_14(-0.51410274),       /* sin(600*π/512) */
    Q_2_14(-0.51935599),       /* sin(601*π/512) */
    Q_2_14(-0.52458968),       /* sin(602*π/512) */
    Q_2_14(-0.52980362),       /* sin(603*π/512) */
    Q_2_14(-0.53499762),       /* sin(604*π/512) */
    Q_2_14(-0.54017147),       /* sin(605*π/512) */
    Q_2_14(-0.54532499),       /* sin(606*π/512) */
    Q_2_14(-0.55045797),       /* sin(607*π/512) */
    Q_2_14(-0.55557023),       /* sin(608*π/512) */
    Q_2_14(-0.56066158),       /* sin(609*π/512) */
    Q_2_14(-0.56573181),       /* sin(610*π/512) */
    Q_2_14(-0.57078075),       /* sin(611*π/512) */
    Q_2_14(-0.57580819),       /* sin(612*π/512) */
    Q_2_14(-0.58081396),       /* sin(613*π/512) */
    Q_2_14(-0.58579786),       /* sin(614*π/512) */
    Q_2_14(-0.59075970),       /* sin(615*π/512) */
    Q_2_14(-0.59569930),       /* sin(616*π/512) */
    Q_2_14(-0.60061648),       /* sin(617*π/512) */
    Q_2_14(-0.60551104),       /* sin(618*π/512) */
    Q_2_14(-0.61038281),       /* sin(619*π/512) */
    Q_2_14(-0.61523159),       /* sin(620*π/512) */
    Q_2_14(-0.62005721),       /* sin(621*π/512) */
    Q_2_14(-0.62485949),       /* sin(622*π/512) */
    Q_2_14(-0.62963824),       /* sin(623*π/512) */
    Q_2_14(-0.63439328),       /* sin(624*π/512) */
    Q_2_14(-0.63912444),       /* sin(625*π/512) */
    Q_2_14(-0.64383154),       /* sin(626*π/512) */
    Q_2_14(-0.64851440),       /* sin(627*π/512) */
    Q_2_14(-0.65317284),       /* sin(628*π/512) */
    Q_2_14(-0.65780669),       /* sin(629*π/512) */
    Q_2_14(-0.66241578),       /* sin(630*π/512) */
    Q_2_14(-0.66699992),       /* sin(631*π/512) */
    Q_2_14(-0.67155895),       /* sin(632*π/512) */
    Q_2_14(-0.67609270),       /* sin(633*π/512) */
    Q_2_14(-0.68060100),       /* sin(634*π/512) */
    Q_2_14(-0.68508367),       /* sin(635*π/512) */
    Q_2_14(-0.68954054),       /* sin(636*π/512) */
    Q_2_14(-0.69397146),       /* sin(637*π/512) */
    Q_2_14(-0.69837625),       /* sin(638*π/512) */
    Q_2_14(-0.70275474),       /* sin(639*π/512) */
    Q_2_14(-0.70710678),       /* sin(640*π/512) */
    Q_2_14(-0.71143220),       /* sin(641*π/512) */
    Q_2_14(-0.71573083),       /* sin(642*π/512) */
    Q_2_14(-0.72000251),       /* sin(643*π/512) */
    Q_2_14(-0.72424708),       /* sin(644*π/512) */
    Q_2_14(-0.72846439),       /* sin(645*π/512) */
    Q_2_14(-0.73265427),       /* sin(646*π/512) */
    Q_2_14(-0.73681657),       /* sin(647*π/512) */
    Q_2_14(-0.74095113),       /* sin(648*π/512) */
    Q_2_14(-0.74505779),       /* sin(649*π/512) */
    Q_2_14(-0.74913639),       /* sin(650*π/512) */
    Q_2_14(-0.75318680),       /* sin(651*π/512) */
    Q_2_14(-0.75720885),       /* sin(652*π/512) */
    Q_2_14(-0.76120239),       /* sin(653*π/512) */
    Q_2_14(-0.76516727),       /* sin(654*π/512) */
    Q_2_14(-0.76910334),       /* sin(655*π/512) */
    Q_2_14(-0.77301045),       /* sin(656*π/512) */
    Q_2_14(-0.77688847),       /* sin(657*π/512) */
    Q_2_14(-0.78073723),       /* sin(658*π/512) */
    Q_2_14(-0.78455660),       /* sin(659*π/512) */
    Q_2_14(-0.78834643),       /* sin(660*π/512) */
    Q_2_14(-0.79210658),       /* sin(661*π/512) */
    Q_2_14(-0.79583690),       /* sin(662*π/512) */
    Q_2_14(-0.79953727),       /* sin(663*π/512) */
    Q_2_14(-0.80320753),       /* sin(664*π/512) */
    Q_2_14(-0.80684755),       /* sin(665*π/512) */
    Q_2_14(-0.81045720),       /* sin(666*π/512) */
    Q_2_14(-0.81403633),       /* sin(667*π/512) */
    Q_2_14(-0.81758481),       /* sin(668*π/512) */
    Q_2_14(-0.82110251),       /* sin(669*π/512) */
    Q_2_14(-0.82458930),       /* sin(670*π/512) */
    Q_2_14(-0.82804505),       /* sin(671*π/512) */
    Q_2_14(-0.83146961),       /* sin(672*π/512) */
    Q_2_14(-0.83486287),       /* sin(673*π/512) */
    Q_2_14(-0.83822471),       /* sin(674*π/512) */
    Q_2_14(-0.84155498),       /* sin(675*π/512) */
    Q_2_14(-0.84485357),       /* sin(676*π/512) */
    Q_2_14(-0.84812034),       /* sin(677*π/512) */
    Q_2_14(-0.85135519),       /* sin(678*π/512) */
    Q_2_14(-0.85455799),       /* sin(679*π/512) */
    Q_2_14(-0.85772861),       /* sin(680*π/512) */
    Q_2_14(-0.86086694),       /* sin(681*π/512) */
    Q_2_14(-0.86397286),       /* sin(682*π/512) */
    Q_2_14(-0.86704625),       /* sin(683*π/512) */
    Q_2_14(-0.87008699),       /* sin(684*π/512) */
    Q_2_14(-0.87309498),       /* sin(685*π/512) */
    Q_2_14(-0.87607009),       /* sin(686*π/512) */
    Q_2_14(-0.87901223),       /* sin(687*π/512) */
    Q_2_14(-0.88192126),       /* sin(688*π/512) */
    Q_2_14(-0.88479710),       /* sin(689*π/512) */
    Q_2_14(-0.88763962),       /* sin(690*π/512) */
    Q_2_14(-0.89044872),       /* sin(691*π/512) */
    Q_2_14(-0.89322430),       /* sin(692*π/512) */
    Q_2_14(-0.89596625),       /* sin(693*π/512) */
    Q_2_14(-0.89867447),       /* sin(694*π/512) */
    Q_2_14(-0.90134885),       /* sin(695*π/512) */
    Q_2_14(-0.90398929),       /* sin(696*π/512) */
    Q_2_14(-0.90659570),       /* sin(697*π/512) */
    Q_2_14(-0.90916798),       /* sin(698*π/512) */
    Q_2_14(-0.91170603),       /* sin(699*π/512) */
    Q_2_14(-0.91420976),       /* sin(700*π/512) */
    Q_2_14(-0.91667906),       /* sin(701*π/512) */
    Q_2_14(-0.91911385),       /* sin(702*π/512) */
    Q_2_14(-0.92151404),       /* sin(703*π/512) */
    Q_2_14(-0.92387953),       /* sin(704*π/512) */
    Q_2_14(-0.92621024),       /* sin(705*π/512) */
    Q_2_14(-0.92850608),       /* sin(706*π/512) */
    Q_2_14(-0.93076696),       /* sin(707*π/512) */
    Q_2_14(-0.93299280),       /* sin(708*π/512) */
    Q_2_14(-0.93518351),       /* sin(709*π/512) */
    Q_2_14(-0.93733901),       /* sin(710*π/512) */
    Q_2_14(-0.93945922),       /* sin(711*π/512) */
    Q_2_14(-0.94154407),       /* sin(712*π/512) */
    Q_2_14(-0.94359346),       /* sin(713*π/512) */
    Q_2_14(-0.94560733),       /* sin(714*π/512) */
    Q_2_14(-0.94758559),       /* sin(715*π/512) */
    Q_2_14(-0.94952818),       /* sin(716*π/512) */
    Q_2_14(-0.95143502),       /* sin(717*π/512) */
    Q_2_14(-0.95330604),       /* sin(718*π/512) */
    Q_2_14(-0.95514117),       /* sin(719*π/512) */
    Q_2_14(-0.95694034),       /* sin(720*π/512) */
    Q_2_14(-0.95870347),       /* sin(721*π/512) */
    Q_2_14(-0.96043052),       /* sin(722*π/512) */
    Q_2_14(-0.96212140),       /* sin(723*π/512) */
    Q_2_14(-0.96377607),       /* sin(724*π/512) */
    Q_2_14(-0.96539444),       /* sin(725*π/512) */
    Q_2_14(-0.96697647),       /* sin(726*π/512) */
    Q_2_14(-0.96852209),       /* sin(727*π/512) */
    Q_2_14(-0.97003125),       /* sin(728*π/512) */
    Q_2_14(-0.97150389),       /* sin(729*π/512) */
    Q_2_14(-0.97293995),       /* sin(730*π/512) */
    Q_2_14(-0.97433938),       /* sin(731*π/512) */
    Q_2_14(-0.97570213),       /* sin(732*π/512) */
    Q_2_14(-0.97702814),       /* sin(733*π/512) */
    Q_2_14(-0.97831737),       /* sin(734*π/512) */
    Q_2_14(-0.97956977),       /* sin(735*π/512) */
    Q_2_14(-0.98078528),       /* sin(736*π/512) */
    Q_2_14(-0.98196387),       /* sin(737*π/512) */
    Q_2_14(-0.98310549),       /* sin(738*π/512) */
    Q_2_14(-0.98421009),       /* sin(739*π/512) */
    Q_2_14(-0.98527764),       /* sin(740*π/512) */
    Q_2_14(-0.98630810),       /* sin(741*π/512) */
    Q_2_14(-0.98730142),       /* sin(742*π/512) */
    Q_2_14(-0.98825757),       /* sin(743*π/512) */
    Q_2_14(-0.98917651),       /* sin(744*π/512) */
    Q_2_14(-0.99005821),       /* sin(745*π/512) */
    Q_2_14(-0.99090264),       /* sin(746*π/512) */
    Q_2_14(-0.99170975),       /* sin(747*π/512) */
    Q_2_14(-0.99247953),       /* sin(748*π/512) */
    Q_2_14(-0.99321195),       /* sin(749*π/512) */
    Q_2_14(-0.99390697),       /* sin(750*π/512) */
    Q_2_14(-0.99456457),       /* sin(751*π/512) */
    Q_2_14(-0.99518473),       /* sin(752*π/512) */
    Q_2_14(-0.99576741),       /* sin(753*π/512) */
    Q_2_14(-0.99631261),       /* sin(754*π/512) */
    Q_2_14(-0.99682030),       /* sin(755*π/512) */
    Q_2_14(-0.99729046),       /* sin(756*π/512) */
    Q_2_14(-0.99772307),       /* sin(757*π/512) */
    Q_2_14(-0.99811811),       /* sin(758*π/512) */
    Q_2_14(-0.99847558),       /* sin(759*π/512) */
    Q_2_14(-0.99879546),       /* sin(760*π/512) */
    Q_2_14(-0.99907773),       /* sin(761*π/512) */
    Q_2_14(-0.99932238),       /* sin(762*π/512) */
    Q_2_14(-0.99952942),       /* sin(763*π/512) */
    Q_2_14(-0.99969882),       /* sin(764*π/512) */
    Q_2_14(-0.99983058),       /* sin(765*π/512) */
    Q_2_14(-0.99992470),       /* sin(766*π/512) */
    Q_2_14(-0.99998118),       /* sin(767*π/512) */
    Q_2_14(-1),                /* sin(768*π/512) */
    Q_2_14(-0.99998118),       /* sin(769*π/512) */
    Q_2_14(-0.99992470),       /* sin(770*π/512) */
    Q_2_14(-0.99983058),       /* sin(771*π/512) */
    Q_2_14(-0.99969882),       /* sin(772*π/512) */
    Q_2_14(-0.99952942),       /* sin(773*π/512) */
    Q_2_14(-0.99932238),       /* sin(774*π/512) */
    Q_2_14(-0.99907773),       /* sin(775*π/512) */
    Q_2_14(-0.99879546),       /* sin(776*π/512) */
    Q_2_14(-0.99847558),       /* sin(777*π/512) */
    Q_2_14(-0.99811811),       /* sin(778*π/512) */
    Q_2_14(-0.99772307),       /* sin(779*π/512) */
    Q_2_14(-0.99729046),       /* sin(780*π/512) */
    Q_2_14(-0.99682030),       /* sin(781*π/512) */
    Q_2_14(-0.99631261),       /* sin(782*π/512) */
    Q_2_14(-0.99576741),       /* sin(783*π/512) */
    Q_2_14(-0.99518473),       /* sin(784*π/512) */
    Q_2_14(-0.99456457),       /* sin(785*π/512) */
    Q_2_14(-0.99390697),       /* sin(786*π/512) */
    Q_2_14(-0.99321195),       /* sin(787*π/512) */
    Q_2_14(-0.99247953),       /* sin(788*π/512) */
    Q_2_14(-0.99170975),       /* sin(789*π/512) */
    Q_2_14(-0.99090264),       /* sin(790*π/512) */
    Q_2_14(-0.99005821),       /* sin(791*π/512) */
    Q_2_14(-0.98917651),       /* sin(792*π/512) */
    Q_2_14(-0.98825757),       /* sin(793*π/512) */
    Q_2_14(-0.98730142),       /* sin(794*π/512) */
    Q_2_14(-0.98630810),       /* sin(795*π/512) */
    Q_2_14(-0.98527764),       /* sin(796*π/512) */
    Q_2_14(-0.98421009),       /* sin(797*π/512) */
    Q_2_14(-0.98310549),       /* sin(798*π/512) */
    Q_2_14(-0.98196387),       /* sin(799*π/512) */
    Q_2_14(-0.98078528),       /* sin(800*π/512) */
    Q_2_14(-0.97956977),       /* sin(801*π/512) */
    Q_2_14(-0.97831737),       /* sin(802*π/512) */
    Q_2_14(-0.97702814),       /* sin(803*π/512) */
    Q_2_14(-0.97570213),       /* sin(804*π/512) */
    Q_2_14(-0.97433938),       /* sin(805*π/512) */
    Q_2_14(-0.97293995),       /* sin(806*π/512) */
    Q_2_14(-0.97150389),       /* sin(807*π/512) */
    Q_2_14(-0.97003125),       /* sin(808*π/512) */
    Q_2_14(-0.96852209),       /* sin(809*π/512) */
    Q_2_14(-0.96697647),       /* sin(810*π/512) */
    Q_2_14(-0.96539444),       /* sin(811*π/512) */
    Q_2_14(-0.96377607),       /* sin(812*π/512) */
    Q_2_14(-0.96212140),       /* sin(813*π/512) */
    Q_2_14(-0.96043052),       /* sin(814*π/512) */
    Q_2_14(-0.95870347),       /* sin(815*π/512) */
    Q_2_14(-0.95694034),       /* sin(816*π/512) */
    Q_2_14(-0.95514117),       /* sin(817*π/512) */
    Q_2_14(-0.95330604),       /* sin(818*π/512) */
    Q_2_14(-0.95143502),       /* sin(819*π/512) */
    Q_2_14(-0.94952818),       /* sin(820*π/512) */
    Q_2_14(-0.94758559),       /* sin(821*π/512) */
    Q_2_14(-0.94560733),       /* sin(822*π/512) */
    Q_2_14(-0.94359346),       /* sin(823*π/512) */
    Q_2_14(-0.94154407),       /* sin(824*π/512) */
    Q_2_14(-0.93945922),       /* sin(825*π/512) */
    Q_2_14(-0.93733901),       /* sin(826*π/512) */
    Q_2_14(-0.93518351),       /* sin(827*π/512) */
    Q_2_14(-0.93299280),       /* sin(828*π/512) */
    Q_2_14(-0.93076696),       /* sin(829*π/512) */
    Q_2_14(-0.92850608),       /* sin(830*π/512) */
    Q_2_14(-0.92621024),       /* sin(831*π/512) */
    Q_2_14(-0.92387953),       /* sin(832*π/512) */
    Q_2_14(-0.92151404),       /* sin(833*π/512) */
    Q_2_14(-0.91911385),       /* sin(834*π/512) */
    Q_2_14(-0.91667906),       /* sin(835*π/512) */
    Q_2_14(-0.91420976),       /* sin(836*π/512) */
    Q_2_14(-0.91170603),       /* sin(837*π/512) */
    Q_2_14(-0.90916798),       /* sin(838*π/512) */
    Q_2_14(-0.90659570),       /* sin(839*π/512) */
    Q_2_14(-0.90398929),       /* sin(840*π/512) */
    Q_2_14(-0.90134885),       /* sin(841*π/512) */
    Q_2_14(-0.89867447),       /* sin(842*π/512) */
    Q_2_14(-0.89596625),       /* sin(843*π/512) */
    Q_2_14(-0.89322430),       /* sin(844*π/512) */
    Q_2_14(-0.89044872),       /* sin(845*π/512) */
    Q_2_14(-0.88763962),       /* sin(846*π/512) */
    Q_2_14(-0.88479710),       /* sin(847*π/512) */
    Q_2_14(-0.88192126),       /* sin(848*π/512) */
    Q_2_14(-0.87901223),       /* sin(849*π/512) */
    Q_2_14(-0.87607009),       /* sin(850*π/512) */
    Q_2_14(-0.87309498),       /* sin(851*π/512) */
    Q_2_14(-0.87008699),       /* sin(852*π/512) */
    Q_2_14(-0.86704625),       /* sin(853*π/512) */
    Q_2_14(-0.86397286),       /* sin(854*π/512) */
    Q_2_14(-0.86086694),       /* sin(855*π/512) */
    Q_2_14(-0.85772861),       /* sin(856*π/512) */
    Q_2_14(-0.85455799),       /* sin(857*π/512) */
    Q_2_14(-0.85135519),       /* sin(858*π/512) */
    Q_2_14(-0.84812034),       /* sin(859*π/512) */
    Q_2_14(-0.84485357),       /* sin(860*π/512) */
    Q_2_14(-0.84155498),       /* sin(861*π/512) */
    Q_2_14(-0.83822471),       /* sin(862*π/512) */
    Q_2_14(-0.83486287),       /* sin(863*π/512) */
    Q_2_14(-0.83146961),       /* sin(864*π/512) */
    Q_2_14(-0.82804505),       /* sin(865*π/512) */
    Q_2_14(-0.82458930),       /* sin(866*π/512) */
    Q_2_14(-0.82110251),       /* sin(867*π/512) */
    Q_2_14(-0.81758481),       /* sin(868*π/512) */
    Q_2_14(-0.81403633),       /* sin(869*π/512) */
    Q_2_14(-0.81045720),       /* sin(870*π/512) */
    Q_2_14(-0.80684755),       /* sin(871*π/512) */
    Q_2_14(-0.80320753),       /* sin(872*π/512) */
    Q_2_14(-0.79953727),       /* sin(873*π/512) */
    Q_2_14(-0.79583690),       /* sin(874*π/512) */
    Q_2_14(-0.79210658),       /* sin(875*π/512) */
    Q_2_14(-0.78834643),       /* sin(876*π/512) */
    Q_2_14(-0.78455660),       /* sin(877*π/512) */
    Q_2_14(-0.78073723),       /* sin(878*π/512) */
    Q_2_14(-0.77688847),       /* sin(879*π/512) */
    Q_2_14(-0.77301045),       /* sin(880*π/512) */
    Q_2_14(-0.76910334),       /* sin(881*π/512) */
    Q_2_14(-0.76516727),       /* sin(882*π/512) */
    Q_2_14(-0.76120239),       /* sin(883*π/512) */
    Q_2_14(-0.75720885),       /* sin(884*π/512) */
    Q_2_14(-0.75318680),       /* sin(885*π/512) */
    Q_2_14(-0.74913639),       /* sin(886*π/512) */
    Q_2_14(-0.74505779),       /* sin(887*π/512) */
    Q_2_14(-0.74095113),       /* sin(888*π/512) */
    Q_2_14(-0.73681657),       /* sin(889*π/512) */
    Q_2_14(-0.73265427),       /* sin(890*π/512) */
    Q_2_14(-0.72846439),       /* sin(891*π/512) */
    Q_2_14(-0.72424708),       /* sin(892*π/512) */
    Q_2_14(-0.72000251),       /* sin(893*π/512) */
    Q_2_14(-0.71573083),       /* sin(894*π/512) */
    Q_2_14(-0.71143220),       /* sin(895*π/512) */
    Q_2_14(-0.70710678),       /* sin(896*π/512) */
    Q_2_14(-0.70275474),       /* sin(897*π/512) */
    Q_2_14(-0.69837625),       /* sin(898*π/512) */
    Q_2_14(-0.69397146),       /* sin(899*π/512) */
    Q_2_14(-0.68954054),       /* sin(900*π/512) */
    Q_2_14(-0.68508367),       /* sin(901*π/512) */
    Q_2_14(-0.68060100),       /* sin(902*π/512) */
    Q_2_14(-0.67609270),       /* sin(903*π/512) */
    Q_2_14(-0.67155895),       /* sin(904*π/512) */
    Q_2_14(-0.66699992),       /* sin(905*π/512) */
    Q_2_14(-0.66241578),       /* sin(906*π/512) */
    Q_2_14(-0.65780669),       /* sin(907*π/512) */
    Q_2_14(-0.65317284),       /* sin(908*π/512) */
    Q_2_14(-0.64851440),       /* sin(909*π/512) */
    Q_2_14(-0.64383154),       /* sin(910*π/512) */
    Q_2_14(-0.63912444),       /* sin(911*π/512) */
    Q_2_14(-0.63439328),       /* sin(912*π/512) */
    Q_2_14(-0.62963824),       /* sin(913*π/512) */
    Q_2_14(-0.62485949),       /* sin(914*π/512) */
    Q_2_14(-0.62005721),       /* sin(915*π/512) */
    Q_2_14(-0.61523159),       /* sin(916*π/512) */
    Q_2_14(-0.61038281),       /* sin(917*π/512) */
    Q_2_14(-0.60551104),       /* sin(918*π/512) */
    Q_2_14(-0.60061648),       /* sin(919*π/512) */
    Q_2_14(-0.59569930),       /* sin(920*π/512) */
    Q_2_14(-0.59075970),       /* sin(921*π/512) */
    Q_2_14(-0.58579786),       /* sin(922*π/512) */
    Q_2_14(-0.58081396),       /* sin(923*π/512) */
    Q_2_14(-0.57580819),       /* sin(924*π/512) */
    Q_2_14(-0.57078075),       /* sin(925*π/512) */
    Q_2_14(-0.56573181),       /* sin(926*π/512) */
    Q_2_14(-0.56066158),       /* sin(927*π/512) */
    Q_2_14(-0.55557023),       /* sin(928*π/512) */
    Q_2_14(-0.55045797),       /* sin(929*π/512) */
    Q_2_14(-0.54532499),       /* sin(930*π/512) */
    Q_2_14(-0.54017147),       /* sin(931*π/512) */
    Q_2_14(-0.53499762),       /* sin(932*π/512) */
    Q_2_14(-0.52980362),       /* sin(933*π/512) */
    Q_2_14(-0.52458968),       /* sin(934*π/512) */
    Q_2_14(-0.51935599),       /* sin(935*π/512) */
    Q_2_14(-0.51410274),       /* sin(936*π/512) */
    Q_2_14(-0.50883014),       /* sin(937*π/512) */
    Q_2_14(-0.50353838),       /* sin(938*π/512) */
    Q_2_14(-0.49822767),       /* sin(939*π/512) */
    Q_2_14(-0.49289819),       /* sin(940*π/512) */
    Q_2_14(-0.48755016),       /* sin(941*π/512) */
    Q_2_14(-0.48218377),       /* sin(942*π/512) */
    Q_2_14(-0.47679923),       /* sin(943*π/512) */
    Q_2_14(-0.47139674),       /* sin(944*π/512) */
    Q_2_14(-0.46597650),       /* sin(945*π/512) */
    Q_2_14(-0.46053871),       /* sin(946*π/512) */
    Q_2_14(-0.45508359),       /* sin(947*π/512) */
    Q_2_14(-0.44961133),       /* sin(948*π/512) */
    Q_2_14(-0.44412214),       /* sin(949*π/512) */
    Q_2_14(-0.43861624),       /* sin(950*π/512) */
    Q_2_14(-0.43309382),       /* sin(951*π/512) */
    Q_2_14(-0.42755509),       /* sin(952*π/512) */
    Q_2_14(-0.42200027),       /* sin(953*π/512) */
    Q_2_14(-0.41642956),       /* sin(954*π/512) */
    Q_2_14(-0.41084317),       /* sin(955*π/512) */
    Q_2_14(-0.40524131),       /* sin(956*π/512) */
    Q_2_14(-0.39962420),       /* sin(957*π/512) */
    Q_2_14(-0.39399204),       /* sin(958*π/512) */
    Q_2_14(-0.38834505),       /* sin(959*π/512) */
    Q_2_14(-0.38268343),       /* sin(960*π/512) */
    Q_2_14(-0.37700741),       /* sin(961*π/512) */
    Q_2_14(-0.37131719),       /* sin(962*π/512) */
    Q_2_14(-0.36561300),       /* sin(963*π/512) */
    Q_2_14(-0.35989504),       /* sin(964*π/512) */
    Q_2_14(-0.35416353),       /* sin(965*π/512) */
    Q_2_14(-0.34841868),       /* sin(966*π/512) */
    Q_2_14(-0.34266072),       /* sin(967*π/512) */
    Q_2_14(-0.33688985),       /* sin(968*π/512) */
    Q_2_14(-0.33110631),       /* sin(969*π/512) */
    Q_2_14(-0.32531029),       /* sin(970*π/512) */
    Q_2_14(-0.31950203),       /* sin(971*π/512) */
    Q_2_14(-0.31368174),       /* sin(972*π/512) */
    Q_2_14(-0.30784964),       /* sin(973*π/512) */
    Q_2_14(-0.30200595),       /* sin(974*π/512) */
    Q_2_14(-0.29615089),       /* sin(975*π/512) */
    Q_2_14(-0.29028468),       /* sin(976*π/512) */
    Q_2_14(-0.28440754),       /* sin(977*π/512) */
    Q_2_14(-0.27851969),       /* sin(978*π/512) */
    Q_2_14(-0.27262136),       /* sin(979*π/512) */
    Q_2_14(-0.26671276),       /* sin(980*π/512) */
    Q_2_14(-0.26079412),       /* sin(981*π/512) */
    Q_2_14(-0.25486566),       /* sin(982*π/512) */
    Q_2_14(-0.24892761),       /* sin(983*π/512) */
    Q_2_14(-0.24298018),       /* sin(984*π/512) */
    Q_2_14(-0.23702361),       /* sin(985*π/512) */
    Q_2_14(-0.23105811),       /* sin(986*π/512) */
    Q_2_14(-0.22508391),       /* sin(987*π/512) */
    Q_2_14(-0.21910124),       /* sin(988*π/512) */
    Q_2_14(-0.21311032),       /* sin(989*π/512) */
    Q_2_14(-0.20711138),       /* sin(990*π/512) */
    Q_2_14(-0.20110463),       /* sin(991*π/512) */
    Q_2_14(-0.19509032),       /* sin(992*π/512) */
    Q_2_14(-0.18906866),       /* sin(993*π/512) */
    Q_2_14(-0.18303989),       /* sin(994*π/512) */
    Q_2_14(-0.17700422),       /* sin(995*π/512) */
    Q_2_14(-0.17096189),       /* sin(996*π/512) */
    Q_2_14(-0.16491312),       /* sin(997*π/512) */
    Q_2_14(-0.15885814),       /* sin(998*π/512) */
    Q_2_14(-0.15279719),       /* sin(999*π/512) */
    Q_2_14(-0.14673047),       /* sin(1000*π/512) */
    Q_2_14(-0.14065824),       /* sin(1001*π/512) */
    Q_2_14(-0.13458071),       /* sin(1002*π/512) */
    Q_2_14(-0.12849811),       /* sin(1003*π/512) */
    Q_2_14(-0.12241068),       /* sin(1004*π/512) */
    Q_2_14(-0.11631863),       /* sin(1005*π/512) */
    Q_2_14(-0.11022221),       /* sin(1006*π/512) */
    Q_2_14(-0.10412163),       /* sin(1007*π/512) */
    Q_2_14(-0.09801714),       /* sin(1008*π/512) */
    Q_2_14(-0.09190896),       /* sin(1009*π/512) */
    Q_2_14(-0.08579731),       /* sin(1010*π/512) */
    Q_2_14(-0.07968244),       /* sin(1011*π/512) */
    Q_2_14(-0.07356456),       /* sin(1012*π/512) */
    Q_2_14(-0.06744392),       /* sin(1013*π/512) */
    Q_2_14(-0.06132074),       /* sin(1014*π/512) */
    Q_2_14(-0.05519524),       /* sin(1015*π/512) */
    Q_2_14(-0.04906767),       /* sin(1016*π/512) */
    Q_2_14(-0.04293826),       /* sin(1017*π/512) */
    Q_2_14(-0.03680722),       /* sin(1018*π/512) */
    Q_2_14(-0.03067480),       /* sin(1019*π/512) */
    Q_2_14(-0.02454123),       /* sin(1020*π/512) */
    Q_2_14(-0.01840673),       /* sin(1021*π/512) */
    Q_2_14(-0.01227154),       /* sin(1022*π/512) */
    Q_2_14(-0.00613588),       /* sin(1023*π/512) */
    Q_2_14(0),                 /* sin(1024*π/512) */
    Q_2_14(0.00613588),        /* sin(1025*π/512) */
    Q_2_14(0.01227154),        /* sin(1026*π/512) */
    Q_2_14(0.01840673),        /* sin(1027*π/512) */
    Q_2_14(0.02454123),        /* sin(1028*π/512) */
    Q_2_14(0.03067480),        /* sin(1029*π/512) */
    Q_2_14(0.03680722),        /* sin(1030*π/512) */
    Q_2_14(0.04293826),        /* sin(1031*π/512) */
    Q_2_14(0.04906767),        /* sin(1032*π/512) */
    Q_2_14(0.05519524),        /* sin(1033*π/512) */
    Q_2_14(0.06132074),        /* sin(1034*π/512) */
    Q_2_14(0.06744392),        /* sin(1035*π/512) */
    Q_2_14(0.07356456),        /* sin(1036*π/512) */
    Q_2_14(0.07968244),        /* sin(1037*π/512) */
    Q_2_14(0.08579731),        /* sin(1038*π/512) */
    Q_2_14(0.09190896),        /* sin(1039*π/512) */
    Q_2_14(0.09801714),        /* sin(1040*π/512) */
    Q_2_14(0.10412163),        /* sin(1041*π/512) */
    Q_2_14(0.11022221),        /* sin(1042*π/512) */
    Q_2_14(0.11631863),        /* sin(1043*π/512) */
    Q_2_14(0.12241068),        /* sin(1044*π/512) */
    Q_2_14(0.12849811),        /* sin(1045*π/512) */
    Q_2_14(0.13458071),        /* sin(1046*π/512) */
    Q_2_14(0.14065824),        /* sin(1047*π/512) */
    Q_2_14(0.14673047),        /* sin(1048*π/512) */
    Q_2_14(0.15279719),        /* sin(1049*π/512) */
    Q_2_14(0.15885814),        /* sin(1050*π/512) */
    Q_2_14(0.16491312),        /* sin(1051*π/512) */
    Q_2_14(0.17096189),        /* sin(1052*π/512) */
    Q_2_14(0.17700422),        /* sin(1053*π/512) */
    Q_2_14(0.18303989),        /* sin(1054*π/512) */
    Q_2_14(0.18906866),        /* sin(1055*π/512) */
    Q_2_14(0.19509032),        /* sin(1056*π/512) */
    Q_2_14(0.20110463),        /* sin(1057*π/512) */
    Q_2_14(0.20711138),        /* sin(1058*π/512) */
    Q_2_14(0.21311032),        /* sin(1059*π/512) */
    Q_2_14(0.21910124),        /* sin(1060*π/512) */
    Q_2_14(0.22508391),        /* sin(1061*π/512) */
    Q_2_14(0.23105811),        /* sin(1062*π/512) */
    Q_2_14(0.23702361),        /* sin(1063*π/512) */
    Q_2_14(0.24298018),        /* sin(1064*π/512) */
    Q_2_14(0.24892761),        /* sin(1065*π/512) */
    Q_2_14(0.25486566),        /* sin(1066*π/512) */
    Q_2_14(0.26079412),        /* sin(1067*π/512) */
    Q_2_14(0.26671276),        /* sin(1068*π/512) */
    Q_2_14(0.27262136),        /* sin(1069*π/512) */
    Q_2_14(0.27851969),        /* sin(1070*π/512) */
    Q_2_14(0.28440754),        /* sin(1071*π/512) */
    Q_2_14(0.29028468),        /* sin(1072*π/512) */
    Q_2_14(0.29615089),        /* sin(1073*π/512) */
    Q_2_14(0.30200595),        /* sin(1074*π/512) */
    Q_2_14(0.30784964),        /* sin(1075*π/512) */
    Q_2_14(0.31368174),        /* sin(1076*π/512) */
    Q_2_14(0.31950203),        /* sin(1077*π/512) */
    Q_2_14(0.32531029),        /* sin(1078*π/512) */
    Q_2_14(0.33110631),        /* sin(1079*π/512) */
    Q_2_14(0.33688985),        /* sin(1080*π/512) */
    Q_2_14(0.34266072),        /* sin(1081*π/512) */
    Q_2_14(0.34841868),        /* sin(1082*π/512) */
    Q_2_14(0.35416353),        /* sin(1083*π/512) */
    Q_2_14(0.35989504),        /* sin(1084*π/512) */
    Q_2_14(0.36561300),        /* sin(1085*π/512) */
    Q_2_14(0.37131719),        /* sin(1086*π/512) */
    Q_2_14(0.37700741),        /* sin(1087*π/512) */
    Q_2_14(0.38268343),        /* sin(1088*π/512) */
    Q_2_14(0.38834505),        /* sin(1089*π/512) */
    Q_2_14(0.39399204),        /* sin(1090*π/512) */
    Q_2_14(0.39962420),        /* sin(1091*π/512) */
    Q_2_14(0.40524131),        /* sin(1092*π/512) */
    Q_2_14(0.41084317),        /* sin(1093*π/512) */
    Q_2_14(0.41642956),        /* sin(1094*π/512) */
    Q_2_14(0.42200027),        /* sin(1095*π/512) */
    Q_2_14(0.42755509),        /* sin(1096*π/512) */
    Q_2_14(0.43309382),        /* sin(1097*π/512) */
    Q_2_14(0.43861624),        /* sin(1098*π/512) */
    Q_2_14(0.44412214),        /* sin(1099*π/512) */
    Q_2_14(0.44961133),        /* sin(1100*π/512) */
    Q_2_14(0.45508359),        /* sin(1101*π/512) */
    Q_2_14(0.46053871),        /* sin(1102*π/512) */
    Q_2_14(0.46597650),        /* sin(1103*π/512) */
    Q_2_14(0.47139674),        /* sin(1104*π/512) */
    Q_2_14(0.47679923),        /* sin(1105*π/512) */
    Q_2_14(0.48218377),        /* sin(1106*π/512) */
    Q_2_14(0.48755016),        /* sin(1107*π/512) */
    Q_2_14(0.49289819),        /* sin(1108*π/512) */
    Q_2_14(0.49822767),        /* sin(1109*π/512) */
    Q_2_14(0.50353838),        /* sin(1110*π/512) */
    Q_2_14(0.50883014),        /* sin(1111*π/512) */
    Q_2_14(0.51410274),        /* sin(1112*π/512) */
    Q_2_14(0.51935599),        /* sin(1113*π/512) */
    Q_2_14(0.52458968),        /* sin(1114*π/512) */
    Q_2_14(0.52980362),        /* sin(1115*π/512) */
    Q_2_14(0.53499762),        /* sin(1116*π/512) */
    Q_2_14(0.54017147),        /* sin(1117*π/512) */
    Q_2_14(0.54532499),        /* sin(1118*π/512) */
    Q_2_14(0.55045797),        /* sin(1119*π/512) */
    Q_2_14(0.55557023),        /* sin(1120*π/512) */
    Q_2_14(0.56066158),        /* sin(1121*π/512) */
    Q_2_14(0.56573181),        /* sin(1122*π/512) */
    Q_2_14(0.57078075),        /* sin(1123*π/512) */
    Q_2_14(0.57580819),        /* sin(1124*π/512) */
    Q_2_14(0.58081396),        /* sin(1125*π/512) */
    Q_2_14(0.58579786),        /* sin(1126*π/512) */
    Q_2_14(0.59075970),        /* sin(1127*π/512) */
    Q_2_14(0.59569930),        /* sin(1128*π/512) */
    Q_2_14(0.60061648),        /* sin(1129*π/512) */
    Q_2_14(0.60551104),        /* sin(1130*π/512) */
    Q_2_14(0.61038281),        /* sin(1131*π/512) */
    Q_2_14(0.61523159),        /* sin(1132*π/512) */
    Q_2_14(0.62005721),        /* sin(1133*π/512) */
    Q_2_14(0.62485949),        /* sin(1134*π/512) */
    Q_2_14(0.62963824),        /* sin(1135*π/512) */
    Q_2_14(0.63439328),        /* sin(1136*π/512) */
    Q_2_14(0.63912444),        /* sin(1137*π/512) */
    Q_2_14(0.64383154),        /* sin(1138*π/512) */
    Q_2_14(0.64851440),        /* sin(1139*π/512) */
    Q_2_14(0.65317284),        /* sin(1140*π/512) */
    Q_2_14(0.65780669),        /* sin(1141*π/512) */
    Q_2_14(0.66241578),        /* sin(1142*π/512) */
    Q_2_14(0.66699992),        /* sin(1143*π/512) */
    Q_2_14(0.67155895),        /* sin(1144*π/512) */
    Q_2_14(0.67609270),        /* sin(1145*π/512) */
    Q_2_14(0.68060100),        /* sin(1146*π/512) */
    Q_2_14(0.68508367),        /* sin(1147*π/512) */
    Q_2_14(0.68954054),        /* sin(1148*π/512) */
    Q_2_14(0.69397146),        /* sin(1149*π/512) */
    Q_2_14(0.69837625),        /* sin(1150*π/512) */
    Q_2_14(0.70275474),        /* sin(1151*π/512) */
    Q_2_14(0.70710678),        /* sin(1152*π/512) */
    Q_2_14(0.71143220),        /* sin(1153*π/512) */
    Q_2_14(0.71573083),        /* sin(1154*π/512) */
    Q_2_14(0.72000251),        /* sin(1155*π/512) */
    Q_2_14(0.72424708),        /* sin(1156*π/512) */
    Q_2_14(0.72846439),        /* sin(1157*π/512) */
    Q_2_14(0.73265427),        /* sin(1158*π/512) */
    Q_2_14(0.73681657),        /* sin(1159*π/512) */
    Q_2_14(0.74095113),        /* sin(1160*π/512) */
    Q_2_14(0.74505779),        /* sin(1161*π/512) */
    Q_2_14(0.74913639),        /* sin(1162*π/512) */
    Q_2_14(0.75318680),        /* sin(1163*π/512) */
    Q_2_14(0.75720885),        /* sin(1164*π/512) */
    Q_2_14(0.76120239),        /* sin(1165*π/512) */
    Q_2_14(0.76516727),        /* sin(1166*π/512) */
    Q_2_14(0.76910334),        /* sin(1167*π/512) */
    Q_2_14(0.77301045),        /* sin(1168*π/512) */
    Q_2_14(0.77688847),        /* sin(1169*π/512) */
    Q_2_14(0.78073723),        /* sin(1170*π/512) */
    Q_2_14(0.78455660),        /* sin(1171*π/512) */
    Q_2_14(0.78834643),        /* sin(1172*π/512) */
    Q_2_14(0.79210658),        /* sin(1173*π/512) */
    Q_2_14(0.79583690),        /* sin(1174*π/512) */
    Q_2_14(0.79953727),        /* sin(1175*π/512) */
    Q_2_14(0.80320753),        /* sin(1176*π/512) */
    Q_2_14(0.80684755),        /* sin(1177*π/512) */
    Q_2_14(0.81045720),        /* sin(1178*π/512) */
    Q_2_14(0.81403633),        /* sin(1179*π/512) */
    Q_2_14(0.81758481),        /* sin(1180*π/512) */
    Q_2_14(0.82110251),        /* sin(1181*π/512) */
    Q_2_14(0.82458930),        /* sin(1182*π/512) */
    Q_2_14(0.82804505),        /* sin(1183*π/512) */
    Q_2_14(0.83146961),        /* sin(1184*π/512) */
    Q_2_14(0.83486287),        /* sin(1185*π/512) */
    Q_2_14(0.83822471),        /* sin(1186*π/512) */
    Q_2_14(0.84155498),        /* sin(1187*π/512) */
    Q_2_14(0.84485357),        /* sin(1188*π/512) */
    Q_2_14(0.84812034),        /* sin(1189*π/512) */
    Q_2_14(0.85135519),        /* sin(1190*π/512) */
    Q_2_14(0.85455799),        /* sin(1191*π/512) */
    Q_2_14(0.85772861),        /* sin(1192*π/512) */
    Q_2_14(0.86086694),        /* sin(1193*π/512) */
    Q_2_14(0.86397286),        /* sin(1194*π/512) */
    Q_2_14(0.86704625),        /* sin(1195*π/512) */
    Q_2_14(0.87008699),        /* sin(1196*π/512) */
    Q_2_14(0.87309498),        /* sin(1197*π/512) */
    Q_2_14(0.87607009),        /* sin(1198*π/512) */
    Q_2_14(0.87901223),        /* sin(1199*π/512) */
    Q_2_14(0.88192126),        /* sin(1200*π/512) */
    Q_2_14(0.88479710),        /* sin(1201*π/512) */
    Q_2_14(0.88763962),        /* sin(1202*π/512) */
    Q_2_14(0.89044872),        /* sin(1203*π/512) */
    Q_2_14(0.89322430),        /* sin(1204*π/512) */
    Q_2_14(0.89596625),        /* sin(1205*π/512) */
    Q_2_14(0.89867447),        /* sin(1206*π/512) */
    Q_2_14(0.90134885),        /* sin(1207*π/512) */
    Q_2_14(0.90398929),        /* sin(1208*π/512) */
    Q_2_14(0.90659570),        /* sin(1209*π/512) */
    Q_2_14(0.90916798),        /* sin(1210*π/512) */
    Q_2_14(0.91170603),        /* sin(1211*π/512) */
    Q_2_14(0.91420976),        /* sin(1212*π/512) */
    Q_2_14(0.91667906),        /* sin(1213*π/512) */
    Q_2_14(0.91911385),        /* sin(1214*π/512) */
    Q_2_14(0.92151404),        /* sin(1215*π/512) */
    Q_2_14(0.92387953),        /* sin(1216*π/512) */
    Q_2_14(0.92621024),        /* sin(1217*π/512) */
    Q_2_14(0.92850608),        /* sin(1218*π/512) */
    Q_2_14(0.93076696),        /* sin(1219*π/512) */
    Q_2_14(0.93299280),        /* sin(1220*π/512) */
    Q_2_14(0.93518351),        /* sin(1221*π/512) */
    Q_2_14(0.93733901),        /* sin(1222*π/512) */
    Q_2_14(0.93945922),        /* sin(1223*π/512) */
    Q_2_14(0.94154407),        /* sin(1224*π/512) */
    Q_2_14(0.94359346),        /* sin(1225*π/512) */
    Q_2_14(0.94560733),        /* sin(1226*π/512) */
    Q_2_14(0.94758559),        /* sin(1227*π/512) */
    Q_2_14(0.94952818),        /* sin(1228*π/512) */
    Q_2_14(0.95143502),        /* sin(1229*π/512) */
    Q_2_14(0.95330604),        /* sin(1230*π/512) */
    Q_2_14(0.95514117),        /* sin(1231*π/512) */
    Q_2_14(0.95694034),        /* sin(1232*π/512) */
    Q_2_14(0.95870347),        /* sin(1233*π/512) */
    Q_2_14(0.96043052),        /* sin(1234*π/512) */
    Q_2_14(0.96212140),        /* sin(1235*π/512) */
    Q_2_14(0.96377607),        /* sin(1236*π/512) */
    Q_2_14(0.96539444),        /* sin(1237*π/512) */
    Q_2_14(0.96697647),        /* sin(1238*π/512) */
    Q_2_14(0.96852209),        /* sin(1239*π/512) */
    Q_2_14(0.97003125),        /* sin(1240*π/512) */
    Q_2_14(0.97150389),        /* sin(1241*π/512) */
    Q_2_14(0.97293995),        /* sin(1242*π/512) */
    Q_2_14(0.97433938),        /* sin(1243*π/512) */
    Q_2_14(0.97570213),        /* sin(1244*π/512) */
    Q_2_14(0.97702814),        /* sin(1245*π/512) */
    Q_2_14(0.97831737),        /* sin(1246*π/512) */
    Q_2_14(0.97956977),        /* sin(1247*π/512) */
    Q_2_14(0.98078528),        /* sin(1248*π/512) */
    Q_2_14(0.98196387),        /* sin(1249*π/512) */
    Q_2_14(0.98310549),        /* sin(1250*π/512) */
    Q_2_14(0.98421009),        /* sin(1251*π/512) */
    Q_2_14(0.98527764),        /* sin(1252*π/512) */
    Q_2_14(0.98630810),        /* sin(1253*π/512) */
    Q_2_14(0.98730142),        /* sin(1254*π/512) */
    Q_2_14(0.98825757),        /* sin(1255*π/512) */
    Q_2_14(0.98917651),        /* sin(1256*π/512) */
    Q_2_14(0.99005821),        /* sin(1257*π/512) */
    Q_2_14(0.99090264),        /* sin(1258*π/512) */
    Q_2_14(0.99170975),        /* sin(1259*π/512) */
    Q_2_14(0.99247953),        /* sin(1260*π/512) */
    Q_2_14(0.99321195),        /* sin(1261*π/512) */
    Q_2_14(0.99390697),        /* sin(1262*π/512) */
    Q_2_14(0.99456457),        /* sin(1263*π/512) */
    Q_2_14(0.99518473),        /* sin(1264*π/512) */
    Q_2_14(0.99576741),        /* sin(1265*π/512) */
    Q_2_14(0.99631261),        /* sin(1266*π/512) */
    Q_2_14(0.99682030),        /* sin(1267*π/512) */
    Q_2_14(0.99729046),        /* sin(1268*π/512) */
    Q_2_14(0.99772307),        /* sin(1269*π/512) */
    Q_2_14(0.99811811),        /* sin(1270*π/512) */
    Q_2_14(0.99847558),        /* sin(1271*π/512) */
    Q_2_14(0.99879546),        /* sin(1272*π/512) */
    Q_2_14(0.99907773),        /* sin(1273*π/512) */
    Q_2_14(0.99932238),        /* sin(1274*π/512) */
    Q_2_14(0.99952942),        /* sin(1275*π/512) */
    Q_2_14(0.99969882),        /* sin(1276*π/512) */
    Q_2_14(0.99983058),        /* sin(1277*π/512) */
    Q_2_14(0.99992470),        /* sin(1278*π/512) */
    Q_2_14(0.99998118),        /* sin(1279*π/512) */
};
