#include "subgames.h"
#include "subgame_menu.h"
#include "task.h"
#include "pause_fade.h"
#include "palette.h"
#include "random.h"
#include "functions.h"
#include "constants/languages.h"

static void sub_08128DB0(void);
static void sub_08128E8C(void);

// apply a set of tilesets during animation (?)
static struct Task *sub_08128D48(const struct Unk_08128D48_0 *a1) {
    struct Task *t = TaskCreate(sub_08128DB0, sizeof(struct Unk_08128D48), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_08128D48 *var = TaskGetStructPtr(t);

    var->frames = a1->frames;
    var->dstVram = VRAM + a1->dstVramOffset;
    var->numFrames = a1->numFrames;
    var->sizeTiles = 0x20 * a1->numTiles;
    var->currentTilesetIndex = 0;
    var->delayCounter = 0xFF;
    return t;
}

static void sub_08128DB0(void) {
    struct Unk_08128D48 *var = TaskGetStructPtr(gCurTask);
    const struct Unk_08128D48_0_4 *p = &var->frames[var->currentTilesetIndex];

    if (var->delayCounter < p->delay)
        ++var->delayCounter;
    else {
        ++var->currentTilesetIndex;
        var->delayCounter = 0;
        if (var->currentTilesetIndex >= var->numFrames)
            var->currentTilesetIndex = 0;
        ++var; --var;
        p = &var->frames[var->currentTilesetIndex];
        CpuCopy32((void *)VRAM + p->srcVramOffset, (void *)var->dstVram, var->sizeTiles);
    }
}

// apply a set of palettes during animation (?)
static struct Task *sub_08128E28(const struct Unk_08128E28_0 *a1) {
    struct Task *t = TaskCreate(sub_08128E8C, sizeof(struct Unk_08128E28), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_08128E28 *var = TaskGetStructPtr(t);

    var->data = a1->data;
    var->currentDataOffset = 0;
    var->paletteOffset = a1->paletteOffset;
    var->paletteSize = a1->paletteSize;
    var->numPalettes = a1->numPalettes;
    var->currentPaletteIndex = 0;
    var->delayCounter = 0xFF;
    return t;
}

static void sub_08128E8C(void) {
    struct Unk_08128E28 *var = TaskGetStructPtr(gCurTask);
    const u16 *p = &var->data[var->currentDataOffset];

    if (var->delayCounter < p[0])
        ++var->delayCounter;
    else {
        ++var->currentPaletteIndex;
        var->delayCounter = 0;
        var->currentDataOffset += var->paletteSize + 1;
        if (var->currentPaletteIndex >= var->numPalettes) {
            var->currentPaletteIndex = 0;
            var->currentDataOffset = 0;
        }
        ++var; --var;
        p = &var->data[var->currentDataOffset];
        if (gMainFlags & MAIN_FLAG_BG_PALETTE_TRANSFORMATION_ENABLE)
            LoadBgPaletteWithTransformation(p+1, var->paletteOffset, var->paletteSize);
        else {
            DmaCopy16(3, p+1, gBgPalette + var->paletteOffset, var->paletteSize * sizeof(u16));
            gMainFlags |= MAIN_FLAG_BG_PALETTE_SYNC_ENABLE;
        }
    }
}

static void sub_081295A0(void);
static void sub_081297F8(struct Unk_08128F44 *);
static void sub_081298B4(void);
static void sub_08129A6C(void);
static void sub_08129C34(void);
static void sub_08129F28(void);
static void sub_0812A344(s32 *, struct Unk_08128F44_4 *);
static s32 *sub_0812A388(struct Unk_08128F44_4 *);
static void sub_0812A39C(void);
static void sub_0812A8F0(void);
static void sub_0812AAE0(struct Unk_0812A77C *);
static void sub_0812B204(void);
static void sub_0812B2F8(void);
static void sub_0812B418(void);
static void sub_0812B63C(void);
static void sub_0812BEE0(void);
static void sub_0812C168(struct Unk_0812A77C *);
static void sub_0812C29C(void);
static void sub_0812C490(struct Unk_0812A77C *);
static void sub_0812C528(struct Unk_0812A77C_40 *, u8);
static void sub_0812C63C(void);
static void sub_0812C814(void);
static void sub_0812CA84(void);
static void sub_0812CBDC(void);
static void sub_0812CDD4(struct Unk_0812A77C *);
static void sub_0812CED8(struct Unk_0812A77C_40 *, u8);
static void sub_0812CF80(struct Unk_0812A77C_40 *, struct Unk_0812A77C *);
static void sub_0812D060(void);
static void sub_0812D124(s16, s16, struct Unk_0812A77C_40 *);
static struct Task *sub_0812D1EC(struct Unk_0812A77C_40 *, u8);
static void sub_0812D3AC(void);
static struct Task *sub_0812D4F4(void);
static void sub_0812D988(void);
static void sub_0812DB2C(void);
static struct Task *sub_0812DBB4(s16, s16, s16, s16, bool8);
static void sub_0812DC90(void);
static void sub_0812DF14(void);
static void CrackityHackDrawCracks(void);
static void sub_0812E0C8(u16, u16, u8);
static void sub_0812E194(u16, u16, s16);
static void sub_0812E468(struct Unk_0812A77C *);
static void sub_0812E51C(void);
static void sub_0812E588(struct Task *);
static void sub_0812E604(struct Unk_0812A77C_40 *);
static void sub_0812E640(void);
static void nullsub_31(struct Task *);
static bool32 sub_0812E6A8(struct Unk_0812D4F4 *);
static bool32 sub_0812E6C8(struct Unk_0812DBB4 *);
static void nullsub_32(struct Task *);
static void sub_0812E6E4(u8);
static void sub_0812E764(struct Sprite *, u8);
static void sub_0812E7A0(void);
static void sub_0812E818(struct Unk_0812A77C_40 *);
static void sub_0812E9CC(void);
static void sub_0812EC54(void);
static void sub_0812ED78(s32);
static void sub_0812EF3C(void);
static struct Task *sub_0812EFB4(void);
static struct Task *sub_0812EFFC(u32, u8);
static void sub_0812F070(void);

static const u8 gUnk_08363AA0[][3] = {
    {  0x0,  0x1,  0x2 },
    {  0x1,  0x2,  0x0 },
    {  0x2,  0x0,  0x1 },
    {  0x0,  0x0,  0x0 },
    { 0x46, 0x1A, 0xFF },
    { 0x7F, 0x40, 0x7D },
    { 0xB8,  0x1, 0xFE },
    {  0x2, 0xBF,  0x8 },
    { 0x5F,  0x2,  0x0 },
    {  0x0, 0x9F, 0x6E },
    { 0xD2,  0x0, 0xA0 },
    { 0x7F, 0x96, 0x1C },
    { 0x3B, 0x39, 0x62 },
    { 0x12, 0x80, 0x7E },
    { 0xFF,  0x3,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x11,  0x2,  0x0 },
    { 0x11, 0x11,  0x2 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0, 0x21,  0x0 },
    {  0x0, 0x10,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    {  0x2,  0x0, 0x10 },
    { 0x12, 0x12,  0x2 },
    {  0x0, 0x11, 0x21 },
    {  0x0, 0x10, 0x12 },
    { 0x12,  0x2,  0x0 },
    { 0x10,  0x2,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0, 0x10, 0x11 },
    { 0x11, 0x21, 0x10 },
    { 0x11, 0x11, 0x21 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0, 0x21 },
    {  0x0,  0x0, 0x10 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    { 0x11, 0x11, 0x21 },
    { 0x10, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x21 },
    {  0x0,  0x0, 0x10 },
    {  0x2,  0x0,  0x0 },
    { 0x21,  0x0,  0x0 },
    { 0x10,  0x2,  0x0 },
    {  0x0, 0x21,  0x0 },
    {  0x0, 0x10,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21, 0x10, 0x21 },
    {  0x0, 0x11, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x11 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0, 0x11 },
    { 0x11, 0x21, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    { 0x10, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    { 0x10, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    {  0x2, 0x21,  0x0 },
    { 0x10,  0x2, 0x11 },
    {  0x2, 0x10,  0x2 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x11 },
    { 0x11, 0x21, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21, 0x10, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    {  0x2, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x11, 0x11,  0x2 },
    { 0x10, 0x21, 0x10 },
    { 0x21, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21, 0x10, 0x21 },
    {  0x0, 0x11, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0,  0x0 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21,  0x0, 0x11 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21,  0x0, 0x11 },
    { 0x11,  0x2,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21, 0x10, 0x21 },
    { 0x10, 0x21, 0x10 },
    { 0x21,  0x0, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0, 0x11, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0, 0x21 },
    {  0x0,  0x0, 0x10 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x11 },
    { 0x11,  0x2,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11,  0x2 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    { 0x12, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x21, 0x10 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x11, 0x11,  0x2 },
    { 0x11, 0x11, 0x21 },
    {  0x0, 0x11, 0x11 },
    { 0x11,  0x2, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x21, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11, 0x12, 0x12 },
    { 0x21, 0x11, 0x12 },
    { 0x12, 0x21, 0x11 },
    { 0x12, 0x12, 0x21 },
    { 0x11, 0x12, 0x12 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x21 },
    { 0x10, 0x21, 0x11 },
    { 0x21, 0x10, 0x21 },
    { 0x11, 0x12, 0x12 },
    { 0x21, 0x11,  0x2 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    { 0x12, 0x11, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x10 },
    { 0x11, 0x11,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    {  0x0, 0x11, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x12 },
    { 0x12, 0x21, 0x11 },
    { 0x12, 0x12, 0x21 },
    { 0x11, 0x12, 0x12 },
    { 0x21, 0x11, 0x12 },
    { 0x12, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x21, 0x10, 0x11 },
    { 0x11,  0x2,  0x0 },
    { 0x11, 0x21,  0x0 },
    { 0x10, 0x11, 0x11 },
    {  0x2, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x10, 0x11, 0x11 },
    {  0x2, 0x10, 0x11 },
    { 0x11,  0x2,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    { 0x10, 0x11,  0x2 },
    {  0x0, 0x11, 0x21 },
    {  0x0, 0x10, 0x11 },
    {  0x2,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0, 0x10, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10,  0x2,  0x0 },
    {  0x0, 0x11, 0x21 },
    {  0x0, 0x10, 0x21 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11,  0x2 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    {  0x2, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11, 0x12, 0x11 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x21 },
    { 0x10, 0x21, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x11, 0x11 },
    {  0x2, 0x11, 0x11 },
    { 0x21,  0x0, 0x11 },
    { 0x11, 0x11,  0x2 },
    { 0x11, 0x21, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11, 0x12 },
    { 0x12, 0x21, 0x11 },
    { 0x12, 0x12, 0x21 },
    { 0x11, 0x12, 0x12 },
    { 0x21, 0x11, 0x12 },
    { 0x12, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x21, 0x10, 0x21 },
    { 0x11, 0x21, 0x10 },
    { 0x21, 0x11, 0x12 },
    { 0x12, 0x21, 0x11 },
    {  0x2, 0x11, 0x21 },
    { 0x11,  0x2, 0x11 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11, 0x12, 0x11 },
    { 0x21, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11, 0x11, 0x11 },
    {  0x2, 0x11,  0x2 },
    { 0x11,  0x2, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x11, 0x11, 0x21 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2, 0x10, 0x21 },
    { 0x10, 0x11, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x21, 0x10, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    {  0x2,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11,  0x2 },
    { 0x10, 0x21, 0x11 },
    { 0x12, 0x12, 0x21 },
    { 0x11, 0x12, 0x12 },
    { 0x21, 0x11, 0x12 },
    { 0x12, 0x21, 0x11 },
    { 0x12, 0x12, 0x21 },
    { 0x11, 0x11, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x11,  0x2, 0x10 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x21, 0x10 },
    { 0x11, 0x11,  0x2 },
    {  0x0, 0x11, 0x21 },
    {  0x0, 0x10, 0x11 },
    { 0x11,  0x2, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x11,  0x2, 0x10 },
    { 0x21,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    { 0x21, 0x11, 0x21 },
    { 0x11, 0x21, 0x11 },
    { 0x21, 0x10, 0x11 },
    { 0x11,  0x2, 0x10 },
    { 0x11, 0x11,  0x2 },
    {  0x0, 0x11, 0x21 },
    {  0x0,  0x0, 0x11 },
    { 0x21,  0x0,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11, 0x21 },
    {  0x0, 0x10, 0x11 },
    {  0x2,  0x0, 0x11 },
    { 0x21,  0x0, 0x10 },
    { 0x11,  0x2,  0x0 },
    { 0x11, 0x21,  0x0 },
    {  0x0, 0x11, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x11,  0x2 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x10 },
    { 0x21,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0,  0x0 },
    { 0x11,  0x2,  0x0 },
    { 0x10, 0x21,  0x0 },
    {  0x0, 0x10, 0x21 },
    {  0x0,  0x0, 0x11 },
    {  0x2,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    { 0x10, 0x11, 0x11 },
    { 0x21, 0x10, 0x11 },
    { 0x11, 0x21,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0 },
};

static const struct Unk_02021590 gUnk_08364ACC[][6] = {
    [LANGUAGE_JAPANESE] = {
        { 0x343, 0xE, 0x0 },
        { 0x343, 0xD, 0x0 },
        { 0x343, 0xC, 0x0 },
        { 0x343, 0x9, 0x0 },
        { 0x343, 0xA, 0x0 },
        { 0x343, 0xB, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x343, 0xE, 0x0 },
        { 0x343, 0xD, 0x0 },
        { 0x343, 0xC, 0x0 },
        { 0x343, 0x9, 0x0 },
        { 0x343, 0xA, 0x0 },
        { 0x343, 0xB, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x343, 0xE, 0x0 },
        { 0x343, 0xD, 0x0 },
        { 0x343, 0xC, 0x0 },
        { 0x343, 0x9, 0x0 },
        { 0x343, 0xA, 0x0 },
        { 0x343, 0xB, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x343, 0xE, 0x0 },
        { 0x343, 0xD, 0x0 },
        { 0x343, 0xC, 0x0 },
        { 0x343, 0x9, 0x0 },
        { 0x343, 0xA, 0x0 },
        { 0x343, 0xB, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x343, 0xE, 0x0 },
        { 0x343, 0xD, 0x0 },
        { 0x343, 0xC, 0x0 },
        { 0x343, 0x9, 0x0 },
        { 0x343, 0xA, 0x0 },
        { 0x343, 0xB, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x343, 0xE, 0x0 },
        { 0x343, 0xD, 0x0 },
        { 0x343, 0xC, 0x0 },
        { 0x343, 0x9, 0x0 },
        { 0x343, 0xA, 0x0 },
        { 0x343, 0xB, 0x0 },
    },
};

static const s8 gUnk_08364B5C[][60] = {
    [0] = {
        0x0, 0x0, 0x0, 0x0, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
        0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x4, 0x4, 0x4, 0x4,
        0x4, 0x4, 0x4, 0x4, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
        0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
        0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0,
        0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    },
    [1] = {
        0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x6, 0x6, 0x6, 0x6,
        0x6, 0x6, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,
        0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
        0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
        0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
        0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    },
    [2] = {
        0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
        0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x8, 0x8, 0x8, 0x8,
        0x8, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x4, 0x4, 0x4,
        0x4, 0x4, 0x4, 0x4, 0x4, 0x2, 0x2, 0x2, 0x2, 0x2,
        0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1,
        0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0,
    },
    [3] = {
        0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
        0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x6, 0x6, 0x6, 0x6,
        0x6, 0x6, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,
        0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
        0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
        0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    },
};

static const s8 gUnk_08364C4C[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x8, 0x8, 0x8, 0x8,
    0x8, 0x8, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,
    0x4, 0x4, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
};

static const s8 gUnk_08364C88[] = {
    0x3, 0x4, 0x4, 0x4, 0x8, 0x8,  0x8,  0x8, 0xA,
    0xA, 0xC, 0xC, 0xE, 0xE, 0xE, 0x10, 0x10, 0x0, // TODO: padding?
};

static const s16 gUnk_08364C9A[][6] = {
    {  0x78, 0x1A0,  0x78, 0x1C0,  0x78, 0x248 },
    { 0x168, 0x180, 0x168, 0x1A0, 0x168, 0x228 },
    { 0x258, 0x180, 0x258, 0x1A0, 0x258, 0x228 },
    { 0x348, 0x1A0, 0x348, 0x1C0, 0x348, 0x248 },
};

static const s8 gUnk_08364CCA[] = {
    -4, 1, 3, -2, 4, -1, -5, 3
};

static const u8 gUnk_08364CD2[][4] = {
    { 0x0, 0x1, 0x2, 0x3 },
    { 0x1, 0x2, 0x3, 0x0 },
    { 0x2, 0x3, 0x0, 0x1 },
    { 0x3, 0x0, 0x1, 0x2 },
};

static const struct Unk_02021590 gUnk_08364CE4[][7] = {
    [LANGUAGE_JAPANESE] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0x1, 0x0 },
        { 0x344, 0x2, 0x0 },
        { 0x344, 0x3, 0x0 },
        { 0x344, 0x4, 0x0 },
        { 0x344, 0x5, 0x0 },
        { 0x344, 0x6, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0x1, 0x0 },
        { 0x344, 0x2, 0x0 },
        { 0x344, 0x3, 0x0 },
        { 0x344, 0x4, 0x0 },
        { 0x344, 0x5, 0x0 },
        { 0x344, 0x6, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0x1, 0x0 },
        { 0x344, 0x2, 0x0 },
        { 0x344, 0x3, 0x0 },
        { 0x344, 0x4, 0x0 },
        { 0x344, 0x5, 0x0 },
        { 0x344, 0x6, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0x1, 0x0 },
        { 0x344, 0x2, 0x0 },
        { 0x344, 0x3, 0x0 },
        { 0x344, 0x4, 0x0 },
        { 0x344, 0x5, 0x0 },
        { 0x344, 0x6, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0x1, 0x0 },
        { 0x344, 0x2, 0x0 },
        { 0x344, 0x3, 0x0 },
        { 0x344, 0x4, 0x0 },
        { 0x344, 0x5, 0x0 },
        { 0x344, 0x6, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0x1, 0x0 },
        { 0x344, 0x2, 0x0 },
        { 0x344, 0x3, 0x0 },
        { 0x344, 0x4, 0x0 },
        { 0x344, 0x5, 0x0 },
        { 0x344, 0x6, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_08364D8C[][6] = {
    [LANGUAGE_JAPANESE] = {
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x8, 0x0 },
        { 0x344, 0x9, 0x0 },
        { 0x344, 0xA, 0x0 },
        { 0x344, 0xB, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x8, 0x0 },
        { 0x344, 0x9, 0x0 },
        { 0x344, 0xA, 0x0 },
        { 0x344, 0xB, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x8, 0x0 },
        { 0x344, 0x9, 0x0 },
        { 0x344, 0xA, 0x0 },
        { 0x344, 0xB, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x8, 0x0 },
        { 0x344, 0x9, 0x0 },
        { 0x344, 0xA, 0x0 },
        { 0x344, 0xB, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x8, 0x0 },
        { 0x344, 0x9, 0x0 },
        { 0x344, 0xA, 0x0 },
        { 0x344, 0xB, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x7, 0x0 },
        { 0x344, 0x8, 0x0 },
        { 0x344, 0x9, 0x0 },
        { 0x344, 0xA, 0x0 },
        { 0x344, 0xB, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_08364E1C[][12] = {
    [LANGUAGE_JAPANESE] = {
        { 0x346, 0x0, 0x0 },
        { 0x346, 0x1, 0x0 },
        { 0x346, 0x2, 0x0 },
        { 0x346, 0x3, 0x0 },
        { 0x346, 0x4, 0x0 },
        { 0x346, 0x5, 0x0 },
        { 0x346, 0x6, 0x0 },
        { 0x346, 0x7, 0x0 },
        { 0x346, 0x8, 0x0 },
        { 0x346, 0x9, 0x0 },
        { 0x346, 0xB, 0x0 },
        { 0x346, 0xA, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x346, 0x0, 0x0 },
        { 0x346, 0x1, 0x0 },
        { 0x346, 0x2, 0x0 },
        { 0x346, 0x3, 0x0 },
        { 0x346, 0x4, 0x0 },
        { 0x346, 0x5, 0x0 },
        { 0x346, 0x6, 0x0 },
        { 0x346, 0x7, 0x0 },
        { 0x346, 0x8, 0x0 },
        { 0x346, 0x9, 0x0 },
        { 0x346, 0xB, 0x0 },
        { 0x346, 0xA, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x346, 0x0, 0x0 },
        { 0x346, 0x1, 0x0 },
        { 0x346, 0x2, 0x0 },
        { 0x346, 0x3, 0x0 },
        { 0x346, 0x4, 0x0 },
        { 0x346, 0x5, 0x0 },
        { 0x346, 0x6, 0x0 },
        { 0x346, 0x7, 0x0 },
        { 0x346, 0x8, 0x0 },
        { 0x346, 0x9, 0x0 },
        { 0x346, 0xB, 0x0 },
        { 0x346, 0xA, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x346, 0x0, 0x0 },
        { 0x346, 0x1, 0x0 },
        { 0x346, 0x2, 0x0 },
        { 0x346, 0x3, 0x0 },
        { 0x346, 0x4, 0x0 },
        { 0x346, 0x5, 0x0 },
        { 0x346, 0x6, 0x0 },
        { 0x346, 0x7, 0x0 },
        { 0x346, 0x8, 0x0 },
        { 0x346, 0x9, 0x0 },
        { 0x346, 0xB, 0x0 },
        { 0x346, 0xA, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x346, 0x0, 0x0 },
        { 0x346, 0x1, 0x0 },
        { 0x346, 0x2, 0x0 },
        { 0x346, 0x3, 0x0 },
        { 0x346, 0x4, 0x0 },
        { 0x346, 0x5, 0x0 },
        { 0x346, 0x6, 0x0 },
        { 0x346, 0x7, 0x0 },
        { 0x346, 0x8, 0x0 },
        { 0x346, 0x9, 0x0 },
        { 0x346, 0xB, 0x0 },
        { 0x346, 0xA, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x346, 0x0, 0x0 },
        { 0x346, 0x1, 0x0 },
        { 0x346, 0x2, 0x0 },
        { 0x346, 0x3, 0x0 },
        { 0x346, 0x4, 0x0 },
        { 0x346, 0x5, 0x0 },
        { 0x346, 0x6, 0x0 },
        { 0x346, 0x7, 0x0 },
        { 0x346, 0x8, 0x0 },
        { 0x346, 0x9, 0x0 },
        { 0x346, 0xB, 0x0 },
        { 0x346, 0xA, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_08364F3C[][4] = {
    [LANGUAGE_JAPANESE] = {
        { 0x343, 0x0, 0x0 },
        { 0x343, 0x5, 0x0 },
        { 0x343, 0x6, 0x0 },
        { 0x343, 0x7, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x343, 0x0, 0x0 },
        { 0x343, 0x5, 0x0 },
        { 0x343, 0x6, 0x0 },
        { 0x343, 0x7, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x343, 0x0, 0x0 },
        { 0x343, 0x5, 0x0 },
        { 0x343, 0x6, 0x0 },
        { 0x343, 0x7, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x343, 0x0, 0x0 },
        { 0x343, 0x5, 0x0 },
        { 0x343, 0x6, 0x0 },
        { 0x343, 0x7, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x343, 0x0, 0x0 },
        { 0x343, 0x5, 0x0 },
        { 0x343, 0x6, 0x0 },
        { 0x343, 0x7, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x343, 0x0, 0x0 },
        { 0x343, 0x5, 0x0 },
        { 0x343, 0x6, 0x0 },
        { 0x343, 0x7, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_08364F9C[][2] = {
    [LANGUAGE_JAPANESE] = {
        { 0x345, 0x0, 0x0 },
        { 0x345, 0x1, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x345, 0x0, 0x0 },
        { 0x345, 0x1, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x345, 0x0, 0x0 },
        { 0x345, 0x1, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x345, 0x0, 0x0 },
        { 0x345, 0x1, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x345, 0x0, 0x0 },
        { 0x345, 0x1, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x345, 0x0, 0x0 },
        { 0x345, 0x1, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_08364FCC[] = {
    [LANGUAGE_JAPANESE] = { 0x345, 0x13, 0x0 },
    [LANGUAGE_ENGLISH]  = { 0x345, 0x13, 0x0 },
    [LANGUAGE_GERMAN]   = { 0x345, 0x13, 0x0 },
    [LANGUAGE_FRENCH]   = { 0x345, 0x13, 0x0 },
    [LANGUAGE_SPANISH]  = { 0x345, 0x13, 0x0 },
    [LANGUAGE_ITALIAN]  = { 0x345, 0x13, 0x0 },
};

static const s32 gUnk_08364FE4[] = {
    120, 360, 600, 840
};

static const struct Unk_02021590 gUnk_08364FF4[][4] = {
    [LANGUAGE_JAPANESE] = {
        { 0x346, 0xC, 0x0 },
        { 0x346, 0xD, 0x0 },
        { 0x346, 0xE, 0x0 },
        { 0x346, 0xF, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x346, 0xC, 0x0 },
        { 0x346, 0xD, 0x0 },
        { 0x346, 0xE, 0x0 },
        { 0x346, 0xF, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x346, 0xC, 0x0 },
        { 0x346, 0xD, 0x0 },
        { 0x346, 0xE, 0x0 },
        { 0x346, 0xF, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x346, 0xC, 0x0 },
        { 0x346, 0xD, 0x0 },
        { 0x346, 0xE, 0x0 },
        { 0x346, 0xF, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x346, 0xC, 0x0 },
        { 0x346, 0xD, 0x0 },
        { 0x346, 0xE, 0x0 },
        { 0x346, 0xF, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x346, 0xC, 0x0 },
        { 0x346, 0xD, 0x0 },
        { 0x346, 0xE, 0x0 },
        { 0x346, 0xF, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_08365054[][4] = {
    [LANGUAGE_JAPANESE] = {
        { 0x343, 0x1, 0x0 },
        { 0x343, 0x2, 0x0 },
        { 0x343, 0x3, 0x0 },
        { 0x343, 0x4, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x343, 0x1, 0x0 },
        { 0x343, 0x2, 0x0 },
        { 0x343, 0x3, 0x0 },
        { 0x343, 0x4, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x343, 0x1, 0x0 },
        { 0x343, 0x2, 0x0 },
        { 0x343, 0x3, 0x0 },
        { 0x343, 0x4, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x343, 0x1, 0x0 },
        { 0x343, 0x2, 0x0 },
        { 0x343, 0x3, 0x0 },
        { 0x343, 0x4, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x343, 0x1, 0x0 },
        { 0x343, 0x2, 0x0 },
        { 0x343, 0x3, 0x0 },
        { 0x343, 0x4, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x343, 0x1, 0x0 },
        { 0x343, 0x2, 0x0 },
        { 0x343, 0x3, 0x0 },
        { 0x343, 0x4, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_083650B4[][4] = {
    [LANGUAGE_JAPANESE] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0xC, 0x0 },
        { 0x344, 0xD, 0x0 },
        { 0x344, 0xE, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0xC, 0x0 },
        { 0x344, 0xD, 0x0 },
        { 0x344, 0xE, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0xC, 0x0 },
        { 0x344, 0xD, 0x0 },
        { 0x344, 0xE, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0xC, 0x0 },
        { 0x344, 0xD, 0x0 },
        { 0x344, 0xE, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0xC, 0x0 },
        { 0x344, 0xD, 0x0 },
        { 0x344, 0xE, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x344, 0x0, 0x0 },
        { 0x344, 0xC, 0x0 },
        { 0x344, 0xD, 0x0 },
        { 0x344, 0xE, 0x0 },
    },
};

static const u8 gUnk_08365114[][16] = {
    [0] = { 0xF, 0x10, 0x11, 0x14, 0x28, 0x15, 0x15,  0xA, 0x23, 0x16, 0x16,  0xC, 0x17, 0x17, 0x17, 0x1E },
    [1] = { 0xA, 0x18, 0x19, 0x19, 0x1A, 0x1A, 0x1B, 0x10, 0x1C, 0x1C, 0x1D, 0x1D, 0x1E, 0x28, 0x1F, 0x23 },
    [2] = { 0x5, 0x21, 0x22, 0x22, 0x23, 0x23, 0x24, 0x24, 0x25, 0x25, 0x26, 0x26, 0x27, 0x27, 0x28, 0x28 },
};

static const u16 gUnk_08365144[][4] = {
    [0] = { 0x1, 0x2, 0x1, 0x2 },
    [1] = { 0x2, 0x3, 0x4, 0x3 },
    [2] = { 0x5, 0x4, 0x3, 0x4 },
};

static const u16 gCrackityHackBgPalette[] = {
    RGB(14,  5, 31) | 0x8000, RGB(16, 11,  0) | 0x8000, RGB(20, 12,  0) | 0x8000, RGB(23, 14,  0) | 0x0000, RGB(26, 17,  5) | 0x8000, RGB(29, 20, 10) | 0x8000, RGB(31, 24, 15) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB(24, 17,  0) | 0x8000, RGB(26, 21,  5) | 0x8000, RGB(29, 25, 11) | 0x0000, RGB(31, 29, 17) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(29, 26, 19) | 0x8000, RGB( 0, 31,  0) | 0x8000, RGB( 0,  0,  0) | 0x0000,
    RGB(14,  5, 31) | 0x8000, RGB(19, 20,  5) | 0x8000, RGB(20, 22,  9) | 0x8000, RGB(22, 24, 13) | 0x8000, RGB(24, 27, 18) | 0x0000, RGB(26, 31, 27) | 0x8000, RGB(19, 13, 19) | 0x0000, RGB(20, 15, 23) | 0x8000,
    RGB(22, 17, 27) | 0x8000, RGB(24, 22, 31) | 0x0000, RGB(26, 28, 31) | 0x0000, RGB(31, 14,  0) | 0x8000, RGB(31, 25,  0) | 0x8000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB(14,  5, 31) | 0x8000, RGB( 5, 20, 19) | 0x8000, RGB( 9, 22, 20) | 0x8000, RGB(13, 24, 22) | 0x8000, RGB(18, 27, 24) | 0x0000, RGB(27, 31, 26) | 0x8000, RGB( 0, 12,  0) | 0x0000, RGB( 8, 18, 12) | 0x0000,
    RGB(10, 16,  0) | 0x8000, RGB(31, 30,  0) | 0x0000, RGB( 0,  0, 22) | 0x0000, RGB( 0, 13, 30) | 0x8000, RGB( 1, 20, 31) | 0x0000, RGB( 2, 27, 31) | 0x0000, RGB(19, 31, 31) | 0x8000, RGB(29, 31, 31) | 0x8000,
    RGB(14,  5, 31) | 0x8000, RGB(31, 19,  9) | 0x8000, RGB(31, 31, 31) | 0x8000, RGB(31, 27, 18) | 0x8000, RGB( 0, 26, 31) | 0x8000, RGB(14, 17, 22) | 0x0000, RGB( 0, 28, 14) | 0x0000, RGB( 0, 18,  0) | 0x8000,
    RGB(23, 15,  0) | 0x8000, RGB(31, 13, 29) | 0x0000, RGB(31,  3, 12) | 0x0000, RGB(19, 20,  5) | 0x8000, RGB(20, 22,  9) | 0x8000, RGB(22, 24, 13) | 0x8000, RGB(24, 27, 18) | 0x0000, RGB(26, 31, 27) | 0x8000,
    RGB(14,  5, 31) | 0x8000, RGB( 0,  0,  0) | 0x0000, RGB(29, 20,  4) | 0x0000, RGB( 2,  1, 15) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB(31, 31, 31) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB( 1,  0, 31) | 0x0000, RGB( 9,  3, 25) | 0x0000, RGB( 4,  2, 31) | 0x0000, RGB( 7,  5, 31) | 0x0000, RGB(13,  8, 27) | 0x0000, RGB( 9,  8, 31) | 0x0000, RGB(11, 10, 31) | 0x0000,
    RGB(14, 13, 31) | 0x0000, RGB(18, 17, 31) | 0x8000, RGB(21, 20, 31) | 0x8000, RGB(23, 22, 31) | 0x8000, RGB(19, 27, 31) | 0x8000, RGB(26, 26, 31) | 0x8000, RGB(28, 29, 31) | 0x8000, RGB(31, 31, 31) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB( 5,  6, 18) | 0x0000, RGB( 6,  6, 18) | 0x0000, RGB( 9,  3, 26) | 0x0000, RGB( 7,  7, 18) | 0x0000, RGB( 8,  8, 19) | 0x0000, RGB(10, 10, 20) | 0x0000, RGB(11, 11, 20) | 0x0000,
    RGB(12, 12, 21) | 0x0000, RGB(13, 13, 22) | 0x0000, RGB(14, 14, 22) | 0x0000, RGB(15, 15, 23) | 0x0000, RGB(17, 17, 23) | 0x8000, RGB(18, 18, 24) | 0x8000, RGB(20, 20, 25) | 0x8000, RGB(22, 22, 26) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 3, 11, 14) | 0x0000, RGB( 1, 13, 19) | 0x0000, RGB( 0, 15, 19) | 0x0000, RGB( 0, 17, 19) | 0x8000, RGB( 9, 13, 16) | 0x0000,
    RGB(15, 12, 12) | 0x0000, RGB( 0, 19, 16) | 0x8000, RGB( 0, 18, 28) | 0x8000, RGB( 0, 21, 13) | 0x8000, RGB(16, 14, 13) | 0x0000, RGB( 0, 26,  7) | 0x8000, RGB(11, 19, 27) | 0x8000, RGB(17, 20, 26) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB( 3, 11, 16) | 0x0000, RGB(16, 11,  0) | 0x0000, RGB( 6, 14, 18) | 0x0000, RGB(17, 13, 13) | 0x0000, RGB(22, 13,  0) | 0x0000, RGB(10, 16, 20) | 0x8000, RGB(17, 15, 18) | 0x0000,
    RGB(13, 17, 23) | 0x8000, RGB(19, 17, 21) | 0x8000, RGB(24, 17, 11) | 0x8000, RGB(17, 19, 23) | 0x8000, RGB(18, 19, 25) | 0x8000, RGB(18, 20, 27) | 0x8000, RGB(20, 22, 28) | 0x8000, RGB(24, 25, 28) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
};

static const u16 gUnk_0836535C[] = {
    RGB( 0,  0, 31) | 0x0000, RGB( 0,  7, 31) | 0x8000, RGB( 0, 15, 31) | 0x8000, RGB( 0, 23, 31) | 0x8000, RGB( 0, 31, 31) | 0x8000, RGB( 0, 31, 23) | 0x8000, RGB( 0, 31, 15) | 0x8000, RGB( 0, 31,  7) | 0x8000,
    RGB( 0, 31,  0) | 0x8000, RGB( 7, 31,  0) | 0x8000, RGB(15, 31,  0) | 0x8000, RGB(23, 31,  0) | 0x8000, RGB(31, 31,  0) | 0x8000, RGB(31, 23,  0) | 0x8000, RGB(31, 15,  0) | 0x8000, RGB(31,  7,  0) | 0x8000,
    RGB(31,  0,  0) | 0x0000, RGB(31, 31, 31) | 0x8000,
};

const u32 gCrackityHackBgMainTileset[] = INCBIN_U32("graphics/crackity_hack/bg/main_tileset.4bpp.lz");

const u32 gCrackityHackGameEndedTileset_Japanese[] = INCBIN_U32("graphics/crackity_hack/bg/game_ended/tileset_japanese.4bpp.lz");
const u32 gCrackityHackGameEndedTileset_Italian[] = INCBIN_U32("graphics/crackity_hack/bg/game_ended/tileset_italian.4bpp.lz");
const u32 gCrackityHackGameEndedTileset_French[] = INCBIN_U32("graphics/crackity_hack/bg/game_ended/tileset_french.4bpp.lz");
const u32 gCrackityHackGameEndedTileset_Spanish[] = INCBIN_U32("graphics/crackity_hack/bg/game_ended/tileset_spanish.4bpp.lz");
const u32 gCrackityHackGameEndedTileset_English[] = INCBIN_U32("graphics/crackity_hack/bg/game_ended/tileset_english.4bpp.lz");
const u32 gCrackityHackGameEndedTileset_German[] = INCBIN_U32("graphics/crackity_hack/bg/game_ended/tileset_german.4bpp.lz");

// works as const u16 gCrackityHackUndergroundBg2CrackTilemap[][0x20][2]
static const u16 gCrackityHackUndergroundBg2CrackTilemap[] = INCBIN_U16("graphics/crackity_hack/bg/underground/bg2_crack_tilemap.bin");

static const u32 gCrackityHackColosseumBg0Tilemap[0x200] = INCBIN_U32("graphics/crackity_hack/bg/colosseum/bg0_tilemap.bin");
static const u32 gCrackityHackColosseumBg1Tilemap[0x200] = INCBIN_U32("graphics/crackity_hack/bg/colosseum/bg1_tilemap.bin");
static const u32 gCrackityHackUndergroundBg0Tilemap[0x200] = INCBIN_U32("graphics/crackity_hack/bg/underground/bg0_tilemap.bin");
static const u32 gCrackityHackUndergroundBg1Tilemap[0x200] = INCBIN_U32("graphics/crackity_hack/bg/underground/bg1_tilemap.bin");
static const u32 gCrackityHackUndergroundBg0CrackingThroughTilemap[0x200] = INCBIN_U32("graphics/crackity_hack/bg/underground/bg0_cracking_through_tilemap.bin");
static const u32 gCrackityHackUndergroundBg1CrackingThroughTilemap[0x200] = INCBIN_U32("graphics/crackity_hack/bg/underground/bg1_cracking_through_tilemap.bin");

static const u32 gUnk_08371EC8[0x140] = INCBIN_U32("graphics/crackity_hack/bg/tilemap_08371EC8.bin"); // never referenced

static const struct Unk_08128D48_0 gUnk_083723C8 = {
    .dstVramOffset = 0x38A0,
    .numTiles = 5,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xC0A0,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0x9880,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_083723D4 = {
    .dstVramOffset = 0x3C20,
    .numTiles = 10,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xC420,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0x9C00,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_083723E0 = {
    .dstVramOffset = 0x4020,
    .numTiles = 12,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xC820,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0x9160,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_083723EC = {
    .dstVramOffset = 0x4420,
    .numTiles = 12,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xCC20,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0x9560,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_083723F8 = {
    .dstVramOffset = 0x4820,
    .numTiles = 12,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xD020,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0x9960,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_08372404 = {
    .dstVramOffset = 0x4C20,
    .numTiles = 12,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xD420,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0x9D60,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_08372410 = {
    .dstVramOffset = 0x5020,
    .numTiles = 12,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xD820,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0xA160,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_0837241C = {
    .dstVramOffset = 0x5420,
    .numTiles = 12,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xDC20,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0xA560,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_08372428 = {
    .dstVramOffset = 0x5820,
    .numTiles = 11,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xC1A0,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0xA000,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_08128D48_0 gUnk_08372434 = {
    .dstVramOffset = 0x5C20,
    .numTiles = 11,
    .numFrames = 2,
    .frames = {
        {
            .srcVramOffset = 0xC5A0,
            .unk2 = 0,
            .delay = 15,
        },
        {
            .srcVramOffset = 0xA400,
            .unk2 = 0,
            .delay = 15,
        },
    },
};

static const struct Unk_02021590 gUnk_08372440[][16] = {
    [LANGUAGE_JAPANESE] = {
        { 0x345,  0x2, 0x0 },
        { 0x345,  0x3, 0x0 },
        { 0x345,  0x4, 0x0 },
        { 0x345,  0x5, 0x0 },
        { 0x345,  0x6, 0x0 },
        { 0x345,  0x7, 0x0 },
        { 0x345,  0x8, 0x0 },
        { 0x345,  0x9, 0x0 },
        { 0x345,  0xA, 0x0 },
        { 0x345,  0xB, 0x0 },
        { 0x345,  0xC, 0x0 },
        { 0x345,  0xD, 0x0 },
        { 0x345,  0xE, 0x0 },
        { 0x345,  0xF, 0x0 },
        { 0x345, 0x10, 0x0 },
        { 0x345, 0x11, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x345,  0x2, 0x0 },
        { 0x345,  0x3, 0x0 },
        { 0x345,  0x4, 0x0 },
        { 0x345,  0x5, 0x0 },
        { 0x345,  0x6, 0x0 },
        { 0x345,  0x7, 0x0 },
        { 0x345,  0x8, 0x0 },
        { 0x345,  0x9, 0x0 },
        { 0x345,  0xA, 0x0 },
        { 0x345,  0xB, 0x0 },
        { 0x345,  0xC, 0x0 },
        { 0x345,  0xD, 0x0 },
        { 0x345,  0xE, 0x0 },
        { 0x345,  0xF, 0x0 },
        { 0x345, 0x10, 0x0 },
        { 0x345, 0x11, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x345,  0x2, 0x0 },
        { 0x345,  0x3, 0x0 },
        { 0x345,  0x4, 0x0 },
        { 0x345,  0x5, 0x0 },
        { 0x345,  0x6, 0x0 },
        { 0x345,  0x7, 0x0 },
        { 0x345,  0x8, 0x0 },
        { 0x345,  0x9, 0x0 },
        { 0x345,  0xA, 0x0 },
        { 0x345,  0xB, 0x0 },
        { 0x345,  0xC, 0x0 },
        { 0x345,  0xD, 0x0 },
        { 0x345,  0xE, 0x0 },
        { 0x345,  0xF, 0x0 },
        { 0x345, 0x10, 0x0 },
        { 0x345, 0x11, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x345,  0x2, 0x0 },
        { 0x345,  0x3, 0x0 },
        { 0x345,  0x4, 0x0 },
        { 0x345,  0x5, 0x0 },
        { 0x345,  0x6, 0x0 },
        { 0x345,  0x7, 0x0 },
        { 0x345,  0x8, 0x0 },
        { 0x345,  0x9, 0x0 },
        { 0x345,  0xA, 0x0 },
        { 0x345,  0xB, 0x0 },
        { 0x345,  0xC, 0x0 },
        { 0x345,  0xD, 0x0 },
        { 0x345,  0xE, 0x0 },
        { 0x345,  0xF, 0x0 },
        { 0x345, 0x10, 0x0 },
        { 0x345, 0x11, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x345,  0x2, 0x0 },
        { 0x345,  0x3, 0x0 },
        { 0x345,  0x4, 0x0 },
        { 0x345,  0x5, 0x0 },
        { 0x345,  0x6, 0x0 },
        { 0x345,  0x7, 0x0 },
        { 0x345,  0x8, 0x0 },
        { 0x345,  0x9, 0x0 },
        { 0x345,  0xA, 0x0 },
        { 0x345,  0xB, 0x0 },
        { 0x345,  0xC, 0x0 },
        { 0x345,  0xD, 0x0 },
        { 0x345,  0xE, 0x0 },
        { 0x345,  0xF, 0x0 },
        { 0x345, 0x10, 0x0 },
        { 0x345, 0x11, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x345,  0x2, 0x0 },
        { 0x345,  0x3, 0x0 },
        { 0x345,  0x4, 0x0 },
        { 0x345,  0x5, 0x0 },
        { 0x345,  0x6, 0x0 },
        { 0x345,  0x7, 0x0 },
        { 0x345,  0x8, 0x0 },
        { 0x345,  0x9, 0x0 },
        { 0x345,  0xA, 0x0 },
        { 0x345,  0xB, 0x0 },
        { 0x345,  0xC, 0x0 },
        { 0x345,  0xD, 0x0 },
        { 0x345,  0xE, 0x0 },
        { 0x345,  0xF, 0x0 },
        { 0x345, 0x10, 0x0 },
        { 0x345, 0x11, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_083725C0[][4] = {
    [LANGUAGE_JAPANESE] = {
        { 0x343, 0x11, 0x0 },
        { 0x343, 0x12, 0x0 },
        { 0x343, 0x13, 0x0 },
        { 0x343, 0x14, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x343, 0x11, 0x0 },
        { 0x343, 0x12, 0x0 },
        { 0x343, 0x13, 0x0 },
        { 0x343, 0x14, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x343, 0x11, 0x0 },
        { 0x343, 0x12, 0x0 },
        { 0x343, 0x13, 0x0 },
        { 0x343, 0x14, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x343, 0x11, 0x0 },
        { 0x343, 0x12, 0x0 },
        { 0x343, 0x13, 0x0 },
        { 0x343, 0x14, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x343, 0x11, 0x0 },
        { 0x343, 0x12, 0x0 },
        { 0x343, 0x13, 0x0 },
        { 0x343, 0x14, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x343, 0x11, 0x0 },
        { 0x343, 0x12, 0x0 },
        { 0x343, 0x13, 0x0 },
        { 0x343, 0x14, 0x0 },
    },
};

static const s8 gUnk_08372620[] = { 10, 5, 10, 15, 20, 0, 0, 0 }; // TODO: padding?

extern const u32 *const gCrackityHackObjTilesetTable[];

static struct Task *sub_08128F44(const struct Unk_02021590 *a1, u8 a2, u8 a3, s16 a4, s16 a5, u8 a6) {
    struct Task *t = TaskCreate(sub_0812A39C, sizeof(struct Unk_08128F44), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_08128F44 *tmp = TaskGetStructPtr(t), *var = tmp;
#ifndef NONMATCHING
    register struct Unk_08128F44_4 *var1 asm("r6"), *var2 asm("r4");
#else
    struct Unk_08128F44_4 *var1, *var2;
#endif

    var->unk0 = a1;
    var->unk2AC = 0x10;
    var->unk2AD = 0;
    var->unk2AE = 0;
    var->unk2B0 = a2;
    var->unk2B1 = a3;
    var->unk2B2 = 1;
    var->unk2B3 = 0;
    var->unk2B4 = a4;
    var->unk2B6 = a5;
    if (a6) var->unk2AC |= 0x80;
    if (gMainFlags & MAIN_FLAG_OBJ_PALETTE_TRANSFORMATION_ENABLE)
        LoadObjPaletteWithTransformation(&gUnk_082DE69C[0x10 * var->unk2B2], 0x10 * var->unk2B0, 0x10);
    else {
        DmaCopy16(3, &gUnk_082DE69C[0x10 * var->unk2B2], &gObjPalette[0x10 * var->unk2B0], 0x10 * sizeof(u16));
        gMainFlags |= MAIN_FLAG_OBJ_PALETTE_SYNC_ENABLE;
    }
    if (gMainFlags & MAIN_FLAG_OBJ_PALETTE_TRANSFORMATION_ENABLE)
        LoadObjPaletteWithTransformation(gUnk_082DE69C, 0x10 * var->unk2B1, 0x10);
    else {
        DmaCopy16(3, gUnk_082DE69C, &gObjPalette[0x10 * var->unk2B1], 0x10 * sizeof(u16));
        gMainFlags |= MAIN_FLAG_OBJ_PALETTE_SYNC_ENABLE;
    }
    CpuFill32(0, &var->unk4[0][0], sizeof(struct Unk_08128F44_4));
    var->unk4[0][0].unk0.tilesVram = 0x6010000;
    var->unk4[0][0].unk0.unk14 = 0x280;
    var->unk4[0][0].unk0.animId = var->unk0[0].animId;
    var->unk4[0][0].unk0.variant = var->unk0[0].variant;
    var->unk4[0][0].unk0.unk16 = 0;
    var->unk4[0][0].unk0.unk1B = 0xFF;
    var->unk4[0][0].unk0.unk1C = 0x10;
    var->unk4[0][0].unk0.palId = var->unk2B0;
    var->unk4[0][0].unk0.x = ({var->unk2B4 + 0;});
    var->unk4[0][0].unk0.y = ({var->unk2B6 + 0;});
    var->unk4[0][0].unk0.unk8 = 0xC0000;
    var->unk4[0][0].unk28 = 4 * var->unk2B4;
    var->unk4[0][0].unk2C = 4 * var->unk2B6;
    var->unk4[0][0].unk30 = 0;
    var->unk4[0][0].unk32 = 0;
    var->unk4[0][0].unk34 = 0x10;
    var->unk4[0][0].unk36 = 0;
    var->unk4[0][0].unk38 = NULL;
    var->unk4[0][0].unk3C = NULL;
    var->unk4[0][0].unk40 = NULL;
    CpuFill32(0, &var->unk4[1][0], sizeof(struct Unk_08128F44_4));
    var->unk4[1][0].unk0.tilesVram = 0x6010000;
    var->unk4[1][0].unk0.unk14 = 0x280;
    var->unk4[1][0].unk0.animId = var->unk0[1].animId;
    var->unk4[1][0].unk0.variant = var->unk0[1].variant;
    var->unk4[1][0].unk0.unk16 = 0;
    var->unk4[1][0].unk0.unk1B = 0xFF;
    var->unk4[1][0].unk0.unk1C = 0x10;
    var->unk4[1][0].unk0.palId = var->unk2B0;
    var->unk4[1][0].unk0.x = 0;
    var->unk4[1][0].unk0.y = 0;
    var->unk4[1][0].unk0.unk8 = 0xC0000;
    var->unk4[1][0].unk28 = 0;
    var->unk4[1][0].unk2C = 0;
    var->unk4[1][0].unk30 = 0;
    var->unk4[1][0].unk32 = 0;
    var->unk4[1][0].unk34 = 0x10;
    var->unk4[1][0].unk36 = 0;
    var->unk4[1][0].unk38 = NULL;
    var->unk4[1][0].unk3C = NULL;
    var->unk4[1][0].unk40 = NULL;
    var->unk4[0][0].unk40 = &var->unk4[1][0];
    var->unk4[1][0].unk3C = &var->unk4[0][0];
    var->unk4[1][0].unk34 &= ~0x10;
    CpuFill32(0, var1 = &var->unk4[2][0], sizeof(struct Unk_08128F44_4));
    var1->unk0.tilesVram = 0x6010000;
    var1->unk0.unk14 = 0x2C0;
    var1->unk0.animId = var->unk0[0].animId;
    var1->unk0.variant = var->unk0[0].variant;
    var1->unk0.unk16 = 0;
    var1->unk0.unk1B = 0xFF;
    var1->unk0.unk1C = 0x10;
    var1->unk0.palId = var->unk2B1;
    var1->unk0.x = ({var->unk2B4 + 0x14;});
    var1->unk0.y = ({var->unk2B6 + 0xA;});
    var1->unk0.unk8 = 0xC0000;
    var1->unk28 = 4 * (var->unk2B4 + 0x14);
    var1->unk2C = 4 * (var->unk2B6 + 0xA);
    var1->unk30 = 0;
    var1->unk32 = 0;
    var1->unk34 = 0x10;
    var1->unk36 = 0;
    var1->unk38 = NULL;
    var1->unk3C = NULL;
    var1->unk40 = NULL;
    CpuFill32(0, var2 = &var->unk4[3][0], sizeof(struct Unk_08128F44_4));
    var2->unk0.tilesVram = 0x6010000;
    var2->unk0.unk14 = 0x2C0;
    var2->unk0.animId = var->unk0[2].animId;
    var2->unk0.variant = var->unk0[2].variant;
    var2->unk0.unk16 = 0;
    var2->unk0.unk1B = 0xFF;
    var2->unk0.unk1C = 0x10;
    var2->unk0.palId = var->unk2B1;
    var2->unk0.x = 0;
    var2->unk0.y = 0;
    var2->unk0.unk8 = 0xC0000;
    var2->unk28 = 0;
    var2->unk2C = 0;
    var2->unk30 = 0;
    var2->unk32 = 0;
    var2->unk34 = 0x10;
    var2->unk36 = 0;
    var2->unk38 = NULL;
    var2->unk3C = NULL;
    var2->unk40 = NULL;
    var1->unk40 = var2;
    var2->unk3C = var1;
    var2->unk34 &= ~0x10;
    CpuFill32(0, var1 = &var->unk4[4][0], sizeof(struct Unk_08128F44_4));
    var1->unk0.tilesVram = 0x6010000;
    var1->unk0.unk14 = 0x280;
    var1->unk0.animId = var->unk0[0].animId;
    var1->unk0.variant = var->unk0[0].variant;
    var1->unk0.unk16 = 0;
    var1->unk0.unk1B = 0xFF;
    var1->unk0.unk1C = 0x10;
    var1->unk0.palId = var->unk2B0;
    var1->unk0.x = ({var->unk2B4 - 0x14;});
    var1->unk0.y = ({var->unk2B6 - 5;});
    var1->unk0.unk8 = 0xC0000;
    var1->unk28 = 4 * (var->unk2B4 - 0x14);
    var1->unk2C = 4 * (var->unk2B6 - 5);
    var1->unk30 = 0;
    var1->unk32 = 0;
    var1->unk34 = 0x10;
    var1->unk36 = 0;
    var1->unk38 = NULL;
    var1->unk3C = NULL;
    var1->unk40 = NULL;
    CpuFill32(0, var2 = &var->unk4[7][0], sizeof(struct Unk_08128F44_4));
    var2->unk0.tilesVram = 0x6010000;
    var2->unk0.unk14 = 0x280;
    var2->unk0.animId = var->unk0[3].animId;
    var2->unk0.variant = var->unk0[3].variant;
    var2->unk0.unk16 = 0;
    var2->unk0.unk1B = 0xFF;
    var2->unk0.unk1C = 0x10;
    var2->unk0.palId = var->unk2B0;
    var2->unk0.x = 0;
    var2->unk0.y = 0;
    var2->unk0.unk8 = 0xC0000;
    var2->unk28 = 0;
    var2->unk2C = 0;
    var2->unk30 = 0;
    var2->unk32 = 0;
    var2->unk34 = 0x10;
    var2->unk36 = 0;
    var2->unk38 = NULL;
    var2->unk3C = NULL;
    var2->unk40 = NULL;
    var1->unk40 = var2;
    var2->unk3C = var1;
    var2->unk34 &= ~0x10;
    CpuFill32(0, var1 = &var->unk4[5][0], sizeof(struct Unk_08128F44_4));
    var1->unk0.tilesVram = 0x6010000;
    var1->unk0.unk14 = 0x2C0;
    var1->unk0.animId = var->unk0[0].animId;
    var1->unk0.variant = var->unk0[0].variant;
    var1->unk0.unk16 = 0;
    var1->unk0.unk1B = 0xFF;
    var1->unk0.unk1C = 0x10;
    var1->unk0.palId = var->unk2B1;
    var1->unk0.x = ({var->unk2B4 + 0;});
    var1->unk0.y = ({var->unk2B6 + 5;});
    var1->unk0.unk8 = 0xC0000;
    var1->unk28 = 4 * var->unk2B4;
    var1->unk2C = 4 * (var->unk2B6 + 5);
    var1->unk30 = 0;
    var1->unk32 = 0;
    var1->unk34 = 0x10;
    var1->unk36 = 0;
    var1->unk38 = NULL;
    var1->unk3C = NULL;
    var1->unk40 = NULL;
    CpuFill32(0, var2 = &var->unk4[8][0], sizeof(struct Unk_08128F44_4));
    var2->unk0.tilesVram = 0x6010000;
    var2->unk0.unk14 = 0x2C0;
    var2->unk0.animId = var->unk0[4].animId;
    var2->unk0.variant = var->unk0[4].variant;
    var2->unk0.unk16 = 0;
    var2->unk0.unk1B = 0xFF;
    var2->unk0.unk1C = 0x10;
    var2->unk0.palId = var->unk2B1;
    var2->unk0.x = 0;
    var2->unk0.y = 0;
    var2->unk0.unk8 = 0xC0000;
    var2->unk28 = 0;
    var2->unk2C = 0;
    var2->unk30 = 0;
    var2->unk32 = 0;
    var2->unk34 = 0x10;
    var2->unk36 = 0;
    var2->unk38 = NULL;
    var2->unk3C = NULL;
    var2->unk40 = NULL;
    var1->unk40 = var2;
    var2->unk3C = var1;
    var2->unk34 &= ~0x10;
    CpuFill32(0, var1 = &var->unk4[6][0], sizeof(struct Unk_08128F44_4));
    var1->unk0.tilesVram = 0x6010000;
    var1->unk0.unk14 = 0x300;
    var1->unk0.animId = var->unk0[0].animId;
    var1->unk0.variant = var->unk0[0].variant;
    var1->unk0.unk16 = 0;
    var1->unk0.unk1B = 0xFF;
    var1->unk0.unk1C = 0x10;
    var1->unk0.palId = var->unk2B1;
    var1->unk0.x = ({var->unk2B4 + 0x14;});
    var1->unk0.y = ({var->unk2B6 + 0xF;});
    var1->unk0.unk8 = 0xC0000;
    var1->unk28 = 4 * (var->unk2B4 + 0x14);
    var1->unk2C = 4 * (var->unk2B6 + 0xF);
    var1->unk30 = 0;
    var1->unk32 = 0;
    var1->unk34 = 0x10;
    var1->unk36 = 0;
    var1->unk38 = NULL;
    var1->unk3C = NULL;
    var1->unk40 = NULL;
    CpuFill32(0, var2 = &var->unk4[9][0], sizeof(struct Unk_08128F44_4));
    var2->unk0.tilesVram = 0x6010000;
    var2->unk0.unk14 = 0x300;
    var2->unk0.animId = var->unk0[5].animId;
    var2->unk0.variant = var->unk0[5].variant;
    var2->unk0.unk16 = 0;
    var2->unk0.unk1B = 0xFF;
    var2->unk0.unk1C = 0x10;
    var2->unk0.palId = var->unk2B1;
    var2->unk0.x = 0;
    var2->unk0.y = 0;
    var2->unk0.unk8 = 0xC0000;
    var2->unk28 = 0;
    var2->unk2C = 0;
    var2->unk30 = 0;
    var2->unk32 = 0;
    var2->unk34 = 0x10;
    var2->unk36 = 0;
    var2->unk38 = NULL;
    var2->unk3C = NULL;
    var2->unk40 = NULL;
    var1->unk40 = var2;
    var2->unk3C = var1;
    var2->unk34 &= ~0x10;
    return t;
}

static void sub_081295A0(void) {
    struct Unk_08128F44 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u16 r2;

    if (var->unk2AC & 1)
        r2 = 0;
    else if (gUnk_0203AD10 & 2)
        r2 = gUnk_020382D0.unk8[1][0];
    else
        r2 = gPressedKeys;
    if (var->unk2AC & 4) {
        if (r2 & 1) {
            if (!(var->unk2AC & 0x80))
                m4aSongNumStart(0x21E);
            var->unk2AC |= 1;
        }
        else if (r2 & 2) {
            if (!(var->unk2AC & 0x80))
                m4aSongNumStart(0x21F);
            var->unk2AC &= ~4;
            var->unk2AC &= ~0x40;
        }
        else if (r2 & 0x40) {
            if (!(var->unk2AC & 0x80))
                m4aSongNumStart(0x21D);
            var->unk2AE = 0;
            gCurTask->main = sub_08129F28;
        }
        else if (r2 & 0x80) {
            if (!(var->unk2AC & 0x80))
                m4aSongNumStart(0x21D);
            var->unk2AE = 0;
            gCurTask->main = sub_08129C34;
        }
    }
    else {
        if (r2 & 1) {
            if (!(var->unk2AC & 0x80)) {
                m4aSongNumStart(0x21E);
                if (var->unk2AD == 0)
                    var->unk2B2 = 1;
                else if (var->unk2AD == 1)
                    var->unk2B2 = 3;
                else
                    var->unk2B2 = 5;
            }
            if (var->unk2AC & 0x10) {
                var->unk2AC |= 4;
                var->unk2AC |= 0x40;
            }
            else {
                var->unk2AC |= 1;
            }
        }
        else if (r2 & 0x40) {
            if (!(var->unk2AC & 0x80))
                m4aSongNumStart(0x21D);
            var->unk2AE = 0;
            gCurTask->main = sub_081298B4;
        }
        else if (r2 & 0x80) {
            if (!(var->unk2AC & 0x80))
                m4aSongNumStart(0x21D);
            var->unk2AE = 0;
            gCurTask->main = sub_08129A6C;
        }
    }
    sub_081297F8(var);
    if (!(var->unk2AC & 0x80)) {
        if (var->unk2AC & 4) {
            sub_081288DC(&var->unk4[4][0]);
            sub_081288DC(&var->unk4[5][0]);
            sub_081288DC(&var->unk4[6][0]);
        }
        else {
            sub_081288DC(&var->unk4[0][0]);
            sub_081288DC(&var->unk4[2][0]);
        }
    }
}

static void sub_081297F8(struct Unk_08128F44 *a1) {
    const u16 *p;

    if (a1->unk2B3++ > 5) {
        a1->unk2B3 = 0;
        p = gUnk_082DE69C + 0x10 * (a1->unk2AC & 2 ? a1->unk2B2 : a1->unk2B2 + 1);
        a1->unk2AC ^= 2;
        if (gMainFlags & MAIN_FLAG_OBJ_PALETTE_TRANSFORMATION_ENABLE)
            LoadObjPaletteWithTransformation(p, 0x10 * a1->unk2B0, 0x10);
        else {
            DmaCopy16(3, p, gObjPalette + 0x10 * a1->unk2B0, 0x10 * sizeof(u16));
            gMainFlags |= MAIN_FLAG_OBJ_PALETTE_SYNC_ENABLE;
        }
    }
}

static void sub_081298B4(void) {
    struct Unk_08128F44 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (var->unk2AC & 0x10) {
        var->unk4[0][0].unk28 += 8;
        var->unk4[0][0].unk2C += 4;
        var->unk4[0][0].unk0.unk14 &= ~0x7C0;
        var->unk4[0][0].unk0.unk14 |= 0x2C0;
        var->unk4[0][0].unk0.palId = var->unk2B1;
        var->unk4[1][0].unk0.unk14 &= ~0x7C0;
        var->unk4[1][0].unk0.unk14 |= 0x2C0;
        var->unk4[1][0].unk0.palId = var->unk2B1;
        var->unk4[2][0].unk28 -= 8;
        var->unk4[2][0].unk2C -= 4;
        var->unk4[2][0].unk0.unk14 &= ~0x7C0;
        var->unk4[2][0].unk0.unk14 |= 0x280;
        var->unk4[2][0].unk0.palId = var->unk2B0;
        var->unk4[3][0].unk0.unk14 &= ~0x7C0;
        var->unk4[3][0].unk0.unk14 |= 0x280;
        var->unk4[3][0].unk0.palId = var->unk2B0;
    }
    else {
        var->unk4[0][0].unk28 -= 8;
        var->unk4[0][0].unk2C -= 4;
        var->unk4[0][0].unk0.unk14 &= ~0x7C0;
        var->unk4[0][0].unk0.unk14 |= 0x280;
        var->unk4[0][0].unk0.palId = var->unk2B0;
        var->unk4[1][0].unk0.unk14 &= ~0x7C0;
        var->unk4[1][0].unk0.unk14 |= 0x280;
        var->unk4[1][0].unk0.palId = var->unk2B0;
        var->unk4[2][0].unk28 += 8;
        var->unk4[2][0].unk2C += 4;
        var->unk4[2][0].unk0.unk14 &= ~0x7C0;
        var->unk4[2][0].unk0.unk14 |= 0x2C0;
        var->unk4[2][0].unk0.palId = var->unk2B1;
        var->unk4[3][0].unk0.unk14 &= ~0x7C0;
        var->unk4[3][0].unk0.unk14 |= 0x2C0;
        var->unk4[3][0].unk0.palId = var->unk2B1;
    }
    if (var->unk2AC & 0x10)
        var->unk2B2 = 1;
    else
        var->unk2B2 = 3;
    sub_081297F8(var);
    if (!(var->unk2AC & 0x80)) {
        sub_081288DC(&var->unk4[0][0]);
        sub_081288DC(&var->unk4[2][0]);
    }
    if (++var->unk2AE > 9) {
        gCurTask->main = sub_081295A0;
        var->unk2AC ^= 0x10;
        var->unk2AC ^= 0x20;
    }
}

static void sub_08129A6C(void) {
    struct Unk_08128F44 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (var->unk2AC & 0x10) {
        var->unk4[0][0].unk28 += 8;
        var->unk4[0][0].unk2C += 4;
        var->unk4[0][0].unk0.palId = var->unk2B1;
        var->unk4[1][0].unk0.palId = var->unk2B1;
        var->unk4[2][0].unk28 -= 8;
        var->unk4[2][0].unk2C -= 4;
        var->unk4[2][0].unk0.palId = var->unk2B0;
        var->unk4[3][0].unk0.palId = var->unk2B0;
    }
    else {
        var->unk4[0][0].unk28 -= 8;
        var->unk4[0][0].unk2C -= 4;
        var->unk4[0][0].unk0.palId = var->unk2B0;
        var->unk4[1][0].unk0.palId = var->unk2B0;
        var->unk4[2][0].unk28 += 8;
        var->unk4[2][0].unk2C += 4;
        var->unk4[2][0].unk0.palId = var->unk2B1;
        var->unk4[3][0].unk0.palId = var->unk2B1;
    }
    if (var->unk2AC & 0x10)
        var->unk2B2 = 1;
    else
        var->unk2B2 = 3;
    sub_081297F8(var);
    if (!(var->unk2AC & 0x80)) {
        sub_081288DC(&var->unk4[0][0]);
        sub_081288DC(&var->unk4[2][0]);
    }
    if (++var->unk2AE > 9) {
        if (var->unk2AC & 0x10) {
            var->unk4[0][0].unk0.unk14 &= ~0x7C0;
            var->unk4[0][0].unk0.unk14 |= 0x2C0;
            var->unk4[1][0].unk0.unk14 &= ~0x7C0;
            var->unk4[1][0].unk0.unk14 |= 0x2C0;
            var->unk4[2][0].unk0.unk14 &= ~0x7C0;
            var->unk4[2][0].unk0.unk14 |= 0x280;
            var->unk4[3][0].unk0.unk14 &= ~0x7C0;
            var->unk4[3][0].unk0.unk14 |= 0x280;
        }
        else {
            var->unk4[0][0].unk0.unk14 &= ~0x7C0;
            var->unk4[0][0].unk0.unk14 |= 0x280;
            var->unk4[1][0].unk0.unk14 &= ~0x7C0;
            var->unk4[1][0].unk0.unk14 |= 0x280;
            var->unk4[2][0].unk0.unk14 &= ~0x7C0;
            var->unk4[2][0].unk0.unk14 |= 0x2C0;
            var->unk4[3][0].unk0.unk14 &= ~0x7C0;
            var->unk4[3][0].unk0.unk14 |= 0x2C0;
        }
        gCurTask->main = sub_081295A0;
        var->unk2AC ^= 0x10;
        var->unk2AC ^= 0x20;
    }
}

static void sub_08129C34(void) {
    struct Unk_08128F44 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    const u8 *p = gUnk_08363AA0[var->unk2AD];

    var->unk4[p[0]][4].unk28 += 0x10;
    var->unk4[p[0]][4].unk2C += 8;
    var->unk4[p[0]][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[0]][4].unk0.unk14 |= 0x300;
    var->unk4[p[0]][4].unk0.palId = var->unk2B1;
    var->unk4[p[0] + 3][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[0] + 3][4].unk0.unk14 |= 0x300;
    var->unk4[p[0] + 3][4].unk0.palId = var->unk2B1;
    var->unk4[p[1]][4].unk28 -= 8;
    var->unk4[p[1]][4].unk2C -= 4;
    var->unk4[p[1]][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[1]][4].unk0.unk14 |= 0x280;
    var->unk4[p[1]][4].unk0.palId = var->unk2B0;
    var->unk4[p[1] + 3][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[1] + 3][4].unk0.unk14 |= 0x280;
    var->unk4[p[1] + 3][4].unk0.palId = var->unk2B0;
    var->unk4[p[2]][4].unk28 -= 8;
    var->unk4[p[2]][4].unk2C -= 4;
    var->unk4[p[2]][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[2]][4].unk0.unk14 |= 0x2C0;
    var->unk4[p[2]][4].unk0.palId = var->unk2B1;
    var->unk4[p[2] + 3][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[2] + 3][4].unk0.unk14 |= 0x2C0;
    var->unk4[p[2] + 3][4].unk0.palId = var->unk2B1;
    if (p[1] == 0)
        var->unk2B2 = 1;
    else if (p[1] == 1)
        var->unk2B2 = 3;
    else
        var->unk2B2 = 5;
    sub_081297F8(var);
    if (!(var->unk2AC & 0x80)) {
        sub_081288DC(&var->unk4[4][0]);
        sub_081288DC(&var->unk4[5][0]);
        sub_081288DC(&var->unk4[6][0]);
    }
    if (++var->unk2AE > 9) {
        gCurTask->main = sub_081295A0;
        var->unk2AD = p[1];
    }
}

static void sub_08129F28(void) {
    struct Unk_08128F44 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    const u8 *p = gUnk_08363AA0[var->unk2AD];

    var->unk4[p[0]][4].unk28 += 8;
    var->unk4[p[0]][4].unk2C += 4;
    var->unk4[p[0]][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[0]][4].unk0.unk14 |= 0x2C0;
    var->unk4[p[0]][4].unk0.palId = var->unk2B1;
    var->unk4[p[0] + 3][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[0] + 3][4].unk0.unk14 |= 0x2C0;
    var->unk4[p[0] + 3][4].unk0.palId = var->unk2B1;
    var->unk4[p[1]][4].unk28 += 8;
    var->unk4[p[1]][4].unk2C += 4;
    var->unk4[p[1]][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[1]][4].unk0.unk14 |= 0x300;
    var->unk4[p[1]][4].unk0.palId = var->unk2B1;
    var->unk4[p[1] + 3][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[1] + 3][4].unk0.unk14 |= 0x300;
    var->unk4[p[1] + 3][4].unk0.palId = var->unk2B1;
    var->unk4[p[2]][4].unk28 -= 0x10;
    var->unk4[p[2]][4].unk2C -= 8;
    var->unk4[p[2]][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[2]][4].unk0.unk14 |= 0x280;
    var->unk4[p[2]][4].unk0.palId = var->unk2B0;
    var->unk4[p[2] + 3][4].unk0.unk14 &= ~0x7C0;
    var->unk4[p[2] + 3][4].unk0.unk14 |= 0x280;
    var->unk4[p[2] + 3][4].unk0.palId = var->unk2B0;
    if (p[2] == 0)
        var->unk2B2 = 1;
    else if (p[2] == 1)
        var->unk2B2 = 3;
    else
        var->unk2B2 = 5;
    sub_081297F8(var);
    if (!(var->unk2AC & 0x80)) {
        sub_081288DC(&var->unk4[4][0]);
        sub_081288DC(&var->unk4[5][0]);
        sub_081288DC(&var->unk4[6][0]);
    }
    if (++var->unk2AE > 9) {
        gCurTask->main = sub_081295A0;
        var->unk2AD = p[2];
    }
}

static void sub_0812A218(struct Unk_08128F44_4 *a1) {
    struct Unk_08128F44_4 *unk3C = a1->unk3C;

    a1->unk28 += unk3C->unk28;
    a1->unk2C += unk3C->unk2C;
    a1->unk30 = unk3C->unk30;
    a1->unk32 = unk3C->unk32;
    a1->unk34 |= 0x10;
    a1->unk38 = sub_0812A388(a1);
    unk3C->unk40 = NULL;
    a1->unk3C = NULL;
}

void sub_0812A254(struct Unk_08128F44_4 *a1) {
    s32 a[2];

    a[0] = 0;
    a[1] = 0;
    if (!(a1->unk34 & 0x2000)) {
        a1->unk28 += a1->unk30;
        a1->unk2C += a1->unk32;
        sub_0812A344(a, a1);
        a1->unk0.x = a[0] >> 2;
        a1->unk0.y = a[1] >> 2;
    }
}

// not referenced
static void sub_0812A29C(struct Unk_08128F44_4 *a1) {
    a1->unk34 &= ~0x100;
    if (a1->unk34 & 0x200)
        a1->unk0.unk1B = 0xFF;
}

static void sub_0812A2C0(struct Unk_0812D1EC_0 *a1) {
    a1->unk48 += a1->unk4.unk30;
    a1->unk4C += a1->unk4.unk32;
    a1->unk4.unk28 = a1->unk48;
    a1->unk4.unk2C = a1->unk4C;
    if (a1->unk52 & 2) {
        a1->unk4.unk28 += a1->unk0[0].unk28;
        a1->unk4.unk2C += a1->unk0[0].unk2C;
    }
    sub_081288DC(&a1->unk4);
}

bool32 sub_0812A304(void) {
    if ((!gBldRegs.bldY || gBldRegs.bldY == 0x1F) && !gBldRegs.bldAlpha)
        return FALSE;
    else
        return TRUE;
}

static bool32 sub_0812A328(struct Unk_08128F44 *a1) {
    if (a1->unk2AC & 1)
        return TRUE;
    else
        return FALSE;
}

static void sub_0812A344(s32 *a1, struct Unk_08128F44_4 *a2) {
    if (a2->unk3C)
        sub_0812A344(a1, a2->unk3C);
    if (a2->unk38) {
        a1[0] += a2->unk28 + a2->unk38[0];
        a1[1] += a2->unk2C + a2->unk38[1];
    }
    else {
        a1[0] += a2->unk28;
        a1[1] += a2->unk2C;
    }
}

static s32 *sub_0812A388(struct Unk_08128F44_4 *a1) {
    while (1) {
        if (!a1->unk3C)
            return a1->unk38;
        a1 = a1->unk3C;
    }
}

static void sub_0812A39C(void) {
    struct Unk_08128F44 *var = TaskGetStructPtr(gCurTask);

    gCurTask->main = sub_081295A0;
    if (!(var->unk2AC & 0x80))
        m4aSongNumStart(542);
}

static void sub_0812A3F4(struct Unk_0812A77C_40 *a1, s32 *a2, u8 a3, u8 a4) {
    if (a4 < gUnk_0203AD30)
        a1->unk90 = 0;
    else
        a1->unk90 = 1;
    a1->unk88 = NULL;
    a1->unk8C = NULL;
    a1->unk92 = 0;
    a1->unk96 = 0;
    a1->unk94 = 0;
    a1->unk98 = 0;
    a1->unk9A = 0;
    a1->unk9C = 0x5A;
    a1->unk9E = 1;
    a1->unkA0 = 1;
    a1->unkAC = 3;
    a1->unkA6 = 0;
    a1->unkA8 = 0;
    a1->unkAA = 0;
    a1->unkAD = 0;
    a1->unkAE = 0;
    CpuFill32(0, &a1->unk0[0], sizeof(struct Unk_08128F44_4));
    a1->unk0[0].unk0.tilesVram = 0x6010000;
    a1->unk0[0].unk0.unk14 = 0x480;
    a1->unk0[0].unk0.animId = gUnk_08364CE4[gLanguage][6].animId;
    a1->unk0[0].unk0.variant = gUnk_08364CE4[gLanguage][6].variant;
    a1->unk0[0].unk0.unk16 = 0;
    a1->unk0[0].unk0.unk1B = 0xFF;
    a1->unk0[0].unk0.unk1C = 0x10;
    a1->unk0[0].unk0.palId = a3;
    a1->unk0[0].unk0.x = gUnk_08364C9A[a3][0] >> 2;
    a1->unk0[0].unk0.y = gUnk_08364C9A[a3][1] >> 2;
    a1->unk0[0].unk0.unk8 = 0xC0000;
    a1->unk0[0].unk28 = gUnk_08364C9A[a3][0];
    a1->unk0[0].unk2C = gUnk_08364C9A[a3][1];
    a1->unk0[0].unk30 = 0;
    a1->unk0[0].unk32 = 0;
    a1->unk0[0].unk34 = 0x810;
    a1->unk0[0].unk36 = 0;
    a1->unk0[0].unk3C = NULL;
    a1->unk0[0].unk40 = NULL;
    a1->unk0[0].unk38 = a2;
    CpuFill32(0, &a1->unk0[1], sizeof(struct Unk_08128F44_4));
    a1->unk0[1].unk0.tilesVram = 0x6010000;
    a1->unk0[1].unk0.unk14 = 0x440;
    a1->unk0[1].unk0.animId = gUnk_08364F9C[gLanguage][0].animId;
    a1->unk0[1].unk0.variant = gUnk_08364F9C[gLanguage][0].variant;
    a1->unk0[1].unk0.unk16 = 0;
    a1->unk0[1].unk0.unk1B = 0xFF;
    a1->unk0[1].unk0.unk1C = 0x10;
    a1->unk0[1].unk0.palId = 4;
    a1->unk0[1].unk0.x = gUnk_08364C9A[a3][4] >> 2;
    a1->unk0[1].unk0.y = gUnk_08364C9A[a3][5] >> 2;
    a1->unk0[1].unk0.unk8 = 0xC0000;
    a1->unk0[1].unk28 = gUnk_08364C9A[a3][4];
    a1->unk0[1].unk2C = gUnk_08364C9A[a3][5];
    a1->unk0[1].unk30 = 0;
    a1->unk0[1].unk32 = 0;
    a1->unk0[1].unk34 = 0x10;
    a1->unk0[1].unk36 = 0;
    a1->unk0[1].unk3C = NULL;
    a1->unk0[1].unk40 = NULL;
    a1->unk0[1].unk38 = a2;
    if (a3 == 2 || a3 == 3) {
        a1->unk0[0].unk34 |= 1;
        a1->unk0[1].unk34 |= 1;
    }
}

static void sub_0812A5FC(struct Unk_0812A77C_40 *a1, u8 a2) {
    if (a1->unk90 & 1) {
        u32 r6;

        r6 = Rand16();
        r6 &= 0xF;
        a1->unkAD = gUnk_08365114[a2][r6];
        r6 = Rand16();
        r6 &= 3;
        a1->unkAE = gUnk_08365144[a2][r6];
    }
}

void LoadCrackityHackGfx(void) {
    CpuFill32(0, (void *)VRAM, VRAM_SIZE);
    if (gMainFlags & MAIN_FLAG_BG_PALETTE_TRANSFORMATION_ENABLE)
        LoadBgPaletteWithTransformation(gCrackityHackBgPalette, 0, BG_PLTT_SIZE / sizeof(u16));
    else {
        DmaCopy16(3, gCrackityHackBgPalette, gBgPalette, BG_PLTT_SIZE);
        gMainFlags |= MAIN_FLAG_BG_PALETTE_SYNC_ENABLE;
    }
    LZ77UnCompVram(gCrackityHackBgMainTileset, (void *)0x6000000);
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        LZ77UnCompVram(gCrackityHackGameEndedTileset_Japanese, (void *)0x6002000);
        break;
    case LANGUAGE_ENGLISH:
        LZ77UnCompVram(gCrackityHackGameEndedTileset_English, (void *)0x6002000);
        break;
    case LANGUAGE_GERMAN:
        LZ77UnCompVram(gCrackityHackGameEndedTileset_German, (void *)0x6002000);
        break;
    case LANGUAGE_FRENCH:
        LZ77UnCompVram(gCrackityHackGameEndedTileset_French, (void *)0x6002000);
        break;
    case LANGUAGE_SPANISH:
        LZ77UnCompVram(gCrackityHackGameEndedTileset_Spanish, (void *)0x6002000);
        break;
    case LANGUAGE_ITALIAN:
        LZ77UnCompVram(gCrackityHackGameEndedTileset_Italian, (void *)0x6002000);
        break;
    }
    LZ77UnCompVram(gCrackityHackObjTilesetTable[gLanguage], (void *)0x6010000);
}

void sub_0812A77C(void) {
    struct Task *t;
    struct Unk_0812A77C *var;

    gRngVal = 0;
    gDispCnt = DISPCNT_MODE_0 | DISPCNT_OBJ_1D_MAP | DISPCNT_BG0_ON | DISPCNT_BG1_ON | DISPCNT_OBJ_ON;
    gBgCntRegs[0] = BGCNT_PRIORITY(2) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(28);
    gBgCntRegs[1] = BGCNT_PRIORITY(2) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(29);
    gBgCntRegs[2] = BGCNT_PRIORITY(1) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(30);
    gBldRegs.bldCnt = BLDCNT_TGT1_ALL | BLDCNT_EFFECT_LIGHTEN;
    gBldRegs.bldY = 0x10;
    gBgScrollRegs[0][0] = 8;
    gBgScrollRegs[0][1] = 0x58;
    gBgScrollRegs[1][0] = 8;
    gBgScrollRegs[1][1] = 0x58;
    gBgScrollRegs[2][0] = 0;
    gBgScrollRegs[2][1] = 0;
    t = TaskCreate(sub_0812A8F0, sizeof(struct Unk_0812A77C), 0x100, TASK_USE_IWRAM, sub_0812E588);
    var = TaskGetStructPtr(t);
    CpuFill16(0, var, sizeof(struct Unk_0812A77C));
    var->unk14[0] = sub_08128D48(&gUnk_083723C8);
    var->unk14[1] = sub_08128D48(&gUnk_083723D4);
    var->unk14[2] = sub_08128D48(&gUnk_083723E0);
    var->unk14[3] = sub_08128D48(&gUnk_083723EC);
    var->unk14[4] = sub_08128D48(&gUnk_083723F8);
    var->unk14[5] = sub_08128D48(&gUnk_08372404);
    var->unk14[6] = sub_08128D48(&gUnk_08372410);
    var->unk14[7] = sub_08128D48(&gUnk_0837241C);
    var->unk14[8] = sub_08128D48(&gUnk_08372428);
    var->unk14[9] = sub_08128D48(&gUnk_08372434);
    var->unk5F4 = gUnk_0203AD14;
    var->unk10[0] = gUnk_08364CD2[gUnk_0203AD3C][0];
    var->unk10[1] = gUnk_08364CD2[gUnk_0203AD3C][1];
    var->unk10[2] = gUnk_08364CD2[gUnk_0203AD3C][2];
    var->unk10[3] = gUnk_08364CD2[gUnk_0203AD3C][3];
}

static void sub_0812A8F0(void) {
    struct Unk_0812A77C *var;
#ifndef NONMATCHING
    register struct Unk_08128F44_4 *r4 asm("r4");
#else
    struct Unk_08128F44_4 *r4;
#endif

    CreatePauseFade(-0x10, 1);
    var = TaskGetStructPtr(gCurTask);
    gCurTask->main = sub_0812B204;
    var->unk0 = NULL;
    var->unk4 = NULL;
    var->unk8[0] = 0;
    var->unk8[1] = 0;
    var->unk5EC = 0;
    var->unk5F6 = 0;
    sub_0812AAE0(var);
    sub_0812A3F4(&var->unk40[0], var->unk8, 0, var->unk10[0]);
    sub_0812A3F4(&var->unk40[1], var->unk8, 1, var->unk10[1]);
    sub_0812A3F4(&var->unk40[2], var->unk8, 2, var->unk10[2]);
    sub_0812A3F4(&var->unk40[3], var->unk8, 3, var->unk10[3]);
    sub_0812A5FC(&var->unk40[0], var->unk5F4);
    sub_0812A5FC(&var->unk40[1], var->unk5F4);
    sub_0812A5FC(&var->unk40[2], var->unk5F4);
    sub_0812A5FC(&var->unk40[3], var->unk5F4);
    CpuFill32(0, r4 = &var->unk564[0], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x3C0;
    r4->unk0.animId = gUnk_08365054[gLanguage][0].animId;
    r4->unk0.variant = gUnk_08365054[gLanguage][0].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 0xB;
    r4->unk0.x = 0;
    r4->unk0.y = 0x10;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0;
    r4->unk2C = 0x40;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x810;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &var->unk564[1], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x400;
    r4->unk0.animId = gUnk_08365054[gLanguage][0].animId;
    r4->unk0.variant = gUnk_08365054[gLanguage][0].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 0xB;
    r4->unk0.x = 0;
    r4->unk0.y = -0x28;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0;
    r4->unk2C = -0xA0;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x810;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    sub_0812E7A0();
    sub_0812E818(&var->unk40[0]);
    m4aSongNumStart(28);
    m4aSongNumStart(556);
}

static void sub_0812AAE0(struct Unk_0812A77C *a1) {
    u8 i;
    struct Sprite sprites[NUM_LANGUAGES][6];

    for (i = 0; i < 4; ++i) {
        u8 idx = a1->unk10[i];

        SpriteInit(&sprites[0][0], 0x6010000, 0x480,
            gUnk_083650B4[gLanguage][idx].animId,
            gUnk_083650B4[gLanguage][idx].variant,
            0, 0xFF, 0x10, i, 0, 0, 0x80000);
    }
    // This is completely pointless as every case is doing the same thing except for using different buffers
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        SpriteInitNoPointer(&sprites[LANGUAGE_JAPANESE][0], 0x6010000, 0x480, 0x345, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][1], 0x6010000, 0x480, 0x344, 7,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][2], 0x6010000, 0x480, 0x345, 0x12,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][3], 0x6010000, 0x480, 0x343, 0x11,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][4], 0x6010000, 0x480, 0x343, 0,
            0, 0xFF, 0x10, 0xB, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][5], 0x6010000, 0x480, 0x346, 0,
            0, 0xFF, 0x10, 0xC, 0, 0, 0x80000);
        break;
    case LANGUAGE_ENGLISH:
        SpriteInit(&sprites[LANGUAGE_ENGLISH][0], 0x6010000, 0x480, 0x345, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][1], 0x6010000, 0x480, 0x344, 7,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][2], 0x6010000, 0x480, 0x345, 0x12,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][3], 0x6010000, 0x480, 0x343, 0x11,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][4], 0x6010000, 0x480, 0x343, 0,
            0, 0xFF, 0x10, 0xB, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][5], 0x6010000, 0x480, 0x346, 0,
            0, 0xFF, 0x10, 0xC, 0, 0, 0x80000);
        break;
    case LANGUAGE_GERMAN:
        SpriteInit(&sprites[LANGUAGE_GERMAN][0], 0x6010000, 0x480, 0x345, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][1], 0x6010000, 0x480, 0x344, 7,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][2], 0x6010000, 0x480, 0x345, 0x12,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][3], 0x6010000, 0x480, 0x343, 0x11,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][4], 0x6010000, 0x480, 0x343, 0,
            0, 0xFF, 0x10, 0xB, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][5], 0x6010000, 0x480, 0x346, 0,
            0, 0xFF, 0x10, 0xC, 0, 0, 0x80000);
        break;
    case LANGUAGE_FRENCH:
        SpriteInit(&sprites[LANGUAGE_FRENCH][0], 0x6010000, 0x480, 0x345, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][1], 0x6010000, 0x480, 0x344, 7,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][2], 0x6010000, 0x480, 0x345, 0x12,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][3], 0x6010000, 0x480, 0x343, 0x11,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][4], 0x6010000, 0x480, 0x343, 0,
            0, 0xFF, 0x10, 0xB, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][5], 0x6010000, 0x480, 0x346, 0,
            0, 0xFF, 0x10, 0xC, 0, 0, 0x80000);
        break;
    case LANGUAGE_SPANISH:
        SpriteInit(&sprites[LANGUAGE_SPANISH][0], 0x6010000, 0x480, 0x345, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][1], 0x6010000, 0x480, 0x344, 7,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][2], 0x6010000, 0x480, 0x345, 0x12,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][3], 0x6010000, 0x480, 0x343, 0x11,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][4], 0x6010000, 0x480, 0x343, 0,
            0, 0xFF, 0x10, 0xB, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][5], 0x6010000, 0x480, 0x346, 0,
            0, 0xFF, 0x10, 0xC, 0, 0, 0x80000);
        break;
    case LANGUAGE_ITALIAN:
        SpriteInit(&sprites[LANGUAGE_ITALIAN][0], 0x6010000, 0x480, 0x345, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][1], 0x6010000, 0x480, 0x344, 7,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][2], 0x6010000, 0x480, 0x345, 0x12,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][3], 0x6010000, 0x480, 0x343, 0x11,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][4], 0x6010000, 0x480, 0x343, 0,
            0, 0xFF, 0x10, 0xB, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][5], 0x6010000, 0x480, 0x346, 0,
            0, 0xFF, 0x10, 0xC, 0, 0, 0x80000);
        break;
    }
    CpuCopy32(gCrackityHackColosseumBg0Tilemap, (void *)0x600E000, sizeof(gCrackityHackColosseumBg0Tilemap));
    CpuCopy32(gCrackityHackColosseumBg1Tilemap, (void *)0x600E800, sizeof(gCrackityHackColosseumBg1Tilemap));
}

static void sub_0812B204(void) {
    struct Unk_0812A77C *var = TaskGetStructPtr(gCurTask);

    if (var->unk5F2++ > 120) {
        var->unk5F2 = 0;
        gCurTask->main = sub_0812B2F8;
        var->unk40[0].unk0[0].unk2C += 0x18;
        var->unk40[1].unk0[0].unk2C += 0x18;
        var->unk40[2].unk0[0].unk2C += 0x18;
        var->unk40[3].unk0[0].unk2C += 0x18;
        sub_0812E764(&var->unk40[0].unk0[0].unk0, 0);
        sub_0812E764(&var->unk40[1].unk0[0].unk0, 0);
        sub_0812E764(&var->unk40[2].unk0[0].unk0, 0);
        sub_0812E764(&var->unk40[3].unk0[0].unk0, 0);
    }
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    sub_081288DC(&var->unk40[0].unk0[1]);
    sub_081288DC(&var->unk40[1].unk0[1]);
    sub_081288DC(&var->unk40[2].unk0[1]);
    sub_081288DC(&var->unk40[3].unk0[1]);
}

static void sub_0812B2F8(void) {
    struct Unk_0812A77C *var = TaskGetStructPtr(gCurTask);

    if (var->unk5F2++ > 60) {
        var->unk5F2 = 0;
        gCurTask->main = sub_0812B418;
        var->unk0 = sub_0812D4F4();
        var->unk40[0].unk88 = sub_0812D1EC(&var->unk40[0], 0);
        var->unk40[1].unk88 = sub_0812D1EC(&var->unk40[1], 1);
        var->unk40[2].unk88 = sub_0812D1EC(&var->unk40[2], 2);
        var->unk40[3].unk88 = sub_0812D1EC(&var->unk40[3], 3);
        var->unk40[0].unk90 |= 0x10;
        var->unk40[1].unk90 |= 0x10;
        var->unk40[2].unk90 |= 0x10;
        var->unk40[3].unk90 |= 0x10;
        sub_0812D060();
    }
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    sub_081288DC(&var->unk40[0].unk0[1]);
    sub_081288DC(&var->unk40[1].unk0[1]);
    sub_081288DC(&var->unk40[2].unk0[1]);
    sub_081288DC(&var->unk40[3].unk0[1]);
}

static void sub_0812B418(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    struct Unk_08128F44_4 *ptr, *ptr2, *ptr3;

    sub_0812CDD4(var);
    if (sub_0812E6A8(TaskGetStructPtr(var->unk0)) && var->unk0) {
        TaskDestroy(var->unk0);
        var->unk0 = NULL;
        var->unk40[0].unk0[0].unk40 = ptr = &var->unk564[0];
        ptr->unk3C = &var->unk40[0].unk0[0];
        ptr->unk34 &= ~0x10;
        ptr2 = &var->unk40[0].unk0[1];
        ptr2->unk40 = ptr3 = &var->unk564[1];
        ptr3->unk3C = ptr2;
        ptr3->unk34 &= ~0x10;
        sub_0812E764(&var->unk40[0].unk0[0].unk0, 1);
        sub_0812E764(&var->unk40[1].unk0[0].unk0, 1);
        sub_0812E764(&var->unk40[2].unk0[0].unk0, 1);
        sub_0812E764(&var->unk40[3].unk0[0].unk0, 1);
        gCurTask->main = sub_0812B63C;
        TaskDestroy(var->unk40[0].unk88);
        TaskDestroy(var->unk40[1].unk88);
        TaskDestroy(var->unk40[2].unk88);
        TaskDestroy(var->unk40[3].unk88);
        var->unk40[0].unk88 = NULL;
        var->unk40[1].unk88 = NULL;
        var->unk40[2].unk88 = NULL;
        var->unk40[3].unk88 = NULL;
        var->unk40[0].unk90 &= ~0x10;
        var->unk40[1].unk90 &= ~0x10;
        var->unk40[2].unk90 &= ~0x10;
        var->unk40[3].unk90 &= ~0x10;
        var->unk40[0].unk90 |= 0x20;
        var->unk40[1].unk90 |= 0x20;
        var->unk40[2].unk90 |= 0x20;
        var->unk40[3].unk90 |= 0x20;
        var->unk5F0 = 0x10;
        var->unk3C = 0;
        sub_0812E640();
    }
    sub_0812CED8(&var->unk40[0], 0);
    sub_0812CED8(&var->unk40[1], 1);
    sub_0812CED8(&var->unk40[2], 2);
    sub_0812CED8(&var->unk40[3], 3);
    sub_0812D124(var->unk40[0].unk9C, var->unk40[0].unk9E, &var->unk40[0]);
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    sub_081288DC(&var->unk40[0].unk0[1]);
    sub_081288DC(&var->unk40[1].unk0[1]);
    sub_081288DC(&var->unk40[2].unk0[1]);
    sub_081288DC(&var->unk40[3].unk0[1]);
}

static void sub_0812B63C(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    sub_0812CDD4(var);
    if (var->unk40[0].unkA6 & 4 && var->unk564[0].unk34 & 0x200) {
        struct Unk_08128F44_4 *ptr = &var->unk564[0];

        ptr->unk0.animId = gUnk_08365054[gLanguage][1].animId;
        ptr->unk0.variant = gUnk_08365054[gLanguage][1].variant;
        ptr->unk0.unk1B = 0xFF;
        var->unk564[0].unk34 |= 0x800;
    }
    if (var->unk5F0 & 0x20) {
        sub_0812CF80(&var->unk40[0], var);
        sub_0812E604(&var->unk40[1]);
        sub_0812E604(&var->unk40[2]);
        sub_0812E604(&var->unk40[3]);
    }
    if (var->unk5F0 & 0x10) {
        var->unk40[0].unk0[0].unk2C -= 4 * gUnk_08364B5C[0][var->unk3C];
        var->unk40[1].unk0[0].unk2C -= 4 * gUnk_08364B5C[1][var->unk3C];
        var->unk40[2].unk0[0].unk2C -= 4 * gUnk_08364B5C[2][var->unk3C];
        var->unk40[3].unk0[0].unk2C -= 4 * gUnk_08364B5C[3][var->unk3C];
        var->unk8[1] += 4 * gUnk_08364C4C[var->unk3C];
        ++var->unk3C;
        if (var->unk3C > 60) {
            var->unk5F0 &= ~0x10;
            var->unk5F0 |= 0x20;
            sub_0812E764(&var->unk40[0].unk0[0].unk0, 5);
            sub_0812E764(&var->unk40[1].unk0[0].unk0, 5);
            sub_0812E764(&var->unk40[2].unk0[0].unk0, 5);
            sub_0812E764(&var->unk40[3].unk0[0].unk0, 5);
            var->unk3C = 0;
            sub_0812A218(&var->unk564[0]);
            // TODO: typo?
            var->unk564[1].unk30 = 0;
            var->unk564[1].unk32 = 0;
            sub_0812A218(&var->unk564[1]);
            var->unk564[1].unk30 = 0;
            var->unk564[1].unk32 = 0;
            var->unk40[0].unkA8 = var->unk564[0].unk2C;
            var->unk40[1].unkA8 = var->unk564[0].unk2C;
            var->unk40[2].unkA8 = var->unk564[0].unk2C;
            var->unk40[3].unkA8 = var->unk564[0].unk2C;
            var->unk40[0].unkAA = var->unk564[1].unk2C;
            var->unk40[1].unkAA = var->unk564[1].unk2C;
            var->unk40[2].unkAA = var->unk564[1].unk2C;
            var->unk40[3].unkAA = var->unk564[1].unk2C;
            var->unk40[0].unkA6 |= 2;
            var->unk40[1].unkA6 |= 2;
            var->unk40[2].unkA6 |= 2;
            var->unk40[3].unkA6 |= 2;
        }
    }
    else if (var->unk5F0 & 0x20) {
        if (var->unk5EC > 0x29) {
            var->unk564[0].unk32 = 0;
            var->unk40[0].unkA6 &= ~2;
            var->unk40[0].unk0[0].unk2C += 4 * gUnk_08364C88[var->unk3C];
            var->unk40[1].unk0[0].unk2C += 4 * gUnk_08364C88[var->unk3C];
            var->unk40[2].unk0[0].unk2C += 4 * gUnk_08364C88[var->unk3C];
            var->unk40[3].unk0[0].unk2C += 4 * gUnk_08364C88[var->unk3C];
            ++var->unk3C;
        }
        else {
            if (var->unk5EC < 0xF)
                var->unk8[1] -= 0x20;
            ++var->unk5EC;
        }
        if (var->unk40[0].unkA6 & 2)
            var->unk40[0].unkA8 += 0x10;
        if (var->unk40[1].unkA6 & 2)
            var->unk40[1].unkA8 += 0x10;
        if (var->unk40[2].unkA6 & 2)
            var->unk40[2].unkA8 += 0x10;
        if (var->unk40[3].unkA6 & 2)
            var->unk40[3].unkA8 += 0x10;
        var->unk564[0].unk2C = var->unk40[0].unkA8;
        var->unk564[1].unk2C = var->unk40[0].unkAA;
        if (var->unk3C > 8) {
            sub_0812E764(&var->unk40[0].unk0[0].unk0, 2);
            sub_0812E764(&var->unk40[1].unk0[0].unk0, 2);
            sub_0812E764(&var->unk40[2].unk0[0].unk0, 2);
            sub_0812E764(&var->unk40[3].unk0[0].unk0, 2);
        }
        if (var->unk3C > 0x11) {
            u8 i;

            var->unk5F0 &= ~0x20;
            var->unk5F0 |= 0x40;
            for (i = 0; i < 4; ++i) {
                struct Unk_08128F44_4 *ptr = &var->unk40[i].unk0[1];

                ptr->unk0.animId = gUnk_08364F9C[gLanguage][1].animId;
                ptr->unk0.variant = gUnk_08364F9C[gLanguage][1].variant;
                ptr->unk0.unk1B = 0xFF;
            }
            m4aSongNumStart(554);
            var->unk0 = sub_0812EFB4();
            CreatePauseFade(4, 1);
        }
    }
    else if (var->unk5F0 & 0x40) {
        if (!sub_0812A304()) {
            s16 sp04[4];
            bool32 sp10;

            var->unk40[0].unkA4 = var->unk40[0].unk9C;
            var->unk40[1].unkA4 = var->unk40[1].unk9C;
            var->unk40[2].unkA4 = var->unk40[2].unk9C;
            var->unk40[3].unkA4 = var->unk40[3].unk9C;
            if (var->unk40[0].unk90 & 1)
                var->unk40[0].unkA0 = var->unk40[0].unkAE;
            if (var->unk40[1].unk90 & 1)
                var->unk40[1].unkA0 = var->unk40[1].unkAE;
            if (var->unk40[2].unk90 & 1)
                var->unk40[2].unkA0 = var->unk40[2].unkAE;
            if (var->unk40[3].unk90 & 1)
                var->unk40[3].unkA0 = var->unk40[3].unkAE;
            var->unk40[0].unk9C = 8 * (var->unk40[0].unkA4 * var->unk40[0].unkA0 / 0xA + var->unk40[0].unkA4 / 8);
            var->unk40[1].unk9C = 8 * (var->unk40[1].unkA4 * var->unk40[1].unkA0 / 0xA + var->unk40[1].unkA4 / 8);
            var->unk40[2].unk9C = 8 * (var->unk40[2].unkA4 * var->unk40[2].unkA0 / 0xA + var->unk40[2].unkA4 / 8);
            var->unk40[3].unk9C = 8 * (var->unk40[3].unkA4 * var->unk40[3].unkA0 / 0xA + var->unk40[3].unkA4 / 8);
            sp10 = FALSE;
            if (var->unk40[0].unk9C >= 8000)
                sp10 = TRUE;
            sub_0812E468(var);
            CpuCopy32(gCrackityHackUndergroundBg0Tilemap, (void *)0x600E000, sizeof(gCrackityHackUndergroundBg0Tilemap));
            CpuCopy32(gCrackityHackUndergroundBg1Tilemap, (void *)0x600E800, sizeof(gCrackityHackUndergroundBg1Tilemap));
            gDispCnt |= DISPCNT_BG2_ON;
            CpuFill32(0, (void *)0x600F000, 0x400);
            gDispCnt &= ~DISPCNT_WIN0_ON;
            gBgScrollRegs[2][1] = 0;
            gCurTask->main = sub_0812BEE0;
            TaskDestroy(var->unk0);
            var->unk0 = NULL;
            CreatePauseFade(-0x10, 1);
            sp04[0] = var->unk40[0].unk9C;
            sp04[1] = var->unk40[1].unk9C;
            sp04[2] = var->unk40[2].unk9C;
            sp04[3] = var->unk40[3].unk9C;
            if (var->unk40[0].unkAC)
                sp04[0] -= 120;
            if (var->unk40[1].unkAC)
                sp04[1] -= 120;
            if (var->unk40[2].unkAC)
                sp04[2] -= 120;
            if (var->unk40[3].unkAC)
                sp04[3] -= 120;
            var->unk0 = sub_0812DBB4(sp04[0], sp04[1], sp04[2], sp04[3], sp10);
            gBgScrollRegs[0][0] = 8;
            gBgScrollRegs[0][1] = 0x58;
            gBgScrollRegs[1][0] = 8;
            gBgScrollRegs[1][1] = 0x58;
            gBgScrollRegs[2][0] = 0;
            gBgScrollRegs[2][1] = 0;
            var->unk8[0] = 0;
            var->unk8[1] = 0;
        }
    }
    gBgScrollRegs[0][0] = 8 - (var->unk8[0] >> 3);
    gBgScrollRegs[0][1] = 0x58 - (var->unk8[1] >> 3);
    gBgScrollRegs[1][0] = 8 - (var->unk8[0] >> 3) - (var->unk8[0] >> 6);
    gBgScrollRegs[1][1] = 0x58 - (var->unk8[1] >> 3) - (var->unk8[1] >> 6);
    if (var->unk5F0 & 0x40) {
        u16 a = Rand16() & 7, b = Rand16() & 7;

        gBgScrollRegs[0][0] += gUnk_08364CCA[a];
        gBgScrollRegs[0][1] += gUnk_08364CCA[b];
        gBgScrollRegs[1][0] += gUnk_08364CCA[a];
        gBgScrollRegs[1][1] += gUnk_08364CCA[b];
    }
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    sub_081288DC(&var->unk40[0].unk0[1]);
    sub_081288DC(&var->unk40[1].unk0[1]);
    sub_081288DC(&var->unk40[2].unk0[1]);
    sub_081288DC(&var->unk40[3].unk0[1]);
    if (var->unk564[1].unk34 & 0x10) {
        sub_081288DC(&var->unk564[1]);
        sub_081288DC(&var->unk564[0]);
    }
}

static void sub_0812BE74(struct Unk_0812A77C_40 *a1) {
    s32 r2 = abs(a1->unkA8 - a1->unkAA);

    a1->unkA0 = 1;
    if (a1->unkA8 > a1->unkAA) {
        if (r2 > 0x30) return;
        if (r2 > 0x20)
            a1->unkA0 = 2;
        else
            a1->unkA0 = 3;
    }
    else {
        if (r2 == 0)
            a1->unkA0 = 5;
        else if (r2 <= 0x10)
            a1->unkA0 = 4;
        else if (r2 <= 0x20)
            a1->unkA0 = 3;
        else if (r2 <= 0x30)
            a1->unkA0 = 2;
        else
            a1->unkA0 = 1;
    }
}

static void sub_0812BEE0(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (sub_0812E6C8(TaskGetStructPtr(var->unk0))) {
        if (!(var->unk5F0 & 2)) {
            if (var->unk40[0].unk9C >= 8000)
                CreatePauseFade(0x10, 1);
            else if (var->unk40[1].unk9C >= 8000 || var->unk40[2].unk9C >= 8000 || var->unk40[3].unk9C >= 8000)
                CreatePauseFadeSetBldCnt(0x10, 1);
            else
                CreatePauseFade(0x10, 1);
            var->unk5F0 |= 2;
        }
        if (!sub_0812A304()) {
            u32 r2;

            TaskDestroy(var->unk0);
            var->unk0 = NULL;
            var->unk5F0 &= ~2;
            r2 = 0;
            if (var->unk40[0].unk9C >= 8000)
                r2 = 1;
            if (var->unk40[1].unk9C >= 8000)
                ++r2;
            if (var->unk40[2].unk9C >= 8000)
                ++r2;
            if (var->unk40[3].unk9C >= 8000)
                ++r2;
            gDispCnt |= DISPCNT_BG0_ON | DISPCNT_BG1_ON;
            if (r2) {
                var->unk5F2 = 0;
                if (var->unk40[0].unk9C >= 8000) {
                    gDispCnt &= ~DISPCNT_BG2_ON;
                    sub_0812C168(var);
                    if (gUnk_0203AD10 & 2) {
                        gCurTask->main = sub_0812C29C;
                        sub_0812E194(10, 0x10, var->unk40[0].unk9C - 120);
                        sub_0812E194(70, 0x10, var->unk40[1].unk9C - 120);
                        sub_0812E194(130, 0x10, var->unk40[2].unk9C - 120);
                        sub_0812E194(190, 0x10, var->unk40[3].unk9C - 120);
                    }
                    else {
                        gCurTask->main = sub_0812C29C;
                    }
                }
                else {
                    gCurTask->main = sub_0812C29C;
                    sub_0812E194(10, 0x10, var->unk40[0].unk9C - 120);
                    sub_0812E194(70, 0x10, var->unk40[1].unk9C - 120);
                    sub_0812E194(130, 0x10, var->unk40[2].unk9C - 120);
                    sub_0812E194(190, 0x10, var->unk40[3].unk9C - 120);
                }
            }
            else {
                sub_0812C490(var);
                gCurTask->main = sub_0812C63C;
            }
        }
    }
    if (var->unk40[0].unk9C < 8000)
        sub_0812E6E4(0);
}

static inline struct Unk_08128F44_4 *BeYourself(struct Unk_08128F44_4 *a1) { // for matching
    return a1;
}

static void sub_0812C168(struct Unk_0812A77C *a1) {
    u8 i;
    struct Unk_08128F44_4 *var;

    CpuCopy32(gCrackityHackUndergroundBg0CrackingThroughTilemap, (void *)0x600E000, sizeof(gCrackityHackUndergroundBg0CrackingThroughTilemap));
    CpuCopy32(gCrackityHackUndergroundBg1CrackingThroughTilemap, (void *)0x600E800, sizeof(gCrackityHackUndergroundBg1CrackingThroughTilemap));
    gDispCnt &= ~DISPCNT_BG2_ON;
    gBgCntRegs[0] = BGCNT_PRIORITY(2) | BGCNT_TXT256x256 | BGCNT_CHARBASE(1) | BGCNT_SCREENBASE(0x1C);
    gBgCntRegs[1] = BGCNT_PRIORITY(2) | BGCNT_TXT256x256 | BGCNT_CHARBASE(1) | BGCNT_SCREENBASE(0x1D);
    gBgScrollRegs[0][0] = 8;
    gBgScrollRegs[0][1] = 0;
    gBgScrollRegs[1][0] = 8;
    gBgScrollRegs[1][1] = 0;
    gBgScrollRegs[2][0] = 0;
    gBgScrollRegs[2][1] = 0;
    a1->unk5F2 = 0;
    for (i = 0; i < 4; ++i) {
        CpuFill32(0, &a1->unk410[i], sizeof(a1->unk410[i]));
        var = BeYourself(&a1->unk410[i]);
        var->unk0.tilesVram = 0x6010000;
        var->unk0.unk14 = 0x480;
        var->unk0.animId = gUnk_08364FCC[gLanguage].animId;
        var->unk0.variant = gUnk_08364FCC[gLanguage].variant;
        var->unk0.unk16 = 0;
        var->unk0.unk1B = 0xFF;
        var->unk0.unk1C = 0x10;
        var->unk0.palId = 4;
        var->unk0.x = gUnk_08364FE4[i] >> 2;
        var->unk0.y = 0;
        var->unk0.unk8 = 0xC0000;
        var->unk28 = gUnk_08364FE4[i];
        var->unk2C = 0;
        var->unk30 = 0;
        var->unk32 = 0;
        var->unk34 = 0x10;
        var->unk36 = 0;
        var->unk38 = NULL;
        var->unk3C = NULL;
        var->unk40 = NULL;
    }
}

static void sub_0812C29C(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    sub_0812E194(10, 0x10, var->unk40[0].unk9C - 120);
    sub_0812E194(70, 0x10, var->unk40[1].unk9C - 120);
    sub_0812E194(130, 0x10, var->unk40[2].unk9C - 120);
    sub_0812E194(190, 0x10, var->unk40[3].unk9C - 120);
    if (!(var->unk5F0 & 2) && !sub_0812A304()) {
        if (var->unk40[0].unk9C >= 8000) {
            CreatePauseFade(-0x10, 1);
            m4aSongNumStart(561);
        }
        else {
            CreatePauseFadeSetBldCnt(-0x10, 1);
        }
        var->unk5F0 |= 2;
    }
    if (var->unk5F2 > 120) {
        if (!sub_0812A304()) {
            var->unk5F0 &= ~2;
            gDispCnt &= ~DISPCNT_BG2_ON;
            gBgCntRegs[0] = BGCNT_PRIORITY(2) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(0x1C);
            gBgCntRegs[1] = BGCNT_PRIORITY(2) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(0x1D);
            sub_0812C490(var);
            gCurTask->main = sub_0812C63C;
        }
    }
    else {
        if (var->unk5F2 == 120) {
            CreatePauseFade(0x10, 1);
            ++var->unk5F2;
        }
        else {
            ++var->unk5F2;
        }
    }
    if (var->unk5F2 == 30)
        m4aSongNumStart(561);
    if (var->unk5F2 > 30) {
        if (var->unk40[0].unk9C >= 8000) {
            sub_081288DC(var->unk410);
            if (var->unk40[1].unk9C >= 8000)
                sub_081288DC(&var->unk410[1]);
            if (var->unk40[2].unk9C >= 8000)
                sub_081288DC(&var->unk410[2]);
            if (var->unk40[3].unk9C >= 8000)
                sub_081288DC(&var->unk410[3]);
        }
    }
    if (var->unk40[0].unk9C < 8000)
        sub_0812E6E4(0);
}

static void sub_0812C490(struct Unk_0812A77C *a1) {
    CpuCopy32(gCrackityHackColosseumBg0Tilemap, (void *)0x600E000, sizeof(gCrackityHackColosseumBg0Tilemap));
    CpuCopy32(gCrackityHackColosseumBg1Tilemap, (void *)0x600E800, sizeof(gCrackityHackColosseumBg1Tilemap));
    gDispCnt &= ~DISPCNT_BG2_ON;
    sub_0812C528(&a1->unk40[0], 0);
    sub_0812C528(&a1->unk40[1], 1);
    sub_0812C528(&a1->unk40[2], 2);
    sub_0812C528(&a1->unk40[3], 3);
    gBgScrollRegs[0][0] = 8;
    gBgScrollRegs[0][1] = 0x58;
    gBgScrollRegs[1][0] = 8;
    gBgScrollRegs[1][1] = 0x58;
    gBgScrollRegs[2][0] = 0;
    gBgScrollRegs[2][1] = 0;
    a1->unk5F2 = 30;
}

static void sub_0812C528(struct Unk_0812A77C_40 *a1, u8 a2) {
    if (a1->unkAC) {
        sub_0812E764(&a1->unk0[0].unk0, 4);
        switch (a2) {
        case 0:
            a1->unk0[0].unk28 = 120;
            a1->unk0[0].unk2C = 0x228;
            break;
        case 1:
            a1->unk0[0].unk28 = 360;
            a1->unk0[0].unk2C = 0x228;
            break;
        case 2:
            a1->unk0[0].unk28 = 600;
            a1->unk0[0].unk2C = 0x228;
            break;
        case 3:
            a1->unk0[0].unk28 = 840;
            a1->unk0[0].unk2C = 0x228;
            break;
        }
    }
    else {
        sub_0812E764(&a1->unk0[0].unk0, 3);
        switch (a2) {
        case 0:
            a1->unk0[0].unk28 = 120;
            a1->unk0[0].unk2C = 0x1A8;
            break;
        case 1:
            a1->unk0[0].unk28 = 360;
            a1->unk0[0].unk2C = 0x1A8;
            break;
        case 2:
            a1->unk0[0].unk28 = 600;
            a1->unk0[0].unk2C = 0x1A8;
            break;
        case 3:
            a1->unk0[0].unk28 = 840;
            a1->unk0[0].unk2C = 0x1A8;
            break;
        }
    }
    a1->unk0[1].unk0.palId = 6;
    switch (gLanguage) { // all the same
    case LANGUAGE_JAPANESE:
        a1->unk0[1].unk0.animId = 0x345;
        a1->unk0[1].unk0.variant = 0x12;
        a1->unk0[1].unk0.unk1B = 0xFF;
        break;
    case LANGUAGE_ENGLISH:
        a1->unk0[1].unk0.animId = 0x345;
        a1->unk0[1].unk0.variant = 0x12;
        a1->unk0[1].unk0.unk1B = 0xFF;
        break;
    case LANGUAGE_GERMAN:
        a1->unk0[1].unk0.animId = 0x345;
        a1->unk0[1].unk0.variant = 0x12;
        a1->unk0[1].unk0.unk1B = 0xFF;
        break;
    case LANGUAGE_FRENCH:
        a1->unk0[1].unk0.animId = 0x345;
        a1->unk0[1].unk0.variant = 0x12;
        a1->unk0[1].unk0.unk1B = 0xFF;
        break;
    case LANGUAGE_SPANISH:
        a1->unk0[1].unk0.animId = 0x345;
        a1->unk0[1].unk0.variant = 0x12;
        a1->unk0[1].unk0.unk1B = 0xFF;
        break;
    case LANGUAGE_ITALIAN:
        a1->unk0[1].unk0.animId = 0x345;
        a1->unk0[1].unk0.variant = 0x12;
        a1->unk0[1].unk0.unk1B = 0xFF;
        break;
    }
    switch (a2) { // all the same
    case 0:
        a1->unk0[1].unk2C = 0x248;
        break;
    case 1:
        a1->unk0[1].unk2C = 0x248;
        break;
    case 2:
        a1->unk0[1].unk2C = 0x248;
        break;
    case 3:
        a1->unk0[1].unk2C = 0x248;
        break;
    }
}

static void sub_0812C63C(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (!sub_0812A304()) {
        CreatePauseFade(-8, 1);
        gCurTask->main = sub_0812C814;
        var->unk5F0 |= 2;
        var->unk40[0].unk8C = sub_0812EFFC(120, 4);
        var->unk40[1].unk8C = sub_0812EFFC(360, 4);
        var->unk40[2].unk8C = sub_0812EFFC(600, 4);
        var->unk40[3].unk8C = sub_0812EFFC(840, 4);
    }
    if (!var->unk40[0].unkAC) {
        if (var->unk40[0].unk9C >= 8000)
            m4aSongNumStart(34);
        else
            m4aSongNumStart(19);
    }
    else {
        m4aSongNumStart(32);
    }
    sub_0812E194(10, 0x10, var->unk40[0].unk9C - 120);
    sub_0812E194(70, 0x10, var->unk40[1].unk9C - 120);
    sub_0812E194(130, 0x10, var->unk40[2].unk9C - 120);
    sub_0812E194(190, 0x10, var->unk40[3].unk9C - 120);
    sub_0812E0C8(30, 0x30, var->unk40[0].unkAC);
    sub_0812E0C8(90, 0x30, var->unk40[1].unkAC);
    sub_0812E0C8(150, 0x30, var->unk40[2].unkAC);
    sub_0812E0C8(210, 0x30, var->unk40[3].unkAC);
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    if (!var->unk40[0].unkAC)
        sub_081288DC(&var->unk40[0].unk0[1]);
    if (!var->unk40[1].unkAC)
        sub_081288DC(&var->unk40[1].unk0[1]);
    if (!var->unk40[2].unkAC)
        sub_081288DC(&var->unk40[2].unk0[1]);
    if (!var->unk40[3].unkAC)
        sub_081288DC(&var->unk40[3].unk0[1]);
}

static void sub_0812C814(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (!sub_0812A304()) {
        if (!var->unk4) {
            u16 unk = gUnk_0203AD10 & 2 ? gUnk_020382D0.unk8[1][0] : gPressedKeys;

            if (unk & 1) {
                if (gUnk_0203AD3C)
                    var->unk4 = sub_08128F44(gUnk_08364ACC[gLanguage], 0xD, 0xE, 0x50, 0x32, 1);
                else
                    var->unk4 = sub_08128F44(gUnk_08364ACC[gLanguage], 0xD, 0xE, 0x50, 0x32, 0);
            }
        }
        else {
            struct Unk_08128F44 *var2 = TaskGetStructPtr(var->unk4);

            if (sub_0812A328(var2)) {
                TaskDestroy(var->unk40[0].unk8C);
                TaskDestroy(var->unk40[1].unk8C);
                TaskDestroy(var->unk40[2].unk8C);
                TaskDestroy(var->unk40[3].unk8C);
                CreatePauseFade(4, 1);
                var->unk5F4 = var2->unk2AD;
                if (var2->unk2AC & 0x10)
                    gCurTask->main = sub_0812CA84;
                else
                    gCurTask->main = sub_0812CBDC;
            }
        }
    }
    sub_0812E194(10, 0x10, var->unk40[0].unk9C - 120);
    sub_0812E194(70, 0x10, var->unk40[1].unk9C - 120);
    sub_0812E194(130, 0x10, var->unk40[2].unk9C - 120);
    sub_0812E194(190, 0x10, var->unk40[3].unk9C - 120);
    sub_0812E0C8(30, 0x30, var->unk40[0].unkAC);
    sub_0812E0C8(90, 0x30, var->unk40[1].unkAC);
    sub_0812E0C8(150, 0x30, var->unk40[2].unkAC);
    sub_0812E0C8(210, 0x30, var->unk40[3].unkAC);
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    if (!var->unk40[0].unkAC)
        sub_081288DC(&var->unk40[0].unk0[1]);
    if (!var->unk40[1].unkAC)
        sub_081288DC(&var->unk40[1].unk0[1]);
    if (!var->unk40[2].unkAC)
        sub_081288DC(&var->unk40[2].unk0[1]);
    if (!var->unk40[3].unkAC)
        sub_081288DC(&var->unk40[3].unk0[1]);
}

static void sub_0812CA84(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (!sub_0812A304()) {
        m4aMPlayAllStop();
        gCurTask->main = sub_0812A8F0;
        TaskDestroy(var->unk4);
        var->unk4 = NULL;
    }
    sub_0812E194(10, 0x10, var->unk40[0].unk9C - 120);
    sub_0812E194(70, 0x10, var->unk40[1].unk9C - 120);
    sub_0812E194(130, 0x10, var->unk40[2].unk9C - 120);
    sub_0812E194(190, 0x10, var->unk40[3].unk9C - 120);
    sub_0812E0C8(30, 0x30, var->unk40[0].unkAC);
    sub_0812E0C8(90, 0x30, var->unk40[1].unkAC);
    sub_0812E0C8(150, 0x30, var->unk40[2].unkAC);
    sub_0812E0C8(210, 0x30, var->unk40[3].unkAC);
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    if (!var->unk40[0].unkAC)
        sub_081288DC(&var->unk40[0].unk0[1]);
    if (!var->unk40[1].unkAC)
        sub_081288DC(&var->unk40[1].unk0[1]);
    if (!var->unk40[2].unkAC)
        sub_081288DC(&var->unk40[2].unk0[1]);
    if (!var->unk40[3].unkAC)
        sub_081288DC(&var->unk40[3].unk0[1]);
}

static void sub_0812CBDC(void) {
    struct Unk_0812A77C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (!sub_0812A304()) {
        TaskDestroy(var->unk4);
        var->unk4 = NULL;
        if (gUnk_0203AD10 & 2)
            gUnk_020382D0.unk4 &= ~2;
        var->unk5F6 = 0;
        gCurTask->main = sub_0812E51C;
    }
    sub_0812E194(10, 0x10, var->unk40[0].unk9C - 120);
    sub_0812E194(70, 0x10, var->unk40[1].unk9C - 120);
    sub_0812E194(130, 0x10, var->unk40[2].unk9C - 120);
    sub_0812E194(190, 0x10, var->unk40[3].unk9C - 120);
    sub_0812E0C8(30, 0x30, var->unk40[0].unkAC);
    sub_0812E0C8(90, 0x30, var->unk40[1].unkAC);
    sub_0812E0C8(150, 0x30, var->unk40[2].unkAC);
    sub_0812E0C8(210, 0x30, var->unk40[3].unkAC);
    sub_081288DC(&var->unk40[0].unk0[0]);
    sub_081288DC(&var->unk40[1].unk0[0]);
    sub_081288DC(&var->unk40[2].unk0[0]);
    sub_081288DC(&var->unk40[3].unk0[0]);
    if (!var->unk40[0].unkAC)
        sub_081288DC(&var->unk40[0].unk0[1]);
    if (!var->unk40[1].unkAC)
        sub_081288DC(&var->unk40[1].unk0[1]);
    if (!var->unk40[2].unkAC)
        sub_081288DC(&var->unk40[2].unk0[1]);
    if (!var->unk40[3].unkAC)
        sub_081288DC(&var->unk40[3].unk0[1]);
}

static bool32 sub_0812CD5C(struct Unk_0812A77C_40 *a1, u8 a2) {
    bool32 ret = FALSE;
    u16 r = Rand16() & 0xF;

    if (a1->unk90 & 0x10) {
        if (a1->unk9E == a1->unkAD) {
            a1->unkAD = gUnk_08365114[a2][r];
            ret = TRUE;
        }
    }
    else if (a1->unk90 & 0x20) {
        a1->unk90 &= ~0x20;
    }
    return ret;
}

static void sub_0812CDD4(struct Unk_0812A77C *a1) {
    u8 i;

    for (i = 0; i < 4; ++i) {
        u8 unk = a1->unk10[i];

        if (a1->unk40[i].unk90 & 1) {
            a1->unk40[i].unk98 = a1->unk40[i].unk96;
            a1->unk40[i].unk96 = sub_0812CD5C(&a1->unk40[i], a1->unk5F4);
            a1->unk40[i].unk98 = a1->unk40[i].unk98; // required for matching
            a1->unk40[i].unk94 = (a1->unk40[i].unk98 ^ a1->unk40[i].unk96) & a1->unk40[i].unk96;
            a1->unk40[i].unk9A = 0;
        }
        else if (gUnk_0203AD10 & 2) {
            a1->unk40[i].unk98 = a1->unk40[i].unk96;
            a1->unk40[i].unk96 = gUnk_020382D0.unk8[0][unk];
            a1->unk40[i].unk94 = gUnk_020382D0.unk8[1][unk];
            a1->unk40[i].unk9A = gUnk_020382D0.unk8[2][unk];
        }
        else {
            a1->unk40[i].unk98 = gPrevInput;
            a1->unk40[i].unk96 = gInput;
            a1->unk40[i].unk94 = gPressedKeys;
            a1->unk40[i].unk9A = gReleasedKeys;
        }
    }
}

static void sub_0812CED8(struct Unk_0812A77C_40 *a1, u8 a2 __attribute__((unused))) {
    if (a1->unk92) {
        if (--a1->unk92 < 2)
            a1->unk9E = 0;
    }
    else {
        if (a1->unk94 & 1) {
            a1->unk9C += 0xA * a1->unk9E;
            if (a1->unk9C > 0x640)
                a1->unk9C = 0x640;
            a1->unk92 = 0x2D;
            a1->unkA6 |= 0x10;
        }
        if (a1->unkA6 & 1) {
            if (--a1->unk9E < 1)
                a1->unkA6 ^= 1;
        }
        else {
            if (++a1->unk9E > 0x28)
                a1->unkA6 ^= 1;
        }
    }
}

static void sub_0812CF80(struct Unk_0812A77C_40 *a1, struct Unk_0812A77C *a2) {
    if (a1->unkA6 & 2 && a1->unk94 & 1) {
        sub_0812BE74(a1);
        if (a1->unkA0 == 5)
            m4aSongNumStart(553);
        else
            m4aSongNumStart(552);
        a2->unk564[0].unk34 &= ~0x800;
        a1->unkA6 |= 4;
        a1->unkA6 &= ~2;
        if (a2->unk564[0].unk2C != a2->unk564[1].unk2C) {
            struct Sprite *sprite = &a2->unk564[0].unk0;

            sprite->animId = gUnk_08365054[gLanguage][2].animId;
            sprite->variant = gUnk_08365054[gLanguage][2].variant;
            sprite->unk1B = 0xFF;
        }
        else {
            struct Sprite *sprite = &a2->unk564[0].unk0;

            sprite->animId = gUnk_08365054[gLanguage][3].animId;
            sprite->variant = gUnk_08365054[gLanguage][3].variant;
            sprite->unk1B = 0xFF;
        }
    }
}

static void sub_0812D060(void) {
    gBgCntRegs[2] = BGCNT_PRIORITY(1) | BGCNT_TXT256x256 | BGCNT_CHARBASE(3) | BGCNT_SCREENBASE(30);
    gBgScrollRegs[2][0] = 0;
    gBgScrollRegs[2][1] = -0x46;
    gDispCnt |= DISPCNT_WIN0_ON | DISPCNT_BG2_ON;
    gWinRegs[0] = WIN_RANGE(0x10, 0x18);
    gWinRegs[2] = WIN_RANGE(0x10, 0x38);
    gWinRegs[4] = WIN_RANGE(0, 4);
    gWinRegs[5] = WIN_RANGE(0, 0x3B);
    CpuFill32(0x22222222, (void *)0x600C000, 0x20);
    CpuFill32(0x11111111, (void *)0x600C020, 0x20);
    DmaFill32(3, 0xF001F001, (void *)0x600F000, 0x400);
    DmaFill32(3, 0xF000F000, (void *)0x600F400, 0x400);
}

static void sub_0812D124(s16 a1, s16 a2, struct Unk_0812A77C_40 *a3) {
    u8 r4 = a1 / 100;

    if (r4 > 0x10) r4 = 0x10;
    gBgScrollRegs[2][1] = a2 - 0x38;
    if (a2 > 0x27) r4 = 0x11;
    if (a3->unk94 & 1 && a3->unkA6 & 0x10) {
        a3->unkA6 &= ~0x10;
        if (a2 > 0x27)
            m4aSongNumStart(553);
        else
            m4aSongNumStart(552);
    }
    if (gMainFlags & MAIN_FLAG_BG_PALETTE_TRANSFORMATION_ENABLE)
        LoadBgPaletteWithTransformation(gUnk_0836535C + r4, 0xF1, 1);
    else {
        DmaCopy16(3, gUnk_0836535C + r4, gBgPalette + 0xF1, 1 * sizeof(u16));
        gMainFlags |= MAIN_FLAG_BG_PALETTE_SYNC_ENABLE;
    }
}

static struct Task *sub_0812D1EC(struct Unk_0812A77C_40 *a1, u8 a2) {
    struct Task *t = TaskCreate(sub_0812D3AC, sizeof(struct Unk_0812D1EC), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC *tmp = TaskGetStructPtr(t), *var = tmp;

    var->unk0.unk0 = a1->unk0;
    var->unk0.unk50 = 0;
    var->unk0.unk52 = 2;
    var->unk0.unk48 = 0;
    var->unk0.unk4C = 0;
    if (var->unk0.unk52 & 2) {
        ({ CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x4C0;
        var->unk0.unk4.unk0.animId = gUnk_08364D8C[gLanguage][0].animId;
        var->unk0.unk4.unk0.variant = gUnk_08364D8C[gLanguage][0].variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = (var->unk0.unk48 + var->unk0.unk0[0].unk28) >> 2;
        var->unk0.unk4.unk0.y = (var->unk0.unk4C + var->unk0.unk0[0].unk2C) >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48 + var->unk0.unk0[0].unk28;
        var->unk0.unk4.unk2C = var->unk0.unk4C + var->unk0.unk0[0].unk2C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4));
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x4C0;
        var->unk0.unk4.unk0.animId = gUnk_08364D8C[gLanguage][0].animId;
        var->unk0.unk4.unk0.variant = gUnk_08364D8C[gLanguage][0].variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = var->unk0.unk48 >> 2;
        var->unk0.unk4.unk0.y = var->unk0.unk4C >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48;
        var->unk0.unk4.unk2C = var->unk0.unk4C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    var->unk0.unk4.unk38 = a1->unk0[0].unk38;
    if (a2 == 2 || a2 == 3) {
        var->unk0.unk4.unk34 |= 1;
    }
    var->unk54 = a1;
    var->unk58 = 0;
    var->unk59 = 0;
    return t;
}

static void sub_0812D3AC(void) {
    struct Unk_0812D1EC *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 r3;

    if (var->unk54->unk9C >= 1500) {
        var->unk59 |= 2;
        r3 = 2;
    }
    else if (var->unk54->unk9C >= 1000)
        r3 = 2;
    else if (var->unk54->unk9C >= 500)
        r3 = 1;
    else
        r3 = 0;
    if (var->unk59 & 1) {
        if (var->unk0.unk4.unk34 & 0x200) {
            var->unk0.unk4.unk34 |= 0x800;
            var->unk59 &= ~1;
            var->unk0.unk4.unk0.animId = gUnk_08364D8C[gLanguage][2 * var->unk58 + 1].animId;
            var->unk0.unk4.unk0.variant = gUnk_08364D8C[gLanguage][2 * var->unk58 + 1].variant;
            var->unk0.unk4.unk0.unk1B = 0xFF;
        }
    }
    else {
        if (var->unk58 < r3) {
            var->unk59 |= 1;
            var->unk58 = r3;
            var->unk0.unk4.unk0.animId = gUnk_08364D8C[gLanguage][2 * var->unk58].animId;
            var->unk0.unk4.unk0.variant = gUnk_08364D8C[gLanguage][2 * var->unk58].variant;
            var->unk0.unk4.unk0.unk1B = 0xFF;
            var->unk0.unk4.unk34 &= ~0x800;
        }
    }
    sub_0812A2C0(&var->unk0);
}

static struct Task *sub_0812D4F4(void) {
    struct Task *t = TaskCreate(sub_0812D988, sizeof(struct Unk_0812D4F4), 0x100, TASK_USE_IWRAM, nullsub_31);
    struct Unk_0812D4F4 *var = TaskGetStructPtr(t);
#ifndef NONMATCHING
    register struct Unk_08128F44_4 *r4 asm("r4"), *r6; // probably the same issue as sub_08128F44
#else
    struct Unk_08128F44_4 *r4, *r6;
#endif

    var->unk110 = 1;
    var->unk111 = 0;
    var->unk112 = 0;
    var->unk113 = 0;
    var->unk114 = 0;
    CpuFill32(0, &var->unk0[0], sizeof(struct Unk_08128F44_4));
    var->unk0[0].unk0.tilesVram = 0x6010000;
    var->unk0[0].unk0.unk14 = 0x340;
    var->unk0[0].unk0.animId = gUnk_08364E1C[gLanguage][var->unk110].animId;
    var->unk0[0].unk0.variant = gUnk_08364E1C[gLanguage][var->unk110].variant;
    var->unk0[0].unk0.unk16 = 0;
    var->unk0[0].unk0.unk1B = 0xFF;
    var->unk0[0].unk0.unk1C = 0x10;
    var->unk0[0].unk0.palId = 0xC;
    var->unk0[0].unk0.x = 0x68;
    var->unk0[0].unk0.y = 0x10;
    var->unk0[0].unk0.unk8 = 0xC0000;
    var->unk0[0].unk28 = 0x1A0;
    var->unk0[0].unk2C = 0x40;
    var->unk0[0].unk30 = 0;
    var->unk0[0].unk32 = 0;
    var->unk0[0].unk34 = 0x10;
    var->unk0[0].unk36 = 0;
    var->unk0[0].unk38 = NULL;
    var->unk0[0].unk3C = NULL;
    var->unk0[0].unk40 = NULL;
    CpuFill32(0, &var->unk0[1], sizeof(struct Unk_08128F44_4));
    var->unk0[1].unk0.tilesVram = 0x6010000;
    var->unk0[1].unk0.unk14 = 0x340;
    var->unk0[1].unk0.animId = gUnk_08364E1C[gLanguage][var->unk111].animId;
    var->unk0[1].unk0.variant = gUnk_08364E1C[gLanguage][var->unk111].variant;
    var->unk0[1].unk0.unk16 = 0;
    var->unk0[1].unk0.unk1B = 0xFF;
    var->unk0[1].unk0.unk1C = 0x10;
    var->unk0[1].unk0.palId = 0xC;
    var->unk0[1].unk0.x = 0x74;
    var->unk0[1].unk0.y = 0x10;
    var->unk0[1].unk0.unk8 = 0xC0000;
    var->unk0[1].unk28 = 0x1D0;
    var->unk0[1].unk2C = 0x40;
    var->unk0[1].unk30 = 0;
    var->unk0[1].unk32 = 0;
    var->unk0[1].unk34 = 0x10;
    var->unk0[1].unk36 = 0;
    var->unk0[1].unk38 = NULL;
    var->unk0[1].unk3C = NULL;
    var->unk0[1].unk40 = NULL;
    CpuFill32(0, r4 = &var->unk0[2], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x340;
    r4->unk0.animId = gUnk_08364E1C[gLanguage][0xA].animId;
    r4->unk0.variant = gUnk_08364E1C[gLanguage][0xA].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 0xC;
    r4->unk0.x = 0x7E;
    r4->unk0.y = 0x10;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x1F8;
    r4->unk2C = 0x40;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &var->unk0[3], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x340;
    r4->unk0.animId = gUnk_08364E1C[gLanguage][var->unk112].animId;
    r4->unk0.variant = gUnk_08364E1C[gLanguage][var->unk112].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 0xC;
    r4->unk0.x = 0x8C;
    r4->unk0.y = 0x10;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x230;
    r4->unk2C = 0x40;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &var->unk118[0], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_08364F3C[gLanguage][3].animId;
    r4->unk0.variant = gUnk_08364F3C[gLanguage][3].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 0xB;
    r4->unk0.x = 0x7A;
    r4->unk0.y = 0x10;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x1E8;
    r4->unk2C = 0x40;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &var->unk118[3], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_08364F3C[gLanguage][2].animId;
    r4->unk0.variant = gUnk_08364F3C[gLanguage][2].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 0xB;
    r4->unk0.x = 0x10;
    r4->unk0.y = 0x10;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x40;
    r4->unk2C = 0x40;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &var->unk118[1], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_08364F3C[gLanguage][0].animId;
    r4->unk0.variant = gUnk_08364F3C[gLanguage][0].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 0xB;
    r4->unk0.x = 0x30;
    r4->unk0.y = 0x12;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0xC0;
    r4->unk2C = 0x48;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x810;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r6 = &var->unk118[2], sizeof(struct Unk_08128F44_4));
    r6->unk0.tilesVram = 0x6010000;
    r6->unk0.unk14 = 0x480;
    r6->unk0.animId = gUnk_08364F3C[gLanguage][1].animId;
    r6->unk0.variant = gUnk_08364F3C[gLanguage][1].variant;
    r6->unk0.unk16 = 0;
    r6->unk0.unk1B = 0xFF;
    r6->unk0.unk1C = 0x10;
    r6->unk0.palId = 0xB;
    r6->unk0.x = 0x20;
    r6->unk0.y = 0x12;
    r6->unk0.unk8 = 0xC0000;
    r6->unk28 = 0x80;
    r6->unk2C = 0x48;
    r6->unk30 = 0;
    r6->unk32 = 0;
    r6->unk34 = 0x10;
    r6->unk36 = 0;
    r6->unk38 = NULL;
    r6->unk3C = NULL;
    r6->unk40 = NULL;
    return t;
}

static void sub_0812D988(void) {
    struct Unk_0812D4F4 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    struct Unk_08128F44_4 *r4;

    if (var->unk113++ > 1) {
        var->unk113 = 0;
        if (var->unk112-- < 1) {
            var->unk112 = 9;
            if (var->unk111-- < 1) {
                var->unk111 = 9;
                if (var->unk110-- < 1) {
                    var->unk110 = 0;
                    var->unk111 = 0;
                    var->unk112 = 0;
                    var->unk113 = 0xA;
                    gCurTask->main = sub_0812DB2C;
                }
            }
        }
    }
    var->unk0[0].unk0.animId = gUnk_08364E1C[gLanguage][var->unk110].animId;
    var->unk0[0].unk0.variant = gUnk_08364E1C[gLanguage][var->unk110].variant;
    var->unk0[0].unk0.unk1B = 0xFF;
    var->unk0[1].unk0.animId = gUnk_08364E1C[gLanguage][var->unk111].animId;
    var->unk0[1].unk0.variant = gUnk_08364E1C[gLanguage][var->unk111].variant;
    var->unk0[1].unk0.unk1B = 0xFF;
    r4 = &var->unk0[3];
    r4->unk0.animId = gUnk_08364E1C[gLanguage][var->unk112].animId;
    r4->unk0.variant = gUnk_08364E1C[gLanguage][var->unk112].variant;
    r4->unk0.unk1B = 0xFF;
    sub_081288DC(&var->unk0[0]);
    sub_081288DC(&var->unk0[1]);
    sub_081288DC(&var->unk0[2]);
    sub_081288DC(&var->unk0[3]);
    sub_081288DC(&var->unk118[0]);
    sub_081288DC(&var->unk118[1]);
    sub_081288DC(&var->unk118[2]);
    sub_081288DC(&var->unk118[3]);
}

static void sub_0812DB2C(void) {
    struct Unk_0812D4F4 *var = TaskGetStructPtr(gCurTask);

    if (!var->unk113--)
        var->unk114 |= 2;
    sub_081288DC(&var->unk0[0]);
    sub_081288DC(&var->unk0[1]);
    sub_081288DC(&var->unk0[2]);
    sub_081288DC(&var->unk0[3]);
    sub_081288DC(&var->unk118[0]);
    sub_081288DC(&var->unk118[3]);
}

static struct Task *sub_0812DBB4(s16 a1, s16 a2, s16 a3, s16 a4, bool8 a5) {
    struct Task *t = TaskCreate(sub_0812DC90, sizeof(struct Unk_0812DBB4), 0x100, TASK_USE_IWRAM, nullsub_32);
    struct Unk_0812DBB4 *var = TaskGetStructPtr(t);
    s16 max = 0; // intialization for matching

    max = max(max(max(a4, a3), a2), a1);
    var->unk20 = max;
    var->unk20 -= 120;
    var->unk22 = 0;
    var->unk24 = 0;
    var->unk26 = 1;
    var->unk28 = 0;
    var->unk0[0].unk0 = a1;
    var->unk0[0].unk2 = 0;
    var->unk0[0].unk4 = 0;
    var->unk0[1].unk0 = a2;
    var->unk0[1].unk2 = 0;
    var->unk0[1].unk4 = 0;
    var->unk0[2].unk0 = a3;
    var->unk0[2].unk2 = 0;
    var->unk0[2].unk4 = 0;
    var->unk0[3].unk0 = a4;
    var->unk0[3].unk2 = 0;
    var->unk0[3].unk4 = 0;
    if (a5) var->unk24 |= 0x10;
    return t;
}

static void sub_0812DC90(void) {
    struct Unk_0812DBB4 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    s16 v;

    var->unk26 = (var->unk20 - var->unk22) >> 6;
    if (var->unk26 > 0x10) {
        var->unk26 = 0x10;
        gDispCnt &= ~DISPCNT_BG0_ON;
    }
    else {
        gDispCnt |= DISPCNT_BG0_ON;
    }
    if (!var->unk26) {
        if (var->unk20 != var->unk22)
            var->unk26 = 1;
        else
            var->unk24 |= 0x20;
    }
    gBgScrollRegs[0][1] += var->unk26;
    gBgScrollRegs[1][1] += var->unk26;
    var->unk22 += var->unk26;
    gBgScrollRegs[2][1] += var->unk26;
    if (gBgScrollRegs[2][1] > 0x17) {
        gBgScrollRegs[2][1] = 0;
        if (var->unk26) {
            if (gDispCnt & DISPCNT_BG0_ON)
                m4aSongNumStart(561);
            else
                m4aSongNumStart(560);
        }
        v = (var->unk0[0].unk0 - var->unk0[0].unk2) >> 3;
        if (v >= 0x14)
            var->unk0[0].unk4 = 0x14;
        else
            var->unk0[0].unk4 = v;
        v = (var->unk0[1].unk0 - var->unk0[1].unk2) >> 3;
        if (v >= 0x14)
            var->unk0[1].unk4 = 0x14;
        else
            var->unk0[1].unk4 = v;
        v = (var->unk0[2].unk0 - var->unk0[2].unk2) >> 3;
        if (v >= 0x14)
            var->unk0[2].unk4 = 0x14;
        else
            var->unk0[2].unk4 = v;
        v = (var->unk0[3].unk0 - var->unk0[3].unk2) >> 3;
        if (v >= 0x14)
            var->unk0[3].unk4 = 0x14;
        else
            var->unk0[3].unk4 = v;
    }
    sub_0812E6E4(var->unk26);
    if (var->unk0[0].unk0 <= var->unk0[0].unk2 + var->unk26) {
        var->unk0[0].unk4 = 0;
        var->unk0[0].unk2 = var->unk0[0].unk0;
    }
    else {
        var->unk0[0].unk2 += var->unk26;
    }
    if (var->unk0[1].unk0 < var->unk0[1].unk2 + var->unk26) {
        var->unk0[1].unk4 = 0;
        var->unk0[1].unk2 = var->unk0[1].unk0;
    }
    else {
        var->unk0[1].unk2 += var->unk26;
    }
    if (var->unk0[2].unk0 < var->unk0[2].unk2 + var->unk26) {
        var->unk0[2].unk4 = 0;
        var->unk0[2].unk2 = var->unk0[2].unk0;
    }
    else {
        var->unk0[2].unk2 += var->unk26;
    }
    if (var->unk0[3].unk0 <= var->unk0[3].unk2 + var->unk26) {
        var->unk0[3].unk4 = 0;
        var->unk0[3].unk2 = var->unk0[3].unk0;
    }
    else {
        var->unk0[3].unk2 += var->unk26;
    }
    gUnk_03000530 = var;
    gUnk_03002470[gUnk_03006070++] = CrackityHackDrawCracks;
    gMainFlags |= 0x10;
    sub_0812E194(10, 0x10, var->unk0[0].unk2);
    sub_0812E194(70, 0x10, var->unk0[1].unk2);
    sub_0812E194(130, 0x10, var->unk0[2].unk2);
    sub_0812E194(190, 0x10, var->unk0[3].unk2);
    if (var->unk24 & 1) return;
    if (var->unk24 & 0x20)
        gCurTask->main = sub_0812DF14;
}

static void sub_0812DF14(void) {
    struct Unk_0812DBB4 *var = TaskGetStructPtr(gCurTask);

    var->unk24 |= 2;
    gBgScrollRegs[0][1] += var->unk26;
    gBgScrollRegs[1][1] += var->unk26;
    sub_0812E6E4(var->unk26);
    gUnk_03000530 = var;
    gUnk_03002470[gUnk_03006070++] = CrackityHackDrawCracks;
    gMainFlags |= 0x10;
    sub_0812E194(10, 0x10, var->unk0[0].unk2);
    sub_0812E194(70, 0x10, var->unk0[1].unk2);
    sub_0812E194(130, 0x10, var->unk0[2].unk2);
    sub_0812E194(190, 0x10, var->unk0[3].unk2);
}

// TODO: match this in a better way
static void CrackityHackDrawCracks(void) {
    struct Unk_0812DBB4 *var = gUnk_03000530;
    u32 i;
    s32 r6 = var->unk0[0].unk4;
    u16 *vram = (u16 *)0x600F004;

    for (i = 0; i < r6 + 5; ++i) {
        int var = -r6 + 0x17 + i;
        ++var; --var;
        do
            CpuCopy16(({ gCrackityHackUndergroundBg2CrackTilemap + 2 * var; }), vram, sizeof(u16) * 2);
        while (0);
        vram += 0x20;
    }
    r6 = var->unk0[1].unk4;
    vram = (u16 *)0x600F014;
    for (i = 0; i < r6 + 5; ++i) {
        CpuCopy16(({ gCrackityHackUndergroundBg2CrackTilemap + 2 * (-r6 + 0x17 + i); }) + 0x40, vram, sizeof(u16) * 2);
        vram += 0x20;
    }
    r6 = var->unk0[2].unk4;
    vram = (u16 *)0x600F024;
    for (i = 0; i < r6 + 5; ++i) {
        CpuCopy16(({ gCrackityHackUndergroundBg2CrackTilemap + 2 * (-r6 + 0x17 + i); }) + 0x80, vram, sizeof(u16) * 2);
        vram += 0x20;
    }
    r6 = var->unk0[3].unk4;
    vram = (u16 *)0x600F034;
    for (i = 0; i < r6 + 5; ++i) {
        CpuCopy16(({ gCrackityHackUndergroundBg2CrackTilemap + 2 * (-r6 + 0x17 + i); }) + 0xC0, vram, sizeof(u16) * 2);
        vram += 0x20;
    }
}

static void sub_0812E0C8(u16 a1, u16 a2, u8 a3) {
    struct Unk_08128F44_4 var;
    u16 r9 = 0;

    if (a3)
        r9 = a3 * 0x20 + 0x38;
    CpuFill32(0, &var, sizeof(struct Unk_08128F44_4));
    var.unk0.tilesVram = 0x6010000;
    var.unk0.unk14 = 0x500;
    var.unk0.animId = gUnk_08364FF4[gLanguage][a3].animId;
    var.unk0.variant = gUnk_08364FF4[gLanguage][a3].variant;
    var.unk0.unk16 = 0;
    var.unk0.unk1B = 0xFF;
    var.unk0.unk1C = 0x10;
    var.unk0.palId = 12;
    var.unk0.x = (4 * a1) >> 2;
    var.unk0.y = (4 * a2 + r9) >> 2;
    var.unk0.unk8 = 0xC0000;
    var.unk28 = 4 * a1;
    var.unk2C = 4 * a2 + r9;
    var.unk30 = 0;
    var.unk32 = 0;
    var.unk34 = 0x10;
    var.unk36 = 0;
    var.unk38 = NULL;
    var.unk3C = NULL;
    var.unk40 = NULL;
    sub_081288DC(&var);
}

static void sub_0812E194(u16 a1, u16 a2, s16 a3) {
    u16 hundreds, tens, ones;
    struct Unk_08128F44_4 vars[4];
    struct Unk_08128F44_4 *r4, *r6;

    a3 += 120;
    ones = a3 >> 3;
    if (ones > 999) ones = 999;
    ones -= 1000 * (ones / 1000); // do nothing
    hundreds = ones / 100;
    ones -= 100 * hundreds;
    tens = ones / 10;
    ones -= 10 * tens;
    CpuFill32(0, r6 = &vars[3], sizeof(struct Unk_08128F44_4));
    r6->unk0.tilesVram = 0x6010000;
    r6->unk0.unk14 = 0x340;
    r6->unk0.animId = gUnk_08364E1C[gLanguage][hundreds].animId;
    r6->unk0.variant = gUnk_08364E1C[gLanguage][hundreds].variant;
    r6->unk0.unk16 = 0;
    r6->unk0.unk1B = 0xFF;
    r6->unk0.unk1C = 0x10;
    r6->unk0.palId = 12;
    r6->unk0.x = (4 * a1) >> 2;
    r6->unk0.y = (4 * a2) >> 2;
    r6->unk0.unk8 = 0xC0000;
    r6->unk28 = 4 * a1;
    r6->unk2C = 4 * a2;
    r6->unk30 = 0;
    r6->unk32 = 0;
    r6->unk34 = 0x10;
    r6->unk36 = 0;
    r6->unk38 = NULL;
    r6->unk3C = NULL;
    r6->unk40 = NULL;
    CpuFill32(0, r4 = &vars[2], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x340;
    r4->unk0.animId = gUnk_08364E1C[gLanguage][tens].animId;
    r4->unk0.variant = gUnk_08364E1C[gLanguage][tens].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 12;
    r4->unk0.x = (4 * (a1 + 10)) >> 2;
    r4->unk0.y = (4 * a2) >> 2;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 4 * (a1 + 10);
    r4->unk2C = 4 * a2;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, &vars[1], sizeof(struct Unk_08128F44_4));
    vars[1].unk0.tilesVram = 0x6010000;
    vars[1].unk0.unk14 = 0x340;
    vars[1].unk0.animId = gUnk_08364E1C[gLanguage][ones].animId;
    vars[1].unk0.variant = gUnk_08364E1C[gLanguage][ones].variant;
    vars[1].unk0.unk16 = 0;
    vars[1].unk0.unk1B = 0xFF;
    vars[1].unk0.unk1C = 0x10;
    vars[1].unk0.palId = 12;
    vars[1].unk0.x = (4 * (a1 + 20)) >> 2;
    vars[1].unk0.y = (4 * a2) >> 2;
    vars[1].unk0.unk8 = 0xC0000;
    vars[1].unk28 = 4 * (a1 + 20);
    vars[1].unk2C = 4 * a2;
    vars[1].unk30 = 0;
    vars[1].unk32 = 0;
    vars[1].unk34 = 0x10;
    vars[1].unk36 = 0;
    vars[1].unk38 = NULL;
    vars[1].unk3C = NULL;
    vars[1].unk40 = NULL;
    CpuFill32(0, &vars[0], sizeof(struct Unk_08128F44_4));
    vars[0].unk0.tilesVram = 0x6010000;
    vars[0].unk0.unk14 = 0x340;
    vars[0].unk0.animId = gUnk_08364E1C[gLanguage][11].animId;
    vars[0].unk0.variant = gUnk_08364E1C[gLanguage][11].variant;
    vars[0].unk0.unk16 = 0;
    vars[0].unk0.unk1B = 0xFF;
    vars[0].unk0.unk1C = 0x10;
    vars[0].unk0.palId = 12;
    vars[0].unk0.x = (4 * (a1 + 34)) >> 2;
    vars[0].unk0.y = (4 * a2) >> 2;
    vars[0].unk0.unk8 = 0xC0000;
    vars[0].unk28 = 4 * (a1 + 34);
    vars[0].unk2C = 4 * a2;
    vars[0].unk30 = 0;
    vars[0].unk32 = 0;
    vars[0].unk34 = 0x10;
    vars[0].unk36 = 0;
    vars[0].unk38 = NULL;
    vars[0].unk3C = NULL;
    vars[0].unk40 = NULL;
    sub_081288DC(&vars[0]);
    sub_081288DC(&vars[1]);
    sub_081288DC(r4);
    sub_081288DC(r6);
}

static void sub_0812E468(struct Unk_0812A77C *a1) {
    u8 i, r6;
    u32 j;
    s16 array[4], max;

    array[0] = a1->unk40[0].unk9C;
    array[1] = a1->unk40[1].unk9C;
    array[2] = a1->unk40[2].unk9C;
    array[3] = a1->unk40[3].unk9C;
    for (i = 0; i < 4; i += r6) {
        r6 = 0;
        max = max(max(max(array[3], array[2]), array[1]), array[0]);
        for (j = 0; j < 4; ++j) {
            if (max == a1->unk40[j].unk9C) {
                a1->unk40[j].unkAC = i;
                array[j] = 0;
                ++r6;
            }
        }
    }
}

static void sub_0812E51C(void) {
    struct Unk_0812A77C *var = TaskGetStructPtr(gCurTask);

    if (var->unk5F6++ > 50) {
        TaskDestroy(gCurTask);
        if (gUnk_0203AD10 & 2) {
            sub_08031CC8();
            sub_081589E8();
        }
        sub_08138D64(1);
    }
}

static void sub_0812E588(struct Task *t) {
    struct Unk_0812A77C *var = TaskGetStructPtr(t);

    TaskDestroy(var->unk14[0]);
    var->unk14[0] = NULL;
    TaskDestroy(var->unk14[1]);
    var->unk14[1] = NULL;
    TaskDestroy(var->unk14[2]);
    var->unk14[2] = NULL;
    TaskDestroy(var->unk14[3]);
    var->unk14[3] = NULL;
    TaskDestroy(var->unk14[4]);
    var->unk14[4] = NULL;
    TaskDestroy(var->unk14[5]);
    var->unk14[5] = NULL;
    TaskDestroy(var->unk14[6]);
    var->unk14[6] = NULL;
    TaskDestroy(var->unk14[7]);
    var->unk14[7] = NULL;
    TaskDestroy(var->unk14[8]);
    var->unk14[8] = NULL;
    TaskDestroy(var->unk14[9]);
    var->unk14[9] = NULL;
}

static void sub_0812E604(struct Unk_0812A77C_40 *a1) {
    if (a1->unkA6 & 2 && a1->unk94 & 1) {
        sub_0812BE74(a1);
        a1->unkA6 |= 4;
        a1->unkA6 &= ~2;
    }
}

static void sub_0812E640(void) {
    gDispCnt &= ~DISPCNT_WIN0_ON & ~DISPCNT_BG2_ON;
    gBgCntRegs[2] = BGCNT_PRIORITY(1) | BGCNT_TXT256x256 | BGCNT_SCREENBASE(30);
    gBgScrollRegs[2][0] = 0;
    gBgScrollRegs[2][1] = 0;
    DmaFill32(3, 0, 0x600F000, 0x800);
    CpuFill32(0, gWinRegs, 4);
}

static bool32 sub_0812E6A8(struct Unk_0812D4F4 *a1) {
    if (a1->unk114 & 2)
        return TRUE;
    else
        return FALSE;
}

static void nullsub_31(struct Task *t __attribute__((unused))) {}

static bool32 sub_0812E6C8(struct Unk_0812DBB4 *a1) {
    if (a1->unk24 & 2)
        return TRUE;
    else
        return FALSE;
}

static void nullsub_32(struct Task *t __attribute__((unused))) {}

static void sub_0812E6E4(u8 a1) {
    u32 a1Copy = a1 * 2;
    u32 size = 2 * (160 - a1);

    gMainFlags |= 4;
    gUnk_030036C8 = 0x4000018;
    gUnk_030039A0 = 2;
    CpuCopy16(&gUnk_03002484[2 * a1], gUnk_03002EAC, size / 2 * sizeof(u16));
    CpuCopy16(gUnk_03002484, gUnk_03002EAC + size, a1Copy / 2 * sizeof(u16));
}

static void sub_0812E764(struct Sprite *sprite, u8 a2) {
    sprite->animId = gUnk_08364CE4[gLanguage][a2].animId;
    sprite->variant = gUnk_08364CE4[gLanguage][a2].variant;
    sprite->unk1B = 0xFF;
}

static void sub_0812E7A0(void) {
    u32 i = 0, j = 0;
    u16 *p1, *p2;

    gUnk_030036C8 = 0x4000018;
    gUnk_030039A0 = 2;
    p1 = (u16 *)gUnk_03002484;
    p2 = (u16 *)gUnk_03002EAC;
    for (; i < 160; ++i) {
        *p1++ = j / 4;
        *p2++ = j / 4;
        if (i < 10)
            j += 3;
        else if (i < 20)
            j -= 3;
        else if (i < 40)
            j += 2;
        else if (i < 60)
            j -= 2;
        else if (i < 90)
            j += 1;
        else if (i < 120)
            j -= 1;
        else if (i < 140)
            j += 3;
        else
            j -= 3;
    }
}

static void sub_0812E818(struct Unk_0812A77C_40 *a1) {
    struct Unk_02021590 sp00;
    struct Task *t = TaskCreate(sub_0812E9CC, sizeof(struct Unk_0812E818), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812E818 *tmp = TaskGetStructPtr(t), *var = tmp;

    var->unk54 = 0;
    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        sp00.animId = 0x343;
        sp00.variant = 8;
        break;
    case LANGUAGE_ENGLISH:
        sp00.animId = 0x343;
        sp00.variant = 8;
        break;
    case LANGUAGE_GERMAN:
        sp00.animId = 0x343;
        sp00.variant = 8;
        break;
    case LANGUAGE_FRENCH:
        sp00.animId = 0x343;
        sp00.variant = 8;
        break;
    case LANGUAGE_SPANISH:
        sp00.animId = 0x343;
        sp00.variant = 8;
        break;
    case LANGUAGE_ITALIAN:
        sp00.animId = 0x343;
        sp00.variant = 8;
        break;
    }
    var->unk0.unk0 = a1->unk0;
    var->unk0.unk50 = 0x5A;
    var->unk0.unk52 = 3;
    var->unk0.unk48 = 0;
    var->unk0.unk4C = -0x100;
    if (var->unk0.unk52 & 2) {
        ({ CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x480;
        var->unk0.unk4.unk0.animId = sp00.animId;
        var->unk0.unk4.unk0.variant = sp00.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 11;
        var->unk0.unk4.unk0.x = (var->unk0.unk48 + var->unk0.unk0[0].unk28) >> 2;
        var->unk0.unk4.unk0.y = (var->unk0.unk4C + var->unk0.unk0[0].unk2C) >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48 + var->unk0.unk0[0].unk28;
        var->unk0.unk4.unk2C = var->unk0.unk4C + var->unk0.unk0[0].unk2C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4));
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x480;
        var->unk0.unk4.unk0.animId = sp00.animId;
        var->unk0.unk4.unk0.variant = sp00.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 11;
        var->unk0.unk4.unk0.x = var->unk0.unk48 >> 2;
        var->unk0.unk4.unk0.y = var->unk0.unk4C >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48;
        var->unk0.unk4.unk2C = var->unk0.unk4C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    var->unk0.unk4.unk38 = a1->unk0[0].unk38;
    var->unk0.unk4.unk32 = 2;
}

static void sub_0812E9CC(void) {
    struct Unk_0812E818 *var = TaskGetStructPtr(gCurTask);

    sub_0812A2C0(&var->unk0);
    if (var->unk54++ > 0x18) {
        var->unk54 = 0;
        var->unk0.unk4C = -0x100;
    }
    if (var->unk0.unk52 & 1) {
        if (var->unk0.unk50)
            --var->unk0.unk50;
        else
            TaskDestroy(gCurTask);
    }
}

static void sub_0812EA4C(s32 a1, s32 a2) {
    struct Task *t = TaskCreate(sub_0812EC54, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    s32 r = Rand16() & 0xF;

    var->unk0 = NULL;
    var->unk50 = 0x14;
    var->unk52 = 1;
    var->unk48 = a1;
    var->unk4C = a2;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x380;
        var->unk4.unk0.animId = gUnk_08372440[gLanguage][r].animId;
        var->unk4.unk0.variant = gUnk_08372440[gLanguage][r].variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0[0].unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0[0].unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0[0].unk28;
        var->unk4.unk2C = var->unk4C + var->unk0[0].unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x380;
        var->unk4.unk0.animId = gUnk_08372440[gLanguage][r].animId;
        var->unk4.unk0.variant = gUnk_08372440[gLanguage][r].variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    r = Rand16() & 0xF;
    if (Rand32() & 0x10)
        var->unk4.unk30 = r;
    else
        var->unk4.unk30 = -r;
    var->unk4.unk32 = -(((Rand16() & 0xF) + 4) * 4);
}

static void sub_0812EC54(void) {
    struct Unk_0812D1EC_0 *var = TaskGetStructPtr(gCurTask);
    struct Unk_0812D1EC_0 *var2 = var;

    sub_0812A2C0(var);
    if (var->unk52 & 1) {
        if (var->unk50)
            --var->unk50;
        else
            TaskDestroy(gCurTask);
    }
    else {
        if (var->unk4C > 680)
            TaskDestroy(gCurTask);
        else if (var2->unk48 < -40)
            TaskDestroy(gCurTask);
        else if (var2->unk48 > 1000)
            TaskDestroy(gCurTask);
    }
}

static void sub_0812ECE0(void) {
    struct Unk_0812ECE0 *var = TaskGetStructPtr(gCurTask);
    s32 r3;

    if (var->unk0-- < 1) {
        var->unk0 = (Rand16() & 0xF) + gUnk_08372620[var->unk3];
        r3 = (Rand16() & 0x1F) * 4;
        if (Rand32() & 0x10)
            r3 = -r3;
        sub_0812ED78(var->unk4 + r3);
    }
}

static void sub_0812ED78(s32 a1) {
    struct Task *t = TaskCreate(sub_0812EF3C, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    s32 r = Rand16() & 3;

    var->unk0 = NULL;
    var->unk50 = 0x96;
    var->unk52 = 1;
    var->unk48 = a1;
    var->unk4C = 0;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x380;
        var->unk4.unk0.animId = gUnk_083725C0[gLanguage][r].animId;
        var->unk4.unk0.variant = gUnk_083725C0[gLanguage][r].variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 7;
        var->unk4.unk0.x = (var->unk48 + var->unk0[0].unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0[0].unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0[0].unk28;
        var->unk4.unk2C = var->unk4C + var->unk0[0].unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x380;
        var->unk4.unk0.animId = gUnk_083725C0[gLanguage][r].animId;
        var->unk4.unk0.variant = gUnk_083725C0[gLanguage][r].variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 7;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    r = (Rand16() & 3) + 1;
    var->unk4.unk32 = r;
}

static void sub_0812EF3C(void) {
    struct Unk_0812D1EC_0 *var = TaskGetStructPtr(gCurTask);

    sub_0812A2C0(var);
    if (var->unk52 & 1) {
        if (var->unk50)
            --var->unk50;
        else
            TaskDestroy(gCurTask);
    }
    else if (var->unk4C > 680)
        TaskDestroy(gCurTask);
}

static struct Task *sub_0812EFB4(void) {
    struct Task *t = TaskCreate(sub_0812F070, sizeof(struct Unk_0812EFB4), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812EFB4 *var = TaskGetStructPtr(t);
    
    var->unk0 = 0;
    return t;
}

static struct Task *sub_0812EFFC(u32 a1, u8 a2) {
    struct Task *t = TaskCreate(sub_0812ECE0, sizeof(struct Unk_0812ECE0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812ECE0 *var = TaskGetStructPtr(t);

    var->unk0 = Rand16() & 0x1F;
    var->unk2 = 0;
    var->unk3 = a2;
    var->unk4 = a1;
    return t;
}

static void sub_0812F070(void) {
    struct Unk_0812EFB4 *var = TaskGetStructPtr(gCurTask);

    if (var->unk0++ > 4) {
        var->unk0 = 0;
        sub_0812EA4C(120, 584);
        sub_0812EA4C(360, 552);
        sub_0812EA4C(600, 552);
        sub_0812EA4C(840, 584);
    }
}

static void sub_0812FA28(void);
static void sub_08130534(void);
static void sub_081309B0(void);
static void sub_0813119C(void);
static void sub_0813134C(void);
static void sub_081314C8(void);
static void sub_08131524(void);
static void sub_081315AC(struct Unk_0812F91C *);
static void sub_081316F0(struct Unk_0812F91C *);
static void sub_081317FC(struct Unk_0812F91C *);
static void sub_08131948(struct Unk_0812F91C_45C *, u8);
static void sub_081319BC(struct Unk_0812F91C_20 *);
static void sub_08131A6C(struct Unk_0812F91C_20 *);
static void sub_08131C20(struct Unk_0812F91C_20 *);
static void sub_08131C88(struct Unk_0812F91C_20 *);
static void sub_08131D54(struct Unk_0812F91C_20 *);
static void sub_08131F78(struct Unk_0812F91C_20 *);
static void sub_08132034(struct Unk_0812F91C_20 *, struct Unk_0812F91C_45C *, u8);
static void sub_08132160(struct Unk_0812F91C_20 *, struct Unk_0812F91C_45C *, u8);
static void sub_08132280(struct Unk_0812F91C_20 *, struct Unk_0812F91C_45C *, u8);
static void sub_08132350(struct Unk_0812F91C_20 *);
static void sub_08132498(struct Unk_0812F91C_20 *);
static void sub_08132540(struct Unk_0812F91C_20 *);
static void sub_081325A4(struct Unk_0812F91C *);
static void sub_08132650(struct Unk_0812F91C *);
static void sub_081326F8(struct Unk_0812F91C *);
static void sub_08132800(struct Unk_0812F91C *);
static void sub_08132888(struct Unk_0812F91C *);
static void sub_08132AC8(void);
static void sub_08132B84(void);
static void sub_08132ED8(void);
static void sub_08133044(u8 [], u16);
static void sub_081330AC(void);
static void sub_08133118(struct Task *);
static void sub_08133164(struct Unk_0812F91C_20 *);
static void sub_0813318C(struct Unk_0812F91C_20 *);
static void sub_081331CC(struct Unk_0812F91C_20 *, u16);
static void sub_081331F0(struct Unk_0812F91C_20 *, s32 *);
static void sub_08133248(struct Unk_0812F91C_20 *);
static void sub_08133280(struct Unk_0812F91C_20 *);
static u8 sub_081332D0(struct Unk_0812F91C_20 *, s16, s16);
static u8 sub_081332FC(s32, u32, u8 *);
static void sub_08133344(struct Unk_0812F91C_20 *);
static struct Task *sub_081334DC(struct Unk_0812F91C_20 *);
static void sub_08133688(struct Task *, bool8);
static void sub_08133804(struct Unk_0812F91C_20 *);
static struct Task *sub_08133D44(struct Unk_0812F91C_20 *);
static void sub_08133EEC(struct Unk_0812F91C_20 *, u8);
static void sub_081340AC(struct Unk_0812F91C_20 *);
static void sub_08134178(void);
static void sub_081341B0(struct Unk_0812F91C_20 *, s16, s16);
static void sub_0813436C(void);
static void sub_081343EC(void);
static struct Task *sub_0813457C(void);
static void sub_08134720(struct Task *);
static void sub_08134754(struct Task *);
static struct Task *sub_08134788(struct Unk_0812F91C_20 *);
static void sub_081347D8(struct Unk_0812F91C_20 *, u8, u32);
static void sub_0813483C(void);
static void sub_08134884(void);
static void sub_081348B4(void);

static const struct Unk_02021590 gUnk_08372628[][6] = {
    [LANGUAGE_JAPANESE] = {
        { 0x34B, 0x5, 0x0 },
        { 0x34B, 0x4, 0x0 },
        { 0x34B, 0x3, 0x0 },
        { 0x34B, 0x0, 0x0 },
        { 0x34B, 0x1, 0x0 },
        { 0x34B, 0x2, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x34B, 0x5, 0x0 },
        { 0x34B, 0x4, 0x0 },
        { 0x34B, 0x3, 0x0 },
        { 0x34B, 0x0, 0x0 },
        { 0x34B, 0x1, 0x0 },
        { 0x34B, 0x2, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x34B, 0x5, 0x0 },
        { 0x34B, 0x4, 0x0 },
        { 0x34B, 0x3, 0x0 },
        { 0x34B, 0x0, 0x0 },
        { 0x34B, 0x1, 0x0 },
        { 0x34B, 0x2, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x34B, 0x5, 0x0 },
        { 0x34B, 0x4, 0x0 },
        { 0x34B, 0x3, 0x0 },
        { 0x34B, 0x0, 0x0 },
        { 0x34B, 0x1, 0x0 },
        { 0x34B, 0x2, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x34B, 0x5, 0x0 },
        { 0x34B, 0x4, 0x0 },
        { 0x34B, 0x3, 0x0 },
        { 0x34B, 0x0, 0x0 },
        { 0x34B, 0x1, 0x0 },
        { 0x34B, 0x2, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x34B, 0x5, 0x0 },
        { 0x34B, 0x4, 0x0 },
        { 0x34B, 0x3, 0x0 },
        { 0x34B, 0x0, 0x0 },
        { 0x34B, 0x1, 0x0 },
        { 0x34B, 0x2, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_083726B8[][10] = {
    [LANGUAGE_JAPANESE] = {
        { 0x347, 0x0, 0x0 },
        { 0x347, 0x1, 0x0 },
        { 0x347, 0x2, 0x0 },
        { 0x347, 0x3, 0x0 },
        { 0x347, 0x4, 0x0 },
        { 0x347, 0x5, 0x0 },
        { 0x347, 0x6, 0x0 },
        { 0x347, 0x7, 0x0 },
        { 0x347, 0x8, 0x0 },
        { 0x347, 0x9, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x347, 0x0, 0x0 },
        { 0x347, 0x1, 0x0 },
        { 0x347, 0x2, 0x0 },
        { 0x347, 0x3, 0x0 },
        { 0x347, 0x4, 0x0 },
        { 0x347, 0x5, 0x0 },
        { 0x347, 0x6, 0x0 },
        { 0x347, 0x7, 0x0 },
        { 0x347, 0x8, 0x0 },
        { 0x347, 0x9, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x347, 0x0, 0x0 },
        { 0x347, 0x1, 0x0 },
        { 0x347, 0x2, 0x0 },
        { 0x347, 0x3, 0x0 },
        { 0x347, 0x4, 0x0 },
        { 0x347, 0x5, 0x0 },
        { 0x347, 0x6, 0x0 },
        { 0x347, 0x7, 0x0 },
        { 0x347, 0x8, 0x0 },
        { 0x347, 0x9, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x347, 0x0, 0x0 },
        { 0x347, 0x1, 0x0 },
        { 0x347, 0x2, 0x0 },
        { 0x347, 0x3, 0x0 },
        { 0x347, 0x4, 0x0 },
        { 0x347, 0x5, 0x0 },
        { 0x347, 0x6, 0x0 },
        { 0x347, 0x7, 0x0 },
        { 0x347, 0x8, 0x0 },
        { 0x347, 0x9, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x347, 0x0, 0x0 },
        { 0x347, 0x1, 0x0 },
        { 0x347, 0x2, 0x0 },
        { 0x347, 0x3, 0x0 },
        { 0x347, 0x4, 0x0 },
        { 0x347, 0x5, 0x0 },
        { 0x347, 0x6, 0x0 },
        { 0x347, 0x7, 0x0 },
        { 0x347, 0x8, 0x0 },
        { 0x347, 0x9, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x347, 0x0, 0x0 },
        { 0x347, 0x1, 0x0 },
        { 0x347, 0x2, 0x0 },
        { 0x347, 0x3, 0x0 },
        { 0x347, 0x4, 0x0 },
        { 0x347, 0x5, 0x0 },
        { 0x347, 0x6, 0x0 },
        { 0x347, 0x7, 0x0 },
        { 0x347, 0x8, 0x0 },
        { 0x347, 0x9, 0x0 },
    },
};

static const s8 gUnk_083727A8[] = {
    0, 0, 1, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 0 // TODO: padding?
};

static const s8 gUnk_083727B8[][11] = {
    { 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x9, 0x9, 0x9, 0x2, 0x1 },
    { 0x6, 0x6, 0x7, 0x8, 0x8, 0x8, 0x9, 0x9, 0x9, 0x8, 0x7 },
    { 0x3, 0x3, 0x4, 0x5, 0x5, 0x5, 0x9, 0x9, 0x9, 0x5, 0x4 },
};

static const struct Unk_02021590 gUnk_083727DC[][4] = {
    [LANGUAGE_JAPANESE] = {
        { 0x349, 0x2, 0x0 },
        { 0x349, 0x3, 0x0 },
        { 0x349, 0x4, 0x0 },
        { 0x349, 0x5, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x349, 0x2, 0x0 },
        { 0x349, 0x3, 0x0 },
        { 0x349, 0x4, 0x0 },
        { 0x349, 0x5, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x349, 0x2, 0x0 },
        { 0x349, 0x3, 0x0 },
        { 0x349, 0x4, 0x0 },
        { 0x349, 0x5, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x349, 0x2, 0x0 },
        { 0x349, 0x3, 0x0 },
        { 0x349, 0x4, 0x0 },
        { 0x349, 0x5, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x349, 0x2, 0x0 },
        { 0x349, 0x3, 0x0 },
        { 0x349, 0x4, 0x0 },
        { 0x349, 0x5, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x349, 0x2, 0x0 },
        { 0x349, 0x3, 0x0 },
        { 0x349, 0x4, 0x0 },
        { 0x349, 0x5, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_0837283C[][11] = {
    [LANGUAGE_JAPANESE] = {
        { 0x349,  0x6, 0x0 },
        { 0x349,  0x7, 0x0 },
        { 0x349,  0x8, 0x0 },
        { 0x349,  0x9, 0x0 },
        { 0x349,  0xA, 0x0 },
        { 0x349,  0xB, 0x0 },
        { 0x349,  0xC, 0x0 },
        { 0x349,  0xD, 0x0 },
        { 0x349,  0xE, 0x0 },
        { 0x349,  0xF, 0x0 },
        { 0x349, 0x10, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x349,  0x6, 0x0 },
        { 0x349,  0x7, 0x0 },
        { 0x349,  0x8, 0x0 },
        { 0x349,  0x9, 0x0 },
        { 0x349,  0xA, 0x0 },
        { 0x349,  0xB, 0x0 },
        { 0x349,  0xC, 0x0 },
        { 0x349,  0xD, 0x0 },
        { 0x349,  0xE, 0x0 },
        { 0x349,  0xF, 0x0 },
        { 0x349, 0x10, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x349,  0x6, 0x0 },
        { 0x349,  0x7, 0x0 },
        { 0x349,  0x8, 0x0 },
        { 0x349,  0x9, 0x0 },
        { 0x349,  0xA, 0x0 },
        { 0x349,  0xB, 0x0 },
        { 0x349,  0xC, 0x0 },
        { 0x349,  0xD, 0x0 },
        { 0x349,  0xE, 0x0 },
        { 0x349,  0xF, 0x0 },
        { 0x349, 0x10, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x349,  0x6, 0x0 },
        { 0x349,  0x7, 0x0 },
        { 0x349,  0x8, 0x0 },
        { 0x349,  0x9, 0x0 },
        { 0x349,  0xA, 0x0 },
        { 0x349,  0xB, 0x0 },
        { 0x349,  0xC, 0x0 },
        { 0x349,  0xD, 0x0 },
        { 0x349,  0xE, 0x0 },
        { 0x349,  0xF, 0x0 },
        { 0x349, 0x10, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x349,  0x6, 0x0 },
        { 0x349,  0x7, 0x0 },
        { 0x349,  0x8, 0x0 },
        { 0x349,  0x9, 0x0 },
        { 0x349,  0xA, 0x0 },
        { 0x349,  0xB, 0x0 },
        { 0x349,  0xC, 0x0 },
        { 0x349,  0xD, 0x0 },
        { 0x349,  0xE, 0x0 },
        { 0x349,  0xF, 0x0 },
        { 0x349, 0x10, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x349,  0x6, 0x0 },
        { 0x349,  0x7, 0x0 },
        { 0x349,  0x8, 0x0 },
        { 0x349,  0x9, 0x0 },
        { 0x349,  0xA, 0x0 },
        { 0x349,  0xB, 0x0 },
        { 0x349,  0xC, 0x0 },
        { 0x349,  0xD, 0x0 },
        { 0x349,  0xE, 0x0 },
        { 0x349,  0xF, 0x0 },
        { 0x349, 0x10, 0x0 },
    },
};

static const u8 gUnk_08372944[] = {
    0x0, 0x1, 0x3, 0x2, 0x2, 0x1, 0x1, 0x1,
    0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x0, 0x1,
};

static const u8 gUnk_08372954[] = {
    0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x2, 0x2, 0x2, 0x4, 0x3, 0x4, 0x0, 0x1,
};

static const s8 gUnk_08372964[][8] = {
    { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
    { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 },
    { 0x7, 0x6, 0x5, 0x4, 0x3, 0x2, 0x1, 0x0 },
    { 0x7, 0x7, 0x6, 0x6, 0x5, 0x5, 0x4, 0x4 },
    { 0x3, 0x3, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0 },
    { 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7 },
    { 0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3 },
    { 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x7 },
};

static const u8 gUnk_083729A4[][16] = {
    { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x8, 0x8, 0xA, 0x6, 0x8, 0xA, 0x0, 0x0 },
    { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x6, 0xA, 0xC, 0x8, 0xA, 0xC, 0x0, 0x0 },
    { 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x8, 0xE, 0xA, 0xC, 0xE, 0x0, 0x0 },
};

static const s16 gUnk_083729D4[] = {
    0x70, 0x78, 0x88, 0x90, 0x80, 0x58
};

static const u16 gUnk_083729E0[0x100] = {
    RGB( 0, 19, 23) | 0x0000, RGB(16, 16, 31) | 0x0000, RGB(24,  8,  0) | 0x0000, RGB(31, 16,  0) | 0x0000, RGB(31, 24,  0) | 0x0000, RGB(31, 31,  0) | 0x8000, RGB(24,  0, 16) | 0x0000, RGB(24,  0, 31) | 0x0000,
    RGB( 8, 24,  0) | 0x0000, RGB(16, 31,  0) | 0x8000, RGB(31,  8, 16) | 0x0000, RGB(31, 16, 24) | 0x0000, RGB(16, 24, 31) | 0x0000, RGB( 0, 31, 31) | 0x8000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB(31,  0,  0) | 0x0000, RGB( 0,  9, 31) | 0x8000, RGB( 0, 16, 31) | 0x0000, RGB( 0, 24, 31) | 0x0000, RGB( 2, 31, 31) | 0x8000, RGB(31, 31, 31) | 0x8000, RGB(31, 31, 31) | 0x8000, RGB( 2, 31, 31) | 0x8000,
    RGB( 0, 24, 31) | 0x0000, RGB( 2, 31, 31) | 0x8000, RGB( 2, 31, 31) | 0x8000, RGB( 0, 24, 31) | 0x0000, RGB( 0, 16, 31) | 0x0000, RGB( 0, 20, 31) | 0x0000, RGB( 0, 24, 31) | 0x0000, RGB(31,  0,  0) | 0x0000,
    RGB(19, 15, 11) | 0x8000, RGB( 0,  9, 25) | 0x8000, RGB( 0, 13, 31) | 0x0000, RGB( 0, 15, 31) | 0x0000, RGB( 3, 19, 31) | 0x8000, RGB( 7, 24, 31) | 0x8000, RGB( 2,  5, 25) | 0x8000, RGB(10, 12, 19) | 0x0000,
    RGB(17, 18, 12) | 0x8000, RGB(24, 25,  6) | 0x0000, RGB(31, 31,  0) | 0x8000, RGB(31, 31, 24) | 0x8000, RGB(31,  0,  0) | 0x0000, RGB( 0, 11, 31) | 0x0000, RGB( 0, 31,  0) | 0x8000, RGB( 0, 31,  0) | 0x8000,
    RGB( 0, 13,  0) | 0x0000, RGB( 0, 15, 31) | 0x0000, RGB( 3, 19, 31) | 0x8000, RGB( 7, 24, 31) | 0x8000, RGB( 0, 11, 31) | 0x0000, RGB(31, 24, 31) | 0x8000, RGB(26, 21, 31) | 0x8000, RGB(23, 21, 31) | 0x8000,
    RGB(16, 19, 31) | 0x0000, RGB( 9, 18, 31) | 0x8000, RGB( 0, 16, 31) | 0x0000, RGB( 9, 18, 31) | 0x8000, RGB(16, 19, 31) | 0x0000, RGB(23, 21, 31) | 0x8000, RGB(26, 21, 31) | 0x8000, RGB(31, 24, 31) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0, 22) | 0x0000, RGB( 2,  5, 25) | 0x8000, RGB( 5, 11, 28) | 0x0000, RGB( 8, 16, 31) | 0x8000, RGB(16, 19, 31) | 0x8000, RGB(28, 22, 31) | 0x8000, RGB(28, 23, 31) | 0x8000,
    RGB(31, 26, 31) | 0x8000, RGB(31, 27, 31) | 0x0000, RGB(31, 29, 31) | 0x8000, RGB(31, 30, 31) | 0x0000, RGB(31, 31, 31) | 0x8000, RGB( 0,  0, 20) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000,
    RGB(31,  0,  0) | 0x0000, RGB( 0,  0, 20) | 0x0000, RGB( 5, 11, 28) | 0x0000, RGB( 6, 16, 31) | 0x0000, RGB( 8, 19, 31) | 0x8000, RGB( 7, 24, 31) | 0x8000, RGB( 0,  0, 20) | 0x0000, RGB( 0,  0, 20) | 0x0000,
    RGB( 0,  0, 20) | 0x0000, RGB( 0,  0, 20) | 0x0000, RGB( 0,  0, 20) | 0x0000, RGB( 0,  0, 20) | 0x0000, RGB( 0,  0, 20) | 0x0000, RGB( 0,  0, 20) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000,
    RGB( 0, 13,  0) | 0x0000, RGB( 0,  0,  1) | 0x0000, RGB(29, 20,  4) | 0x0000, RGB( 2,  1, 15) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000,
    RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB( 0, 31,  0) | 0x0000, RGB(31, 31, 31) | 0x0000,
    RGB( 6, 18,  6) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB(31, 26, 30) | 0x0000, RGB(31, 20, 27) | 0x0000, RGB(31, 18, 24) | 0x0000, RGB(30, 14, 20) | 0x0000, RGB(27,  9, 14) | 0x0000, RGB(22,  4,  7) | 0x0000,
    RGB(12,  2,  2) | 0x0000, RGB(31,  3, 16) | 0x0000, RGB(26,  0, 10) | 0x0000, RGB(22,  0,  5) | 0x0000, RGB(31, 29,  0) | 0x0000, RGB( 0, 11, 31) | 0x0000, RGB(31, 11,  0) | 0x0000, RGB(31, 31, 31) | 0x0000,
    RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000,
    RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(31,  0,  0) | 0x0000,
    RGB(19, 15, 11) | 0x8000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB(19, 15, 11) | 0x8000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB(31, 23,  7) | 0x8000, RGB(19, 15, 11) | 0x8000, RGB(19, 27,  7) | 0x8000, RGB(31, 31, 15) | 0x8000, RGB( 7, 15, 23) | 0x8000, RGB(31, 15, 15) | 0x8000, RGB(20, 25, 30) | 0x0000,
    RGB(23, 23,  7) | 0x8000, RGB(27, 15, 19) | 0x8000, RGB( 7, 15, 15) | 0x8000, RGB(23, 31, 15) | 0x8000, RGB(31, 11, 19) | 0x8000, RGB(24, 24, 24) | 0x0000, RGB(31, 11, 11) | 0x8000, RGB(19, 31, 11) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB(31,  7,  7) | 0x8000, RGB(11, 19,  7) | 0x8000, RGB(27, 23, 11) | 0x8000, RGB(27,  7, 11) | 0x8000, RGB(23,  7, 15) | 0x8000, RGB(15, 23, 23) | 0x8000, RGB(11, 27, 15) | 0x8000,
    RGB(19,  7, 19) | 0x8000, RGB(19, 23, 11) | 0x8000, RGB( 7, 27, 19) | 0x8000, RGB(15,  7, 23) | 0x8000, RGB(23, 15, 23) | 0x8000, RGB(31, 23, 23) | 0x8000, RGB(31, 15, 11) | 0x8000, RGB(27, 23, 23) | 0x8000,
    RGB( 0, 16,  0) | 0x0000, RGB(31, 24,  0) | 0x0000, RGB( 0, 24, 31) | 0x0000, RGB(28, 12,  0) | 0x0000, RGB(16, 16, 16) | 0x0000, RGB(31, 31, 31) | 0x8000, RGB( 0, 17, 22) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB(31,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0, 16) | 0x0000,
};

const u32 gUnk_08372BE0[] = INCBIN_U32("graphics/wave_ride/bg/main_tileset.4bpp.lz");

const u32 gUnk_083744AC[] = INCBIN_U32("graphics/wave_ride/bg/game_ended/tileset_japanese.4bpp.lz");
const u32 gUnk_08374890[] = INCBIN_U32("graphics/wave_ride/bg/game_ended/tileset_italian.4bpp.lz");
const u32 gUnk_08374C50[] = INCBIN_U32("graphics/wave_ride/bg/game_ended/tileset_french.4bpp.lz");
const u32 gUnk_08375064[] = INCBIN_U32("graphics/wave_ride/bg/game_ended/tileset_spanish.4bpp.lz");
const u32 gUnk_08375400[] = INCBIN_U32("graphics/wave_ride/bg/game_ended/tileset_english.4bpp.lz");
const u32 gUnk_08375798[] = INCBIN_U32("graphics/wave_ride/bg/game_ended/tileset_german.4bpp.lz");

static const u32 gUnk_08375B54[0x140] = INCBIN_U32("graphics/wave_ride/bg/game_ended/bg2_tilemap.bin");
static const u32 gUnk_08376054[0x200] = INCBIN_U32("graphics/wave_ride/bg/bg1_tilemap.bin");

static const u16 gUnk_08376854[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_main_tilemap.bin");

static const u8 gUnk_08377054[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_08377254[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_0.bin");

static const u8 gUnk_08377A54[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_08377C54[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_1.bin");

static const u8 gUnk_08378454[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_08378654[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_2.bin");

static const u8 gUnk_08378E54[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_08379054[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_3.bin");

static const u8 gUnk_08379854[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_08379A54[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_4.bin");

static const u8 gUnk_0837A254[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_0837A454[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_5.bin");

static const u8 gUnk_0837AC54[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_0837AE54[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_6.bin");

static const u8 gUnk_0837B654[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_0837B854[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_7.bin");

static const u8 gUnk_0837C054[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x2, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_0837C254[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_8.bin");

static const u8 gUnk_0837CA54[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0xA, 0x50,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x91, 0x15,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x8, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x21,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x10,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0x34, 0x11,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_0837CC54[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_9.bin");

static const u8 gUnk_0837D454[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x1, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0, 0x11, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x67,  0x0,  0x0,  0x1, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x67,  0x0,  0x0, 0x11, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x1, 0x67,  0x0,  0x0,  0x1, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0, 0x11, 0x67,  0x0,  0x0, 0x11, 0x67,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x67,  0x0,  0x0,  0x1, 0x67,  0x0,  0x0,  0x1, 0x67,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x67,  0x0,  0x0, 0x11, 0x67,  0x0,  0x0, 0x11, 0x67,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_0837D654[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_10.bin");

static const u8 gUnk_0837DE54[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0, 0xE0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xF1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xF1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 gUnk_0837E054[] __attribute__((aligned(4))) = INCBIN_U16("graphics/wave_ride/bg/bg0_tilemap_11.bin");

static const u8 gUnk_0837E854[][0x10] = {
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    {  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0,  0x0 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
    { 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11 },
};

static const u16 *const gUnk_0837EA54[] = {
    gUnk_08376854, gUnk_08377254, gUnk_08377C54, gUnk_08378654,
    gUnk_08379054, gUnk_08379A54, gUnk_0837A454, gUnk_0837AE54,
    gUnk_0837B854, gUnk_0837C254, gUnk_0837CC54, gUnk_0837D654,
    gUnk_0837E054,
};

static const u8 (*const gUnk_0837EA88[])[0x10] = {
    gUnk_08377054, gUnk_08377A54, gUnk_08378454, gUnk_08378E54,
    gUnk_08379854, gUnk_0837A254, gUnk_0837AC54, gUnk_0837B654,
    gUnk_0837C054, gUnk_0837CA54, gUnk_0837D454, gUnk_0837DE54,
    gUnk_0837E854,
};

static const u8 gUnk_0837EABC[] = {
    0, 1, 0, 1, 0, 1,
    1, 0, 1, 0, 0, 0,
    0
};

static const u8 gUnk_0837EAC9[] = {
    0, 0, 1, 1, 2, 2,
    3, 4, 4, 5, 5, 5,
    0, 0, 0
};

static const u8 gUnk_0837EAD8[][4] = {
    { 0x88, 0xD8, 0x32,  0x4 },
    { 0xC8, 0xD8, 0x42,  0x6 },
    { 0x88, 0xD8, 0x32,  0x4 },
    { 0x68, 0xD0, 0x72,  0x8 },
    { 0x98, 0xB8, 0x34,  0x5 },
    { 0xFF, 0xFF, 0xFF, 0xFF },
    { 0xFF, 0xFF, 0xFF, 0xFF },
};

static const struct Unk_08128D48_0 gUnk_0837EAF4 = {
    .dstVramOffset = 0x4800,
    .numTiles = 0x18,
    .numFrames = 4,
    .frames = {
        {
            .srcVramOffset = 0x4C00,
            .unk2 = 0,
            .delay = 5,
        },
        {
            .srcVramOffset = 0x5000,
            .unk2 = 0,
            .delay = 5,
        },
        {
            .srcVramOffset = 0x5400,
            .unk2 = 0,
            .delay = 5,
        },
        {
            .srcVramOffset = 0x5800,
            .unk2 = 0,
            .delay = 5,
        },
    },
};

static const struct Unk_08128E28_0 gUnk_0837EB08 = {
    .paletteOffset = 0x35,
    .numPalettes = 0xB,
    .paletteSize = 0xB,
    .data = {
        0x5,
        RGB(31, 24, 31), RGB(26, 21, 31), RGB(23, 21, 31), RGB(16, 19, 31),
        RGB( 9, 18, 31), RGB( 0, 16, 31), RGB( 9, 18, 31), RGB(16, 19, 31),
        RGB(23, 21, 31), RGB(26, 21, 31), RGB(31, 24, 31),

        0x5,
        RGB(26, 21, 31), RGB(23, 21, 31), RGB(16, 19, 31), RGB( 9, 18, 31),
        RGB( 0, 16, 31), RGB( 9, 18, 31), RGB(16, 19, 31), RGB(23, 21, 31),
        RGB(26, 21, 31), RGB(31, 24, 31), RGB(31, 24, 31),

        0x5,
        RGB(23, 21, 31), RGB(16, 19, 31), RGB( 9, 18, 31), RGB( 0, 16, 31),
        RGB( 9, 18, 31), RGB(16, 19, 31), RGB(23, 21, 31), RGB(26, 21, 31),
        RGB(31, 24, 31), RGB(31, 24, 31), RGB(26, 21, 31),

        0x5,
        RGB(16, 19, 31), RGB( 9, 18, 31), RGB( 0, 16, 31), RGB( 9, 18, 31),
        RGB(16, 19, 31), RGB(23, 21, 31), RGB(26, 21, 31), RGB(31, 24, 31),
        RGB(31, 24, 31), RGB(26, 21, 31), RGB(23, 21, 31),

        0x5,
        RGB( 9, 18, 31), RGB( 0, 16, 31), RGB( 9, 18, 31), RGB(16, 19, 31),
        RGB(23, 21, 31), RGB(26, 21, 31), RGB(31, 24, 31), RGB(31, 24, 31),
        RGB(26, 21, 31), RGB(23, 21, 31), RGB(16, 19, 31),

        0x5,
        RGB( 0, 16, 31), RGB( 9, 18, 31), RGB(16, 19, 31), RGB(23, 21, 31),
        RGB(26, 21, 31), RGB(31, 24, 31), RGB(31, 24, 31), RGB(26, 21, 31),
        RGB(23, 21, 31), RGB(16, 19, 31), RGB( 9, 18, 31),

        0x5,
        RGB( 9, 18, 31), RGB(16, 19, 31), RGB(23, 21, 31), RGB(26, 21, 31),
        RGB(31, 24, 31), RGB(31, 24, 31), RGB(26, 21, 31), RGB(23, 21, 31),
        RGB(16, 19, 31), RGB( 9, 18, 31), RGB( 0, 16, 31),

        0x5,
        RGB(16, 19, 31), RGB(23, 21, 31), RGB(26, 21, 31), RGB(31, 24, 31),
        RGB(31, 24, 31), RGB(26, 21, 31), RGB(23, 21, 31), RGB(16, 19, 31),
        RGB( 9, 18, 31), RGB( 0, 16, 31), RGB( 9, 18, 31),

        0x5,
        RGB(23, 21, 31), RGB(26, 21, 31), RGB(31, 24, 31), RGB(31, 24, 31),
        RGB(26, 21, 31), RGB(23, 21, 31), RGB(16, 19, 31), RGB( 9, 18, 31),
        RGB( 0, 16, 31), RGB( 9, 18, 31), RGB(16, 19, 31),

        0x5,
        RGB(26, 21, 31), RGB(31, 24, 31), RGB(31, 24, 31), RGB(26, 21, 31),
        RGB(23, 21, 31), RGB(16, 19, 31), RGB( 9, 18, 31), RGB( 0, 16, 31),
        RGB( 9, 18, 31), RGB(16, 19, 31), RGB(23, 21, 31),

        0x5,
        RGB(31, 24, 31), RGB(31, 24, 31), RGB(26, 21, 31), RGB(23, 21, 31),
        RGB(16, 19, 31), RGB( 9, 18, 31), RGB( 0, 16, 31), RGB( 9, 18, 31),
        RGB(16, 19, 31), RGB(23, 21, 31), RGB(26, 21, 31),
    },
};

static const struct Unk_08128E28_0 gUnk_0837EC14 = {
    .paletteOffset = 0x52,
    .numPalettes = 0x18,
    .paletteSize = 0xC,
    .data = {
        0x3,
        RGB( 7, 24, 31), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x3,
        RGB( 8, 19, 31), RGB( 7, 24, 31), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x3,
        RGB( 6, 16, 31), RGB( 8, 19, 31), RGB( 7, 24, 31), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x3,
        RGB( 5, 11, 28), RGB( 6, 16, 31), RGB( 8, 19, 31), RGB( 7, 24, 31),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x3,
        RGB( 0,  0, 20), RGB( 5, 11, 28), RGB( 6, 16, 31), RGB( 8, 19, 31),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x3,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 5, 11, 28), RGB( 6, 16, 31),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x3,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 5, 11, 28),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x8,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 7, 24, 31), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 8, 19, 31), RGB( 7, 24, 31), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 6, 16, 31), RGB( 8, 19, 31), RGB( 7, 24, 31), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 5, 11, 28), RGB( 6, 16, 31), RGB( 8, 19, 31), RGB( 7, 24, 31),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 5, 11, 28), RGB( 6, 16, 31), RGB( 8, 19, 31),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 5, 11, 28), RGB( 6, 16, 31),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 5, 11, 28),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x8,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 7, 24, 31), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 8, 19, 31), RGB( 7, 24, 31), RGB( 0,  0, 20), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 6, 16, 31), RGB( 8, 19, 31), RGB( 7, 24, 31), RGB( 0,  0, 20),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 5, 11, 28), RGB( 6, 16, 31), RGB( 8, 19, 31), RGB( 7, 24, 31),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 5, 11, 28), RGB( 6, 16, 31), RGB( 8, 19, 31),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 5, 11, 28), RGB( 6, 16, 31),

        0x4,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 5, 11, 28),

        0x8,
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
        RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20), RGB( 0,  0, 20),
    },
};

static const struct Unk_08128E28_0 gUnk_0837EE88 = {
    .paletteOffset = 0x16,
    .numPalettes = 4,
    .paletteSize = 9,
    .data = {
        0x5,
        RGB(31, 31, 31), RGB( 2, 31, 31), RGB( 0, 24, 31), RGB( 2, 31, 31),
        RGB( 2, 31, 31), RGB( 0, 24, 31), RGB( 0, 16, 31), RGB( 0, 20, 31),
        RGB( 0, 24, 31),

        0x5,
        RGB( 2, 31, 31), RGB(31, 31, 31), RGB( 2, 31, 31), RGB( 0, 24, 31),
        RGB( 0, 24, 31), RGB( 2, 31, 31), RGB( 0, 24, 31), RGB( 0, 16, 31),
        RGB( 0, 20, 31),

        0x5,
        RGB( 0, 24, 31), RGB( 2, 31, 31), RGB(31, 31, 31), RGB( 2, 31, 31),
        RGB( 0, 20, 31), RGB( 0, 24, 31), RGB( 2, 31, 31), RGB( 0, 24, 31),
        RGB( 0, 16, 31),

        0x5,
        RGB( 2, 31, 31), RGB( 0, 24, 31), RGB( 2, 31, 31), RGB(31, 31, 31),
        RGB( 0, 16, 31), RGB( 0, 20, 31), RGB( 0, 24, 31), RGB( 2, 31, 31),
        RGB( 0, 24, 31),
    },
};

static const u8 gUnk_0837EEDC[] = { 0, 2, 0xFE, 4, 0xFC, 6, 0xFA };

static const u8 gUnk_0837EEE3[] = { 3, 5, 7, 0xFD, 0xFE, 0xFF, 0, 1, 2, 3, 4, 0, 0 }; // padding?

static const struct Unk_02021590 gUnk_0837EEF0[][3] = {
    [LANGUAGE_JAPANESE] = {
        { 0x349, 0x11, 0x0 },
        { 0x349, 0x12, 0x0 },
        { 0x349, 0x13, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x349, 0x11, 0x0 },
        { 0x349, 0x12, 0x0 },
        { 0x349, 0x13, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x349, 0x11, 0x0 },
        { 0x349, 0x12, 0x0 },
        { 0x349, 0x13, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x349, 0x11, 0x0 },
        { 0x349, 0x12, 0x0 },
        { 0x349, 0x13, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x349, 0x11, 0x0 },
        { 0x349, 0x12, 0x0 },
        { 0x349, 0x13, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x349, 0x11, 0x0 },
        { 0x349, 0x12, 0x0 },
        { 0x349, 0x13, 0x0 },
    },
};

extern const u32 *const gUnk_08D61B54[];

static void sub_0812F0E0(struct Unk_0812F91C_20 *a1, s32 *a2, u8 *a3, u8 a4) {
    if (a4 < gUnk_0203AD30)
        a1->unk94 = 0;
    else
        a1->unk94 = 1;
    if (a4 == gUnk_0203AD3C)
        a1->unk94 |= 2;
    a1->unk94 |= 0x10;
    a1->unk9A = 0;
    a1->unk98 = 0;
    a1->unk9C = 0;
    a1->unk9E = 0;
    a1->unkA0 = 6;
    a1->unkA1 = 1;
    a1->unkA2 = 1;
    a1->unkA4 = 0;
    a1->unkA6 = 0;
    a1->unkA8 = 0;
    a1->unkAA = 0;
    a1->unkAC = 0;
    a1->unkB0 = 0;
    a1->unkB2 = 0;
    a1->unkB3 = 0;
    a1->unkB4 = 0;
    a1->unkB6 = 0;
    a1->unkB8 = 0;
    a1->unkBC = 0;
    a1->unkBD = 0;
    a1->unkBE = 0;
    a1->unkBF = 0;
    a1->unkC0 = 0x100;
    switch (a4) {
    case 0:
        a1->unkC4 = 0x3A0;
        break;
    case 1:
        a1->unkC4 = 0x320;
        break;
    case 2:
        a1->unkC4 = 0x2A0;
        break;
    case 3:
        a1->unkC4 = 0x220;
        break;
    }
    a1->unkC8 = 0;
    a1->unkCC = 0;
    a1->unkD0 = 0;
    a1->unkD4 = a3;
    a1->unkD8 = gUnk_0837EA54[a3[0]];
    a1->unkDC = gUnk_0837EA54[a3[1]];
    a1->unkE0 = 0;
    a1->unkE4 = 0;
    a1->unkE5 = 0;
    a1->unkE6 = 0;
    a1->unkE8 = Rand32();
    CpuFill32(0, &a1->unk0, sizeof(struct Unk_08128F44_4));
    a1->unk0.unk0.tilesVram = 0x6010000;
    a1->unk0.unk0.unk14 = 0x440;
    a1->unk0.unk0.animId = gUnk_083726B8[gLanguage][0].animId;
    a1->unk0.unk0.variant = gUnk_083726B8[gLanguage][0].variant;
    a1->unk0.unk0.unk16 = 0;
    a1->unk0.unk0.unk1B = 0xFF;
    a1->unk0.unk0.unk1C = 0x10;
    a1->unk0.unk0.palId = a4;
    a1->unk0.unk0.x = 20;
    a1->unk0.unk0.y = 130;
    a1->unk0.unk0.unk8 = 0xC0000;
    a1->unk0.unk28 = 0x50;
    a1->unk0.unk2C = 0x208;
    a1->unk0.unk30 = 0;
    a1->unk0.unk32 = 0;
    a1->unk0.unk34 = 0x810;
    a1->unk0.unk36 = 0;
    a1->unk0.unk38 = NULL;
    a1->unk0.unk3C = NULL;
    a1->unk0.unk40 = NULL;
    if (a4 == gUnk_0203AD3C)
        a1->unk0.unk0.unk14 = 0x400;
    CpuFill32(0, &a1->unk44, sizeof(struct Unk_08128F44_4));
    a1->unk44.unk0.tilesVram = 0x6010000;
    a1->unk44.unk0.unk14 = 0x440;
    a1->unk44.unk0.animId = gUnk_0837283C[gLanguage][a1->unkE5 + 1].animId;
    a1->unk44.unk0.variant = gUnk_0837283C[gLanguage][a1->unkE5 + 1].variant;
    a1->unk44.unk0.unk16 = 0;
    a1->unk44.unk0.unk1B = 0xFF;
    a1->unk44.unk0.unk1C = 0x10;
    a1->unk44.unk0.palId = 4;
    a1->unk44.unk0.x = 4;
    a1->unk44.unk0.y = -20;
    a1->unk44.unk0.unk8 = 0xC0000;
    a1->unk44.unk28 = 0x10;
    a1->unk44.unk2C = -0x50;
    a1->unk44.unk30 = 0;
    a1->unk44.unk32 = 0;
    a1->unk44.unk34 = 0x1010;
    a1->unk44.unk36 = 0;
    a1->unk44.unk38 = NULL;
    a1->unk44.unk3C = NULL;
    a1->unk44.unk40 = NULL;
    a1->unk0.unk40 = &a1->unk44;
    a1->unk44.unk3C = &a1->unk0;
    a1->unk44.unk34 &= ~0x10;
    a1->unk0.unk38 = a2;
    a1->unk88 = NULL;
    a1->unk8C = NULL;
    if (a1->unk94 & 2) {
        a1->unk88 = sub_08134788(a1);
        a1->unk8C = sub_08133D44(a1);
        a1->unk90 = sub_081334DC(a1);
    }
}

static void sub_0812F404(struct Unk_08128F44_4 a1[], u8 a2, u8 a3, u8 a4, u16 a5) {
#ifndef NONMATCHING
    register struct Unk_08128F44_4 *r4 asm("r4");
    register int var asm("r0");
#else
    struct Unk_08128F44_4 *r4;
    int var;
#endif
    u8 buf[4];

    CpuFill32(0, &a1[0], sizeof(struct Unk_08128F44_4));
    a1[0].unk0.tilesVram = 0x6010000;
    a1[0].unk0.unk14 = 0x480;
    a1[0].unk0.animId = gUnk_083727DC[gLanguage][a4].animId;
    a1[0].unk0.variant = gUnk_083727DC[gLanguage][a4].variant;
    a1[0].unk0.unk16 = 0;
    a1[0].unk0.unk1B = 0xFF;
    a1[0].unk0.unk1C = 0x10;
    a1[0].unk0.palId = 4;
    a1[0].unk0.x = 0x38;
    a1[0].unk0.y = (a3 * 0x80 + 0x90) >> 2;
    a1[0].unk0.unk8 = 0xC0000;
    a1[0].unk28 = 0xE0;
    a1[0].unk2C = a3 * 0x80 + 0x90;
    a1[0].unk30 = 0;
    a1[0].unk32 = 0;
    a1[0].unk34 = 0x10;
    a1[0].unk36 = 0;
    a1[0].unk38 = NULL;
    a1[0].unk3C = NULL;
    a1[0].unk40 = NULL;
    CpuFill32(0, &a1[1], sizeof(struct Unk_08128F44_4));
    a1[1].unk0.tilesVram = 0x6010000;
    a1[1].unk0.unk14 = 0x480;
    a1[1].unk0.animId = gUnk_083726B8[gLanguage][0].animId;
    a1[1].unk0.variant = gUnk_083726B8[gLanguage][0].variant;
    a1[1].unk0.unk16 = 0;
    a1[1].unk0.unk1B = 0xFF;
    a1[1].unk0.unk1C = 0x10;
    a1[1].unk0.palId = a2;
    a1[1].unk0.x = 0x72;
    a1[1].unk0.y = (a3 * 0x80 + 0x90) >> 2;
    a1[1].unk0.unk8 = 0xC0000;
    a1[1].unk28 = 0x1C8;
    a1[1].unk2C = a3 * 0x80 + 0x90;
    a1[1].unk30 = 0;
    a1[1].unk32 = 0;
    a1[1].unk34 = 0x10;
    a1[1].unk36 = 0;
    a1[1].unk38 = NULL;
    a1[1].unk3C = NULL;
    a1[1].unk40 = NULL;
    sub_08133044(buf, a5);
    CpuFill32(0, r4 = &a1[2], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_0837283C[gLanguage][buf[3]].animId;
    r4->unk0.variant = gUnk_0837283C[gLanguage][buf[3]].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 4;
    r4->unk0.x = 0xA4;
    r4->unk0.y = (a3 * 0x80 + 0x9C) >> 2;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x290;
    r4->unk2C = a3 * 0x80 + 0x9C;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &a1[3], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_0837283C[gLanguage][buf[2]].animId;
    r4->unk0.variant = gUnk_0837283C[gLanguage][buf[2]].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 4;
    r4->unk0.x = 0xAC;
    r4->unk0.y = (a3 * 0x80 + 0x9C) >> 2;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x2B0;
    r4->unk2C = a3 * 0x80 + 0x9C;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &a1[4], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_0837283C[gLanguage][10].animId;
    r4->unk0.variant = gUnk_0837283C[gLanguage][10].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 4;
    r4->unk0.x = 0xB4;
    r4->unk0.y = (a3 * 0x80 + 0x9C) >> 2;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x2D0;
    r4->unk2C = a3 * 0x80 + 0x9C;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &a1[5], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_0837283C[gLanguage][buf[1]].animId;
    r4->unk0.variant = gUnk_0837283C[gLanguage][buf[1]].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 4;
    r4->unk0.x = 0xBC;
    r4->unk0.y = (a3 * 0x80 + 0x9C) >> 2;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x2F0;
    r4->unk2C = a3 * 0x80 + 0x9C;
    var = 0;
    r4->unk30 = var; // IDK why this is different from other cases :/
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    CpuFill32(0, r4 = &a1[6], sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = gUnk_0837283C[gLanguage][buf[0]].animId;
    r4->unk0.variant = gUnk_0837283C[gLanguage][buf[0]].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 4;
    r4->unk0.x = 0xC4;
    r4->unk0.y = (a3 * 0x80 + 0x9C) >> 2;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x310;
    r4->unk2C = a3 * 0x80 + 0x9C;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
}

void sub_0812F814(void) {
    CpuFill32(0, (void *)VRAM, VRAM_SIZE);
    if (gMainFlags & MAIN_FLAG_BG_PALETTE_TRANSFORMATION_ENABLE)
        LoadBgPaletteWithTransformation(gUnk_083729E0, 0, BG_PLTT_SIZE / sizeof(u16));
    else {
        DmaCopy16(3, gUnk_083729E0, gBgPalette, BG_PLTT_SIZE);
        gMainFlags |= MAIN_FLAG_BG_PALETTE_SYNC_ENABLE;
    }
    LZ77UnCompVram(gUnk_08372BE0, (void *)0x6000000);
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        LZ77UnCompVram(gUnk_083744AC, (void *)0x6000000);
        break;
    case LANGUAGE_ENGLISH:
        LZ77UnCompVram(gUnk_08375400, (void *)0x6000000);
        break;
    case LANGUAGE_GERMAN:
        LZ77UnCompVram(gUnk_08375798, (void *)0x6000000);
        break;
    case LANGUAGE_FRENCH:
        LZ77UnCompVram(gUnk_08374C50, (void *)0x6000000);
        break;
    case LANGUAGE_SPANISH:
        LZ77UnCompVram(gUnk_08375064, (void *)0x6000000);
        break;
    case LANGUAGE_ITALIAN:
        LZ77UnCompVram(gUnk_08374890, (void *)0x6000000);
        break;
    }
    LZ77UnCompVram(gUnk_08D61B54[gLanguage], (void *)0x6010000);
}

void sub_0812F91C(void) {
    struct Task *t;
    struct Unk_0812F91C *var;

    gRngVal = 0;
    gDispCnt = DISPCNT_MODE_0 | DISPCNT_OBJ_1D_MAP | DISPCNT_BG0_ON | DISPCNT_BG1_ON | DISPCNT_OBJ_ON;
    gBgCntRegs[0] = BGCNT_PRIORITY(1) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(28);
    gBgCntRegs[1] = BGCNT_PRIORITY(1) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(29);
    gBgCntRegs[2] = BGCNT_PRIORITY(0) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(30);
    gBldRegs.bldCnt = BLDCNT_TGT1_ALL | BLDCNT_EFFECT_LIGHTEN;
    gBldRegs.bldY = 0x10;
    gBgScrollRegs[0][0] = 0;
    gBgScrollRegs[0][1] = 0;
    gBgScrollRegs[1][0] = 0;
    gBgScrollRegs[1][1] = 0;
    gBgScrollRegs[2][0] = 0;
    gBgScrollRegs[2][1] = 0;
    t = TaskCreate(sub_0812FA28, sizeof(struct Unk_0812F91C), 0x100, TASK_USE_IWRAM, sub_08133118);
    var = TaskGetStructPtr(t);
    CpuFill16(0, var, sizeof(struct Unk_0812F91C));
    var->unk57C = gUnk_0203AD14;
    var->unk10 = sub_08128D48(&gUnk_0837EAF4);
    var->unk14[0] = sub_08128E28(&gUnk_0837EB08);
    var->unk14[1] = sub_08128E28(&gUnk_0837EC14);
    var->unk14[2] = sub_08128E28(&gUnk_0837EE88);
    var->unk528 = 0;
    var->unk529 = 0;
    var->unk52A = 0;
    m4aMPlayAllStop();
}

static void sub_0812FA28(void) {
    struct Unk_08128F44_4 *r4;
#ifndef NONMATCHING
    register u32 r5 asm("r5"), r6 asm("r6");
#else
    u32 r5, r6;
#endif
    struct Unk_02021590 r7;
    struct Sprite sprites[NUM_LANGUAGES][7];
    struct Unk_0812F91C *tmp, *var;

    CreatePauseFade(-0x10, 1);
    tmp = TaskGetStructPtr(gCurTask);
    var = tmp;
    gCurTask->main = sub_08130534;
    // This is completely pointless as every case is doing the same thing except for using different buffers
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        SpriteInitNoPointer(&sprites[LANGUAGE_JAPANESE][0], 0x6010000, 0x480, 0x347, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][1], 0x6010000, 0x480, 0x347, 0xD,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][2], 0x6010000, 0x480, 0x347, 0xC,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][3], 0x6010000, 0x480, 0x347, 0xE,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][4], 0x6010000, 0x480, 0x348, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][5], 0x6010000, 0x480, 0x34D, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][6], 0x6010000, 0x480, 0x348, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        break;
    case LANGUAGE_ENGLISH:
        SpriteInit(&sprites[LANGUAGE_ENGLISH][0], 0x6010000, 0x480, 0x347, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][1], 0x6010000, 0x480, 0x347, 0xD,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][2], 0x6010000, 0x480, 0x347, 0xC,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][3], 0x6010000, 0x480, 0x347, 0xE,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][4], 0x6010000, 0x480, 0x348, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][5], 0x6010000, 0x480, 0x34D, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][6], 0x6010000, 0x480, 0x348, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        break;
    case LANGUAGE_GERMAN:
        SpriteInit(&sprites[LANGUAGE_GERMAN][0], 0x6010000, 0x480, 0x347, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][1], 0x6010000, 0x480, 0x347, 0xD,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][2], 0x6010000, 0x480, 0x347, 0xC,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][3], 0x6010000, 0x480, 0x347, 0xE,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][4], 0x6010000, 0x480, 0x348, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][5], 0x6010000, 0x480, 0x34D, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][6], 0x6010000, 0x480, 0x348, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        break;
    case LANGUAGE_FRENCH:
        SpriteInit(&sprites[LANGUAGE_FRENCH][0], 0x6010000, 0x480, 0x347, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][1], 0x6010000, 0x480, 0x347, 0xD,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][2], 0x6010000, 0x480, 0x347, 0xC,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][3], 0x6010000, 0x480, 0x347, 0xE,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][4], 0x6010000, 0x480, 0x348, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][5], 0x6010000, 0x480, 0x34D, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][6], 0x6010000, 0x480, 0x348, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        break;
    case LANGUAGE_SPANISH:
        SpriteInit(&sprites[LANGUAGE_SPANISH][0], 0x6010000, 0x480, 0x347, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][1], 0x6010000, 0x480, 0x347, 0xD,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][2], 0x6010000, 0x480, 0x347, 0xC,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][3], 0x6010000, 0x480, 0x347, 0xE,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][4], 0x6010000, 0x480, 0x348, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][5], 0x6010000, 0x480, 0x34D, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][6], 0x6010000, 0x480, 0x348, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        break;
    case LANGUAGE_ITALIAN:
        SpriteInit(&sprites[LANGUAGE_ITALIAN][0], 0x6010000, 0x480, 0x347, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][1], 0x6010000, 0x480, 0x347, 0xD,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][2], 0x6010000, 0x480, 0x347, 0xC,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][3], 0x6010000, 0x480, 0x347, 0xE,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][4], 0x6010000, 0x480, 0x348, 0,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][5], 0x6010000, 0x480, 0x34D, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][6], 0x6010000, 0x480, 0x348, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        break;
    }
    CpuCopy32(gUnk_08376854, (void *)0x600E000, sizeof(gUnk_08376854));
    CpuCopy32(gUnk_08376054, (void *)0x600E800, sizeof(gUnk_08376054));
    CpuCopy32(gUnk_08375B54, (void *)0x600F000, sizeof(gUnk_08375B54));
    var->unk0 = NULL;
    var->unk4 = NULL;
    var->unk8[0] = 0;
    var->unk8[1] = 0;
    var->unk3D0[0] = 0;
    var->unk3D0[1] = 0;
    var->unk3D0[2] = 0;
    var->unk3D0[3] = 0;
    var->unk57A = 0;
    r6 = var->unk52A;
    r5 = var->unk52A;
    var->unk52A = 0;
    if (var->unk528 == 5 && var->unk529 == 0xA) {
        m4aSongNumStart(565);
        var->unk52A |= 1;
    }
    if (r5 &= 1)
        var->unk52A |= 1;
    if (r6 &= 2)
        var->unk52A |= 2;
    var->unk528 = 0;
    var->unk529 = 0;
    var->unk579 = gUnk_0203AD3C;
    var->unk57D = var->unk579;
    var->unk57E = 0;
    sub_081316F0(var);
    sub_0812F0E0(&var->unk20[0], var->unk8, var->unk52C, 0);
    sub_0812F0E0(&var->unk20[1], var->unk8, var->unk52C, 1);
    sub_0812F0E0(&var->unk20[2], var->unk8, var->unk52C, 2);
    sub_0812F0E0(&var->unk20[3], var->unk8, var->unk52C, 3);
    sub_081317FC(var);
    sub_08132800(var);
    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        r7.animId = 0x348;
        r7.variant = 6;
        break;
    case LANGUAGE_ENGLISH:
        r7.animId = 0x348;
        r7.variant = 6;
        break;
    case LANGUAGE_GERMAN:
        r7.animId = 0x348;
        r7.variant = 6;
        break;
    case LANGUAGE_FRENCH:
        r7.animId = 0x348;
        r7.variant = 6;
        break;
    case LANGUAGE_SPANISH:
        r7.animId = 0x348;
        r7.variant = 6;
        break;
    case LANGUAGE_ITALIAN:
        r7.animId = 0x348;
        r7.variant = 6;
        break;
    }
    CpuFill32(0, r4 = &var->unk418, sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x480;
    r4->unk0.animId = r7.animId;
    r4->unk0.variant = r7.variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 4;
    r4->unk0.x = 0;
    r4->unk0.y = 0;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0;
    r4->unk2C = 0;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x810;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    var->unk418.unk38 = var->unk8;
    var->unk570 = var->unk20[var->unk579].unkD8;
    var->unk574 = var->unk20[var->unk579].unkDC;
    var->unk578 = var->unk20[var->unk579].unkE0;
    m4aSongNumStart(30);
}

static void sub_08130534(void) {
    struct Unk_0812F91C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    var->unk20[1].unkE8 = Rand32();
    var->unk20[2].unkE8 = Rand32();
    var->unk20[3].unkE8 = Rand32();
    var->unk4B8 = Rand32();
    var->unk20[0].unkC8 = var->unk20[0].unkC0;
    var->unk20[0].unkCC = var->unk20[0].unkC4;
    var->unk20[1].unkC8 = var->unk20[1].unkC0;
    var->unk20[1].unkCC = var->unk20[1].unkC4;
    var->unk20[2].unkC8 = var->unk20[2].unkC0;
    var->unk20[2].unkCC = var->unk20[2].unkC4;
    var->unk20[3].unkC8 = var->unk20[3].unkC0;
    var->unk20[3].unkCC = var->unk20[3].unkC4;
    var->unk20[0].unkB3 = var->unk20[0].unkB2;
    var->unk20[0].unkB2 = sub_081332D0(&var->unk20[0], 0, 0x20);
    var->unk20[1].unkB3 = var->unk20[1].unkB2;
    var->unk20[1].unkB2 = sub_081332D0(&var->unk20[1], 0, 0x20);
    var->unk20[2].unkB3 = var->unk20[2].unkB2;
    var->unk20[2].unkB2 = sub_081332D0(&var->unk20[2], 0, 0x20);
    var->unk20[3].unkB3 = var->unk20[3].unkB2;
    var->unk20[3].unkB2 = sub_081332D0(&var->unk20[3], 0, 0x20);
    sub_08131C88(&var->unk20[0]);
    sub_08131C88(&var->unk20[1]);
    sub_08131C88(&var->unk20[2]);
    sub_08131C88(&var->unk20[3]);
    sub_08133164(&var->unk20[0]);
    sub_08133164(&var->unk20[1]);
    sub_08133164(&var->unk20[2]);
    sub_08133164(&var->unk20[3]);
    sub_0813318C(&var->unk20[0]);
    sub_0813318C(&var->unk20[1]);
    sub_0813318C(&var->unk20[2]);
    sub_0813318C(&var->unk20[3]);
    sub_08131D54(&var->unk20[0]);
    sub_08131D54(&var->unk20[1]);
    sub_08131D54(&var->unk20[2]);
    sub_08131D54(&var->unk20[3]);
    sub_08131F78(&var->unk20[0]);
    sub_08131F78(&var->unk20[1]);
    sub_08131F78(&var->unk20[2]);
    sub_08131F78(&var->unk20[3]);
    sub_08132034(var->unk20, var->unk45C, var->unk524);
    sub_08132350(&var->unk20[0]);
    sub_08132350(&var->unk20[1]);
    sub_08132350(&var->unk20[2]);
    sub_08132350(&var->unk20[3]);
    sub_08132540(&var->unk20[0]);
    sub_08132540(&var->unk20[1]);
    sub_08132540(&var->unk20[2]);
    sub_08132540(&var->unk20[3]);
    sub_081331F0(&var->unk20[0], var->unk8);
    sub_081331F0(&var->unk20[1], var->unk8);
    sub_081331F0(&var->unk20[2], var->unk8);
    sub_081331F0(&var->unk20[3], var->unk8);
    if (!(var->unk20[var->unk579].unkB0 & 0x20)) {
        var->unk8[0] = -var->unk20[var->unk579].unkC0 + 0x100;
        var->unk8[1] = -var->unk20[var->unk579].unkC4 - var->unk20[var->unk579].unkD0 + 0x140;
        if (var->unk8[1] > -0x20)
            var->unk8[1] = -0x20;
        else if (var->unk8[1] < -0x180)
            var->unk8[1] = -0x180;
        var->unk570 = var->unk20[var->unk579].unkD8;
        var->unk574 = var->unk20[var->unk579].unkDC;
        var->unk578 = var->unk20[var->unk579].unkE0;
        gBgScrollRegs[0][0] = var->unk578 & 7;
        gBgScrollRegs[0][1] = -(var->unk8[1] >> 2);
        gBgScrollRegs[1][0] = -((var->unk8[0] >> 3) & 0xFF);
        gBgScrollRegs[1][1] = -(var->unk8[1] >> 2);
        gUnk_03000530 = var;
        gUnk_03002470[gUnk_03006070++] = sub_08132AC8;
        gMainFlags |= 0x10;
    }
    sub_08132888(var);
    sub_08133248(&var->unk20[0]);
    sub_08133248(&var->unk20[1]);
    sub_08133248(&var->unk20[2]);
    sub_08133248(&var->unk20[3]);
    sub_081325A4(var);
    if (var->unk20[0].unkC0 > var->unk568
        && var->unk20[1].unkC0 > var->unk568
        && var->unk20[2].unkC0 > var->unk568
        && var->unk20[3].unkC0 > var->unk568) {
        if (var->unk52A & 2) {
            var->unk20[0].unk44.unk34 &= ~0x1000;
            var->unk20[1].unk44.unk34 &= ~0x1000;
            var->unk20[2].unk44.unk34 &= ~0x1000;
            var->unk20[3].unk44.unk34 &= ~0x1000;
        }
        var->unk20[0].unk94 &= ~0x10;
        var->unk20[1].unk94 &= ~0x10;
        var->unk20[2].unk94 &= ~0x10;
        var->unk20[3].unk94 &= ~0x10;
        sub_081343EC();
        gCurTask->main = sub_081309B0;
        m4aSongNumStart(29);
    }
}

static void sub_081309B0(void) {
    struct Unk_0812F91C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    var->unk20[1].unkE8 = Rand32();
    var->unk20[2].unkE8 = Rand32();
    var->unk20[3].unkE8 = Rand32();
    var->unk4B8 = Rand32();
    var->unk20[0].unkC8 = var->unk20[0].unkC0;
    var->unk20[0].unkCC = var->unk20[0].unkC4;
    var->unk20[1].unkC8 = var->unk20[1].unkC0;
    var->unk20[1].unkCC = var->unk20[1].unkC4;
    var->unk20[2].unkC8 = var->unk20[2].unkC0;
    var->unk20[2].unkCC = var->unk20[2].unkC4;
    var->unk20[3].unkC8 = var->unk20[3].unkC0;
    var->unk20[3].unkCC = var->unk20[3].unkC4;
    sub_08131948(var->unk45C, var->unk524);
    sub_081315AC(var);
    sub_081319BC(&var->unk20[0]);
    sub_081319BC(&var->unk20[1]);
    sub_081319BC(&var->unk20[2]);
    sub_081319BC(&var->unk20[3]);
    var->unk20[0].unkB3 = var->unk20[0].unkB2;
    var->unk20[0].unkB2 = sub_081332D0(&var->unk20[0], 0, 0x20);
    var->unk20[1].unkB3 = var->unk20[1].unkB2;
    var->unk20[1].unkB2 = sub_081332D0(&var->unk20[1], 0, 0x20);
    var->unk20[2].unkB3 = var->unk20[2].unkB2;
    var->unk20[2].unkB2 = sub_081332D0(&var->unk20[2], 0, 0x20);
    var->unk20[3].unkB3 = var->unk20[3].unkB2;
    var->unk20[3].unkB2 = sub_081332D0(&var->unk20[3], 0, 0x20);
    sub_08131A6C(&var->unk20[0]);
    sub_08131A6C(&var->unk20[1]);
    sub_08131A6C(&var->unk20[2]);
    sub_08131A6C(&var->unk20[3]);
    sub_08131C20(&var->unk20[0]);
    sub_08131C20(&var->unk20[1]);
    sub_08131C20(&var->unk20[2]);
    sub_08131C20(&var->unk20[3]);
    sub_08131C88(&var->unk20[0]);
    sub_08131C88(&var->unk20[1]);
    sub_08131C88(&var->unk20[2]);
    sub_08131C88(&var->unk20[3]);
    sub_08133164(&var->unk20[0]);
    sub_08133164(&var->unk20[1]);
    sub_08133164(&var->unk20[2]);
    sub_08133164(&var->unk20[3]);
    sub_0813318C(&var->unk20[0]);
    sub_0813318C(&var->unk20[1]);
    sub_0813318C(&var->unk20[2]);
    sub_0813318C(&var->unk20[3]);
    if (var->unk20[0].unkC0 > var->unk56C)
        var->unk20[0].unkA8 = 0;
    if (var->unk20[1].unkC0 > var->unk56C)
        var->unk20[1].unkA8 = 0;
    if (var->unk20[2].unkC0 > var->unk56C)
        var->unk20[2].unkA8 = 0;
    if (var->unk20[3].unkC0 > var->unk56C)
        var->unk20[3].unkA8 = 0;
    sub_08131D54(&var->unk20[0]);
    sub_08131D54(&var->unk20[1]);
    sub_08131D54(&var->unk20[2]);
    sub_08131D54(&var->unk20[3]);
    if (var->unk20[var->unk579].unkB0 & 0x20 && !var->unk20[var->unk579].unkE6) {
        var->unk0 = sub_0813457C();
        m4aSongNumStart(31);
    }
    sub_081331CC(&var->unk20[0], var->unk57A);
    sub_081331CC(&var->unk20[1], var->unk57A);
    sub_081331CC(&var->unk20[2], var->unk57A);
    sub_081331CC(&var->unk20[3], var->unk57A);
    sub_08131F78(&var->unk20[0]);
    sub_08131F78(&var->unk20[1]);
    sub_08131F78(&var->unk20[2]);
    sub_08131F78(&var->unk20[3]);
    if (var->unk20[var->unk579].unkB0 & 0x20)
        sub_08132160(var->unk20, var->unk45C, var->unk524);
    else
        sub_08132034(var->unk20, var->unk45C, var->unk524);
    sub_08132280(&var->unk20[0], var->unk45C, var->unk524);
    sub_08132280(&var->unk20[1], var->unk45C, var->unk524);
    sub_08132280(&var->unk20[2], var->unk45C, var->unk524);
    sub_08132280(&var->unk20[3], var->unk45C, var->unk524);
    sub_08132350(&var->unk20[0]);
    sub_08132350(&var->unk20[1]);
    sub_08132350(&var->unk20[2]);
    sub_08132350(&var->unk20[3]);
    sub_08132498(&var->unk20[0]);
    sub_08132498(&var->unk20[1]);
    sub_08132498(&var->unk20[2]);
    sub_08132498(&var->unk20[3]);
    sub_08132540(&var->unk20[0]);
    sub_08132540(&var->unk20[1]);
    sub_08132540(&var->unk20[2]);
    sub_08132540(&var->unk20[3]);
    sub_081331F0(&var->unk20[0], var->unk8);
    sub_081331F0(&var->unk20[1], var->unk8);
    sub_081331F0(&var->unk20[2], var->unk8);
    sub_081331F0(&var->unk20[3], var->unk8);
    if (var->unk20[var->unk579].unkB0 & 0x20) {
        if (var->unk20[var->unk579].unk98 & 0x300) {
            if (++var->unk57D > 3) var->unk57D = 0;
            if (var->unk20[var->unk57D].unkB0 & 0x20)
                var->unk8[1] = -0x180;
        }
        if (var->unk20[var->unk57D].unkB0 & 0x20) {
            switch (var->unk57C) {
            case 0:
                var->unk8[0] = -0x8C75;
                break;
            case 1:
                var->unk8[0] = -0xB470;
                break;
            case 2:
                var->unk8[0] = -0xDC74;
                break;
            }
        }
        else {
            var->unk8[0] = -var->unk20[var->unk57D].unkC0 + 0x100;
            var->unk8[1] = -var->unk20[var->unk57D].unkC4 - var->unk20[var->unk57D].unkD0 + 0x140;
        }
        if (var->unk8[1] > -0x20)
            var->unk8[1] = -0x20;
        else if (var->unk8[1] < -0x180)
            var->unk8[1] = -0x180;
        var->unk570 = var->unk20[var->unk57D].unkD8;
        var->unk574 = var->unk20[var->unk57D].unkDC;
        var->unk578 = var->unk20[var->unk57D].unkE0;
        if (var->unk20[var->unk57D].unkB0 & 0x20) {
            var->unk570 = gUnk_0837EA54[11];
            var->unk574 = gUnk_0837EA54[0];
            var->unk578 = 0x24;
        }
        gBgScrollRegs[0][0] = var->unk578 & 7;
        gBgScrollRegs[0][1] = -(var->unk8[1] >> 2);
        gBgScrollRegs[1][0] = -((var->unk8[0] >> 3) & 0xFF);
        gBgScrollRegs[1][1] = -(var->unk8[1] >> 2);
    }
    else {
        var->unk8[0] = -var->unk20[var->unk579].unkC0 + 0x100;
        var->unk8[1] = -var->unk20[var->unk579].unkC4 - var->unk20[var->unk579].unkD0 + 0x140;
        if (var->unk8[1] > -0x20)
            var->unk8[1] = -0x20;
        else if (var->unk8[1] < -0x180)
            var->unk8[1] = -0x180;
        var->unk570 = var->unk20[var->unk579].unkD8;
        var->unk574 = var->unk20[var->unk579].unkDC;
        var->unk578 = var->unk20[var->unk579].unkE0;
        gBgScrollRegs[0][0] = var->unk578 & 7;
        gBgScrollRegs[0][1] = -(var->unk8[1] >> 2);
        gBgScrollRegs[1][0] = -((var->unk8[0] >> 3) & 0xFF);
        gBgScrollRegs[1][1] = -(var->unk8[1] >> 2);
    }
    gUnk_03000530 = var;
    gUnk_03002470[gUnk_03006070++] = sub_08132AC8;
    gMainFlags |= 0x10;
    sub_08132650(var);
    sub_08133280(&var->unk20[0]);
    sub_08133280(&var->unk20[1]);
    sub_08133280(&var->unk20[2]);
    sub_08133280(&var->unk20[3]);
    sub_08132888(var);
    sub_08133248(&var->unk20[0]);
    sub_08133248(&var->unk20[1]);
    sub_08133248(&var->unk20[2]);
    sub_08133248(&var->unk20[3]);
    sub_081325A4(var);
    if (var->unk20[0].unkC0 > var->unk56C
        && var->unk20[1].unkC0 > var->unk56C
        && var->unk20[2].unkC0 > var->unk56C
        && var->unk20[3].unkC0 > var->unk56C) {
        TaskDestroy(var->unk0);
        var->unk0 = NULL;
        TaskDestroy(var->unk20[var->unk579].unk88);
        TaskDestroy(var->unk20[var->unk579].unk8C);
        TaskDestroy(var->unk20[var->unk579].unk90);
        var->unk20[var->unk579].unk88 = NULL;
        var->unk20[var->unk579].unk8C = NULL;
        var->unk20[var->unk579].unk90 = NULL;
        CreatePauseFade(0x10, 1);
        gCurTask->main = sub_0813119C;
        m4aMPlayAllStop();
    }
    ++var->unk57A;
}

static void sub_0813119C(void) {
    struct Unk_0812F91C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    struct Unk_0813119C *var2;

    if (!sub_0812A304()) {
        gBgScrollRegs[1][0] = 0;
        gBgScrollRegs[1][1] = 0x50;
        CreatePauseFade(-0x10, 1);
        gCurTask->main = sub_0813134C;
        var->unk20[0].unkD8 = gUnk_0837EA54[12];
        var->unk20[0].unkDC = gUnk_0837EA54[0];
        var->unk20[0].unkE0 = 0;
        var->unk20[1].unkD8 = gUnk_0837EA54[12];
        var->unk20[1].unkDC = gUnk_0837EA54[0];
        var->unk20[1].unkE0 = 0;
        var->unk20[2].unkD8 = gUnk_0837EA54[12];
        var->unk20[2].unkDC = gUnk_0837EA54[0];
        var->unk20[2].unkE0 = 0;
        var->unk20[3].unkD8 = gUnk_0837EA54[12];
        var->unk20[3].unkDC = gUnk_0837EA54[0];
        var->unk20[3].unkE0 = 0;
        var->unk570 = var->unk20[var->unk579].unkD8;
        var->unk574 = var->unk20[var->unk579].unkDC;
        var->unk578 = var->unk20[var->unk579].unkE0;
        gUnk_03000530 = var;
        gUnk_03002470[gUnk_03006070++] = sub_08132AC8;
        gMainFlags |= 0x10;
        sub_081326F8(var);
        var->unk0 = TaskCreate(sub_08132B84, sizeof(struct Unk_0813119C), 0x100, TASK_USE_IWRAM, NULL);
        var2 = TaskGetStructPtr(var->unk0);
        var2->unk0 = var;
        if (!var->unk20[var->unk579].unkE5)
            m4aSongNumStart(33);
        else
            m4aSongNumStart(32);
    }
}

static void sub_0813134C(void) {
    struct Unk_0812F91C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    struct Unk_08128F44 *var2;
    u16 r1, r2;

    if (!sub_0812A304()) {
        if (!var->unk4) {
            if (gUnk_0203AD10 & 2) {
                r2 = gUnk_020382D0.unk8[1][0];
                r1 = gUnk_020382D0.unk8[0][0];
            }
            else {
                r2 = gPressedKeys;
                r1 = gInput;
            }
            if (r2 & 1) {
                if (gUnk_0203AD3C)
                    var->unk4 = sub_08128F44(gUnk_08372628[gLanguage], 0xD, 0xE, 0x50, 0x50, 1);
                else
                    var->unk4 = sub_08128F44(gUnk_08372628[gLanguage], 0xD, 0xE, 0x50, 0x50, 0);
            }
            else if (r1 & 4) {
                if (r2 & 0x200)
                    ++var->unk528;
                else if (r2 & 0x100)
                    ++var->unk529;
            }
        }
        else {
            var2 = TaskGetStructPtr(var->unk4);
            if (sub_0812A328(var2)) {
                CreatePauseFade(0x10, 1);
                var->unk57C = var2->unk2AD;
                if (var2->unk2AC & 0x10)
                    gCurTask->main = sub_081314C8;
                else
                    gCurTask->main = sub_08131524;
            }
        }
    }
}

static void sub_081314C8(void) {
    struct Unk_0812F91C *var = TaskGetStructPtr(gCurTask);

    if (!sub_0812A304()) {
        m4aMPlayAllStop();
        gCurTask->main = sub_0812FA28;
        TaskDestroy(var->unk0);
        var->unk0 = NULL;
        TaskDestroy(var->unk4);
        var->unk4 = NULL;
    }
}

static void sub_08131524(void) {
    struct Unk_0812F91C *var = TaskGetStructPtr(gCurTask), *varAlias = var;

    ++var; --var;
    if (!sub_0812A304()) {
        TaskDestroy(varAlias->unk0);
        varAlias->unk0 = NULL;
        TaskDestroy(varAlias->unk4);
        varAlias->unk4 = NULL;
        if (gUnk_0203AD10 & 2)
            gUnk_020382D0.unk4 &= ~2;
        var->unk57E = 0;
        gCurTask->main = sub_081330AC;
    }
}

static void sub_081315AC(struct Unk_0812F91C *a1) {
    u8 i;
    u8 idx;
    bool32 b;

    for (i = 0; i < 4; ) {
        if (a1->unk20[i].unk94 & 1) {
            a1->unk20[i].unk9C = a1->unk20[i].unk9A;
            idx = a1->unk57C;
            gUnk_020382D0.unk0 = gUnk_020382D0.unk0; // toggle unrolled expressions
            b = FALSE; // preload 0
            b = (Rand16() & 0xF) < gUnk_083729A4[idx][a1->unk20[i].unkB2];
            a1->unk20[i].unk9A = b;
            a1->unk20[i].unk98 = a1->unk20[i].unk9A & (a1->unk20[i].unk9A ^ a1->unk20[i].unk9C);
            a1->unk20[i].unk9E = 0;
        }
        else if (gUnk_0203AD10 & 2) {
            a1->unk20[i].unk9C = a1->unk20[i].unk9A;
            a1->unk20[i].unk9A = gUnk_020382D0.unk8[0][i];
            a1->unk20[i].unk98 = gUnk_020382D0.unk8[1][i];
            a1->unk20[i].unk9E = gUnk_020382D0.unk8[2][i];
        }
        else {
            a1->unk20[i].unk9C = gPrevInput;
            a1->unk20[i].unk9A = gInput;
            a1->unk20[i].unk98 = gPressedKeys;
            a1->unk20[i].unk9E = gReleasedKeys;
        }
#ifndef NONMATCHING
        do {
            asm(""::"r"(i));
            ++i;
        } while (0);
#else
        ++i;
#endif
    }
}

static void sub_081316F0(struct Unk_0812F91C *a1) {
    u8 i;
    u8 r7;
    u8 r8;

    CpuFill32(0, a1->unk52C, sizeof(a1->unk52C));
    r7 = 0xA;
    switch (a1->unk57C) {
    case 0:
        r7 = 0x24;
        break;
    case 1:
        r7 = 0x2E;
        break;
    case 2:
        r7 = 0x38;
        break;
    }
    r8 = 9;
    for (i = 0; i < r7; i += 1) {
        u32 r = Rand16();

        a1->unk52C[i] = r % r8;
    }
    for (i = 0; i < r7; i += 2)
        a1->unk52C[i] = 9;
    a1->unk52C[0] = 0xA;
    a1->unk52C[1] = 0;
    a1->unk52C[r7 - 2] = 0;
    a1->unk52C[r7 - 1] = 0xB;
    a1->unk52C[r7] = 0;
    a1->unk568 = 0x400;
    a1->unk56C = (r7 + 1) * 0x400;
}

static inline struct Unk_0812F91C_45C *BeYourself2(struct Unk_0812F91C_45C *a1) {
    return a1;
}

static void sub_081317FC(struct Unk_0812F91C *a1) {
    struct Unk_0812F91C_45C *r2;
    const u8 *r4;
    u8 k, j;
    u8 i = 0;
    u8 sb, ip;
    u8 sp00 = 8;

    switch (a1->unk57C) {
    case 0:
        sp00 = 0x24;
        break;
    case 1:
        sp00 = 0x2E;
        break;
    case 2:
        sp00 = 0x38;
        break;
    }
    a1->unk524 = 0;
    for (j = 0; j < sp00; ++j) {
        u8 idx = a1->unk52C[j];

        ip = gUnk_0837EABC[idx];
        sb = gUnk_0837EAC9[idx];
        for (k = 0; k < ip; ++k) {
            u32 r1 = i++;
            u32 idx2 = sb + k;

            r2 = BeYourself2(&a1->unk45C[r1]);
            r4 = gUnk_0837EAD8[idx2];
            r2->unk0 = 4 * r4[0] + 0x400 * j;
            r2->unk4 = 4 * r4[1];
            r2->unk8 = r2->unk4 - 0x20 * (r4[2] / 0x10);
            r2->unkC = r2->unk4 + 0x20 * (r4[2] & 0xF);
            r2->unk10 = r4[3];
            r2->unk12 = 0x100;
            if (i > 9) {
                a1->unk524 = 0;
                if (a1->unk52A & 1)
                    a1->unk524 = i;
                return;
            }
        }
    }
    a1->unk524 = 0;
    if (a1->unk52A & 1)
        a1->unk524 = i;
}

static void sub_08131948(struct Unk_0812F91C_45C *a1, u8 a2) {
    u8 i;

    for (i = 0; i < a2; ++i) {
        if (a1[i].unk12 & 0x100) {
            a1[i].unk4 -= abs(a1[i].unk10);
            if (a1[i].unk4 < a1[i].unk8)
                a1[i].unk12 &= ~0x100;
        }
        else {
            a1[i].unk4 += abs(a1[i].unk10);
            if (a1[i].unk4 > a1[i].unkC)
                a1[i].unk12 |= 0x100;
        }
    }
}

static void sub_081319BC(struct Unk_0812F91C_20 *a1) {
    a1->unk94 |= 0x20;
    if (a1->unk94 & 0x10)
        a1->unk94 &= ~0x20;
    if (a1->unkB0 & 0x20)
        a1->unk94 &= ~0x20;
    if (a1->unk94 & 0x20
        && a1->unk98 & 1
        && a1->unkE4 < 2) {
        ++a1->unkE4;
        if (!(a1->unkA4 & 0x400)) {
            a1->unkA4 |= 1;
            a1->unkA4 |= 2;
            a1->unkA2 = 0;
            a1->unkA0 = 6;
            a1->unkBF = 1;
            if (a1->unk94 & 2)
                m4aSongNumStart(557);
        }
    }
}

static void sub_08131A6C(struct Unk_0812F91C_20 *a1) {
    if (!a1->unkB8)
        a1->unkA4 &= ~0x1000;
    else {
        --a1->unkB8;
        a1->unkA4 |= 0x1000;
    }
    if (a1->unkA4 & 2) {
        a1->unkA4 &= ~2;
        if (!(a1->unkA4 & 0x1000)) {
            if (a1->unkB2 == 8 || a1->unkB2 == 0xB) {
                a1->unkA8 += 0x140;
                a1->unkA0 = 5;
                sub_08133EEC(a1, 0);
                if (a1->unk94 & 2) {
                    sub_081347D8(a1, 0, a1->unkE8);
                    sub_08133344(a1);
                    if (a1->unk94 & 2)
                        m4aSongNumStart(562);
                }
                a1->unkA4 |= 0x1000;
                a1->unkB8 = 0xA;
            }
            else if (a1->unkB2 == 9 || a1->unkB2 == 0xC) {
                a1->unkA8 += 0x180;
                a1->unkA0 = 5;
                sub_08133EEC(a1, 1);
                if (a1->unk94 & 2) {
                    sub_081347D8(a1, 1, a1->unkE8);
                    sub_08133344(a1);
                    if (a1->unk94 & 2)
                        m4aSongNumStart(562);
                }
                a1->unkA4 |= 0x1000;
                a1->unkB8 = 0xA;
            }
            else if (a1->unkB2 == 0xA || a1->unkB2 == 0xD) {
                a1->unkA8 += 0x1C0;
                a1->unkA0 = 6;
                sub_08133EEC(a1, 2);
                a1->unk0.unk0.animId = gUnk_083726B8[gLanguage][8].animId;
                a1->unk0.unk0.variant = gUnk_083726B8[gLanguage][8].variant;
                a1->unk0.unk0.unk1B = 0xFF;
                if (a1->unk94 & 2) {
                    sub_081347D8(a1, 2, a1->unkE8);
                    sub_08133344(a1);
                    if (a1->unk94 & 2)
                        m4aSongNumStart(562);
                }
                a1->unkA4 |= 0x1000;
                a1->unkB8 = 0xA;
            }
        }
    }
}

static void sub_08131C20(struct Unk_0812F91C_20 *a1) {
    if (!(a1->unkA4 & 1)
        && gUnk_08372944[a1->unkB3] > gUnk_08372944[a1->unkB2]) {
        a1->unkA4 |= 1;
        a1->unkA4 |= 0x10;
        a1->unkA2 = 0;
        a1->unkA0 = gUnk_08372944[sub_081332D0(a1, 0, 0x20)] + (a1->unkA8 >> 8);
    }
}

static void sub_08131C88(struct Unk_0812F91C_20 *a1) {
    if (a1->unkA4 & 1) {
        s16 var = a1->unkA0 * a1->unkA2 - (a1->unkA2 * a1->unkA2 * a1->unkA1 >> 1);

        if (var < 0) {
            a1->unkA4 &= ~1;
            a1->unkA4 &= ~0x10;
            a1->unkA2 = 0;
            a1->unkAC = a1->unkC4;
        }
        else {
            if (var >= 0x20)
                a1->unkAA = -0x20;
            else
                a1->unkAA = -var;
            ++a1->unkA2;
        }
    }
    else {
        s16 var = a1->unkA2 * a1->unkA2 * a1->unkA1 >> 1;

        if (var >= 0x10)
            a1->unkAA = 0x10;
        else {
            a1->unkAA = var;
            ++a1->unkA2;
        }
    }
}

static void sub_08131D54(struct Unk_0812F91C_20 *a1) {
    a1->unkB0 &= ~0x1F;
    if (sub_081332D0(a1, 0, 0)) {
        if (sub_081332D0(a1, 0, 0) == 0xE || sub_081332D0(a1, 0, 0) == 0xF)
            a1->unkB0 |= 0x20;
        a1->unkB0 |= 1;
    }
    if (sub_081332D0(a1, -0x20, 0))
        a1->unkB0 |= 2;
    if (sub_081332D0(a1, 0, -0x20)) {
        if (sub_081332D0(a1, 0, 0) == 0xE || sub_081332D0(a1, 0, 0) == 0xF)
            a1->unkB0 |= 0x20;
        a1->unkB0 |= 4;
    }
    if (sub_081332D0(a1, 0x20, 0))
        a1->unkB0 |= 8;
    if (sub_081332D0(a1, 0, 0x20)) {
        if (sub_081332D0(a1, 0, 0) == 0xE || sub_081332D0(a1, 0, 0) == 0xF)
            a1->unkB0 |= 0x20;
        a1->unkB0 |= 0x10;
        if (a1->unkAC) {
            if (a1->unkA4 & 0x40) {
                a1->unkA4 &= ~0x40;
                a1->unkAC -= a1->unkC4;
                if (a1->unkAC <= -0x60) {
                    a1->unkA4 |= 0x80;
                    a1->unkAC = 0;
                    a1->unkE4 = 0;
                    if (!(a1->unk94 & 2)) return;
                    m4aSongNumStart(558);
                }
            }
            else {
                a1->unkAC = 0;
            }
        }
        if (a1->unk94 & 2) {
            if (sub_081332D0(a1, 0, 0x20) == 1) {
                if (a1->unkB3 == 1) {
                    sub_08134720(a1->unk90);
                    sub_08133688(a1->unk90, 1);
                }
                else {
                    sub_08134754(a1->unk90);
                }
            }
            else {
                sub_08134720(a1->unk90);
                sub_08133688(a1->unk90, 0);
            }
        }
    }
    else {
        a1->unkA4 |= 0x40;
        if (a1->unk94 & 2)
            sub_08134754(a1->unk90);
    }
}

static void sub_08131F78(struct Unk_0812F91C_20 *a1) {
    s16 r1 = a1->unkC4 / 0x20u;
    u32 idx;

    if (a1->unkB0 & 1 || a1->unkB0 & 0x10) {
        while (gUnk_08372954[sub_081332FC(a1->unkC0, 0x20 * r1, a1->unkD4)])
            if (--r1 < 0) r1 = 0;
        a1->unkC4 = 0x20 * r1;
        idx = gUnk_08372954[sub_081332D0(a1, 0, 0x20)];
        a1->unkD0 = 4 * gUnk_08372964[idx][(a1->unkC0 >> 2) & 7];
    }
}

#define Macro_08132034(a1, a2, idx, i) ({ \
    bool32 _a = (a1)[idx].unkC0 - 0x100 <= (a2)[i].unk0; \
    bool32 _b = (a2)[i].unk0 <= (a1)[idx].unkC0 + 0x2C0; \
 \
    if (_a & _b) { \
        (a2)[i].unk12 |= 1; \
        (a2)[i].unk12 |= 0x10 << (idx); \
    } \
})

static void sub_08132034(struct Unk_0812F91C_20 *a1, struct Unk_0812F91C_45C *a2, u8 a3) {
    u8 i;

    for (i = 0; i < a3; ++i) {
        a2[i].unk12 &= ~0xF1;
        Macro_08132034(a1, a2, 0, i);
        Macro_08132034(a1, a2, 1, i);
        Macro_08132034(a1, a2, 2, i);
        Macro_08132034(a1, a2, 3, i);
    }
}

#define Macro_08132160(a1, a2, idx, i) ({ \
    bool32 _a = (a1)[idx].unkC0 - 0x100 <= (a2)[i].unk0; \
    bool32 _b = (a2)[i].unk0 <= (a1)[idx].unkC0 + 0x2C0; \
 \
    if (_a & _b) { \
        (a2)[i].unk12 |= 0xF1; \
    } \
})

static void sub_08132160(struct Unk_0812F91C_20 *a1, struct Unk_0812F91C_45C *a2, u8 a3) {
    u8 i;

    for (i = 0; i < a3; ++i) {
        a2[i].unk12 &= ~0xF1;
        Macro_08132160(a1, a2, 0, i);
        Macro_08132160(a1, a2, 1, i);
        Macro_08132160(a1, a2, 2, i);
        Macro_08132160(a1, a2, 3, i);
    }
}

static void sub_08132280(struct Unk_0812F91C_20 *a1, struct Unk_0812F91C_45C *a2, u8 a3) {
    u8 i;

    for (i = 0; i < a3; ++i) {
        if (a2[i].unk12 & 1) {
            bool32 a = (a2[i].unk0 >> 2) - 0xE <= a1[0].unkC0 >> 2;
            bool32 b = a1[0].unkC0 >> 2 <= (a2[i].unk0 >> 2) + 0xE;
            bool32 c = a & b;
            bool32 d = (a2[i].unk4 >> 2) - 0xE <= a1[0].unkC4 >> 2;
            bool32 e = a1[0].unkC4 >> 2 <= (a2[i].unk4 >> 2) + 0xE;
            bool32 f = d & e;

            if (c & f && !(a1[0].unkA4 & 0x400)) {
                if (a1[0].unk94 & 2)
                    m4aSongNumStart(565);
                a1[0].unkA4 |= 0x100;
                a1[0].unkA4 |= 0x400;
            }
        }
    }
}

static void sub_08132350(struct Unk_0812F91C_20 *a1) {
    if (!(a1->unkA4 & 0x10)) {
        if (a1->unkB2) {
            if (a1->unkA4 & 0x80) {
                if (a1->unk94 & 2 && a1->unkB2 == 1)
                    sub_08133804(a1);
                a1->unkA4 &= ~0x80;
                a1->unkBF = 5;
            }
            if (a1->unkBF) {
                if (a1->unkBF != 4)
                    ++a1->unkBF;
                if (a1->unkBF > 0xA)
                    a1->unkBF = 0;
            }
        }
        if (!(a1->unkA4 & 0x10) && a1->unkB2)
            a1->unkBC = a1->unkB2;
    }
    a1->unkBE = a1->unkBD;
    a1->unkBD = gUnk_083727B8[gUnk_083727A8[a1->unkBC]][a1->unkBF];
    if (a1->unkA4 & 0x400) {
        if (a1->unkB4++ > 0x3C) {
            a1->unkA4 &= ~0x400;
            a1->unkB4 = 0;
            a1->unk0.unk0.animId = gUnk_083726B8[gLanguage][a1->unkBD].animId;
            a1->unk0.unk0.variant = gUnk_083726B8[gLanguage][a1->unkBD].variant;
            a1->unk0.unk0.unk1B = 0xFF;
        }
    }
    else if (a1->unkBE != a1->unkBD) {
        a1->unk0.unk0.animId = gUnk_083726B8[gLanguage][a1->unkBD].animId;
        a1->unk0.unk0.variant = gUnk_083726B8[gLanguage][a1->unkBD].variant;
        a1->unk0.unk0.unk1B = 0xFF;
    }
}

static void sub_08132498(struct Unk_0812F91C_20 *a1) {
    if (a1->unkA4 & 0x100) {
        a1->unkA4 &= ~0x100;
        switch (gLanguage) { // same for every language
        case LANGUAGE_JAPANESE:
            a1->unk0.unk0.animId = 0x347;
            a1->unk0.unk0.variant = 0xB;
            a1->unk0.unk0.unk1B = 0xFF;
            break;
        case LANGUAGE_ENGLISH:
            a1->unk0.unk0.animId = 0x347;
            a1->unk0.unk0.variant = 0xB;
            a1->unk0.unk0.unk1B = 0xFF;
            break;
        case LANGUAGE_GERMAN:
            a1->unk0.unk0.animId = 0x347;
            a1->unk0.unk0.variant = 0xB;
            a1->unk0.unk0.unk1B = 0xFF;
            break;
        case LANGUAGE_FRENCH:
            a1->unk0.unk0.animId = 0x347;
            a1->unk0.unk0.variant = 0xB;
            a1->unk0.unk0.unk1B = 0xFF;
            break;
        case LANGUAGE_SPANISH:
            a1->unk0.unk0.animId = 0x347;
            a1->unk0.unk0.variant = 0xB;
            a1->unk0.unk0.unk1B = 0xFF;
            break;
        case LANGUAGE_ITALIAN:
            a1->unk0.unk0.animId = 0x347;
            a1->unk0.unk0.variant = 0xB;
            a1->unk0.unk0.unk1B = 0xFF;
            break;
        }
        if (a1->unk94 & 2)
            sub_081340AC(a1);
        else
            sub_08134178();
        a1->unkA4 |= 1;
        a1->unkA2 = 0;
        a1->unkA0 = 4;
        a1->unkE4 = 0;
        a1->unkA8 = 0;
    }
}

#ifndef NONMATCHING
static void sub_08132540(struct Unk_0812F91C_20 *a1) {
    s8 var = (a1->unkC0 - 0x100) >> 10;
    register s32 r0 asm("r0"), r1 asm("r1");
    u32 mask = 0xFF;

    if (var < 0) {
        a1->unkD4 += 0;
        var = 0;
    }
    a1->unkD8 = gUnk_0837EA54[a1->unkD4[var]];
    a1->unkDC = gUnk_0837EA54[a1->unkD4[var + 1]];
    r0 = a1->unkC0 - 0x100;
    r1 = r0 >> 2;
    a1->unkE0 = r1 &= mask;
}
#else
static void sub_08132540(struct Unk_0812F91C_20 *a1) {
    s8 var = (a1->unkC0 - 0x100) >> 10;

    if (var < 0) var = 0;
    a1->unkD8 = gUnk_0837EA54[a1->unkD4[var]];
    a1->unkDC = gUnk_0837EA54[a1->unkD4[var + 1]];
    a1->unkE0 = ((a1->unkC0 - 0x100) >> 2) & 0xFF;
}
#endif

static void sub_081325A4(struct Unk_0812F91C *a1) {
    u8 i;

    a1->unk418.unk34 &= ~0x100;
    for (i = 0; i < a1->unk524; ++i) {
        if (a1->unk45C[i].unk12 & (0x10 << a1->unk579)) {
            a1->unk418.unk28 = a1->unk45C[i].unk0;
            a1->unk418.unk2C = a1->unk45C[i].unk4;
            sub_081288DC(&a1->unk418);
            a1->unk418.unk34 |= 0x100;
        }
    }
}

static void sub_08132650(struct Unk_0812F91C *a1) {
    s32 array[4];
    u8 i, j, k;
    s32 max;

    array[0] = a1->unk20[0].unkC0;
    array[1] = a1->unk20[1].unkC0;
    array[2] = a1->unk20[2].unkC0;
    array[3] = a1->unk20[3].unkC0;
    for (i = 0; i < 4; i += k) {
        k = 0;
        max = max(max(max(array[3], array[2]), array[1]), array[0]);
        for (j = 0; j < 4; ++j) {
            if (max == a1->unk20[j].unkC0) {
                a1->unk20[j].unkE5 = i;
                array[j] = 0;
                ++k;
            }
        }
    }
}

static void sub_081326F8(struct Unk_0812F91C *a1) {
    u16 array[4];
    u8 i, j, k;
    u16 min;

    array[0] = a1->unk20[0].unkE6;
    array[1] = a1->unk20[1].unkE6;
    array[2] = a1->unk20[2].unkE6;
    array[3] = a1->unk20[3].unkE6;
    for (i = 0; i < 4; i += k) {
        k = 0;
        min = min(array[0], min(array[1], min(array[2], array[3])));
        for (j = 0; j < 4; ++j) {
            if (min == a1->unk20[j].unkE6) {
                a1->unk20[j].unkE5 = i;
                a1->unk3D0[i + k] = j;
                array[j] = 0xFFFF;
                ++k;
            }
        }
    }
}

static void sub_08132800(struct Unk_0812F91C *a1) {
    struct Unk_08128F44_4 *var;

    CpuFill32(0, var = &a1->unk3D4, sizeof(struct Unk_08128F44_4));
    var->unk0.tilesVram = 0x6010000;
    var->unk0.unk14 = 0x480;
    var->unk0.animId = gUnk_0837283C[gLanguage][0].animId;
    var->unk0.variant = gUnk_0837283C[gLanguage][0].variant;
    var->unk0.unk16 = 0;
    var->unk0.unk1B = 0xFF;
    var->unk0.unk1C = 0x10;
    var->unk0.palId = 4;
    var->unk0.x = 0;
    var->unk0.y = 0x40;
    var->unk0.unk8 = 0xC0000;
    var->unk28 = 0;
    var->unk2C = 0x100;
    var->unk30 = 0;
    var->unk32 = 0;
    var->unk34 = 0x10;
    var->unk36 = 0;
    var->unk38 = NULL;
    var->unk3C = NULL;
    var->unk40 = NULL;
}

static void sub_08132888(struct Unk_0812F91C *a1) {
    u16 r4, *ptr;
    u8 array[4];
    struct Unk_02021590 r5;
    u8 i;
    u8 *r6;

    if (a1->unk52A & 2) {
        if (a1->unk20[gUnk_0203AD3C].unkB0 & 0x20) {
            if (a1->unk20[a1->unk57D].unkB0 & 0x20) {
#ifndef NONMATCHING
                ptr = (u16 *)((u8 *)a1 + sizeof(struct Unk_0812F91C_20) * a1->unk57D + offsetof(struct Unk_0812F91C, unk20) + offsetof(struct Unk_0812F91C_20, unkE6));
#else
                ptr = &a1->unk20[a1->unk57D].unkE6;
#endif
            }
            else {
                ptr = &a1->unk57A;
            }
        }
        else {
            ptr = &a1->unk57A;
        }
        // TODO: maybe we can match this by inlining sub_08133044?
        r6 = array;
        r4 = *ptr;
        if (r4 > 5999) r4 = 5999;
        r6[3] = r4 / 600;
        r4 -= r6[3] * 600;
        r6[2] = r4 / 60;
        r4 -= r6[2] * 60;
        r6[1] = r4 / 10;
        r4 -= r6[1] * 10;
        r6[0] = r4;
        for (i = 0; i < 4; ++i) {
            struct Unk_08128F44_4 *var = &a1->unk3D4;

            var->unk0.animId = gUnk_0837283C[gLanguage][array[3 - i]].animId;
            var->unk0.variant = gUnk_0837283C[gLanguage][array[3 - i]].variant;
            var->unk0.unk1B = 0xFF;
            a1->unk3D4.unk28 = gUnk_083729D4[i] * 4;
            a1->unk3D4.unk2C = 0x40;
            sub_081288DC(&a1->unk3D4);
        }
        {
            struct Unk_08128F44_4 *var = &a1->unk3D4;

            var->unk0.animId = gUnk_0837283C[gLanguage][0xA].animId;
            var->unk0.variant = gUnk_0837283C[gLanguage][0xA].variant;
            var->unk0.unk1B = 0xFF;
            a1->unk3D4.unk28 = gUnk_083729D4[4] * 4;
            a1->unk3D4.unk2C = 0x40;
            sub_081288DC(&a1->unk3D4);
        }
        switch (gLanguage) { // same for every language
        case LANGUAGE_JAPANESE:
            r5.animId = 0x349;
            r5.variant = 1;
            break;
        case LANGUAGE_ENGLISH:
            r5.animId = 0x349;
            r5.variant = 1;
            break;
        case LANGUAGE_GERMAN:
            r5.animId = 0x349;
            r5.variant = 1;
            break;
        case LANGUAGE_FRENCH:
            r5.animId = 0x349;
            r5.variant = 1;
            break;
        case LANGUAGE_SPANISH:
            r5.animId = 0x349;
            r5.variant = 1;
            break;
        case LANGUAGE_ITALIAN:
            r5.animId = 0x349;
            r5.variant = 1;
            break;
        }
        {
            struct Unk_08128F44_4 *var = &a1->unk3D4;

            var->unk0.animId = r5.animId;
            var->unk0.variant = r5.variant;
            var->unk0.unk1B = 0xFF;
            a1->unk3D4.unk28 = gUnk_083729D4[5] * 4;
            a1->unk3D4.unk2C = 0x40;
            sub_081288DC(&a1->unk3D4);
        }
    }
}

static void sub_08132AC8(void) {
    struct Unk_0812F91C *r4 = gUnk_03000530;
    u8 i;
    const u16 *src, *src2;
    u16 *dst, *dst2;

    CpuFill32(0, (void *)0x600E000, 0x800);
    src = &r4->unk570[r4->unk578 >> 3];
    src2 = r4->unk574;
    dst = (u16 *)0x600E000;
    dst2 = (0x20 - (r4->unk578 >> 3)) + (u16 *)0x600E000;
    for (i = 0; i < 0x20; ++i) {
        CpuCopy16(src, dst, ((0x40 - 2 * (r4->unk578 >> 3)) >> 1) * sizeof(u16));
        if (r4->unk578 >> 3)
            CpuCopy16(src2, dst2, ((r4->unk578 >> 3) % 0x200000u) * sizeof(u16));
        dst += 0x20;
        dst2 += 0x20;
        src += 0x20;
        src2 += 0x20;
    }
}

static void sub_08132B84(void) {
    struct Unk_08128F44_4 *r4;
    struct Unk_02021590 r6;
    struct Unk_0813119C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;
    struct Unk_0812F91C *r9;
    struct Unk_0812F91C_20 *r10;
    u16 y;

    gCurTask->main = sub_08132ED8;
    r9 = var->unk0;
    r10 = r9->unk20;
    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        r6.animId = 0x349;
        r6.variant = 0;
        break;
    case LANGUAGE_ENGLISH:
        r6.animId = 0x349;
        r6.variant = 0;
        break;
    case LANGUAGE_GERMAN:
        r6.animId = 0x349;
        r6.variant = 0;
        break;
    case LANGUAGE_FRENCH:
        r6.animId = 0x349;
        r6.variant = 0;
        break;
    case LANGUAGE_SPANISH:
        r6.animId = 0x349;
        r6.variant = 0;
        break;
    case LANGUAGE_ITALIAN:
        r6.animId = 0x349;
        r6.variant = 0;
        break;
    }
    CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
    var->unk4.unk0.tilesVram = 0x6010000;
    var->unk4.unk0.unk14 = 0x480;
    var->unk4.unk0.animId = r6.animId;
    var->unk4.unk0.variant = r6.variant;
    var->unk4.unk0.unk16 = 0;
    var->unk4.unk0.unk1B = 0xFF;
    var->unk4.unk0.unk1C = 0x10;
    var->unk4.unk0.palId = 4;
    var->unk4.unk0.x = 0x3B;
    var->unk4.unk0.y = 0x10;
    var->unk4.unk0.unk8 = 0xC0000;
    var->unk4.unk28 = 0x3B * 4;
    var->unk4.unk2C = 0x10 * 4;
    var->unk4.unk30 = 0;
    var->unk4.unk32 = 0;
    var->unk4.unk34 = 0x10;
    var->unk4.unk36 = 0;
    var->unk4.unk38 = NULL;
    var->unk4.unk3C = NULL;
    var->unk4.unk40 = NULL;
    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        r6.animId = 0x349;
        r6.variant = 1;
        break;
    case LANGUAGE_ENGLISH:
        r6.animId = 0x349;
        r6.variant = 1;
        break;
    case LANGUAGE_GERMAN:
        r6.animId = 0x349;
        r6.variant = 1;
        break;
    case LANGUAGE_FRENCH:
        r6.animId = 0x349;
        r6.variant = 1;
        break;
    case LANGUAGE_SPANISH:
        r6.animId = 0x349;
        r6.variant = 1;
        break;
    case LANGUAGE_ITALIAN:
        r6.animId = 0x349;
        r6.variant = 1;
        break;
    }
    CpuFill32(0, &var->unk48, sizeof(struct Unk_08128F44_4));
    var->unk48.unk0.tilesVram = 0x6010000;
    var->unk48.unk0.unk14 = 0x480;
    var->unk48.unk0.animId = r6.animId;
    var->unk48.unk0.variant = r6.variant;
    var->unk48.unk0.unk16 = 0;
    var->unk48.unk0.unk1B = 0xFF;
    var->unk48.unk0.unk1C = 0x10;
    var->unk48.unk0.palId = 4;
    var->unk48.unk0.x = 0xB5;
    var->unk48.unk0.y = 0x10;
    var->unk48.unk0.unk8 = 0xC0000;
    var->unk48.unk28 = 0xB5 * 4;
    var->unk48.unk2C = 0x10 * 4;
    var->unk48.unk30 = 0;
    var->unk48.unk32 = 0;
    var->unk48.unk34 = 0x10;
    var->unk48.unk36 = 0;
    var->unk48.unk38 = NULL;
    var->unk48.unk3C = NULL;
    var->unk48.unk40 = NULL;

    for (i = 0; i < 4; ++i) {
        sub_0812F404(var->unkD0[i], r9->unk3D0[i], i, r10[r9->unk3D0[i]].unkE5, r10[r9->unk3D0[i]].unkE6);
        if (r9->unk3D0[i] == r9->unk579) {
            var->unkD0[i][1].unk0.unk14 &= ~0x7C0;
            var->unkD0[i][1].unk0.unk14 |= 0x400;
            var->unkD0[i][2].unk0.palId = 5;
            var->unkD0[i][3].unk0.palId = 5;
            var->unkD0[i][4].unk0.palId = 5;
            var->unkD0[i][5].unk0.palId = 5;
            var->unkD0[i][6].unk0.palId = 5;
            y = 0x98;
            switch (i) {
            case 0:
                break;
            case 1:
                y = 0x118;
                break;
            case 2:
                y = 0x198;
                break;
            case 3:
                y = 0x218;
                break;
            }
            switch (gLanguage) { // same for every language
            case LANGUAGE_JAPANESE:
                r6.animId = 0x348;
                r6.variant = 7;
                break;
            case LANGUAGE_ENGLISH:
                r6.animId = 0x348;
                r6.variant = 7;
                break;
            case LANGUAGE_GERMAN:
                r6.animId = 0x348;
                r6.variant = 7;
                break;
            case LANGUAGE_FRENCH:
                r6.animId = 0x348;
                r6.variant = 7;
                break;
            case LANGUAGE_SPANISH:
                r6.animId = 0x348;
                r6.variant = 7;
                break;
            case LANGUAGE_ITALIAN:
                r6.animId = 0x348;
                r6.variant = 7;
                break;
            }
            CpuFill32(0, r4 = &var->unk8C, sizeof(struct Unk_08128F44_4));
            r4->unk0.tilesVram = 0x6010000;
            r4->unk0.unk14 = 0x440;
            r4->unk0.animId = r6.animId;
            r4->unk0.variant = r6.variant;
            r4->unk0.unk16 = 0;
            r4->unk0.unk1B = 0xFF;
            r4->unk0.unk1C = 0x10;
            r4->unk0.palId = 4;
            r4->unk0.x = 0x76;
            r4->unk0.y = y >> 2;
            r4->unk0.unk8 = 0xC0000;
            r4->unk28 = 0x76 * 4;
            r4->unk2C = y;
            r4->unk30 = 0;
            r4->unk32 = 0;
            r4->unk34 = 0x810;
            r4->unk36 = 0;
            r4->unk38 = NULL;
            r4->unk3C = NULL;
            r4->unk40 = NULL;
        }
    }
}

static void sub_08132ED8(void) {
    struct Unk_0813119C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    sub_081288DC(&var->unk4);
    sub_081288DC(&var->unk48);
    sub_081288DC(&var->unk8C);
    sub_081288DC(&var->unkD0[0][0]);
    sub_081288DC(&var->unkD0[0][1]);
    sub_081288DC(&var->unkD0[0][2]);
    sub_081288DC(&var->unkD0[0][3]);
    sub_081288DC(&var->unkD0[0][4]);
    sub_081288DC(&var->unkD0[0][5]);
    sub_081288DC(&var->unkD0[0][6]);
    sub_081288DC(&var->unkD0[1][0]);
    sub_081288DC(&var->unkD0[1][1]);
    sub_081288DC(&var->unkD0[1][2]);
    sub_081288DC(&var->unkD0[1][3]);
    sub_081288DC(&var->unkD0[1][4]);
    sub_081288DC(&var->unkD0[1][5]);
    sub_081288DC(&var->unkD0[1][6]);
    sub_081288DC(&var->unkD0[2][0]);
    sub_081288DC(&var->unkD0[2][1]);
    sub_081288DC(&var->unkD0[2][2]);
    sub_081288DC(&var->unkD0[2][3]);
    sub_081288DC(&var->unkD0[2][4]);
    sub_081288DC(&var->unkD0[2][5]);
    sub_081288DC(&var->unkD0[2][6]);
    sub_081288DC(&var->unkD0[3][0]);
    sub_081288DC(&var->unkD0[3][1]);
    sub_081288DC(&var->unkD0[3][2]);
    sub_081288DC(&var->unkD0[3][3]);
    sub_081288DC(&var->unkD0[3][4]);
    sub_081288DC(&var->unkD0[3][5]);
    sub_081288DC(&var->unkD0[3][6]);
}

static void sub_08133044(u8 a1[], u16 a2) {
    if (a2 > 5999) a2 = 5999;
    a1[3] = a2 / 600;
    a2 -= a1[3] * 600;
    a1[2] = a2 / 60;
    a2 -= a1[2] * 60;
    a1[1] = a2 / 10;
    a2 -= a1[1] * 10;
    a1[0] = a2;
}

static void sub_081330AC(void) {
    struct Unk_0812F91C *var = TaskGetStructPtr(gCurTask);

    if (var->unk57E++ > 0x32) {
        TaskDestroy(gCurTask);
        if (gUnk_0203AD10 & 2) {
            sub_08031CC8();
            sub_081589E8();
        }
        sub_08138D64(2);
    }
}

static void sub_08133118(struct Task *t) {
    struct Unk_0812F91C *var = TaskGetStructPtr(t);

    TaskDestroy(var->unk10);
    var->unk10 = NULL;
    TaskDestroy(var->unk14[0]);
    var->unk14[0] = NULL;
    TaskDestroy(var->unk14[1]);
    var->unk14[1] = NULL;
    TaskDestroy(var->unk14[2]);
    var->unk14[2] = NULL;
}

static void sub_08133164(struct Unk_0812F91C_20 *a1) {
    a1->unkC0 += a1->unkA8 >> 6;
    a1->unkC4 += a1->unkAA;
}

static void sub_0813318C(struct Unk_0812F91C_20 *a1) {
    if (a1->unkA8 < 0x300)
        a1->unkA8 += 4;
    if (a1->unkA8 > 0x300)
        a1->unkA8 -= 3;
    if (a1->unkA8 > 0x600)
        a1->unkA8 = 0x600;
}

static void sub_081331CC(struct Unk_0812F91C_20 *a1, u16 a2) {
    if (a1->unkB0 & 0x20 && !a1->unkE6)
        a1->unkE6 = a2;
}

static void sub_081331F0(struct Unk_0812F91C_20 *a1, s32 *a2) {
    bool32 r1, r2;

    a1->unk94 &= ~4;
    r1 = abs(*a2) <= a1->unkC0;
    r2 = a1->unkC0 <= abs(*a2) + 0x400;
    if (r1 & r2)
        a1->unk94 |= 4;
}

static void sub_08133248(struct Unk_0812F91C_20 *a1) {
    a1->unk0.unk28 = a1->unkC0;
    a1->unk0.unk2C = a1->unkC4 + a1->unkD0;
    if (a1->unk94 & 4)
        sub_081288DC(&a1->unk0);
}

static void sub_08133280(struct Unk_0812F91C_20 *a1) {
    a1->unk44.unk0.animId = gUnk_0837283C[gLanguage][a1->unkE5 + 1].animId;
    a1->unk44.unk0.variant = gUnk_0837283C[gLanguage][a1->unkE5 + 1].variant;
    a1->unk44.unk0.unk1B = 0xFF;
}

static u8 sub_081332D0(struct Unk_0812F91C_20 *a1, s16 a2, s16 a3) {
    return sub_081332FC(a1->unkC0 + a2, a1->unkC4 + a3, a1->unkD4);
}

static u8 sub_081332FC(s32 a1, u32 a2, u8 *a3) {
    s16 r3 = 0x3FF;
    const u8 (*ptr)[0x10];
    u8 r0, r1;
#ifdef NONMATCHING
    u32 r4 = r3;
#else
    register u32 r4 asm("r4") = r3;
    asm(""::"r"(r3));
#endif
    r3 = a1 & r4;
    a2 = a2 & r4;
    ptr = gUnk_0837EA88[a3[a1 >> 0xA]];
    r1 = ptr[a2 >> 5][r3 >> 6];
    if ((r3 >> 5) & 1)
        r0 = r1 % 0x10;
    else
        r0 = r1 / 0x10;
    return r0;
}

static void sub_08133344(struct Unk_0812F91C_20 *a1) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 r4;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        r4.animId = 0x348;
        r4.variant = 4;
        break;
    case LANGUAGE_ENGLISH:
        r4.animId = 0x348;
        r4.variant = 4;
        break;
    case LANGUAGE_GERMAN:
        r4.animId = 0x348;
        r4.variant = 4;
        break;
    case LANGUAGE_FRENCH:
        r4.animId = 0x348;
        r4.variant = 4;
        break;
    case LANGUAGE_SPANISH:
        r4.animId = 0x348;
        r4.variant = 4;
        break;
    case LANGUAGE_ITALIAN:
        r4.animId = 0x348;
        r4.variant = 4;
        break;
    }
    var->unk0 = &a1->unk0;
    var->unk50 = 0;
    var->unk52 = 2;
    var->unk48 = 0;
    var->unk4C = 0x20;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x440;
        var->unk4.unk0.animId = r4.animId;
        var->unk4.unk0.variant = r4.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x10;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x440;
        var->unk4.unk0.animId = r4.animId;
        var->unk4.unk0.variant = r4.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x10;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk0.unk38;
}

static struct Task *sub_081334DC(struct Unk_0812F91C_20 *a1) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 r4;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        r4.animId = 0x348;
        r4.variant = 2;
        break;
    case LANGUAGE_ENGLISH:
        r4.animId = 0x348;
        r4.variant = 2;
        break;
    case LANGUAGE_GERMAN:
        r4.animId = 0x348;
        r4.variant = 2;
        break;
    case LANGUAGE_FRENCH:
        r4.animId = 0x348;
        r4.variant = 2;
        break;
    case LANGUAGE_SPANISH:
        r4.animId = 0x348;
        r4.variant = 2;
        break;
    case LANGUAGE_ITALIAN:
        r4.animId = 0x348;
        r4.variant = 2;
        break;
    }
    var->unk0 = &a1->unk0;
    var->unk50 = 0;
    var->unk52 = 2;
    var->unk48 = 0;
    var->unk4C = 8;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = r4.animId;
        var->unk4.unk0.variant = r4.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 6;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = r4.animId;
        var->unk4.unk0.variant = r4.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 6;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk0.unk38;
    return t;
}

static void sub_08133688(struct Task *t, bool8 a2) {
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    if (a2) {
        switch (gLanguage) { // same for every language
        case LANGUAGE_JAPANESE:
            st.animId = 0x348;
            st.variant = 2;
            break;
        case LANGUAGE_ENGLISH:
            st.animId = 0x348;
            st.variant = 2;
            break;
        case LANGUAGE_GERMAN:
            st.animId = 0x348;
            st.variant = 2;
            break;
        case LANGUAGE_FRENCH:
            st.animId = 0x348;
            st.variant = 2;
            break;
        case LANGUAGE_SPANISH:
            st.animId = 0x348;
            st.variant = 2;
            break;
        case LANGUAGE_ITALIAN:
            st.animId = 0x348;
            st.variant = 2;
            break;
        }
    }
    else {
        switch (gLanguage) { // same for every language
        case LANGUAGE_JAPANESE:
            st.animId = 0x348;
            st.variant = 3;
            break;
        case LANGUAGE_ENGLISH:
            st.animId = 0x348;
            st.variant = 3;
            break;
        case LANGUAGE_GERMAN:
            st.animId = 0x348;
            st.variant = 3;
            break;
        case LANGUAGE_FRENCH:
            st.animId = 0x348;
            st.variant = 3;
            break;
        case LANGUAGE_SPANISH:
            st.animId = 0x348;
            st.variant = 3;
            break;
        case LANGUAGE_ITALIAN:
            st.animId = 0x348;
            st.variant = 3;
            break;
        }
    }
    if (var->unk4.unk0.animId != st.animId
        || var->unk4.unk0.variant != st.variant) {
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk1B = 0xFF;
    }
}

static void sub_08133804(struct Unk_0812F91C_20 *a1) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        st.animId = 0x348;
        st.variant = 5;
        break;
    case LANGUAGE_ENGLISH:
        st.animId = 0x348;
        st.variant = 5;
        break;
    case LANGUAGE_GERMAN:
        st.animId = 0x348;
        st.variant = 5;
        break;
    case LANGUAGE_FRENCH:
        st.animId = 0x348;
        st.variant = 5;
        break;
    case LANGUAGE_SPANISH:
        st.animId = 0x348;
        st.variant = 5;
        break;
    case LANGUAGE_ITALIAN:
        st.animId = 0x348;
        st.variant = 5;
        break;
    }
    var->unk0 = &a1->unk0;
    var->unk50 = 0;
    var->unk52 = 2;
    var->unk48 = 0;
    var->unk4C = 0;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 6;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x10;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 6;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x10;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk0.unk38;
}

static void sub_0813399C(struct Unk_08128F44_4 *a1) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_ENGLISH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_GERMAN:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_FRENCH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_SPANISH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_ITALIAN:
        st.animId = 0x348;
        st.variant = 1;
        break;
    }
    var->unk0 = a1;
    var->unk50 = 0xF;
    var->unk52 = 1;
    var->unk48 = a1->unk28 - 0x20;
    var->unk4C = a1->unk2C + 4 * gUnk_0837EEDC[Rand32() & 7];
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk38;
}

static void sub_08133B74(struct Unk_08128F44_4 *a1, s32 a2, s32 a3, s32 a4) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_ENGLISH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_GERMAN:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_FRENCH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_SPANISH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_ITALIAN:
        st.animId = 0x348;
        st.variant = 1;
        break;
    }
    var->unk0 = a1;
    var->unk50 = 0x19;
    var->unk52 = 1;
    var->unk48 = a1->unk28 + 4 * a2;
    var->unk4C = a1->unk2C + 4 * a3;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk38;
    var->unk4.unk30 = 4;
    var->unk4.unk32 = 4 * gUnk_0837EEDC[a4];
}

static struct Task *sub_08133D44(struct Unk_0812F91C_20 *a1) {
    struct Task *t = TaskCreate(sub_08134884, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        st.animId = 0x348;
        st.variant = 0;
        break;
    case LANGUAGE_ENGLISH:
        st.animId = 0x348;
        st.variant = 0;
        break;
    case LANGUAGE_GERMAN:
        st.animId = 0x348;
        st.variant = 0;
        break;
    case LANGUAGE_FRENCH:
        st.animId = 0x348;
        st.variant = 0;
        break;
    case LANGUAGE_SPANISH:
        st.animId = 0x348;
        st.variant = 0;
        break;
    case LANGUAGE_ITALIAN:
        st.animId = 0x348;
        st.variant = 0;
        break;
    }
    var->unk0 = &a1->unk0;
    var->unk50 = 0;
    var->unk52 = 2;
    var->unk48 = -0x30;
    var->unk4C = 0x30;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk0.unk38;
    return t;
}

static void sub_08133EEC(struct Unk_0812F91C_20 *a1, u8 a2) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;

    var->unk0 = &a1->unk0;
    var->unk50 = 0x1E;
    var->unk52 = 3;
    var->unk48 = -0x20;
    var->unk4C = 0x40;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x400;
        var->unk4.unk0.animId = gUnk_0837EEF0[gLanguage][a2].animId;
        var->unk4.unk0.variant = gUnk_0837EEF0[gLanguage][a2].variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x400;
        var->unk4.unk0.animId = gUnk_0837EEF0[gLanguage][a2].animId;
        var->unk4.unk0.variant = gUnk_0837EEF0[gLanguage][a2].variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk0.unk38;
    var->unk4.unk30 = -2;
    var->unk4.unk32 = -4;
}

static void sub_081340AC(struct Unk_0812F91C_20 *a1) {
    sub_081341B0(a1, -2 * (Rand32() & 7), -4 * (Rand32() & 7));
    sub_081341B0(a1, -2 * (Rand32() & 7), -4 * (Rand32() & 7));
    sub_081341B0(a1,  2 * (Rand32() & 7), -4 * (Rand32() & 7));
    sub_081341B0(a1,  2 * (Rand32() & 7), -4 * (Rand32() & 7));
}

static void sub_08134178(void) {
    Rand32();
    Rand32();
    Rand32();
    Rand32();
    Rand32();
    Rand32();
    Rand32();
    Rand32();
}

static void sub_081341B0(struct Unk_0812F91C_20 *a1, s16 a2, s16 a3) {
    struct Task *t = TaskCreate(sub_0813436C, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_ENGLISH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_GERMAN:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_FRENCH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_SPANISH:
        st.animId = 0x348;
        st.variant = 1;
        break;
    case LANGUAGE_ITALIAN:
        st.animId = 0x348;
        st.variant = 1;
        break;
    }
    var->unk0 = &a1->unk0;
    var->unk50 = 0x3C;
    var->unk52 = 3;
    var->unk48 = 0;
    var->unk4C = 0;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x480;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk0.unk38;
    var->unk4.unk30 = a2;
    var->unk4.unk32 = a3;
}

static void sub_0813436C(void) {
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    var->unk4.unk32 += 2;
    sub_0812A2C0(var);
    if (var->unk52 & 1) {
        if (var->unk50)
            --var->unk50;
        else
            TaskDestroy(gCurTask);
    }
    else if (var->unk4.unk34 & 0x200) {
        TaskDestroy(gCurTask);
    }
}

static void sub_081343EC(void) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        st.animId = 0x34A;
        st.variant = 0;
        break;
    case LANGUAGE_ENGLISH:
        st.animId = 0x34A;
        st.variant = 0;
        break;
    case LANGUAGE_GERMAN:
        st.animId = 0x34A;
        st.variant = 0;
        break;
    case LANGUAGE_FRENCH:
        st.animId = 0x34A;
        st.variant = 0;
        break;
    case LANGUAGE_SPANISH:
        st.animId = 0x34A;
        st.variant = 0;
        break;
    case LANGUAGE_ITALIAN:
        st.animId = 0x34A;
        st.variant = 0;
        break;
    }
    var->unk0 = NULL;
    var->unk50 = 0x5A;
    var->unk52 = 1;
    var->unk48 = 0x1E0;
    var->unk4C = 0x140;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x400;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x400;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
}

static struct Task *sub_0813457C(void) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 st;

    switch (gLanguage) { // same for every language
    case LANGUAGE_JAPANESE:
        st.animId = 0x34A;
        st.variant = 1;
        break;
    case LANGUAGE_ENGLISH:
        st.animId = 0x34A;
        st.variant = 1;
        break;
    case LANGUAGE_GERMAN:
        st.animId = 0x34A;
        st.variant = 1;
        break;
    case LANGUAGE_FRENCH:
        st.animId = 0x34A;
        st.variant = 1;
        break;
    case LANGUAGE_SPANISH:
        st.animId = 0x34A;
        st.variant = 1;
        break;
    case LANGUAGE_ITALIAN:
        st.animId = 0x34A;
        st.variant = 1;
        break;
    }
    var->unk0 = NULL;
    var->unk50 = 0;
    var->unk52 = 0;
    var->unk48 = 0x1E0;
    var->unk4C = 0x140;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing stack
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x400;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = (var->unk48 + var->unk0->unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0->unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0->unk28;
        var->unk4.unk2C = var->unk4C + var->unk0->unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x400;
        var->unk4.unk0.animId = st.animId;
        var->unk4.unk0.variant = st.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 4;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    return t;
}

static void sub_08134720(struct Task *t) {
    struct Unk_0812D1EC_0 *var = TaskGetStructPtr(t);

    var->unk4.unk34 &= ~0x1000;
}

static void sub_08134754(struct Task *t) {
    struct Unk_0812D1EC_0 *var = TaskGetStructPtr(t);

    var->unk4.unk34 |= 0x1000;
}

static struct Task *sub_08134788(struct Unk_0812F91C_20 *a1) {
    struct Task *t = TaskCreate(sub_0813483C, sizeof(struct Unk_08134788), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_08134788 *var = TaskGetStructPtr(t);

    var->unk0 = &a1->unk0;
    var->unk4 = a1->unk0.unk28;
    var->unk6 = 0;
    return t;
}

static void sub_081347D8(struct Unk_0812F91C_20 *a1, u8 a2, u32 a3) {
    struct Task *t = TaskCreate(sub_081348B4, sizeof(struct Unk_081347D8), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_081347D8 *var = TaskGetStructPtr(t);

    var->unk0 = &a1->unk0;
    var->unk4 = a1->unk0.unk28;
    var->unk6 = 0;
    var->unk7 = gUnk_0837EEE3[a2];
    var->unk8 = a3;
}

static void sub_0813483C(void) {
    struct Unk_08134788 *var = TaskGetStructPtr(gCurTask);

    if (var->unk6++ > 4) {
        sub_0813399C(var->unk0);
        var->unk6 = 0;
    }
}

static void sub_08134884(void) {
    struct Unk_0812D1EC_0 *var = TaskGetStructPtr(gCurTask);

    sub_0812A2C0(var);
}

static void sub_081348B4(void) {
    struct Unk_081347D8 *var = TaskGetStructPtr(gCurTask);

    sub_08133B74(var->unk0, 0x1A, -8, 0);
    sub_08133B74(var->unk0, 0x1A,  0, 1);
    sub_08133B74(var->unk0, 0x1A,  8, 2);
    sub_08133B74(var->unk0, 0x1E, -4, 3);
    sub_08133B74(var->unk0, 0x1E,  4, 4);
    TaskDestroy(gCurTask);
}

static void sub_08134E54(void);
static void sub_081358EC(void);
static void sub_081359EC(void);
static void sub_08135E9C(void);
static void sub_08136078(void);
static void sub_08136518(void);
static void sub_081366B8(void);
static void sub_0813683C(void);
static void sub_08136A40(void);
static void sub_08136BE4(void);
static void sub_08136C68(struct Unk_08134D64 *);
static void sub_08136D5C(struct Unk_08134D64 *);
static void sub_08136ED0(void);
static void sub_08136F3C(struct Unk_08134D64_10 *, u8, bool8);
static void sub_08137190(void);
static void sub_08137204(struct Unk_08134D64 *);
static void sub_08137420(void);
static void nullsub_128(struct Task *);
static void sub_08137498(void);
static void sub_081374E8(void);
static void sub_0813754C(void);
static void sub_081375BC(struct Unk_08134D64 *);
static void sub_08137610(struct Unk_08134D64_10 *, u8, u16);
static void sub_08137668(void);
static void sub_081376E4(void);
static void sub_0813773C(struct Unk_08134D64_10 *);
static void sub_08137788(struct Unk_08134D64 *);
static void sub_081377D4(void);
static void sub_0813781C(void);
static void sub_08137874(void);
static void sub_081378BC(void);
static void sub_081378D4(struct Unk_08134D64_10 *);
static void sub_08137A80(void);
static void sub_08137AF8(struct Unk_08134D64_10 *);
static void sub_08137C98(void);
static void sub_08137E24(struct Unk_08134D64_10 *);
static void sub_08137FC8(void);
static struct Task *sub_081380C0(struct Unk_08134D64_10 *, s32, s32);
static struct Task *sub_0813862C(void);
static void sub_081386A8(struct Task *);
static void sub_081386DC(struct Task *);
static void sub_0813870C(void);

static const struct Unk_02021590 gUnk_0837EF38[][6] = {
    [LANGUAGE_JAPANESE] = {
        { 0x36B, 0x5, 0x0 },
        { 0x36B, 0x4, 0x0 },
        { 0x36B, 0x3, 0x0 },
        { 0x36B, 0x0, 0x0 },
        { 0x36B, 0x1, 0x0 },
        { 0x36B, 0x2, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x36B, 0x5, 0x0 },
        { 0x36B, 0x4, 0x0 },
        { 0x36B, 0x3, 0x0 },
        { 0x36B, 0x0, 0x0 },
        { 0x36B, 0x1, 0x0 },
        { 0x36B, 0x2, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x36B, 0x5, 0x0 },
        { 0x36B, 0x4, 0x0 },
        { 0x36B, 0x3, 0x0 },
        { 0x36B, 0x0, 0x0 },
        { 0x36B, 0x1, 0x0 },
        { 0x36B, 0x2, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x36B, 0x5, 0x0 },
        { 0x36B, 0x4, 0x0 },
        { 0x36B, 0x3, 0x0 },
        { 0x36B, 0x0, 0x0 },
        { 0x36B, 0x1, 0x0 },
        { 0x36B, 0x2, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x36B, 0x5, 0x0 },
        { 0x36B, 0x4, 0x0 },
        { 0x36B, 0x3, 0x0 },
        { 0x36B, 0x0, 0x0 },
        { 0x36B, 0x1, 0x0 },
        { 0x36B, 0x2, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x36B, 0x5, 0x0 },
        { 0x36B, 0x4, 0x0 },
        { 0x36B, 0x3, 0x0 },
        { 0x36B, 0x0, 0x0 },
        { 0x36B, 0x1, 0x0 },
        { 0x36B, 0x2, 0x0 },
    },
};

static const struct Unk_02021590 gUnk_0837EFC8[][6] = {
    [LANGUAGE_JAPANESE] = {
        { 0x366, 0x0, 0x0 },
        { 0x366, 0x1, 0x0 },
        { 0x366, 0x2, 0x0 },
        { 0x366, 0x3, 0x0 },
        { 0x366, 0x4, 0x0 },
        { 0x366, 0x5, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x366, 0x0, 0x0 },
        { 0x366, 0x1, 0x0 },
        { 0x366, 0x2, 0x0 },
        { 0x366, 0x3, 0x0 },
        { 0x366, 0x4, 0x0 },
        { 0x366, 0x5, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x366, 0x0, 0x0 },
        { 0x366, 0x1, 0x0 },
        { 0x366, 0x2, 0x0 },
        { 0x366, 0x3, 0x0 },
        { 0x366, 0x4, 0x0 },
        { 0x366, 0x5, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x366, 0x0, 0x0 },
        { 0x366, 0x1, 0x0 },
        { 0x366, 0x2, 0x0 },
        { 0x366, 0x3, 0x0 },
        { 0x366, 0x4, 0x0 },
        { 0x366, 0x5, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x366, 0x0, 0x0 },
        { 0x366, 0x1, 0x0 },
        { 0x366, 0x2, 0x0 },
        { 0x366, 0x3, 0x0 },
        { 0x366, 0x4, 0x0 },
        { 0x366, 0x5, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x366, 0x0, 0x0 },
        { 0x366, 0x1, 0x0 },
        { 0x366, 0x2, 0x0 },
        { 0x366, 0x3, 0x0 },
        { 0x366, 0x4, 0x0 },
        { 0x366, 0x5, 0x0 },
    },
};

static const s32 gUnk_0837F058[] = {
     0x90, 0x178,
    0x140, 0x148,
    0x280, 0x148,
    0x330, 0x178
};

static const struct Unk_02021590 gUnk_0837F078[][9] = {
    [LANGUAGE_JAPANESE] = {
        { 0x367, 0x0, 0x0 },
        { 0x367, 0x1, 0x0 },
        { 0x367, 0x2, 0x0 },
        { 0x367, 0x3, 0x0 },
        { 0x367, 0x4, 0x0 },
        { 0x367, 0x5, 0x0 },
        { 0x367, 0x6, 0x0 },
        { 0x367, 0x7, 0x0 },
        { 0x367, 0x8, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x367, 0x0, 0x0 },
        { 0x367, 0x1, 0x0 },
        { 0x367, 0x2, 0x0 },
        { 0x367, 0x3, 0x0 },
        { 0x367, 0x4, 0x0 },
        { 0x367, 0x5, 0x0 },
        { 0x367, 0x6, 0x0 },
        { 0x367, 0x7, 0x0 },
        { 0x367, 0x8, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x367, 0x0, 0x0 },
        { 0x367, 0x1, 0x0 },
        { 0x367, 0x2, 0x0 },
        { 0x367, 0x3, 0x0 },
        { 0x367, 0x4, 0x0 },
        { 0x367, 0x5, 0x0 },
        { 0x367, 0x6, 0x0 },
        { 0x367, 0x7, 0x0 },
        { 0x367, 0x8, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x367, 0x0, 0x0 },
        { 0x367, 0x1, 0x0 },
        { 0x367, 0x2, 0x0 },
        { 0x367, 0x3, 0x0 },
        { 0x367, 0x4, 0x0 },
        { 0x367, 0x5, 0x0 },
        { 0x367, 0x6, 0x0 },
        { 0x367, 0x7, 0x0 },
        { 0x367, 0x8, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x367, 0x0, 0x0 },
        { 0x367, 0x1, 0x0 },
        { 0x367, 0x2, 0x0 },
        { 0x367, 0x3, 0x0 },
        { 0x367, 0x4, 0x0 },
        { 0x367, 0x5, 0x0 },
        { 0x367, 0x6, 0x0 },
        { 0x367, 0x7, 0x0 },
        { 0x367, 0x8, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x367, 0x0, 0x0 },
        { 0x367, 0x1, 0x0 },
        { 0x367, 0x2, 0x0 },
        { 0x367, 0x3, 0x0 },
        { 0x367, 0x4, 0x0 },
        { 0x367, 0x5, 0x0 },
        { 0x367, 0x6, 0x0 },
        { 0x367, 0x7, 0x0 },
        { 0x367, 0x8, 0x0 },
    },
};

static const s32 gUnk_0837F150[] = {
     0x90, 0x40,
    0x140, 0x40,
    0x280, 0x40,
    0x330, 0x40
};

static const struct Unk_02021590 gUnk_0837F170[][4] = {
    [LANGUAGE_JAPANESE] = {
        { 0x368, 0x3, 0x0 },
        { 0x368, 0x4, 0x0 },
        { 0x368, 0x5, 0x0 },
        { 0x368, 0x6, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x368, 0x3, 0x0 },
        { 0x368, 0x4, 0x0 },
        { 0x368, 0x5, 0x0 },
        { 0x368, 0x6, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x368, 0x3, 0x0 },
        { 0x368, 0x4, 0x0 },
        { 0x368, 0x5, 0x0 },
        { 0x368, 0x6, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x368, 0x3, 0x0 },
        { 0x368, 0x4, 0x0 },
        { 0x368, 0x5, 0x0 },
        { 0x368, 0x6, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x368, 0x3, 0x0 },
        { 0x368, 0x4, 0x0 },
        { 0x368, 0x5, 0x0 },
        { 0x368, 0x6, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x368, 0x3, 0x0 },
        { 0x368, 0x4, 0x0 },
        { 0x368, 0x5, 0x0 },
        { 0x368, 0x6, 0x0 },
    },
};

static const s32 gUnk_0837F1D0[] = {
     0x90, 0xA0,
    0x140, 0xA0,
    0x280, 0xA0,
    0x330, 0xA0
};

static const s32 gUnk_0837F1F0[] = {
     0x1C, -0x60,
     0x1C, -0x60,
    -0x1C, -0x60,
    -0x1C, -0x60
};

static const s8 gUnk_0837F210[] = {
    -0x10, -8, -8, -4, -4, -2, 0, 2, 4, 4, 8, 8, 0x10,
    -8, -4, -4, -2, 0, 2, 4, 4, 8
};

static const struct Unk_02021590 gUnk_0837F228[][10] = {
    [LANGUAGE_JAPANESE] = {
        { 0x369, 0x1, 0x0 },
        { 0x369, 0x2, 0x0 },
        { 0x369, 0x3, 0x0 },
        { 0x369, 0x4, 0x0 },
        { 0x369, 0x5, 0x0 },
        { 0x369, 0x6, 0x0 },
        { 0x369, 0x7, 0x0 },
        { 0x369, 0x8, 0x0 },
        { 0x369, 0x9, 0x0 },
        { 0x369, 0xA, 0x0 },
    },
    [LANGUAGE_ENGLISH] = {
        { 0x369, 0x1, 0x0 },
        { 0x369, 0x2, 0x0 },
        { 0x369, 0x3, 0x0 },
        { 0x369, 0x4, 0x0 },
        { 0x369, 0x5, 0x0 },
        { 0x369, 0x6, 0x0 },
        { 0x369, 0x7, 0x0 },
        { 0x369, 0x8, 0x0 },
        { 0x369, 0x9, 0x0 },
        { 0x369, 0xA, 0x0 },
    },
    [LANGUAGE_GERMAN] = {
        { 0x369, 0x1, 0x0 },
        { 0x369, 0x2, 0x0 },
        { 0x369, 0x3, 0x0 },
        { 0x369, 0x4, 0x0 },
        { 0x369, 0x5, 0x0 },
        { 0x369, 0x6, 0x0 },
        { 0x369, 0x7, 0x0 },
        { 0x369, 0x8, 0x0 },
        { 0x369, 0x9, 0x0 },
        { 0x369, 0xA, 0x0 },
    },
    [LANGUAGE_FRENCH] = {
        { 0x369, 0x1, 0x0 },
        { 0x369, 0x2, 0x0 },
        { 0x369, 0x3, 0x0 },
        { 0x369, 0x4, 0x0 },
        { 0x369, 0x5, 0x0 },
        { 0x369, 0x6, 0x0 },
        { 0x369, 0x7, 0x0 },
        { 0x369, 0x8, 0x0 },
        { 0x369, 0x9, 0x0 },
        { 0x369, 0xA, 0x0 },
    },
    [LANGUAGE_SPANISH] = {
        { 0x369, 0x1, 0x0 },
        { 0x369, 0x2, 0x0 },
        { 0x369, 0x3, 0x0 },
        { 0x369, 0x4, 0x0 },
        { 0x369, 0x5, 0x0 },
        { 0x369, 0x6, 0x0 },
        { 0x369, 0x7, 0x0 },
        { 0x369, 0x8, 0x0 },
        { 0x369, 0x9, 0x0 },
        { 0x369, 0xA, 0x0 },
    },
    [LANGUAGE_ITALIAN] = {
        { 0x369, 0x1, 0x0 },
        { 0x369, 0x2, 0x0 },
        { 0x369, 0x3, 0x0 },
        { 0x369, 0x4, 0x0 },
        { 0x369, 0x5, 0x0 },
        { 0x369, 0x6, 0x0 },
        { 0x369, 0x7, 0x0 },
        { 0x369, 0x8, 0x0 },
        { 0x369, 0x9, 0x0 },
        { 0x369, 0xA, 0x0 },
    },
};

static const s32 gUnk_0837F318[] = {
     0x130, 0x88,
      0x80, 0xB8,
     -0x80, 0xB8,
    -0x130, 0x88,
};

static const s16 gUnk_0837F338[] = {
    -0x13,   -8,
       -8, -0xB,
        8, -0xB,
     0x13,   -8,
};

static const s8 gUnk_0837F348[][0x10] = {
    { -0x23, -0x1E, -0x19, -0x14, -0xF, -0xA, -0x5, 0x32, 0x37, 0x3C, 0x41, 0x46, 0x4B, 0x50, 0x55, 0x5A },
    { -0x14,  -0xF,  -0xA,  -0x5,  0xD,  0xF,  0xF, 0x10, 0x10, 0x11, 0x11, 0x12, 0x13, 0x16, 0x18, 0x1A },
    {  -0xA,  -0x9,  -0x5,   0x8,  0x9,  0xA,  0xB,  0xC,  0xD,  0xD,  0xE,  0xE,  0xF,  0xF, 0x10, 0x10 },
    {   0x0,   0x1,   0x1,   0x2,  0x3,  0x4,  0x5,  0x6,  0x6,  0x6,  0x7,  0x7,  0x8,  0x8,  0x9,  0x9 },
};

static const s16 gUnk_0837F388[][0x10] = {
    {  0xBE, 0xC8, 0xD2, 0xDC,  0xBE, 0xC8,  0xD2,  0xDC, 0xB4, 0xC8,  0xDC,  0xF0, 0x96, 0x96, 0x12C, 0x12C },
    {  0xB4, 0xC8, 0xDC, 0xF0,  0xA0, 0xC8,  0xDC, 0x12C, 0x82, 0x96, 0x15E, 0x15E, 0x64, 0x64, 0x17C, 0x17C },
    {  0xB4, 0xC8, 0xDC, 0xF0,  0x96, 0x96, 0x12C, 0x12C, 0x40, 0x64, 0x190, 0x190, 0x40, 0x40, 0x190, 0x19A },
    { 0x248, 0x40, 0x46, 0x64, 0x1E4, 0x40,  0x5A,  0x40, 0x40, 0x40,  0x4B,  0x5A, 0x4B, 0x63,  0x40,  0x40 },
};

static const u8 gUnk_0837F408[][0x10] = {
    { 0x0, 0x0, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x5, 0x5, 0x5, 0x5, 0x7, 0x8 },
    { 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x6, 0x6, 0x6, 0x6, 0x8, 0x9 },
    { 0x2, 0x2, 0x3, 0x4, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x7, 0x7, 0x7, 0x7, 0x9, 0xA },
    { 0x3, 0x3, 0x4, 0x5, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x8, 0x8, 0x8, 0x8, 0xA, 0xB },
    { 0x4, 0x4, 0x5, 0x6, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x9, 0x9, 0x9, 0x9, 0xB, 0xC },
    { 0x5, 0x5, 0x6, 0x7, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0xA, 0xA, 0xA, 0xA, 0xC, 0xD },
    { 0x6, 0x6, 0x7, 0x8, 0x9, 0x9, 0x9, 0x9, 0x9, 0x9, 0xB, 0xB, 0xB, 0xB, 0xD, 0xE },
    { 0x7, 0x7, 0x8, 0x9, 0xA, 0xA, 0xA, 0xA, 0xA, 0xA, 0xC, 0xC, 0xC, 0xC, 0xE, 0xF },
};

static const s8 gUnk_0837F488[] = { -0x4, 0x0, -0x2, 0x0, 0x6, 0x0, -0x4, 0x0, 0x4, 0x0, 0x2, 0x0, -0x6, 0x0, 0x4 };

static const s8 gUnk_0837F497[] = { 0x7, -0x6, 0x2, -0x5, -0x1, 0x6, 0x5, -0x4, 0x3, -0x2, -0x4, 0x6, -0x7, 0x5, -0x5 };

static const s8 gUnk_0837F4A6[] = { -0x4, 0x0, -0x2, 0x0, 0x6, 0x0, -0x4, 0x0, 0x4, 0x0, 0x2, 0x0, -0x6, 0x0, 0x4 };

static const s8 gUnk_0837F4B5[] = { -0x3, 0x3, 0x0, 0x0, 0x0, 0x2, -0x5, 0x3, 0x0, 0x0, 0x0, -0x3, 0x3, 0x0, 0x0 };

static const u16 gUnk_0837F4C4[] = {
    RGB( 6, 18,  6) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB(31, 28, 30) | 0x0000, RGB(31, 22, 27) | 0x0000, RGB(31, 18, 24) | 0x8000, RGB(30, 14, 20) | 0x0000, RGB(27,  9, 14) | 0x0000, RGB(22,  4,  7) | 0x0000,
    RGB(12,  2,  2) | 0x0000, RGB(31,  3, 16) | 0x0000, RGB(26,  0, 10) | 0x0000, RGB(31, 31, 18) | 0x8000, RGB(29, 29, 31) | 0x0000, RGB(31, 19,  8) | 0x0000, RGB(31, 29,  0) | 0x0000, RGB(31, 31, 31) | 0x8000,
    RGB( 6, 18,  6) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB(31, 31, 31) | 0x8000, RGB(31, 31,  0) | 0x8000, RGB(31, 21,  8) | 0x0000, RGB(31, 15,  1) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(24, 13,  0) | 0x0000,
    RGB(18,  6,  0) | 0x0000, RGB(24, 24, 24) | 0x0000, RGB(17, 17, 17) | 0x8000, RGB(14, 14, 14) | 0x0000, RGB(11, 11, 11) | 0x0000, RGB( 0, 31, 31) | 0x8000, RGB( 0, 20, 31) | 0x8000, RGB( 0, 10, 31) | 0x0000,
    RGB( 6, 18,  6) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB(31, 31, 31) | 0x8000, RGB(31, 31,  0) | 0x8000, RGB(31, 21,  8) | 0x0000, RGB(31, 15,  1) | 0x0000, RGB(31,  0,  0) | 0x0000, RGB(24, 13,  0) | 0x0000,
    RGB(18,  6,  0) | 0x0000, RGB(24, 24, 24) | 0x0000, RGB(17, 17, 17) | 0x8000, RGB(14, 14, 14) | 0x0000, RGB(11, 11, 11) | 0x0000, RGB( 0, 31, 31) | 0x8000, RGB( 0, 20, 31) | 0x8000, RGB( 0, 10, 31) | 0x0000,
    RGB( 6, 18,  6) | 0x0000, RGB(30, 31, 20) | 0x8000, RGB(29, 22, 18) | 0x8000, RGB(31,  7,  3) | 0x0000, RGB(31, 30, 14) | 0x8000, RGB(31, 21,  9) | 0x0000, RGB(30, 18,  3) | 0x0000, RGB(22, 13, 12) | 0x8000,
    RGB(17,  3,  3) | 0x0000, RGB(18, 31, 14) | 0x8000, RGB(17, 15, 22) | 0x8000, RGB(13,  5, 21) | 0x0000, RGB( 7,  0, 17) | 0x0000, RGB( 3, 11, 16) | 0x8000, RGB( 7, 17, 15) | 0x0000, RGB(31, 31, 31) | 0x8000,
    RGB(14,  5, 31) | 0x8000, RGB( 0,  0,  0) | 0x0000, RGB(29, 20,  4) | 0x0000, RGB( 2,  1, 15) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB(31, 31, 31) | 0x8000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
    RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000, RGB( 0,  0,  0) | 0x0000,
};

const u32 gUnk_0837F6C4[] = INCBIN_U32("graphics/speed_eaters/bg/main_tileset.4bpp.lz");

const u32 gUnk_083828DC[] = INCBIN_U32("graphics/speed_eaters/bg/game_ended/tileset_japanese.4bpp.lz");
const u32 gUnk_08382DB8[] = INCBIN_U32("graphics/speed_eaters/bg/game_ended/tileset_italian.4bpp.lz");
const u32 gUnk_0838326C[] = INCBIN_U32("graphics/speed_eaters/bg/game_ended/tileset_french.4bpp.lz");
const u32 gUnk_08383774[] = INCBIN_U32("graphics/speed_eaters/bg/game_ended/tileset_spanish.4bpp.lz");
const u32 gUnk_08383C0C[] = INCBIN_U32("graphics/speed_eaters/bg/game_ended/tileset_english.4bpp.lz");
const u32 gUnk_08384098[] = INCBIN_U32("graphics/speed_eaters/bg/game_ended/tileset_german.4bpp.lz");

static const u32 gUnk_0838454C[] = INCBIN_U32("graphics/speed_eaters/bg/bg0_tilemap.bin.rl");
static const u32 gUnk_083849B8[] = INCBIN_U32("graphics/speed_eaters/bg/bg1_tilemap.bin.rl");
static const u32 gUnk_08384F18[] = INCBIN_U32("graphics/speed_eaters/bg/bg2_tilemap.bin.rl");

static const u32 gUnk_083850A4[] = INCBIN_U32("graphics/speed_eaters/bg/bg2_tilemap_exclamation_mark.bin.rl");
static const u32 gUnk_0838518C[] = INCBIN_U32("graphics/speed_eaters/bg/game_ended/bg2_tilemap.bin.rl");

static const u8 gUnk_083852D0[] = {
    0x4F, 0x64,
    0x58, 0x65,
    0x64, 0x69,
    0x71, 0x6C,
    0x7F, 0x6C,
    0x83, 0x67,
    0x8D, 0x67,
    0x98, 0x66,
    0x58, 0x65,
    0x64, 0x69,
    0x71, 0x6C,
    0x83, 0x67,
    0x98, 0x66,
    0x8D, 0x67,
    0x75, 0x44,
    0x72, 0x54,
};

extern const u8 gUnk_08D61B6C[][4];
extern const u32 *const gUnk_08D61B80[];

static void sub_08134930(struct Unk_08134D64_10 *a1, u8 a2) {
    struct Unk_08128F44_4 *r4;

    if (a2 < gUnk_0203AD30)
        a1->unkD0 = 0;
    else
        a1->unkD0 = 1;
    if (a2 == gUnk_0203AD3C)
        a1->unkD0 |= 2;
    a1->unkD0 |= 0x10;
    a1->unkCC = 0;
    a1->unkDC = 0;
    a1->unkDE = 0;
    a1->unkDF = 0;
    a1->unkE0 = 0;
    a1->unkE2 = 0;
    a1->unkE4 = 0;
    a1->unkE6 = 0;
    a1->unkE7 = 0;
    a1->unkE8 = 0;
    CpuFill32(0, &a1->unk0, sizeof(struct Unk_08128F44_4));
    a1->unk0.unk0.tilesVram = 0x6010000;
    a1->unk0.unk0.unk14 = 0x540;
    a1->unk0.unk0.animId = gUnk_0837EFC8[gLanguage][0].animId;
    a1->unk0.unk0.variant = gUnk_0837EFC8[gLanguage][0].variant;
    a1->unk0.unk0.unk16 = 0;
    a1->unk0.unk0.unk1B = 0xFF;
    a1->unk0.unk0.unk1C = 0x10;
    a1->unk0.unk0.palId = a2;
    a1->unk0.unk0.x = gUnk_0837F058[(a2 << 1)] >> 2;
    a1->unk0.unk0.y = gUnk_0837F058[(a2 << 1) + 1] >> 2;
    a1->unk0.unk0.unk8 = 0xC0000;
    a1->unk0.unk28 = gUnk_0837F058[(a2 << 1)];
    a1->unk0.unk2C = gUnk_0837F058[(a2 << 1) + 1];
    a1->unk0.unk30 = 0;
    a1->unk0.unk32 = 0;
    a1->unk0.unk34 = 0x810;
    a1->unk0.unk36 = 0;
    a1->unk0.unk38 = NULL;
    a1->unk0.unk3C = NULL;
    a1->unk0.unk40 = NULL;
    if (a2 < 2)
        a1->unk0.unk34 |= 1;
    switch (a2) {
    case 0:
    case 3:
        a1->unk0.unk0.unk14 &= ~0x7C0;
        a1->unk0.unk0.unk14 |= 0x4C0;
        break;
    }
    a1->unk0.unk0.unk8 &= ~0x3000;
    a1->unk0.unk0.unk8 |= 0x2000;
    CpuFill32(0, &a1->unk44, sizeof(struct Unk_08128F44_4));
    a1->unk44.unk0.tilesVram = 0x6010000;
    a1->unk44.unk0.unk14 = 0x3C0;
    a1->unk44.unk0.animId = gUnk_0837F078[gLanguage][a1->unkDE].animId;
    a1->unk44.unk0.variant = gUnk_0837F078[gLanguage][a1->unkDE].variant;
    a1->unk44.unk0.unk16 = 0;
    a1->unk44.unk0.unk1B = 0xFF;
    a1->unk44.unk0.unk1C = 0x10;
    a1->unk44.unk0.palId = a2;
    a1->unk44.unk0.x = gUnk_0837F150[(a2 << 1)] >> 2;
    a1->unk44.unk0.y = gUnk_0837F150[(a2 << 1) + 1] >> 2;
    a1->unk44.unk0.unk8 = 0xC0000;
    a1->unk44.unk28 = gUnk_0837F150[(a2 << 1)];
    a1->unk44.unk2C = gUnk_0837F150[(a2 << 1) + 1];
    a1->unk44.unk30 = 0;
    a1->unk44.unk32 = 0;
    a1->unk44.unk34 = 0x10;
    a1->unk44.unk36 = 0;
    a1->unk44.unk38 = NULL;
    a1->unk44.unk3C = NULL;
    a1->unk44.unk40 = NULL;
    CpuFill32(0, r4 = &a1->unk88, sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r4->unk0.unk14 = 0x3C0;
    r4->unk0.animId = gUnk_0837F170[gLanguage][a1->unkE8].animId;
    r4->unk0.variant = gUnk_0837F170[gLanguage][a1->unkE8].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 5;
    r4->unk0.x = gUnk_0837F1D0[(a2 << 1)] >> 2;
    r4->unk0.y = gUnk_0837F1D0[(a2 << 1) + 1] >> 2;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = gUnk_0837F1D0[(a2 << 1)];
    r4->unk2C = gUnk_0837F1D0[(a2 << 1) + 1];
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x10;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
}

static void sub_08134BE4(struct Unk_08134D64_10 *a1, u8 a2 __attribute__((unused))) {
    a1->unkD0 &= ~0x100;
    a1->unkD0 &= ~0x200;
    if (a1->unkD0 & 0x400)
        a1->unkD0 |= 0x200;
    a1->unkD0 &= ~0x20;
    if (a1->unkCC) {
        TaskDestroy(a1->unkCC);
        a1->unkCC = NULL;
    }
    a1->unkDC = 0;
    a1->unkDF = 0;
    a1->unkE0 = 0;
    a1->unkE2 = 0;
    a1->unkE4 = 0;
    a1->unkE6 = 0;
}

void sub_08134C58(void) {
    CpuFill32(0, (void *)VRAM, VRAM_SIZE);
    if (gMainFlags & MAIN_FLAG_BG_PALETTE_TRANSFORMATION_ENABLE)
        LoadBgPaletteWithTransformation(gUnk_0837F4C4, 0, BG_PLTT_SIZE / sizeof(u16));
    else {
        DmaCopy16(3, gUnk_0837F4C4, gBgPalette, BG_PLTT_SIZE);
        gMainFlags |= MAIN_FLAG_BG_PALETTE_SYNC_ENABLE;
    }
    LZ77UnCompVram(gUnk_0837F6C4, (void *)0x6000000);
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        LZ77UnCompVram(gUnk_083828DC, (void *)0x6004000);
        break;
    case LANGUAGE_ENGLISH:
        LZ77UnCompVram(gUnk_08383C0C, (void *)0x6004000);
        break;
    case LANGUAGE_GERMAN:
        LZ77UnCompVram(gUnk_08384098, (void *)0x6004000);
        break;
    case LANGUAGE_FRENCH:
        LZ77UnCompVram(gUnk_0838326C, (void *)0x6004000);
        break;
    case LANGUAGE_SPANISH:
        LZ77UnCompVram(gUnk_08383774, (void *)0x6004000);
        break;
    case LANGUAGE_ITALIAN:
        LZ77UnCompVram(gUnk_08382DB8, (void *)0x6004000);
        break;
    }
    LZ77UnCompVram(gUnk_08D61B80[gLanguage], (void *)0x6010000);
}

void sub_08134D64(void) {
    struct Task *t;
    struct Unk_08134D64 *var;

    gRngVal = 0;
    gDispCnt = DISPCNT_MODE_0 | DISPCNT_OBJ_1D_MAP | DISPCNT_BG0_ON | DISPCNT_BG1_ON | DISPCNT_BG2_ON | DISPCNT_OBJ_ON;
    gBgCntRegs[0] = BGCNT_PRIORITY(2) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(28);
    gBgCntRegs[1] = BGCNT_PRIORITY(1) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(29);
    gBgCntRegs[2] = BGCNT_PRIORITY(0) | BGCNT_TXT256x256 | BGCNT_CHARBASE(0) | BGCNT_SCREENBASE(30);
    gBldRegs.bldCnt = BLDCNT_TGT1_ALL | BLDCNT_EFFECT_LIGHTEN;
    gBldRegs.bldY = 0x10;
    gBgScrollRegs[0][0] = 8;
    gBgScrollRegs[0][1] = 8;
    gBgScrollRegs[1][0] = 8;
    gBgScrollRegs[1][1] = 8;
    gBgScrollRegs[2][0] = 0;
    gBgScrollRegs[2][1] = 0;
    t = TaskCreate(sub_08134E54, sizeof(struct Unk_08134D64), 0x100, TASK_USE_IWRAM, nullsub_128);
    var = TaskGetStructPtr(t);
    CpuFill16(0, var, sizeof(struct Unk_08134D64));
    var->unkC = sub_0813862C();
    var->unk41C = gUnk_0203AD14;
    var->unk41D = gUnk_0203AD3C;
    var->unk40E = 0;
    var->unk416 = 0;
    var->unk417 = 0;
}

static void sub_08134E54(void) {
    struct Unk_08128F44_4 *r4;
    struct Sprite sprites[NUM_LANGUAGES][8];
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u32 r7;

    gCurTask->main = sub_081358EC;
    // This is completely pointless as every case is doing the same thing except for using different buffers
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        SpriteInitNoPointer(&sprites[LANGUAGE_JAPANESE][0], 0x6010000, 0x480, 0x366, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][1], 0x6010000, 0x480, 0x366, 7,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][2], 0x6010000, 0x480, 0x366, 6,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][3], 0x6010000, 0x480, 0x366, 8,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][4], 0x6010000, 0x480, 0x366, 9,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][5], 0x6010000, 0x480, 0x36A, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][6], 0x6010000, 0x480, 0x36A, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_JAPANESE][7], 0x6010000, 0x480, 0x369, 1,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        break;
    case LANGUAGE_ENGLISH:
        SpriteInit(&sprites[LANGUAGE_ENGLISH][0], 0x6010000, 0x480, 0x366, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][1], 0x6010000, 0x480, 0x366, 7,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][2], 0x6010000, 0x480, 0x366, 6,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][3], 0x6010000, 0x480, 0x366, 8,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][4], 0x6010000, 0x480, 0x366, 9,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][5], 0x6010000, 0x480, 0x36A, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][6], 0x6010000, 0x480, 0x36A, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ENGLISH][7], 0x6010000, 0x480, 0x369, 1,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        break;
    case LANGUAGE_GERMAN:
        SpriteInit(&sprites[LANGUAGE_GERMAN][0], 0x6010000, 0x480, 0x366, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][1], 0x6010000, 0x480, 0x366, 7,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][2], 0x6010000, 0x480, 0x366, 6,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][3], 0x6010000, 0x480, 0x366, 8,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][4], 0x6010000, 0x480, 0x366, 9,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][5], 0x6010000, 0x480, 0x36A, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][6], 0x6010000, 0x480, 0x36A, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_GERMAN][7], 0x6010000, 0x480, 0x369, 1,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        break;
    case LANGUAGE_FRENCH:
        SpriteInit(&sprites[LANGUAGE_FRENCH][0], 0x6010000, 0x480, 0x366, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][1], 0x6010000, 0x480, 0x366, 7,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][2], 0x6010000, 0x480, 0x366, 6,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][3], 0x6010000, 0x480, 0x366, 8,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][4], 0x6010000, 0x480, 0x366, 9,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][5], 0x6010000, 0x480, 0x36A, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][6], 0x6010000, 0x480, 0x36A, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_FRENCH][7], 0x6010000, 0x480, 0x369, 1,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        break;
    case LANGUAGE_SPANISH:
        SpriteInit(&sprites[LANGUAGE_SPANISH][0], 0x6010000, 0x480, 0x366, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][1], 0x6010000, 0x480, 0x366, 7,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][2], 0x6010000, 0x480, 0x366, 6,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][3], 0x6010000, 0x480, 0x366, 8,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][4], 0x6010000, 0x480, 0x366, 9,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][5], 0x6010000, 0x480, 0x36A, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][6], 0x6010000, 0x480, 0x36A, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_SPANISH][7], 0x6010000, 0x480, 0x369, 1,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        break;
    case LANGUAGE_ITALIAN:
        SpriteInit(&sprites[LANGUAGE_ITALIAN][0], 0x6010000, 0x480, 0x366, 0,
            0, 0xFF, 0x10, 0, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][1], 0x6010000, 0x480, 0x366, 7,
            0, 0xFF, 0x10, 1, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][2], 0x6010000, 0x480, 0x366, 6,
            0, 0xFF, 0x10, 2, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][3], 0x6010000, 0x480, 0x366, 8,
            0, 0xFF, 0x10, 3, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][4], 0x6010000, 0x480, 0x366, 9,
            0, 0xFF, 0x10, 4, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][5], 0x6010000, 0x480, 0x36A, 0,
            0, 0xFF, 0x10, 5, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][6], 0x6010000, 0x480, 0x36A, 2,
            0, 0xFF, 0x10, 6, 0, 0, 0x80000);
        SpriteInit(&sprites[LANGUAGE_ITALIAN][7], 0x6010000, 0x480, 0x369, 1,
            0, 0xFF, 0x10, 7, 0, 0, 0x80000);
        break;
    }
    RLUnCompVram(gUnk_0838454C, (void *)0x600E000);
    RLUnCompVram(gUnk_083849B8, (void *)0x600E800);
    RLUnCompVram(gUnk_08384F18, (void *)0x600F000);
    var->unk0 = NULL;
    sub_08134930(&var->unk10[0], 0);
    sub_08134930(&var->unk10[1], 1);
    sub_08134930(&var->unk10[2], 2);
    sub_08134930(&var->unk10[3], 3);
    CpuFill32(0, r4 = &var->unk3C0, sizeof(struct Unk_08128F44_4));
    r4->unk0.tilesVram = 0x6010000;
    r7 = 0;
    r4->unk0.unk14 = 0x440;
    r4->unk0.animId = gUnk_0837F228[gLanguage][0].animId;
    r4->unk0.variant = gUnk_0837F228[gLanguage][0].variant;
    r4->unk0.unk16 = 0;
    r4->unk0.unk1B = 0xFF;
    r4->unk0.unk1C = 0x10;
    r4->unk0.palId = 5;
    r4->unk0.x = 0x78;
    r4->unk0.y = 0x80;
    r4->unk0.unk8 = 0xC0000;
    r4->unk28 = 0x1E0;
    r4->unk2C = 0x200;
    r4->unk30 = 0;
    r4->unk32 = 0;
    r4->unk34 = 0x810;
    r4->unk36 = 0;
    r4->unk38 = NULL;
    r4->unk3C = NULL;
    r4->unk40 = NULL;
    var->unk3C0.unk0.unk8 &= ~0x3000;
    var->unk3C0.unk0.unk8 |= 0x1000;
    var->unk408[0] = 0;
    var->unk408[1] = 0;
    var->unk408[2] = 0;
    var->unk408[3] = 0;
    var->unk41A = 0;
    var->unk418 = 0x10;
    if (var->unk416 == 0xA && var->unk417 == 5) {
        m4aSongNumStart(572);
        var->unk418 |= 0x100;
        var->unk41C = 3;
    }
    if (r7) { ++r7; --r7; } // fake var r7 is for using the other zero register
    var->unk416 = r7;
    var->unk417 = 0;
    var->unk41E = 0;
    m4aSongNumStart(35);
}

static void sub_081358EC(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;

    if (var->unk40E) {
        if (var->unk40E > 0xB3) {
            var->unk40E = 0;
            gCurTask->main = sub_081359EC;
        }
    }
    else {
        CreatePauseFade(-0x10, 1);
        gDispCnt |= DISPCNT_BG2_ON;
        RLUnCompVram(gUnk_08384F18, (void *)0x600F000);
        sub_08137C98();
        if (var->unk418 & 0x10) {
            var->unk418 &= ~0x10;
            sub_081378D4(&var->unk10[var->unk41D]);
            for (i = 0; i < 4; ++i) {
                if (var->unk10[i].unkD0 & 1)
                    sub_08137AF8(&var->unk10[i]);
            }
        }
    }
    ++var->unk40E;
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_081359EC(void) {
    struct Unk_08134D64 *var = TaskGetStructPtr(gCurTask);
    u16 flags;

    gCurTask->main = sub_08137420;
    flags = var->unk418;
    var->unk4 = NULL;
    var->unk8 = NULL;
    var->unk40C = 0;
    var->unk40D = 0;
    var->unk40E = 0;
    var->unk412 = 0;
    var->unk414 = 0;
    var->unk418 = 0;
    if (flags & 0x200)
        var->unk418 = 0x200;
    if (flags & 0x400)
        var->unk418 |= 0x400;
    sub_08134BE4(&var->unk10[0], 0);
    sub_08134BE4(&var->unk10[1], 1);
    sub_08134BE4(&var->unk10[2], 2);
    sub_08134BE4(&var->unk10[3], 3);
    var->unk3C0.unk34 &= ~0x1000;
    if (var->unk418 & 0x200)
        var->unk3C0.unk34 |= 0x1000;
    sub_08136D5C(var);
    sub_081375BC(var);
    sub_08137610(&var->unk10[0], var->unk41C, var->unk410);
    sub_08137610(&var->unk10[1], var->unk41C, var->unk410);
    sub_08137610(&var->unk10[2], var->unk41C, var->unk410);
    sub_08137610(&var->unk10[3], var->unk41C, var->unk410);
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_08135B38(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;
    u8 v;

    sub_08136C68(var);
    if (var->unk410 == var->unk412) {
        var->unk418 |= 0x20;
        m4aSongNumStart(568);
        sub_08137668();
        sub_081386DC(var->unkC);
    }
    if (var->unk418 & 0x400
        && var->unk410 - 0x3C > var->unk412
        && !(var->unk412 % 120))
        sub_08137874();
    v = 0;
    for (i = 0; i < 4; ++i) {
        if (!(var->unk10[i].unkD0 & 0x400)
            && !(var->unk10[i].unkD0 & 0x200)
            && var->unk10[i].unkD4 & 1) {
            if (var->unk418 & 0x20)
                var->unk418 |= 0x40;
            if (!var->unk10[i].unkE0) {
                var->unk10[i].unkD0 |= 0x100;
                var->unk10[i].unkE0 = var->unk412;
                var->unk10[i].unkE2 = var->unk40D;
                if (var->unk418 & 0x20) {
                    ++v;
                    var->unk10[i].unkDC |= 1;
                }
                else {
                    var->unk10[i].unkD0 |= 0x200;
                    var->unk10[i].unkCC = sub_081380C0(&var->unk10[i], gUnk_0837F1F0[i << 1], gUnk_0837F1F0[(i << 1) + 1]);
                }
            }
        }
    }
    if (v) ++var->unk40D;
    if (var->unk418 & 0x40 && ++var->unk414 > 4) {
        for (i = 0; i < 4; ++i) {
            if (var->unk10[i].unkD0 & 0x100) {
                if (var->unk10[i].unkD0 & 0x200)
                    var->unk10[i].unkDC |= 0x40;
                else
                    ++var->unk40C;
            }
            else
                var->unk10[i].unkDC |= 0x40;
        }
        for (i = 0; i < 4; ++i) {
            if (var->unk10[i].unkD0 & 0x100 && !(var->unk10[i].unkD0 & 0x200))
                var->unk10[i].unkDF = gUnk_08D61B6C[var->unk40C][var->unk10[i].unkE2];
        }
        var->unk3C0.unk34 |= 0x1000;
        gCurTask->main = sub_08135E9C;
    }
    ++var->unk412;
    if (var->unk418 & 0x20 && var->unk412 >= var->unk410 + 600) {
        var->unk418 |= 0x80;
        gCurTask->main = sub_081366B8;
        CreatePauseFade(0x10, 1);
    }
    if (var->unk10[0].unkD0 & 0x200
        && var->unk10[1].unkD0 & 0x200
        && var->unk10[2].unkD0 & 0x200
        && var->unk10[3].unkD0 & 0x200) {
        var->unk418 |= 0x80;
        gCurTask->main = sub_081366B8;
        CreatePauseFade(0x10, 1);
    }
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_08135E9C(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;

    for (i = 0; i < 4; ++i) {
        if (var->unk10[i].unkDC & 1) {
            var->unk10[i].unkDC &= ~1;
            if (var->unk418 & 1) {
                m4aSongNumStart(569);
                sub_08136F3C(&var->unk10[i], i, FALSE);
            }
        }
        if (var->unk10[i].unkDC & 0x10) {
            struct Unk_08128F44_4 *ptr;

            m4aSongNumStop(569);
            m4aSongNumStart(570);
            var->unk10[i].unkDC &= ~0x10;
            var->unk10[i].unkDC |= 0x20;
            ptr = BeYourself(&var->unk10[i].unk0);
            ptr->unk0.animId = gUnk_0837EFC8[gLanguage][2].animId;
            ptr->unk0.variant = gUnk_0837EFC8[gLanguage][2].variant;
            ptr->unk0.unk1B = 0xFF;
            var->unk10[i].unk0.unk34 &= ~0x800;
        }
        if (var->unk10[i].unkDC & 0x20 && var->unk10[i].unk0.unk34 & 0x200) {
            struct Unk_08128F44_4 *ptr;

            var->unk10[i].unkDC &= ~0x20;
            var->unk10[i].unkDC |= 0x40;
            ptr = BeYourself(&var->unk10[i].unk0);
            ptr->unk0.animId = gUnk_0837EFC8[gLanguage][0].animId;
            ptr->unk0.variant = gUnk_0837EFC8[gLanguage][0].variant;
            ptr->unk0.unk1B = 0xFF;
            var->unk10[i].unk0.unk34 |= 0x800;
        }
    }
    if (var->unk10[0].unkDC & 0x40
        && var->unk10[1].unkDC & 0x40
        && var->unk10[2].unkDC & 0x40
        && var->unk10[3].unkDC & 0x40)
        gCurTask->main = sub_08136078;
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_08136078(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;

    sub_08136C68(var);
    for (i = 0; i < 4; ++i) {
        if (var->unk10[i].unkDF && var->unk10[i].unkE7++ > 0xF) {
            struct Unk_08128F44_4 *ptr;
            u8 xff;

            m4aSongNumStart(571);
            var->unk10[i].unkE7 = 0;
            --var->unk10[i].unkDF;
            if (++var->unk10[i].unkDE > 8)
                var->unk10[i].unkDE = 8;
            ptr = BeYourself(&var->unk10[i].unk44);
            ptr->unk0.animId = gUnk_0837F078[gLanguage][var->unk10[i].unkDE].animId;
            ptr->unk0.variant = gUnk_0837F078[gLanguage][var->unk10[i].unkDE].variant;
            xff = 0xFF;
            *&ptr->unk0.unk1B = xff; // absolutely fake
        }
    }
    if (!var->unk10[0].unkDF && !var->unk10[1].unkDF && !var->unk10[2].unkDF && !var->unk10[3].unkDF) {
        gCurTask->main = sub_081366B8;
        CreatePauseFade(0x10, 1);
    }
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_081361B4(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;
    u8 v;
    void (*fp)(void);

    sub_08136C68(var);
    if (var->unk410 == var->unk412) {
        var->unk418 |= 0x20;
        m4aSongNumStart(568);
        sub_08137668();
        sub_081386DC(var->unkC);
    }
    if (var->unk418 & 0x400
        && var->unk410 - 0x3C > var->unk412
        && !(var->unk412 % 120))
        sub_08137874();
    v = 0;
    for (i = 0; i < 4; ++i) {
        if (!(var->unk10[i].unkD0 & 0x400)
            && !(var->unk10[i].unkD0 & 0x200)
            && var->unk10[i].unkD4 & 1) {
            if (var->unk418 & 0x20)
                var->unk418 |= 0x40;
            if (!var->unk10[i].unkE0) {
                var->unk10[i].unkD0 |= 0x100;
                var->unk10[i].unkE0 = var->unk412;
                var->unk10[i].unkE2 = var->unk40D;
                if (var->unk418 & 0x20) {
                    ++v;
                    var->unk10[i].unkDC |= 1;
                }
                else {
                    var->unk10[i].unkD0 |= 0x200;
                    var->unk10[i].unkCC = sub_081380C0(&var->unk10[i], gUnk_0837F1F0[i << 1], gUnk_0837F1F0[(i << 1) + 1]);
                }
            }
        }
    }
    if (v) ++var->unk40D;
    if (var->unk418 & 0x40 && ++var->unk414 > 2) {
        for (i = 0; i < 4; ++i) {
            if (var->unk10[i].unkD0 & 0x100) {
                if (var->unk10[i].unkD0 & 0x200)
                    var->unk10[i].unkDC |= 0x40;
                else
                    ++var->unk40C;
            }
            else
                var->unk10[i].unkDC |= 0x40;
        }
        fp = sub_08136518; // handles regswap
        for (i = 0; i < 4; ++i) {
            if (var->unk10[i].unkD0 & 0x100 && !(var->unk10[i].unkD0 & 0x200))
                var->unk10[i].unkDF = gUnk_08D61B6C[var->unk40C][var->unk10[i].unkE2];
        }
        var->unk3C0.unk34 |= 0x1000;
        gCurTask->main = fp;
    }
    ++var->unk412;
    if (var->unk418 & 0x20 && var->unk412 >= var->unk410 + 300) {
        var->unk418 |= 0x80;
        gCurTask->main = sub_081366B8;
        CreatePauseFade(0x10, 1);
    }
    if (var->unk10[0].unkD0 & 0x200
        && var->unk10[1].unkD0 & 0x200
        && var->unk10[2].unkD0 & 0x200
        && var->unk10[3].unkD0 & 0x200) {
        var->unk418 |= 0x80;
        gCurTask->main = sub_081366B8;
        CreatePauseFade(0x10, 1);
    }
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_08136518(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;
    bool32 v = FALSE;

    for (i = 0; i < 4; ++i) {
        if (var->unk10[i].unkDC & 1) {
            var->unk10[i].unkDC &= ~1;
            if (!(var->unk418 & 1)) {
                m4aSongNumStart(569);
                sub_08136F3C(&var->unk10[i], i, TRUE);
            }
        }
        if (var->unk10[i].unkDC & 0x10) {
            struct Unk_08128F44_4 *ptr;

            var->unk10[i].unkDC &= ~0x10;
            var->unk10[i].unkDC |= 0x20;
            m4aSongNumStop(569);
            m4aSongNumStart(570);
            ptr = BeYourself(&var->unk10[i].unk0);
            ptr->unk0.animId = gUnk_0837EFC8[gLanguage][3].animId;
            ptr->unk0.variant = gUnk_0837EFC8[gLanguage][3].variant;
            ptr->unk0.unk1B = 0xFF;
        }
        if (var->unk10[i].unkDC & 0x20) {
            var->unk10[i].unkDC &= ~0x20;
            sub_0813773C(&var->unk10[i]);
            if (!v) {
                v = TRUE;
                sub_081377D4();
            }
        }
    }
    if (var->unk10[0].unkDC & 0x40
        && var->unk10[1].unkDC & 0x40
        && var->unk10[2].unkDC & 0x40
        && var->unk10[3].unkDC & 0x40)
        gCurTask->main = sub_08137498;
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_081366B8(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;

    if (!sub_0812A304()) {
        for (i = 0; i < 4; ++i) {
            if (var->unk10[i].unkCC) {
                TaskDestroy(var->unk10[i].unkCC);
                var->unk10[i].unkCC = NULL;
            }
        }
        if (var->unk10[0].unkDE >= 8
            || var->unk10[1].unkDE >= 8
            || var->unk10[2].unkDE >= 8
            || var->unk10[3].unkDE >= 8) {
            gCurTask->main = sub_0813683C;
        }
        else {
            if (++var->unk41A > 7) var->unk41A = 7;
            gCurTask->main = sub_081358EC;
            for (i = 0; i < 4; ++i) {
                struct Unk_08128F44_4 *ptr;

                if (var->unk10[i].unkD0 & 0x400) {
                    var->unk10[i].unkD0 &= ~0x400;
                    ptr = BeYourself(&var->unk10[i].unk0);
                    ptr->unk0.animId = gUnk_0837EFC8[gLanguage][0].animId;
                    ptr->unk0.variant = gUnk_0837EFC8[gLanguage][0].variant;
                    ptr->unk0.unk1B = 0xFF;
                    var->unk10[i].unk0.unk0.palId = i;
                }
                if (!(var->unk418 & 1)) {
                    var->unk41A = 0;
                    if (var->unk10[i].unkD0 & 0x100
                        && !(var->unk10[i].unkD0 & 0x200))
                        var->unk10[i].unkD0 |= 0x400;
                }
            }
        }
    }
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_0813683C(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u8 i;

    if (!sub_0812A304()) {
        CreatePauseFade(-0x10, 1);
        sub_08137204(var);
        for (i = 0; i < 4; ++i) {
            struct Unk_08128F44_4 *ptr;
#ifndef NONMATCHING
            register uintptr_t cursed asm("r4") __attribute__((unused)) = i * sizeof(struct Unk_08134D64_10) + (uintptr_t)var;
#endif

            ptr = BeYourself(&var->unk10[i].unk88);
            ptr->unk0.animId = gUnk_0837F170[gLanguage][var->unk10[i].unkE8].animId;
            ptr->unk0.variant = gUnk_0837F170[gLanguage][var->unk10[i].unkE8].variant;
            ptr->unk0.unk1B = 0xFF;
            var->unk10[i].unkD0 |= 0x20;
            var->unk10[i].unk0.unk0.palId = i;
            if (var->unk10[i].unkE8 == 0) {
                ptr = BeYourself(&var->unk10[i].unk0);
                ptr->unk0.animId = gUnk_0837EFC8[gLanguage][5].animId;
                ptr->unk0.variant = gUnk_0837EFC8[gLanguage][5].variant;
                ptr->unk0.unk1B = 0xFF;
                var->unk10[i].unk0.unk2C -= 0x30;
            }
            else if (var->unk10[i].unkE8 == 3) {
                ptr = BeYourself(&var->unk10[i].unk0);
                ptr->unk0.animId = gUnk_0837EFC8[gLanguage][4].animId;
                ptr->unk0.variant = gUnk_0837EFC8[gLanguage][4].variant;
                ptr->unk0.unk1B = 0xFF;
            }
            else {
                ptr = BeYourself(&var->unk10[i].unk0);
                ptr->unk0.animId = gUnk_0837EFC8[gLanguage][0].animId;
                ptr->unk0.variant = gUnk_0837EFC8[gLanguage][0].variant;
                ptr->unk0.unk1B = 0xFF;
                sub_08155128(&var->unk10[i].unk0.unk0);
                var->unk10[i].unk0.unk34 |= 0x100;
            }
        }
        if (var->unk10[var->unk41D].unkE8 == 0) {
            if (var->unk10[var->unk41D].unkDE == 8
                && var->unk10[0].unkDE + var->unk10[1].unkDE + var->unk10[2].unkDE + var->unk10[3].unkDE == 8)
                m4aSongNumStart(34);
            else
                m4aSongNumStart(33);
        }
        else
            m4aSongNumStart(36);
        gCurTask->main = sub_08136A40;
    }
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_08136A40(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;
    u16 r1, r2;

    if (!sub_0812A304()) {
        if (!var->unk0) {
            if (gUnk_0203AD10 & 2) {
                r2 = gUnk_020382D0.unk8[1][0];
                r1 = gUnk_020382D0.unk8[0][0];
            }
            else {
                r2 = gPressedKeys;
                r1 = gInput;
            }
            if (r2 & 1) {
                if (gUnk_0203AD3C)
                    var->unk0 = sub_08128F44(gUnk_0837EF38[gLanguage], 0xD, 0xE, 0x50, 0x82, 1);
                else
                    var->unk0 = sub_08128F44(gUnk_0837EF38[gLanguage], 0xD, 0xE, 0x50, 0x82, 0);
            }
            else if (r1 & 4) {
                if (r2 & 0x200)
                    ++var->unk416;
                else if (r2 & 0x100)
                    ++var->unk417;
            }
        }
        else {
            struct Unk_08128F44 *tmp = TaskGetStructPtr(var->unk0), *var2 = tmp;

            if (sub_0812A328(var2)) {
                CreatePauseFade(0x10, 1);
                var->unk41C = var2->unk2AD;
                if (var2->unk2AC & 0x10)
                    gCurTask->main = sub_081374E8;
                else {
                    gCurTask->main = sub_08136BE4;
                    RLUnCompVram(gUnk_0838518C, (void *)0x600F000);
                }
            }
        }
    }
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_08136BE4(void) {
    struct Unk_08134D64 *var = TaskGetStructPtr(gCurTask);

    if (!sub_0812A304()) {
        TaskDestroy(var->unk0);
        var->unk0 = NULL;
        TaskDestroy(var->unkC);
        var->unkC = NULL;
        if (gUnk_0203AD10 & 2)
            gUnk_020382D0.unk4 &= ~2;
        var->unk41E = 0;
        gCurTask->main = sub_0813754C;
    }
}

static void sub_08136C68(struct Unk_08134D64 *a1) {
    u8 i;

    for (i = 0; i < 4; ++i) {
        if (a1->unk10[i].unkD0 & 1) {
            a1->unk10[i].unkD8 = 0;
            a1->unk10[i].unkD6 = 0;
            a1->unk10[i].unkD4 = a1->unk10[i].unkE4 == a1->unk412;
            a1->unk10[i].unkDA = 0;
        }
        else if (gUnk_0203AD10 & 2) {
            a1->unk10[i].unkD8 = a1->unk10[i].unkD6;
            a1->unk10[i].unkD6 = gUnk_020382D0.unk8[0][i];
            a1->unk10[i].unkD4 = gUnk_020382D0.unk8[1][i];
            a1->unk10[i].unkDA = gUnk_020382D0.unk8[2][i];
        }
        else {
            a1->unk10[i].unkD8 = gPrevInput;
            a1->unk10[i].unkD6 = gInput;
            a1->unk10[i].unkD4 = gPressedKeys;
            a1->unk10[i].unkDA = gReleasedKeys;
        }
    }
}

static void sub_08136D5C(struct Unk_08134D64 *a1) {
    u32 a = Rand16() & 0xF, b = Rand32() & 0xF;

    if (a < gUnk_0837F408[a1->unk41A][b]) {
        struct Sprite *ptr;

        a1->unk418 &= ~1;
        a1->unk3C0.unk0.palId = 5;
        ptr = &a1->unk3C0.unk0;
        ptr->animId = gUnk_0837F228[gLanguage][5].animId;
        ptr->variant = gUnk_0837F228[gLanguage][5].variant;
        ptr->unk1B = 0xFF;
    }
    else {
        struct Sprite *ptr;

        a1->unk418 |= 1;
        a1->unk3C0.unk0.palId = 7;
        ptr = &a1->unk3C0.unk0;
        ptr->animId = gUnk_0837F228[gLanguage][0].animId;
        ptr->variant = gUnk_0837F228[gLanguage][0].variant;
        ptr->unk1B = 0xFF;
    }
}

static void sub_08136E3C(void) {
    struct Unk_0813773C *var = TaskGetStructPtr(gCurTask);

    ++var->unk4;
    if (var->unk4 < 0x3D) {
        if (var->unk4 == 0x37)
            sub_08137E24(var->unk0);
    }
    else {
        var->unk0->unk0.unk0.animId = gUnk_0837EFC8[gLanguage][4].animId;
        var->unk0->unk0.unk0.variant = gUnk_0837EFC8[gLanguage][4].variant;
        var->unk0->unk0.unk0.unk1B = 0xFF;
        var->unk0->unk0.unk0.palId = 4;
        var->unk4 = 0;
        gCurTask->main = sub_08136ED0;
    }
}

static void sub_08136ED0(void) {
    struct Unk_0813773C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (var->unk4 < 0x16)
        var->unk0->unk0.unk2C += 4 * gUnk_0837F210[var->unk4];
    else {
        var->unk0->unkDC |= 0x40;
        TaskDestroy(gCurTask);
    }
    ++var->unk4;
}

static void sub_08136F3C(struct Unk_08134D64_10 *a1, u8 a2, bool8 a3) {
    struct Task *t = TaskCreate(sub_08137190, sizeof(struct Unk_08136F3C), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_08136F3C *tmp = TaskGetStructPtr(t), *var = tmp;
    u8 idx;

    var->unk54 = a1;
    idx = a1->unkDF;
    if (a3) idx += 5;
    a1->unk0.unk0.animId = gUnk_0837EFC8[gLanguage][1].animId;
    a1->unk0.unk0.variant = gUnk_0837EFC8[gLanguage][1].variant;
    a1->unk0.unk0.unk1B = 0xFF;
    var->unk0.unk0 = &a1->unk0;
    var->unk0.unk50 = 0;
    var->unk0.unk52 = 2;
    var->unk0.unk48 = gUnk_0837F318[a2 << 1];
    var->unk0.unk4C = gUnk_0837F318[(a2 << 1) + 1];
    if (var->unk0.unk52 & 2) {
        ({ CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x440;
        var->unk0.unk4.unk0.animId = gUnk_0837F228[gLanguage][idx].animId;
        var->unk0.unk4.unk0.variant = gUnk_0837F228[gLanguage][idx].variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 7;
        var->unk0.unk4.unk0.x = (var->unk0.unk48 + var->unk0.unk0[0].unk28) >> 2;
        var->unk0.unk4.unk0.y = (var->unk0.unk4C + var->unk0.unk0[0].unk2C) >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48 + var->unk0.unk0[0].unk28;
        var->unk0.unk4.unk2C = var->unk0.unk4C + var->unk0.unk0[0].unk2C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4));
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x440;
        var->unk0.unk4.unk0.animId = gUnk_0837F228[gLanguage][idx].animId;
        var->unk0.unk4.unk0.variant = gUnk_0837F228[gLanguage][idx].variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 7;
        var->unk0.unk4.unk0.x = var->unk0.unk48 >> 2;
        var->unk0.unk4.unk0.y = var->unk0.unk4C >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48;
        var->unk0.unk4.unk2C = var->unk0.unk4C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    if (a3) var->unk0.unk4.unk0.palId = 5;
    var->unk0.unk4.unk0.unk8 &= ~0x3000;
    var->unk0.unk4.unk0.unk8 |= 0x1000;
    var->unk0.unk4.unk30 = gUnk_0837F338[a2 << 1];
    var->unk0.unk4.unk32 = gUnk_0837F338[(a2 << 1) + 1];
}

static void sub_08137190(void) {
    struct Unk_08136F3C *var = TaskGetStructPtr(gCurTask);

    if (var->unk0.unk48 > -8 && var->unk0.unk48 < 8) {
        var->unk0.unk48 = 0;
        var->unk0.unk4.unk30 = 0;
    }
    if (var->unk0.unk4C < 9) {
        var->unk0.unk4C = 0;
        var->unk0.unk4.unk32 = 0;
    }
    sub_0812A2C0(&var->unk0);
    if (!var->unk0.unk48 && !var->unk0.unk4C) {
        var->unk54->unkDC |= 0x10;
        TaskDestroy(gCurTask);
    }
}

#define max2(a, b) ((a) > (b) ? (a) : (b))

static void sub_08137204(struct Unk_08134D64 *a1) {
    u8 array[4];
    u8 i, j, ip;
    u16 max;

    array[0] = a1->unk10[0].unkDE;
    array[1] = a1->unk10[1].unkDE;
    array[2] = a1->unk10[2].unkDE;
    array[3] = a1->unk10[3].unkDE;
    for (i = 0; i < 4; i += ip) {
        ip = 0;
        max = max2(array[0], max2(array[1], max2(array[2], array[3])));
        for (j = 0; j < 4; ++j) {
            if (max == a1->unk10[j].unkDE) {
                a1->unk10[j].unkE8 = i;
                a1->unk408[i + ip] = j;
                array[j] = 0;
                ++ip;
            }
        }
    }
}

static void sub_08137304(void) {
    struct Unk_081377D4 *var = TaskGetStructPtr(gCurTask);

    gBgScrollRegs[0][0] += gUnk_0837F488[var->unk0];
    gBgScrollRegs[0][1] += gUnk_0837F497[var->unk0];
    gBgScrollRegs[1][0] += gUnk_0837F488[var->unk0];
    gBgScrollRegs[1][1] += gUnk_0837F497[var->unk0];
    if (var->unk0++ > 0xE) {
        gBgScrollRegs[0][0] = 8;
        gBgScrollRegs[0][1] = 8;
        gBgScrollRegs[1][0] = 8;
        gBgScrollRegs[1][1] = 8;
        TaskDestroy(gCurTask);
    }
}

static void sub_081373A8(void) {
    struct Unk_081377D4 *var = TaskGetStructPtr(gCurTask);

    gBgScrollRegs[2][0] = gUnk_0837F4A6[var->unk0];
    gBgScrollRegs[2][1] = gUnk_0837F4B5[var->unk0];
    if (var->unk0++ > 0xE) {
        gBgScrollRegs[2][0] = 0;
        gBgScrollRegs[2][1] = 0;
        TaskDestroy(gCurTask);
    }
}

static void sub_08137420(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    sub_081386A8(var->unkC);
    if (var->unk418 & 1)
        gCurTask->main = sub_08135B38;
    else
        gCurTask->main = sub_081361B4;
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_08137498(void) {
    struct Unk_08134D64 *var = TaskGetStructPtr(gCurTask);

    gCurTask->main = sub_081366B8;
    CreatePauseFade(0x10, 1);
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_081374E8(void) {
    struct Unk_08134D64 *var = TaskGetStructPtr(gCurTask);

    if (!sub_0812A304()) {
        m4aMPlayAllStop();
        gCurTask->main = sub_08134E54;
        TaskDestroy(var->unk0);
        var->unk0 = NULL;
    }
    sub_081288DC(&var->unk3C0);
    sub_08137788(var);
}

static void sub_0813754C(void) {
    struct Unk_08134D64 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (var->unk41E++ > 0x32) {
        TaskDestroy(gCurTask);
        if (gUnk_0203AD10 & 2) {
            sub_08031CC8();
            sub_081589E8();
        }
        sub_08138D64(0);
    }
}

static void nullsub_128(struct Task *t) {}

static void sub_081375BC(struct Unk_08134D64 *a1) {
    s32 var;

    Rand32();
    var = gUnk_0837F388[a1->unk41C][gRngVal & 0xF];
    a1->unk410 = var + ((gRngVal >> 2) & 0xF);
}

static void sub_08137610(struct Unk_08134D64_10 *a1, u8 a2, u16 a3) {
    u16 var;

    if (a1->unkD0 & 1) {
        var = Rand16() & 0xF;
        a1->unkE4 = gUnk_0837F348[a2][var] + a3;
    }
}

static void sub_08137668(void) {
    struct Task *t = TaskCreate(sub_081376E4, sizeof(struct Unk_081377D4), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_081377D4 *var = TaskGetStructPtr(t);

    var->unk0 = 0;
    gUnk_03000530 = var;
    gUnk_03002470[gUnk_03006070++] = sub_081378BC;
    gMainFlags |= 0x10;
}

static void sub_081376E4(void) {
    struct Unk_081377D4 *var = TaskGetStructPtr(gCurTask);

    if (++var->unk0 > 0x1E) {
        gDispCnt &= ~DISPCNT_BG2_ON;
        TaskDestroy(gCurTask);
    }
}

static void sub_0813773C(struct Unk_08134D64_10 *a1) {
    struct Task *t = TaskCreate(sub_08136E3C, sizeof(struct Unk_0813773C), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0813773C *var = TaskGetStructPtr(t);

    var->unk0 = a1;
    var->unk4 = 0;
}

static void sub_08137788(struct Unk_08134D64 *a1) {
    u8 i;
    struct Unk_08134D64_10 *var;

    for (i = 0; i < 4; ++i) {
        var = &a1->unk10[i];
        sub_081288DC(&var->unk0);
        if (var->unkD0 & 0x10)
            sub_081288DC(&var->unk44);
        if (var->unkD0 & 0x20)
            sub_081288DC(&var->unk88);
    }
}

static void sub_081377D4(void) {
    struct Task *t = TaskCreate(sub_0813781C, sizeof(struct Unk_081377D4), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_081377D4 *var = TaskGetStructPtr(t);

    var->unk0 = 0;
}

static void sub_0813781C(void) {
    struct Unk_081377D4 *var = TaskGetStructPtr(gCurTask);

    if (var->unk0 > 0x3C) {
        var->unk0 = 0;
        m4aSongNumStart(572);
        gCurTask->main = sub_08137304;
    }
    ++var->unk0;
}

static void sub_08137874(void) {
    struct Task *t = TaskCreate(sub_081373A8, sizeof(struct Unk_081377D4), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_081377D4 *var = TaskGetStructPtr(t);

    var->unk0 = 0;
}

static void sub_081378BC(void) {
    RLUnCompVram(gUnk_083850A4, (void *)0x600F000);
}

static void sub_081378D4(struct Unk_08134D64_10 *a1) {
    struct Task *t = TaskCreate(sub_08137A80, sizeof(struct Unk_0812E818), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812E818 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 local;

    var->unk54 = 0;
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        local.animId = 0x368;
        local.variant = 1;
        break;
    case LANGUAGE_ENGLISH:
        local.animId = 0x368;
        local.variant = 1;
        break;
    case LANGUAGE_GERMAN:
        local.animId = 0x368;
        local.variant = 1;
        break;
    case LANGUAGE_FRENCH:
        local.animId = 0x368;
        local.variant = 1;
        break;
    case LANGUAGE_SPANISH:
        local.animId = 0x368;
        local.variant = 1;
        break;
    case LANGUAGE_ITALIAN:
        local.animId = 0x368;
        local.variant = 1;
        break;
    }
    var->unk0.unk0 = &a1->unk0;
    var->unk0.unk50 = 0x5A;
    var->unk0.unk52 = 3;
    var->unk0.unk48 = 0;
    var->unk0.unk4C = -0xB8;
    if (var->unk0.unk52 & 2) {
        ({ CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x3C0;
        var->unk0.unk4.unk0.animId = local.animId;
        var->unk0.unk4.unk0.variant = local.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = (var->unk0.unk48 + var->unk0.unk0[0].unk28) >> 2;
        var->unk0.unk4.unk0.y = (var->unk0.unk4C + var->unk0.unk0[0].unk2C) >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48 + var->unk0.unk0[0].unk28;
        var->unk0.unk4.unk2C = var->unk0.unk4C + var->unk0.unk0[0].unk2C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4));
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x3C0;
        var->unk0.unk4.unk0.animId = local.animId;
        var->unk0.unk4.unk0.variant = local.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = var->unk0.unk48 >> 2;
        var->unk0.unk4.unk0.y = var->unk0.unk4C >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48;
        var->unk0.unk4.unk2C = var->unk0.unk4C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x810;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    var->unk0.unk4.unk38 = a1->unk0.unk38;
    var->unk0.unk4.unk32 = 2;
}

static void sub_08137A80(void) {
    struct Unk_0812E818 *var = TaskGetStructPtr(gCurTask);

    sub_0812A2C0(&var->unk0);
    if (var->unk54++ > 0x18) {
        var->unk54 = 0;
        var->unk0.unk4C = -0xB8;
    }
    if (var->unk0.unk52 & 1) {
        if (var->unk0.unk50)
            --var->unk0.unk50;
        else
            TaskDestroy(gCurTask);
    }
}

static void sub_08137AF8(struct Unk_08134D64_10 *a1) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 local;

    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        local.animId = 0x368;
        local.variant = 2;
        break;
    case LANGUAGE_ENGLISH:
        local.animId = 0x368;
        local.variant = 2;
        break;
    case LANGUAGE_GERMAN:
        local.animId = 0x368;
        local.variant = 2;
        break;
    case LANGUAGE_FRENCH:
        local.animId = 0x368;
        local.variant = 2;
        break;
    case LANGUAGE_SPANISH:
        local.animId = 0x368;
        local.variant = 2;
        break;
    case LANGUAGE_ITALIAN:
        local.animId = 0x368;
        local.variant = 2;
        break;
    }
    var->unk0 = &a1->unk0;
    var->unk50 = 0x5A;
    var->unk52 = 3;
    var->unk48 = 0;
    var->unk4C = -0xB8;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = local.animId;
        var->unk4.unk0.variant = local.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 5;
        var->unk4.unk0.x = (var->unk48 + var->unk0[0].unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0[0].unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0[0].unk28;
        var->unk4.unk2C = var->unk4C + var->unk0[0].unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = local.animId;
        var->unk4.unk0.variant = local.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 5;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    var->unk4.unk38 = a1->unk0.unk38;
}

static void sub_08137C98(void) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 local;

    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        local.animId = 0x368;
        local.variant = 0;
        break;
    case LANGUAGE_ENGLISH:
        local.animId = 0x368;
        local.variant = 0;
        break;
    case LANGUAGE_GERMAN:
        local.animId = 0x368;
        local.variant = 0;
        break;
    case LANGUAGE_FRENCH:
        local.animId = 0x368;
        local.variant = 0;
        break;
    case LANGUAGE_SPANISH:
        local.animId = 0x368;
        local.variant = 0;
        break;
    case LANGUAGE_ITALIAN:
        local.animId = 0x368;
        local.variant = 0;
        break;
    }
    var->unk0 = NULL;
    var->unk50 = 0x96;
    var->unk52 = 1;
    var->unk48 = 0x1E0;
    var->unk4C = 0xF0;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = local.animId;
        var->unk4.unk0.variant = local.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 5;
        var->unk4.unk0.x = (var->unk48 + var->unk0[0].unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0[0].unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0[0].unk28;
        var->unk4.unk2C = var->unk4C + var->unk0[0].unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = local.animId;
        var->unk4.unk0.variant = local.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 5;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x810;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
}

static void sub_08137E24(struct Unk_08134D64_10 *a1) {
    struct Task *t = TaskCreate(sub_08137FC8, sizeof(struct Unk_08137FC8), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_08137FC8 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 local;

    var->unk54 = &a1->unk0;
    var->unk58 = 0;
    var->unk59 = 0;
    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        local.animId = 0x36A;
        local.variant = 0;
        break;
    case LANGUAGE_ENGLISH:
        local.animId = 0x36A;
        local.variant = 0;
        break;
    case LANGUAGE_GERMAN:
        local.animId = 0x36A;
        local.variant = 0;
        break;
    case LANGUAGE_FRENCH:
        local.animId = 0x36A;
        local.variant = 0;
        break;
    case LANGUAGE_SPANISH:
        local.animId = 0x36A;
        local.variant = 0;
        break;
    case LANGUAGE_ITALIAN:
        local.animId = 0x36A;
        local.variant = 0;
        break;
    }
    var->unk0.unk0 = &a1->unk0;
    var->unk0.unk50 = 0;
    var->unk0.unk52 = 2;
    var->unk0.unk48 = 0;
    var->unk0.unk4C = 0;
    if (var->unk0.unk52 & 2) {
        ({ CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x3C0;
        var->unk0.unk4.unk0.animId = local.animId;
        var->unk0.unk4.unk0.variant = local.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = (var->unk0.unk48 + var->unk0.unk0[0].unk28) >> 2;
        var->unk0.unk4.unk0.y = (var->unk0.unk4C + var->unk0.unk0[0].unk2C) >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48 + var->unk0.unk0[0].unk28;
        var->unk0.unk4.unk2C = var->unk0.unk4C + var->unk0.unk0[0].unk2C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x10;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4));
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x3C0;
        var->unk0.unk4.unk0.animId = local.animId;
        var->unk0.unk4.unk0.variant = local.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = var->unk0.unk48 >> 2;
        var->unk0.unk4.unk0.y = var->unk0.unk4C >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48;
        var->unk0.unk4.unk2C = var->unk0.unk4C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x10;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    var->unk0.unk4.unk38 = a1->unk0.unk38;
}

static void sub_08137FC8(void) {
    struct Unk_08137FC8 *var = TaskGetStructPtr(gCurTask);
    struct Unk_0812D1EC_0 *var2 = &var->unk0;

    sub_0812A2C0(var2);
    if (var->unk59 == 0) {
        if (++var->unk58 > 1) {
            var2->unk4.unk0.palId = 6;
            ++var->unk59;
            var->unk58 = 0;
        }
    }
    else if (var->unk59 == 1) {
        if (++var->unk58 > 1) {
            var2->unk4.unk0.palId = 5;
            ++var->unk59;
            var->unk58 = 0;
            switch (gLanguage) {
            case LANGUAGE_JAPANESE:
                var2->unk4.unk0.animId = 0x36A;
                var2->unk4.unk0.variant = 1;
                var2->unk4.unk0.unk1B = 0xFF;
                break;
            case LANGUAGE_ENGLISH:
                var2->unk4.unk0.animId = 0x36A;
                var2->unk4.unk0.variant = 1;
                var2->unk4.unk0.unk1B = 0xFF;
                break;
            case LANGUAGE_GERMAN:
                var2->unk4.unk0.animId = 0x36A;
                var2->unk4.unk0.variant = 1;
                var2->unk4.unk0.unk1B = 0xFF;
                break;
            case LANGUAGE_FRENCH:
                var2->unk4.unk0.animId = 0x36A;
                var2->unk4.unk0.variant = 1;
                var2->unk4.unk0.unk1B = 0xFF;
                break;
            case LANGUAGE_SPANISH:
                var2->unk4.unk0.animId = 0x36A;
                var2->unk4.unk0.variant = 1;
                var2->unk4.unk0.unk1B = 0xFF;
                break;
            case LANGUAGE_ITALIAN:
                var2->unk4.unk0.animId = 0x36A;
                var2->unk4.unk0.variant = 1;
                var2->unk4.unk0.unk1B = 0xFF;
                break;
            }
        }
    }
    else if (var->unk59 == 2) {
        do {
            if (var2->unk4.unk34 & 0x200)
                TaskDestroy(gCurTask);
        } while (0);
    }
}

static struct Task *sub_081380C0(struct Unk_08134D64_10 *a1, s32 a2, s32 a3) {
    struct Task *t = TaskCreate(sub_0813870C, sizeof(struct Unk_081380C0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_081380C0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 local;

    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        local.animId = 0x369;
        local.variant = 0;
        break;
    case LANGUAGE_ENGLISH:
        local.animId = 0x369;
        local.variant = 0;
        break;
    case LANGUAGE_GERMAN:
        local.animId = 0x369;
        local.variant = 0;
        break;
    case LANGUAGE_FRENCH:
        local.animId = 0x369;
        local.variant = 0;
        break;
    case LANGUAGE_SPANISH:
        local.animId = 0x369;
        local.variant = 0;
        break;
    case LANGUAGE_ITALIAN:
        local.animId = 0x369;
        local.variant = 0;
        break;
    }
    var->unk0.unk0 = &a1->unk0;
    var->unk0.unk50 = 0;
    var->unk0.unk52 = 2;
    var->unk0.unk48 = a2;
    var->unk0.unk4C = a3;
    if (var->unk0.unk52 & 2) {
        ({ CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x400;
        var->unk0.unk4.unk0.animId = local.animId;
        var->unk0.unk4.unk0.variant = local.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = (var->unk0.unk48 + var->unk0.unk0[0].unk28) >> 2;
        var->unk0.unk4.unk0.y = (var->unk0.unk4C + var->unk0.unk0[0].unk2C) >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48 + var->unk0.unk0[0].unk28;
        var->unk0.unk4.unk2C = var->unk0.unk4C + var->unk0.unk0[0].unk2C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x10;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk0.unk4, sizeof(struct Unk_08128F44_4));
        var->unk0.unk4.unk0.tilesVram = 0x6010000;
        var->unk0.unk4.unk0.unk14 = 0x400;
        var->unk0.unk4.unk0.animId = local.animId;
        var->unk0.unk4.unk0.variant = local.variant;
        var->unk0.unk4.unk0.unk16 = 0;
        var->unk0.unk4.unk0.unk1B = 0xFF;
        var->unk0.unk4.unk0.unk1C = 0x10;
        var->unk0.unk4.unk0.palId = 5;
        var->unk0.unk4.unk0.x = var->unk0.unk48 >> 2;
        var->unk0.unk4.unk0.y = var->unk0.unk4C >> 2;
        var->unk0.unk4.unk0.unk8 = 0xC0000;
        var->unk0.unk4.unk28 = var->unk0.unk48;
        var->unk0.unk4.unk2C = var->unk0.unk4C;
        var->unk0.unk4.unk30 = 0;
        var->unk0.unk4.unk32 = 0;
        var->unk0.unk4.unk34 = 0x10;
        var->unk0.unk4.unk36 = 0;
        var->unk0.unk4.unk38 = NULL;
        var->unk0.unk4.unk3C = NULL;
        var->unk0.unk4.unk40 = NULL;
    }
    var->unk0.unk4.unk38 = a1->unk0.unk38;
    var->unk0.unk4.unk0.unk8 &= ~0x3000;
    var->unk0.unk4.unk0.unk8 |= 0x2000;
    var->unk0.unk4.unk0.unk14 &= ~0x7C0;
    var->unk0.unk4.unk0.unk14 |= (a1->unk0.unk0.unk14 - 1) & 0x7C0;
    var->unk54 = 0;
    return t;
}

static void sub_081382A0(s32 a1, s32 a2) {
    struct Task *t = TaskCreate(sub_08128980, sizeof(struct Unk_0812D1EC_0), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0812D1EC_0 *tmp = TaskGetStructPtr(t), *var = tmp;
    struct Unk_02021590 local;

    switch (gLanguage) {
    case LANGUAGE_JAPANESE:
        local.animId = 0x36A;
        local.variant = 3;
        break;
    case LANGUAGE_ENGLISH:
        local.animId = 0x36A;
        local.variant = 3;
        break;
    case LANGUAGE_GERMAN:
        local.animId = 0x36A;
        local.variant = 3;
        break;
    case LANGUAGE_FRENCH:
        local.animId = 0x36A;
        local.variant = 3;
        break;
    case LANGUAGE_SPANISH:
        local.animId = 0x36A;
        local.variant = 3;
        break;
    case LANGUAGE_ITALIAN:
        local.animId = 0x36A;
        local.variant = 3;
        break;
    }
    var->unk0 = NULL;
    var->unk50 = 0;
    var->unk52 = 0;
    var->unk48 = a1;
    var->unk4C = a2;
    if (var->unk52 & 2) {
        ({ CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4)); }); // for sharing the filler with another CpuSet call
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = local.animId;
        var->unk4.unk0.variant = local.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 5;
        var->unk4.unk0.x = (var->unk48 + var->unk0[0].unk28) >> 2;
        var->unk4.unk0.y = (var->unk4C + var->unk0[0].unk2C) >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48 + var->unk0[0].unk28;
        var->unk4.unk2C = var->unk4C + var->unk0[0].unk2C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x10;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
    else {
        CpuFill32(0, &var->unk4, sizeof(struct Unk_08128F44_4));
        var->unk4.unk0.tilesVram = 0x6010000;
        var->unk4.unk0.unk14 = 0x3C0;
        var->unk4.unk0.animId = local.animId;
        var->unk4.unk0.variant = local.variant;
        var->unk4.unk0.unk16 = 0;
        var->unk4.unk0.unk1B = 0xFF;
        var->unk4.unk0.unk1C = 0x10;
        var->unk4.unk0.palId = 5;
        var->unk4.unk0.x = var->unk48 >> 2;
        var->unk4.unk0.y = var->unk4C >> 2;
        var->unk4.unk0.unk8 = 0xC0000;
        var->unk4.unk28 = var->unk48;
        var->unk4.unk2C = var->unk4C;
        var->unk4.unk30 = 0;
        var->unk4.unk32 = 0;
        var->unk4.unk34 = 0x10;
        var->unk4.unk36 = 0;
        var->unk4.unk38 = NULL;
        var->unk4.unk3C = NULL;
        var->unk4.unk40 = NULL;
    }
}

static void sub_08138438(void) {
    struct Unk_08138518 *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (!var->unk3) {
        u32 r32 = Rand32();
        u32 r = r32 & 0x1E;

        var->unk0 = gUnk_083852D0[r];
        var->unk1 = gUnk_083852D0[r + 1];
        if ((r32 >> 3) & 1)
            var->unk0 += (r32 >> 2) & 3;
        else
            var->unk0 -= (r32 >> 2) & 3;
        if ((r32 >> 5) & 1)
            var->unk1 += (r32 >> 4) & 3;
        else
            var->unk1 -= (r32 >> 4) & 3;
        var->unk3 = r32 & 0x1F;
        sub_081382A0(4 * var->unk0, 4 * var->unk1);
        if (!--var->unk2) {
            TaskDestroy(gCurTask);
            return;
        }
    }
    --var->unk3;
}

static inline struct Unk_08138518 *sub_08138518_helper(void) {
    struct Task *t = TaskCreate(sub_08138438, sizeof(struct Unk_08138518), 0x100, TASK_USE_IWRAM, NULL);

    return TaskGetStructPtr(t);
}

static void sub_08138518(void) {
    struct Unk_0813862C *tmp = TaskGetStructPtr(gCurTask), *var = tmp;

    if (var->unk0 & 1)
        TaskDestroy(gCurTask);
    else if (!(var->unk0 & 2) && !var->unk2--) {
        struct Unk_08138518 *var2 = sub_08138518_helper();

        var2->unk0 = 0;
        var2->unk1 = 0;
        var2->unk2 = 2;
        var2->unk3 = 0;
        var->unk2 = (Rand32() & 0x4F) + 120;
    }
}

static void sub_081385DC(void) {
    struct Task *t = TaskCreate(sub_08138438, sizeof(struct Unk_08138518), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_08138518 *var = TaskGetStructPtr(t);

    var->unk0 = 0;
    var->unk1 = 0;
    var->unk2 = 2;
    var->unk3 = 0;
}

static struct Task *sub_0813862C(void) {
    struct Task *t = TaskCreate(sub_08138518, sizeof(struct Unk_0813862C), 0x100, TASK_USE_IWRAM, NULL);
    struct Unk_0813862C *var = TaskGetStructPtr(t);

    var->unk0 = 2;
    var->unk2 = 1;
    return t;
}

static void sub_08138678(struct Task *t) { // not referenced, so I can only guess what struct it's using
    struct Unk_0813862C *var = TaskGetStructPtr(t);

    var->unk0 |= 1;
}

static void sub_081386A8(struct Task *t) {
    struct Unk_0813862C *var = TaskGetStructPtr(t);

    var->unk0 &= ~2;
}

static void sub_081386DC(struct Task *t) {
    struct Unk_0813862C *var = TaskGetStructPtr(t);

    var->unk0 |= 2;
}

static void sub_0813870C(void) {
    struct Unk_081380C0 *var = TaskGetStructPtr(gCurTask);

    if (var->unk54 < 5) {
        var->unk0.unk4C -= 4;
        ++var->unk54;
    }
    sub_0812A2C0(&var->unk0);
}
