#ifndef GUARD_CONSTANTS_OBJECT_TYPES_H
#define GUARD_CONSTANTS_OBJECT_TYPES_H

#define OBJ_WADDLE_DEE_1               0x00
#define OBJ_BRONTO_BURT                0x01
#define OBJ_BLIPPER                    0x02
#define OBJ_GLUNK                      0x03
#define OBJ_SQUISHY                    0x04
#define OBJ_SCARFY                     0x05
#define OBJ_GORDO                      0x06
#define OBJ_SNOOTER_1                  0x07
#define OBJ_CHIP                       0x08
#define OBJ_SOARAR                     0x09
#define OBJ_HALEY                      0x0A
#define OBJ_ROLYPOLY                   0x0B
#define OBJ_CUPIE                      0x0C
#define OBJ_BLOCKIN                    0x0D
#define OBJ_SNOOTER_2                  0x0E
#define OBJ_LEAP                       0x0F
#define OBJ_JACK                       0x10
#define OBJ_BIG_WADDLE_DEE             0x11
#define OBJ_WADDLE_DOO                 0x12
#define OBJ_FLAMER                     0x13
#define OBJ_HOT_HEAD                   0x14
#define OBJ_LASER_BALL                 0x15
#define OBJ_PENGY                      0x16
#define OBJ_ROCKY                      0x17
#define OBJ_SIR_KIBBLE                 0x18
#define OBJ_SPARKY                     0x19
#define OBJ_SWORD_KNIGHT               0x1A
#define OBJ_UFO                        0x1B
#define OBJ_TWISTER                    0x1C
#define OBJ_WHEELIE                    0x1D
#define OBJ_NODDY                      0x1E
#define OBJ_GOLEM_1                    0x1F
#define OBJ_GOLEM_2                    0x20
#define OBJ_GOLEM_3                    0x21
#define OBJ_FOLEY_1                    0x22
#define OBJ_SHOOTY                     0x23
#define OBJ_SCARFY_FALLING             0x24
#define OBJ_BOXIN                      0x25
#define OBJ_COOKIN                     0x26
#define OBJ_MINNY                      0x27
#define OBJ_BOMBER                     0x28
#define OBJ_HEAVY_KNIGHT               0x29
#define OBJ_GIANT_ROCKY                0x2A
#define OBJ_METAL_GUARDIAN             0x2B
#define OBJ_EMPTY_2C                   0x2C
#define OBJ_BATTY                      0x2D
#define OBJ_FOLEY_2                    0x2E
#define OBJ_BANG_BANG                  0x2F
#define OBJ_DARK_MIND_BOMB             0x30
#define OBJ_EMPTY_31                   0x31
#define OBJ_DROPPY                     0x32
#define OBJ_PRANK                      0x33
#define OBJ_MIRRA                      0x34
#define OBJ_SHOTZO_1                   0x35
#define OBJ_SHADOW_KIRBY               0x36
#define OBJ_WADDLE_DEE_2               0x37
#define OBJ_MR_FROSTY                  0x38
#define OBJ_BONKERS                    0x39
#define OBJ_PHAN_PHAN                  0x3A
#define OBJ_BATAFIRE                   0x3B
#define OBJ_BOX_BOXER                  0x3C
#define OBJ_BOXY                       0x3D
#define OBJ_MASTER_HAND                0x3E
#define OBJ_BOMBAR                     0x3F
#define OBJ_EMPTY_40                   0x40
#define OBJ_EMPTY_41                   0x41
#define OBJ_EMPTY_42                   0x42
#define OBJ_EMPTY_43                   0x43
#define OBJ_EMPTY_44                   0x44
#define OBJ_KRACKO                     0x45
#define OBJ_KING_GOLEM                 0x46
#define OBJ_CRAZY_HAND_1               0x47
#define OBJ_GOBBLER                    0x48
#define OBJ_WIZ                        0x49
#define OBJ_MOLEY                      0x4A
#define OBJ_MEGA_TITAN                 0x4B
#define OBJ_TITAN_HEAD                 0x4C
#define OBJ_CRAZY_HAND_2               0x4D
#define OBJ_DARK_META_KNIGHT           0x4E
#define OBJ_DARK_MIND_FORM_1           0x4F
#define OBJ_DARK_MIND_FORM_2           0x50
#define OBJ_DARK_MIND_FORM_3_TRIGGER   0x51
#define OBJ_DARK_META_KNIGHT_W8        0x52
#define OBJ_EMPTY_53                   0x53
#define OBJ_EMPTY_54                   0x54
#define OBJ_EMPTY_55                   0x55
#define OBJ_EMPTY_56                   0x56
#define OBJ_EMPTY_57                   0x57
#define OBJ_EMPTY_58                   0x58
#define OBJ_EMPTY_59                   0x59
#define OBJ_EMPTY_5A                   0x5A
#define OBJ_EMPTY_5B                   0x5B
#define OBJ_EMPTY_5C                   0x5C
#define OBJ_EMPTY_5D                   0x5D
#define OBJ_SMALL_FOOD                 0x5E
#define OBJ_POP_SODA                   0x5F
#define OBJ_MEAT                       0x60
#define OBJ_TOMATO                     0x61
#define OBJ_BATTERY                    0x62
#define OBJ_1UP                        0x63
#define OBJ_INVINCIBLE_CANDY           0x64
#define OBJ_MIRROR_SHARD               0x65
#define OBJ_EMPTY_66                   0x66
#define OBJ_EMPTY_67                   0x67
#define OBJ_EMPTY_68                   0x68
#define OBJ_GOAL_GAME_BONUS            0x69
#define OBJ_EMPTY_6A                   0x6A
#define OBJ_EMPTY_6B                   0x6B
#define OBJ_EMPTY_6C                   0x6C
#define OBJ_SMALL_BUTTON               0x6D
#define OBJ_FLAME                      0x6E
#define OBJ_DOOR                       0x6F
#define OBJ_SHOTZO_2                   0x70
#define OBJ_VERTICAL_SLIDING_DOOR      0x71
#define OBJ_BOSS_CHALLENGE_DOOR        0x72
#define OBJ_OBJECT_SPAWNER             0x73
#define OBJ_DESTROYABLE_ROCK_BLOCK     0x74
#define OBJ_UNKNOWN_75                 0x75
#define OBJ_LAVA_WALL                  0x76
#define OBJ_SCROLL_LOCK                0x77
#define OBJ_CANNON_FUSE                0x78
#define OBJ_STAR_STONE_BLOCK           0x79
#define OBJ_UNKNOWN_7A                 0x7A
#define OBJ_STAR_PLATFORM              0x7B
#define OBJ_FLAME_COLUMN               0x7C
#define OBJ_LARGE_STAR_STONE_BLOCK_7D  0x7D
#define OBJ_LARGE_STAR_STONE_BLOCK_7E  0x7E
#define OBJ_CPU_KIRBY_TRIGGER          0x7F
#define OBJ_SMALL_CHEST                0x80
#define OBJ_BIG_CHEST                  0x81
#define OBJ_UNKNOWN_82                 0x82
#define OBJ_UNKNOWN_83                 0x83
#define OBJ_WARP_STAR                  0x84
#define OBJ_GOAL_STAR                  0x85
#define OBJ_BIG_BUTTON                 0x86
#define OBJ_UNKNOWN_87                 0x87
#define OBJ_LARGE_STAR_STONE_BLOCK_88  0x88
#define OBJ_LARGE_STAR_STONE_BLOCK_89  0x89
#define OBJ_CANNON                     0x8A
#define OBJ_8_DIR_CANNON               0x8B
#define OBJ_HUB_MIRROR                 0x8C
#define OBJ_HAMMER_PEG                 0x8D
#define OBJ_CUTSCENE_TRIGGER           0x8E
#define OBJ_MASTER_SWORD_UNOBTAINABLE  0x8F
#define OBJ_WIND_EFFECT                0x90
#define OBJ_TRIGGERABLE_WALL           0x91
#define OBJ_ABILITY_STATUE_1           0x92
#define OBJ_ABILITY_STATUE_2           0x93
#define OBJ_ABILITY_STATUE_3           0x94
#define OBJ_ABILITY_STATUE_4           0x95
#define OBJ_ABILITY_STATUE_RANDOM      0x96
#define OBJ_DOOR_TO_HUB                0x97
#define OBJ_MASTER_SWORD_STAND         0x98
#define OBJ_AREA_DOOR                  0x99
#define OBJ_EMPTY_9A                   0x9A
#define OBJ_KING_GOLEM_ROCK            0x9B
#define OBJ_KING_GOLEM_GORDO           0x9C
#define OBJ_FOLEY_LEAVES               0x9D
#define OBJ_COOKIN_PAN                 0x9E
#define OBJ_GOBBLER_BABY               0x9F
#define OBJ_UNKNOWN_A0                 0xA0
#define OBJ_BATAFIRE_FIREBALL          0xA1
#define OBJ_PARASOL                    0xA2
#define OBJ_ABILITY_STAR_1             0xA3
#define OBJ_ABILITY_STAR_2             0xA4
#define OBJ_INHALABLE_STAR             0xA5
#define OBJ_MR_FROSTY_ICE_CUBE_SMALL   0xA6
#define OBJ_MR_FROSTY_ICE_CUBE_LARGE   0xA7
#define OBJ_BONKERS_NUT_SMALL          0xA8
#define OBJ_BONKERS_NUT_LARGE          0xA9
#define OBJ_APPLE                      0xAA
#define OBJ_PRANK_FIRE                 0xAB
#define OBJ_PRANK_ICE                  0xAC
#define OBJ_PRANK_BOMB                 0xAD
#define OBJ_PRANK_PAN                  0xAE
#define OBJ_BANANA_PEEL                0xAF
#define OBJ_BOXY_BOX                   0xB0
#define OBJ_SHOOTING_ENEMY_STAR        0xB1
#define OBJ_BOMBAR_BOMB                0xB2
#define OBJ_BOMBAR_MISSILE             0xB3
#define OBJ_BOX_BOXER_ENERGY_BALL      0xB4
#define OBJ_WIZ_FOOTBALL               0xB5
#define OBJ_WIZ_CAR                    0xB6
#define OBJ_WIZ_BALLOON                0xB7
#define OBJ_WIZ_BOMB                   0xB8
#define OBJ_WIZ_CLOUD                  0xB9
#define OBJ_WIZ_APPLE                  0xBA
#define OBJ_WIZ_DROPPY                 0xBB
#define OBJ_TITAN_ARM_1                0xBC
#define OBJ_TITAN_ARM_2                0xBD
#define OBJ_TITAN_ARM_3                0xBE
#define OBJ_TITAN_ARM_4                0xBF
#define OBJ_TITAN_HEAD_MISSILE         0xC0
#define OBJ_MOLEY_ROCK                 0xC1
#define OBJ_MOLEY_SCREW                0xC2
#define OBJ_MOLEY_TIRE                 0xC3
#define OBJ_MOLEY_BOMB                 0xC4
#define OBJ_MOLEY_BIG_ROCK             0xC5
#define OBJ_MOLEY_BARREL               0xC6
#define OBJ_MOLEY_SPIKE_BALL           0xC7
#define OBJ_MASTER_HAND_BULLET         0xC8
#define OBJ_THROWN_BOMB_2              0xC9
#define OBJ_SHADOW_KIRBY_BOMB          0xCA
#define OBJ_DARK_MIND_STAR_FIRE        0xCB
#define OBJ_DARK_MIND_STAR_ICE         0xCC
#define OBJ_DARK_MIND_STAR_SPARK       0xCD
#define OBJ_DARK_MIND_STAR_MIX         0xCE
#define OBJ_UNKNOWN_CF                 0xCF
#define OBJ_UNKNOWN_D0                 0xD0
#define OBJ_DARK_MIND_LASER            0xD1
#define OBJ_DARK_MIND_LASER_SHOWER     0xD2
#define OBJ_DARK_MIND_MIRROR_CUTTER    0xD3
#define OBJ_UNKNOWN_D4                 0xD4
#define OBJ_SIR_KIBBLE_CUTTER          0xD5
#define OBJ_GLUNK_BULLET               0xD6
#define OBJ_SHOTZO_BULLET              0xD7
#define OBJ_CUPIE_ARROW                0xD8
#define OBJ_JACK_STAR                  0xD9
#define OBJ_SHOOTY_BOMB                0xDA

// TODO: how are they classified? 
#define ObjType0To32(obj) ((obj)->type == OBJ_WADDLE_DEE_1 || (obj)->type == OBJ_BRONTO_BURT || (obj)->type == OBJ_BLIPPER \
                           || (obj)->type == OBJ_GLUNK || (obj)->type == OBJ_SQUISHY || (obj)->type == OBJ_SCARFY \
                           || (obj)->type == OBJ_GORDO || (obj)->type == OBJ_SNOOTER_1 || (obj)->type == OBJ_CHIP \
                           || (obj)->type == OBJ_SOARAR || (obj)->type == OBJ_HALEY || (obj)->type == OBJ_ROLYPOLY \
                           || (obj)->type == OBJ_CUPIE || (obj)->type == OBJ_BLOCKIN || (obj)->type == OBJ_SNOOTER_2 \
                           || (obj)->type == OBJ_LEAP || (obj)->type == OBJ_JACK || (obj)->type == OBJ_BIG_WADDLE_DEE \
                           || (obj)->type == OBJ_WADDLE_DOO || (obj)->type == OBJ_FLAMER || (obj)->type == OBJ_HOT_HEAD \
                           || (obj)->type == OBJ_LASER_BALL || (obj)->type == OBJ_PENGY || (obj)->type == OBJ_ROCKY \
                           || (obj)->type == OBJ_SIR_KIBBLE || (obj)->type == OBJ_SPARKY || (obj)->type == OBJ_SWORD_KNIGHT \
                           || (obj)->type == OBJ_UFO || (obj)->type == OBJ_TWISTER || (obj)->type == OBJ_WHEELIE \
                           || (obj)->type == OBJ_NODDY || (obj)->type == OBJ_GOLEM_1 || (obj)->type == OBJ_GOLEM_2 \
                           || (obj)->type == OBJ_GOLEM_3 || (obj)->type == OBJ_FOLEY_1 || (obj)->type == OBJ_SHOOTY \
                           || (obj)->type == OBJ_SCARFY_FALLING || (obj)->type == OBJ_BOXIN || (obj)->type == OBJ_COOKIN \
                           || (obj)->type == OBJ_MINNY || (obj)->type == OBJ_BOMBER || (obj)->type == OBJ_HEAVY_KNIGHT \
                           || (obj)->type == OBJ_GIANT_ROCKY || (obj)->type == OBJ_METAL_GUARDIAN || (obj)->type == OBJ_EMPTY_2C \
                           || (obj)->type == OBJ_BATTY || (obj)->type == OBJ_FOLEY_2 || (obj)->type == OBJ_BANG_BANG \
                           || (obj)->type == OBJ_DARK_MIND_BOMB || (obj)->type == OBJ_EMPTY_31 || (obj)->type == OBJ_DROPPY)

#define ObjType0To37(obj) (ObjType0To32((obj)) || (obj)->type == OBJ_PRANK || (obj)->type == OBJ_MIRRA || (obj)->type == OBJ_SHOTZO_1 \
                           || (obj)->type == OBJ_SHADOW_KIRBY || (obj)->type == OBJ_WADDLE_DEE_2)

#define ObjType38To52(obj) ((obj)->type == OBJ_MR_FROSTY || (obj)->type == OBJ_BONKERS || (obj)->type == OBJ_PHAN_PHAN \
                            || (obj)->type == OBJ_BATAFIRE || (obj)->type == OBJ_BOX_BOXER || (obj)->type == OBJ_BOXY \
                            || (obj)->type == OBJ_MASTER_HAND || (obj)->type == OBJ_BOMBAR || (obj)->type == OBJ_EMPTY_40 \
                            || (obj)->type == OBJ_EMPTY_41 || (obj)->type == OBJ_EMPTY_42 || ObjType43To52(obj))

#define ObjType43To52(obj) ((obj)->type == OBJ_EMPTY_43 \
                            || (obj)->type == OBJ_EMPTY_44 || (obj)->type == OBJ_KRACKO || (obj)->type == OBJ_KING_GOLEM \
                            || (obj)->type == OBJ_CRAZY_HAND_1 || (obj)->type == OBJ_GOBBLER || (obj)->type == OBJ_WIZ \
                            || (obj)->type == OBJ_MOLEY || (obj)->type == OBJ_MEGA_TITAN || (obj)->type == OBJ_TITAN_HEAD \
                            || (obj)->type == OBJ_CRAZY_HAND_2 || (obj)->type == OBJ_DARK_META_KNIGHT || (obj)->type == OBJ_DARK_MIND_FORM_1 \
                            || (obj)->type == OBJ_DARK_MIND_FORM_2 || (obj)->type == OBJ_DARK_MIND_FORM_3_TRIGGER \
                            || (obj)->type == OBJ_DARK_META_KNIGHT_W8)

#define ObjType53To5C(obj) ((obj)->type == OBJ_EMPTY_53 || (obj)->type == OBJ_EMPTY_54 || (obj)->type == OBJ_EMPTY_55 \
                            || (obj)->type == OBJ_EMPTY_56 || (obj)->type == OBJ_EMPTY_57 || (obj)->type == OBJ_EMPTY_58 \
                            || (obj)->type == OBJ_EMPTY_59 || (obj)->type == OBJ_EMPTY_5A || (obj)->type == OBJ_EMPTY_5B \
                            || (obj)->type == OBJ_EMPTY_5C)

#define ObjType53To64(obj) (ObjType53To5C(obj) || (obj)->type == OBJ_EMPTY_5D || (obj)->type == OBJ_SMALL_FOOD \
                            || (obj)->type == OBJ_POP_SODA || (obj)->type == OBJ_MEAT || (obj)->type == OBJ_TOMATO \
                            || (obj)->type == OBJ_BATTERY || (obj)->type == OBJ_1UP || (obj)->type == OBJ_INVINCIBLE_CANDY)

#define ObjType5ETo6C(obj) ((obj)->type == OBJ_SMALL_FOOD || (obj)->type == OBJ_POP_SODA || (obj)->type == OBJ_MEAT \
                            || (obj)->type == OBJ_TOMATO || (obj)->type == OBJ_BATTERY || (obj)->type == OBJ_1UP \
                            || (obj)->type == OBJ_INVINCIBLE_CANDY || (obj)->type == OBJ_MIRROR_SHARD || (obj)->type == OBJ_EMPTY_66 \
                            || (obj)->type == OBJ_EMPTY_67 || (obj)->type == OBJ_EMPTY_68 || (obj)->type == OBJ_GOAL_GAME_BONUS \
                            || (obj)->type == OBJ_EMPTY_6A || (obj)->type == OBJ_EMPTY_6B || (obj)->type == OBJ_EMPTY_6C)

#define ObjType6Dto99(obj) ((obj)->type == OBJ_SMALL_BUTTON || (obj)->type == OBJ_FLAME || (obj)->type == OBJ_DOOR \
                            || (obj)->type == OBJ_SHOTZO_2 || (obj)->type == OBJ_VERTICAL_SLIDING_DOOR || (obj)->type == OBJ_BOSS_CHALLENGE_DOOR \
                            || (obj)->type == OBJ_OBJECT_SPAWNER || (obj)->type == OBJ_DESTROYABLE_ROCK_BLOCK || (obj)->type == OBJ_UNKNOWN_75 \
                            || (obj)->type == OBJ_LAVA_WALL || (obj)->type == OBJ_SCROLL_LOCK || (obj)->type == OBJ_CANNON_FUSE \
                            || (obj)->type == OBJ_STAR_STONE_BLOCK || (obj)->type == OBJ_UNKNOWN_7A || (obj)->type == OBJ_STAR_PLATFORM \
                            || (obj)->type == OBJ_FLAME_COLUMN || (obj)->type == OBJ_LARGE_STAR_STONE_BLOCK_7D || (obj)->type == OBJ_LARGE_STAR_STONE_BLOCK_7E \
                            || (obj)->type == OBJ_CPU_KIRBY_TRIGGER || (obj)->type == OBJ_SMALL_CHEST || (obj)->type == OBJ_BIG_CHEST \
                            || (obj)->type == OBJ_UNKNOWN_82 || (obj)->type == OBJ_UNKNOWN_83 || (obj)->type == OBJ_WARP_STAR \
                            || (obj)->type == OBJ_GOAL_STAR || (obj)->type == OBJ_BIG_BUTTON || (obj)->type == OBJ_UNKNOWN_87 \
                            || (obj)->type == OBJ_LARGE_STAR_STONE_BLOCK_88 || (obj)->type == OBJ_LARGE_STAR_STONE_BLOCK_89 || (obj)->type == OBJ_CANNON \
                            || (obj)->type == OBJ_8_DIR_CANNON || (obj)->type == OBJ_HUB_MIRROR || (obj)->type == OBJ_HAMMER_PEG \
                            || (obj)->type == OBJ_CUTSCENE_TRIGGER || (obj)->type == OBJ_MASTER_SWORD_UNOBTAINABLE || (obj)->type == OBJ_WIND_EFFECT \
                            || (obj)->type == OBJ_TRIGGERABLE_WALL || (obj)->type == OBJ_ABILITY_STATUE_1 || (obj)->type == OBJ_ABILITY_STATUE_2 \
                            || (obj)->type == OBJ_ABILITY_STATUE_3 || (obj)->type == OBJ_ABILITY_STATUE_4 || (obj)->type == OBJ_ABILITY_STATUE_RANDOM \
                            || (obj)->type == OBJ_DOOR_TO_HUB || (obj)->type == OBJ_MASTER_SWORD_STAND || (obj)->type == OBJ_AREA_DOOR)

#define ObjType6Dto9A(obj) (ObjType6Dto99(obj) || (obj)->type == OBJ_EMPTY_9A)

#define ObjIsTitanArm(obj) ((obj)->type == OBJ_TITAN_ARM_1 || (obj)->type == OBJ_TITAN_ARM_2 || (obj)->type == OBJ_TITAN_ARM_3 || (obj)->type == OBJ_TITAN_ARM_4)

#define ObjTypeAltIdx(obj) ((obj)->type - OBJ_MR_FROSTY)

#endif // GUARD_CONSTANTS_OBJECT_TYPES_H
