class User < ActiveRecord::Base
  rolify
  # Include default devise modules.
  devise :database_authenticatable, :registerable,
          :recoverable, :rememberable, :trackable, :validatable,
          :confirmable, :omniauthable
  include DeviseTokenAuth::Concerns::User
  
  devise :omniauthable
  
  validates_uniqueness_of :email
  
  has_one :user_setting
  has_many :user_organizations
  has_many :organizations, through: :user_organizations
  
  before_create :set_up_user
  after_create :add_user_defaults
  
  def personal_org
    self.organizations.where(:name => 'Personal').first
  end
  
  private
    def set_up_user
      #devise stuff
      skip_confirmation!
    end
    
    def add_user_defaults
      create_personal_org
      add_domain_org
      create_settings
    end
    
    def create_settings
      UserSetting.create!(:user => self)
    end
    
    def create_personal_org
      org = Organization.create!(:name => 'Personal')
      self.organizations << org
      
      self.add_role :write, org
    end
    
    def add_domain_org
      domain = self.email.split('@')
      org = Organization.find_by(:domain => domain)
      if org
        self.organizations << org
        
        self.add_role :read, org
      end
    end
end
