# OpenAI ChatGPT Chrome Extension

This extension uses the magic of OpenAI's chat and image models to ensure a seamless ChatGPT-Like experience - all without ever having to leave your favorite website. Start a A.I. powered conversation or generate stunning images with just a few clicks.


## 📸 Screenshots
<div style="display: flex; gap: 20px; justify-content: start; align-items: start;">
    <img src='assets/preview-1.png' width='400' alt='Chat Completion Preview' />
    <img src='assets/preview-2.png' width='400' alt='Image Generation Preview' />
</div>

## ✨ Features

 - 💨 Easy access to OpenAI's chat and images models without leaving your favorite website.
 - 💬 Chat with the latest GPT models.
 - 🌄 Generate stunning images with DALL-E 3.
 - 🎛️ Seamlessly switch between different models.
 - 💾 Copy or download the generated content with just a click.
 - 🛟 API-Key is safely stored in the browser's local storage and never leaves your device.

## 🚀 Getting started
    
1. Clone the extension or download the latest release.
2. Open the Chrome browser and navigate to [chrome://extensions](chrome://extensions).
3. Enable the developer mode by clicking the toggle switch in the top right corner of the page.
4. Click on the "Load unpacked" button and select the cloned extension folder.
5. The options page automatically opens where you need to enter your OpenAI API-Key.
    
The extension should now be installed and ready to use. Open the extension by clicking on the chrome-themed OpenAI icon in the top right corner of your browser.

## 🚨 Note

For the extension to work, you need to have an OpenAI API-Key. You can get one by signing up on the [OpenAI website](https://openai.com/). Once you have an API-Key, you will need to enter it in the options page of the extension.
