import '@stoplight/elements/styles.min.css';
import {
  Preflight,
  ThemeProvider,
  defaultTheme,
  x,
} from '@xstyled/styled-components';
import dynamic from 'next/dynamic';
import Head from 'next/head';

const APIDocumentUI = dynamic<{
  apiDescriptionUrl: string;
  layout?: 'sidebar' | 'stacked';
  router?: 'history' | 'memory' | 'hash' | 'static';
}>(
  import('@stoplight/elements').then(({ API }) => API),
  {
    ssr: false,
    loading: () => <p>Loading...</p>,
  }
);

const theme = {
  ...defaultTheme,
};

export default function Playground() {
  return (
    <ThemeProvider theme={theme}>
      <x.div h="100vh" mx="auto">
        <Preflight />
        <Head>
          <title>Next Swagger Doc Demo App</title>
          <meta name="description" content="Generated by create next app" />
          <link rel="icon" href="/favicon.ico" />
        </Head>
        <APIDocumentUI
          apiDescriptionUrl="/swagger.json"
          layout="sidebar"
          router="hash"
        />
      </x.div>
    </ThemeProvider>
  );
}
