---
id: b1r1n
title: Testing Overview
file_version: 1.1.2
app_version: 1.6.3
---

## Testing frameworks

We use [Vitest](https://vitest.dev/) for unit tests, and [Playwright](https://playwright.dev/) for our end-to-end tests.

## Running tests locally

### Configure automation user and password

To run the tests, you first need to configure the user and password.

### Run the tests

You can then use the following commands to run tests:

`yarn test`

## Writing tests

### Assertions

Use snapshot testing for make sure the output is the same.

<br/>

<!-- NOTE-swimm-snippet: the lines below link your snippet to Swimm -->

### 📄 test/index.test.ts

```typescript
7          expect(
8            createSwaggerSpec({
9              definition: {
10               openapi: '3.0.0',
11               info: {
12                 title: 'NextJS Swagger',
13                 version: '0.1.0',
14               },
15             },
16           }),
17         ).toMatchSnapshot();
```

<br/>

### Best Practices

When writing tests, we follow a few guidelines.

A group of tests is called a "suite". We now have several test suites, each one aims to test a certain set of features in the app. For example, {{path for a test file}} tests the {{feature's name}} feature.

Test by file

<br/>

<!-- NOTE-swimm-snippet: the lines below link your snippet to Swimm -->

### 📄 test/index.test.ts

```typescript
5      describe('withSwagger', () => {
```

<br/>

Then we have all related use cases to the same group

<!-- NOTE-swimm-snippet: the lines below link your snippet to Swimm -->

### 📄 test/index.test.ts

```typescript
6        it('should create default swagger json option', () => {
7          expect(
8            createSwaggerSpec({
9              definition: {
10               openapi: '3.0.0',
11               info: {
12                 title: 'NextJS Swagger',
13                 version: '0.1.0',
14               },
15             },
16           }),
17         ).toMatchSnapshot();
18       });
19
20       it('should have Bearer Authentication', () => {
21         expect(
22           createSwaggerSpec({
23             definition: {
24               openapi: '3.0.0',
25               info: {
26                 title: 'NextJS Swagger',
27                 version: '0.1.0',
28               },
29               components: {
30                 securitySchemes: {
31                   bearerAuth: {
32                     type: 'http',
33                     scheme: 'bearer',
34                     bearerFormat: 'JWT',
35                   },
36                 },
37               },
38               security: [
39                 {
40                   bearerAuth: [],
41                 },
42               ],
43             },
44             apiFolder: 'pages/api',
45           }),
46         ).toMatchSnapshot();
47       });
48
49       it('should have support OAuth2 Authentication', () => {
50         expect(
51           createSwaggerSpec({
52             definition: {
53               openapi: '3.0.0',
54               info: {
55                 title: 'NextJS Swagger',
56                 version: '0.1.0',
57               },
58               components: {
59                 securitySchemes: {
60                   OAuth2: {
61                     type: 'oauth2',
62                     description: 'OAuth2 authentication with a bearer token.',
63                     flows: {
64                       implicit: {
65                         authorizationUrl: 'https://example.com/authorize',
66                         scopes: {
67                           'read:pets': 'read your pets',
68                           'write:pets': 'modify pets in your account',
69                         },
70                       },
71                       password: {
72                         tokenUrl: 'https://example.com/token',
73                         scopes: {
74                           'read:pets': 'read your pets',
75                           'write:pets': 'modify pets in your account',
76                         },
77                       },
78                     },
79                   },
80                 },
81               },
82               security: [
83                 {
84                   OAuth2: ['read', 'write'],
85                 },
86               ],
87             },
88             apiFolder: 'pages/api',
89           }),
90         ).toMatchSnapshot();
91       });
```

<br/>

This file was generated by Swimm. [Click here to view it in the app](https://app.swimm.io/repos/Z2l0aHViJTNBJTNBbmV4dC1zd2FnZ2VyLWRvYyUzQSUzQWplbGx5ZG4=/docs/b1r1n).
