---
Order: 2
Area: runtimes
TOCTitle: ASP.NET Core
ContentId: AFFD7BDB-925E-4D02-828D-4E14360C70DA
PageTitle: ASP.NET Core and Visual Studio Code End to End
DateApproved: 4/14/2016
MetaDescription: Visual Studio Code has great support for writing and debugging ASP.NET applications running on Cross Platform CLR.
MetaTags:
- DNX
- ASP.NET Core
---

# ASP.NET Core with VS Code

>**Note:** ASP.NET Core and DNX (the .NET Execution Environment) on OS X and Linux are in an early Beta/Preview state. We recommend following the [ASP.NET Home project](https://github.com/aspnet/Home) on GitHub for the latest information.

## ASP.NET Core and DNX

[ASP.NET Core/DNX](http://www.asp.net/vnext/overview/aspnet-vnext/aspnet-5-overview) is a lean .NET stack for building modern cloud and web apps that run on OS X, Linux, and Windows. It has been built from the ground up to provide an optimized development framework for apps that are either deployed to the cloud or run on-premises. It consists of modular components with minimal overhead, so you retain flexibility while constructing your solutions.

## Installing ASP.NET Core and DNX

Installation for each platform (Windows, OS X and Linux) is slightly different and covered in detail at [ASP.NET Getting Started](https://docs.asp.net/en/latest/getting-started/index.html).

## Getting Started

If you don't have an existing ASP.NET DNX application, here's a nice tutorial to [Create an ASP.NET web app in VS Code](https://azure.microsoft.com/en-us/documentation/articles/web-sites-create-web-app-using-vscode).  It will walk you through installing prerequisites and scaffolding out a web application.

## Next Steps

We hope this gets you started building ASP.NET Core applications.  Try these things next:

* [Editing Evolved](/docs/editor/editingevolved.md) - Lint, IntelliSense, Lightbulbs, Peek and Go to Definition and more
* [Working with C#](/docs/languages/csharp.md) - Learn about the great C# support you'll have when working on your ASP.NET application.
* [Tasks](/docs/editor/tasks.md) - Running tasks with Gulp, Grunt and Jake.  Showing Errors and Warnings
