# 安装Visual Studio Code

安装与使用VS Code非常简单和快捷。各平台请按照如下指导安装即可。

VS Code轻量且可以运行在大多数可用硬件和平台版本。您可以重新查看[系统要求](https://code.visualstudio.com/docs/supporting/requirements)以检查您的机器配置是否支持VS Code。

> Note：VS Code是一款占用空间不大的编辑器。不同于传统IDEs几乎包含了所有组件，您可以为了您所关心的开发技术而调整您的安装。确保在平台指导后阅读[附加组件](https://github.com/heshenghuan/CN-VScode-Docs/blob/hsh/md/%E7%BC%96%E8%BE%91%E5%99%A8/%E5%AE%89%E8%A3%85.md#附加组件)部分学习如何客制化您的VS Code安装。

## Mac OS X

1. 下载适用于Mac OS X的[Visual Studio Code](https://go.microsoft.com/fwlink/?LinkID=534106)。
2. 双击下载的存档展开内容。
3. 拖动`Visual Studio Code.app`至`Applications`文件夹，在`Launchpad`中点击打开。
4. 右键点击Dock栏中的VS Code图标，依次选择`选项`、`在Dock中保留`。

>Tip：如果您希望能够在终端中输入‘code’就能运行VS Code，VS Code有一条命令，**Shell Command: Install 'code' command in PATH**可以将‘code’添加至您的`$PATH`中。
>
>安装完成之后，运行VS Code。现在，打开命令面板（按F1键）输入`Shell 命令`找到`Shell 命令: 在PATH中安装“code”命令`。
>
>![Shell 命令：在PATH中安装“code”命令](../../images/md_editor_setup_01.png)
>
>命令执行完成之后，重启终端工具使新的`$PATH`可用。现在，您可以简单地在终端中任意文件夹下输入‘code .’来编辑该文件夹下的文件了。

## Linux

1. 下载适用于您发行版的Visual Studio Code，基于Debian的发行版如Ubuntu请点击[.deb](http://go.microsoft.com/fwlink/?LinkID=760868),基于Red Hat(rpm包管理格式，包括OpenSuSE)的发行版如Fedora或CentOS请点击[.rpm](http://go.microsoft.com/fwlink/?LinkID=760867)。注意，32-bit 二进制安装文件在[下载页面](https://code.visualstudio.com/Download)同样可用。

2. 通过任一GUI软件包管理系统安装只需双击包文件即可，或者也可以使用命令行安装:

   ```shell
   # For .deb
   sudo dpkg -i <file>.deb

   # For .rpm (Fedora 21 and below)
   sudo yum install <file>.rpm

   # For .rpm (Fedora 22 and above)
   sudo dnf install <file>.rpm
   ```

3. 现在VS Code应该可以通过launcher或在命令行中输入`code`运行了。

> Tip：在任意文件路径下输入‘code ./’来编辑该文件夹下的文件。

## Windows

1. 下载[Visual Studio Code](https://go.microsoft.com/fwlink/?LinkID=534107)。
2. 双击`VSCodeSetup.exe`开始安装，这将会花费几分钟。
3. 64-bit构架下，VS Code默认将会安装在`C:\Program Files (x86)\Microsoft VS Code`下。

> Note：VS Code要求.NET Framework 4.5已安装，如果您使用的是Windows 7系统，请确保.NET Framework 4.5已安装。
>
> Tip：安装程序会选择添加Visual Studio Code至您的`%PATH%`中，于是您在控制台中任意文件路径下输入‘code .’来编辑该文件夹下的文件。
>
> Tip：您可能需要在安装完成后注销让变化的`%PATH%`环境变量生效。

## 附加组件

VS Code的下载不大且只包含各种开发工作中共享的最小数量的组件，包括例如编辑器、文件管理、窗口管理和用户设置等基本功能。JavaScript/TypeScript语言服务和Node.js调试器也属于基本组件范畴。

如果您习惯于用更大、更整体的开发工具（IDEs），那么您可能会惊讶地发现您的情况不能完全支持开箱即用。例如，VS Code没有“**文件** > **新建工程**”这一选项及预先安装的工程模板。大多数VS Code使用者需要依据他们的特殊需求安装附加组件。

以下是几个常用的已安装组件：

- [Git](http://git-scm.com/download) - VS Code内部支持了源代码版本控制系统Git，但是需要您电脑中预先安装好了Git
- [Node\.js(includes NPM)](https://nodejs.org/) - 一个快速搭建运行JavaScript应用的平台和运行时
- [TypeScript](http://typescriptlang.org/) - TypeScript编译器`tsc`
- [Typings](https://github.com/typings/typings) - 一个TypeScript类型定义管理程序，让VS Code可以为流行的JavaScript框架提供智能感知

您将会发现上述组件经常在我们的文档和穿行测试中提及。

## VS Code扩展

[VS Code扩展](https://code.visualstudio.com/docs/editor/extension-gallery)让第三方提供额外的支持：

- 语言 - [C++](https://code.visualstudio.com/docs/languages/cpp), [C#](https://code.visualstudio.com/docs/languages/csharp), [Go](https://marketplace.visualstudio.com/items/lukehoban.Go), [Python](https://marketplace.visualstudio.com/items?itemName=donjayamanne.python)
- 工具 - [ESLint](https://marketplace.visualstudio.com/items/dbaeumer.vscode-eslint), [JSHint](https://marketplace.visualstudio.com/items/dbaeumer.jshint) , [PowerShell](https://marketplace.visualstudio.com/items?itemName=ms-vscode.PowerShell), [Visual Studio Team Services](https://marketplace.visualstudio.com/items?itemName=ms-vsts.team)
- 调试器 - [Chrome](https://marketplace.visualstudio.com/items?itemName=msjsdiag.debugger-for-chrome), [PHP XDebug](https://marketplace.visualstudio.com/items?itemName=felixfbecker.php-debug).

扩展融入了VS Code的用户界面、命令行和任务运行系统，所以您会发现通过VS Code的共享接口很容易使用不同的技术工作。点此查看[VS Code扩展市场](https://marketplace.visualstudio.com/vscode)发现新东西。

## 附加工具

Visual Studio Code整合了现有工具链。我们认为下述工具可以提升您的开发体验。

- [Yeoman](http://yeoman.io/) - 一个应用搭建工具， 想象成命令行版本的 **文件** > **新建工程**
- [generator-aspnet](https://www.npmjs.com/package/generator-aspnet) - 一个搭建**ASP.NET Core**应用的Yeoman生成器
- [hottowel](https://github.com/johnpapa/generator-hottowel) - 一个快速创建**AngularJS**应用的Yeoman生成器
- [Express](http://expressjs.com/) - 使用 **Jade** 模板引擎的Node.js应用框架
- [gulp](http://gulpjs.com/) - 基于流的自动化构建工具，可以很容易地整合进VS Code任务
- [mocha](http://mochajs.org/) - 运行于Node.js之上的JavaScript测试框架
- [bower](http://bower.io/) - 客户端软件包管理器

## 下一步

现在您已经安装调试您的VS Code了。

更多文档，请查阅：

- [The Basics](https://code.visualstudio.com/docs/editor/codebasics) - Basic orientation around VS Code
- [Editing Evolved](https://code.visualstudio.com/docs/editor/editingevolved) - Lint, IntelliSense, Lightbulbs, Peek and Goto Definition and more
- [Debugging](https://code.visualstudio.com/docs/editor/debugging) - This is where VS Code really shines

如果您想要快速开始，试试[Node.js runtime](https://code.visualstudio.com/docs/runtimes/nodejs)，可以让您使用VS Code几分钟内调试一个Node.js web应用。

## 常见问题

Q: VS Code有什么系统要求？

A: 相关要求请查看[系统要求](https://code.visualstudio.com/docs/supporting/requirements)。

Q: 如何创建并运行一个新项目？

A: VS Code并没有传统的“**文件** > **新建工程**”选项或预装工程模板，您需要依据您的开发需求添加附加组件和搭建工具。在项目搭建工具如[Yeoman](http://yeoman.io/)的帮助和NPM包管理器上众多的模块中，您肯定可以找到合适的模板和工具用来创建您的项目。