---
Order: 5
Area: extensionapi
TOCTitle: Contribution Points
ContentId: 2F27A240-8E36-4CC2-973C-9A1D8069F83F
PageTitle: Visual Studio Code Extension Contribution Points - package.json
DateApproved: 11/8/2017
MetaDescription: To extend Visual Studio Code, your extension (plug-in) declares which of the various contribution points it is using in its package.json extension manifest file.
---

# Contribution Points - package.json

This document covers the various contribution points that are defined in the [`package.json` extension manifest](./扩展manifest文件.md).

这篇文档包含了[`package.json` extension manifest](./扩展manifest文件.md)中 `contribution` 选项的所有可用字段。

* [`configuration`](/docs/extensionAPI/extension-points.md#contributesconfiguration)
* [`commands`](/docs/extensionAPI/extension-points.md#contributescommands)
* [`keybindings`](/docs/extensionAPI/extension-points.md#contributeskeybindings)
* [`languages`](/docs/extensionAPI/extension-points.md#contributeslanguages)
* [`debuggers`](/docs/extensionAPI/extension-points.md#contributesdebuggers)
* [`grammars`](/docs/extensionAPI/extension-points.md#contributesgrammars)
* [`themes`](/docs/extensionAPI/extension-points.md#contributesthemes)
* [`snippets`](/docs/extensionAPI/extension-points.md#contributessnippets)
* [`jsonValidation`](/docs/extensionAPI/extension-points.md#contributesjsonvalidation)

## `contributes.configuration`

Contribute configuration keys that will be exposed to the user. The user will be able to set these configuration options either from User Settings or from the Workspace Settings.

When contributing configuration keys, a JSON schema describing these keys is actually contributed. This ensures the user gets great tooling support when authoring VS Code settings files.

You can read these values from your extension using `vscode.workspace.getConfiguration('myExtension')`.

`contributes.configuration` 选项会被暴露给用户。用户能够在“用户设置”或“工作区设置”面板中设置这些配置选项。

在配置 `contributes.configuration` ，同时也配置了这些选项的一种JSON模式的描述。着确保了用户在设置VS Code 选项文件时能够或者更好的工具支持。

**译者注：**在配置 `contributes.configuration` 时，实际上是配置了某个选项的诸如类型/默认值／介绍等选项，这样用户在配置 setting 文件时VS Code能够根据这些配置来提示用户。

### 例子

```json
// package.json
...
"contributes": {
	"configuration": {
		"type": "object",
		"title": "TypeScript configuration",
		"properties": {
			"typescript.useCodeSnippetsOnMethodSuggest": {
				"type": "boolean",
				"default": false,
				"description": "Complete functions with their parameter signature."
			},
			"typescript.tsdk": {
				"type": ["string", "null"],
				"default": null,
				"description": "Specifies the folder path containing the tsserver and lib*.d.ts files to use."
			}
		}
	}
}
```

![configuration extension point example](images/extension-points/configuration.png)

## `contributes.configurationDefaults`

Contribute default language specific editor configurations. This will override default editor configurations for the provided language.

The following example contributes default editor configurations for the `markdown` language:

设置默认语言特定的编辑器配置。这将覆盖所提供语言的默认编辑器配置。
下面的例子配置了 `markdown` 语言的默认编辑器配置

### 例子

```json
// package.json
"contributes": {
    "configurationDefaults": {
        "[markdown]": {
            "editor.wordWrap": "on",
            "editor.quickSuggestions": false
        }
    }
}
```

## `contributes.commands`

Contribute an entry consisting of a title and a command to invoke to the Command Palette (⇧⌘P). You can also optionally define a `category` string which will prefix the command title and allow easy grouping within the Command Palette drop-down.

提供了一个由 commands 和 title 字段组成的条目，用于在 **命令面板**(⇧⌘P) 中调用。你同时耶可以选择添加一个 `category` 字符串，此字符串会用作命令的前缀，同时在命令面板展开的时候方便进行命令的分组。

>**Note:** When a command is invoked (from a key binding or from the **Command Palette**), VS Code will emit an activationEvent `onCommand:${command}`.

>**Note:** 当一个命令被调用的时候（无论是通过按键绑定还是 **命令面板**），VS Code 将触发一个 activationEvent `onCommand:${command}`。

### Example

```json
...
"contributes": {
	"commands": [{
		"command": "extension.sayHello",
		"title": "Hello World"
	}]
}
...
```

![commands extension point example](images/extension-points/commands.png)

## `contributes.menus`

Contribute a menu item for a command to the editor or Explorer. The menu item definition contains the command that should be invoked when selected and the condition under which the item should show. The latter is defined with the `when` clause which uses the key bindings [when clause contexts](https://code.visualstudio.com/docs/getstarted/keybindings#_when-clause-contexts). In addition to the mandatory `command` property, an alternative command can be defined using the `alt`-property. It will be shown and invoked when pressing Alt while hovering over a menu item. Last, a `group`-property defines sorting and grouping of menu items. The `navigation` group is special as it will always be sorted to the top/beginning of a menu.

定义了编辑器或者资源管理器中一个命令在的菜单项。菜单项定义了选择时应该调用的命令以及不同情况下命令的的显示方式。后者使用 `when` 子句，并结合 [子句上下文](https://code.visualstudio.com/docs/getstarted/keybindings#_when-clause-contexts) 通过按键绑定来定义的。 除了必要的 command 属性，我们还可以使用 `alt` 来替换。当鼠标悬浮在菜单项上时，按住 Alt 可以显示和调用。最后，`group` 属性定义了菜单项的分组与排序。 `navigation` 组比较特殊，因为它会一直排在最顶部或者最开始的位置。

Currently extension writers can contribute to:

目前拓展的开发者能够修改这些部分：

- 全局的命令面板 - `commandPalette`
- 资源管理器环境菜单 - `explorer/context`
- 编辑器环境菜单 - `editor/context`
- 编辑器的标题菜单栏 - `editor/title`
- 编辑器标题的上下文菜单 - `editor/title/context`
- 调试调用堆栈的上下文菜单 - `debug/callstack/context`
- [SCM 标题菜单](https://code.visualstudio.com/docs/extensionAPI/api-scm#_menus) - `scm/title`
- [SCM 资源组菜单](https://code.visualstudio.com/docs/extensionAPI/extension-points#_contributessnippets) - `scm/resourceGroup/context`
- [SCM 资源菜单](https://code.visualstudio.com/docs/extensionAPI/api-scm#_menus) - `scm/resource/context`
- [SCM 修改标题时的菜单](https://code.visualstudio.com/docs/extensionAPI/api-scm#_menus) - `scm/change/title`
- [View 面板标题菜单](https://code.visualstudio.com/docs/extensionAPI/extension-points#_contributesviews) - `view/title`
- [View 面板中项目的菜单](https://code.visualstudio.com/docs/extensionAPI/extension-points#_contributesviews) - `view/item/context`

>**Note:** When a command is invoked from a (context) menu, VS Code tries to infer the currently selected resource and passes that as a parameter when invoking the command. For instance, a menu item inside the Explorer is passed the URI of the selected resource and a menu item inside an editor is passed the URI of the document.

>**Note:** 当一个命令通过 （上下文）菜单调用时，VS Code 会尝试推断出当前选定的资源，并以参数的形式传递给被调用的命令

In addition to a title, commands can also define icons which VS Code will show in the editor title menu bar.

除了标题之外，命令还可以定义 VS Code在编辑器标题菜单栏中使用的的图标。

### 例子

```json
"contributes": {
    "menus": {
        "editor/title": [{
            "when": "resourceLangId == markdown",
            "command": "markdown.showPreview",
            "alt": "markdown.showPreviewToSide",
            "group": "navigation"
        }]
    }
}
```

![menus](images/extension-points/menus.png)

### Context specific visibility of Command Palette menu items - 命令面板中的命令可见性

When registering commands in package.json, they will automatically be shown in the Command Palette (⇧⌘P). To allow more control over command visibility, there is the commandPalette menu item. It allows you to define a when condition to control if a command should be visible in the Command Palette or not.

当我们在 `package.json` 中定义命令的时候，它们就会自动显示在命令面板中(`⇧⌘P`)，为了更好地控制命令的可见性，这里有一个 `commandPalette` 的菜单选项。它允许你定义一个 `when` 条件来控制命令是否应该在 **命令面板** 中显示。

The snippet below makes the 'Hello World' command only visible in the **Command Palette** when something is selected in the editor:

下面的代码片段使得 `Hello World` 命令只有当用户在编辑器中选择了某些东西的时候才会在 **命令面板** 中显示出来。

```json
"commands": [{
    "command": "extension.sayHello",
    "title": "Hello World"
}],
"menus": {
    "commandPalette": [{
        "command": "extension.sayHello",
        "when": "editorHasSelection"
    }]
}
```

### Sorting of groups - 组排序

Menu items can be sorted into groups. They are sorted in lexicographical order with the following defaults/rules.

菜单项可以被分成组。它们按照以下默认值/规则按字典顺序排序。

The context menu of the editor has these default:

编辑器的上下文菜单具有以下默认值：

- navigation - `navigation` 组无论何时都会被排在第一位。
- 1_modification - 接下来的这个组包含来修改你代码的一些命令
- 9_cutcopypaste - 最后这个组包含了最基本的编辑命令

![groupSorting](images/extension-points/groupSorting.png)

You can add menu items to these groups or add new groups of menu items in between, below, or above. Only the editor context menu allows this grouping control.

您可以将菜单项添加到这些组中，或者在这些组中间、下面或者上面添加新的菜单项组。只有编辑器上下文菜单允许这个分组控制。

### Sorting inside groups - 组内排序

组内的顺序取决于标题或顺序属性。菜单项的组内顺序通过将 `@<number>` 附加到组标识符指定，如下所示：

```json
"editor/title": [{
    "when": "editorHasSelection",
    "command": "extension.Command",
    "group": "myGroup@1"
}]
```

## `contributes.keybindings`

Contribute a key binding rule defining what command should be invoked when the user presses a key combination. See the [Key Bindings](/docs/customization/keybindings.md) topic where key bindings are explained in detail.

提供的按键绑定规则定义了按下组合键时应当调用的命令。请参阅 [按键绑定](/docs/customization/keybindings.md) 主题，其中详细介绍了按键绑定。

Contributing a key binding will cause the Default Keyboard Shortcuts to display your rule, and every UI representation of the command will now show the key binding you have added. And, of course, when the user presses the key combination the command will be invoked.

设置键绑定将导致默认键盘快捷键显示您的规则，并且该命令的每个UI表示现在将显示您添加的键绑定。当然，当用户按下组合键时，该命令将被调用。

>**Note:** Because VS Code runs on Windows, Mac and Linux, where modifiers differ, you can use "key" to set the default key combination and overwrite it with a specific platform.

>**Note:** 由于VS代码在Windows，Mac和Linux上运行，其中修饰符不同，因此你可以使用“key”来设置默认组合键并依照特定的平台来覆盖它。

>**Note:** When a command is invoked (from a key binding or from the Command Palette), VS Code will emit an activationEvent `onCommand:${command}`.

>**Note:** 当一个命令被调用的时候（无论是通过按键绑定还是 **命令面板**），VS Code 将触发一个 activationEvent `onCommand:${command}`。

### 例子

```json

Defining that `kbstyle(Ctrl+F1)` under Windows and Linux and `kbstyle(Cmd+F1)` under Mac trigger the `"extension.sayHello"` command:

定义了 Windows 和 Linux 下的 `kbstyle(Ctrl+F1)` 和 Mac 下的 `kbstyle(Cmd+F1)` 会触发 `"extension.sayHello"` 命令。

```json
"contributes": {
    "keybindings": [{
        "command": "extension.sayHello",
        "key": "ctrl+f1",
        "mac": "cmd+f1",
        "when": "editorTextFocus"
    }]
}
```

![keybindings extension point example](images/extension-points/keybindings.png)

## `contributes.languages`

Contribute the definition of a language. This will introduce a new language or enrich the knowledge VS Code has about a language.

提供一种语言的定义。这会引入一门新的语言或者提升VS Code关于一门语言的认知。

In this context, a language is basically a string identifier that is associated to a file (See `TextDocument.getLanguageId()`).

在这种情况下，语言基本上是与文件关联的字符串标识符（参阅 `TextDocument.getLanguageId()`）。

VS Code uses three hints to determine the language a file will be associated with. Each "hint" can be enriched independently:

VS代码使用三个提示来确定文件将与之关联的语言。每个 “提示” 都可以独立显示：

1. the extension of the filename (`extensions` below)
2. the filename (`filenames` below)
3. the first line inside the file (`firstLine` below)

1. 文件名的扩展名（下面的提到的 `extensions`）
2. 文件名（下面的提到的 `filename`）
3. 文件中的第一行（下面的提到的 `firstLine`）

When a file is opened by the user, these three rules are applied and a language is determined. VS Code will then emit an activationEvent `onLanguage:${language}` (e.g. `onLanguage:python` for the example below)

当一个文件被用户打开的时候，这三种规则将被应用同时将确定出一种语言。此时VS Code 将会触发一个 activationEvent `onLanguage:${language}` (例如下面提到的例子 `onLanguage:python`)

The aliases property contains human readable names under which the language is known. The first item in this list will be picked as the language label (as rendered in the status bar on the right).

### Example

The `aliases` property contains human readable names under which the language is known. The first item in this list will be picked as the language label (as rendered in the status bar on the right).

`alias` 属性包含了可识别语言的人类可读名称。该列表中的第一个项目将被选为语言标签（在右侧的状态栏中显示）。

The `configuration` property specifies a path to the language configuration file. The path is relative to the extension folder, and is typically `./language-configuration.json`. The file uses the JSON format and can contain the following properties:

`configuration` 属性指定了语言配置文件的路径。路径相对于扩展文件夹，通常是 `./language-configuration.json`。该文件使用JSON格式，可以包含以下属性：

* `comments` - 定义了表示注释的符号
  * `blockComment` - 用于标记块注释的开始和结束标记。由“切换块注释”命令使用。
  * `lineComment` - 用于标记行注释的开始标记。由“添加行注释”命令使用。
* `brackets` - 定义影响括号内代码缩进的括号符号。输入新行时，由编辑器用于确定或更正新的缩进级别。
* `autoClosingPairs` - 定义自动关闭功能的打开和关闭符号。当输入一个打开的符号时，编辑器会自动插入关闭符号。自动关闭对可选地使用 `notIn`参数来禁用字符串或注释中的对。
* `surroundingPairs` - 定义了选定字符串的打开和关闭符号。
* `folding` - 定义何时以及如何在编辑器中折叠代码。
  * `offSide` - 尾随代码段的空行属于下一个折叠部分（用于基于缩进的语言，如Python或F）
  * `markers` - 用于识别代码中自定义折叠区域的标记的正则表达式

If your language configuration file name is or ends with `language-configuration.json`, you will get validation and editing support in VS Code.

如果您的语言配置文件名是或以 `language-configuration.json` 结尾，您将在VS Code中得到验证和编辑支持。

### 例子

```json
...
"contributes": {
    "languages": [{
        "id": "python",
        "extensions": [ ".py" ],
        "aliases": [ "Python", "py" ],
        "filenames": [ ... ],
        "firstLine": "^#!/.*\\bpython[0-9.-]*\\b",
        "configuration": "./language-configuration.json"
    }]
}
```

language-configuration.json

```json
{
    "comments": {
        "lineComment": "//",
        "blockComment": [ "/*", "*/" ]
    },
    "brackets": [
        ["{", "}"],
        ["[", "]"],
        ["(", ")"]
    ],
    "autoClosingPairs": [
        ["{", "}"],
        ["[", "]"],
        ["(", ")"],
        { "open": "'", "close": "'", "notIn": ["string", "comment"] },
        { "open": "/**", "close": " */", "notIn": ["string"] }
    ],
    "surroundingPairs": [
        ["{", "}"],
        ["[", "]"],
        ["(", ")"],
        ["<", ">"],
        ["'", "'"]
    ],
    "folding": {
        "offSide": true,
        "markers": {
            "start": "^\\s*//#region",
            "end": "^\\s*//#endregion"
        }
    }
}
```

## contributes.debuggers

Contribute a debugger to VS Code. A debugger contribution has the following properties:

为 VS Code 设置一个调试器。 调试器可以具有以下属性。

* `type` 是用于在启动配置中标识此调试器的唯一ID。
* `label` 标签是用户界面中此调试器的用户可见名称。
* `program` 指的是实现了VS Code debug协议的调试器文件。
* `runtime` 如果调试适配器的路径不是可执行文件，但需要运行时。
* `configurationAttributes` 是特定于此调试器的启动配置参数的模式。
* `initialConfigurations` 列出了用于填充初始 `launch.json` 的启动配置。
* `configurationSnippets` 列出了在编辑 `launch.json` 时通过IntelliSense提供的启动配置。
* `variables` 引入了替换变量并将它们绑定到由调试器扩展实现的命令。
* `languages` 那些调试扩展可能被认为是“默认调试器”的语言。
* `adapterExecutableCommand` 命令可以动态计算调试适配器可执行文件路径和参数的命令ID。该命令返回具有以下格式的结构：

  ```json
  command: "<executable>",
  args: [ "<argument1>", "<argument2>", ... ]
  ```
The attribute `command` must be a either an absolute path to an executable or a name of executable looked up via the PATH environment variable. The special value `node` will be mapped to VS Code's built-in node runtime without being looked up on the PATH.

属性 `command` 必须设置为可执行文件的绝对路径或通过PATH环境变量查找的可执行文件的名称。
特殊值 `node` 将被映射到VS Code的内置节点运行时间，而不在PATH上查找。

### Example

```json
"contributes": {
    "debuggers": [{
        "type": "node",
        "label": "Node Debug",

        "program": "./out/node/nodeDebug.js",
        "runtime": "node",

        "languages": ["javascript", "typescript", "javascriptreact", "typescriptreact"],

        "configurationAttributes": {
            "launch": {
                "required": [ "program" ],
                "properties": {
                    "program": {
                        "type": "string",
                        "description": "The program to debug."
                    }
                }
            }
        },

        "initialConfigurations": [{
            "type": "node",
            "request": "launch",
            "name": "Launch Program",
            "program": "${workspaceFolder}/app.js"
        }],

        "configurationSnippets": [
            {
                "label": "Node.js: Attach Configuration",
                "description": "A new configuration for attaching to a running node program.",
                "body": {
                    "type": "node",
                    "request": "attach",
                    "name": "${2:Attach to Port}",
                    "port": 9229
                }
            }
        ],

        "variables": {
            "PickProcess": "extension.node-debug.pickNodeProcess"
        }
    }]
}
```

For a full walkthrough on how to integrate a `debugger`, go to [Debuggers](/docs/extensions/example-debuggers.md).

有关如何集成 `debugger` 的完整演示，请转至 [调试器](/docs/extensions/example-debuggers.md).

## contributes.breakpoints

Usually a debugger extension will also have a `contributes.breakpoints` entry where the extension lists the language file types for which setting breakpoints will be enabled.

通常情况下，调试器扩展也会有一个 `contributions.breakpoints` 条目，其中扩展名列出了将启用设置断点的语言文件类型。

```json
"contributes": {
    "breakpoints": [
        {
            "language": "javascript"
        },
        {
            "language": "javascriptreact"
        }
    ]
}
```

## contributes.grammars

Contribute a TextMate grammar to a language. You must provide the `language` this grammar applies to, the TextMate `scopeName` for the grammar and the file path.

设置一种语言的 TextMate 语法。您必须提供此语法适用的 `language` 字段，语法和文件路径的TextMate scopeName。

>**Note:** The file containing the grammar can be in JSON (filenames ending in .json) or in XML plist format (all other files).

>**注意:** 包含语法的文件可以是JSON（以.json结尾的文件名）或XML plist格式（所有其他文件）。


### 例子

```json
"contributes": {
    "grammars": [{
        "language": "shellscript",
        "scopeName": "source.shell",
        "path": "./syntaxes/Shell-Unix-Bash.tmLanguage"
    }]
}                        
```

See [Adding Language Colorization](/docs/extensions/themes-snippets-colorizers.md) for instructions on using the [yo code extension generator](/docs/extensions/yocode.md) to quickly package TextMate .tmLanguage files as VS Code extensions.

有关使用 [yo code extension generator](/docs/extensions/yocode.md) 将 TextMate .tmLanguage 文件快速打包为VS代码扩展的说明，请参阅 [Adding Language Colorization](/docs/extensions/themes-snippets-colorizers.md)。

![grammars extension point example](images/extension-points/grammars.png)

## contributes.themes

Contribute a TextMate theme to VS Code. You must specify a label, whether the theme is a dark theme or a light theme (such that the rest of VS Code changes to match your theme) and the path to the file (XML plist format).

为 VS Code 提供一个 TextMate 主题。你必须指定一个标签，无论主题是黑暗的主题还是轻的主题（使VS码的其余部分更改为与主题相匹配）以及文件路径（XML plist格式）

### 例子

```json
"contributes": {
    "themes": [{
        "label": "Monokai",
        "uiTheme": "vs-dark",
        "path": "./themes/Monokai.tmTheme"
    }]
}
```

![themes extension point example](images/extension-points/themes.png)

See [Changing the Color Theme](/docs/extensions/themes-snippets-colorizers.md) for instructions on using the [yo code extension generator](/docs/extensions/yocode.md) to quickly package TextMate .tmTheme files as VS Code extensions.

有关使用 [yo code extension generator](/docs/extensions/yocode.md) 将 TextMate .tmLanguage 文件快速打包为VS代码扩展的说明，请参阅 [Changing the Color Theme](/docs/extensions/themes-snippets-colorizers.md)。


## contributes.snippets

Contribute snippets for a specific language. The `language` attribute is the [language identifier](/docs/languages/identifiers.md) and the `path` is the relative path to the snippet file, which defines snippets in the [VS Code snippet format](/docs/editor/userdefinedsnippets.md#snippet-syntax).

为某一个具体的语言提供代码片段。其中， `language` 属性是 [语言标识符](/docs/languages/identifiers.md), `path` 属性是代码片段文件的相对路径。 代码文件会在 [VS Code snippet format](/docs/editor/userdefinedsnippets.md#snippet-syntax) 中定义。

下面的例子显示为Go语言添加片段。

```json
"contributes": {
    "snippets": [{
        "language": "go",
        "path": "./snippets/go.json"
    }]
}
```

## contributes.jsonValidation

Contribute a validation schema for a specific type of `json` file.  The `url` value can be either a local path to a schema file included in the extension or a remote server URL such as a [json schema store](http://schemastore.org/json).

为特定类型的json文件贡献一个验证模式。
url值可以是包含在扩展中的模式文件的本地路径，也可以是远程服务器URL（如json模式存储）。

```json
"contributes": {
    "jsonValidation": [{
        "fileMatch": ".jshintrc",
        "url": "http://json.schemastore.org/jshintrc"
    }]
}
```

## contributes.views

Contribute a view to VS Code. You must specify an identifier and name for the view. You can contribute to following locations:

给 VS Code 配置一个 view。 你必须为此 view 指定标示符与名称。你可以将view设置到以下位置

* `explorer`: 侧边栏中的资源管理器
* `debug`: 侧边栏中的debug菜单

When the user opens the view, VS Code will then emit an activationEvent `onView:${viewId}` (e.g. `onView:nodeDependencies` for the example below). You can also control the visibility of the view by providing the `when` context value.

当一个用户打开 view 的时候， VS Code 将触发一个 activationEvent `onView:${viewId}` (比如下面的例子触发了 `onView:nodeDependencies`)。 您可以通过 `when` 字段根据环境来设置 view 是否显示。

```json
"contributes": {
    "views": {
        "explorer": [
            {
                "id": "nodeDependencies",
                "name": "Node Dependencies",
                "when": "workspaceHasPackageJSON"
            }
        ]
    }
}
```

![views extension point example](images/extension-points/views.png)

Extension writers should register a [provider](/docs/extensionAPI/vscode-api.md#TreeDataProvider) programmatically to populate data in the view. Refer to examples [here](https://github.com/Microsoft/vscode-extension-samples/tree/master/tree-view-sample).

拓展编写者需要注册一个 [provider](/docs/extensionAPI/vscode-api.md#TreeDataProvider) 程序来把数据填充到 view 中。 参考此例 [here](https://github.com/Microsoft/vscode-extension-samples/tree/master/tree-view-sample)。

## contributes.problemMatchers

Contribute problem matcher patterns. These contributions work in both the output panel runner and in the terminal runner. Below is an example to contribute a problem matcher for the gcc compiler in an extension:

设置一个问题匹配器。这些设置在输出面板运行者和终端运行者中都可以工作。下面是一个在扩展中为gcc编译器提供一个问题匹配器的例子：

```json
"contributes": {
    "problemMatchers": [
        {
            "name": "gcc",
            "owner": "cpp",
            "fileLocation": ["relative", "${workspaceFolder}"],
            "pattern": {
                "regexp": "^(.*):(\\d+):(\\d+):\\s+(warning|error):\\s+(.*)$",
                "file": 1,
                "line": 2,
                "column": 3,
                "severity": 4,
                "message": 5
            }
        }
    ]
}
```

This problem matcher can now be used in a `tasks.json` file via a name reference `$gcc`. An example looks like this:

这个问题匹配器现在可以通过类似 `$ gcc` 这样的名称引用的方式在 `tasks.json` 文件中使用。一个例子大概是：

```json
{
    "version": "0.1.0",
    "command": "gcc",
    "args": ["-Wall", "helloWorld.c", "-o", "helloWorld"],
    "problemMatcher": "$gcc"
}
```

Also see: [Defining a Problem Matcher](/docs/editor/tasks.md#defining-a-problem-matcher)

同时也可以参见: [Defining a Problem Matcher](/docs/editor/tasks.md#defining-a-problem-matcher)

## contributes.problemPatterns

Contributes named problem patterns that can be used in problem matchers (see above).

Contributes 命名的问题匹配器可以用于错误匹配参见(上文）。


## Next Steps - 下一步

To learn more about VS Code extensibility model, try these topic:

要了解更多关于VS Code 的可扩展性模型，请尝试以下主题：

* [Extension Manifest File](/docs/extensionAPI/extension-manifest.md) - VS Code package.json extension manifest file reference
* [Activation Events](/docs/extensionAPI/activation-events.md) - VS Code activation events reference
