---
Order: 8
Area: extensions
TOCTitle: Running and Debugging Extensions
ContentId: 44569A0C-7196-48E6-A5EE-FC5AAAAD32F3
PageTitle: Running and Debugging your Visual Studio Code Extension
DateApproved: 4/14/2016
MetaDescription: It is easy to debug and test your Visual Studio Code extension (plug-in).  The Yo Code extension generator scaffolds the necessary settings to run and debug your extension directly in Visual Studio Code.
---

# 扩展（以下简称：插件）运行和调试

你可以使用VS Code来开发一个插件，而且VS Code也提供了几个简化开发的工具：

* Yeoman 生成器 to 给插件提供脚手架
* 智能化，还有针对插件 API 的代码导航
* 编译 TypeScript（当用 TypeScript 实现的时候）
* 插件运行和调试
* 插件发布

## 生成一个插件

我们建议你通过基本文件脚手架化来开始。你可以使用`yo code` Yeoman 生成器来做到，而且我们在[Yo Code 文档](/docs/tools/yocode.md)中描述了细节。生成器会保证一切就绪，开发体验良好。

## 插件运行和调试

你可以按下`F5`，在调试器下轻易地运行运行。这会打开一个加载好插件的 VS Code 窗口。插件输出在调试控制台。支持在调试视图或者调试控制台设置断点，单步调试，查看变量。

![插件调试]](images/debugging-extensions/debug.png)

我们来看看幕后将要发生什么。如果你用 TypeScript 来写插件那么你的代码必须先编译成 JavaScript。

## 编译 TypeScript

生成好的插件内的TypeScript 编译像下面这样设置好

* `tsconfig.json`声明了 TypeScript 编译器的编译选项。更多请看[TypeScript wiki](https://github.com/Microsoft/TypeScript/wiki/tsconfig.json) 或者在我们的[TypeScript章节](/docs/languages/typescript.md#tsconfigjson)。
* 合适版本的TypeScript编译器包含在 node_modules 文件夹内。
* `typings/vscode-typings.d.ts`: 告诉TypeScript 编译器要包含`vscode` API 声明。
* API 声明 包含在 `node_modules/vscode`。

在运行插件之前TypeScript 编译会被触发。
这是通过`.vscode/launch.json`文件内的`preLaunchTask`属性（声明了一个在启动调试之前执行的任务） 。这个任务在`.vscode/tasks.json`内部定义。

> **说明:** TypeScript 编译器在监视模式触发，就能够在文件变动时重新编译。

## 插件启动

插件在一个带有`Extension Development Host`标题的窗口内启动。该窗口运行着 VS Code，更准确的说，是带有开发模式插件的`Extension Host`。

可以在命令行通过`extensionDevelopmentPath`选项实现同样的效果。该选项告诉 VS Code 搜寻插件的位置，比如，

>`code --extensionDevelopmentPath=_my_extension_folder`.

一旦`Extension Host`启动了，VS Code 就把调试器附加于其上，启动调试。

这是按下`F5`后发生的：

 1. `.vscode/launch.json` 告知要首次运行 `npm`命令。
 2. `.vscode/tasks.json` 通过脚本命令 `npm run compile`，声明了 `npm` 任务。
 3. `package.json` 声明`compile`脚本， 做为 `node ./node_modules/vscode/bin/compile -watch -p ./`。
 4. 这会最终调用包含在 node_modules 的TypeScript 编译器, 生成了 `out/src/extension.js` 和 `out/src/extension.js.map`。
 5. 一旦TypeScript 编译任务结束,`code --extensionDevelopmentPath=${workspaceRoot}` 进程启动。
 6. VS Code 的第二个实例在一个特殊窗口中启动，然后寻找一个`${workspaceRoot}`目录下的插件。

## 插件热加载

因为 TypeScript 编译器在监视模式下运行，所以 TypeScript 文件会在你改动时自动编译。可以在 VS Code 左侧状态栏里观察编译进程。当编译没有错误地结束时，你必须重新加载`Extension Development Host`来确保它发现了你的改变。你可以有以下选项：

* 点击调试重启，重新启动插件开发主机窗口。
* 在插件开发主机窗口内按下 `kbstyle(Ctrl+R)` (Mac: `kbstyle(Cmd+R)`)。

## 下一步

* [插件测试](/docs/extensions/testing-extensions.md) - 学习如何写插件的单元和集成测试。
* [发布工具](/docs/tools/vscecli.md) - vsce命令行工具来发布插件
* [插件清单文件](/docs/extensionAPI/extension-manifest.md) - VS Code 插件清单文件指南
* [插件API](/docs/extensionAPI/overview.md) - 了解VS Code 可扩展的 API

## 常见问题

**问: 我如何才能在我的插件使用VS Code 新版本中引入的 API?**

**答:** 如果你的插件使用VS Code 新版本中引入的 API，你就不得不在插件`package.json`文件的`engines`字段中去声明依赖。

步骤如下：

* 设置`package.json`文件内具备`engine`字段的VS Code 最小版本号。
* 保证`vscode`模块的开发依赖 >= `0.11.0`。
* 像下面这样把`postinstall`脚本加到`package.json`文件里去：

```json
"scripts": {
    "postinstall": "node ./node_modules/vscode/bin/install"
}
```

* 在插件根目录下键入`npm install`。
* `vscode`模块会下载你声明的`engine`字段中`vscode.d.ts`的合适版本。
* 返回 VS Code，瞧一瞧你选择的特定版本 API是如何智能感知，并进行交互验证的。
