---
Order: 7
Area: extensions
TOCTitle: Principles and Patterns
ContentId: 36C1E34B-2F41-4AA0-9443-015D92EF85FB
PageTitle: Visual Studio Code Extensibility Patterns and Principles
DateApproved: 4/14/2016
MetaDescription: The Visual Studio Code extensibility (plug-in) API is designed around a set of guiding patterns and principles to promote extension consistency, correctness and ease of development.
---

# 扩展（以下简称插件）编写的基本方法和原则

VS Code 的插件 API 遵循一些会贯穿到整个 API 的基本方法和原则。

## Promises

VS Code API 采用 [promises](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)来进行异步操作.在插件当中，可以返回任何类型的 promise，比如ES6, WinJS, A+ 等等。

API当中，`Thenable`类型用以依赖某个 promise 库。`Thenable` 是`then`属性的“公分母”。

大部分的promise使用都不是必要的，当 VS Code 运行一个插件时，可以像处理 _result type_ 的一个`Thenable`来处理 _result type_ 他本身。当 promise 没必要用上时，API 会通过`or`-types 给出提示。

```typescript
  provideNumber(): number | Thenable<number>
```

## CancellationToken 取消标志

不稳定的状态经常触发操作异步操作，状态有可能在异步操作结束前改变。举个例子，智能感知开始计算，但是用户继续输入使得异步操作“过期“了。

给此类行为的API都会被传递`CancellationToken`参数，我们可以通过`isCancellationRequested`来检查取消状态，或者取消时通过`onCancellationRequested`得到通知。取消标志通常是函数调用的最后一个可选参数。

## Disposalibity 释放模式

VS Code API 在其内部资源上使用 [释放模式](https://en.wikipedia.org/wiki/Dispose_pattern)。这涉及到事件监听，命令行，UI交互，还有各种语言贡献。

在实例内部，`setStatusBarMessage(value: string)`返回一个可释放类型`Disposable`，在调用`dispose`方法的时候它再一次移除了消息。

## Events

VS Code API 内的事件是通过调用监听器函数来订阅的函数。订阅函数返回一个可释放类型`Disposable`，他会把 dispose 方法上的监听器给移除掉。
Events in the VS Code API are exposed as functions which you call with a listener-function to subscribe. Calls to subscribe return a `Disposable` which removes the event listener upon dispose.

```javascript
var listener = function(event) {
	console.log(“It happened”, event);
};

// 开始监听
var subscription = fsWatcher.onDidDelete(listener);

// 更多
subscriptions.dispose(); // 停止监听
```

事件名采用`on[Will|Did]VerNoun`结构，意思是事件是否将要发生 *(onWill)* 或者已经发生 *(onDid)* ，现在发生 *(verb)* ，还有上下文 *(noun)* （除非上下文明确）。

一个 VS Code API 的例子是`window.onDidChangeActiveTextEditor`事件会在活动文本编辑器 *（noun）* 已经（*onDid*）改变了（*verb*）

## 使用 Node.js 模块

你的插件允许在运行时依赖[Node.js](https://nodejs.org)模块。和一个 node 模块本身相似，还可以增加一些依赖到 [`package.json` 插件清单](/docs/extensionAPI/extension-manifest.md)的`dependencies`字段上去。

### 安装和打包

你安装VS Code插件的时候，VS Code **不会** 自动安装其依赖，所以你必须在发布前执行`npm install`。插件的安装包会包含他内在的所有依赖。你可以运行`vsce ls`去枚举出所有`vsce`将会包含进安装包的文件。

## 下一步

* [插件清单文件](/docs/extensionAPI/extension-manifest.md) - VS Code package.json 插件清单文件指南
* [贡献关键点](/docs/extensionAPI/extension-points.md) - VS Code 贡献关键点 指南
* [激活事件](/docs/extensionAPI/activation-events.md) - VS Code 激活事件 指南

## 常见问题

#### 问：我可以使用原生 Node.js模块吗

**答：** 一个 VS Code 插件安装包包含许多依赖。意味着如果你在 Windows 开发插件而且发布插件时依赖原生 Node.js 模块，那么你的插件会包含 Windows 上编译好的原生依赖。OS X 、Linux用户就不能使用该插件。

此刻奏效的唯一办法是把四个平台（Windows X86, X64, Linux, OSX）的二进制文件都放进插件，并且插件包含动态加载正确二进制文件的代码。
