---
Order: 11
Area: extensions
TOCTitle: Our Approach
ContentId: 2D912137-E7FE-4C5F-91D9-52088169C4AD
PageTitle: Our Approach to Extensibility
DateApproved: 4/14/2016
MetaDescription: Learn about the choices we made in creating the Visual Studio Code extension (plug-in) model.
---

# 可拓展途径

VS Code拥有一个极具拓展性，并且有许多方法去拓展的模块。但是，我们没有为插件作者们提供底层 UI DOM 的权限。基于 VS Code，我们继续努力优化顶层 Web 技术的使用去交付一个高可用，高响应的编辑器，而且当DOM 技术还有 VS Code 发展时我们会继续调优。VS Code也针对许多智能感知这样的场景内建了一套 UI 组件。这样的话，那些不同编程语言间的体验是流畅的，而且插件和插件作者们不需要另外开发。

我们意识到这个途径可能初始感觉限制到插件作者。同时我们也总是在寻找提高可拓展性，拓展插件可用功能。我们十分期待聆听您的反馈和创意！

## 核心概念

当我们开始着手提高 VS Code 可拓展性的时候，我们有许多考量。下面的章节告知了我们许多关键决定的上下文环境。在 API 内，我们也拥有一份描绘许多[已采纳的核心模式](/docs/extensions/patterns-and-principles.md)轮廓的文档

## 稳定性 - 插件隔离

插件很美妙但是也会影响启动性能或者VS Code 自身的总体性能。为了避开这些问题，VS Code 在一个单独的`extension host process`进程中加载并运行插件。一个行为异常的插件不能影响到 VS Code，特别是启动时间。

我们和终端用户用心构建了这个架构，可以看出此架构确保终端用户总是能够控制 VS Code：用户可以在任何时候打开，输入或者保存文件，不管插件干了什么，VS Code都可以保证UI的响应式。

`extension host`是一个 Node.js 进程，它把 VS CodeAPI 保护给插件作者们。在 `extension host`内部，VS Code 为插件运行提供了调试支持。

## 性能 - 插件激活

VS Code 尽可能晚地加载插件，当前时段没有使用的插件不会被加载，因此不消耗内存。为了支持插件懒加载，VS Code 定义了所谓的`激活事件`.一个[激活事件](/docs/extensionAPI/activation-events.md)会被 VS Code 的特定活动触发，同时插件可以定义它需要激活的哪些事件。举个例子，一个编辑 markdown 的插件只会在用户打开一个 markdown 文件的时候激活

## 插件清单

为了懒激活插件，VS Code 需要一份插件描述`extension manifest`，相当于在`package.json`文件增加了一些[特定字段](/docs/extensionAPI/extension-manifest.md)。这个包含触发插件加载的[激活事件](/docs/extensionAPI/activation-events.md)。VS Code提供一套[插件可以添加](/docs/extensionAPI/extension-points.md)的`贡献点`。举个例子，当添加一个 VS Code 命令的时候，你需要通过`commands`贡献点提供命令声明。在`package.json`内部声明了插件贡献。VS Code 在启动和 UI 初始化的时候读取并解析插件清单。

因为`extensioin host`是一个 Node.js 进程，所以你可以在插件内使用Node API，甚至实现一个插件的时候可以复用 Node.js 模块。可以在`package.json`里声明模块依赖，然后用 npm 去安装一个Node.js 模块。

更多细节请参考 [package.json 贡献点指南](/docs/extensionAPI/extension-points.md)。

## 可拓展 API

在一个单独进程运行插件的办法，使得 VS Code 严格控制了暴露给扩展的 API。更多当前 API 细节请参考[可拓展 API概述](/docs/extensionAPI/overview.md)。

VS Code 使用 Web 技术（HTML，CSS）来实现，因为 Web 技术在修改UI，写样式的时候十分强大。你可以轻易添加节点到 DOM 中，使用 CSS 实现一个个性化外观。但是，当发展成一个像 VS Code 应用的时候就显得不够了。以至于结构改变，和 UI 高耦合的插件会卡住。出于这一点，VS Code 选择保守性办法，确保 DOM 不暴露给插件作者们。

## 插件协议

VS Code 一个常见的插件模式是用一个和 VS Code以某种协议通信的单独进程里，去执行插件代码。比如说，语言服务和调试适配器。通常，这个协议通过stdin/stdout，使用 JSON 载荷，来和进程间通信。使用单独进程会提供一个帮助 VS Code 维持核心编辑器稳定性的边界隔离区。另外，使用插件作者们可以对于特殊插件实现最合适的语言。

## 下一步

* [第一个插件]](/docs/extensions/example-hello-world.md) - 尝试生成一个简单的 Hello world 插件
* [插件API](/docs/extensionAPI/overview.md) - 了解VS Code 可拓展 APIs
* [插件样例](/docs/tools/samples.md) - 你可以查看并构建的插件样例列表

## 常见问题

暂无
