---
Order: 1
Area: extensions
TOCTitle: Overview
ContentId: AD26EFB1-FFC6-4284-BAB8-F3BCB8294728
PageTitle: Extending Visual Studio Code
DateApproved: 4/14/2016
MetaDescription: Visual Studio Code has a rich extensibility model for interacting with and adding to the tool.  Learn how to create your own extensions (plug-ins) for Visual Studio Code.
---

# Visual Studio Code 扩展   Extending Visual Studio Code

如果你对扩展VS Code有兴趣，你就应该看看这篇文档。在这篇文档里将对VS Code的插件做一个概括性的描述，并且将教你快速的制作你的第一个vs Code插件。如果你对更深入的插件制作内容有兴趣，那么你可以阅读这篇 [文章](/docs/extensions/our-approach.md).

If you are interested in extending VS Code, you are in the right place. Here we present an outline of the VS Code extensibility documentation and how to quickly build your first VS Code extension.  If you're curious about our design approach to extensibility for VS Code, you can read about it [here](/docs/extensions/our-approach.md).

如果你仅仅是想使用已经存在的插件，可以阅读这篇[文档](/docs/editor/extension-gallery.md)， 这篇文档将展示如何从VS Code插件[商店](https://marketplace.visualstudio.com/VSCode)里寻找并安装插件。

If you just want to use existing extensions, see the [Extension Marketplace](/docs/editor/extension-gallery.md) topic where we show you how to find and install extensions from the VS Code [Marketplace](https://marketplace.visualstudio.com/VSCode).

>**小贴士:** 别忘了除了插件以外，我们还有很多种方法去 [定制](/docs/customization/overview.md) VS Code而不用写一行代码。包括添加[主题](/docs/customization/themes.md), [基础语言支持](/docs/customization/colorizer.md), 和 [用户定义代码段](/docs/customization/userdefinedsnippets.md)。

>**Tip:** Don't forget there are several ways to [customize](/docs/customization/overview.md) VS Code without writing an extension.  This includes adding [Themes](/docs/customization/themes.md), [basic Language Support](/docs/customization/colorizer.md), and [Snippets](/docs/customization/userdefinedsnippets.md) without writing a single line of code.

所有的VS Code插件在发布（注册），激活（加载）时共享使用公共的模块去访问VS Code插件API。值得一提的是两种特殊的VS Code插件，语言服务和调试器，他们有自已独有的额外协议，这些协议在他们单独的文档中说明。

1. [插件](/docs/extensions/overview.md#extensions) - 基础构建模块
2. [语言服务](/docs/extensions/overview.md#language-servers) - 针对于CPU占用率较高和IO占用率较高的加强任务
3. [调试器](/docs/extensions/overview.md#debuggers) - 连接一个外部的调试器

All VS Code extensions share a common model of contribution (registration), activation (loading) and access to the VS Code extensibility API.  There are however two special flavors of VS Code extensions, language servers and debuggers, which have their own additional protocols and are covered in their own sections of the documentation.

1. [Extensions](/docs/extensions/overview.md#extensions) - the base building block
2. [Language Servers](/docs/extensions/overview.md#language-servers) - for high cost IO or CPU intensive tasks
3. [Debuggers](/docs/extensions/overview.md#debuggers) - wire up an external debugger


## 插件  Extensions

所有的插件在激活时都运行在我们的一个共享的插件宿主进程。这种单独的进程模型能确保VS Code一直保持灵敏的响应

All extensions when activated run in our shared extension host process.  This separate process for extensions ensures that VS Code remains responsive through-out.  

插件包含了以下组件的支持：

* **激活** - 当检测到指定的文件类型，或者指定的文件存在，或者通过命令面板或者键盘快捷键选中一条命令时加载插件
* **编辑器** - 用来处理编辑器的内容 - 读和控制文本, 使用选择区域
* **工作空间** - 访问打开的文件, 状态栏, 信息提示等
* **事件** - 连接编辑器的生命周期，类似：打开，关闭，修改等等 
* **高级编辑器** - 为高级语言提供包括智能感知，预览, 悬停, 诊断以及更多的支持

Extensions include support for:

* **Activation** - load an extension when a specific file type is detected, when a specific file exists, or when a command is selected via the Command Palette or a key combination
* **Editor** - work with the editor's content - read and manipulate text, leverage selection(s)
* **Workspace** - access working files, the status bar, information messages and more
* **Eventing** - connect to the editor life-cycle events such as: open, close, change, and more
* **Evolved editing** - create providers for rich language support including IntelliSense, Peek, Hover, Diagnostics and much, much more

我们有两个手把手的例子演示来让你学习插件的基础开发

1. **[Hello World](/docs/extensions/example-hello-world.md)** - 生成一个基础的插件, 理解插件的目录结构, 插件清单, 学习插件怎样激活，运行，调试和在本地安装。
2. **[Word Count](/docs/extensions/example-word-count.md)** - 学习基于指定的文件类型激活插件, 更新状态栏, 响应文本编辑器的修改, 当文件关闭的时候怎样去释放插件。 

We have two end-to-end walkthroughs to get you going on extension basics:

1. **[Hello World](/docs/extensions/example-hello-world.md)** - generate a basic extension, understand an extension's folder structure, the extension manifest, learn how activation works, run and debug your extension and install it locally. 
2. **[Word Count](/docs/extensions/example-word-count.md)** - activate based on a specific file type, update the status bar, respond to changes in the text editor, and dispose your extension when moving off the file. 

## 语言服务  Language Servers

语言服务将为你的插件创建一个专用的进程。当你的插件占用了很高的CPU或者IO以至于拖慢了其他插件时，这是一个很有用的设计。那些在所有的文件上做处理的任务通常都有这些特点，例如代码检查或者静态分析。

在这里可以找到更多关于[语言服务](/docs/extensions/example-language-server.md)的资料。

Language servers let you create a dedicated process for your extension.  This is a useful design choice for your extension when your extension runs high cost CPU or IO intensive tasks which could slow other extensions.  This is common for tasks that work across all files in a workspace e.g. linters or static analysis suites.

Find out more about [language servers](/docs/extensions/example-language-server.md).

## 调试器 Debuggers

创建一个调试服务用来连接一个任一语言的调试器到VS Code

在这里可以找到更多关于集成[调试器](/docs/extensions/example-debuggers.md)的信息。

最简单的方法是通过插件[商店](/docs/editor/extension-gallery.md)去看已经发布的VS Code插件，你可以找到一些很有用的插件，安装他们并且了解他们来想办法扩展你自己开发环境的VS Code。

Connecting a debugger written for any language to VS Code is possible through the creation of a debug service.

Find out more about integrating [debuggers](/docs/extensions/example-debuggers.md).

The easiest way to see VS Code extensions in action is via the [Extension Marketplace](/docs/editor/extension-gallery.md).  You can browse for useful extensions, install them to try them out and get an idea how you might extend VS Code for your own development scenarios.

## 编写一个插件  Writing an Extension

你可以用TypeScript或者JavaScript来编写一个插件。VS Code提供了一个一流的插件开发体验，你可以用VS Code自己完成[开发, 构建, 运行, 测试 和 调试](/docs/extensions/debugging-extensions.md)的所有环节。

Extensions can be written in either TypeScript or JavaScript.  VS Code offers a first class extension development experience where you can [develop, build, run, test and debug](/docs/extensions/debugging-extensions.md) all from within VS Code itself.

## 安装和分享  Install and Share

一旦你拥有了一个可以正常工作的插件，你可以[安装或者分享给其他人](/docs/extensions/install-extension.md)。我们支持本地安装，私有分享，或者发布到公共的[插件商店](/docs/editor/extension-gallery.md)。

Once you have a working extension, you can [install it or share it with others](/docs/extensions/install-extension.md).   We support local installation, private sharing, or publishing to the public [Extension Marketplace](/docs/editor/extension-gallery.md).

## 测试插件  Testing Extensions

我们也对插件的[编写、运行和测试](/docs/extensions/testing-extensions.md)有完美的支持。你可以很容易创建一个针对调用的所有VS Code API的集成测试，并且在一个运行中的VS Code实例中测试你的代码。

We also have great support for [writing and running tests](/docs/extensions/testing-extensions.md) for your extension.  You can easily create integration tests which call the VS Code APIs and test your code in a running VS Code instance.

## 下一步  Next Steps

* [你的第一个插件](/docs/extensions/example-hello-world.md) - 试着去创建一个简单的Hello World插件
* [插件API](/docs/extensionAPI/overview.md) - 学习VS Code插件API
* [示例](/docs/tools/samples.md) - 你可以复习和构建的插件示例列表

* [Your First Extension](/docs/extensions/example-hello-world.md) - Try creating a simple Hello World extension
* [Extension API](/docs/extensionAPI/overview.md) - Learn about the VS Code extensibility APIs
* [Samples](/docs/tools/samples.md) - A list of extension samples you can review and build

## 常见问题 Common Questions

无

Nothing yet

