---
Order: 9
Area: extensions
TOCTitle: Installing Extensions
ContentId: 8D19F206-8CB3-498D-BDD1-317B4104EDD0
PageTitle: Installing Visual Studio Code Extensions
DateApproved: 4/14/2016
MetaDescription: Learn how to install Visual Studio Code extensions (plug-ins) from the public Marketplace, shared with other developers or privately on your own machine.
---

# 安装扩展

## 个人扩展文件夹

VS Code 会在个人扩展文件夹中`.vscode/extensions`来寻找扩展组件。不同的平台其文件夹所在的位置也不同：

* **Windows** `%USERPROFILE%\.vscode\extensions`
* **Mac** `~/.vscode/extensions`
* **Linux** `~/.vscode/extensions`

如果你想在VS Code 每次启动都能够加载你自己的扩展或者定制化信息，那么就需要在`.vscode/extensions`文件夹下新建一个文件夹，并把项目文件放进去。例如：`~/.vscode/extensions/myextension`。

## 单独与他人共享 (旁加载)

如果你想单独和其他人分享你的扩展或者自定义配置，只需要简单地把生成器的结果文件发送给他们并让他们把文件放在他们自己的`.vscode/extensions`文件夹下。或者，你可以执行命令`vsce package`来打包你的扩展，该命令使用[vsce publishing tool](/docs/tools/vscecli.md)工具将扩展打包成`vsix`文件，之后将该文件发送给他们即可。

## 安装已打包的扩展(.vsix)

你可以手动地安装已打包成`.vsix`文件的VS Code扩展。只需要使用VS Code的命令行并提供相关`.vsix`文件的路径。

```bash
code myextension.vsix
```

扩展将会被安装到个人扩展文件夹`.vscode/extensions`中，你可以一次安装多个扩展，只要在命令行中提供多个`.vsix`文件的路径。

你也可以通过在VS Code中打开`.vsix`文件来安装扩展。点击**文件** > **打开文件…**或者`kb(workbench.action.files.openFile)`并选择`.vsix`扩展文件。

## 发布到商店中

如果你想将你的扩展与他人分享到VS Code 的[应用商店](/docs/editor/extension-gallery.md)中，可以使用[vsce publishing tool](/docs/tools/vscecli.md)工具来打包你的扩展并提交它。

## 下一步


* [应用商店](/docs/editor/extension-gallery.md) - 了解更多关于VS Code 的公开扩展
* [发布扩展](/docs/tools/vscecli.md) - 了解如何打包并发布你的扩展
