---
Order: 3
Area: tools
TOCTitle: Samples
ContentId: B32601A8-27ED-4D97-BA83-F1C8C945C635
PageTitle: Visual Studio Code Extension Samples
DateApproved: 4/14/2016
MetaDescription: Learn from existing extension samples.
---


# VS Code Extension Samples 
# VS Code 扩展范例

This is a list to make it easy to see where all the samples are...   
这里是一个便于查看所有范例的列表。

We have two walkthroughs that cover many of the core concepts - start with these:   
我们从覆盖了许多核心概念的两个演练开始：

* **[Your First Extension](/docs/extensions/example-hello-world.md)** - explains the core extensibility concepts with a walkthrough 
* **[你的第一个扩展](/docs/extensions/example-hello-world.md)** - 通过一个演练讲解核心扩展概念
* **[Word Count Extension](/docs/extensions/example-word-count.md)** - another walkthrough building on the last 
* **[单词计数扩展](/docs/extensions/example-word-count.md)** - 建立在上个例子基础之上的另一个演练

## Sample Extensions 
## 扩展范例

Sample|Description|Type|In Marketplace
------|-----------|----|---------
**[Word Count](https://github.com/Microsoft/vscode-wordcount)**|Adds a word count to the status bar for Markdown files that updates on editing events.  We have a [walkthrough on how this was created](/docs/extensions/example-word-count.md).|[Extension](/docs/extensions/example-hello-world.md)|Y
**[MDTools](https://github.com/Microsoft/vscode-MDTools)**|Work with selections and update based on common text processing e.g. ToUpper, HTMLEncode, ...|[Extension](/docs/extensions/example-hello-world.md)|Y
**[Decorator](https://github.com/Microsoft/vscode-extension-samples/tree/master/decorator-sample)**|Shows how to decorate editor text with a border, colors, and a custom cursor as well as add an overview ruler highlight.|[Extension](/docs/extensions/example-hello-world.md)|N
**[TextDocumentProvider](https://github.com/Microsoft/vscode-extension-samples/tree/master/textdocumentprovider-sample)**|Shows how to create virtual documents and preview them.|[Extension](/docs/extensions/example-hello-world.md)|N
**[TSLint](https://github.com/Microsoft/vscode-tslint)**|Lint your TypeScript files based on TSLint|[Language Server](/docs/extensions/example-language-server.md)|Y
**[Spelling and Grammar Checker](https://github.com/Microsoft/vscode-spell-check)**|Configurable Markdown spelling and grammar checker.  Calls an external web service for checking and supports activation, add to dictionary, error mapping.  Watches for config file changes in real time.|[Extension](/docs/extensions/example-hello-world.md)|Y
**[Mock Debugger](https://github.com/Microsoft/vscode-mock-debug)**|Helps you build and test a debugger.|[Debuggers](/docs/extensions/example-debuggers.md)|Y
**[Go Language Support](https://github.com/microsoft/vscode-go)**|Rich language support for [Go Lang](https://golang.org/) - IntelliSense, Debug, Peek, Rename, Syntax, ...|[Extension](/docs/extensionAPI/vscode-api.md#languages)|Y 

范例|描述|类型|在商店中
------|-----------|----|---------
**[Word Count](https://github.com/Microsoft/vscode-wordcount)**|在editing更新事件触发时，为MarkDown文件添加一个单词计数的状态栏. 这里是[关于这个扩展是如何被创建的范例](/docs/extensions/example-word-count.md).|[Extension](/docs/extensions/example-hello-world.md)|Y
**[MDTools](https://github.com/Microsoft/vscode-MDTools)**|普通文本处理选择和更新是如何工作的. ToUpper, HTMLEncode, ...|[Extension](/docs/extensions/example-hello-world.md)|Y
**[Decorator](https://github.com/Microsoft/vscode-extension-samples/tree/master/decorator-sample)**|展示如何用边框、颜色和自定义光标或者高亮的规则总览装饰一个可编辑文本。|[Extension](/docs/extensions/example-hello-world.md)|N
**[TextDocumentProvider](https://github.com/Microsoft/vscode-extension-samples/tree/master/textdocumentprovider-sample)**|展示如何创建一个虚拟文档并预览他们。|[Extension](/docs/extensions/example-hello-world.md)|N
**[TSLint](https://github.com/Microsoft/vscode-tslint)**|TSLint实现TypeScript的语法提示。|[Language Server](/docs/extensions/example-language-server.md)|Y
**[Spelling and Grammar Checker](https://github.com/Microsoft/vscode-spell-check)**|可配置的MarkDown拼写和语法检查器。 调用额外的Web服务实现检测和支持激活，添加到字典，错误映射。 实时检测配置文件变化。|[Extension](/docs/extensions/example-hello-world.md)|Y
**[Mock Debugger](https://github.com/Microsoft/vscode-mock-debug)**|帮助你创建和测试一个调试器。|[Debuggers](/docs/extensions/example-debuggers.md)|Y
**[Go Language Support](https://github.com/microsoft/vscode-go)**|富语言支持 [Go Lang](https://golang.org/) - 智能提示, 调试, 选取, 重命名, 语法, ...|[Extension](/docs/extensionAPI/vscode-api.md#languages)|Y 


## Tools to Help you build an Extension 
## 帮助你创建扩展的工具

Tool|Purpose
----|-------
**[Extension Generator](/docs/tools/yocode.md)**|To help you getting started implementing an extension, we have a [Yeoman](http://yeoman.io/) generator.  This creates all the initial settings you need for the development environment to work well and includes the API Typing files and any relevant modules.  You can find the generator source [here](https://github.com/Microsoft/vscode-generator-code).
**[Debugging Extensions](/docs/extensions/debugging-extensions.md)**|We have worked hard to provide an easy way to develop, debug and locally test your extensions.
**[Publishing Tool](/docs/tools/vscecli.md)**|Once you have a working extension, it's time to [share it](/docs/tools/vscecli.md) in the [extension Marketplace](/docs/editor/extension-gallery.md). We have a simple command line tool for this. You can find the source code [here](https://github.com/Microsoft/vsce).

工具|目的
----|-------
**[Extension Generator](/docs/tools/yocode.md)**|帮助你开始实现一个扩展, 我们有 [Yeoman](http://yeoman.io/) 生成器。 创建你的开发环境所需的所有初始化配置，包括API类型文件和任意相关的模块。  你可以从[这里](https://github.com/Microsoft/vscode-generator-code)获取生成器源码。
**[Debugging Extensions](/docs/extensions/debugging-extensions.md)**|
**[Publishing Tool](/docs/tools/vscecli.md)**|一旦你有了一个可以正常工作的扩展，那么是时候在[扩展商店](/docs/editor/extension-gallery.md)[分享它](/docs/tools/vscecli.md)了。 对此我们有一个简单的命令行工具。你可以从[这里](https://github.com/Microsoft/vsce)找到它的源码。

## Runtime samples 
## 运行时范例

* [Node.js](https://github.com/Microsoft/vscode-samples)

## Next Steps 
## 接下来的步骤

* [Extension Marketplace](/docs/editor/extension-gallery.md) - Learn more about VS Code's public extension Marketplace. 
* [扩展商店](/docs/editor/extension-gallery.md) - 可以学习更多VSCode公共扩展相关内容的商店。

## Common Questions 
## 常见问题

Nothing yet  
现在还没有
