﻿---
Order: 7
Area: customization
TOCTitle: Display Language
ContentId: 413A7FA3-94F8-4FCB-A4A3-F4C1E77EF716
PageTitle: Visual Studio Code Display Language (Locale)
DateApproved: 4/14/2016
MetaDescription: How to change the display language (locale) of Visual Studio Code.  
---

# Display Language - 语言区域

Visual Studio Code 附带 10 种可供显示的语言（区域设置）：英语（美国），简体中文，繁体中文，法语，德语，意大利语，日语，韩语，俄语和西班牙语。10 种语言均包含于 Visual Studio Code 本体当中，无需再次下载。

默认情况下，VS Code 将自动使用系统默认语言，如不支持当前系统语言将使用 英语（美国）作为默认语言。

## Available Locales - 可选语言

语言 | 区域
-----------------|-------
英语（美国） | `en-US`
简体中文 | `zh-CN`
繁体中文 | `zh-TW`
法语 | `fr`
德语 | `de`
意大利语 | `it`
日语 | `ja`
韩语 | `ko`
俄语 | `ru`
西班牙语 | `es`

## Setting the Language - 语言设置

如果您想要切换语言，可以于启动 VS Code 时在命令行参数中添加 `--locale` ，或者使用命令面板（F1）中的 **配置语言 ( Configure Language )** 选项来切换为其他语言。

例：使用 `--locale` 命令行参数的方法将语言切换为法语

```bash
code . --locale=fr
```

 **配置语言 ( Configure Language )** 命令将会在您的 VS Code 用户目录中创建一个 `locale.json` 文件，并设置 `locale` 属性为您系统的首选语言。

例：使用命令面板方法将语言切换为繁体中文

```json
{
    // Defines VS Code's display language.
    "locale":"zh-TW"
}
```

> 注：修改 `locale` 值后需要重新启动 VS Code 方能生效。
