﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using QZsystem.Library.UsersTableAdapters;
using QZsystem.Library.DaydsTableAdapters;

namespace QZsystem.Grbg
{
    public partial class Grbgday : Library.Log
    {
        static public Library.Dayds.TbeiwangDataTable daytable;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int id = Convert.ToInt32(Session["myid"]);
                TbeiwangTableAdapter Tday = new TbeiwangTableAdapter();
                int stryear = DateTime.Now.Year;
                int stryearresult = stryear - 1;
                DateTime deldate = Convert.ToDateTime(stryearresult + "-12-30");
                int? datecount = Convert.ToInt32(Tday.Scalardate(deldate));
                if (datecount != null)
                {
                    if (datecount > 0)
                    {
                        Tday.Deletedate(deldate);
                    }
                }
                daytable = Tday.Getcreatuser(id);
            }
        }
        protected void Calendar1_DayRender(object sender, DayRenderEventArgs e)
        {
            CalendarDay calDay = e.Day;
            TableCell tc = e.Cell;
            CNDate dt = new CNDate(calDay.Date);
            int i = 0;
            if (calDay.IsOtherMonth)
            {
                tc.Controls.Clear();
            }
            else
            {
                HyperLink aHyperLink = new HyperLink();
                aHyperLink.ToolTip = "管理备忘录";
                aHyperLink.ID = "addid";
                aHyperLink.Attributes["da"] = calDay.Date.ToShortDateString();
                aHyperLink.Text = dt.GetLunarHolDay();
                aHyperLink.NavigateUrl = "#";
                tc.Controls.Add(new LiteralControl("&nbsp;&nbsp;"));
                tc.Controls.Add(aHyperLink);
                tc.Controls.Add(new LiteralControl("<br>"));
                if (daytable.Rows.Count > 0)
                {
                    foreach (var rows in daytable)
                    {
                        if (rows.Creatdate == calDay.Date)
                        {
                            i++;
                        }
                    }
                }
                if (i > 0)
                {
                    HyperLink aHyperLink2 = new HyperLink();
                    aHyperLink2.ID = "viewdate";
                    aHyperLink2.Attributes["daa"] = calDay.Date.ToShortDateString();
                    aHyperLink2.ToolTip = "查看个人日程";
                    aHyperLink2.NavigateUrl = "#";
                    aHyperLink2.Text = "◎您今日有" + i + "个日程";
                    tc.Controls.Add(aHyperLink2);
                }
            }
        }
    }
}