﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using QZsystem.Library.KmTableAdapters;
using QZsystem.Library.MxTableAdapters;
using QZsystem.Library.PzmsgTableAdapters;

namespace QZsystem.Cwgl
{
    public partial class Cwglkm : Library.Log
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            qzqzqz.Text = "";
            if (!IsPostBack)
            {

                TkmTableAdapter Tkm = new TkmTableAdapter();
                int? count = Convert.ToInt32(Tkm.ScalarQuery());
                if (count != null)
                {
                    Label lb = (Label)this.ListView1.FindControl("Labelcount");
                    if (lb != null)
                    {
                        lb.Text = count.ToString();
                    }
                }
            }
        }
        protected void ListView1_ItemInserting(object sender, ListViewInsertEventArgs e)
        {
            if (this.IsValid)
            {
                TextBox t1 = (TextBox)e.Item.FindControl("KmTextBox");
                TextBox t2 = (TextBox)e.Item.FindControl("KnameTextBox");
                string km = t1.Text.Trim();
                string kname = t2.Text.Trim();
                if (km.Length >= 4)
                {
                    TkmTableAdapter Tkm = new TkmTableAdapter();
                    var countkname = Tkm.Getkname(kname);
                    var countkm = Tkm.Getkm(km);
                    if (countkname.Rows.Count > 0)
                    {
                        e.Cancel = true;
                        qzqzqz.Text = "<script>alert('新增失败,科目名称重复');</script>";
                        return;
                    }
                    else if (countkm.Rows.Count > 0)
                    {
                        e.Cancel = true;
                        qzqzqz.Text = "<script>alert('新增失败,科目编码重复');</script>";
                        return;
                    }
                    else
                    {
                        try
                        {
                            DropDownList dfane = (DropDownList)e.Item.FindControl("DropDownList2");
                            e.Values["Fang"] = dfane.SelectedValue;
                            DropDownList d1 = (DropDownList)e.Item.FindControl("DropDownList1");
                            int s = Convert.ToInt32(d1.SelectedValue);
                            e.Values["Pid"] = s;
                            if (s == 0)
                            {
                                double d = Convert.ToDouble(km);
                                e.Values["kid"] = d;
                            }
                            else if (s == 1)
                            {
                                string str = km.Replace('-', '.');
                                double d = Convert.ToDouble(str);
                                e.Values["kid"] = d;
                            }
                            else if (s == 2)
                            {
                                string[] str1 = km.Split('-');
                                string str2 = str1[0] + "." + str1[1] + str1[2];
                                double d = Convert.ToDouble(str2);
                                e.Values["kid"] = d;
                            }
                        }
                        catch
                        {
                            e.Cancel = true;
                            qzqzqz.Text = "<script>alert('新增失败,科目类别与科目编号不批配.');</script>";
                        }
                    }
                }
                else
                {
                    e.Cancel = true;
                    qzqzqz.Text = "<script>alert('科目编号最少四位数');</script>";
                }
            }
        }
        protected void ListView1_ItemDeleting(object sender, ListViewDeleteEventArgs e)
        {
            int id = Convert.ToInt32(this.ListView1.DataKeys[e.ItemIndex].Value);
            TkmTableAdapter Tkm = new TkmTableAdapter();
            var row = Tkm.Getid(id).Single();
            TpzmsgTableAdapter Tpzmsg = new TpzmsgTableAdapter();
            int? count = Tpzmsg.Scalarkmlike(row.Km + "%");
            if (count != null)
            {
                if (count > 0)
                {
                    e.Cancel = true;
                    qzqzqz.Text = "<script>alert('删除失败,科目下有凭证记录不能删除');</script>";
                }
            }
        }
    }
}