[toc]

# 一、基础认识

## 0. PE、BIOS与UEFI 、 MBR和GPT

### PE

[体验最好的 PE 系统是什么？](https://www.zhihu.com/question/40137216)

> 1、目前最良心的最好用的PE，应该是李培聪先生的“微PE”。[微PE工具箱 - 最好用的WinPE装机维护工具](http://www.wepe.com.cn/download.html)

### BIOS和UEFI

UEFI 是取代传统 BIOS 的，全称“统一的可扩展固件接口”。MBR 则是传统的分区表类型，最大的缺点则是不支持容量大于 2T 的硬盘。GPT 则弥补了 MBR 这个缺点，最大支持 18EB 的硬盘，是基于 UEFI 使用的磁盘分区架构。



相关阅读：

- BIOS中文意思：[如何设置ThinkPad S1 Yoga BIOS Setup](https://zm10.sm-tc.cn/?src=l4uLj8XQ0IuXlpGU0ZOakZCJkNGckJLRnJHQl4uSk4zQlJGQiJOam5ia0Juai56Wk6DNz87Lz8nPys7OzM7OzsfMy9GXi5KT&uid=1bb14c7fc13bbf5ada5972a917c90bdc&hid=a50f725ecb1c10ced7f6c68d3f2cf4c2&pos=2&cid=9&time=1519216780276&from=click&restype=1&pagetype=0000004000000402&bu=structure_web_info&query=boot+order+lock&mode=&v=1&uc_param_str=dnntnwvepffrgibijbprsvdsdichei)
- [UEFI是什么？与BIOS的区别在哪里？UEFI详解！](http://www.ihacksoft.com/uefi.html)
- [UEFI+GPT引导基础篇（一）：什么是GPT，什么是UEFI？](https://www.iruanmi.com/what-is-gpt-and-what-is-uefi/)
- [大白菜UEFI版和装机版制作U盘有什么区别](http://www.bigbaicai.com/rjjc/cjwt/1751.html) 

### MBR和GPT



## 1. 机械硬盘、固态硬盘、转速、缓存

### 机械硬盘

[大家觉得机械硬盘转速和缓存哪个对速度影响更大呢？](https://steamcn.com/t447918-1-1)  【荐】

> 所以说，缓存还是蛮有用的，不止可以延长机械硬盘寿命，还能在一定的程度上提升机械硬盘速度速度，缓存32MB和64MB差距会较大，但32MB以下的和64MB以上的差距就不大了。
>
> ......

### 固态硬盘

> 在给固态硬盘分区时，需要设置4k对齐才能发挥它的优势。

[设置固态硬盘4k对齐视频教程](http://www.bigbaicai.com/videos/3105.html)

> 其实做法就是：设置「对齐分区到此扇区数的整数倍」，32位系统设置为对齐到 2048；64位系统设置为对齐到 4096。　

**1、固态硬盘为什么有擦写次数的限制？原理是什么？**

回答1：

> 这个问题，要从SSD盘的结构说起。其由控制单元（主控芯片）和存储单元（闪存芯片）两部分组成。而影响写入寿命问题，就出在闪存器件上。
>
> 1. 闪存存储单元的物理结构中，用氧化物创建一个电场，电子穿过氧化物并储存电荷，记录一个电位值，即写入1位数据，擦除数据会向相反方向发生同样事件。问题是电子穿过氧化物的次数越多，氧化膜就会变的越弱，最终电场也不能阻止电子的自由活动了，这个单元就损坏了；
> 2. 因此，写和擦都是会减少氧化膜的寿命的，制造工艺又限制了该膜的厚度，其存储单元的寿命由此而来。理论值，SLC闪存擦写寿命10万次；MLC闪存擦写寿命1万次；TLC闪存擦写寿命500~1500次。

回答2：

> 这个问题，我也在网上查了好久，综合多个文章，大概是这样的：
>
> 单元存储颗粒，你用多了，可能就消磁了，或者介质疲劳损坏了“可以理解为，就像是轮胎那样磨损了”。
>
> 一个单元颗粒，可以擦写1000次； 利用这些个单元颗粒，组成了100G的硬盘；当你正好写入100G的数据的时候，这个100G的硬盘，正好每个颗粒 被擦写了1次。
>
> 个人的 SSD 硬盘，如果每天能写满100G，那1000次的颗粒硬盘，可以用1000天。
>
> 平时我们的 SSD，写入是非常少的，为了保证每个颗粒的使用频度；SSD 有一套均衡机制，保证每个颗粒都能被使用到，而且尽可能的使用的平均。 如果 100G 硬盘，平时只有 10G 数据，不会只往那 10G 上写【与机械硬盘的区别】，否则的话，那10G写报废了，岂不是整个硬盘也跟着报废。
>
> 即使硬盘有些数据是始终只读的，在其它颗粒被频繁使用后，调度也会做出数据迁移，保证每个颗粒的平均使用度。就是，100G的硬盘，一天写100G，如果是1000次擦写的，基本上用 3 年没任何问题【理论上的，没有其它故障原因】。
>
> 但是，一天写100G，基本不可能，所以呢，一个固态硬盘，用个 5、6 年基本没问题，跟机械硬盘差不了多谢； 反而是，机械硬盘频繁擦写固定的位置，反而容易坏道。  

回答3：

> 因为固态盘都是闪存盘，闪存都是有写入寿命的。这一点和U盘是一个意思。
>
> 从 U 盘时代就讨论 SLC 还是 MLC 了。为什么大家都害怕喜欢 SLC？害怕 TLC。本质上就是写入寿命不一样。SLC 能写一万次，MLC 是3000次，TLC 只有 1500 次。

回答4：

> **固态硬盘的擦写次数就是写入和抹除的次数，一般固态硬盘的芯片有 SLC、MLC、TLC 三种。由于SSD盘由控制单元（主控芯片）和存储单元（闪存芯片）两部分组成。而影响写入寿命问题，就出在闪存器件上。因此有擦写次数的限制。主要原理也是用客观的减少擦写次数来防治损坏。**
>
> 固态硬盘（Solid State Drives），简称固盘，固态硬盘（Solid State Drive）用固态电子存储芯片阵列而制成的硬盘，由控制单元和存储单元（FLASH芯片、DRAM芯片）组成。固态硬盘在接口的规范和定义、功能及使用方法上与普通硬盘的完全相同，在产品外形和尺寸上也完全与普通硬盘一致。被广泛应用于军事、车载、工控、视频监控、网络监控、网络终端、电力、医疗、航空、导航设备等领域。
>
> 其芯片的工作温度范围很宽，商规产品（0~70℃）工规产品（-40~85℃）。虽然成本较高，但也正在逐渐普及到DIY市场。由于固态硬盘技术与传统硬盘技术不同，所以产生了不少新兴的存储器厂商。厂商只需购买NAND存储器，再配合适当的控制芯片，就可以制造固态硬盘了。新一代的固态硬盘普遍采用SATA-2接口、SATA-3接口、SAS接口、MSATA接口、PCI-E接口、NGFF接口、CFast接口和SFF-8639接口。

——from：[ssd固态硬盘 为什么有擦写次数的限制？原理是什么？_百度知道](<https://zhidao.baidu.com/question/1176248024345426139.html>)

相关阅读：

- [固态硬盘寿命，固态硬盘使用寿命怎么看|Crucial(英睿达)](<https://www.crucial.cn/learn-with-crucial/ssd/the-service-life-of-ssds>)

### 硬盘分区

知乎：[硬盘主分区，扩展分区，逻辑分区，动态分区这些名称都是什么意思？](https://www.zhihu.com/question/20281689)
> 这个回答值得先看看。 「这也就是为什么，操作系统不能安装在逻辑分区的原因了。」（MBR分区表的由于本身结构的限制，最多允许在一个硬盘上同时创建4个主分区；而GPT分区表则在设计时进行了改进，基本没有主分区数量的限制，只要有没有占用的盘符，就可以创建更多地主分区。）一个硬盘最多可创建4个主分区。活动分区是基于主分区的，磁盘分区中的任意主分区都可以设置为活动分区。如果电脑上4个主分区都安装了不同的系统，那被标记为活动分区的主分区将用于初始引导，即启动活动分区内安装的系统。

PS：关于硬盘分区，不管什么系统，(MBR)硬盘最多能分4个主分区，当然了，扩展分区（可以包括很多逻辑分区）算一个主分区。
![](https://pic3.zhimg.com/80/v2-c186e51625a2dcf2d8e1666b4acc5606_hd.jpg)


再看这篇文章：[认识主分区,活动分区,扩展分区和逻辑分区](http://www.disktool.cn/jiaocheng/basic-partition.html)  会有更加清晰的认识。

[使用主分区和逻辑分区的意义在哪里？](https://segmentfault.com/q/1010000000699894)

[电脑硬盘主分区和逻辑分区的区别是什么](https://jingyan.baidu.com/article/c85b7a642aade8003bac950e.html)

这篇文章也解释了很多：[电脑硬盘分3个主分区可以吗？](https://zhidao.baidu.com/question/1540772428888403707.html)


**分区的有关问题**

系统能安装在「逻辑分区」吗？
> [逻辑分区可以装系统吗](https://zhidao.baidu.com/question/1545048991841292267.html)
> 当然可以，不过系统的引导文件必需要在主分区这下才行！这点其实不用你去设置，系统都知道一定要安装引导文件到C盘的！

[Linux可不可以装在逻辑分区中？](https://zhidao.baidu.com/question/50824713.html) 


这里有个百度知道： [一个硬盘可以没有主分区么?](https://zhidao.baidu.com/question/151094214.html)

> 这个问题不是绝对的。如已有一块硬盘，其上有主分区，即可安装操作系统使用。而另一块硬盘则可以没有主分区，即全为逻辑分区。这第二块硬盘的分区中，仍可安装操作系统，与第一块盘的系统，组成多操作系统环境。
>
> 这块没有主分区的硬盘，可以安装操作系统使用的秘密，就在于它的启动引导程序，仍被存放在第一块盘的主分区中，路标指向多系统所在路径。
>
> 但，如果仅有一块硬盘，没有主分区，即失去了引导启动的功能，即便安装了操作系统也不能使用的。硬盘中光有主分区，还不能满足启动系统条件，还要“激活”主分区才行。

**关于分区的总结：**

> ***总结 1：***
>
> 主分区也可成为“引导分区”，会被操作系统和主板认定为这个硬盘的第一个分区。所以C盘永远都是排在所有磁盘分区的第一的位置上。 
>
> 除去主分区所占用的容量以外，剩下的容量被认定为扩展分区。通俗的讲就是主分区是硬盘的主人，而扩展分区是这个硬盘上的仆人，主分区和扩展分区为主从关系。
>
> 扩展分区如果不再进行分区了，那么扩展分区就是逻辑分区了。如果还需要进行分区操作的话，则所谓的逻辑分区只能从扩展分区上操作。就相当于在仆人中（扩展分区上）进行细分类，分成接电话的（D盘）、扫地的（E盘）、做饭的（F盘）等等。
>
> ***总结 2：***
>
> 最多可以分四个主分区，只不过其中只能有一个是活动的，另外扩展分区也相当于一个主分区，也就是说你可以分三个主分区和一个扩展分区。
>
> 不过一般有一个主分区就够了，你想分两个主分区也是完全可以的，系统不一定要装在主分区上的，也可以装在扩展分区下的逻辑分区里，不过windows的引导文件是一定要在第一分区，也就是c盘下的。

问：一个硬盘可以没有主分区么?

>  答：这个问题不是绝对的。如已有一块硬盘，其上有主分区，即可安装操作系统使用。而另一块硬盘则可以没有主分区，即全为逻辑分区。这第二块硬盘的分区中，仍可安装操作系统，与第一块盘的系统，组成多操作系统环境。
>
> 这块没有主分区的硬盘，可以安装操作系统使用的秘密，就在于它的启动引导程序，仍被存放在第一块盘的主分区中，路标指向多系统所在路径。但，如果仅有一块硬盘，没有主分区，即失去了引导启动的功能，即便安装了操作系统也不能使用的。硬盘中光有主分区，还不能满足启动系统条件，还要“激活”主分区才行。

关于这块的知识建议可以阅读：《鸟哥的Linux私房菜-基础篇》写的很好。　

### 分区格式： FAT32、NTFS、exFAT等

**FAT32：**虽然我们现在还常常能看到它的身影，存粹是因为它的兼容性比较好。从 1997 年的 Windows
95 OSR2 开始它被正式引用，几乎所有主流系统都能对其格式进行读写。

但缺点也很明显，它的安全性不高，而且对单个文件体积有限制，大小不能超过 4GB，文件名长度不能超过 255 字符。

**exFAT：**FAT 是胖的意思，exFAT 就是比胖还胖的意思。

其实 exFAT 也叫 FAT64，从 Windows CE6 之后就出现了。它彻底解决了 FAT32 不支持 4G 以上大文件的缺点，直接最大支持 16EB，可说是非常万能了。Win、Mac 都能用，还有很强的跨平台能力，是微软专为闪存（U盘、存储卡）闪存设备设计的文件系统，兼容性非常好。

**NTFS：**NTFS 的名字就很骚气，全称 New Technology File System 新技术。从 Windows 2000 以后开始普及，发展到如今 NTFS 最大支持 256TB（MBR），GPT 分区下更是最大支持 128EB。它是微软为网络、磁盘配额、文件加密等多方面设计的磁盘格式，管理方便、安全性好、容错率高，扩展方便。它最稳定、推荐机械硬盘使用（存储数据首选）。

如果你是 Mac 用户就又多了些小麻烦，因为 NTFS 是微软的专利，Mac 用户需要靠第三方软件才能写入 NTFS 文件系统，所以多平台用户更推荐 exFAT 格式。

——from：[小科普 | FAT32、NTFS、exFAT？格式化我该选谁？](<https://www.bilibili.com/read/cv644956/>)

1、Fat32 文件格式是一种通用格式，任何 USB 存储设备都会预装该文件系统，可以在任何操作系统平台上使用。最主要的缺陷是只支持最大单文件大小容量为 4GB，因此日常使用没有问题，只有在传输大文件时才会显现出缺点。

2、exFAT 文件是微软自家创建的用来取代 FAT32 文件格式的新型文件格式，它最大可以支持 1EB 的文件大小，非常适合用来存储大容量文件，还可以在 Mac 和 Windows 操作系统上通用。虽然是微软的技术，苹果批准在系统中使用该文件格式，因此在 Mac 系统中格式化存储设备时会出现 exFAT 文件格式选项。**最大的缺点是没有文件日志功能，这样就不能记录磁盘上文件的修改记录。**

3、NTFS是微软为硬盘或固态硬盘（SSD）创建的默认新型文件系统，NTFS 的含义是 New Technology File System，它基层了所有文件系统的优点：日志功能、无文件大小限制、支持文件压缩和长文件名、服务器文件管理权限等。最大的缺点是 Mac 系统只能读取 NTFS 文件但没有权限写入，需要借助第三方工具才能实现。因此跨平台的功能非常差。——from：<https://zhuanlan.zhihu.com/p/32364955>

相关阅读：

- [新买的移动硬盘该格式化为 NTFS 还是 exFAT？ - 知乎](<https://www.zhihu.com/question/20448164>)
- [有哪些 macOS 和 Windows 都支持的文件系统？ - 知乎](<https://www.zhihu.com/question/278134190>)
- [为什么有人说exfat会丢数据呢？ - 知乎](<https://www.zhihu.com/question/21034296>)
- [如今Mac下使用移动硬盘最好的解决方案是哪种？ - 知乎](<https://www.zhihu.com/question/45553897>)

**Mac 下如何使用 NTFS 格式硬盘？**参考：[Microsoft NTFS for Mac by Paragon Software](<https://china.paragon-software.com/home-mac/ntfs-for-mac/>) 该软件。

>我们知道，Windows 和 macOS 都是最主流的电脑操作系统，但是两者关系却并不那么友好：两个系统使用完全不同的文件格式，且互不兼容！Windows 系统对苹果的 HFS+ 文件完全无法读写，而苹果电脑的 macOS 对现在 Windows PC 上最主要的 Mocrosoft NTFS 文件系统也仅仅提供了阅读的支持。那意味着你无法在 NTFS 分区中创建、删除或者修改文件或文件夹。对想在苹果电脑上使用 Mocrosoft NTFS 分区、移动硬盘或者是双系统的用户来说，这是件非常麻烦的事情。
>
>Microsoft NTFS for Mac by Paragon Software 就是用来解除您这个烦恼的！通过 Microsoft 的 NTFS for Mac by Paragon Software，您可以在 macOS 下高速安全地对 Microsoft NTFS 分区文件进行读读取、编辑、修改、删除的任何操作。为您的跨平台文件管理带来极大的便利。



## 2. 内存、虚拟内存

### 内存

我们先来认识内存：

一代内存（DDR）、二代内存（DDR2）、三代内存（DDR3），常说的几代内存条，主要是以内存的频率来划分。

- 一代（DDR）内存频率主要分为：DDR266、DDR333、DDR400
- 二代（DDR2）内存频率主要分为：DDR2 533、DDR2 667、DDR2 800
- 三代（DDR3）内存评论主要分为：DDR3 1066、DDR3 1333、DDR3 1600、DDR3 1866
- 四代（DDR4）内存频率主要分为：DDR4 2133、DDR4 2400、DDR4 2666、DDR4 3200、DDR4 3600

> DDR3是标准电压1.5V，而DDR3L是低电压1.35V。DDR4：1.25v 电压。

内存选购：

- [内存讲解和选购指南合集 - 哔哩哔哩](<https://www.bilibili.com/read/cv1406336/>)

### 虚拟内存

- [「技巧」如何正确设置WIN7的虚拟内存](http://a1.mp.uc.cn/article.html?uc_param_str=frdnsnpfvecpntnwprdssskt&client=ucweb&wm_cid=195827075242800128&wm_id=1a7f1e3e3793489c9f76a776c6eb1213&title_type=1&pagetype=share&btifl=100&wm_aid=ca9d27e92add43439c3ef35b48c6ca79&sdkdeep=2&sdksid=f0dc3324-5f0a-737b-5e16-ea379e5d0085&sdkoriginal=f0dc3324-5f0a-737b-5e16-ea379e5d0085)
- [内存足够大就不需要设置虚拟内存？](https://zm10.sm-tc.cn/?src=l4uLj8XQ0JWWkZiGnpHRnZ6Wm4rRnJCS0JLQno2LlpyTmtDMmp7KzsvHxs7Pmc7Hx8rNmsnOnZ2ezprRl4uSkw%3D%3D&uid=1bb14c7fc13bbf5ada5972a917c90bdc&hid=a1e424d6ac5089c9c144f2c458a7c4bd&pos=1&cid=9&time=1521305370299&from=click&restype=1&pagetype=0000004002000402&bu=web&query=%E6%9C%8D%E5%8A%A1%E5%99%A8%E8%A6%81%E8%AE%BE%E7%BD%AE%E8%99%9A%E6%8B%9F%E5%86%85%E5%AD%98%E5%90%97&mode=&v=1&force=true&wap=false&province=%E6%B1%9F%E8%A5%BF%E7%9C%81&city=%E5%8D%97%E6%98%8C%E5%B8%82&uc_param_str=dnntnwvepffrgibijbprsvdsdichei)　



## 3. 显卡

### 显卡系列：GeForce/Tesla/Tesla

NVIDIA 的 GPU 产品主要有**GeForce、Tesla**和**Tesla**三大系列，虽然从硬件角度来看它们都采用同样的架构设计，也都支持用作通用计算(GPGPU)，但因为它们分别面向的目标市场以及产品定位的不同，这三个系列的GPU在软硬件的设计和支持上都存在许多差异。

可以这么看：

- GeForce：游戏显卡
- Quadro：专业绘图显卡
- Tesla：专业运算卡，主要进行并行运算，图形运算等  

> 补充：<https://share.iclient.ifeng.com/news/shareNews?fromType=vampire&aid=sub_42630074>
>
> 可能大家不太理解 GeForce、Quadro、Tesla三者的关系，其实这三种产品采用的是同样的GPU，但是根据具体需求的不同，所开放的功能也不一样，也就是老黄的手术刀阉掉的地方也不一样。GeForce作为游戏显卡，其价格在三个产品线当中是最便宜的，而关于游戏性能方面最重要的流处理器数量、单精度运算能力、DirectX的支持度等，都是完整的，但少了一些高级功能。而Quadro显卡相较于GeForce显卡，加入了完整的OpenGL支持，并且在顶级型号上加入了ECC显存。Tesla系列相较于GeForce系列则是去掉了显示接口，并且在高端型号上使用了支持双精度运算的GPU以及ECC显存。
>
> 
>
> 然而理论计算性能方面，采用相同GPU的Quadro显卡和GeForce显卡在计算能力上与昂贵的Tesla计算卡并没有什么区别，只是GeForce系列的显存容量一般相对较少。这样一来，许多预算吃紧的深度学习用户就会选择相对便宜的GeForce显卡来用作深度学习计算使用。目前GeForce 1080 Ti的价格为699美元，国内售价一般在6000元上下。Titan Xp的价格1200美元，国内售价一般为12000元左右。但是Tesla的价格可就不这么美丽了，入门款的 K80的价格都要高达3399美元，大约是40000左右人民币，而高端一点的Tesla P100的价格是5150美元，国内售价在50000元左右。

其中 Quadro 的定位是专业用途显卡而 Tesla 的定位是专业的 GPGPU，单价相对较高，也都很少会被用作其他用途。但面向消费者的 GeForce 显卡却因为出货量大，价格较低的缘故经常被当作另外两个专业产品的替代品来使用。

**生产厂商：**

**Tesla系列产品全部由NVIDIA原厂设计和生产，**产品品质和服务都更有保障。**GeForce显卡则主要由第三方厂商生产，**而且还区分为采用原厂设计的公版型号和厂商自行设计的非公版型号，其产品的稳定性可能也因不同厂商的设计和工艺水平存在差异。

**芯片及启用核心数量的差异：**

虽然同一代的GPU产品都采用相同的核心架构，但不同型号的GPU采用的是不同等级的GPU核心，比如作为Tesla系列旗舰的P100采用的是GP100核心，而P40和P4则分别采用的是GP102和GP104核心，在GeForce系列产品里，则还有采用更低的GP106/107/108等型号核心的产品。

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190616164935.png)

(略。。。)

参考：

- [【立尔讯】NVIDIA GPU—Tesla和GeForce之间的区别](<http://www.learsun.com/Article/lexnvidiag.html>)
- [小科普 | “专业显卡”有什么用？ - 哔哩哔哩](<https://www.bilibili.com/read/cv7472/>)

### 显卡架构：Tesla/Kepler/Fermi/Maxwell/Pascal/Volta

相关阅读：

- [NVIDIA显卡架构代号的另一面：他们都是伟大的科学先驱 - 超能网](<https://www.expreview.com/57805.html>)





## 分区助手使用实操


以下为本人在 Windows 7 下使用「分区助手」的实践和心得：

假设你已经对一块硬盘分好区了，分区盘符分别为：E、F，并且 E、F盘下各有文件。实践心得如下：

1、我的一些实践：

1. 对未分配的硬盘「创建分区」，只会创建出一个分区，并且该分区默认为主分区，默认SDD分区 4k 对齐。
2. 可以点击整个磁盘，然后选择「快速分区」，可以一次性分很多区
3. 对主分区进行「创建分区」或「切割分区」操作，分出来的新区都是主分区
   1. 可以把新的分区转为逻辑分区 【注：转换过程，盘符里的文件不会被删除。】
   2. 也可以对原来的主分区转为逻辑分区，但这会多出一个 7.84M 的无盘符分区（电脑上不会显现）。【注：转换过程，盘符里的文件不会被删除。】
4. 逻辑分区可以转为正常主分区【注：转换过程，盘符里的文件不会被删除。】
5. 主分区和逻辑分区进行合并会变为主分区；逻辑分区和逻辑分区合并还是逻辑分区
6. 对 MBR 硬盘转换到 GPT 硬盘，对 GPT 硬盘转换到 MBR 硬盘，都不会删除盘符的文件，也没多出无盘符的隐藏分区之类的。
7. 在对已经安装好的系统的分区进行分区，会有提示一些提示，如重启，之后自动重启后，发现出现 `AOMEI Partittion Assistant PreOS Mode` 执行 Analyzing volume 界面。【所以，最好还是不要对已经安装了系统的盘符再分区】

2、关于切割分区  

可以对任意一个盘符切割出新的分区，原分区文件不会被删除，并且新的分区盘符字符递增，如对 E 盘在切割分出一个新的分区，新的分区盘符为：G。

注意：新的分区 G 盘，在「分区助手」软件中显示和 E 分区是相邻的。

本人的亲身实践：

- 我要进行的操作：UEFI 方式安装的 win10， 对已安装了系统的 C 盘与未分配分区进行合并。本人用分区助手进行合并操作，会有个类似 `...重启后在下次进入系统前程序将进行在PreOS模式来实现这些分区操作` 的提醒，忽略继续执行，电脑重启，最后未成功合并，win10 系统也没崩溃。

  后来，本人直接使用系统自带的"磁盘管理"合并成功，操作类似为：D盘合并到C盘，如果是D盘有文件的话，是没办法搞的。所以要先备份D盘，然后在磁盘管理里面删除分区，这个时候再在C盘上点右键，扩展分区。参考：https://www.zhihu.com/question/68409041

- 

3、关于合并分区  

只能对相邻的分区进行合并。如上面情况，只能对相邻的 E、G 合并，或 G、E 合并。合并后各自盘符的文件还会存在，比如点击 E 分区，合并 G 分区，那么合并后的新的分区则会把 G 盘的所有文件保存在 `G-drive-xxxxxx` 这个文件夹下。 参考官方教程：[怎么合并分区](https://www.disktool.cn/jiaocheng/merge-partitions.html) 



## 问题汇总

### 1）内存条低压和标压可以混装吗？

经过我的查询和实验，确定现在的低压和标压条子是可以混用的。一般的内存条插口为了兼容标压条子，都是 1.5v 接口，所以 1.35v 的低压和 1.5v 的标压内存条都可以用。兼容问题上，网上有人说混用后 1.35v 的会自动升压到 1.5v，这也许是多年前的答案了，那时候的条子可能在里面仍然有 1.5v 的模块。而我这条 14 年的低压条子和标压混用后没有自动升压，cpu-z 检测出来的电压仍然是 1.35v。没有出现问题，一切正常，性能也能发挥完全，频率这些也没出问题。现在的电子产品都将兼容性考虑得很好，所以在这类问题上不必过于担心。

参考：[内存条低压和标压可以混装吗？ - 知乎](https://www.zhihu.com/question/27327665)

DDR4 2400内存可以在最高支持DDR4 2133内存的主板正常使用；反之，DDR4 2133内存也可在支持DDR4 2400内存的主板上安装使用。但内存会按两者中较低频率（本例中为2133MHz）运行。——from：http://ask.zol.com.cn/x/5585033.html

### 2）Mac OS 下如何对 NTFS 格式硬盘写？

参考方法1：[Microsoft NTFS for Mac by Paragon Software](<https://china.paragon-software.com/home-mac/ntfs-for-mac/>) 

> 我们知道，Windows 和 macOS 都是最主流的电脑操作系统，但是两者关系却并不那么友好：两个系统使用完全不同的文件格式，且互不兼容！Windows 系统对苹果的 HFS+ 文件完全无法读写，而苹果电脑的 macOS 对现在 Windows PC 上最主要的 Mocrosoft NTFS 文件系统也仅仅提供了阅读的支持。那意味着你无法在 NTFS 分区中创建、删除或者修改文件或文件夹。对想在苹果电脑上使用 Mocrosoft NTFS 分区、移动硬盘或者是双系统的用户来说，这是件非常麻烦的事情。
>
> Microsoft NTFS for Mac by Paragon Software 就是用来解除您这个烦恼的！通过 Microsoft 的 NTFS for Mac by Paragon Software，您可以在 macOS 下高速安全地对 Microsoft NTFS 分区文件进行读读取、编辑、修改、删除的任何操作。为您的跨平台文件管理带来极大的便利。



## 4、Windows、Linux、Mac OS 区别

[一分钟看懂WINDOWS系统、LINUX系统和苹果操作系统到底有什么区别？](https://www.gonet.com.cn/webduirshow-166.html)

![](https://www.gonet.com.cn/~editor/eweditor/uploadfile/20171027141729471.png)

在这个问答中「[windows系统,Linux和mac os x本质区别是？？？](https://zhidao.baidu.com/question/376563438.html)」有人写道：

> 系统构架不一样 内核不一样
> Linux开源，Mac OS X和Windows闭源，但是Mac OS X基于Darwin，Darwin是半开源的，Windows 基于Windows NT，Darwin基于BSD，Linux是类Unix 因为基于Minix， Minix基于BSD ，so Linux和Mac OS X有些微妙的关系

这个问答「[Mac OS与Linux的区别与联系](https://ask.csdn.net/questions/167343)」中有人说道，引用下：

> 没有外设厂家驱动的支持，os只是一个汽车的发动机而已，普通用户谁会买个发动机玩？！

什么意思呢？以我现在的认识，是这样理解的：操作系统可以管理硬件、进行内存管理等工作，但假如你想要让电脑的产生声音，必定是有个声卡硬件，即你现在需要让声卡发出声音，你必定需要安装对应操作系统的声卡驱动，这样才能让声卡发声。所以 Windows 下你需要安装 Windows 版本的声卡驱动，Linux 下你需要安装 Linux 版本的声卡驱动。那么你可能要问，驱动到底是什么？这个可以网上搜索，现引用网上一些回答：

> A：驱动程序一般指的是设备驱动程序（Device Driver），是一种可以使计算机和设备通信的特殊程序。相当于硬件的接口，操作系统只有通过这个接口，才能控制硬件设备的工作，假如某设备的驱动程序未能正确安装，便不能正常工作。
>
> B：驱动就是各个硬件的软件，比如显卡有显卡驱动，鼠标有鼠标驱动，驱动也可以从字面上来理解，就是驱动硬件工作，如果没有驱动，硬件将无法工作或是无法正常工作，你能忍受你的电脑没有显示，鼠标不能用，键盘不能用，电脑没声音么？所以驱动是很重要的系统软件。

看望上面的可能还不是很理解，再看看这篇文章：[驱动工作原理](https://jingyan.baidu.com/article/aa6a2c142f4b750d4c19c482.html)，我引用些觉得需要理解的语句：

> 设备驱动程序用来将硬件本身的功能告诉操作系统，完成硬件设备电子信号与操作系统及软件的高级编程语言之间的互相翻译。当操作系统需要使用某个硬件时，比如：让声卡播放音乐，它会先发送相应指令到声卡驱动程序，声卡驱动程序接收到后，马上将其翻译成声卡才能听懂的电子信号命令，从而让声卡播放音乐。
>
> 我的理解和解释：打个比方，比如你自己生产了某硬件——比如打印机，你得让打印机工作对不对，你自己设计的打印机，Windows 哪知道怎么去让它工作，毕竟你这个硬件不是像鼠标、键盘这样是电脑标配啊，所以你连接上 WIndows 系统是不能工作的，但你可以根据 **Windows 硬件接口**规范去实现驱动程序，即编写相应打印机的驱动程序安装到操作系统上。Windows 硬件接口该怎么理解？我的理解，Windows 已经能知道管理内存、IO 等工作，你设计的打印机也必定会用到内存、IO 等，你基于此，自己再去实现基于这些的“延伸”——即，你对你的打印机的再去设计相应程序指导它工作。
>
> 相关文章看看：
>
> - [操作系统、驱动和硬件的关系的思考](https://blog.csdn.net/qq_38880380/article/details/78327825)
> - [软件是如何驱动硬件的，代码是怎样对计算机实现控制的？](https://blog.csdn.net/mixika99/article/details/53234136)

另外你也可能会问为什么安装完操作系统后一般键盘、鼠标等着这些可以正常使用？——那是因为电脑系统以及自带了它们的驱动了。

# 二、单独安装：Windows 系统

## 1. 安装 Win7

非常简单。

1、方法一：使用 U 盘启动盘

1. 先制作一个 U 盘启动盘
2. 设置电脑 Bios 或者直接按电脑某键直接进入快速启动选择界面
3. 进入 PE 
4. 重装
   1. 使用还原方法（以前以为只有 Ghost 版的系统才可以使用该方法，后来发现原版系统也可以还原，但是还原之后，可能存在第三方些软件，这和你使用制作 U 盘启动盘的厂商有关）
   2. 使用安装原版的方法（略）

2、方法二：系统刻入进 U 盘

使用 UltraISO 软件可以直接把系统刻入进去 U 盘，然后安装。这里就略过了。自行网上搜下。



## 2. 安装 Win10

安装 Win7 方式，同样可以用来安装 Win 10。

但些注意的地方：

（1）在使用 UEFI Bios 方式安装 Win10，要求你安装系统的磁盘是 GPT 分区表格式。否则你可以使用传统 Bios 方式安装，即 Legacy Bios 方式安装，那么你的磁盘可以是 MBR。

（）使用 UEFI Bios 方式安装 Win10，使用方法二安装的时候，有个注意的地方：

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624163535.png)

如上，这里的「选择引导驱动器」选择的是 ESP 那个分区（注：磁盘采用 GPT 分区表格式会存在这么个分区）。



## 3. Windows上安装Mac系统（安装“黑苹果”）

[ThinkPad X220 单硬盘安装 windows + mac os 完全教程]()





# 三、单独安装：Linux(各类发行版)系统

## 1. Ubuntu 安装



## 2. CentOS 安装





# 四、单独安装：MacOS 系统





# 五、VMware 虚拟机安装系统

## 1. 安装 Ubuntu 要点

注：本人使用的 VMware-workstation-full-14.0.0-6661328 虚拟机

### VMware Tools

VMware Tools 是用于增强虚拟机的客户机操作系统性能并改进虚拟机管理的实用程序套件。如果不在客户机操作系统中安装 VMware Tools，客户机性能将缺少重要的功能。安装 VMware Tools 会避免出现以下问题或改进性能：

``` 
- 视频分辨率低
- 色深不足
- 网速显示错误
- 鼠标移动受限
- 不能复制、粘贴和拖放文件
- 没有声音
- 提供创建客户机操作系统静默快照的能力
- 将客户机操作系统中的时间与主机上的时间保持同步
```

VMware Tools 安装后，可以让我们在 Windows 下更好的管理虚拟机。

虚拟机 VMware tools 的作用：

1. 更新虚拟机中的显卡驱动, 使虚拟机中的 XWindows 可以运行在 SVGA 模式下。在客户操作系统中安装 Mware Tools 非常重要。如果不安装 VMware Tools，虚拟机中的图形环境被限制为 VGA 模式图形(640x480，16色)。使用 VMware Tools，SVGA 驱动程序被安装，VMware Workstation 支持最高 32 位显示和高显示分辨率，显著提升总体的图形性能。
2. 在主机和客户机之间时间同步。  注意: 只有当你在客户操作系统中设置时钟为一个比在主机中设置的时间更早的时间时，才可以在客户和主机操作系统之间同步时间。
3. 支持同一个分区的真实启动和从虚拟机中启动, 自动修改相应的设置文件。
4. 自动捕获和释放鼠标光标。未安装 VMware Tools 的时候只能用 Ctrl+Alt 来释放鼠标，安装 VMware Tools 后可以实现虚拟机和主机图形用户界面之间平滑移动鼠标光标。
5. 在主机和客户机之间或者从一台虚拟机到另一台虚拟机进行复制和粘贴操作。
6. 改善网络性能。

**安装的主要步骤：**

1. 点击 VMware Workstation 软件菜单「虚拟机」--> 「安装 VMware Tools」；
2. 弹出对话框，点击是；
3. 此时，会发现虚拟机设备下多了 VMware Tools 这一项，点击它，其里面有一个 `VMwareTools-10.1.15-6627299.tar` 文件；
4. 然后把 `VMwareTools-10.1.15-6627299.tar` 文件提取到某个目录下，比如桌面新建的 myfile文件夹下；
5. 提取完成后会发现桌面的 myfile 里面多了一个 vmware-tools-distrib 文件夹；
6. 使用快捷键 Ctrl+Alt+T 打开终端，然后切换到 vmware-tools-distrib 该文件夹：
7. 然后输入命令：`sudo ./vmware-install.pl -d`，开始安装 VMware Tools了，根据其提示输入 yes/no，直到出现 Enjoy，表示安装成功。注：`-d` 假定希望接受默认设置。如果不使用 `-d`，请按提示接受默认值或提供您自己的答案。

### open-vm-tools 

在后来，本人有次安装完 Ubuntu 18.04，再按照如上方式试着安装 VMware Tools，发现不能成功安装，提示类似如下：

``` xml
open-vm-tools are available from the OS vendor and VMware recommends using open-vm-tools.

See http://kb.vmware.com/kb/2073803 for more information.

Do you still want to proceed with this legacy installer?
```

而后在网上找到篇文章 [在 VMware 虚拟机中安装 open-vm-tools - 知乎](https://zhuanlan.zhihu.com/p/22488904)，大概意思是，open-vm-tools 代替了官方 VMware Tools，又因大部分发行版的官方仓库里面都有 open-vm-tools，所以直接安装即可解决问题，完成安装：

1. Ubuntu / Debian:
    ``` xml
    sudo apt install open-vm-tools
    ```
2. CentOS / Fedora:
    ``` xml
    sudo dnf install open-vm-tools
    ```
3. Arch Linux
    ``` xml
    sudo pacman -S open-vm-tools
    ```

### Intel VT-x

参考：[VMware安装Ubuntu18.04（必会） - 知乎](<https://zhuanlan.zhihu.com/p/38797088>)

上文章提到，需要勾选 Intel VT-x，那这个是什么？

1, <https://blog.csdn.net/xyyangkun/article/details/7518663>

Intel VT 中的 VT-x 技术是 CPU 的硬件虚拟化技术，VT 可以同时提升虚拟化效率和虚拟机的安全性，在 x86 平台上的 VT 技术，一般称之为 VT-x，而在 Itanium 平台上的 VT 技术，被称之为 VT-i。

2, <https://zhidao.baidu.com/question/1824493322902868068.html>

```
英特尔的 VT 虚拟化技术包括分别针对处理器、芯片组、网络的 VT-x、VT-d 和 VT-c 三种技术。

1、针对处理器的英特尔 VT-x 技术：包括英特尔虚拟化灵活迁移技术（Intel VT FlexMigration）、英特尔 VT FlexPriority、英特尔 VT 扩展页表（Extended Page Tables）；

2、针对芯片组的英特尔 VT-d 技术：支持直接 I/O 访问的 VT 虚拟化技术；

3、针对网络的英特尔 VT-c 技术：包括虚拟机设备队列（VMDq）、 虚拟机直接互连（VMDc）。

简单来说：VT 包括 VT-x、VT-d 和 VT-c。VT-x 只是英特尔 VT 技术中的一项。
```

3, <https://jingyan.baidu.com/article/5553fa82bf12b165a3393478.html>

Intel VirtualTechnology(VT)既“虚拟化技术”就是以前众所周知的“Vanderpool”技术，这种技术让可以让一个 CPU 工作起来就像多个 CPU 并行运行，从而使得在一部电脑内同时运行多个操作系统成为可能。

**如何开启？**——网上搜下自己型号的电脑如何在 BIOS 中开启。

惠普 HP 笔记本开启：开机按 F  -> 进入 BIOS -> 

### VMware Workstation 与 Device/Credential Guard 不兼容

另外，我在启动 VMware Workstation 时曾有出现过这个：

``` 
VMware Workstation 与 Device/Credential Guard 不兼容
```

的报错，这是什么问题呢？可以看下这篇文章：[解决Windows10运行VMware Workstation出现与Device Guard不兼容导致无法运行与创建虚拟机问题 - MINIRPLUS](<https://blog.minirplus.com/10268/>)，这里提到原因分析是：

``` 
Windows10开启Hyper-V后与VMware Workstation冲突导致无法运行和新建虚拟机。

一般来说Windows10默认不会打开Hyper-V，但是安装Docker默认会打开Hyper-V。
```

确实，我是在安装 docker 后才出现这个报错。解决方法是：禁用 Hyper-V。以管理员身份打开 PowerShell 或 CMD，输入：`bcdedit /set hypervisorlaunchtype off`，确定，然后重启系统即可。

注意，文中也有提到：

``` 
不要试图在控制面板>卸载程序>打开或关闭 Windows 功能中关闭 Hyper-V，否则在重启后会导致更新配置失败并回滚重启。
```

## 2. 安装 CentOS 要点

注：本人使用的 VMware-workstation-full-14.0.0-6661328 虚拟机

下载：

1. 官网：<https://www.centos.org/download/>
2. CentOS 7 官方阿里云下载地址：<http://mirrors.aliyun.com/centos/7/isos/x86_64/>

本人安装过程，参考的：[VMware 14安装CentOS 7 - 追梦小猿的博客 - CSDN博客](<https://blog.csdn.net/ElliotCs/article/details/79352540>)

选的 GNOME Desktop，即选的桌面版安装。

在新建虚拟机向导的设置中，本人选择的为：“将虚拟磁盘存储为单个文件(O)”选项。注：VMware 安装其他系统，本人也是选择的这个。

**注：发现，不用安装 VMware Tools 或 open-vm-tools 也能全屏。**

## 3. 安装 Debian 要点

注：本人使用的 VMware-workstation-full-14.0.0-6661328 虚拟机

官网下载地址：<https://www.debian.org/distrib/netinst>，Debian 官方默认只提供最新的版本下载，这是点击“小容量安装光盘或 U 盘” 下的 amd64 获取到的链接：

``` 
https://cdimage.debian.org/debian-cd/current/amd64/iso-cd/debian-10.0.0-amd64-netinst.iso
```

本人打算安装 Debian 9.x，于是找到这个链接：<http://cdimage.debian.org/cdimage/archive/>，可以下载各个版本的 debian。也可在下面这些国内镜像下载：

``` 
- 阿里云开源镜像：https://opsx.alibaba.com/mirror
- 网易开源镜像站：http://mirrors.163.com/
- 开源中国：http://mirrors.oschina.net/
```

本人选择了 Debian 9.5 安装，进入到 9.5.0/amd64/iso-cd/ 目录下，选择 `debian-9.5.0-amd64-netinst.iso` 下载，这是实际的下载地址：

``` 
http://cdimage.debian.org/cdimage/archive/9.5.0/amd64/iso-cd/debian-9.5.0-amd64-netinst.iso
```

大小约：291M。

本人安装过程，参考的：[VMware 14 安装debian9.5](http://www.youi.xin/?p=80)。

在安装过程，其中在“选择安装的软件”这个步骤，和文章一致，我选择第一个桌面环境，当然也可以选择其他的图形化界面，如果不选，安装完没有图形化的桌面。然后点击“继续”，它会下载并安装，这个过程时间比较长。

最后，在系统安装完成后，安装 VMware-tools，前面有赘述，就不多解释了，但也如前所述，也遇到安装完，**还是不能全屏的问题，**然后打开终端使用：`sudo apt install open-vm-tools` 安装 opencv-vm-tools 解决了。

> 注：**要是碰到类似权限不够的问题**，可以终端下输入：su，换成超级管理员用户登入，再去安装。

## 4. 安装 MacOS 要点

注：本人使用的 VMware-workstation-full-14.0.0-6661328 虚拟机

本人安装过程，参照的：[VMware 15 安装 MAC OS 10.13 原版（详细图文教程） - CSDN博客](<https://blog.csdn.net/qq_40147863/article/details/84797618>)

但有点不同的是，本人安装过程，并没有关闭 VMware 服务，但最后还是安装成功了的。

### 常见问题01：VMware Workstation 不可恢复错误: (vcpu-0)

开启虚拟机时弹窗：VMware Workstation 不可恢复错误: (vcpu-0) 

**解决办法：**

1. 打开选择的系统的那个目录，找到 wmx 为后缀名的文件，用编辑器打开；

2. 找到 smc.present = “TRUE” 那一行，下面添加一行，内容为：

   ``` 
   smc.version = 0
   ```

### 常见问题02：开启虚拟机时进入 Boot Manager

**解决方法：**

- 1.是你下载的镜像的问题，不要下载 dmg 格式的，下载 cdr 格式的
- 2.是你 cpu 的问题，不支持 AMD 的，就不必再折腾啦

### 全屏问题/darwin.iso

安装完 MacOS 后，VMware 未显示全屏，解决办法，可参照：<https://blog.csdn.net/Jeremy__Lin/article/details/88528811>

即，需要 darwin.iso 这个文件，这是下载地址：[darwin.iso黑苹果专用全屏iso下载v8.5.3](<http://www.itmop.com/downinfo/169305.html>)。

这里解释下这个 darwin.iso 文件：darwin.iso 是 vmware 加载 mac 的安装 Mac 引导光盘，virtual machine 12 以下可用，含 12。VMWare 12 虚拟机如果要安装 mac 系统，如果又要安装 VMware Tools 的话，就需要这个darwin.iso。

如何使用这个文件，就不多说了，文章有步骤。完了之后，重启 mac OS 系统可以看到桌面会有个 VMware Tools  这个，点击它，进行安装。安装完之后，设置"安全性与隐私"下的“允许从以下位置下载的应用”为："App Store 和被认可的开发者"。

要是碰到成功 VMWare Tools 后还不能全屏显示问题。网上找到篇文章，可以用来参考下：[解决VMWare安装Mac系统后无法全屏显示的问题](<https://blog.csdn.net/wenxiran1990/article/details/82700151>)

###  导入 macOS 出现的问题：Attempting to start up from

这里得提下，在导入 macOS 到虚拟机遇到的问题。

**问题1：**

在导入 macOS 后，会报：VMware Workstation 不可恢复错误: (vcpu-0) 这样的错误，前面有提到解决办法。

**问题2：**

解决问题1 后，点击启动系统，然后报了如下类似错误：

```
Attempting to start up from
EFI VMware Virtual SATA CDROM Drive (1.0) … unsuccessful.

```

网上找到了该问题解决方式，很多都有提到该解决方式：

```
1. 在虚拟机的安装目录里找到vmx文件
2. 删掉里面的 firmware="efi"
3. 保存重启虚拟机即可正常安装
```

但实测，按照如上方法，并没解决问题。后通过自己的倒腾，找到了解决办法。操作很简单：

1. 找到导入进来 macOS 后对应的 vmx 文件。

2. 然后修改 guestOS 值为 darwin17-64：

   ```
   guestOS = "darwin17-64"
   ```

即可解决该问题。我猜测是因为在开始安装 macOS 系统，使用了 darwin.iso 文件缘故。

## 说明补充

① 以上在 VMware 中安装的系统过程，在新建虚拟机向导的设置中，本人选择的为：“将虚拟磁盘存储为单个文件(O)”选项。

② 以上在 VMware 中安装的系统，本人内存选择的：2G；硬盘存储空间大概 30~50G；处理器数量为：2，每个处理器的内核数量：2；网络适配器：NAT

③ 以上在 VMware 中安装的系统，本人都勾选了“虚拟化Intel VT-x/EPT或AMD-V/RVI(V)“

以上这些设置，根据自己的情况来设定就好。

查看 RedHat,CentOS 系统版本：

```
cat /etc/redhat-release	
```

查看 macOS 系统是32位还是64位：

``` 
uname -a

x86_64 表示系统为64位
i686 表示系统32位的
```



## VMware Workstation 虚拟机快捷键

常用：

``` 
Ctrl-Alt           返回正常(窗口)模式, 鼠标键盘焦点返回到本机vmware中
Ctrl-G             鼠标和键盘焦点返回到虚拟机系统中
Ctrl-Alt-Enter     进入全屏模式
ctrl+alt+insert    退出全屏
Ctrl-Alt-Tab       当鼠标和键盘焦点在虚拟机中时, 在打开的虚拟机中切换.
Ctrl-Tab           当鼠标和键盘焦点不在虚拟机中时, 在打开的虚拟机中切换. VMware Workstation应用程序必须在活动应用状态上.
Ctrl-Shift-Tab    当鼠标和键盘焦点不在虚拟机中时, 在打开的虚拟机中切换. VMware Workstation应用程序必须在活动应用状态上.
Ctrl-D               编辑虚拟机配置
Ctrl-P               编辑参数
Ctrl-F4              关闭所选择虚拟机的概要或者控制视图. 如果虚拟机开着, 一个确认对话框将出现.
Ctrl-B               开机
Ctrl-E               关机
Ctrl-R               重启
Ctrl-Z               挂起
Ctrl-N               新建一个虚拟机
Ctrl-O               打开一个虚拟机
```

（待补充...



## 各系统密码的更改

能进入系统的情况下更改密码：

1）Ubuntu 下更改用户密码：

``` 
1. 进入Ubuntu，打开一个终端，输入 sudo su 转为root用户。 注意，必须先转为root用户！！！ 
2. sudo passwd user(user 是对应的用户名) 
3. 输入新密码，确认密码。 
4. 修改密码成功，重启，输入新密码进入Ubuntu。
```
2）CentOS 下更改用户密码：

```
使用 passwd 命令可以用来修改用户密码。
$ passwd	
输入以上命令后回车，即可直接输入旧密码以及新密码，修改当前用户的密码。

对于root用户来说，可以直接修改其他用户的密码：
$ passwd <user_name>
```

修改 root 密码：

``` 
如果不是以root用户登录的，请先切换到root用户下， 
执行命令：su root 
然后按提示输入root用户的密码。
```

3）Debian 下更改用户密码：

```
1. 进入 Debian 系统，终端输入：su，换成超级管理员；
2. sudo passwd user(user 是对应的用户名) 
3. 输入新密码，确认密码。 
4. 修改密码成功，重启，输入新密码进入Ubuntu。
```

4）macOS 下更改用户密码：

```
如果您知道自己的密码，并可以使用它来登录您的帐户，则您可以在“用户与群组”偏好设置中更改密码：
1. 从苹果菜单中选取“系统偏好设置”，然后点按“用户与群组”。
2. 从用户列表中选择您的用户名。
3. 点按“更改密码”按钮，然后按照屏幕上的说明操作。

注：如果只有一个用户，点击进入“系统偏好设置”，即可在“通用”下面点击“更改密码”进行更改即可。
```



# 五、实践记录：Win7+Ubuntu16.04

## 安装要点

UEFI/Legacy启动模式区分：

(1)进入系统查看 

运行cmd，然后输入 bcdedit /enum {current} 执行，如果 path 中给出的路径是 winload.efi ，则说明系统是通过 UEFI 模式启动的了

(2)开机时查看 

在开机的时候，如果显示开机画面是主板的 logo，底下加上一个转圈，这应该就是UEFI启动。如果是出现系统开机画面时才出现转圈则是传统 BIOS 启动

(3)进入系统查看 

首先同时按下电脑的win键和r键，打开“运行”(或者直接在开始菜单中打开“运行”） 然后再输入msinfo32，点击确定。 然后就打开了系统信息的窗口。 查看 ”BIOS模式”，写的是UEFI就是UEFI，legacy就是传统BIOS启动。——from：<https://blog.csdn.net/GJXS2017/article/details/80296267>



准备：先 Windows7、Ubuntu 系统镜像准备好，磁盘分出一个区以便安装 Ubuntu。

**Win7+Ubuntu 双系统详细安装步骤：** 

1）先制作 U 盘启动盘（详细制作过程不说了），然后安装常规操作安装好 Windows7（注：本人使用的 legacy 方式安装，分区是 MBR 格式）；

2）然后再安装 Ubuntu 到刚才分出的那个区，安装步骤：

1. 先用 UltraISO 软件制作启动盘，可参照：<https://jingyan.baidu.com/article/3c48dd348bc005e10be358eb.html>；（注：如果最后安装失败，可以试试 Rufus 这个制作启动盘）

2. 制作完毕，然后 U 盘插入电脑，电脑开机根据主板按对应按键用于选择从 U 盘启动，如惠普笔记本选择 F9；

   ![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190602143529.png)

   注：这里补充下内容，总的来讲，设置电脑从 U 盘启动一共有两种方法，第一种是开机时候按快捷键然后选择 U 盘启动，如上；第二种进 Bios 然后设置 U 盘为第一启动项（[点击查看](http://www.upanok.com/jiaocheng/68.html)）。
   
   （利用快捷键启动相对来说比较简单快捷，推荐大家使用，但是如果你的电脑是没有热键选择启动项功能的，建议你第二种方法来设置了。）
   
3. 选择 U 盘进入，然后按照步骤来提示选择对应选项安装即可，注意，在「安装类型」我选择的是「其他类型」，然后进入到分区界面，这里我把我最开始分出的那个区分成了 4 个区，分别是 `/`、交换空间、`/boot`、`/home`，它们的作用可以参考如下：

   | **目录** | **建议大小** | 格式 | **描述**                                                     |
   | -------- | ------------ | ---- | ------------------------------------------------------------ |
   | /        | 10G-20G      | ext4 | 根目录                                                       |
   | swap     | <2048M       | swap | 交换空间                                                     |
   | /boot    | 200M左右     | ext4 | Linux的内核及引导系统程序所需要的文件，比如 vmlinuz initrd.img文件都位于这个目录中。在一般情况下，GRUB或LILO系统引导管理器也位于这个目录；启动撞在文件存放位置，如kernels，initrd，grub。 |
   | /tmp     | 5G左右       | ext4 | 系统的临时文件，一般系统重启不会被保存。（建立服务器需要？） |
   | /home    | 尽量大些     | ext4 | 用户工作目录；个人配置文件，如个人环境变量等；所有账号分配一个工作目录。 |

   注1：具体我的分区分别多大，就不细说了，这个根据用来安装 Ubuntu 的分区大小来细分。

   注2：这里分区我都是选择的「逻辑分区」，网上有说法是，因为原本电脑已经有了一个是主分区类型的引导器。

   !!!另外注意，在进行下一步的时候，别着急点击右下角的「现在安装」，在点击之前，先点击刚才分的 `/boot` 区，并且下面的「安装启动引导器的设置」选择 `/boot` 这个区，然后再点击「现在安装」开始安装。为什么这样？网上有说，如果不这样，那就是 Ubuntu 下引导 Windows 启动，假设 Ubuntu 系统出问题了，Windows 可能也很难进去了；这样做了，就可以在 Windows 引导 Ubuntu 的启动。详细参考网上的解释看看。

4. 后面设置用户名等等。

注意，在安装过程可能出现：

``` xml
the grub-efi-amd64-signed package failed to install into /target/.
```

类似错误提示。本人重复安装好几次还是这样，还是这样的提示。后面我尝试对于第一步的步骤，使用 [Rufus](<https://rufus.ie/zh_CN.html>) 制作启动盘，后面安装成功。这里放一个 Rufus 如何安装的链接供参考：[使用Rufus 3.4制作Ubuntu 18.04.1 U盘启动盘的方法](<https://ywnz.com/linuxjc/3978.html>)

安装 Ubuntu 系统后，然后拔出 U 盘，开机进入 Windows7 系统，下载安装 EasyBCD 工具进行设置。我是这样设置的：选择“Add New Entry” -> 选择“Linux/BSD” -> 选择“GRUB(Legacy)” -> Name自己取 -> Device 选择 Ubuntu 的 `/boot` 分区 -> Add Entry。在 “Edit Boot Menu”中选择「等待用户选择」。然后电脑重启开机可以看到 Windows7+Ubuntu的选择了。

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190602153412.png)

注意：看网上很多人在“Linux/BSD”选择的是 GRUB2，我猜可能是因为他们采用的 uefi 模式安装和启动吧。

可能出现的问题的解决方式，供参考：

(1) 安装出现错误：the grub-efi-amd64-signed package failed to install into /target/.

解决方式参考1：<http://keep.01ue.com/?pi=731030&_a=app&_c=index&_m=p>

解决方式参考2：<https://www.cnblogs.com/xiaojieshisilang/p/9334095.html>

解决方式参考3：<https://blog.csdn.net/qingsong3333/article/details/80863293>

解决方式参考4：<https://blog.csdn.net/qq_29985391/article/details/78663823>

> 1、给Linux Ubuntu 分区的时候，我没有单独分boot分区，只分了 \(根分区)和Swap(交换分区)。
>
> 2、(我的电脑是支持UEFI的)进入BIOS，找到BootMode，有三个选项Auto 、UEFI Only、Legacy Only。  选择Legacy       Only（传统模式）。
>
> 3、之后保存重启进入GNU GRUB进行选择。
>
> 4、UEFI和Legacy 
>
> ​	可扩展固件接口（Extensible Firmware Interface，EFI）是 Intel 为全新类型的 PC 固件的体系结构、接口和服务提出的建议标准。　其主要目的是为了提供一组在 OS 加载之前（启动前）在所有平台上一致的、正确指定的启动服务，被看做是有近20多年历史的PC BIOS的继任者。
>
> ​	由于电脑教育普及，很多人都知道BIOS就是Basic Input/Output System，翻成中文是“基本输入/输出系统”，是一种所谓的“固件”，负责在开机时做硬件启动和检测等工作，并且担任操作系统控制硬件时的中介角色。
>
> ……

(2) Win7 和 Ubuntu 双系统时间不一样问题

解决方法1：

- 修改 Windows 对硬件时间的对待方式，让 Windows 把硬件时间当作 UTC（需要重启），在命令提示符下输入：

  ``` xml
  Reg add HKLM\SYSTEM\CurrentControlSet\Control\TimeZoneInformation /v RealTimeIsUniversal /t REG_DWORD /d 1
  ```

  即可成功解决。

参考来源：<https://blog.csdn.net/zyqblog/article/details/79318955>

(3) 开机界面多余的选项

- [ubuntu删除开机界面中多余的选项](<https://blog.csdn.net/ztl0013/article/details/7936134>)
- [ubuntu 引导修复，grub2多余选项删除](<https://blog.csdn.net/u013270341/article/details/79005827>)

相关阅读：

- 知乎：[怎样安装 Windows 7 与 Linux 的双系统？](https://www.zhihu.com/question/19867618)
- [Win7与Ubuntu 16.04双系统安装教程](https://luozm.github.io/win-ubuntu)
- [Windows下安装Ubuntu 16.04双系统 ](https://www.cnblogs.com/Duane/p/5424218.html) 

安装双系统参考教程：

- [Linux探索之旅 | 第一部分第四课：磁盘分区+完成Ubuntu安装](https://www.jianshu.com/p/53b8b76439d0)
- [Win7下硬盘安装Ubuntu 12.04.3双系统](https://www.bbsmax.com/A/gVdnNVREdW/)
- [win7下硬盘安装win7+linuxUbuntu双系统方法](https://www.bbsmax.com/A/GBJrWZrG50/)



# 六、实践记录：Win10+Ubuntu18.04

## 1. UEFI 启动模式下的安装（UEFI Bios）

### 0) 安装 Win10

#### win10 各个版本区别

本人下载的在【[MSDN我要告诉你](<https://msdn.itellyou.cn/>)】网站最新的 Windows 10,Version 1903(Updated June 2019)，选择的为：`Windows 10 (consumer edition), version 1903 (updated June 2019) (x64) - DVD (Chinese-Simplified) `，下载地址：

``` xml
ed2k://|file|cn_windows_10_consumer_edition_version_1903_updated_june_2019_x64_dvd_cedfd58d.iso|5126440960|73CC4AC1F0FA133E76DA82ECE0A3B240|/
```

``` xml
文件名: cn_windows_10_consumer_edition_version_1903_updated_june_2019_x64_dvd_cedfd58d.iso
SHA1: 941f0b57498128d120a0985bd87a66dfdf25cd6a
文件大小: 4.77GB
发布时间: 2019-06-19
```

在那个网站还有 business edition 版本，什么意思呢？我们来看一个帖子下对于 Business Edition 和 Consumer Edition  区别的说法：

```
某某1：

Consumer 为零售版，Business 为批量版
Consumer editions 包括：家庭版、家庭单语言版、教育版、专业版、专业教育版、专业工作站版。
Business editions 包括：专业版、企业版、教育版、专业工作站版、专业教育版。

某某2：

用大白话说，consumer 可以用 tb10块的key激活，business 只能 vol 批量激活(就是 kms 激活) 。

——from：<https://bbs.nga.cn/read.php?tid=14156789&rand=395>
```

关于 win10 的各个版本的区别可以看下这个：[Win10七大版本区别在哪？Win10哪个版本最好用？-太平洋电脑网](https://www.pconline.com.cn/win10/1086/10863673.html)

> Win10家庭版、Win10专业版、Win10企业版、Win10教育版、Win10移动版、Win10移动企业版、Win10物联网版。

#### win10 安装和激活

先安装 Windows 10，这里就记录了，正常操作就可以。【**注：本人发现按安装完 Win10，各种驱动都已经有了， 包括无线网卡驱动，并不需要去单独找驱动安装。**】

**如何激活 Win10？？** 本人安装的为 Win10 专业版，使用的如下方式激活，成功激活 Win10。

这里可以先看看【[win10永久激活方法（真正永久激活）](<https://jingyan.baidu.com/article/9113f81b4d49232b3314c75e.html>)】：

> win10 的花费不低，所以很多电脑用户选择搜索激活，但是大部分用的激活工具激活的基本上都是假激活（或许本来就是），kms 激活和试用账号临时激活都是有时间限制的，虽然到时都可以继续，但是系统还是明确此激活为假激活，并没有真正激活，下面是真正永久激活教程。

看完永久激活方法，可以参照这个博文来，【[Windows10 专业版激活 【3秒激活 亲测有效】](https://blog.csdn.net/weixin_38327420/article/details/83182062)】，和上面的永久方法一样。操作步骤我总结如下：

```
1、Win+R 打开 CMD，注意：如果遇到没有权限或是别的问题，请用管理员身份打开：按 Win 键，搜索 cmd，以管理员身份打开；
2、输入命令：slmgr.vbs /upk 执行，此时弹出窗口显未“已成功卸载了产品密钥”；
3、接着输入：slmgr /ipk W269N-WFGWX-YVC9B-4J6C9-T83GX， 弹出窗口提示：“成功的安装了产品密钥”；
4、继续输入命令：slmgr /skms zh.us.to， 弹出窗口提示：“密钥管理服务计算机名成功的设置为zh.us.to”；
5、接下来输入以下命令：slmgr /ato，此时将弹出窗口提示：“成功的激活了产品”。
```

按如上操作，成功激活。**注：我发现在安装过程选择的是“专业教育版”，按如上步骤激活成功后，版本变为了“专业版”。**

下面主要记录下安装完 Win10 后安装 Ubuntu 的要点。

### 1) 关闭快速启动

先禁用 Windows 10 快速启动，不知道是不是必须，如果进不了选择启动项，请先禁用快速启动。

如何禁用？按住 Win + X，选择“电源选项”，依次执行："选择电源按钮的功能" -> "更改当前不可用的设置" -> 取消选择"启用快速启动(推荐)"。——from：注： “快速启动”是Windows 8时代引进的新特性，建议关闭该特性的原因是，“快速启动”会影响 Grub 开机引导过程，可能出现无法载入 Ubuntu 的状况，最后选择“保存修改”。——from：<https://www.jianshu.com/p/d79821e9fdbe>

### 2) 开始安装 Ubuntu

主要参考：[UEFI启动模式下的Win10+Ubuntu双系统安装指南 - 知乎](https://zhuanlan.zhihu.com/p/35376135)

UEFI BOIS 和 Legacy BOIS：[UEFI BIOS和 传统BIOS 启动模式对比](<https://blog.csdn.net/loveanao/article/details/49281589>)，以下有摘入部分内容。

**传统 BIOS 开机流程：**



![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624173158.png)

从你按下主机机壳上的电源键，到进入作业系统的期间，储存於主机板上那颗 EEPROM（电气可抹除暨可程式化唯读记忆体）裡的 BIOS 便会开始执行以下的工作：

1. 初始化
2. POST（Power On Self Test；开机自我检测）
3. 记录电脑系统的设定值
4. 提供常驻程式
5. 载入作业系统

**UEFI BIOS 系统的开机流程：**

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624173448.png)

1. SEC 阶段
2. PEI 阶段
3. DXE 阶段
4. TSL 阶段

在继续探讨何谓 UEFI BIOS 之前，先来看看传统 BIOS 有哪些问题，让 Intel 决心带头推出 UEFI BIOS。

1. 过时的16位元模式
2. 只有1MB定址空间
3. 组合语言难维护
4. 十年不变的程式码

UEFI 的版本发展：

最初制定的 EFI 版本 2000 年 12 月的 1.02 版。在 2002 年的 12 月又释出了加入EFI驱动程式模型的 1.10 版。于 2005 年，Intel 将此规格提供给负责 UEFI 开发和推广的 UEFI 论坛。為了反映这点，EFI 也被更名為 UEFI。在大部分的文件资料中，EFI 和 UEFI 讲的是一样的东西。

......

UEFI BIOS 哪裡好？

1. 定址空间更弹性
2. 什麼系统都能用
3. 开发维护更容易
4. 精简系统用途大

（略。。。）

END。

现在的电脑大多数使用了 UEFI BIOS 引导系统（原来都是使用传统 Legacy BIOS），从而加快启动速度，但同时也给用惯传统 BIOS 的用户带来很多困惑！电脑不能识别制作好的 U 盘 PE 系统了。

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624174009.png)

（略。。。）

关于安装过程的如何分区就不细讲了，不用和别人一致，根据自己实际情况合理分区就行。不过在这里要提下，原文作者没有自己另外新建 efi 分区，文中写到：

> 1）最终用的引导区（/boot）应该安装在支持EFI的分区，我选择安装在了Window引导分区下，一般单个系统引导区设为300MB左右，据说重新划区安装也没问题，这里没有尝试。
>
> ![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624174904.png)

作者这里的做法是：把 Ubuntu 启动引导安装在 Windows 引导分区下。【注：我亲测这是可以的】

但我也有看到有另外新建一个 efi 分区，然后把 Ubuntu 启动引导安装在自己另外新建的 efi 分区。如何新建，参考如下：

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624175557.png)

**注意**：它的作用和 boot 引导分区一样，但是 boot 引导是默认 grub 引导的，而 efi 显然是 UEFI 引导的。不要按照那些老教程去选 boot 引导分区，也就是最后你的挂载点里没有“/boot”这一项，否则你就没办法UEFI启动两个系统了。——from：<https://blog.csdn.net/DeMonliuhui/article/details/77483523>

另外，如果我们有两个磁盘，并且想要把 Ubuntu 安装在第二个磁盘，其实我们也可以在安装过程中选择清除磁盘安装，点击下一步，选择第二个磁盘即可，这样也不用你进行上面的分区，应该是有默认给你分区的。但最后的结果是，你可能重启会直接进入 win10 系统，没有选项让你选择哪个系统进入，但你能在电脑重启过程，按某个快捷键（根据电脑来）选择启动的方式进行选择你需要进入的磁盘，这里即第二个磁盘，这样就可以进入 Ubuntu 了。

### 3) Linux 分区了解下

这里关于 Ubuntu 的分区了解下仅参考，来源【<https://blog.csdn.net/DeMonliuhui/article/details/77483523>】

**1.swap交换空间**：虚拟内存地方。

``` xml
大小：与电脑内存一致即可，最小不能低于电脑内存的一半。小了不够用，大了没用。
新分区的类型:主分区
新分区的位置：空间起始位置
用于：交换空间
```

**2.efi系统分区**：系统引导文件都会在里面。 

``` xml
大小：大小最好不要小于256MB，系统引导文件都会在里面，我给的512MB。
新分区的类型:逻辑分区（这里不是主分区，请勿怀疑，老式的boot挂载才是主分区）
新分区的位置：空间起始位置
用于：efi系统分区
```

注意：它的作用和 boot 引导分区一样，但是 boot 引导是默认 grub 引导的，而 efi 显然是 UEFI 引导的。不要按照那些老教程去选 boot 引导分区，也就是最后你的挂载点里没有“/boot”这一项，否则你就没办法 UEFI 启动两个系统了。

**3./home**：这个相当于你的个人文件夹，类似 Windows 里的 User，如果你是个娱乐向的用户，我建议最好能分配稍微大点，因为你的图片、视频、下载内容基本都在这里面，这些东西可不像在 Win 上面你想移动就能移动的。

``` xm
大小：最好不要低于8GB，我Ubuntu分区的总大小是64GB，这里我给了30G给home。
新分区的类型:逻辑分区
新分区的位置：空间起始位置
用于：EXT4日志文件系统
挂载点：/home
```

**4./**：因为除了 home 和 usr 还有很多别的目录，但那些都不是最重要的，“/”就把除了之前你挂载的 home 和 usr 外的全部杂项囊括了。

``` xml
大小：8G左右。
新分区的类型:逻辑分区
新分区的位置：空间起始位置
用于：EXT4日志文件系统
挂载点：/
```

**5./usr**：这个相当于你的软件安装位置，Linux下一般来说安装第三方软件你是没办法更改安装目录的，系统都会统一地安装到 /usr 目录下面。

``` xml
大小：这个分区必须要大，把剩余的空间都给它就对了。
新分区的类型:逻辑分区
新分区的位置：空间起始位置
用于：EXT4日志文件系统
挂载点：/usr
```

**6.设置安装引导的启动设置**：找到类型为 efi 的设备，如图：/dev/sda7，然后在安装启动引导器的设置，选择上面对应的设备。

### 4) 系统选择界面

安装完双系统，开机启动，进入系统选择界面类似如下：

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624183214.png)

分别选择 Ubuntu、Windows Boot Manager 能分别进入 Ubuntu、Windows10。但是这个系统选择界面很想改掉，比如去除多余的两项、设置启动系统选择的时间等。我在 Win 下安装了 EasyBCD 软件想修改下，发现 Linux/BSD 下的是不能修改的，如图：

![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190624183812.png)

这个问题，待以后再说吧。



## 2. 传统启动模式下的安装（Legacy Bios）

[windows 10中安装ubuntu-实现双系统 - 知乎](https://zhuanlan.zhihu.com/p/31271077)





---



## 遇到的坑

以下为在安装实验室服务器（CPU：至强 E5-2620v4，主板：技嘉x99 ud4）安装 Window7+下的遇到的问题。

**问题 1：**

Win7 下安装双系统，cpu 是第六代 cpu，采用u 盘进入 pe 安装的方式，在安装到「选择国家和语言」页面的时候鼠标和键盘都不能动，这里的问题原因是：第六代及以上 cpu 使用 u 盘方式安装，不行，因为不支持 usb3.0 什么的....  后面改为：使用 Ultraiso 软件刻入 Win7 系统至 u 盘，然后安装一个`Smart Tool`工具，写入驱动，就可安装成功了。

Smart Tool 使用方法：选择`Add USB drivers`，然后选择`USB storage`选择已刻入系统之后的U盘，再勾选`add NVMe driver`，点击`Start`即可。

以下列出参考资料，以后保不准可能用到：
- [安装WIN7加载识别USB3.0驱动的解决办法](http://blog.csdn.net/weiganliu/article/details/77234528)
- [win7原版映像中添加usb3.0驱动](http://blog.csdn.net/g_newbie/article/details/60578199)
- [向win7旗舰版U盘启动盘 添加usb3.0driver](http://blog.csdn.net/xforce_zuoxiang/article/details/52669298)
- [如何给Win7安装镜像注入usb3.0和nvme驱动](https://tieba.baidu.com/p/5175759153?traceid=)

**问题 2：** 

Win7 下安装 Ubuntu，关于安装过程 Ubuntu 分区的问题： 先设置 500M 主分区，格式类型选 ext4，挂载到 `/boot`；剩下可以全为 逻辑分区，格式为 ext4，挂载到`/`  ，其中这里虚拟内存可以不用（即不设置 swap 分区）。


注：第一，安装系统的时候选择安装在 `/boot`这个主分区的位置，这是启动分区；第二，Ubuntu 最多 4 个主分区；第三，Linux 分为启动 根分区 交换分区（swap）


Ubuntu 下修复引导。引导 win7 出来（网上方法）：

1, `sudo gedit /etc/default/grub`修改，`sudo update-grub`

2, `sudo gedit /boot/grub/grub.cfg` ,文件最后添加如下内容：
```
menuentry 'Win7' {
set root=(hd0,1);
ntldr /bootmgr
boot
}
```



---





# 七、如何彻底清除硬盘数据

参考方法：

（1）[如何彻底清除数据 防止文件被恢复 - 知乎](<https://zhuanlan.zhihu.com/p/23934273>)

将文件拖入回收站然后再将回收站清空，数据就真的被删除了吗？其实，数据并没有被真正从硬盘上清除，只是表面上的删除操作。就像是将一本书中的目录撕掉，但是目录对应的内容并不受影响。这是为什么呢？首先了解一下操作系统存储和删除数据的工作原理。电脑在向硬盘写入数据的时候，除了需要保存数据本身还需要将文件名、大小、创建时间等进行保存。这些文件信息被称为“文件头信息”，系统将他们与文件数据本身保存在分开的两个区域。“文件头信息”就好比是书本的目录部分，方便系统查找、定位和读取数据，文件数据是书籍的正文。操作系统在删除文件的时候，并不是将所有与这个文件相关的信息全部删除，而是将这个文件标记为已删除，将该文件占用的磁盘空间标记为空闲。因此，当一个文件被删除后，只有“文件头信息”里面的一小部分数据收到影响，文件数据都依然保留在硬盘上。由于数据被标记为删除，用户是看不到被回收站清空的数据的。

数据恢复技术就是基于该原理，开发数据恢复软件，让数据恢复成为很简单的一样任务。所以当入手新的电脑或是硬盘后，旧的设备不要轻易送人或是出售。即便硬盘已经被格式化或是数据被删除，但是，如果不法分子拿到你的硬盘并进行了数据恢复，进行窃取个人资料。近几年，类型的事情时有发生。

对于有一点电脑基础的用户，可以尝试使用专业的数据销毁工具。平时最为常用的方法是逻辑层面的数据擦除，可以使用相关的软件完成，可以达到数据清零的效果，防止数据恢复软件进行恢复。当然了，军用或是企业级的数据销毁设备效果会更好，不过普通用户没有必要使用。下面介绍几种简单实用的彻底数据清除的方法。

方法一：慢速格式化

使用电脑对分区或是U盘等存储设备进行格式化的时候，将“快速格式化”选项前面的勾去掉（如下图）。这种方式进行格式化可以称为慢速格式化，整个过程需要的时间比较长，但是效果可以达到清零的效果，这样操作后，一般的数据恢复软件只能搜索到一些系统文件。

2）[清除扇区的作用，与删除分区有和不同？ - 知乎](<https://www.zhihu.com/question/43010685>)

回答1：

> 扇区不是分区……大家都知道，硬盘上面“写着”1和0。
> 清除扇区数据是把硬盘上某个区域（或者整个硬盘的用户区域）的1全部擦掉成0，这样操作的硬盘数据是无法用任何数据恢复软件来恢复的；
>
> 但如果删除分区，那么仅是将这个区域的文件分配表，文件格式，MBR之类的数据头部删掉而已，文件本身还在。仅仅删除分区，通过数据恢复软件是可以轻易恢复出数据的。普通的格式化同理。

回答2：

> 使用 Diskgenius 软件清除硬盘的数据不会损伤硬盘。 
>
> 基本所有的分区软件都支持清除硬盘数据的功能。
>
> 清除数据的方法基本都是通过向需要清除的区域的所有存储扇区写零，来达到覆盖原有数据，防止文件被不法人员回复的目的。这个写零的操作只是硬盘正常的写操作，和硬盘使用过程中写文件是没有区别的，所以不会对硬盘造成任何损伤。 但同时，此操作除了针对数据恢复的安全性也没有任何意义。

（3）<https://zhuanlan.zhihu.com/p/22493667>

1. 使用“DiskGenius分区工具”，双击磁盘进行选择需要彻底删除文件或文件夹，鼠标右键选择“彻底删除文件”；
2. 打开彻底删除文件窗口，可以选择用字符对文件数据进行填充，删除 ntfs 分区请勾选“删除$MFT中的文件记录”，选择完毕按下“彻底删除”按钮；
3. 随后软件会弹出提示窗口，警告用户文件彻底删除后无法进行恢复，确认无误点击“确定”选项。



# 八、一些问题

## 系统安装

**win10 下安装 ubuntu 到移动硬盘？**

在 win10 下，某次安装 Ubuntu 18.04 到新买的移动硬盘，安装过程出现“...使用磁盘的最小对齐，这可能造成非常差的性能...”这样的错误，后搜索网上资料，查阅到说是用 DiskGenius 软件进行 Linux 分区，并 4k 对齐，但我下载了该软件，并没看到那个分区格式。后来找到 “**MiniTool**” 软件解决了：该软件可以分区为 ext 格式。分完之后，再去安装 Ubuntu，安装过程对分的区重新选择挂载即可（这里不要勾选格式化）。

这里有个问题，安装完 ubuntu 到移动硬盘，拔掉移动硬盘后，win10 进不去了：每次开机显示 grub 命令画面。**这里我猜测是：** 是因为安装 ubuntu 过程，选择了引导安装在整个硬盘，这样会导致“由 ubuntu 引导 win10”，如果想“由 win10 引导 ubuntu”，估计是要引导安装在 `/boot` 分区。这其实也是我目前猜测，写下来只为当记录。

**引导如何修复？**

那进不去 win10 怎么办？这种情况，那相当说 win10 的引导出问题了，怎么办呢？在我的实践下，我下载安装了 **“快启动” U盘制作工具**制作启动盘，进入 PE，点击引导修复，而后好像就这么恢复了。



## (键盘)代码 19：由于其配置信息（注册表中的）不完整或已损坏，Windows 无法启动这个硬件设备

解决办法参考：[(键盘)代码 19：由于其配置信息（注册表中的）不完整或已损坏，Windows 无法启动这个硬件设备 解决方法 - CSDN博客](https://blog.csdn.net/zoro_13/article/details/17338063)