[toc]

# Linux 操作与技巧



## Ubuntu 下安装各类应用软件

推荐看看：

- [在Ubuntu 上有什么必装的实用软件？](https://www.zhihu.com/question/19811112)

### TeamViewer（远程控制）

1. 通过[官网](< https://www.teamviewer.com/zhCN/>)下载 Linux 版 TeamViewer 

2. 通过命令行，运行`.deb`文件，完成安装：`sudo dpkg -i teamviewer_13.0.6634_amd64.deb `，当然了，在 ubuntu 下你也可以直接双击完成安装。

   但是，命令安装过程出现如下错误信息：

   ```
   正在选中未选择的软件包 teamviewer。 
   (正在读取数据库 … 系统当前共安装有 253291 个文件和目录。) 
   正准备解包 teamviewer_13.0.6634_amd64.deb  … 
   正在解包 teamviewer (13.0.6634) … 
   dpkg：警告：无法删除原有的目录 /var/log/teamviewer12 ：目录非空 
   dpkg: 依赖关系问题使得 teamviewer 的配置工作不能继续： 
   teamviewer 依赖于 qtdeclarative5-dialogs-plugin (>= 5.2) | qml-module-qtquick-dialogs (>= 5.2)；然而： 
   未安装软件包 qtdeclarative5-dialogs-plugin。 
   未安装软件包 qml-module-qtquick-dialogs。 
   dpkg: 处理软件包 teamviewer (–install)时出错： 
   依赖关系问题 - 仍未被配置 
   正在处理用于 desktop-file-utils (0.22-1ubuntu5.1) 的触发器 … 
   正在处理用于 gnome-menus (3.13.3-6ubuntu3.1) 的触发器 … 
   正在处理用于 bamfdaemon (0.5.3~bzr0+16.04.20160824-0ubuntu1) 的触发器 … 
   Rebuilding /usr/share/applications/bamf-2.index… 
   正在处理用于 mime-support (3.59ubuntu1) 的触发器 … 
   正在处理用于 hicolor-icon-theme (0.15-0ubuntu1) 的触发器 … 
   在处理时有错误发生： 
   teamviewer
   ```

   尝试解决：

   1. 先卸载 TeamView：`sudo apt-get remove teamviewer`

   2. 依次敲击命令，更新系统响应的软件：

      ```xml
      sudo apt-get update 	#从网上的源更新安装包信息
      sudo apt-get upgrade	#升级软件包到最新版本
      ```

   3. 然后再安装：`sudo dpkg -i teamviewer_13.0.6634_amd64.deb `，最后发现可以了。

   注1：如果出现依赖错误，可以试着使用该先运行该命令：`sudo apt-get install -f`（该命令表示修复软件依赖包的关系），再去运行安装包。

   注2：能看到有的网上博文会用到 `wget` 命令，该命令为下载资源，如下载 TeamViewer 的 `.deb` 包：`wget https://download.teamviewer.com/download/linux/teamviewer_amd64.deb`，这样就会把该文件下载到本地了。

   最后的实际使用中，发现竟然没有传输声音（但耳机插 Ubuntu 实体机电脑上是有声音的），在 TeamViewer 设置中也没找到开启声音的设置，那这样就和我以前使用 VNC 远程连接没什么区别了，只起到了监视屏幕作用。

   提下：如果插 Ubuntu 实体机电脑上没有声音，可以试试网上解决办法：[Ubuntu 下耳机没有声音 解决方法](https://blog.csdn.net/weixin_40294256/article/details/79137488)

参考：[Ubuntu 16.04 安装 TeamViewer 13](https://blog.csdn.net/u011292539/article/details/79249027)

### 搜狗输入法

参考：[Ubuntu 16.04安装sogou 拼音输入法](https://blog.csdn.net/ljheee/article/details/52966456)

注：根据上文解释，安装搜狗输入法之前先要更换为国内的软件源，否则无法解决依赖问题。

按照文中操作，我先需要添加国内阿里云的软件源，实际操作中似乎有点问题，于是网上找了别的博客中提到的阿里云的软件源，如下：

```
# deb cdrom:[Ubuntu 16.04 LTS _Xenial Xerus_ - Release amd64 (20160420.1)]/ xenial main restricted
deb-src http://archive.ubuntu.com/ubuntu xenial main restricted #Added by software-properties
deb http://mirrors.aliyun.com/ubuntu/ xenial main restricted
deb-src http://mirrors.aliyun.com/ubuntu/ xenial main restricted multiverse universe #Added by software-properties
deb http://mirrors.aliyun.com/ubuntu/ xenial-updates main restricted
deb-src http://mirrors.aliyun.com/ubuntu/ xenial-updates main restricted multiverse universe #Added by software-properties
deb http://mirrors.aliyun.com/ubuntu/ xenial universe
deb http://mirrors.aliyun.com/ubuntu/ xenial-updates universe
deb http://mirrors.aliyun.com/ubuntu/ xenial multiverse
deb http://mirrors.aliyun.com/ubuntu/ xenial-updates multiverse
deb http://mirrors.aliyun.com/ubuntu/ xenial-backports main restricted universe multiverse
deb-src http://mirrors.aliyun.com/ubuntu/ xenial-backports main restricted universe multiverse #Added by software-properties
deb http://archive.canonical.com/ubuntu xenial partner
deb-src http://archive.canonical.com/ubuntu xenial partner
deb http://mirrors.aliyun.com/ubuntu/ xenial-security main restricted
deb-src http://mirrors.aliyun.com/ubuntu/ xenial-security main restricted multiverse universe #Added by software-properties
deb http://mirrors.aliyun.com/ubuntu/ xenial-security universe
deb http://mirrors.aliyun.com/ubuntu/ xenial-security multiverse
```

现总结下大致步骤：

（1）在安装之前，先用文本编辑器打开源列表`sudo gedit /etc/apt/sources.list` ，在文件头添加阿里云的软件源，当然也可以添加别的软件源，比如清华大学的：[清华大学开源软件镜像站](https://mirror.tuna.tsinghua.edu.cn/help/ubuntu/)

（2）下面正式开始安装：

1. 下载搜狗输入法，下载的是个 `.deb` 文件：[搜狗输入法 for linux](https://pinyin.sogou.com/linux/?r=pinyin)

2. Ubuntu 16.04 安装搜狗输入法命令如下：

   ```xml
   sudo apt-get install -f		#修复软件依赖包关系
   sudo dpkg -i sogoupinyin_2.2.0.0108_amd64.deb	#开始安装
   ```

   deb 文件名，要和自己下载的版本一致。

3. 安装完毕，设置语言选项：

   到系统设置 --> 语言支持（System->Language Support），将键盘输入法系统由默认的 iBus 设置为 fcitx。

   > 操作此步骤时，如果没有出现 fcitx 选项，说明你的机器还需要安装 fcitx 键盘输入法系统。安装 fcitx：
   >
   > ```
   > sogou是基于 fcitx 的，而系统默认的键盘输入法系统是 iBus。Ubuntu 16.04默认是带有 fcitx 的，正常安装，如果有的话，按上面步骤即可完成；但有些版本的 Ubuntu，需要自己安装 fcitx，才能安装使用sogou。
   > 
   > 1、添加以下源：sudo add-apt-repository ppa:fcitx-team/nightly
   > 2、更新系统：sudo apt-get update
   > 3、安装fcitx：sudo apt-get install fcitx
   > 4、安装fcitx的配置工具：sudo apt-get install fcitx-config-gtk
   > 5、安装fcitx的table-all软件包：sudo apt-get install fcitx-table-all
   > 6、安装im-switch切换工具：sudo apt-get install im-switch
   > 
   > 至此，fcitx 键盘输入法系统就安装好了。第5，6步需要按键“Y”确认安装。简单测试的方法就是在终端键入“fcitx”，有各种提示就对了。
   > 安装完 fcitx 后，再安装 sogou 即可。
   > ```

4. 注销，重新登陆。将键盘输入法系统改为 fcitx 后，一定要注销，而且操作顺序不能改。这时还不能马上使用，还要点击右上角的输入法图标，点击设置，进入设置界面，这个时候没有看到搜狗输入法，点击左下角的加号，然后注意先要去掉”只显示当前语言的输入法”前面那个勾，然后再搜索”sogo”，这个时候就看到 sogo
   pinyin 了，接着添加就可以了，然后就可以切换输入法了。

   

### QQ（聊天社交）

1）方式一（失败）

- [Ubuntu 16.04 安装QQ解决方案](https://blog.csdn.net/fuchaosz/article/details/51919607)

- [Ubuntu 16.04安装QQ国际版图文详细教程](https://www.linuxidc.com/Linux/2016-09/134923.htm)

步骤大致如下：

1. 下载 [winQQ国际版](http://www.ubuntukylin.com/application/show.php?lang=cn&id=279)

2. 下载完成之后可以看到名为`wine-qqintl.zip`压缩文件，解压出来，得到如下三个文件：

   ```xml
   fonts-wqy-microhei_0.2.0-beta-2_all.deb
   ttf-wqy-microhei_0.2.0-beta-2_all.deb
   wine-qqintl_0.1.3-2_i386.deb
   ```

3. 使用下面命令依次安装：

   ```xml
   sudo dpkg -i ./fonts-wqy-microhei_0.2.0-beta-2_all.deb
   sudo dpkg -i ./ttf-wqy-microhei_0.2.0-beta-2_all.deb
   sudo dpkg -i ./wine-qqintl_0.1.3-2_i386.deb
   ```

   如果安装最后一个包的时候失败了，则可以执行下面的命令后再试：`sudo apt-get install -f`，顺带解释下，这个命令啥作用呢？

   > `apt-get install -f`：修复软件依赖包的关系

   安装完毕后，在 dash 中搜索 qq  就可以打开了。

   注：如果要卸载 wineqq，命令：`sudo dpkg -remove wine-qqintl`

补充遇到的问题：

> 以上方式实际操作不成功，`sudo dpkg -i ./wine-qqintl_0.1.3-2_i386.deb`安装失败，会提示：
>
> ![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/18-10-2-48461819.jpg)
>
> 即使使用`apt-get install -f`修复软年依赖关系也是这样问题。
>
> 好吧，于是尝试 `apt-get clean`：
>
> > 这个命令会把安装的软件的备份也删除，不过这样不会影响软件的使用的。
>
> 再`sudo apt-get update`：
>
> > 该命令表示：从网上的源更新安装包信息。
>
> 然后尝试：`sudo apt-get install libasound2 liblcms2-2 libpng12-0 libsm6 libncurses5 libpulse0 libmpg123-0 libasound2-plugins`，但会提示「没有可用的软件包 libpng12-0......」：
>
> ![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/18-10-2-65061192.jpg)
>
> 好吧，尝试单个包独立安装，但最后还是会发现`sudo apt-get install libpng12-0`安装该包出现如上一样问题。就懒得尝试去网上单独下载包进行手动安装了（放弃脸.jpg）。

2）方式二（失败）

- [ubuntu18.04安装qq](https://blog.csdn.net/qq_35308803/article/details/80643263?tdsourcetag=s_pcqq_aiomsg)

大概步骤：

1. Ctrl+Alt+T 打开终端，执行下面命令安装 wine：`sudo apt-get install wine`
2. 下载 wineQQ8.9_19990：[百度网盘下载地址](https://pan.baidu.com/s/1KAP1h4qVDBi_LY4lBrfCYQ  )  密码：4854，下载完成，可以看到有个名为`wineQQ8.9_19990.tar.xz`打包文件
3. 解压该文件：`tar xvf wineQQ8.9_19990.tar.xz`
4. 打开 dash，搜索 qq 打开

3）方式三（失败）

下载了该文中的 [wine qq 2013 for linux Ubuntu 64位兼容](http://www.longene.org/forum/viewtopic.php?f=6&t=4700&tdsourcetag=s_pcqq_aiomsg) 提到的 Longene QQ2013SP6：

- 本地下载：[WineQQ2013SP6-20140102-Longene](http://www.longene.org/download/WineQQ2013SP6-20140102-Longene.deb)
- 百度网盘：[WineQQ2013SP6-20140102-Longene](http://pan.baidu.com/s/1hq83fWo)

下载完成之后，得到名为`WineQQ2013SP6-20140102-Longene.deb`文件，于是直接`sudo dpkg -i WineQQ2013-20131120-Longene.deb`进行安装，完成之后，能看到 ubuntu 桌面出现了 qq，直接双击可以打开，但是使用的时候提示「尊敬的QQ用户，由于您使用的QQ版本太旧，将不能继续使用......」，好吧。

在知乎问答下 [yao伟斌](https://www.zhihu.com/question/19811112/answer/132006027) 在精选留言中有分享文件 [WineQQ7.8-20151109-Longene.deb](https://pan.baidu.com/s/1dFkMRr7) 密码：jew8，不造这个是不是这个版本比较新，然后可以呢？

**这里提下：** 

关于依赖的问题。可以了解下 gdebi：

> dpkg 的一个缺点是它不能解决依赖关系，你必须手动安装依赖包，而 gdebi 可以帮助我们自动安装依赖包．输入下面的命令安装 gdebi：`sudo apt-get install gdebi`，它的命令语法如下：`sudo gdebi <package.deb>`



### 微信（聊天社交）

参考：[buntu 18.04 安装微信（Linux通用）](https://www.cnblogs.com/dunitian/p/9124806.html)

上文介绍了好几种方式。安装的软件包为 `electronic-wechat`：

> 这个是一个开源软件，当然了是基于 web 版的微信。Ubuntu 软件市场也是有的，所以安全性不用担心。其开源地址为：https://github.com/geeeeeeeeek/electronic-wechat

大概总结下：

1）方式一：简单点，直接在 ubuntu 软件中心搜索「微信」可以看到名为`electronic-wechat`软件，直接安装就行。

2）方式二：下载软件包：[electronic-wechat GitHub下载地址](https://github.com/geeeeeeeeek/electronic-wechat/releases)，解压安装即可。



### Shadowsocks/ShadowsocksR



参考文章：

- [Linux下SSR客户端的配置与开机自启](https://blog.csdn.net/xs18952904/article/details/80272579)
- [Ubuntu 16.04使用Shadowsocks代理上网（Chrome浏览器）](https://blog.csdn.net/u79501/article/details/69666754)
- [Linux 环境安装 SSR 客户端](https://break-hope.github.io/2018/08/17/install-ssr-on-linux/)
- [Ubuntu 安装ssr-qt5客户端](https://blog.csdn.net/jankin6/article/details/79251192)





