<a name="top"></a>

<div align="center" style=“width:100%;”>
        <img src="./assets/logo/logo.png" href="https://github.com/jayboxyz/websites-and-tools"></img>  
</div>


分类收藏一些网站、工具和软件，记录一些关于 windows/macOS/linux 系统的使用技巧和软件操作等，“工欲善其事，必先利其器”，提高做事效率，让效率成为一种习惯。

> 欢迎大家 star，也欢迎 PR 或 issue，分享和推荐你觉得不错的资源、利器，软件和使用技巧等。


<h2 align="center" style="font-size:24px;font-weight: bold;">工具和应用</h2>


| :fish_cake:                   | :fish_cake:                            | :fish_cake:                         | :fish_cake:                   | :fish_cake:                     | :fish_cake:                       | :fish_cake:               | :fish_cake:                       |
| ----------------------------- | -------------------------------------- | ----------------------------------- | ----------------------------- | ------------------------------- | --------------------------------- | ------------------------- | --------------------------------- |
| [IDE插件](./0.IDE_plugins.md) | [Chrome插件](./1.chrome_extensions.md) | [Windows软件](./2.windows_tools.md) | [MacOS软件](./3.mac_tools.md) | [Linux软件](./4.linux_tools.md) | [Android应用](./5.android_app.md) | [iOS应用](./6.iOS_app.md) | [GitHub利器](./7.github_tools.md) |


<h2 align="center" style="font-size:24px;">操作和技巧</h2>


| :full_moon:                             | :full_moon:                               | :full_moon:                           | :full_moon: | :full_moon:                             | :full_moon:                        | :full_moon:                                | :full_moon:                        |
| --------------------------------------- | ----------------------------------------- | ------------------------------------- | ---------------------------------- | ------------------------------------------ | ---------------------------------- | ----------- | ----------- |
| [Office使用](./skills/01-玩转Office.md) | [Windows使用](./skills/02-玩转Windows.md) | [MacOS使用](./skills/03-玩转MacOS.md) | [Linux使用](./skills/04.玩转Linux.md) | [Chrome使用](./skills/05-玩转Chrome.md) | [手机使用](./skills/06-玩转手机.md) | [硬件&系统重装](./skills/07-操作系统重装.md) | [杂七杂八](./skills/08-杂七杂八.md) |


<h2 align="center" style="font-size:24px;">网站和书签</h2>

[toc]

## 一、杂七杂八

**浏览器主页：**

-  [搜酷站](https://www.soukuzhan.com/) [**荐**]
-  [KIM主页](<https://kim.plopco.com/>)
-  [星空导航](https://www.starnavi.cn)
-  [大马路](https://dama.lu/)
-  [简约导航](https://www.jianavi.cn/)
-  [某柠檬导航](https://www.moulem.com/j.html)
-  [Infinity](https://cn.infinitynewtab.com/)【新一代的标签页，一个更好用，更强大的新标签页】[**Chrome插件**]
-  [Momentum](<https://chrome.google.com/webstore/detail/momentum/laookkfknpbbblfpciffpaejjkokdgca?utm_source=chrome-ntp-icon>)【每天打开一个超美的浏览器页面。自动更换壁纸，自带时钟，任务日历和工作清单】
-  [远方 New Tab](<https://chrome.google.com/webstore/detail/dream-afar-new-tab/henmfoppjjkcencpbjaigfahdjlgpegn/related?hl=zh-CN>)【美化新标签页的插件。正如这个插件的中文名一样，每次打开新标签页时都会显示一张远方的自然风光图，同时提供可配置的搜索框(可设置使用百度、谷歌或者必应)，天气预报，时钟等功能】[**Chrome插件**]

**搜索 & 资源 & 网盘：** 

- [Google](https://www.google.com/)
- [Bing](<https://cn.bing.com/>)
- [DuckDuckGo](<https://duckduckgo.com/>)【 从介绍来看这个搜索引擎不收集用户信息，而且没有广告】
- [DogeDoge 多吉搜索](https://www.dogedoge.com/)【不追踪，不误导；支持部分即时结果。前端页面“借鉴”的 DuckDuckGo】
- [国外搜索引擎大全-百鸣](http://www.baimin.com/world/557.htm)
- [虫部落 — 让搜索更简单](http://www.chongbuluo.com/)
- [Bird.so 小众搜索引擎](https://bird.so/)
- [史莱姆搜索](http://www.slimego.cn/)
- [我的盘 - 最好用的网盘搜索引擎](http://www.wodepan.com/)
- [南瓜线报资源网](<https://www.630906.com/>)

**电子书下载：** 

- [Love2.io](https://love2.io/)【Love2.io 是一个全新的开源技术文档分享平台，我们致力于提供用户更优雅的阅读和写作体验。技术改变世界，用文档传播。有很多来自 GitHub 的技术书籍】
- [SIMPLE求知网-互联网+程序猿](<http://www.simple000.com/>)【为编程爱好者提供计算机电子书等电子资料免费资源下载】
- [SoBooks](https://sobooks.cc/)
- [[搬书匠] - 电子书(EBook)](<http://www.banshujiang.cn/>)
- [Jiumo Search 鸠摩搜索](<https://www.jiumodiary.com/>)
- [Ebooke](<https://ebookee.org/>)【一个基于互联网并提供免费电子图书下载的搜索引擎网站】

**科研 & 学术：**

- [Google 学术搜索](https://scholar.google.com.hk/?hl=zh-CN)  |  [牛顿网 - 谷歌学术搜索镜像](<http://www.ndtsg.com/>)  |  [gfsoso 学术搜索](<https://c.glgoo.top/scholar/>)  |  [谷歌学术镜像](<http://ac.scmor.com/>)
- [百度学术](http://xueshu.baidu.com/)
- [Bing 学术](https://cn.bing.com/academic/?FORM=HDRSC4&setmkt=zh-CN)
- [谷粉学术](https://gfsoso.99lb.net/)
- [Sci-hub.tw](https://sci-hub.tw/)  |  [sci-hub.shop](<https://www.sci-hub.shop/>)  |  ...【只要你有论文的 URL 或者 DOI（Digital Object Identifier）就可以粘贴到搜索框里，点击“Open”就会出现你想要的论文。】
- [中国知网](http://www.cnki.net/)  |  [arXiv](https://arxiv.org/)（或  [Arxiv Sanity](<http://www.arxiv-sanity.com/>)）  |  [快搜 - 学术搜索](http://scholar.chongbuluo.com/)  |  [Web of Science [v.5.29] - 所有数据库 基本检索](http://apps.webofknowledge.com/UA_GeneralSearch_input.do?product=UA&search_mode=GeneralSearch&SID=8Ecas5pkrJVAlSzoqGC&preferencesSaved=)  | [ScienceDirect](<https://www.sciencedirect.com/>)  | …
- [SemanticScholar](<https://www.semanticscholar.org/>)【一个免费学术搜索引擎，其检索结果来自于期刊、学术会议资料或者是学术机构的文献。】
- [科塔学术 - 科研与学术资源导航平台](<https://www.sciping.com/>)
- [Overleaf中文版](<https://cn.overleaf.com/>)【Overleaf 是一个使用 LaTeX 进行多人协同编辑的平台，可以免费注册和使用，不用下载 LaTeX 软件，是最为著名的 LaTeX 在线协作系统。主要特色是有 LaTeX 插件，编辑功能十分完善，有实时预览（即编即看，无需手动编译）的功能。】
- [Grammarly](https://www.grammarly.com)【英语语法纠正，为你检查那些自己未注意到的单词、语法、时态错误，并提供更准确的纠正方法。基础版免费。有 word 插件。】

**汽车：**

- [汽车之家](https://www.autohome.com.cn/)【汽车之家为汽车消费者提供选车、买车、用车、换车等所有环节的全面、准确、快捷的一站式服务。】

**理财 & 炒股 & 炒币：**

- [雪球](https://xueqiu.com/)【雪球是一家成立于 2010 年 3 月的投资者垂直社交媒体，用户可以在雪球关注股票及基金等证券代码，查看沪深/港/美股票的实时行情；关注各类投资者进行投资见解的交流；创建和分享个人投资组合；创建沪深及美股股票账户、基金交易账户，实盘买卖股票和基金。】

**购书 & 交易：**

- [图灵社区](http://www.ituring.com.cn/book)  [荐]
- [豆瓣读书](https://book.douban.com/)  [荐]
- [当当网](http://www.dangdang.com/)
- [china-pub网上书店](http://www.china-pub.com/)
- [孔夫子旧书网](http://www.kongfz.com/)【二手书买卖】
- [闲鱼](https://2.taobao.com/)【二手买卖平台】
- [拍拍](<https://www.paipai.com/>)  |  [拍拍二手京东自营旗舰店 - 京东](<https://jingdongyoupin.jd.com/>)【拍拍，原名拍拍网、拍拍二手，起初是腾讯公司2005年推出的网络拍卖平台，现为京东旗下二手交易平台。】
- [转转](<http://www.zhuanzhuan.com/>)【二手交易网站】
- [历史价格查询（京东、淘宝、天猫）](http://www.lsjgcx.com/)【查询商品历史价格走势，京东、天猫、淘宝、亚马逊、苏宁、当当、考拉、严选、国美、新蛋等商品。】

**技能学习：** 

- [YouTube：sikana视频课堂](https://www.youtube.com/user/SikanaChina/about)【专注精品网络技能教育课程，内容涵盖艺术，音乐，烹饪，手工，健康，装修，自然和体育等多个方面。】

**科普：**

- [李永乐老师的头条主页](<https://www.toutiao.com/c/user/4234740937/#mid=1566748645609474>) | B战：[李永乐老师官方](<https://space.bilibili.com/9458053>【高中数学、物理老师，北京大学双学士，清华大学硕士研究生。科普了知识包括物理、电子、生活等等。】
- [王珂的头条主页](<https://www.toutiao.com/c/user/token/MS4wLjABAAAAYOk-Tz5yXZnmNgkC64T4tL9bjlxoodnhbMIPFXEktu4/#mid=1559382930310146>) | B 战：[王珂Rocky](<https://space.bilibili.com/95257211>)【讲解了很多科学原理，包括计算机、物理等等。】

**工具 & 下载：**

- [少数派](https://sspai.com/)【致力于更好地运用数字产品或科学方法，帮助用户提升工作效率和生活品质】
- [GugeApps](<https://www.gugeapps.net/>)【使用它可以轻松下载 Chrome 的扩展插件和主题背景。有一点不方便的，就是不能直接添加，需要手动添加。在 Chrome 中访问：`chrome://extensions`，把开发者打开，然后在左上角的”加载已解压的扩展程序“选择就可以使用了。同时它还提供了 Chrome 浏览器下载镜像。】
- [管家团队官方网站](<http://www.gjtd666.com/>)【管家团队致力于为用户提供优质的内容和服务，经过多年的沉淀，已经打造了一系列优秀的产品，如：管家课堂、管家英语口语、管家速修等。注：都是公众号，其中有个公号「软件安装管家」，免费发布各类软件安装包和安装教程。】

**免费图像网站：**

- [Pexels](https://www.pexels.com/)  [无版权]
- [PxHere](<https://pxhere.com/>)【PxHere 是一个图片搜索网站，它上面所有的图片的都是遵循 CC0 协议的，你可以免费商用或者使用，而不需要标注来源。它上面不乏有很多高清的图片，基本上可以满足很多你的需求，而且没有法律的风险】  [无版权]  [荐]
- [lifeofpix](https://www.lifeofpix.com/)
- [foter](https://foter.com/)
- [picjumbo](https://picjumbo.com/)
- [Gratisography](https://gratisography.com/)  [无版权]
- [Unsplash](https://unsplash.com/ )  [无版权]
- [freeimages](https://www.freeimages.com/)
- [Pixabay](https://pixabay.com/)【有高清的照片素材，视频素材，插画素材，还有矢量图素材。】  [无版权]
- [LibreStock](<https://librestock.com/>)【可以检索一些优质的高清图片】
- [Canva](https://www.canva.com/photos/free/)
- [reshot](https://www.reshot.com/)
- [rawpixel](https://www.rawpixel.com/)
- [Morguefile](https://morguefile.com/)
- [pxhere](https://pxhere.com/)
- [ISO Republic](https://isorepublic.com/)
- [泼辣有图](http://www.polayoutu.com)
- [别样网-沙沙野](https://www.ssyer.com/)
- [配图神器 Zoommy](https://zoommyapp.com/)【Zoommy 是一款桌面客户端应用，支持 Windows、macOS、Linux，可以从 50 家高质量图片网站中搜索超过 50000 张 CC0 授权，或者公有领域的图片，之后便可以随意使用这些图片。】

**摄影：**

- [视觉中国](<https://xinhuanet.vcg.com/>)【拥有领先的基于云计算、大数据等平台技术的超大型影像库搜索及存储技术，是中国最大的视觉内容互联网版权交易平台。聚集了众多国内外顶级签约摄影师和艺术家。】
- [图虫](https://tuchong.com/)【优质摄影图片分享社区】
- [米拍](https://www.mepai.me/mp/home)【原创摄影交流学习社区，学摄影】
- [500px摄影社区中国版](https://500px.com.cn/community/index.html)【与全球摄影师交流分享】

**图标素材：** 

- [Flatlcon](https://www.flaticon.com/)【提供海量免费的 SVG、PNG、WebFont 格式图标素材下载的站点，该网站收录的图标都是单色、平面化素材。】
- [Fontello](http://fontello.com/)【自定义 icon】
- [Iconfont](https://www.iconfont.cn/)【阿里巴巴矢量图标库是由阿里巴巴体验团队倾力打造的中国第一个最大且功能最全的矢量图标库，提供矢量图标下载、在线存储、格式转换等功能，是设计师和前端开发的便捷工具。】
- [Swifticons](https://www.swifticons.com/)【高品质多分类图标素材网站，提供 1456 种高品质图标素材，覆盖了 15 个广泛的分类样式。】
- [IconFinder-Free Icons](https://www.iconfinder.com/free_icons)
- [Vexels](https://www.vexels.com/)
- [Icons8](https://icons8.com/)

**免费图床：**

- [SM.MS](https://sm.ms/)【无外链限制，无流量限制的图床，简易的在线图床工具。】
- [路过图床](<https://imgchr.com/>)
- [Qchan图床](http://tuchuang.org/)
- [小贱贱图床](http://pic.xiaojianjian.net/)【每日上传图片限制数：30张。】

**Logo设计：**

- [Logomakr](https://logomakr.com/)  [荐]
- [Free Logo Design](https://www.freelogodesign.org/)
- [Logo Garden](https://www.logogarden.com/)

**公众号 & 排版：**

- Markdown 在线写作：
  - [Markdown在线编辑器 - MdEditor](https://www.mdeditor.com/)【在线 Markdown 写作】
  - [Cmd Markdown 编辑阅读器 - 作业部落出品](<https://www.zybuluo.com/mdeditor>)【在线 Markdown 写作】

- 公众号文章自动排版
  - mdnice：[让微信排版变 Nice](https://mdnice.com/)
  - Lyric：[微信公众号格式化编辑器](https://lab.lyric.im/wxformat/)
  - 小胡子哥：[Online Markdown Converter](http://md.barretlee.com/)
  - 颜家大少：[Md2All](http://md.aclickall.com/)
  - [可能吧公众号 Style 一键转换](<https://knb.im/mp/>)
- 微信公众号图文编辑工具
  - 秀米编辑器
  - 135编辑器
  -  i排版
- [壹伴](https://yiban.io/) [Chrome插件]
- [新媒体管家](https://xmt.cn/index) [Chrome插件]
- [Fotor在线设计](<https://www.fotor.com.cn/>)

**杂七杂八：**

- [毒鸡汤](<http://www.nows.fun/>)

**国外网站：**

- [Netflix](<https://www.netflix.com/sg-zh/>)【一间在世界多国提供网络视频点播的 OTT 服务公司，并同时在美国经营单一费率邮寄 DVD 出租服务。】

**数据分析：** 

- [七麦数据（原ASO100）](<https://www.qimai.cn/>)【国内专业的移动应用数据分析平台，覆盖App Store & Google Play双平台，提供iOS&Android应用市场多维度数据。】



## 二、在线工具

**作图 & 工作：** 

- [draw.io](https://www.draw.io/)
- [ProcessOn](https://www.processon.com/)
- [gliffy](https://www.gliffy.com/diagram-software)
- [iSlide - 让PPT设计简单起来！](<https://www.islide.cc/>)【一款基于 PowerPoint 的插件工具，使用它可以可以让你轻轻松松做出经验高大上的 PPT。】
- [英文大小写字母转换器 - 在线转换大小写字母,大写转小写,小写转大写](<https://dzhuli.com/daxiaoxie/>)
- [維基詞典，自由的多語言詞典](https://zh.wiktionary.org/wiki/Wiktionary:%E9%A6%96%E9%A1%B5#%E5%85%B6%E4%BB%96%E8%AF%AD%E8%A8%80%E7%9A%84%E7%BB%B4%E5%9F%BA%E8%AF%8D%E5%85%B8)【可查各种语言词汇的语源、读音和解释】

**工具 & 下载：** 

- [Crx离线安装包下载](http://yurl.sinaapp.com/crx.php)【可将 Chrome 插件转为 crx 文件】
- [中文转换工具](https://www.chineseconverter.com/zh-cn/convert/chinese-to-pinyin)【中文转换一系列工具】
- [免费在线文字识别，文字提取，OCR服务](http://www.ocrmaker.com/)
- [DownGit](https://minhaskamal.github.io/DownGit/#/home) | [DownGit中文版](http://downgit.zhoudaxiaa.com/#/home)【想要下载 GitHub 整个项目，或说项目中的指定文件夹或文件，只要复制相应链接拷贝粘贴，然后点击 Download 就可以下载。】
- [百度文库文档解析抓取工具](<http://bdwk.588230.com/>)【百度文库付费 RMB 文档免费下载。】
- [peterq/pan-light](<https://github.com/peterq/pan-light>)【百度网盘不限速】

**免费临时网盘：**

- [奶牛快传](https://cowtransfer.com/)【一款国内临时文件传输分享服务网盘网站。可以免注册上传和下载，可以设置密码。另外提供了共享网址所对应的二维码以及微信小程序二维码。注：对于注册用户，它不限制传输文件的大小，文件可保留 7 天；未注册用户则可最大传输 2GB 文件，可以保留 3 天。】
- [Firefox Send](https://send.firefox.com/)【一款“临时性的文件传输共享服务”。上传的文件可设置访问密码、过期时间、最大下载次数。一旦时间或次数超限后，分享链接将自动失效，文件也会彻底销毁删除，无法再被恢复。另外，接收方并不需要账号即可匿名直接下载。注：匿名用户可以上传最大 1GB、最长 1 天的临时文件、被下载 1 次后自动删除文件；而注册用户 (同样完全免费) 则最大可以上传 2.5 GB 文件、最长可以保留 7 天的时间、最多允许 100 次下载次数。】
- [WeTransfer](https://wetransfer.com/)【一个提供超大文件临时中转服务的网站，完全免费，传输上限 2GB。使用方法：进入网站，添加文件、填写对方邮箱、自己邮箱、一些提示语即可，点击 Transfer，就可以了，上传完毕后，对方会在他邮箱收到一条 Link，就可以很快下载下来了。】

**在线办公 & 文档转换 & 处理：** 

- [UZER.ME](https://uzer.me/)【UZER 是一个无需下载安装，就可以在浏览器中使用各种企业级大型软件（比如 Office 系列，PS，AutoCAD），无需安装插件，也不会占很多内存，打开网页就可以体验使用，而且几乎没有卡顿】
- [PDF2go](https://www.pdf2go.com/zh/)【在线 PDF 转换器，编辑，旋转和压缩 PDF 文件】
- [Smallpdf](https://smallpdf.com/cn)【所有 PDF 问题的免费解决方案】
- [iLovePDF](https://www.ilovepdf.com/zh_cn)【为 PDF 爱好者提供的 PDF 文件在线处理工具】
- [LightPDF]( https://lightpdf.com/zh/ )【免费在线编辑、转换 PDF 文件】

**格式转换：** 

- [office-converter](https://cn.office-converter.com/)【Office Converter 是世界上最大的在线文件转换工具集合网站，你能免费在线转换包括视频、音频、图形、文档和压缩等服务，目前能够做到输出超过500种格式，输入格式转换超过2000种不同的格式转换。目前网站提供的在线转换文件包括，在线文档转换、在线视频转换、在线音乐转换、在线电子书转换、在线文件压缩、在线二维码生成器、在线 YouTube 转换和下载、在线翻译/免费、在线单位转换： 热门单位换算、 在线力学转算、在线运动转算、 在线维度转算等等。】
- [Aconvert.com](https://www.aconvert.com/cn/)【各类文件类型转换；音视频分割、合并、裁剪等；在线压缩。】
- [CloudConvert](https://cloudconvert.com/)【各类文件类型相互之间转换】
  - 在线 WMA 转 GIF 图片：<https://cloudconvert.com/wmv-to-gif>
- [Convertio](https://convertio.co/zh/)【Convertio 是在线文档转换工具，支持45种常见格式的文档转换工具，包括办公文档、图片、电子书、音频、压缩文件等类型。可以快速实现 PDF 转换 Word、PNG 转换 JPG、WAV 转换 MP3 等操作。对应的 Chrome 插件：[Convertio插件在线安装](https://chrome.google.com/webstore/detail/convertio/eppjkefeiehhflmgkhdooajgbkkegpcl/related)。】

**图片处理：** 

- [iLoveIMG](https://www.iloveimg.com/zh-cn)【iLoveIMG 是一个在线“图像文件处理”网络应用软件，提供多种图像文件基础编辑功能。其中包括：图片文件格式转换、图片压缩、图片剪裁服务的工具集合，支持图片格式有 JPG、PNG、GIF。它的优点：一次调整多个图像文件的尺寸、压缩多个图像文件、裁剪多个图像文件，以及转换多个图像文件的格式。】
- [压缩图](https://www.yasuotu.com/)【在线图片压缩工具】
- [在线图片大小修改器](https://www.sojson.com/image/change.html)
- [改图宝](http://www.gaitubao.com/)【在线修改照片大小尺寸工具】
- [证件照研究院|证件照检测&制作平台]([http://www.id-photo-verify.com](http://www.id-photo-verify.com/))
  - [证件照片在线制作（专业版）](<http://www.id-photo-verify.com/maker/index.html>)

**短地址：** 

- [短链在线生成-短网址生成器](http://tool.tcode.me/shorturl.html)  [荐]
- [网址缩短-suo.im短网址](http://suo.im/)
- [短网址生成-ft12.com短网址](http://www.ft12.com/)

**加密解密：**

- [MD5在线加密/解密/破解—MD5在线](https://www.sojson.com/encrypt_md5.html)
- [MD5在线加密/解密/破解 - 站长工具](http://tool.chinaz.com/Tools/md5.aspx)
- [SOMD5](https://www.somd5.com/)

**符号 & 字体：** 

- [特殊符号大全](https://www.ifreesite.com/typing/keyboard-symbols.htm)
- [特殊字符大全](http://xh.5156edu.com/page/18466.html)
- [罗马数字](<http://w3.iams.sinica.edu.tw/lab/wbtzeng/labtech/roman_number.htm>)【 `I, 1`、`II, 2`、`III, 3`、`IV, 4`、`V, 5`、`VI, 6`、`VII, 7`、`VIII, 8`、`IX, 9`、 `X, 10`、`XI，`】

**Latex公式编辑：**

- [在线 LaTeX 公式编辑器](<https://www.codecogs.com/latex/eqneditor.php>)
- [LaTeX公式编辑器](<https://zh.numberempire.com/latexequationeditor.php>)



## 三、学习提升

**记笔记 & 写作 & 思维导图：**

- [有道云笔记](https://note.youdao.com/)
- [印象笔记](https://www.yinxiang.com/)
- [石墨文档](https://shimo.im/)
- [语雀](<https://www.yuque.com/>)【 一个企业级协作服务，提供文档、表格、项目管理等协作工具，帮助企业沉淀、整理内部信息和知识。是阿里巴巴集团内部最大的文档平台，也是阿里系知识管理和团队协作的主要工具之一。现在个人也都是可以直接注册使用的，跟阿里员工一样使用所有功能。】
- [幕布](https://mubu.com/apps)
- [百度脑图](http://naotu.baidu.com/)
- [XMind](https://www.xmind.cn/)【收费】
- [Medium](<https://medium.com>)【Medium是一个在线发布平台，最初由 Twitter 联合创始人 Evan Williams 开发。该平台于 2012 年启动，现在每个月有 6000 万独立访客。】

**读书 & 专栏：**

- [微信读书](https://weread.qq.com/)【很多书都可以在这找到，喜欢电子阅读推荐微信读书】
- [得到](https://www.igetget.com/)【知识付费，课程很多】

**编程导航：** 

- [编程导航-ITnavigation](http://www.redbanners.cn/)
- [Tool321_不可错过任何一个工具](http://tool321.com/cn/index.html)
- [Web前端导航](http://www.alloyteam.com/nav/)
- [前端文档工具](http://www.css88.com/nav/)

**在线工具：**

- [在线工具 —— 开源中国社区](http://tool.oschina.net/)
- [在线工具 - 程序员的工具箱](https://tool.lu/)
- [在线工具 - aTool - 最全面的工具集合](<http://www.atool9.com/>)
- [站长工具 - 站长之家](<http://tool.chinaz.com/>)
  - [调色板](<http://tool.chinaz.com/Tools/onlinecolor.aspx>)
- [codelf](https://unbug.github.io/codelf)【写代码给变量命名比较纠结，可以试试这个】

**编程学习网站：** 

- [菜鸟教程](http://www.runoob.com/) [**荐**]
- [w3school 在线教程](http://www.w3school.com.cn/)
- [w3cschool - 学编程](https://www.w3cschool.cn/)【注：有会员制】
- [W3Schools 中文教程](http://www.w3s.com.cn/)
- [C语言中文网](http://c.biancheng.net/cpp/)

**技术相关：**

- [FreeSSL.cn](<https://freessl.cn/>)【一个免费提供 HTTPS 证书申请、HTTPS 证书管理和 HTTPS 证书到期提醒服务的网站。】
- [【友盟+】全球领先的第三方全域数据服务商](https://www.umeng.com/)
- [IPIP.NET](https://www.ipip.net/ip.html)【在线查询ip地址】

**运维推广：**

- [openinstall](<https://www.openinstall.io/>)【业界领先的 App 推广云技术平台，以其精准的安装来源追踪解决方案为移动开发者提供稳定可靠的渠道推广和运营技术服务。】

**技术社区：**

- [GitHub](<https://github.com/>)
- [Stack Overflow](https://stackoverflow.com/)【一个程序设计领域的问答网站，隶属 Stack Exchange Network。网站允许注册用户提出或回答问题，还可对已有问题或答案加分、扣分或进行修改，条件是用户达到一定的“声望值”。】
- [SegmentFault 思否](<https://segmentfault.com/>)【2011年4月在杭州上线；专注于 IT 开发者的专业问答社区；SegmentFault（简称SF）的目标是做一个纯粹的程序员问答社区，国外知名 IT 问答网站 StackOverflow 是 SegmentFault 的学习对象。SegmentFault 避免建设成类似 Quora 的社会化问答社区，比起那些更注重社交关系的问答网站， SegmentFault 更加注重问题之间的关系。】
- [CSDN](https://www.csdn.net/)【中国最大 IT 社区。】
- [掘金](https://juejin.im/)【一个帮助开发者成长的社区。】
- [小专栏](https://xiaozhuanlan.com/)【一个专业人士的创作知识社区。】
- [极客时间](<https://time.geekbang.org/>)【极客邦科技出品的一款 IT 内容知识服务 App，内容包含专栏订阅、极客新闻、热点专题、直播、视频和音频等多形式的知识内容。】
- [51CTO](http://www.51cto.com/)
- [开源中国](https://www.oschina.net/)
- [V2EX](<https://www.v2ex.com/>)【v2ex是一个技术创意网站，官方自称为一个“由设计师、程序员及有创意的人参与的社区”。它的建站目的是基于兴趣，将用户创建的内容进行组织并分类成不同“节点”，网站以内容的活跃程度决定这些内容在网站首页的排列顺序。】
- [知乎](https://www.zhihu.com/)
- [我要自学网](http://www.51zxw.net/)【视频教程|免费教程|自学电脑|3D教程|平面教程|影视动画教程|办公教程|机械设计教程|网站设计教程等。】

**制作在线电子书：**

- 国外：[GitBook](https://www.gitbook.com/)
- 国内：[看云](https://www.kancloud.cn/)

**行业动态：** 

- [36氪](<https://36kr.com/>)
- [InfoQ](http://www.infoq.com/cn) 
- [IT之家](https://www.ithome.com/)

**代码搜索：**

- [CodeForge.cn](http://www.codeforge.cn/l/2/c/0/t/0/v/0)
- [HelloGitHub](https://hellogithub.com/)【分享 GitHub 上入门级、有趣的开源项目。】

**代码托管：**

- [码云 Gitee](https://gitee.com/)【为开源中国旗下的。】
- [CODING](https://coding.net/)
- [GitHub](https://github.com/)【国外。2018-06-04 宣布 75 亿美元被微软收购。现可以免费创建私有仓库。】
- [GitLab](https://www.gitlab.com/)【国外。以免费创建私有仓库；GitLab 让开发团队对他们的代码仓库拥有更多的控制。】

**编程资源：**

- [Java知识分享网-免费Java资源下载](http://www.java1234.com/)
- [深度开源 - Java开源大全，开源信息发掘、分享、交流](http://www.open-open.com/)
- [爱酷学习网-免费高清视频教程在线观看](http://www.icoolxue.com/)
- [798资源网](<https://www.798ziyuan.com>)【各类编程资源下载，包括视频等】

**网络课堂：**

- [网易公开课](<https://open.163.com/>)【于2010年11月上线，是一个汇集国内外名校公开课和演讲的免费、轻量的在线学习平台。免费。】
- [网易云课堂](<https://study.163.com/>)【于2012年12月上线，是以实用技能类内容为主，衔接高等教育和职业应用而打造的一个综合学习服务平台。免费与收费共存。】
- [百度传课](<https://chuanke.baidu.com/>)
- [腾讯课堂](<https://ke.qq.com/>)
- [中国大学MOOC(慕课)](<https://www.icourse163.org/>)【中国大学MOOC(慕课) 是国内优质的中文MOOC学习平台，由爱课程网携手网易云课堂打造。】
- [可汗学院](<https://zh.khanacademy.org/>)【由孟加拉裔美国人、麻省理工学院及哈佛大学商学院毕业生萨尔曼·可汗在 2006 年创立的一所非营利教育机构。机构通过网络提供一系列免费教材，现于 Youtube 载有超过5,600段教学影片，内容涵盖数学、历史、医疗卫生及医学、金融、物理、化学、生物、天文学、经济学、宇宙学、有机化学、美国公民教育、美术史、宏观经济学、微观经济学及计算机科学。】
- [万门大学](<https://www.wanmen.org/>) 
- [慕课网-程序员的梦工厂](<https://www.imooc.com/>)【IT 技能学习平台】
- [极客学院IT在线教育平台](<http://www.jikexueyuan.com/>)【IT 职业在线教育平台，拥有海量高清IT职业课程，涵盖 30+ 个技术领域。】
  - [极客学院Wiki - IT 技术图文教程库](<http://wiki.jikexueyuan.com/>)【极客学院 Wiki 为中国最大 IT 职业在线教育平台极客学院旗下图文开发技术教程站点，拥有海量 IT 图文教程，涵盖30+ 个技术领域。】

**网络课堂(AI课程)：**

- [优达学城 (Udacity)](https://cn.udacity.com/)【Udacity是由Sebastian Thrun, David Stavens和Mike Sokolsky注资的一个私立教育组织，它的目标是实现民主教育。截至2012年九月, Udacity有12个开放课堂。Udacity是来自硅谷的前沿技术平台，为广大学子提供WEB前端开发、Python/JAVA编程、IOS/Android开发、人工智能开发等一系列在线课程及实战项目。】
- [小象学院 ](http://www.chinahadoop.cn/)
- [七月在线](https://www.julyedu.com/)

**培训机构：**

- [尚硅谷](http://www.atguigu.com/)【B站有它家全套视频教程，见用户[尚硅谷](https://space.bilibili.com/302417610)，很赞】[**荐**]
- [传智播客](http://www.itcast.cn/)
- [黑马程序员](http://www.itheima.com/)
  - [传智播客和黑马程序员视频库](http://yun.itheima.com/)
- [尚硅谷](http://www.atguigu.com/)
  - [谷粒学院](http://www.gulixueyuan.com/)
- [北京尚学堂](http://www.bjsxt.com/)
- [咕泡学院](https://www.gupaoedu.com/index.html)
- [千锋教育](http://www.mobiletrain.org/)
- [扣丁学堂](http://www.codingke.com/)
- [珠峰培训-八年专注前端培训](http://www.zhufengpeixun.cn/)
- [麦子学院](http://www.maiziedu.com/)

**Online Judge 平台：** 

- [LeetCode(英文))](<https://leetcode.com/>) | [LeetCode(中文)](<https://leetcode-cn.com/>) [荐]
- [topcoder](https://www.topcoder.com/)
- [POJ（北京大学）](http://poj.org/)
- [HDOJ（杭电）](http://acm.hdu.edu.cn/)
- [ZOJ（浙江大学）](http://acm.zju.edu.cn/onlinejudge/showProblemsets.do)
- [南阳理工学院](http://acm.nyist.edu.cn/JudgeOnline/problemset.php)
- [炮姐 OJ 平台](http://acm.timus.ru/problemset.aspx)
- [Codeforces](http://codeforces.com/) [国外]

**算法考试 & 比赛：** 

- [PAT | 计算机程序设计能力考试](<https://www.patest.cn/>)

**企业信息查询：**

- [国家企业信用信息公示系统](http://www.gsxt.gov.cn/index.html)  
- [天眼查](https://www.tianyancha.com/)  [荐]
- [企查猫(企业查询宝)](https://www.qichamao.com/)
- [启信宝|企业查询|企业信息查询|企业信用查询](http://www.qixin.com/)
- [全国企业营业执照查询系统(红盾网)-中国工商局注册信用信息公示网](http://www.xiechuangw.com/chaxun/)

**求职 & 招聘：**

- [牛客网](https://www.nowcoder.com/)【IT行业求职、招聘、刷题等。】
- [看准网](https://www.kanzhun.com/)【中国雇主点评与职场信息平台。】
- [海投网]( https://www.haitou.cc/ )【2012 年开通域名。 定位于高校毕业生，为高校毕业生与知名企业搭建了一座有效的桥梁。】
- [应届生求职网](http://www.yingjiesheng.com/)【提供最新、最全、最准确的应届大学毕业生校园招聘、兼职实习、校园宣讲会和校园招聘会信息。】
- IT/互联网专业的招聘网站：
  - [BOSS直聘-互联网招聘神器！](https://www.zhipin.com/)
  - [拉勾网-专业的互联网招聘平台](https://www.lagou.com/)
  - [跟对人\_互联网it公司最新招聘信息_互联网人才求职找工作网站](http://www.genduiren.cn/)
- 其他招聘网站：
  - [智联招聘](https://www.zhaopin.com/)
  - [前程无忧](https://www.51job.com/)
  - [猎聘网](https://www.liepin.com/)
  - [58同城](http://www.58.com/) 

**简历制作：**

- [冷熊简历](http://cv.ftqq.com/#)【一款 Markdown 简历工具，支持 Markdown 实时预览，下载 MD 文件，一键转化为 PDF。另外添加了常用内容片段，简历内容自动实时保存。】
- [CyC2018/Markdown-Resume](https://github.com/CyC2018/Markdown-Resume)
- [超级简历WonderCV](https://www.wondercv.com/)【可以用这个免费做一个简历，基本足够了。简历模板简洁，不像有些简历模版比较花里胡哨。】
- [五百丁 - 中国领先的简历制作平台](http://www.500d.me/)
- [乔布简历](http://cv.qiaobutang.com/)
- [Docer稻壳儿](http://www.docer.com/)
- [592职业圈](https://www.job592.com/doc/5bebaaeae4b0f0140131ff08.html)【简历模板下载】

**兼职 & 实习：** 

- [大学生找实习求职招聘网站 | 实习僧](https://www.shixiseng.com/)
- [实习生-找实习-刺猬实习-最受信赖的实习招聘平台](http://www.ciweishixi.com/)
- [求职找工作 - 人才招聘 - 大街网](https://www.dajie.com/)
- [兼职猫app-免费、安全、靠谱｜大学生蓝领喜爱的临时工软件](https://www.jianzhimao.com/)

**项目 & 外包：** 

- [程序员客栈](https://www.proginn.com/)
- [猪八戒网站](http://www.zbj.com/)
- [远程.work](https://yuancheng.work/)【远程工作】
- [码市](https://codemart.com/projects)【码市是 Coding 推出的互联网软件外包服务平台，意在连接需求方与广大开发者。让项目的需求方快速的找到合适的开发者，完成项目开发工作。】



## 四、软件下载

**系统有关：** 

- [驱动精灵离线装机版 - 以及万能驱动包下载](http://www.drivergenius.com/zhuangji.asp)
- [自由天空驱动包(万能驱动助理win10) v7.18.1225.1 完整版](https://www.3987.com/xiazai/1/278/Driver/8150.html)
- [Microsoft .NET Framework 4.5官网下载](https://www.microsoft.com/zh-cn/download/details.aspx?id=30653)
- [Internet Explorer 11（脱机安装程序）](https://support.microsoft.com/zh-cn/help/18520/download-internet-explorer-11-offline-installer)

**资源下载：** 

- [MSDN,我告诉你](https://msdn.itellyou.cn/)【微软公司的各类软件下载，包括windows、MS Office等】



## 五、影音娱乐

**视频网站：** 

- [哔哩哔哩](https://www.bilibili.com/)
- [时光网](http://www.mtime.com/)
- [爱微电影](http://www.197c.com/)

**枪版视频 & VIP 视频：**

- [喝茶影视-喝茶影院](http://aaqqs.com/)  [荐]
- [97看剧网](http://www.kanjuba1.com/)
- [97看片吧](http://www.97qkp.com/)  
- [八哥网](<http://www.8gw.com/>)
- [E视网](http://www.ewang.com/)

**购票：** 

- [大麦网](https://www.damai.cn/)
- [摩天轮](https://www.tking.cn/)

**音乐：**

- [音乐直链搜索](http://music.liuzhijin.cn/)

**游戏：**

- [Steam](<https://store.steampowered.com/>)【美国电子游戏商维尔福于2003年9月12日推出的数字发行平台，提供数字版权管理、多人游戏、流媒体和社交网络服务等功能。】
- [Origin](<https://www.origin.com/hkg/zh-tw/store>)【充满超棒 PC 游戏汇集的平台】
- [itch.io](<https://itch.io/>)【一个销售和提供下载独立电子游戏的网站】

**视频 & 音频处理：**

- [在线编辑视频](https://online-video-cutter.com/cn/)
- [在线提取视频中音频](http://audio-extractor.net/cn/) 

**视频下载：** 

- [舒克高清视频下载](http://www.shokdown.com/)
- [硕鼠下载](http://www.flvcd.com/)
- [微博、秒拍、小咖秀、晃咖视频解析下载](https://weibo.iiilab.com/)
- [Apowersoft免费在线视频下载](https://www.apowersoft.cn/online-video-downloader) [国外]
- [ClipConverter.cc](https://www.clipconverter.cc/) [国外]
- [免费在线 YouTube 下载器-savefrom.net](https://zh.savefrom.net/) [国外]
- [Video Grabber免费下载海量视频资源](https://www.videograbber.net/zh/) [国外]

  

## 六、生活相关

**工作**

- [个人所得税计算器](http://shui.apple886.com/)  |  [个税计算器](https://www.gerensuodeshui.cn/)

<div align="right">
    <a href="#top">回到顶部</a>
</div>

> *Logo... Powered by [logomakr](https://logomakr.com/).*e