[toc]

# :fountain: Chrome 插件

**搜索和推荐：**

- [Chrome插件,Chrome商店,谷歌浏览器插件下载,谷歌商店 - Chrome插件网](<http://www.cnplugins.com/>)

- [Chrome插件(谷歌浏览器插件) - 提供Chrome商店中优秀的Chrome插件推荐与下载服务](<http://chromecj.com/>)

- [zhaoolee/ChromeAppHeroes](https://github.com/zhaoolee/ChromeAppHeroes) - Chrome 插件英雄榜。

  

## Chrome 扩展

### 1. GitHub 相关

- [Octotree](https://chrome.google.com/webstore/detail/octotree/bkhaagjahfmjljalopjnoealnfndnagc) - 左侧查看 GitHub 仓库项目文件。  [荐]  [必备] 
- [Enhanced Github](https://chrome.google.com/webstore/detail/enhanced-github/anlikcnbgdeidpacdbdljnabclhahhmd) - 能够显示代码仓库的大小，以及其中每个文件的大小和下载链接。  [荐]  [必备] 
- [GitHub Hovercard](https://chrome.google.com/webstore/detail/github-hovercard/mmoahbbnojgkclgceahhakhnccimnplk) - 停留用户头像悬浮显示信息。  [荐]  [必备] 
- [GitZip for github](https://chrome.google.com/webstore/detail/gitzip-for-github/ffabmkklhbepgcgfonabamgnfafbdlkn) - 可以随意下载 GitHub 文件和文件夹。使用参考：[Chrome扩展：GitZip for github 下载GitHub项目文件夹](https://www.xia1ge.com/gitzip-for-github.html)  [荐]  [必备]  
- [Sourcegraph for GitHub](https://chrome.google.com/webstore/detail/sourcegraph-for-github/dgjhfomjieaadpoljlnidmbgkdffpack) - 代码搜索，查看引用，自动跳转，项目目录导航，这些 IDE 上常用的功能操作，借助 Sourcegraph 插件，都能帮你直接在线使用。  [荐] 
- [Git History Browser Extension](<https://chrome.google.com/webstore/detail/git-history-browser-exten/laghnmifffncfonaoffcndocllegejnf?utm_source=chrome-ntp-icon>) - 可视化的方式显示文件修改历史。  [荐]
- [Awesome Autocomplete for GitHub](<https://chrome.google.com/webstore/detail/awesome-autocomplete-for/djkfdjpoelphhdclfjhnffmnlnoknfnd?utm_source=chrome-ntp-icon>) - GitHub 智能搜索插件，有点类似自动补全功能，实时监听输入的搜索关键字，自动列出相关内容。 
- ~~[The Fucking Github](<https://github.com/lvxianchao/the-fucking-github>)~~ - 方便地查看、整理、搜索你已经 Star 过的项目和搜索 Github 上的项目。注：新版暂未成功发布应用商店。
- [Refined GitHub](https://chrome.google.com/webstore/detail/refined-github/hlepfoohegkhhmjieoechaddaejaokhf/related?hl=en-US) - 在使用 GitHub 的过程中，有较强的不适感，可以尝试安装下该插件，它主要针对 GitHub 进行了优化，添加了非常多强大的功能，之前该插件加入的一些功能也被 GitHub 官方添加到了 Feature，正式应用到生产环境了。下面列举几个该插件功能：1. 将 PR 和 issue 设为未读状态；2. 优化评论区的交互，增加互动用户的头像；3. 在 404 页面添加项目相关的可点击链接
- [Octohint](https://chrome.google.com/webstore/detail/octohint/hbkpjkfdheainjkkebeoofkpgddnnbpk?hl=en-US) - 经常会遇到这样一种情况，在 GitHub 浏览代码时，想查看一个变量或函数名的定义，只能通过快捷键 `command + f`来查看，很不方便，于是就有人做了 Octohint 这个插件。这个插件的作用是当我们使用 GitHub 浏览代码时，默认会加入参数属性提示、变量名高亮等功能。这样我们就可以愉快的浏览代码啦。
- [Dashboard filter for GitHub](https://chrome.google.com/webstore/detail/dashboard-filter-for-gith/pcnaddhmngnnpookfhhamkelhhakimdg) - 该插件能帮忙很好过滤与筛选信息。例如过滤其他人 Star 或 Fork 我的开源项目所产生的动态，如果你开源的项目比较多，或在某段时间 Star 上涨比较快，那么这些次要信息就可能对你产生较大干扰，这时借助这个插件就可以很轻松的过滤掉。
- [Isometric Contributions](https://chrome.google.com/webstore/detail/isometric-contributions/mjoedlfflcchnleknnceiplgaeoegien?hl=en-US) - 这个插件比较有趣，它可以把你的 GitHub Commit 转化为 3D 模式进行显示，让你的提交记录看起来更加直观与生动。  [荐]
- [Notifier for GitHub](https://chrome.google.com/webstore/detail/notifier-for-github/lmjdlojahmbbcodnpecnjnmlddbkjhnn?hl=en-US) - 如果使用 GitHub 进行协作的频率比较高，那么可以考虑装下这个插件，它的主要作用是在插件栏显示 GitHub 未读消息数，同时也支持桌面通知，让你第一时间可以知道 GitHub 上是否来事儿了。
- [OctoLinker](<https://chrome.google.com/webstore/detail/octolinker/jlmafbaeoofdegohdhinkhilhclaklkp?utm_source=chrome-ntp-icon>) - 在你使用 GitHub 浏览代码的时候，会不会常常想，如果它有像 IDE 一样的自动链接跳转功能就好了，这款插件如你所愿，它可以帮助开发者在浏览代码时进行更高效的代码链接跳转。
- [Github File Icons](https://chrome.google.com/webstore/detail/github-file-icons/kkokonbjllgdmblmbichgkkikhlcnekp?hl=en-US) - 安装了这个插件，那么在使用 GitHub 的时候就能享受到打开 Atom 的那种左侧漂亮的文件图标体验，它会自动根据 GitHub 项目文件类型自动替换文件图标，让文件看起来更加直观形象。
- [Night Shift](<https://chrome.google.com/webstore/detail/night-shift/fpnlpehjhijpamloppfjljenemeokfio/related?utm_source=chrome-ntp-icon>) - Night Shift 将 Chrome标签（整个内容）的色温改变为色谱的淡黄色部分，从而减少屏幕上的一些蓝光，因此，在夜间使用时眼睛疲劳，有助于减少干扰睡眠模式。使用：<https://www.chrome666.com/chrome-extension/night_shift.html>
- [Github Stars Manager](<https://chrome.google.com/webstore/detail/github-stars-manager/epooeampfghdkampjnocabjniefmnkab>) - 直接在 GitHub 的 star 页面中增加 tag，可以直接导出数据到 Chrome 书签栏。

### 2. 功能增强

- [Tampermonkey](https://chrome.google.com/webstore/detail/tampermonkey/dhdgffkkebhmkfjojejmpbldmpobfkfo)  [荐]  [必备]

  用户脚本是一段代码，它们能够优化您的网页浏览体验。安装之后，有些脚本能为网站添加新的功能，有些能使网站的界面更加易用，有些则能隐藏网站上烦人的部分内容。在 Greasy Fork 上的用户脚本都是由用户编写并向全世界发表的，您可以免费安装，轻松体验。
  
  要使用用户脚本，您首先需要安装一个用户脚本管理器。根据您使用的浏览器不同，可用的用户脚本管理器也有所不同。Chrome 可以使用：Tampermonkey
  
  下载以及脚本搜索：https://greasyfork.org/zh-CN
  
  脚本推荐：[Userscript+](https://greasyfork.org/zh-CN/scripts/24508-userscript-show-site-all-userjs)，该脚本可以显示当前网站所有可用的 UserJS 脚本，并可一键安装。
  
  作用于 GitHub 网站的脚本推荐，这里有个仓库列举了很多【[Mottie/GitHub-userscripts](https://github.com/Mottie/GitHub-userscripts)】,以下重点列举几个常用的：
  
  1. [GitHub Table of Contents](<https://greasyfork.org/zh-CN/scripts/18344-github-table-of-contents>) - 在README和WIKI页面旁边自动生成目录。  [荐]  [必备]
  2. [GitHub Image Preview](<https://greasyfork.org/zh-CN/scripts/19773-github-image-preview>) - 图片预览。  [荐]  
  3. [GitHub Code Colors](<https://greasyfork.org/zh-CN/scripts/18141-github-code-colors>) - 在代码颜色定义旁边添加颜色。
  
- [FireShot](https://chrome.google.com/webstore/detail/take-webpage-screenshots/mcbpblocgmgfnpjjppndjkmgjaogfceg?utm_source=chrome-ntp-icon) - 捕捉网页截图，包括截取整个网页为图片。  [荐] [必备] 

- [Full Page Screen Capture](<https://chrome.google.com/webstore/detail/full-page-screen-capture/fdpohaocaechififmbbbbbknoalclacl?hl=zh-CN>) - 可用来截取整个页面。

- [书签侧边栏](<https://chrome.google.com/webstore/detail/bookmark-sidebar/jdbnofccmhefkmjbkkdkfiicjkgofkdh?utm_source=chrome-ntp-icon>) - 可以将 Chrome 的书签栏移动至浏览器两侧，并通过滑动或点击等方式唤出。在书签侧边栏的设置中，还可以自定义其外观、位置、行为等。  [荐] [必备]★★★

- [壹伴 · 小插件](https://chrome.google.com/webstore/detail/%E5%A3%B9%E4%BC%B4-%C2%B7-%E5%B0%8F%E6%8F%92%E4%BB%B6/ibefaeehajgcpooopoegkifhgecigeeg?utm_source=chrome-ntp-icon) - 简单好用的公众号效率工具。  [荐]

- [新媒体管家](<https://chrome.google.com/webstore/detail/%E6%96%B0%E5%AA%92%E4%BD%93%E7%AE%A1%E5%AE%B6/jicmnjcngcnfhgfggbdhlbjpcbadimaj?utm_source=chrome-ntp-icon>) - 新媒体运营工具，和壹伴都差不多。

- [OneTab](https://chrome.google.com/webstore/detail/onetab/chphlpgkkbolifaimnlloiipkdnihall?utm_source=chrome-ntp-icon) - 这个插件可以把网页暂时挂起，从而节省很多内存。  [荐]

- [Markdown Here](https://chrome.google.com/webstore/detail/markdown-here/elifhakcjgalahccnjkneoccemfahfoa?hl=zh-CN) - 简单来说，这款插件可以让你在通常的富文本编辑器上使用 Markdown 语言。

- [Infinity 新标签页(Pro)](https://chrome.google.com/webstore/detail/infinity-new-tab-pro/nnnkddnnlpamobajfibfdgfnbcnkgngh)

  百万用户选择的新标签页和快速拨号，自由添加网站图标，云端高清壁纸，快速访问书签、天气、笔记、待办事项、扩展管理与历史记录。使你的主页和开始页更加美观和易用
  
  百万用户选择的新标签页(Speed dial)，致力于创造真正高效优雅的极简生活。
  
  Infinity新标签页是一款基于html5的扩展程序，它将开启你的Chrome新标签页和火狐新标签页高度自定义时代。一步添加常用网站到新标签页并以图标展示，可定制的搜索引擎，精选高清壁纸，还有天气、笔记、书签、待办事项、历史记录、Gmail提醒等小挂件帮助提高生产力。
  
  相关介绍：[超好用的chrome扩展：Infinity新标签页功能全解！](https://zhuanlan.zhihu.com/p/45399388)

- 极简图床 - 通过该插件上传图片到图床，已弃，改用 PicGo 客户端更方便。 [已弃用]

- [惠惠购物助手](https://chrome.google.com/webstore/detail/%E6%83%A0%E6%83%A0%E8%B4%AD%E7%89%A9%E5%8A%A9%E6%89%8B/ohjkicjidmohhfcjjlahfppkdblibkkb?utm_source=chrome-ntp-icon) - 是网易有道出品的一款装机必备插件，轻松自动全网比价，商品历史价格走势，让你聪明购物。  [荐]

- [购物党自动比价工具](<https://chrome.google.com/webstore/detail/%E8%B4%AD%E7%89%A9%E5%85%9A%E8%87%AA%E5%8A%A8%E6%AF%94%E4%BB%B7%E5%B7%A5%E5%85%B7/jgphnjokjhjlcnnajmfjlacjnjkhleah/related?utm_source=chrome-ntp-icon>) - 在线的比价工具，网购的时候可以看价格历史记录，以及各大网站的价格对比，也有查快递的快捷方式。  [荐]

- [云盘万能钥匙](https://chrome.google.com/webstore/detail/%E4%BA%91%E7%9B%98%E4%B8%87%E8%83%BD%E9%92%A5%E5%8C%99/anlllmnpjodopgbkbpnghnjlelnogfjc?hl=zh-CN) - 能自动打开设置了密码但分享过的百度云文件。  [荐]

- [EPUBReader](https://chrome.google.com/webstore/detail/epubreader/jhhclmfgfllimlhabjkgkeebkbiadflb?utm_source=chrome-ntp-icon) - 可以直接在浏览器中打开 EPUB 格式的电子书阅读。  [荐]

- [Anything to QRcode](https://chrome.google.com/webstore/detail/anything-to-qrcode/calkaljlpglgogjfcidhlmmlgjnpmnmf/related) - 帮你将网页上的二维码解析出真实的链接地址，或者一键将当前的网页地址、图片网址、选中文字生成二维码图片。可完全离线使用。  [荐]

- [二維碼生成器 (Quick QR)](https://chrome.google.com/webstore/detail/quick-qr-code-generator/afpbjjgbdimpioenaedcjgkaigggcdpp/related?hl=zh-CN) - 一键生成二维码，自动添加当前网页 URL 为二维码内容，或者手动添加其他内容，可以简单修改二维码样式。  [荐]

- [滴答清单 - Todo & 任务提醒](https://chrome.google.com/webstore/detail/ticktick-todo-task-list/diankknpkndanachmlckaikddgcehkod?utm_source=chrome-ntp-icon) - 滴答清单，一个帮你高效完成任务和规划时间的应用，是一款拥有跨设备云同步、周期提醒、清单管理、清晰分类、协作和集成日历的应用。

- [Simple Allow Copy](https://chrome.google.com/webstore/detail/simple-allow-copy/aefehdhdciieocakfobpaaolhipkcpgc/related?utm_source=chrome-ntp-icon)  [荐]

  有些网站为了防止你拷贝上面的内容，比如某些网站有版权保护内容是不允许你拷贝的，如果你一定要拷贝，低效的方法就是手动逐个字的敲，装上 Allow Copy 这款插件，瞬间就恢复拷贝功能。

- [PaintMagick](https://chrome.google.com/webstore/detail/image-editor-paintmagick/gefjgcijamcglmolelmpeegnflbjalfa/related?utm_source=chrome-ntp-icon)

  PaintMagick 使用 Web 浏览器在线创建和编辑照片和图像。
  
  PaintMagick 是照片的图像编辑器，并使用高级绘图功能，效果和滤镜进行绘制。它允许直接在Web浏览器中创建和编辑图像。您可以创建图像，从剪贴板粘贴（ctrl + v）或从计算机上传（使用菜单或拖放）。一切都停留在你的网页浏览器中。
  
  另外还有视频编辑、视频转换、音频编辑、文档编辑等功能。

- [crxMouse Chrome™ 手势](https://chrome.google.com/webstore/detail/crxmouse-chrome-gestures/jlgkpaicikihijadgifklkbpdajbkhjo/related?utm_source=chrome-ntp-icon)  

  该插件可以用鼠标手势完成比如关闭标签页、新增标签页、打开主页、前进、后退、刷新等功能，非常方便。

- [违禁词检查](https://chrome.google.com/webstore/detail/%E8%BF%9D%E7%A6%81%E8%AF%8D%E6%A3%80%E6%9F%A5/hidcgccgkiamehonfofohinbaeefabmi?utm_source=chrome-ntp-icon) - 检查商品描述中可能违反广告法，可能导致用户投诉的违禁词和高风险词，且支持图片文字识别。

- [Toggle JavaScript](https://chrome.google.com/webstore/detail/toggle-javascript/cidlcjdalomndpeagkjpnefhljffbnlo/related?utm_source=chrome-ntp-icon)

  Toggle JavaScript provides a simple, easy-to-access browser button to enable or disable JavaScript globally. 
  
  翻译过来就是说：你可以控制浏览器是否加载 JavaScript 代码，这个对于爬虫爱好者来说是很实用的工具，可以看出哪些是动态加载的东西。

- [Chrono下载管理器](https://chrome.google.com/webstore/detail/chrono-download-manager/mciiogijehkdemklbdcbfkefimifhecn/related?utm_source=chrome-ntp-icon)

  Chrono下载管理器是 Chrome 浏览器下第一款(也是唯一一款)功能全面的下载管理工具。Chrono 接管你在 Chrome 中的所有下载，你的所有下载管理工作都在浏览器中完成，而不需要安装另外的程序。 Chrono 与 Chrome 浏览器紧密地整合在一起，添加了对浏览器菜单、工具栏和快捷键的支持。

- [下载+](<https://chrome.google.com/webstore/detail/download-plus/gokgophibdidjjpildcdbfpmcahilaaf/related?utm_source=chrome-ntp-icon>) - Chrome 的下载管理在二级菜单里，进去很不方便。装了这个插件就可以直接看和管理，很好用。

- [右键搜](https://chrome.google.com/webstore/detail/context-menus/phlfmkfpmphogkomddckmggcfpmfchpn/related?utm_source=chrome-app-launcher-info-dialog)

  扩展右键菜单，超过 300 种功能，方便的选择、组合或自定义页面、划词、图片菜单，并有生成、解析二维码和短网址功能。设置可使用云存储。最新增加功能共享、资源下载、重命名等功能。右键搜伴侣增加超级拖拽。

  - 对图片右击，可以选择去谷歌搜索相似图片|解析图片的网址|提取图片二维码
  - 对页面右击，可以定制进入浏览器扩展程序菜单|查看内存|生成当前网址二维码
  - 更关键的是，它还支持自定义很多功能，例如，你可以设置对选中文字，进行在知乎里搜索，可以通过方法，自定义搜索引擎。

  使用：[右键搜：为Chrome添加多个右键搜索引擎](https://jingyan.baidu.com/article/3c48dd3471d67fe10be358fd.html)

- [Search to Play the Song](https://chrome.google.com/webstore/detail/search-to-play-the-song/anfmgjkkbagjfdejhbjdiapgkbhpigpm/related?utm_source=chrome-ntp-icon)  [荐]

  搜我听歌 (SPS) 是 Search to Play the Song 的缩写，它是一款非常极简干净且完全免费的 Chrome 浏览器插件扩展。通过它，你不必安装任何音乐播放器软件客户端，即可在一个地方搜索并在线播放虾米音乐、QQ音乐、网易云音乐等服务的歌曲，非常的方便。另外还能在线听广播电台。
  
  搜索功能，默认只有五条，只可以听，也没有提供下载。所以想单纯听个歌，它是个不错的选择。

- [Holmes](https://chrome.google.com/webstore/detail/holmes/gokficnebmomagijbakglkcmhdbchbhn/related) - 搜索浏览器书签。[荐]  [必备]

- [Search by Image (by Google)](https://chrome.google.com/webstore/detail/search-by-image-by-google/dajedkncpodkggklbegccjpmnglmnflm/related) - 通过图片搜索图片：可以在网页上任何的图片身上右键点击进行 Google 的“以图搜图”，缩略图找原图或找相似图片的利器。  [荐]  [必备]

- [Context Menu Search](https://chrome.google.com/webstore/detail/context-menu-search/ocpcmghnefmdhljkoiapafejjohldoga/related) - Chrome 右键默认只能进行 Google 搜索，这枚插件可以为你的右键增加多个搜索引擎，百度、淘宝、必应、360 等等，想用什么搜就用什么搜。  [荐]

- [IE Tab](https://chrome.google.com/webstore/detail/ie-tab/hehijbfgiekmjfkfjpbkbammjbdenadd) - 在 Windows 系统下可以快速切换到 IE 浏览器内核，对付那些不支持 Chrome 的网站。

- [Pushbullet](https://chrome.google.com/webstore/detail/pushbullet/chlffgpmiacpedhhbkiomidkjlcfhogd) - 可以快速在 iOS、Android 手机和电脑的 Chrome 之间互相传递文字、链接、图片等信息。

- [APK Downloader](https://chrome.google.com/webstore/detail/apk-downloader/fgljidimohbcmjdabiecfeikkmpbjegm/related) - 无需帐号即可直接在 Google Play 商店中直接下载 Android 的 apk 安装包。  [荐]

- [Incognito-Filter](https://chrome.google.com/webstore/detail/incognito-filter/cifilbmpnkjinlkchohdfcpdkmpngiik/related) - 让指定的网站在“隐身窗口”中打开，用来对付一些不太想留痕迹的网站。

- [Vimium](https://chrome.google.com/webstore/detail/vimium/dbepggeogbaibhgnhhndojpepiihcmeb)  [荐]

  Vimium 名字其实是 Vim 和 Chromium 的合体。一看到Vim作为程序猿肯定不陌生，但是对于其他非IT行业的人可能还不知道，简单的说，Vim 其实是 Linux 等平台上的一款文本编辑器，它可以让你彻底脱离鼠标，通过一系列快捷键，来操作任何一件事情。Vimium 就是吸取了Vim常用的快捷键，让你在使用 Chrome 的过程中，无论是浏览网页、切换标签或是其它任何操作，都可以只通过键盘完成。想像一下，你再也不需要移动鼠标去打开一个链接，手指不用离开键盘，一切都是这么流畅。使用：[让你用 Chrome 上网快到想哭：Vimium - 少数派](https://sspai.com/post/27723)
  
- [Save to Pocket](<https://chrome.google.com/webstore/detail/save-to-pocket/niloccemoadcdkdjlinkgdfekeahmflj/related?utm_source=chrome-ntp-icon>)   

  Save To Pocket 插件是目前谷歌浏览器上最优秀的一款实用辅助插件，该插件可以安装在以 Chrome 为内核的任何浏览器上，其功能和网页收藏夹相同，能够一键收藏你想再次观看的网页，视频，文章等页面，并且支持以后在 Android，iOS 中查看。Android 版下载，Google Play：[Pocket](<https://play.google.com/store/apps/details?id=com.ideashower.readitlater.pro>)
  
- [Raindrop.io](https://chrome.google.com/webstore/detail/raindropio-save-button-fo/ldgfbffkinooeloadekpmfoklnobpien?utm_source=chrome-ntp-icon)   [荐]  可用来替代 Pocket

  Raindrop.io 是一款 Chrome 中的智能书签，可以根据用户保存的书签类型来为用户保存书签的显示样式，使得 Chrome 中的书签变得更加生动。支持火狐、Safari、Opera 等各种浏览器，也支持苹果和微软电脑，更支持 iPhone、iPad 和安卓手机。使用：[Raindrop.io：智能书签](http://chromecj.com/productivity/2015-05/465.html)
  
- [Focus Image Viewer | 专注看图](<https://chrome.google.com/webstore/detail/focus-image-viewer-%E4%B8%93%E6%B3%A8%E7%9C%8B%E5%9B%BE/bidhfhcmmbkgcblpicmjdkoagiimgiao/related>)

  一个美观易用的看图界面，帮助你专注于网页中的图片。该扩展提供一个美观易用的看图界面，能够帮助你专注于网页中的图片，而不被其他东西分心。

**科学上网：**

- [谷歌访问助手](https://chrome.google.com/webstore/detail/%E8%B0%B7%E6%AD%8C%E8%AE%BF%E9%97%AE%E5%8A%A9%E6%89%8B/gocklaboggjfkolaknpbhddbaopcepfp?utm_source=chrome-ntp-icon) - 使用该插件可以免费上：

  ```xml
  - google.com(谷歌搜索)
  - mail.google.com(gmail邮箱)
  - chrome商店访问
  ```

- [SetupVPN](<https://chrome.google.com/webstore/detail/setupvpn-lifetime-free-vp/oofgbpoabipfcfjapgnbbjjaenockbdp/related?utm_source=chrome-ntp-icon>) - 免费 VPN，无需技术知识，只需下载扩展程序，创建一个帐户即可完成。【目前可用，荐】

- [TouchVPN](https://touchvpn.net/) - 官网显示有 Android、Windows、Chrome插件、iOS、MacOS 版本。

**插件开与关：**

- [Extensity](https://chrome.google.com/webstore/detail/extensity/jjmflmamggggndanpgfnpelongoepncg/related?utm_source=chrome-ntp-icon) - Chrome 插件和应用的开启和关闭。  [荐] 
- [扩展管理](<https://chrome.google.com/webstore/detail/extmanager/bgejgfcdaicmfbfphchgcdgnpnbcondb?utm_source=chrome-ntp-icon>) - 管理 Chrome 插件，在需要某扩展的时候快速启用，不需要的时候禁用掉，回收所占资源。这个也很不错。  [荐]  
- [Context](https://chrome.google.com/webstore/detail/context/aalnjolghjkkogicompabhhbbkljnlka/related) - 可以快速开启、禁用全部扩展，或者启用停止单个扩展，还可以让你对扩展进行分组，并且可以快速启用/禁用某个分组的扩展。
- [一键管理所有扩展](https://chrome.google.com/webstore/detail/%E4%B8%80%E9%94%AE%E7%AE%A1%E7%90%86%E6%89%80%E6%9C%89%E6%89%A9%E5%B1%95/lboblnfejcmcaplhnbkkfcienhlhpnni) - 浏览器插件开启和关闭。  [荐]
- [一键管理](https://chrome.google.com/webstore/detail/%E4%B8%80%E9%94%AE%E7%AE%A1%E7%90%86/kfjmkgngkgpgjdoealkmmajmmhpnffoj?utm_source=chrome-ntp-icon) - 一键开启、禁止所有应用，一键开启关闭扩展，一键直达应用，一键直达常用功能，一键能做很多。

**翻译：** 

- [沙拉查词](https://chrome.google.com/webstore/detail/沙拉查词-聚合词典划词翻译/cdonnmffkdaoajfknoeeecmchibpmkmg?utm_source=chrome-ntp-icon) - 一款专业划词翻译扩展。[荐] [必备]
- [ImTranslator: 翻译，字典，声音](<https://chrome.google.com/webstore/detail/imtranslator-translator-d/noaijdpnepcgjemiklgfkcfbkokogabh?hl=zh-CN>) - ImTranslator执行的选定文本，单词，短语和网页翻译。ImTranslator 可以阅读10种语言的文字。

**广告：** 

- [AdBlock](https://chrome.google.com/webstore/detail/adblock/gighmmpiobklfepjocnamgkkbiglidom/related?utm_source=chrome-ntp-icon) - 它屏蔽了几乎所有烦人的弹出广告、Banner广告、图片广告等。带来的直接结果就是：页面变干净了，页面加载速度变快了，以及流量和电量的节省；还有对网络安全和隐私的保护。

- [Adblock Plus](https://chrome.google.com/webstore/detail/adblock-plus-free-ad-bloc/cfhdojbkjhnklbpkdaibdccddilifddb?hl=zh-CN) - 最受欢迎的广告拦截扩展。

- [uBlock Origin](<https://chrome.google.com/webstore/detail/ublock-origin/cjpalhdlnbpafiamejdnhcphjbkeiagm?utm_source=chrome-ntp-icon>) - 可屏蔽你用百度搜索排在前面的那些广告。  [荐]★★

   一款自由、开源、跨平台的内容过滤浏览器扩展，包含广告屏蔽功能。此扩展可在多款浏览器上使用，包括 Safari、Chrome、Edge、Firefox 和 Opera 及相关的兼容浏览器。官方介绍是：一款高效的网络请求过滤工具，占用极低的内存和 CPU；它不只是一个广告拦截工具，它还可以从 hosts 文件里读取和创建过滤规则。

- [Cloudopt AdBlocker](<https://chrome.google.com/webstore/detail/cloudopt-adblocker/cnffkgfknlbnbfhihojeagbmcdcfdcnb?utm_source=chrome-ntp-icon>) - 可能是东半球最强安全插件，实时保护您的安全、防止追迹、恶意域名，过滤横幅广告、弹窗广告以及视频广告。

**工具：** 

- [Smallpdf - 编辑、压缩与转换PDF文件](<https://chrome.google.com/webstore/detail/smallpdf-edit-compress-an/ohfgljdgelakfkefopgklcohadegdpjf/related>) - 轻松易用的PDF工具，可用于编辑、转换、合并、拆分和压缩PDF文件。可与Gmail整合。

### 3. 开发辅助

- [掘金](https://chrome.google.com/webstore/detail/%E6%8E%98%E9%87%91/lecdifefmmfjnjjinhaennhdlmcaeeeb?utm_source=chrome-ntp-icon)  [荐] [必备]

- [WEB前端助手(FeHelper)](https://chrome.google.com/webstore/detail/web%E5%89%8D%E7%AB%AF%E5%8A%A9%E6%89%8Bfehelper/pkgccpejnmalmdinmhkkfafefagiiiad)

  包括 JSON 格式化、二维码生成与解码、信息编解码、代码压缩、美化、页面取色、Markdown 与 HTML 互转、网页滚动截屏、正则表达式、时间转换工具、编码规范检测、页面性能检测、Ajax 接口调试、密码生成器、JSON 比对工具、网页编码设置、便签笔记。

- [Tab Resize](https://chrome.google.com/webstore/detail/tab-resize-split-screen-l/bkpenclhmiealbebdopglffmfdiilejc/related?utm_source=chrome-ntp-icon)

  Tab Resize是一款可以将显示屏变成二、三个独立视图，并等分在显示屏的画面，当然用户也可以自行分割画面，当一键立即就可将页面等分，因此在一个屏幕中，同时看到多个网页。Tab Resize内建了五种不同的视窗排列样式，只要点一下 Tab Resize 按钮再按你要的分割方式，即可快速分割、排列并占满你的显示屏。要恢复时，只要再点“Undo”按钮即可恢复就可以了。
  
  使用：[Tab Resize：浏览器屏幕分割插件](http://chromecj.com/accessibility/2017-09/809.html)

- [Classic Cache Killer](https://chrome.google.com/webstore/detail/classic-cache-killer/kkmknnnjliniefekpicbaaobdnjjikfp?utm_source=chrome-ntp-icon)

  是一款 Chrome 缓存自动清理插件，启用之后可以在每个页面加载之前自动清除掉 Chrome 的缓存。
  
  插件安装完毕后会在右上角出现一个图标，点击即可控制插件的开关。插件打开时，就会禁用一切缓存，这样我们就可以随心所欲地进行任何设计和开发了，无需担心缓存卡住。不需要禁用缓存的时候，点击一下图标即可关闭插件，开启缓存。

- [Web Scraper](https://chrome.google.com/webstore/detail/web-scraper/jnhgnonknehpejjnehehllkliplmbmhn/related?utm_source=chrome-ntp-icon)

  Web Scraper是一款免费的 Chrome 扩展，通过建立 sitemap 遍历网站抓取相应的数据。无需写代码，即可抓取 95% 以上的网站。
  
  使用：[ WebScraper 中文文档 · 看云](http://webscraper.top/543178)

- [WhatRuns](<https://chrome.google.com/webstore/detail/whatruns/cmkdbmfndkfgebldhnkbfhlneefdaaip?utm_source=chrome-ntp-icon>)

  WhatRuns 是一款用于了解网站技术的扩展，主要能通过分析网站页面所使用的框架、代码等技术以及页面所使用的样式等方面，让使用者能直观的了解网站的整体技术信息。
  
- [Repl.it](<https://chrome.google.com/webstore/detail/replit/kihnihckibjknmebghcjpmemaginnipl/related?utm_source=chrome-ntp-icon>)

  Repl.it 是一款允许你浏览器上编程的云端 IDE，支持编译并运行包括 C、Python、JavaScript、Ruby 等在内的超过 50 种语言，无需下载，即开即用。而其第三方 Chrome 扩展，则给任意网页中的代码片段增加了一键运行按钮，省去复制到本地编译的流程。

- [Simple Extension](<https://chrome.google.com/webstore/detail/simple-extension/ofhbnimjijmnaigdfhhmhegnlmcbilba>)

  简易扩展的名字相当实诚，但功能性却毫不逊色。它可以帮助你快速切换用户代理、管理多个 Cookies、监听网络请求、改写静态和动态网址等，可谓前端开发者必备。
  
- [Office Online](<https://chrome.google.com/webstore/detail/office-online/ndjpnladcallmjemlbaebfadecfhkepb?utm_source=chrome-ntp-icon>)

  为 Chrome 打造 - 无需安装 Office，即可使用 Word、Excel、PowerPoint、OneNote 和 Sway Online。
  
- [JSONView](<https://chrome.google.com/webstore/detail/jsonview/chklaanhfefbnpoihckbnefhakgolnmc/related?utm_source=chrome-ntp-icon>)

  api 接口一般都是默认返回 json 格式，想要查看具体返回哪些内容的时候通过 Chrome 查看全乱的，而且中文编码也不对，而有了这个插件就不一样了，自动跟你排列出 Json 数据，不管返回数据有多复杂，你都可以很直观的了解他的数据格式。

- [Visual Inspector](<https://chrome.google.com/webstore/detail/visual-inspector/efaejpgmekdkcngpbghnpcmbpbngoclc/related?utm_source=chrome-ntp-icon>)

  可以比较方便地获取当前浏览网页的各种资源和规范。
  
- [WakaTime](<https://chrome.google.com/webstore/detail/wakatime/jnbbnacmeggbgdjgaoojpmhdlkkpblgi/related?utm_source=chrome-ntp-icon>)

  一款可以记录编码时间的工具。目前支持绝大部分主流的 IDE 以及 Chrome 浏览器。使用参考：[WakaTime数据同步展示工](<https://juejin.im/post/5c4172e5518825265c2fe8ba>)。
  
- [Website IP](<https://chrome.google.com/webstore/detail/website-ip/ghbmhlgniedlklkpimlibbaoomlpacmk?utm_source=chrome-ntp-icon>)  [荐]

  将当前网站的 IP 显示在右下角，便于本地开发网站调试。

- [Page Ruler](<https://chrome.google.com/webstore/detail/page-ruler/emliamioobfffbgcfdchabfibonehkme?utm_source=chrome-ntp-icon>)
  
  可以让你在任何页面，都可以随意测量网页上元素的尺寸和位置。不仅仅可以测量元素的宽度和高度，同时可以测出元素所相对于页面的绝对位置，对于前端工程师们来说，这应该是不错和好用的测量插件。
  
- [Auto Refresh](<https://chrome.google.com/webstore/detail/auto-refresh/ifooldnmmcmlbdennkpdnlnbgbmfalko?hl=zh-CN>)

  用于自动刷新页面。这款插件可以自定义刷新间隔的时间。抢车票、秒杀或者是需要实时刷新页面的时候用这款插件很方便。
  
- [SimilarWeb - 网站流量来源和排名](<https://chrome.google.com/webstore/detail/similarweb-traffic-rank-w/hoklmmgfnpapgjgcpechhaamimifchmp?utm_source=chrome-ntp-icon>)

  通过 SimilarWeb 扩展程序查看真实的深入网站参与、流量来源和网站排名信息。

### 4. 其他插件

- [Natasha](https://chrome.google.com/webstore/detail/natasha/icnhghjkdcenmhomcfikdfpkmekhhlej/)

  Natasha 的插件，旨在各大招聘网站标记 996.ICU 和 955.WLB 上榜公司。目前支持的浏览器或者招聘网站并不是很多。——2018-04-12

- [莆田系医院网站提醒](<https://chrome.google.com/webstore/detail/莆田系医院网站提醒/pihadmdiehanenijehoohjnpiaofmmng?utm_source=chrome-ntp-icon>)

  用户只要访问莆田系医院，该扩展便会迅速变成红色，并给出它的医院名字和所在城市。这样你自然就能轻松识别出这些缺乏责任感的医院，增强防备心理。

- [Password Checkup](<https://chrome.google.com/webstore/detail/password-checkup/pncabnpcffmalkkjpajodfhijclecjno/related?utm_source=chrome-ntp-icon>)

  Google 于近期推出了 Password Checkup 扩展，当检测到你正在使用的用户名和密码存在于 40 亿条泄露数据库内时，自动弹出提醒，保护个人隐私。

- [Simplify Gmail](<https://chrome.google.com/webstore/detail/simplify-gmail/pbmlfaiicoikhdbjagjbglnbfcbcojpj/related?utm_source=chrome-ntp-icon>)

  为了完成 KPI，Google 大刀部把广受欢迎的 Inbox 砍掉了，如果你曾是 Inbox 忠实用户，可能会对陈旧的 Gmail 界面感到不适应。为了拯救你的收件箱，前 Inbox 设计师 Michael Leggett 开发了 Simplify Gmail 扩展，重新设计了按钮和元素的摆放位置，隐藏了侧边栏，让界面更加清爽干净。

- [Google Results Previewer](<https://chrome.google.com/webstore/detail/google-results-previewer/mkmjdljkedjpedbceoaaghdmcnipdcjf/related?utm_source=chrome-ntp-icon>)

  使用 Google 搜索时，你可能需要同时浏览对比多个结果。这时，按首页排序一路点下去就未免过于低效。而 Google Results Previewer 就可以在当前页面小窗加载鼠标悬停的链接，并支持进一步交互，提高信息检索效率。
  
- [牛客简历助手](https://chrome.google.com/webstore/detail/%E7%89%9B%E5%AE%A2%E7%AE%80%E5%8E%86%E5%8A%A9%E6%89%8B/iihgchombimnadbbapofogflgbifgbgl) - 简历一次填写，N 网闪填，适配市面80%以上招聘网站，节省70%以上的简历重复填写时间。
  
- [Grammarly for Chrome](https://chrome.google.com/webstore/detail/grammarly-for-chrome/kbfnbcaeplbcioakkpcpgfkobkghlhen?hl=cn) - 英语语法纠正，为你检查那些自己未注意到的单词、语法、时态错误，并提供更准确的纠正方法。基础版免费。有 word 插件。
  
  
  



## Chrome 应用

- [Lucidchart 离线图表](https://chrome.google.com/webstore/detail/lucidchart-diagrams-deskt/djejicklhojeokkfmdelnempiecmdomj?hl=zh-CN)

  在线和离线绘制流程图、实体模型、UML、思维导图与更多图表的最便捷方式。
  
  Lucidchart 是一种可视化协作工具，可使图表的绘制快速而轻松。在您安装完毕后，即可轻松在线或离线创建和编辑图表！在线时可轻松与他人分享图表，以便体验实时协作，所作更改瞬间即可合并和同步完毕。
  
  此工具永久免费，包含部分功能限制。高级功能可免费试用 14 天。

- [Secure Shell App](https://chrome.google.com/webstore/detail/secure-shell-app/pnhechapfaindjhompbnflcldabbghjo/related)

  对于拥有自己服务器的人来讲，ssh 连接服务器是很常用的操作。Linux 用户一般通过命令搞定，windows 用户需要下载额外的软件，而对于 Chrome 用户，我们可以使用 ssh 的插件 Secure Shell App。
  
  使用：[003《Secure Shell App》 Chrome中开启ssh一种什么体验](https://zhaoolee.gitbooks.io/chrome/content/003-secure-shell-app-chromezhong-kai-qi-ssh-yi-zhong-shi-yao-ti-yan.html)
  
- [Postman](<https://chrome.google.com/webstore/detail/postman/fhbjgbiflinjbdggehcddcbncdddomop>)

  Postman 是一款功能超级强大的用于发送 HTTP 请求的 Chrome插件应用，方便我们测试服务器接口。而不需要像以前一样专门写个测试页面或测试代码去发送数据。
  
  使用：[Chrome插件 postman的使用方法详解！最全面的教程](<https://blog.csdn.net/LongtengGensSupreme/article/details/80493307>)



## 油猴脚本

- [Userscript+ ](<https://greasyfork.org/zh-CN/scripts/24508-userscript-show-site-all-userjs>) - 显示当前网站的所有可用 UserJS(Tampermonkey) 脚本。  [荐]  
- [PanDownload网页版跳转按钮（UI美化版）](https://greasyfork.org/zh-CN/scripts/385966-pandownload%E7%BD%91%E9%A1%B5%E7%89%88%E8%B7%B3%E8%BD%AC%E6%8C%89%E9%92%AE-ui%E7%BE%8E%E5%8C%96%E7%89%88) - 百度网盘分享链接页面加个按钮，点击可跳转到 PanDownload 网页版去下载。
- [百度网盘直链下载助手](https://greasyfork.org/zh-CN/scripts/39504-百度网盘直链下载助手) - 可直接下载百度文件。  [荐]
- [百度云插件+APIKey](<https://greasyfork.org/zh-CN/scripts/496-%E7%99%BE%E5%BA%A6%E4%BA%91%E6%8F%92%E4%BB%B6-apikey>) - 在百度云网盘的页面添加一个搜索框，调用搜索 API 搜索所有公开分享文件。
- [网盘助手]([https://greasyfork.org/zh-CN/scripts/378301-%E7%BD%91%E7%9B%98%E5%8A%A9%E6%89%8B](https://greasyfork.org/zh-CN/scripts/378301-网盘助手))
- [搜索引擎一键切换 soTab](<https://greasyfork.org/zh-CN/scripts/14856-sotab-search-engine-switcher>) - 在常用的搜索引擎页面中添加互相切换的按钮，包括图片、视频、知道、学术搜索。  [荐]
- [百度文库文字复制](<https://greasyfork.org/zh-CN/scripts/369861-%E7%99%BE%E5%BA%A6%E6%96%87%E5%BA%93%E6%96%87%E5%AD%97%E5%A4%8D%E5%88%B6>) - 添加一个按钮，复制百度文库中的文字。
- ......
