[toc]

# :crystal_ball: 集成开发环境/编辑器插件

- [WakaTime](<https://wakatime.com/plugins>)

  一款可以记录编码时间的工具。目前支持绝大部分主流的 IDE 以及 Chrome 浏览器。使用参考：[WakaTime数据同步展示工](<https://juejin.im/post/5c4172e5518825265c2fe8ba>)。

  ![](https://img-1256179949.cos.ap-shanghai.myqcloud.com/20190716195451.png)



## :yum: VS Code

- [VSC Netease Music](https://github.com/nondanee/vsc-netease-music) - 听歌小插件。







## :yum: Intellij IDEA

1、插件安装

打开 setting 文件选择 Plugins 选项：

- Ctrl + Alt + S
- File -> Setting

分别是安装 JetBrains 插件，第三方插件，本地已下载的插件包。

2、插件收集

- **Statistic**

  统计各类文件，对象个数，文件大小，行数等等属性信息。安装和使用参考：[IDEA 代码统计插件 --- Statistic](https://blog.csdn.net/u014430366/article/details/77574222)

- **activate-power-mode 和 Power mode II**

  根据 Atom 的插件 activate-power-mode 的效果移植到 IDEA 上。写代码是整个屏幕都在抖动，activate-power-mode 是白的的，Power mode II 色彩更酷炫点。

- **Background Image Plus**

  idea 背景修改插件，让你的 idea 与众不同，可以设置自己喜欢的图片作为 code 背景。

  安装成功之后重启，菜单栏的 View 标签 -> 点击 Set Background Image(没安装插件是没有这个标签的)，在弹框中路由选择到本地图片，点击 OK 即可。

- **Grep console**

  自定义日志颜色，idea 控制台可以彩色显示各种级别的 log，安装完成后，在 console 中右键就能打开。并且可以设置不同的日志级别的显示样式。可以直接根据关键字搜索你想要的，搜索条件是支持正则表达式的。

- **Free Mybatis plugin**

  mybatis 插件，让你的 `mybatis.xml` 像 java 代码一样编辑。我们开发中使用 mybatis 时时长需要通过 mapper 接口查找对应的 xml 中的 sql 语句，该插件方便了我们的操作。

  安装完成重启 IDEA 之后，我们会看到 code 左侧或多出一列绿色的箭头，点击箭头我们就可以直接定位到 xml 相应文件的位置。

- **MyBatis Log Plugin**

  mybatis 现在是 java 中操作数据库的首选，在开发的时候，我们都会把 mybatis 的脚本直接输出在 console 中，但是默认的情况下，输出的脚本不是一个可以直接执行的。如果我们想直接执行，还需要在手动转化一下。MyBatis Log Plugin 这款插件是直接将 mybatis 执行的 sql 脚本显示出来，无需处理，可以直接复制出来执行的。执行程序后，我们可以很清晰的看到我们执行了哪些 sql 脚本，而且脚本可以执行拿出来运行。

- **String Manipulation**

  强大的字符串转换工具。使用快捷键，Alt+M。

  ``` xml
  切换样式（camelCase, hyphen-lowercase, HYPHEN-UPPERCASE, snake_case, SCREAMING_SNAKE_CASE, dot.case, words lowercase, Words Capitalized, PascalCase）
  转换为SCREAMING_SNAKE_CASE (或转换为camelCase)
  转换为 snake_case (或转换为camelCase)
  转换为dot.case (或转换为camelCase)
  转换为hyphen-case (或转换为camelCase)
  转换为hyphen-case (或转换为snake_case)
  转换为camelCase (或转换为Words)
  转换为camelCase (或转换为lowercase words)
  转换为PascalCase (或转换为camelCase)
  选定文本大写
  样式反转
  ```

- **Alibaba Java Coding Guidelines**

  阿里巴巴代码规范检查插件，当然规范可以参考《阿里巴巴Java开发手册》。

- **Lombok**

  Java 语言，每次写实体类的时候都需要写一大堆的 setter，getter，如果 bean 中的属性一旦有修改、删除或增加时，需要重新生成或删除 get/set 等方法，给代码维护增加负担，这也是 Java 被诟病的一种原因。

  Lombok 则为我们解决了这些问题，使用了lombok的注解(@Setter,@Getter,@ToString,@@RequiredArgsConstructor,@EqualsAndHashCode或@Data)之后，就不需要编写或生成 get/set 等方法，很大程度上减少了代码量，而且减少了代码维护的负担。

  安装完成之后，在应用Lombok的时候注意别忘了需要添加依赖，maven 为例：

  ``` xml
  <dependency>
      <groupId>org.projectlombok</groupId>
      <artifactId>lombok</artifactId>
  </dependency>
  ```

  ``` java
  @Setter
  @Getter
  @ToString
  @EqualsAndHashCode
  public class People {
      private String name;
      private int age;
      private String male;
  }
  ```

- **Key promoter**

  Key promoter 是 IntelliJ IDEA 的快捷键提示插件，会统计你鼠标点击某个功能的次数，提示你应该用什么快捷键，帮助记忆快捷键，等熟悉了之后可以关闭掉这个插件。

- **Gsonformat**

  可根据 json 数据快速生成 java 实体类。

  自定义个 javaBean(无任何内容，就一个空的类)，复制你要解析的 Json，然后 alt+insert 弹出如下界面或者使用快捷键 Alt+S，在里面粘贴刚刚复制的 Json，点击 OK 即可。

- **Restfultookit**

  Spring MVC 网页开发的时候，我们都是通过 requestmapping 的方式来定义页面的 URL 地址的，为了找到这个地址我们一般都是 cmd+shift+F 的方式进行查找，大家都知道，我们 URL 的命名一个是类requestmapping+方法requestmapping，查找的时候还是有那么一点不方便的，restfultookit 就能很方便的帮忙进行查找。

  例如：我要找到 /user/add 对应的 controller，那么只要 Ctrl+斜杠，就能直接定位到我们想要的 controller。当然 restfultookit 还为我们提供的其他的功能。

- **JRebel**

  JRebel 是一种热部署生产力工具，修改代码后不用重新启动程序，所有的更改便可以生效。它跳过了 Java 开发中常见的重建、重新启动和重新部署周期。
  
  

---

---



#### 一、官方工具

IntelliJ IDEA 默认安装并提供了非常多的工具，比如 Git Integration、Maven Integration、Markdown support、SSH Remote Run 等。其中有很多好用，但是不为人知的工具。

##### 1. REST client

在日常开发过程中，我们或多或少都涉及到 API 接口的测试。例如，有的小伙伴使用 Chrome 的 Postman 插件，或者使用火狐的 restclient 等工具。事实上，这些工具是测试 API 接口非常有效的方式之一，笔者之前也一直使用 Postman 完成 API 接口的测试工作。今天，笔者推荐另外一个非常好用的小工具，能够帮助读者快速测试 API 接口。这个工具就是 IDEA 的 Editor REST Client。IDEA 的 Editor REST Client 在 IntelliJ IDEA 2017.3 版本就开始支持，在 2018.1 版本添加了很多的特性。事实上，它是 IntelliJ IDEA 的 HTTP Client 插件。详细使用文档，参考：<http://blog.720ui.com/2018/restclient_use/>

##### 2. UML Support

如果需要研究源码，内置 UML Support 插件可以很好地查看类继承关系。详细使用文档，参考：<https://www.jetbrains.com/help/idea/class-diagram.html>

未完待续…

#### 二、市场插件

- 阿里代码规约检测
- 快捷键提示工具：Key promoter X
- 代码注解插件： Lombok
- 代码生成工具：CodeMaker
- 单元测试测试生成工具：JUnitGenerator
- Mybatis 工具：Free Mybatis plugin
- Maven辅助神器：Maven Helper
- JSON转领域对象工具：GsonFormat
- 领域对象转JSON工具：POJO to JSON
- 时序图生成工具：SequenceDiagram
- 字符串工具：String Manipulation
- 代码作色工具：Rainbow Brackets
- RESTful 服务开发辅助工具集: RestfulToolkit
- 日志工具：Grep Console
- 生成对象set方法：GenerateAllSetter
- Redis可视化：Iedis
- K8s工具：Kubernetes
- 中英文翻译工具：Translation

##### 1. 阿里代码规约检测

《阿里巴巴 Java 开发手册》是阿里巴巴集团技术团队的集体智慧结晶和经验总结， 经历了多次大规模一线实战的检验及不断完善， 系统化地整理成册。当然，规范只能提供参考，我们还需要工具来帮忙我们实现了实时检测。目前，Alibaba Java Code Guidelines 插件实现了开发手册中的的 53 条规则，大部分基于 PMD 实现，其中有 4 条规则基于 IDEA 实现，并且基于 IDEA Inspection 实现了实时检测功能。部分规则实现了 Quick Fix 功能。目前，插件检测有两种模式：实时检测、手动触发。详细使用文档，参考：<https://github.com/alibaba/p3c/blob/master/idea-plugin/README_cn.md>

- 阿里巴巴 Java 开发手册（详尽版）： <https://github.com/alibaba/p3c/blob/master/> 阿里巴巴 Java 开发手册（详尽版）.pdf
- GitHub : <https://github.com/alibaba/p3c>
- IDEA 插件地址：<https://plugins.jetbrains.com/plugin/10046-alibaba-java-coding-guidelines>

此外，类似的插件还有 FindBugs 和 CheckStyle。

##### 2. 快捷键提示工具：Key promoter X

Key Promoter X 是一个快捷键提示插件，如果鼠标操作是能够用快捷键替代，Key Promoter X 会提示可以用什么快捷键替代。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/9792-key-promoter-x>

##### 3. 代码注解插件： Lombok

lombok 的使用，参考 ：<https://projectlombok.org/>。我们需要在代码中引入二方库，然后安装 lombok 插件即可。

``` xml
<dependency>
    <groupId>org.projectlombok</groupId>  
    <artifactId>lombok</artifactId>
    <version>最新版本号</version>
</dependency>
```

##### 4. 代码生成工具：CodeMaker

开发过程中，经常手工编写重复代码。现在，可以通过 CodeMaker 来定义 Velocity 模版来支持自定义代码模板来生成代码。目前，CodeMaker 自带两个模板。Model：根据当前类生成一个与其拥有类似属性的类，用于自动生成持久类对应的领域类。Converter：该模板需要两个类作为输入的上下文，用于自动生成领域类与持久类的转化类。详细使用文档，参考：<https://github.com/x-hansong/CodeMaker>

##### 5. 单元测试测试生成工具：JUnitGenerator

单元测试是必不可少的！我们可以使用 JUnitGenerator 插件来自动创建了单元测试。我们可以使用提供的 velocity 模板定制单元测试输出代码。如果在已经存在单元测试的地方创建了单元测试，则会提示用户进行覆盖或合并操作。合并操作允许用户有选择地创建目标文件内容。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/3064-junitgenerator-v2-0>

##### 6. Mybatis 工具：Free Mybatis plugin

现在，MyBatis 框架已占领半壁江山。因此，围绕着 MyBatis 的插件和工具越来越多。Free Mybatis plugin 非常方便进行 Mapper 接口和 XML 文件之间跳转。详细使用文档，参考：
<https://plugins.jetbrains.com/plugin/8321-free-mybatis-plugin>。此外，收费版的还有 Mybatis plugin。

对于 Mybatis 的工具还有很多，比如 mybatis-log-plugin、codehelper.generator。此外，非 IDEA的工具有： Mybatis 分页插件 Mybatis-PageHelper、Mybatis 代码生成工具 mybatis-generator 等。地址：<http://www.mybatis.org/generator/>

##### 7. Maven辅助神器：Maven Helper

如果 Maven 引入的 jar 包有冲突，可以使用 Maven Helper 插件来帮助分析。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/7179-maven-helper>

##### 8. JSON转领域对象工具：GsonFormat

在开发过程中，我们可能会遇到 json 格式的字符串转换成实体类参数的场景，这个插件可以根据 JSONObject 格式的字符串，自动生成实体类参数。详细使用文档，参考：<https://github.com/zzz40500/GsonFormat>
那么，如何使用呢？我们可以使用 GsonFommat 的快捷键，默认 option + s (mac), alt + s (win) 通过以下方式修改快捷键。或者点击工具栏的 Generate 来唤起生成工具。

##### 9. 领域对象转JSON工具：POJO to JSON

为了测试需要，我们需要将简单 Java 领域对象转成 JSON 字符串方便用 postman 或者 curl 模拟数据。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/9686-pojo-to-json>

##### 10. 时序图生成工具：SequenceDiagram

有的时候，我们需要梳理业务逻辑或者阅读源码。从中，我们需要了解整个调用链路，反向生成 UML 的时序图是强需求。其中，SequenceDiagram 插件是一个非常棒的插件。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/8286-sequencediagram>

##### 11. 字符串工具：String Manipulation

String Manipulation 插件提供了非常丰富字符串工具，例如命名替换（ (camelCase, kebab-lowercase, KEBAB-UPPERCASE, snakecase, SCREAMINGSNAKE_CASE, dot.case, words lowercase, Words Capitalized, PascalCase）等。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/2162-string-manipulation>

##### 12. 代码作色工具：Rainbow Brackets

Rainbow Brackets 插件可以实现配对括号相同颜色，并且实现选中区域代码高亮的功能。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/10080-rainbow-brackets>

事实上，代码作色之后，可以非常方便我们阅读。类似的工具还有：Grep Console 来自定义设置控制台输出颜色等。

##### 13. RESTful 服务开发辅助工具集: RestfulToolkit

开发中，经过会根据 URI 的部分信息来查找对应的 Controller 中方法，RestfulToolkit 提供了一套 RESTful 服务开发辅助工具集，提供了如下功能：

根据 URL 直接跳转到对应的方法定义 ( Ctrl \ or Ctrl Alt N ); 提供了一个 Services tree 的显示窗口; 一个简单的 http 请求工具; 在请求方法上添加了有用功能: 复制生成 URL;,复制方法参数... 其他功能: java 类上添加 Convert to JSON 功能，格式化 json 数据 ( Windows: Ctrl + Enter; Mac: Command + Enter )。

详细使用文档，参考：<https://plugins.jetbrains.com/plugin/10292-restfultoolkit>

##### 14. 日志工具：Grep Console

参考：<https://plugins.jetbrains.com/plugin/7125-grep-console>

不同级别日志通过颜色区分，一路了然

##### 15. 生成对象set方法：GenerateAllSetter

开发中，有时可以通过BeanUtil等工具类进行对象之间的属性拷贝，但有时候也需要手工进行赋值。通过GenerateAllSetter，可以一键生成对象的所有 set 语句。

##### 16. Redis可视化：Iedis

参考：<https://plugins.jetbrains.com/plugin/9228-iedis> 使用参考：<https://codesmagic.com/iedis/userguide/getting-started> 可方便的执行增删查改及使用命令行进行操作。

##### 17. K8s工具：Kubernetes

参考：<https://plugins.jetbrains.com/plugin/10485-kubernetes》 支持编辑 Kubernetes 资源文件，如下： 可以比较方便的查看 yaml 中的各项 placeholder 的默认值，且可以方便的链接到 value 位置。

##### 18. 中英文翻译工具：Translation

最骚的操作是什么？帆哥在群里分享了一套「半中文编程」：说到了变量命名，先用中文写好，然后用 Translation 插件的 translate and replace 一键替换为英文，这样效率高而且准确。详细使用文档，参考：<https://plugins.jetbrains.com/plugin/8579-translation>

> *From：[IntelliJ IDEA 常用插件一览，让效率成为习惯](https://mp.weixin.qq.com/s/zyIKY0Bc7DXic7kQN-zuRA)* 






## :yum: Intellij PyCharm

- Statistic - 统计各类文件，对象个数，文件大小，行数等等属性信息。安装和使用参考：[IDEA 代码统计插件 --- Statistic](https://blog.csdn.net/u014430366/article/details/77574222)





---



- [dawnlabs/carbon](https://github.com/dawnlabs/carbon/blob/master/docs/README.cn.zh.md)

  > Carbon 是一个免费的开源库，用于创建和分享源代码的美丽图像。
  >
  > 如何使用：[使用Carbon和Polacode从你的编辑器创建代码截图](https://segmentfault.com/a/1190000014579171)
  >
  > 使用说明：[中文简体版](https://github.com/dawnlabs/carbon/blob/master/docs/README.cn.zh.md)
  >
  > - 在线使用：https://carbon.now.sh/
  > - VS Code 中安装插件使用：[Polacode](https://marketplace.visualstudio.com/items?itemName=pnp.polacode)
  > - IntelliJ IDEA 中安装插件使用： [carbon-now-sh](https://plugins.jetbrains.com/plugin/10469-carbon-now-sh)

- [nvbn/thefuck](https://github.com/nvbn/thefuck)

  > The Fuck 是一款用于检查上一条出错的指令中的错误，并提供修正选项的软件。它不仅适合新手学习和了解自己的错误，同样也适合一个稳固在一个 Linux 发行版上突然要使用另一个发型版不适应的老鸟。The Fuck 不仅支持 Linux 发行版，还支持 macOS 和 FreeBSD。安装参考：https://www.mf8.biz/thefuck/
  >
  > 了解下：[又是一个名叫草泥马的项目：thefuck](https://segmentfault.com/a/1190000002740344)