# SvelteKit vs NextJS

Comparison of major features in SvelteKit vs NextJS.

Goals: fast, easy, convention over configuration, & batteries included.
Overwhelming choices are bad versus providing a clear path forward.

|                                                                                             | SvelteKit                                                                                                                                                                                                                                                                                                                                 | NextJS                                                                                                                                                                                                                                                                                                               | Winner                              | Notes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| ------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| UI lib                                                                                      | [Svelte](https://svelte.dev/)                                                                                                                                                                                                                                                                                                             | [React](https://reactjs.org/)<br>(or [MillionJS](https://million.dev/) or [Preact](https://preactjs.com))                                                                                                                                                                                                            | SvelteKit                           | Svelte offers faster DOM updates, smaller KB client size, _much_ easier cross-component state management, ability to abstract responsive state into external files, etc. Svelte5 has Runes (signals) 🎉, React does not have an equivalent yet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Dev: Hot reload                                                                             | [🟢](https://kit.svelte.dev/docs/faq#how-do-i-use-hmr-with-sveltekit)                                                                                                                                                                                                                                                                                                      | [🟢](https://nextjs.org/docs/architecture/fast-refresh)                                                                                                                                                                                                                                                          | --                                  | I.e. Auto reload on file save.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| Dev: O(1) hot reload                                                                        | [🟢 Vite](https://vitejs.dev/)                                                                                                                                                                                                                                                                                                            | [🟢 🚧 Turbopack (\*not enabled by default)](https://nextjs.org/docs/architecture/turbopack)                                                                                                                                                                                                                         | SvelteKit                           | I.e. Processes only the changed files. Fast even in big projects. \*Update `package.json` to enable Turbopack: `"dev": "next dev --turbo"`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| Dev: "Fast refresh"                                                                         | [🟢 🚧 (not enabled by default)](https://kit.svelte.dev/docs/faq#how-do-i-use-hmr-with-sveltekit)                                                                                                                                                                                                                                                                          | [🟢](https://nextjs.org/docs/basic-features/fast-refresh)                                                                                                                                                                                                                                                            | NextJS                              | I.e. UI state preserved across reloads.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Dev: Write modern JS                                                                        | [🟢](https://svelte.dev/docs#compile-time)                                                                                                                                                                                                                                                                                                | [🟢](https://nextjs.org/docs/advanced-features/compiler)                                                                                                                                                                                                                                                             | --                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Dev: A11y console hints                                                                     | [🟢](https://svelte.dev/docs#accessibility-warnings)                                                                                                                                                                                                                                                                                      | ❌                                                                                                                                                                                                                                                                                                                   | SvelteKit                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Dev: Prettier                                                                               | [🟢](https://marketplace.visualstudio.com/items?itemName=svelte.svelte-vscode)                                                                                                                                                                                                                                                            | [🟢](https://nextjs.org/docs/basic-features/eslint#prettier)                                                                                                                                                                                                                                                         | --                                  | For `.svelte` or `.jsx` files, respectively. For SvelteKit, install [`Svelte for VSCode`](https://marketplace.visualstudio.com/items?itemName=svelte.svelte-vscode) extension.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| Prod: Bundler                                                                               | [🟢](https://svelte.dev/docs#compile-time)                                                                                                                                                                                                                                                                                                | [🟢](https://nextjs.org/docs/advanced-features/compiler)                                                                                                                                                                                                                                                             | --                                  | E.g. Minify assets, etc. Both are enabled by default. When [RollDown](https://rolldown.rs/) (Rust) is ready in 2024, Svelte will be able to switch from Rollup+ESbuild to RollDown for even faster production builds.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| Prod: Auto code splitting, per route                                                        | [🟢](https://kit.svelte.dev/docs/performance)                                                                                                                                                                                                                                                                            | [🟢](https://nextjs.org/docs/app/building-your-application/routing/linking-and-navigating#1-code-splitting)                                                                                                                                                                                                                                             | --                                  | I.e. Auto code split JS & CSS per route & bundle appropriately.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Prod: Build adapters for different hosts                                                    | [🟢](https://kit.svelte.dev/docs/adapters)                                                                                                                                                                                                                                                                                                | ❌                                                                                                                                                                                                                                                                                                                   | SvelteKit                           | SvelteKit provides easy portability to many hosts. NextJS works best with Vercel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| KB size: Hello World                                                                        | 🟢 46.3 (25.6 gzip) with CSR\*<br>🟢 2.9 (3.3 gzip) without CSR (1.8kb of this is the favicon; shows as bigger with gzip in Chrome)                                                                                                                                                                                                       | ❌ 336.3 (131.3 gzip) (includes a 9.7kb favicon 👀)\*                                                                                                                                                                                                                                                                | SvelteKit                           | - \*CSR is "client side router".<br>- SvelteKit updated Aug 25, 2023 using SvelteKit 1.23 & Svelte 4.<br>- NextJS updated Aug 25, 2023 using App Router, NextJS 13.4.19, & React 18.2.0.<br>- Both tests return HTML of `<p>hello world</p>` and exclude CSS.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| KB size: "Real World" app                                                                   | too out of date                                                                                                                                                                                                                                                                                                                           | too out of date                                                                                                                                                                                                                                                                                                      | --                                  | Out of date; PR welcome. \*Mar 13, 2021 <https://realworld.svelte.dev/>, <https://svelte.dev/blog/sapper-towards-the-ideal-web-app-framework>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| Rendering: SSR, per route                                                                   | [🟢](https://kit.svelte.dev/docs/page-options#ssr)                                                                                                                                                                                                                                                                                  | [🟢](https://nextjs.org/docs/app/building-your-application/optimizing/lazy-loading#skipping-ssr)                                                                                                                                                                                                                                                   | --                                  | I.e. Server-side rendered at run time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Rendering: Streaming                                                                        | [🟢](https://kit.svelte.dev/docs/load#streaming-with-promises)                                                                                                                                                                                                                                                                                         | [🟢](https://nextjs.org/docs/app/building-your-application/routing/loading-ui-and-streaming#streaming-with-suspense)                                                                                                                                                                                                 | --                                  | I.e. Server sends HTTP stream as it rendered on the server, rather than waiting for full rendering to complete before sending the response.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| Rendering: Static, per route                                                                | [🟢](https://kit.svelte.dev/docs/page-options#prerender)                                                                                                                                                                                                                                                                                  | [🟢](https://nextjs.org/docs/advanced-features/automatic-static-optimization)                                                                                                                                                                                                                                        | --                                  | I.e. Static HTML generated at build time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| Rendering: Incremental Static Regeneration, per route                                       | [🟢](https://kit.svelte.dev/docs/adapter-vercel#incremental-static-regeneration) on non-edge Vercel                                                                                                                                                                                                                                       | [🟢](https://nextjs.org/docs/pages/building-your-application/data-fetching/incremental-static-regeneration) on non-edge Vercel                                                                                                                                                                                       | --                                  | Static 'on demand' in production–i.e. first request dynamic, then cached as static. For other runtimes (like Edge on Vercel & Cloudflare), consider setting your route's `cache-control` header to use `stale-while-revalidate` for some similar benefits.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| Rendering: "Partial Prerendering"                                                           | ❌                                                                                                                                                                                                                                                                                                                                        | [🟢🚧](https://nextjs.org/learn/dashboard-app/partial-prerendering)\*                                                                                                                                                                                                                                                  | NextJS                              | \*"experimental", in NextJS v14 or newer.<br>Allows static prerendring of a page + streaming dynamic areas, like user auth buttons in a header, shopping cart status, etc.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Headers: s-max-age & max-age, per route                                                     | [🟢](https://kit.svelte.dev/docs/load#cookies-and-headers)                                                                                                                                                                                                                                                                                | [🟢](https://nextjs.org/docs/going-to-production#caching)                                                                                                                                                                                                                                                            | --                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Routes: File-based routing                                                                  | [🟢](https://kit.svelte.dev/docs/routing)                                                                                                                                                                                                                                                                                                 | [🟢](https://nextjs.org/docs/basic-features/pages)                                                                                                                                                                                                                                                                   | --                                  | For simplicity. Other routing utilities should be included.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| Routes: "SPA mode"                                                                          | 🟢                                                                                                                                                                                                                                                                                                                                        | 🟢                                                                                                                                                                                                                                                                                                                   | --                                  | SSR for initial page load, then client-side routing for subsequent pages.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| Routes: Pre-fetch JS/CSS on link hover                                                      | [🟢](https://kit.svelte.dev/docs/link-options)                                                                                                                                                                                                                                                                                            | [🟢 next/link](https://nextjs.org/docs/api-reference/next/link)                                                                                                                                                                                                                                                      | SvelteKit                           | By default in SvelteKit, can be overridden or removed. Svelte also offers a [`preloadCode()`](https://kit.svelte.dev/docs/modules#$app-navigation-preloadcode) and [`prefetchData()`](https://kit.svelte.dev/docs/modules#$app-navigation-preloaddata) to preload all or some routes specified via regex--powerful! NextJS requires using their link component; see docs.                                                                                                                                                                                                                                                                                                                                                                        |
| Built-in: Metadata                                                                          | [🟢](https://svelte.dev/docs#template-syntax-svelte-head)                                                                                                                                                                                                                                                                                 | [🟢 next/head](https://nextjs.org/docs/api-reference/next/head)                                                                                                                                                                                                                                                      | --                                  | Place within `<svelte:head>...</svelte:head>`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| Built-in: State management                                                                  | [🟢 svelte/store](https://svelte.dev/docs#run-time-svelte-store)                                                                                                                                                                                                                                                                          | [🟢 useState](https://react.dev/reference/react/useState)                                                                                                                                                                                                                                                                                                                   | SvelteKit                           | Ideal is one, easy, built-in way. <br><br>React has `useState`, [Zustand](https://github.com/pmndrs/zustand), & others. <br><br>Svelte4 uses reactive vars and stores. Svelte5 brings Runes (signals) for an even better DX, better state updating performance than React (due to being signal based), and the ability to use reactivity inside template files (e.g. `.svelte`) _and_ supporting files (e.g. `.svelte.ts`), enabling new ways to refactor and abstract your code. Svelte continues to win on state management.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| Built-in: Animations                                                                        | [🟢 svelte/animate](https://svelte.dev/docs#run-time-svelte-animate)                                                                                                                                                                                                                                                                      | ❌                                                                                                                                                                                                                                                                                                                   | SvelteKit                           | 3rd-party options exist for React, but they're not as easy to use. [FramerMotion](https://www.framer.com/motion/) is popular for React. [Motion One](https://motion.dev/) is a also great library (small & fast) and works with any UI framework.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Built-in: Image optimizations                                                               | 🟢 [enhanced:img](https://kit.svelte.dev/docs/images#sveltejs-enhanced-img) (beta)                                                                                                                                                                                                                                                        | 🟢 [next/image](https://nextjs.org/docs/api-reference/next/image)                                                                                                                                                                                                                                                    | --                                  | Build-time image optimizations (conversion to AVIF or WEBP), creation of picture element with fallback to JPEG or PNG, resizing, adding width & height automatically, add file name hash for caching, etc. Hosted services exist as well if you prefer to do this at runtime (Cloudflare Images, Cloudinary, Gumlet, etc)                                                                                                                                                                                                                                                                                                                                                                                                                        |
| Built-in: Forms                                                                             | [🟢 Form actions & `use:enhance`](https://kit.svelte.dev/docs/form-actions) (works with or without JS) <br>or<br> [Formsnap](https://formsnap.dev/docs) (built on superforms) <br>or<br> [Superforms](https://github.com/ciscoheat/sveltekit-superforms)                                                                                                                                                   | [🟢 NextJS 13 Form and Server actions ](https://nextjs.org/docs/app/building-your-application/data-fetching/server-actions-and-mutations#forms) (works with or without JS, if built properly)                                                                                                                                            | --                                  | Svelte has built-in form support with a progressive enhancement that works even without JS; they're very clean because validation rules are defined once and used for both client & server side.<br><br>[Formik](https://formik.org) (for React) is clean but requires JS and duplication of validation rules on the server side; similar to [Felte](https://felte.dev) (for React, SvelteKit, & Vue).                                                                                                                                                                                                                                                                                                                                           |
| Auth                                                                                        | [🟢 Auth.js](https://authjs.dev) or [Lucia](https://github.com/lucia-auth/lucia)                                                                                                                                                                                                                                                          | [🟢 Auth.js](https://authjs.dev) or [Lucia](https://github.com/lucia-auth/lucia)                                                                                                                                                                                                                                     | --                                  | Auth.js (formely NextAuth.js) is defacto standard for NextJS; easy to use; email, social, &/or one-click link. It supports SvelteKit too. [Original announcement](https://vercel.com/blog/announcing-sveltekit-auth). However, Lucia is very popular in the SvelteKit community.<br><br>- [thecopenhagenbook.com](https://thecopenhagenbook.com/) (free by the author of Lucia) may be helpful to learn how to set up Auth, for either framework.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| OG Image Generation                                                                         | [🟢❌ @ethercorps/sveltekit-og](https://github.com/etherCorps/sveltekit-og)\*                                                                                                                                                                                                                                                             | [🟢 @vercel/og](https://vercel.com/docs/concepts/functions/edge-functions/og-image-generation)                                                                                                                                                                                                                       | NextJS                              | `@ethercorps/sveltekit-og` is based on [Satori](https://github.com/vercel/satori), which `@vercel/og` is also based on. <br>\*❌ on `@ethercorps/sveltekit-og`'s because not working on certain hosts like Cloudflare Pages. Credit to Vercel for creating Satori. Both include TailwindCSS support.  **Opportunity for someone to contribute an OG lib for SvelteKit!**                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Sitemap                                                                                     | [🟢 Super Sitemap](https://github.com/jasongitmail/super-sitemap)                                                                                                                                                                                                                                                                         | [🟢 next-sitemap](https://github.com/iamvishnusankar/next-sitemap)                                                                                                                                                                                                                                                   | --                                  | Super Sitemap wins on ease of use and being up to date expected conventions for sitemap, but both get the job done.<br><br>Disclosure: I'm the author of [Super Sitemap](https://github.com/jasongitmail/super-sitemap). [Github issue for official sitemap.xml support in SvelteKit](https://github.com/sveltejs/kit/issues/1142).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| Data fetching                                                                               | [🟢 TanStack Query](https://github.com/TanStack/query)<br>[🟢 SSWR](https://github.com/ConsoleTVs/sswr)<br>[🟢 tRPC](https://github.com/icflorescu/trpc-sveltekit)                                                                                                                                                                                                   | [🟢 TanStack Query](https://github.com/TanStack/query)<br>[🟢 SWR](https://swr.vercel.app)<br>[🟢 tRPC](https://trpc.io/)                                                                                                                                                                                            | --                                  | Easy fetch/isLoading/errors/caching. <br><br>SvelteKit provides [automatic type safety](https://kit.svelte.dev/docs/load#page-data) (see note below the code sample) for data returned from load functions thanks to its autogenerated `$types` module, with no work on the dev's part.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [Tailwind CSS](https://tailwindcss.com/) compatible                                         | [🟢](https://tailwindcss.com/docs/guides/sveltekit) (or [via svelte-add](https://svelte-add.com/adder/tailwindcss))                                                                                                                                                                                                                      | [🟢](https://nextjs.org/docs/app/building-your-application/styling/tailwind-css)                                                                                                                                                                                                                                                                     | NextJS b/c built in. Both are easy. | For NextJS, just check `Yes` for the TailwindCSS option when creating your NextJS app using [create-next-app](https://nextjs.org/docs/app/api-reference/create-next-app).<br><br>[Tailwind v4](https://tailwindcss.com/blog/tailwindcss-v4-alpha#try-out-the-alpha) will make set up even easier.                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| UI Component Libs - _Styled_                                                                | - [🟢 Shadcn Svelte](https://www.shadcn-svelte.com/) (unofficial)\*<br/>- [🟢 Flowbite Svelte](https://flowbite-svelte.com/)<br/>- [🟢 Skeleton UI](https://www.skeleton.dev/)<br/>- [🟢 Carbon Components Svelte](https://carbon-components-svelte.onrender.com/components/Checkbox)                                                     | - [🟢 Shadcn UI](https://ui.shadcn.com/)\*\*<br>- [🟢 Tailwind UI](https://tailwindui.com)<br>- [🟢 MUI](https://mui.com)<br>- [🟢 Ant Design](https://ant.design)<br>- [🟢 Mantine UI](https://ui.mantine.dev)<br>- [🟢 Chakra UI](https://chakra-ui.com)<br>- [🟢 Flowbite React](https://www.flowbite-react.com/) | NextJS                              | - \*Built on BitsUI (similar to RadixUI), which itself is built on MeltUI<br>- \*\*Built on RadixUI.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| UI Component Libs - _Unstyled_                                                              | - [🟢 Bits UI](https://www.bits-ui.com/)\*<br>- [🟢 Melt UI](https://www.melt-ui.com/)\*\*<br>- [🟢🚧 svelte-headlessui](https://github.com/rgossiaux/svelte-headlessui) (unofficial; issues for official support: [1](https://github.com/tailwindlabs/headlessui/issues/162), [2](https://github.com/tailwindlabs/headlessui/issues/32)) | - [🟢 Radix UI](https://www.radix-ui.com/)<br>- [🟢 Headless UI](https://headlessui.dev/)<br>- [🟢 React Aria](https://react-spectrum.adobe.com/react-aria/getting-started.html)                                                                                                                                     | NextJS                              | Un-styled UI components (dropdown, slider, toggle, etc). <br>-\*Built on MeltUI, to provide a more familiar component interface.<br>- \*\*Melt UI is the successor to [radix-svelte](https://github.com/radix-svelte/radix-svelte).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| Docs                                                                                        | [10/10](https://kit.svelte.dev/)                                                                                                                                                                                                                                                                                                          | [10/10](https://nextjs.org/docs)                                                                                                                                                                                                                                                                                     | --                                  |
| Component Directory                                                                         | [sveltesociety.dev/components](https://sveltesociety.dev/components/) ([add yours](https://sveltesociety.dev/help/submitting))                                                                                                                                                                                                            | --                                                                                                                                                                                                                                                                                                                   |                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Dev Retention (proxy for enjoyment; Svelte vs React)                                                                         | 90%                                                                                                                                                                                                           | 83%                                                                                                                                                                                                                                                                                                                   | Svelte                                     | *Source: [State of JS 2022 Front-end frameworks 'Retention'](https://2022.stateofjs.com/en-US/libraries/front-end-frameworks/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| Philosophy                                                                         | [Tenets](https://github.com/sveltejs/svelte/discussions/10085)                                                                                                                                                                                                         | ?                                                                                                                                                                                                                                                                                                                   | n/a                                  | "People use Svelte because they like Svelte. They like it because it aligns with their aesthetic sensibilities. Instead of striving to be the fastest or smallest or whateverest, we explicitly aim to be the framework with the best vibes. ... We're not trying to be the most popular framework, we're trying to be the best framework." 🤘                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |

## Low priority

The following are low-priority framework features because they can be enabled easily via hosting providers or other common tools (e.g. analytics), or other best practices have emerged like using utility-based style frameworks.

|                                                                                           | Svelte Kit | NextJS                             | Winner  | Notes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| ----------------------------------------------------------------------------------------- | ---------- | ---------------------------------- | ------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Built-in: CSS scoping                                                                       | [🟢](https://svelte.dev/docs#component-format-style)                                                                                                                                                                                                                                                                                      | [🟢](https://nextjs.org/docs/basic-features/built-in-css-support#adding-component-level-css)                                                                                                                                                                                                                         | SvelteKit                           | Svelte's is automatic. NextJS' is via CSS modules or CSS in JSX (not as clean).<br><br>Irrelevant if you use TailwindCSS. Move to "low priority" b/c it's now standard to use a utility-based style framework like TailwindCSS or UnoCSS for composability & sharing of components.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Prod: [HTTP Early Hints response](https://blog.cloudflare.com/early-hints/) of JS/CSS\*\* | ❌         | ❌                                 | Neither | \*\*_Not super relevant as a framework feature anymore because easily enabled via some hosting platform providers._ Replaces HTTP2 Server Push. Send two responses: 1.) a 103 response status with headers listing resources to preload & preconnect; 2.) a standard 200 response status or similar. ([Cloudflare can do this for sites automatically](https://developers.cloudflare.com/cache/about/early-hints).)                                                                        |
| Web vitals reporting\*\*                                                                  | ❌         | [🟢](https://nextjs.org/analytics) | NextJS  | \*\*_Not super relevant as a framework feature anymore because easily added via analytics snippet now or via some hosting platform providers._ [Cloudlfare Site Analytics](https://developers.cloudflare.com/analytics/web-analytics/understanding-web-analytics/core-web-vitals) offers Core Web Vitals tracking with zero configuration; it's part of their JS snippet. [Vercel](https://vercel.com/docs/analytics) also offers it if using NextJS or NuxtJS & has a _superb_ dashboard. |
| CSS-only component libs (i.e. no JS)<br><br>\**categorically not recommended** | - [🟢 DaisyUI](https://daisyui.com)<br>-[🟢❌ Headless UI\*](https://tailwindui.com)                                                                                                                                                                                                                                                      | [🟢 DaisyUI](https://daisyui.com)                                                                                                                                                                                                                                                                                    | --                                  | \*Categorically _not_ recommended b/c some components _will_ require JavaScript and adding your own JS and achieving accessibility is hard; the better approach is to start with an accessible, JS-enabled UI component lib for your framework that comes with nice default styles and allows styling to your preference (e.g. Shadcn).<br/>- DaisyUI offers themes that can be one-off customized with TailwindCSS classes or altered using Tailwind's `@apply` directive. CSS-only components require the dev to add accessible interactions with JS–a lot of work.<br>- \*\*Headless UI is a paid product with official React and Vue support; can use as HTML & CSS with SvelteKit, but no JS.<br>- Update: won't maintain this row anymore. |


Due to the wide ecosystem of Next JS, a framework built on top of Next JS [Blitz JS](https://blitzjs.com/) is also an honorable mention. It comes with features that Next JS doesn't support natively like auth mechanism and more. Suitable for medium or large-size projects. And also, you can utilize your Next JS knowledge while using Blitz JS.
