﻿CREATE TABLE IF NOT EXISTS "__EFMigrationsHistory" (
    "MigrationId" character varying(150) NOT NULL,
    "ProductVersion" character varying(32) NOT NULL,
    CONSTRAINT "PK___EFMigrationsHistory" PRIMARY KEY ("MigrationId")
);

START TRANSACTION;


DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    CREATE TABLE "Questions" (
        "Id" uuid NOT NULL,
        "Text" text NOT NULL,
        "ConnectionId" text,
        "Context" text,
        "Embeddings" real[],
        "CreatedBy" text,
        "Created" timestamp with time zone NOT NULL,
        "ModifiedBy" text,
        "Modified" timestamp with time zone,
        CONSTRAINT "PK_Questions" PRIMARY KEY ("Id")
    );
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    CREATE TABLE "Resources" (
        "Id" uuid NOT NULL,
        "Content" text NOT NULL,
        "Title" text NOT NULL,
        "Type" text NOT NULL,
        "Embeddings" real[] NOT NULL,
        "CreatedBy" text,
        "Created" timestamp with time zone NOT NULL,
        "ModifiedBy" text,
        "Modified" timestamp with time zone,
        CONSTRAINT "PK_Resources" PRIMARY KEY ("Id")
    );
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    CREATE TABLE "Answers" (
        "Id" integer GENERATED BY DEFAULT AS IDENTITY,
        "Text" text NOT NULL,
        "Prompt" text NOT NULL,
        "Client" text NOT NULL,
        "Model" text NOT NULL,
        "PromptTokens" integer NOT NULL,
        "CompletionTokens" integer NOT NULL,
        "QuestionId" uuid NOT NULL,
        "CreatedBy" text,
        "Created" timestamp with time zone NOT NULL,
        "ModifiedBy" text,
        "Modified" timestamp with time zone,
        CONSTRAINT "PK_Answers" PRIMARY KEY ("Id"),
        CONSTRAINT "FK_Answers_Questions_QuestionId" FOREIGN KEY ("QuestionId") REFERENCES "Questions" ("Id") ON DELETE CASCADE
    );
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    CREATE TABLE "QuestionResources" (
        "Id" integer GENERATED BY DEFAULT AS IDENTITY,
        "QuestionId" uuid NOT NULL,
        "ResourceId" uuid NOT NULL,
        "CreatedBy" text,
        "Created" timestamp with time zone NOT NULL,
        "ModifiedBy" text,
        "Modified" timestamp with time zone,
        CONSTRAINT "PK_QuestionResources" PRIMARY KEY ("Id"),
        CONSTRAINT "FK_QuestionResources_Questions_QuestionId" FOREIGN KEY ("QuestionId") REFERENCES "Questions" ("Id") ON DELETE CASCADE,
        CONSTRAINT "FK_QuestionResources_Resources_ResourceId" FOREIGN KEY ("ResourceId") REFERENCES "Resources" ("Id") ON DELETE CASCADE
    );
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    CREATE UNIQUE INDEX "IX_Answers_QuestionId" ON "Answers" ("QuestionId");
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    CREATE INDEX "IX_QuestionResources_QuestionId" ON "QuestionResources" ("QuestionId");
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    CREATE INDEX "IX_QuestionResources_ResourceId" ON "QuestionResources" ("ResourceId");
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240512090001_Init') THEN
    INSERT INTO "__EFMigrationsHistory" ("MigrationId", "ProductVersion")
    VALUES ('20240512090001_Init', '8.0.4');
    END IF;
END $EF$;
COMMIT;

START TRANSACTION;


DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240520074639_AddedQuestionFilesTable') THEN
    CREATE TABLE "QuestionFiles" (
        "Id" integer GENERATED BY DEFAULT AS IDENTITY,
        "Text" text NOT NULL,
        "QuestionId" uuid NOT NULL,
        "CreatedBy" text,
        "Created" timestamp with time zone NOT NULL,
        "ModifiedBy" text,
        "Modified" timestamp with time zone,
        CONSTRAINT "PK_QuestionFiles" PRIMARY KEY ("Id"),
        CONSTRAINT "FK_QuestionFiles_Questions_QuestionId" FOREIGN KEY ("QuestionId") REFERENCES "Questions" ("Id") ON DELETE CASCADE
    );
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240520074639_AddedQuestionFilesTable') THEN
    CREATE INDEX "IX_QuestionFiles_QuestionId" ON "QuestionFiles" ("QuestionId");
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240520074639_AddedQuestionFilesTable') THEN
    INSERT INTO "__EFMigrationsHistory" ("MigrationId", "ProductVersion")
    VALUES ('20240520074639_AddedQuestionFilesTable', '8.0.4');
    END IF;
END $EF$;
COMMIT;

START TRANSACTION;


DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240606143308_AddedCodeAndNoteQuestionTables') THEN
    ALTER TABLE "Questions" DROP COLUMN "Embeddings";
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240606143308_AddedCodeAndNoteQuestionTables') THEN
    CREATE TABLE "QuestionCodes" (
        "Id" uuid NOT NULL,
        "Embeddings" real[],
        "QuestionId" uuid NOT NULL,
        "CreatedBy" text,
        "Created" timestamp with time zone NOT NULL,
        "ModifiedBy" text,
        "Modified" timestamp with time zone,
        CONSTRAINT "PK_QuestionCodes" PRIMARY KEY ("Id"),
        CONSTRAINT "FK_QuestionCodes_Questions_QuestionId" FOREIGN KEY ("QuestionId") REFERENCES "Questions" ("Id") ON DELETE CASCADE
    );
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240606143308_AddedCodeAndNoteQuestionTables') THEN
    CREATE TABLE "QuestionNotes" (
        "Id" uuid NOT NULL,
        "Embeddings" real[],
        "QuestionId" uuid NOT NULL,
        "CreatedBy" text,
        "Created" timestamp with time zone NOT NULL,
        "ModifiedBy" text,
        "Modified" timestamp with time zone,
        CONSTRAINT "PK_QuestionNotes" PRIMARY KEY ("Id"),
        CONSTRAINT "FK_QuestionNotes_Questions_QuestionId" FOREIGN KEY ("QuestionId") REFERENCES "Questions" ("Id") ON DELETE CASCADE
    );
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240606143308_AddedCodeAndNoteQuestionTables') THEN
    CREATE UNIQUE INDEX "IX_QuestionCodes_QuestionId" ON "QuestionCodes" ("QuestionId");
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240606143308_AddedCodeAndNoteQuestionTables') THEN
    CREATE UNIQUE INDEX "IX_QuestionNotes_QuestionId" ON "QuestionNotes" ("QuestionId");
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240606143308_AddedCodeAndNoteQuestionTables') THEN
    INSERT INTO "__EFMigrationsHistory" ("MigrationId", "ProductVersion")
    VALUES ('20240606143308_AddedCodeAndNoteQuestionTables', '8.0.4');
    END IF;
END $EF$;
COMMIT;

START TRANSACTION;


DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240607124012_AddedStateColumnToQuestionTable') THEN
    ALTER TABLE "Questions" ADD "State" text NOT NULL DEFAULT '';
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240607124012_AddedStateColumnToQuestionTable') THEN
    INSERT INTO "__EFMigrationsHistory" ("MigrationId", "ProductVersion")
    VALUES ('20240607124012_AddedStateColumnToQuestionTable', '8.0.4');
    END IF;
END $EF$;
COMMIT;

START TRANSACTION;


DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240608112850_AddStateColumnToCodeAndNoteQuestionTable') THEN
    ALTER TABLE "QuestionNotes" ADD "State" text NOT NULL DEFAULT '';
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240608112850_AddStateColumnToCodeAndNoteQuestionTable') THEN
    ALTER TABLE "QuestionCodes" ADD "State" text NOT NULL DEFAULT '';
    END IF;
END $EF$;

DO $EF$
BEGIN
    IF NOT EXISTS(SELECT 1 FROM "__EFMigrationsHistory" WHERE "MigrationId" = '20240608112850_AddStateColumnToCodeAndNoteQuestionTable') THEN
    INSERT INTO "__EFMigrationsHistory" ("MigrationId", "ProductVersion")
    VALUES ('20240608112850_AddStateColumnToCodeAndNoteQuestionTable', '8.0.4');
    END IF;
END $EF$;
COMMIT;

