/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.ui.event.SearchInputListener;

public class SearchInput
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String SEARCH_BACKGROUND = "#248AC2";
    public static final String SEARCH_TITLECOLOR = "#76bce3";
    public static final String SEARCH_TEXTCOLOR = "#e8e8e8";
    JLabel searchIcon;
    JLabel searchTitle;
    JTextField searchText;

    public SearchInput() {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(6, 12, 12, 14));
        this.setBackground(Color.decode(configFile.getSetting("SEARCH_BACKGROUND", "Appearance", SEARCH_BACKGROUND)));
        this.searchIcon = new JLabel("\ue9c1");
        this.searchIcon.setFont(ConfigurationManager.getIconFont(16.0f));
        this.searchIcon.setBorder(new EmptyBorder(0, 0, 0, 8));
        this.searchIcon.setForeground(Color.decode(configFile.getSetting("SEARCH_TITLECOLOR", "Appearance", SEARCH_TITLECOLOR)));
        this.add(this.searchIcon);
        this.searchTitle = new JLabel("Search");
        this.searchTitle.setForeground(Color.decode(configFile.getSetting("SEARCH_TITLECOLOR", "Appearance", SEARCH_TITLECOLOR)));
        this.searchTitle.setBorder(new EmptyBorder(2, 0, 0, 12));
        this.add(this.searchTitle);
        this.searchText = new JTextField();
        this.searchText.setBorder(new EmptyBorder(2, 0, 0, 0));
        this.searchText.setBackground(Color.decode(configFile.getSetting("SEARCH_BACKGROUND", "Appearance", SEARCH_BACKGROUND)));
        this.searchText.setForeground(Color.decode(configFile.getSetting("SEARCH_TEXTCOLOR", "Appearance", SEARCH_TEXTCOLOR)));
        this.searchText.setCaretColor(Color.decode(configFile.getSetting("SEARCH_TEXTCOLOR", "Appearance", SEARCH_TEXTCOLOR)));
        this.searchText.setFont(ConfigurationManager.getDefaultFont(14.0f));
        this.add(this.searchText);
        this.setVisible(false);
    }

    public void performSearch(String title, final SearchInputListener listener) {
        this.searchTitle.setText(title);
        this.searchTitle.setFont(ConfigurationManager.getDefaultFont(14.0f));
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    JTextField textField = (JTextField)e.getSource();
                    if (textField.getText().length() > 0) {
                        listener.searchRequested(textField.getText());
                    }
                    SearchInput.this.setVisible(false);
                }
                if (e.getKeyCode() == 27) {
                    SearchInput.this.setVisible(false);
                }
            }
        });
        this.setVisible(true);
        this.searchText.grabFocus();
    }
}

