/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.net.GopherItem;
import org.gophie.net.GopherPage;
import org.gophie.ui.MainWindow;
import org.gophie.ui.PageMenu;
import org.gophie.ui.event.NavigationInputListener;

public class PageView
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private PageMenu pageMenu;
    private JEditorPane viewPane;
    private JEditorPane headerPane;
    private HTMLEditorKit editorKit;
    private StyleSheet styleSheet;
    private Font textFont;
    private String viewTextColor = "#ffffff";
    private String selectionColor = "#cf9a0c";
    private ConfigFile configFile = ConfigurationManager.getConfigFile();
    private ArrayList<NavigationInputListener> inputListenerList = new ArrayList();
    private GopherPage currentPage = null;

    public void addListener(NavigationInputListener listener) {
        this.inputListenerList.add(listener);
    }

    public void showGopherContent(GopherPage content) {
        this.headerPane.setText("");
        this.pageMenu.setCurrentPage(content);
        if (content.getContentType() == GopherItem.GopherItemType.IMAGE_FILE || content.getContentType() == GopherItem.GopherItemType.GIF_FILE) {
            try {
                String imageUrl;
                String imageFileExt = ".jpg";
                if (content.getContentType() == GopherItem.GopherItemType.GIF_FILE) {
                    imageFileExt = ".gif";
                }
                if ((imageUrl = content.getUrl().getUrlString()).substring(imageUrl.length() - 4).equals(".")) {
                    imageFileExt = imageUrl.substring(imageUrl.length() - 3);
                }
                if (imageUrl.substring(imageUrl.length() - 5).equals(".")) {
                    imageFileExt = imageUrl.substring(imageUrl.length() - 4);
                }
                File tempImageFile = File.createTempFile("gopherimagefile", imageFileExt);
                FileOutputStream outputStream = new FileOutputStream(tempImageFile);
                outputStream.write(content.getByteArray());
                outputStream.close();
                String imageHtmlCode = "<img src=\"" + tempImageFile.toURI().toURL().toExternalForm() + "\" />";
                try {
                    BufferedImage bufferedImage = ImageIO.read(tempImageFile);
                    int width = bufferedImage.getWidth();
                    int height = bufferedImage.getHeight();
                    if (width > 800) {
                        double calcHeight = (double)height / ((double)width / 800.0);
                        imageHtmlCode = "<img src=\"" + tempImageFile.toURI().toURL().toExternalForm() + "\" width=800 height=" + (int)calcHeight + " />";
                    }
                }
                catch (Exception ex) {
                    System.out.println("Failed to determine image size: " + ex.getMessage());
                }
                this.viewPane.setContentType("text/html");
                this.viewPane.setText(imageHtmlCode);
            }
            catch (Exception ex) {
                this.viewPane.setContentType("text/plain");
                this.viewPane.setText("Failed to display the image:\n" + ex.getMessage());
            }
        } else {
            this.viewPane.setContentType("text/plain");
            this.viewPane.setText(content.getSourceCode().replace("\n.\r\n", ""));
        }
    }

    private String formatItemTitle(String text) {
        return text.replace("&", "&amp;").replace(" ", "&nbsp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public void showGopherPage(GopherPage page) {
        this.currentPage = page;
        this.pageMenu.setCurrentPage(page);
        String renderedHeader = "<table cellspacing=\"0\" cellpadding=\"2\">";
        String renderedContent = "<table cellspacing=\"0\" cellpadding=\"2\">";
        int lineNumber = 1;
        for (GopherItem item : page.getItemList()) {
            renderedHeader = renderedHeader + "<tr><td class=\"lineNumber\">" + lineNumber + "</td><td><div class=\"itemIcon\">" + this.getGopherItemTypeIcon(item.getItemTypeCode()) + "</div></td></tr>";
            String itemTitle = this.formatItemTitle(item.getUserDisplayString());
            if (itemTitle.isEmpty()) {
                itemTitle = "&nbsp;";
            }
            String itemCode = "<span class=\"text\">" + itemTitle + "</span>";
            if (!item.getItemTypeCode().equals("i")) {
                itemCode = "<a href=\"" + item.getUrlString() + "\">" + itemTitle + "</a>";
            }
            renderedContent = renderedContent + "<tr><td class=\"item\">" + itemCode + "</td></tr>";
            ++lineNumber;
        }
        this.viewPane.setContentType("text/html");
        this.viewPane.setText(renderedContent + "</table>");
        this.headerPane.setContentType("text/html");
        this.headerPane.setText(renderedHeader + "</table>");
        this.viewPane.setCaretPosition(0);
    }

    private void configureStyle() {
        String linkColor = this.configFile.getSetting("PAGE_LINK_COLOR", "Appearance", "#22c75c");
        String lineNumberColor = this.configFile.getSetting("PAGE_LINENUMBER_COLOR", "Appearance", "#454545");
        String iconFontSize = ConfigurationManager.getConfigFile().getSetting("PAGE_ICON_FONT_SIZE", "Appearance", "10");
        this.styleSheet = this.editorKit.getStyleSheet();
        this.styleSheet.addRule("body { white-space:nowrap; margin:0; padding:0; vertical-align: top;}");
        this.styleSheet.addRule(".text { cursor:text; }");
        this.styleSheet.addRule(".lineNumber { color: " + lineNumberColor + "; }");
        this.styleSheet.addRule(".itemIcon { font-family:Feather; font-size:" + iconFontSize + "px; margin-left:5px; }");
        this.styleSheet.addRule("a { text-decoration: none; color: " + linkColor + "; }");
        this.styleSheet.addRule(".item { color: " + this.viewTextColor + "; }");
    }

    public PageView(MainWindow parent, String textColor, String backgroundColor) {
        this.editorKit = new HTMLEditorKit();
        this.viewPane = new JEditorPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        this.viewPane.setEditable(false);
        this.viewPane.setBackground(Color.decode(backgroundColor));
        this.viewPane.setForeground(Color.decode(textColor));
        this.viewPane.setBorder(new EmptyBorder(10, 4, 8, 16));
        this.viewPane.setEditorKit(this.editorKit);
        this.viewPane.setCursor(new Cursor(2));
        this.viewPane.setSelectionColor(Color.decode(this.configFile.getSetting("PAGE_SELECTION_COLOR", "Appearance", this.selectionColor)));
        this.viewPane.setDragEnabled(false);
        this.getViewport().add(this.viewPane);
        this.viewTextColor = textColor;
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(31);
        this.headerPane = new JEditorPane();
        this.headerPane.setEditable(false);
        this.headerPane.setBackground(Color.decode(backgroundColor));
        this.headerPane.setForeground(Color.decode(textColor));
        this.headerPane.setBorder(new EmptyBorder(10, 12, 8, 2));
        this.headerPane.setEditorKit(this.editorKit);
        this.headerPane.setDragEnabled(false);
        this.setRowHeaderView(this.headerPane);
        this.configureStyle();
        this.pageMenu = new PageMenu();
        this.pageMenu.addPageMenuEventListener(parent);
        this.viewPane.add(this.pageMenu);
        this.viewPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                int menuTriggerButtonId = Integer.parseInt(PageView.this.configFile.getSetting("MENU_MOUSE_TRIGGERBUTTON", "Navigation", "3"));
                if (evt.getButton() == menuTriggerButtonId) {
                    PageView.this.pageMenu.setSelectedText(PageView.this.viewPane.getSelectedText());
                    PageView.this.pageMenu.show(PageView.this.viewPane, (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
                }
            }
        });
        this.viewPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                String urlValue = e.getDescription();
                GopherItem itemObject = null;
                if (PageView.this.currentPage != null) {
                    for (GopherItem contentItem : PageView.this.currentPage.getItemList()) {
                        if (!contentItem.getUrlString().equals(urlValue)) continue;
                        itemObject = contentItem;
                    }
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    PageView.this.pageMenu.setLinkTarget(itemObject);
                }
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    PageView.this.pageMenu.setLinkTarget(null);
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    for (NavigationInputListener inputListener : PageView.this.inputListenerList) {
                        inputListener.addressRequested(urlValue, itemObject);
                    }
                }
            }
        });
        this.textFont = ConfigurationManager.getConsoleFont(ConfigurationManager.getConsoleFontSize(17.0f));
        this.viewPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.viewPane.setFont(this.textFont);
        this.headerPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.headerPane.setFont(this.textFont);
        this.headerPane.setHighlighter(null);
    }

    public void selectAllText() {
        this.viewPane.selectAll();
        this.viewPane.requestFocus();
    }

    public String getGopherItemTypeIcon(String code) {
        String result = "";
        if (code.equals("0")) {
            result = "\ue964";
        }
        if (code.equals("1")) {
            result = "\ue90f";
        }
        if (code.equals("2")) {
            result = "\ue951";
        }
        if (code.equals("3")) {
            result = "\ue97c";
        }
        if (code.equals("4")) {
            result = "\ue9bf";
        }
        if (code.equals("5")) {
            result = "\ue9bf";
        }
        if (code.equals("6")) {
            result = "\ue9bf";
        }
        if (code.equals("7")) {
            result = "\ue9c1";
        }
        if (code.equals("8")) {
            result = "\ue9dd";
        }
        if (code.equals("9")) {
            result = "\ue9bf";
        }
        if (code.equals("+")) {
            result = "\ue9c3";
        }
        if (code.equals("g")) {
            result = "\ue97a";
        }
        if (code.equals("I")) {
            result = "\ue97a";
        }
        if (code.equals("T")) {
            result = "\ue9dd";
        }
        if (code.equals("h")) {
            result = "\ue972";
        }
        if (code.equals("i")) {
            result = "";
        }
        if (code.equals("s")) {
            result = "\ue99e";
        }
        if (code.equals("?")) {
            result = "\ue9d0";
        }
        return result;
    }
}

