/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.net.GopherItem;
import org.gophie.net.GopherPage;
import org.gophie.net.GopherUrl;
import org.gophie.ui.event.PageMenuEventListener;
import org.gophie.ui.util.ImageTransferable;

public class PageMenu
extends PopupMenu {
    private static final long serialVersionUID = 1L;
    private MenuItem saveItem;
    private MenuItem saveTargetItem;
    private MenuItem copyTargetUrl;
    private MenuItem copyTargetText;
    private MenuItem copyImageUrl;
    private MenuItem copyImageObject;
    private MenuItem copySelectedItem;
    private MenuItem copyUrlItem;
    private MenuItem copyTextItem;
    private MenuItem copySourceItem;
    private MenuItem selectAllItem;
    private MenuItem setHomeGopherItem;
    private PopupMenu copyMenu;
    private String selectedText = "";
    private GopherItem targetLink;
    private GopherPage currentPage;
    private ArrayList<PageMenuEventListener> eventListenerList = new ArrayList();

    public PageMenu() {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        final String prefixEnabled = configFile.getSetting("SELECTOR_PREFIX_ENABLED", "Navigation", "yes");
        this.saveItem = new MenuItem("Save Page As...");
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.currentPage != null) {
                    for (PageMenuEventListener listener : PageMenu.this.eventListenerList) {
                        listener.pageSaveRequested(PageMenu.this.currentPage);
                    }
                }
            }
        });
        this.saveTargetItem = new MenuItem("Save Link As...");
        this.saveTargetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.targetLink != null) {
                    for (PageMenuEventListener listener : PageMenu.this.eventListenerList) {
                        listener.itemDownloadRequested(PageMenu.this.targetLink);
                    }
                }
            }
        });
        this.copyTargetUrl = new MenuItem("Copy Link URL");
        this.copyTargetUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.targetLink != null) {
                    String targetLinkUrl = PageMenu.this.targetLink.getUrlString();
                    if (prefixEnabled.equals("yes")) {
                        GopherUrl prefixUrl = new GopherUrl(PageMenu.this.targetLink.getUrlString());
                        prefixUrl.setTypePrefix(PageMenu.this.targetLink.getItemTypeCode());
                        targetLinkUrl = prefixUrl.getUrlString(true);
                    }
                    PageMenu.this.copyToClipboard(targetLinkUrl);
                }
            }
        });
        this.copyImageUrl = new MenuItem("Copy Image URL");
        this.copyImageUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.currentPage != null) {
                    String currentPageUrl = PageMenu.this.currentPage.getUrl().getUrlString();
                    if (prefixEnabled.equals("yes")) {
                        GopherUrl prefixUrl = new GopherUrl(PageMenu.this.currentPage.getUrl().getUrlString());
                        prefixUrl.setTypePrefix(GopherItem.getTypeCode(PageMenu.this.currentPage.getContentType()));
                        currentPageUrl = prefixUrl.getUrlString(true);
                    }
                    PageMenu.this.copyToClipboard(currentPageUrl);
                }
            }
        });
        this.copyImageObject = new MenuItem("Copy Image");
        this.copyImageObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.currentPage != null) {
                    PageMenu.this.copyImageToClipboard();
                }
            }
        });
        this.copyTargetText = new MenuItem("Copy Link Text");
        this.copyTargetText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.targetLink != null) {
                    PageMenu.this.copyToClipboard(PageMenu.this.targetLink.getUserDisplayString());
                }
            }
        });
        this.copySelectedItem = new MenuItem("Copy Selection");
        this.copySelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.selectedText.length() > 0) {
                    PageMenu.this.copyToClipboard(PageMenu.this.selectedText);
                }
            }
        });
        this.selectAllItem = new MenuItem("Select All");
        this.selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PageMenuEventListener listener : PageMenu.this.eventListenerList) {
                    listener.selectAllTextRequested();
                }
            }
        });
        this.setHomeGopherItem = new MenuItem("Set As Home Gopher");
        this.setHomeGopherItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.currentPage != null) {
                    for (PageMenuEventListener listener : PageMenu.this.eventListenerList) {
                        listener.setHomeGopherRequested(PageMenu.this.currentPage.getUrl().getUrlString());
                    }
                }
            }
        });
        this.copyMenu = new PopupMenu("Copy");
        this.copyUrlItem = new MenuItem("URL");
        this.copyUrlItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.currentPage != null) {
                    PageMenu.this.copyToClipboard(PageMenu.this.currentPage.getUrl().getUrlString());
                }
            }
        });
        this.copyTextItem = new MenuItem("Page Text");
        this.copyTextItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.currentPage != null) {
                    PageMenu.this.copyToClipboard(PageMenu.this.currentPage.getTextContent());
                }
            }
        });
        this.copySourceItem = new MenuItem("Source Code");
        this.copySourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PageMenu.this.currentPage != null) {
                    PageMenu.this.copyToClipboard(PageMenu.this.currentPage.getSourceCode());
                }
            }
        });
        this.copyMenu.add(this.copyUrlItem);
        this.copyMenu.add(this.copyTextItem);
        this.copyMenu.add(this.copySourceItem);
    }

    public void addPageMenuEventListener(PageMenuEventListener listener) {
        this.eventListenerList.add(listener);
    }

    @Override
    public void show(Component origin, int x, int y) {
        this.removeAll();
        if (this.targetLink == null) {
            Boolean isImage = false;
            if (this.currentPage != null) {
                switch (this.currentPage.getContentType()) {
                    case GOPHERMENU: {
                        this.saveItem.setLabel("Save Page As ...");
                        break;
                    }
                    case IMAGE_FILE: {
                        isImage = true;
                        break;
                    }
                    case GIF_FILE: {
                        isImage = true;
                        break;
                    }
                    default: {
                        this.saveItem.setLabel("Save File As ...");
                    }
                }
            }
            if (isImage.booleanValue()) {
                this.saveItem.setLabel("Save Image As ...");
            }
            this.add(this.saveItem);
            this.addSeparator();
            if (this.selectedText.length() > 0 && !isImage.booleanValue()) {
                this.add(this.copySelectedItem);
            }
            if (!isImage.booleanValue()) {
                this.add(this.selectAllItem);
                this.add(this.copyMenu);
                this.addSeparator();
                if (this.currentPage.getContentType() == GopherItem.GopherItemType.GOPHERMENU) {
                    this.addSeparator();
                    this.add(this.setHomeGopherItem);
                }
            } else {
                this.add(this.copyImageObject);
                this.add(this.copyImageUrl);
            }
        } else {
            this.add(this.saveTargetItem);
            this.addSeparator();
            this.add(this.copyTargetUrl);
            if (this.selectedText.length() > 0) {
                this.add(this.copySelectedItem);
            }
            this.add(this.copyTargetText);
        }
        super.show(origin, x, y);
    }

    private void copyImageToClipboard() {
        if (this.currentPage != null && (this.currentPage.getContentType() == GopherItem.GopherItemType.IMAGE_FILE || this.currentPage.getContentType() == GopherItem.GopherItemType.GIF_FILE)) {
            try {
                ByteArrayInputStream imageInputStream = new ByteArrayInputStream(this.currentPage.getByteArray());
                BufferedImage bufferedImage = ImageIO.read(imageInputStream);
                ImageTransferable transferImage = new ImageTransferable(bufferedImage);
                Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipBoard.setContents(transferImage, null);
            }
            catch (Exception ex) {
                System.out.println("Unable to copy image to clipboard: " + ex.getMessage());
            }
        }
    }

    private void copyToClipboard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(text), null);
    }

    public void setCurrentPage(GopherPage value) {
        this.targetLink = null;
        this.currentPage = value;
    }

    public void setLinkTarget(GopherItem value) {
        this.targetLink = value;
    }

    public void setSelectedText(String value) {
        this.selectedText = value == null ? "" : value;
    }
}

