/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.net.GopherItem;
import org.gophie.net.GopherUrl;
import org.gophie.ui.event.NavigationInputListener;

public class NavigationBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    static String textColorHex;
    static String textHoverColorHex;
    private String selectionColor = "#ffffff";
    private Font iconFont;
    private JLabel backButton;
    private JLabel forwardButton;
    private JLabel refreshButton;
    private JLabel homeButton;
    private JTextField addressInput;
    private JLabel downloadButton;
    private JLabel statusIcon;
    private Boolean isLoadingStatus = false;
    private Boolean allowNavigateForward = false;
    private Boolean allowNavigateBack = false;
    private ArrayList<NavigationInputListener> inputListenerList = new ArrayList();

    public NavigationBar(String backgroundColor, String textColor, String textHoverColor) {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        this.iconFont = ConfigurationManager.getIconFont(19.0f);
        textHoverColorHex = textHoverColor;
        textColorHex = textColor;
        this.setBackgroundColor(backgroundColor);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.backButton = this.createButton("\ue910");
        this.backButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (NavigationBar.this.allowNavigateBack.booleanValue()) {
                    for (NavigationInputListener inputListener : NavigationBar.this.inputListenerList) {
                        inputListener.backwardRequested();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (NavigationBar.this.allowNavigateBack.booleanValue()) {
                    NavigationBar.this.setCursor(new Cursor(12));
                    NavigationBar.this.backButton.setForeground(Color.decode(textHoverColorHex));
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(0));
                NavigationBar.this.backButton.setForeground(Color.decode(textColorHex));
            }
        });
        this.forwardButton = this.createButton("\ue912");
        this.forwardButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (NavigationBar.this.allowNavigateForward.booleanValue()) {
                    for (NavigationInputListener inputListener : NavigationBar.this.inputListenerList) {
                        inputListener.forwardRequested();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (NavigationBar.this.allowNavigateForward.booleanValue()) {
                    NavigationBar.this.setCursor(new Cursor(12));
                    NavigationBar.this.forwardButton.setForeground(Color.decode(textHoverColorHex));
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(0));
                NavigationBar.this.forwardButton.setForeground(Color.decode(textColorHex));
            }
        });
        this.refreshButton = this.createButton("\ue9b9");
        this.refreshButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (!NavigationBar.this.isLoadingStatus.booleanValue()) {
                    for (NavigationInputListener inputListener : NavigationBar.this.inputListenerList) {
                        inputListener.refreshRequested();
                    }
                } else {
                    for (NavigationInputListener inputListener : NavigationBar.this.inputListenerList) {
                        inputListener.stopRequested();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(12));
                NavigationBar.this.refreshButton.setForeground(Color.decode(textHoverColorHex));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(0));
                NavigationBar.this.refreshButton.setForeground(Color.decode(textColorHex));
            }
        });
        this.homeButton = this.createButton("\ue979");
        this.homeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                for (NavigationInputListener inputListener : NavigationBar.this.inputListenerList) {
                    inputListener.homeGopherRequested();
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(12));
                NavigationBar.this.homeButton.setForeground(Color.decode(textHoverColorHex));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(0));
                NavigationBar.this.homeButton.setForeground(Color.decode(textColorHex));
            }
        });
        this.addressInput = this.createAddressInput();
        this.addressInput.setSelectionColor(Color.decode(configFile.getSetting("NAVIGATIONBAR_SELECTION_COLOR", "Appearance", this.selectionColor)));
        this.addressInput.setCaretColor(Color.decode(textColorHex));
        this.downloadButton = this.createButton("\ue90b");
        this.downloadButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                for (NavigationInputListener inputListener : NavigationBar.this.inputListenerList) {
                    inputListener.showDownloadRequested();
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(12));
                NavigationBar.this.downloadButton.setForeground(Color.decode(textHoverColorHex));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NavigationBar.this.setCursor(new Cursor(0));
                NavigationBar.this.downloadButton.setForeground(Color.decode(textColorHex));
            }
        });
        ImageIcon statusIconImage = ConfigurationManager.getImageIcon("loading.gif");
        this.statusIcon = new JLabel(statusIconImage);
        this.statusIcon.setBorder(new EmptyBorder(0, 8, 0, 2));
        this.statusIcon.setOpaque(false);
        this.statusIcon.setVisible(false);
        this.add(this.statusIcon);
    }

    public void setNavigateForward(Boolean value) {
        this.allowNavigateForward = value;
    }

    public void setNavigateBack(Boolean value) {
        this.allowNavigateBack = value;
    }

    public void setIsLoading(Boolean status) {
        this.isLoadingStatus = status;
        if (status.booleanValue()) {
            this.statusIcon.setVisible(true);
            this.refreshButton.setText("\ue9d6");
        } else {
            this.statusIcon.setVisible(false);
            this.refreshButton.setText("\ue9b9");
        }
    }

    public void addListener(NavigationInputListener listener) {
        this.inputListenerList.add(listener);
    }

    public void setAddressText(String addressText) {
        this.addressInput.setText(addressText);
    }

    private JTextField createAddressInput() {
        final JTextField inputField = new JTextField();
        inputField.setBorder(new EmptyBorder(4, 10, 6, 4));
        inputField.setFont(ConfigurationManager.getDefaultFont(14.0f));
        inputField.setForeground(Color.decode(textColorHex));
        inputField.setOpaque(false);
        this.add(inputField);
        inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String requestedAddress = inputField.getText().trim();
                if (requestedAddress.length() > 0) {
                    for (NavigationInputListener inputListener : NavigationBar.this.inputListenerList) {
                        GopherUrl gopherUrl;
                        String address = requestedAddress;
                        GopherItem item = new GopherItem();
                        ConfigFile configFile = ConfigurationManager.getConfigFile();
                        String prefixEnabled = configFile.getSetting("SELECTOR_PREFIX_ENABLED", "Navigation", "yes");
                        if (prefixEnabled.equals("yes") && (gopherUrl = new GopherUrl(address)).hasTypePrefix()) {
                            item = new GopherItem(gopherUrl.getTypePrefix(), gopherUrl);
                            address = gopherUrl.getUrlString();
                        }
                        inputListener.addressRequested(address, item);
                    }
                }
            }
        });
        return inputField;
    }

    private JLabel createButton(String text) {
        JLabel button = new JLabel(text);
        button.setFont(this.iconFont);
        button.setForeground(Color.decode(textColorHex));
        button.setBorder(new EmptyBorder(0, 8, 0, 8));
        this.add(button);
        return button;
    }

    public void setBackgroundColor(String colorHex) {
        this.setBackground(Color.decode(colorHex));
    }
}

