/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.ui.event.MessageViewListener;

public class MessageView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGEVIEW_BACKGROUND_COLOR = "#fcba03";
    private static final String MESSAGEVIEW_FOREGROUND_COLOR = "#000000";
    private JLabel messageIcon;
    private JLabel messageText;
    private JPanel buttonPanel;
    private Font iconFont;

    public MessageView() {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        this.iconFont = ConfigurationManager.getIconFont(19.0f);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 16));
        this.setBackground(Color.decode(configFile.getSetting("MESSAGEVIEW_BACKGROUND_COLOR", "Appearance", MESSAGEVIEW_BACKGROUND_COLOR)));
        this.messageIcon = new JLabel();
        this.messageIcon.setFont(this.iconFont);
        this.messageIcon.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.messageIcon.setForeground(Color.decode(configFile.getSetting("MESSAGEVIEW_FOREGROUND_COLOR", "Appearance", MESSAGEVIEW_FOREGROUND_COLOR)));
        this.messageText = new JLabel();
        this.messageText.setFont(ConfigurationManager.getDefaultFont(11.0f));
        this.messageText.setForeground(Color.decode(configFile.getSetting("MESSAGEVIEW_FOREGROUND_COLOR", "Appearance", MESSAGEVIEW_FOREGROUND_COLOR)));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(new EmptyBorder(0, 30, 0, 0));
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBackground(Color.decode(configFile.getSetting("MESSAGEVIEW_BACKGROUND_COLOR", "Appearance", MESSAGEVIEW_BACKGROUND_COLOR)));
        this.add((Component)this.messageIcon, "West");
        this.add((Component)this.messageText, "Center");
        this.add((Component)this.buttonPanel, "East");
        this.setVisible(false);
    }

    private JLabel createButton(String text) {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        String buttonColor = configFile.getSetting("MESSAGEVIEW_FOREGROUND_COLOR", "Appearance", MESSAGEVIEW_FOREGROUND_COLOR);
        JLabel customButton = new JLabel("<html><div style=\"border:1px solid " + buttonColor + ";padding:2px 6px 2px 6px;border-radius:6px;\">" + text + "</div></html>");
        customButton.setCursor(new Cursor(12));
        customButton.setFont(ConfigurationManager.getDefaultFont(11.0f));
        customButton.setBorder(new EmptyBorder(0, 5, 0, 5));
        customButton.setForeground(Color.decode(buttonColor));
        return customButton;
    }

    public void showInfo(String text) {
        this.messageIcon.setText("\ue902");
        this.messageText.setText(text);
        this.buttonPanel.removeAll();
        JLabel closeButton = this.createButton("Close");
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MessageView.this.setVisible(false);
            }
        });
        this.buttonPanel.add(closeButton);
        this.setVisible(true);
    }

    public void showConfirm(String text, String[] optionList, final MessageViewListener eventListener) {
        this.messageIcon.setText("\ue904");
        this.messageText.setText(text);
        this.buttonPanel.removeAll();
        int i = 0;
        while (i < optionList.length) {
            JLabel optionButton = this.createButton(optionList[i]);
            final int optionId = i++;
            optionButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent evt) {
                    eventListener.optionSelected(optionId);
                }
            });
            this.buttonPanel.add(optionButton);
        }
        this.setVisible(true);
    }
}

