/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.config.SystemUtility;
import org.gophie.net.DownloadItem;
import org.gophie.net.DownloadList;
import org.gophie.net.GopherClient;
import org.gophie.net.GopherItem;
import org.gophie.net.GopherPage;
import org.gophie.net.GopherUrl;
import org.gophie.net.event.GopherClientEventListener;
import org.gophie.net.event.GopherError;
import org.gophie.ui.DownloadWindow;
import org.gophie.ui.MessageView;
import org.gophie.ui.NavigationBar;
import org.gophie.ui.PageView;
import org.gophie.ui.SearchInput;
import org.gophie.ui.event.MessageViewListener;
import org.gophie.ui.event.NavigationInputListener;
import org.gophie.ui.event.PageMenuEventListener;
import org.gophie.ui.event.SearchInputListener;

public class MainWindow
implements NavigationInputListener,
GopherClientEventListener,
PageMenuEventListener {
    public static final String APPLICATION_TITLE = "Gophie";
    public static final String NAVIGATIONBAR_BACKGROUND = "#248AC2";
    public static final String NAVIGATIONBAR_TEXTCOLOR = "#76bce3";
    public static final String NAVIGATIONBAR_TEXTHOVERCOLOR = "#ffffff";
    public static final String VIEW_BACKGROUND = "#1b1b1b";
    public static final String VIEW_TEXTCOLOR = "#e8e8e8";
    public static final String DEFAULT_GOPHERHOME = "gopher.floodgap.com";
    private GopherClient gopherClient;
    private DownloadList downloadList;
    private ArrayList<GopherPage> history = new ArrayList();
    private int historyPosition = -1;
    private JFrame frame;
    private PageView pageView;
    private NavigationBar navigationBar;
    private JPanel headerBar;
    private MessageView messageView;
    private SearchInput searchInput;
    private DownloadWindow downloadWindow;

    public MainWindow() {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        this.gopherClient = new GopherClient();
        this.downloadList = new DownloadList();
        this.downloadWindow = new DownloadWindow(this.downloadList);
        this.frame = new JFrame(APPLICATION_TITLE);
        this.frame.setMinimumSize(new Dimension(800, 600));
        this.frame.setDefaultCloseOperation(3);
        this.frame.setIconImage(ConfigurationManager.getImage("icon.png"));
        this.pageView = new PageView(this, configFile.getSetting("VIEW_TEXTCOLOR", "Appearance", VIEW_TEXTCOLOR), configFile.getSetting("VIEW_BACKGROUND", "Appearance", VIEW_BACKGROUND));
        this.pageView.addListener(this);
        this.navigationBar = new NavigationBar(configFile.getSetting("NAVIGATIONBAR_BACKGROUND", "Appearance", NAVIGATIONBAR_BACKGROUND), configFile.getSetting("NAVIGATIONBAR_TEXTCOLOR", "Appearance", NAVIGATIONBAR_TEXTCOLOR), configFile.getSetting("NAVIGATIONBAR_TEXTHOVERCOLOR", "Appearance", NAVIGATIONBAR_TEXTHOVERCOLOR));
        String gopherHome = configFile.getSetting("GOPHERHOME", "Navigation", DEFAULT_GOPHERHOME);
        this.navigationBar.setAddressText(gopherHome);
        this.navigationBar.addListener(this);
        this.headerBar = new JPanel();
        this.headerBar.setLayout(new BoxLayout(this.headerBar, 1));
        this.messageView = new MessageView();
        this.headerBar.add(this.messageView);
        this.searchInput = new SearchInput();
        this.headerBar.add(this.searchInput);
        Container contentPane = this.frame.getContentPane();
        contentPane.add((Component)this.headerBar, "North");
        contentPane.add((Component)this.pageView, "Center");
        contentPane.add((Component)this.navigationBar, "South");
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(dim.width / 2 - this.frame.getSize().width / 2, dim.height / 2 - this.frame.getSize().height / 2);
        this.frame.setVisible(true);
        this.fetchGopherContent(gopherHome, GopherItem.GopherItemType.GOPHERMENU);
    }

    public void show() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void updateHistory(GopherPage page) {
        Boolean addToHistory = false;
        if (this.historyPosition == this.history.size() - 1) {
            if (this.history.size() > 0) {
                if (!this.history.get(this.history.size() - 1).getUrl().getUrlString().equals(page.getUrl().getUrlString())) {
                    addToHistory = true;
                }
            } else {
                addToHistory = true;
            }
        } else if (!this.history.get(this.historyPosition).getUrl().getUrlString().equals(page.getUrl().getUrlString())) {
            ArrayList<GopherPage> updatedHistory = new ArrayList<GopherPage>();
            for (int h = 0; h <= this.historyPosition; ++h) {
                updatedHistory.add(this.history.get(h));
            }
            this.history = updatedHistory;
            addToHistory = true;
        }
        this.navigationBar.setNavigateBack(false);
        this.navigationBar.setNavigateForward(false);
        if (addToHistory.booleanValue()) {
            this.history.add(page);
            this.historyPosition = this.history.size() - 1;
            this.navigationBar.setNavigateForward(false);
            if (this.history.size() > 1) {
                this.navigationBar.setNavigateBack(true);
            }
        } else {
            if (this.historyPosition > 0) {
                this.navigationBar.setNavigateBack(true);
            }
            if (this.historyPosition < this.history.size() - 1) {
                this.navigationBar.setNavigateForward(true);
            }
        }
    }

    public void confirmDownload(String addressText, final GopherItem item) {
        String confirmText = "Download \"" + item.getFileName() + "\" from \"" + item.getHostName() + "\"?";
        String[] optionList = new String[]{"Open", "Save", "Dismiss"};
        this.messageView.showConfirm(confirmText, optionList, new MessageViewListener(){

            @Override
            public void optionSelected(int option) {
                if (option == 0) {
                    String targetFileName = ConfigurationManager.getDownloadPath() + item.getFileName();
                    MainWindow.this.downloadList.add(new DownloadItem(item, targetFileName, true));
                    MainWindow.this.messageView.setVisible(false);
                }
                if (option == 1) {
                    MainWindow.this.initiateDownload(item);
                    MainWindow.this.messageView.setVisible(false);
                }
                MainWindow.this.messageView.setVisible(false);
            }
        });
    }

    public void initiateDownload(GopherItem fileItem) {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Download and save file", 1);
        fileDialog.setFile(fileItem.getFileNameWithForcedExt());
        fileDialog.setVisible(true);
        String targetFileName = fileDialog.getDirectory() + fileDialog.getFile();
        if (!targetFileName.equals(null) && !targetFileName.equals("nullnull")) {
            this.downloadList.add(new DownloadItem(fileItem, targetFileName, false));
        }
    }

    @Override
    public void addressRequested(final String addressText, GopherItem item) {
        if (item.isBinaryFile().booleanValue()) {
            this.confirmDownload(addressText, item);
        } else {
            switch (item.getItemType()) {
                case FULLTEXT_SEARCH: {
                    this.searchInput.performSearch(item.getUserDisplayString(), new SearchInputListener(){

                        @Override
                        public void searchRequested(String text) {
                            String searchQueryText = addressText + "\t" + text;
                            MainWindow.this.fetchGopherContent(searchQueryText, GopherItem.GopherItemType.GOPHERMENU);
                        }
                    });
                    break;
                }
                case CCSCO_NAMESERVER: {
                    this.openTelnetSession(item.getHostName(), item.getPortNumber());
                    break;
                }
                case TELNET: {
                    this.openTelnetSession(item.getHostName(), item.getPortNumber());
                    break;
                }
                case TELNET3270: {
                    this.openTelnetSession(item.getHostName(), item.getPortNumber());
                    break;
                }
                default: {
                    if (addressText.startsWith("https://") || addressText.startsWith("http://")) {
                        this.openWebContent(addressText, item.getItemType());
                        break;
                    }
                    if (addressText.startsWith("mailto:")) {
                        this.openEmailClient(addressText.replace("mailto:", ""));
                        break;
                    }
                    this.fetchGopherContent(new GopherUrl(addressText).getUrlString(), item.getItemType());
                }
            }
        }
    }

    private void openEmailClient(final String emailAddress) {
        String confirmText = "Do you want to send an e-mail to \"" + emailAddress + "\"?";
        String[] optionList = new String[]{"Create new e-mail", "Dismiss"};
        this.messageView.showConfirm(confirmText, optionList, new MessageViewListener(){

            @Override
            public void optionSelected(int option) {
                if (option == 0) {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        try {
                            Desktop.getDesktop().browse(new URI("mailto:" + emailAddress));
                        }
                        catch (Exception ex) {
                            System.out.println("Unable to open system's email client: " + ex.getMessage());
                        }
                    }
                    MainWindow.this.messageView.setVisible(false);
                } else {
                    MainWindow.this.messageView.setVisible(false);
                }
            }
        });
    }

    private void openTelnetSession(final String hostName, final int portNumber) {
        String confirmText = "Open a Telnet session with \"" + hostName + ":" + portNumber + "\"?";
        String[] optionList = new String[]{"Open Telnet", "Dismiss"};
        this.messageView.showConfirm(confirmText, optionList, new MessageViewListener(){

            @Override
            public void optionSelected(int option) {
                if (option == 0) {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        try {
                            String telnetUri = "telnet://" + hostName + ":" + portNumber;
                            Desktop.getDesktop().browse(new URI(telnetUri));
                        }
                        catch (Exception ex) {
                            System.out.println("Unable to open system's telnet client: " + ex.getMessage());
                        }
                    }
                    MainWindow.this.messageView.setVisible(false);
                } else {
                    MainWindow.this.messageView.setVisible(false);
                }
            }
        });
    }

    private void openWebContent(final String addressText, GopherItem.GopherItemType contentType) {
        String confirmText = "Open \"" + addressText + "\" with your web browser?";
        String[] optionList = new String[]{"Open Website", "Dismiss"};
        this.messageView.showConfirm(confirmText, optionList, new MessageViewListener(){

            @Override
            public void optionSelected(int option) {
                if (option == 0) {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        try {
                            Desktop.getDesktop().browse(new URI(addressText));
                        }
                        catch (Exception ex) {
                            System.out.println("Unable to open system's world wide web browser: " + ex.getMessage());
                        }
                    }
                    MainWindow.this.messageView.setVisible(false);
                } else {
                    MainWindow.this.messageView.setVisible(false);
                }
            }
        });
    }

    private void fetchGopherContent(String addressText, GopherItem.GopherItemType contentType) {
        this.navigationBar.setIsLoading(true);
        String address = addressText;
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        String prefixEnabled = configFile.getSetting("SELECTOR_PREFIX_ENABLED", "Navigation", "yes");
        if (prefixEnabled.equals("yes")) {
            GopherUrl prefixUrl = new GopherUrl(addressText);
            prefixUrl.setTypePrefix(GopherItem.getTypeCode(contentType));
            address = prefixUrl.getUrlString(true);
        }
        this.navigationBar.setAddressText(address);
        try {
            this.gopherClient.fetchAsync(addressText, contentType, this);
        }
        catch (Exception ex) {
            System.out.println("Exception while fetching async: " + ex.getMessage());
        }
    }

    @Override
    public void backwardRequested() {
        if (this.historyPosition > 0) {
            --this.historyPosition;
            this.pageLoaded(this.history.get(this.historyPosition));
            this.updateHistory(this.history.get(this.historyPosition));
        }
    }

    @Override
    public void forwardRequested() {
        if (this.historyPosition < this.history.size() - 1) {
            ++this.historyPosition;
            this.pageLoaded(this.history.get(this.historyPosition));
            this.updateHistory(this.history.get(this.historyPosition));
        }
    }

    @Override
    public void refreshRequested() {
        GopherPage currentPage = this.history.get(this.historyPosition);
        this.fetchGopherContent(currentPage.getUrl().getUrlString(), currentPage.getContentType());
    }

    @Override
    public void stopRequested() {
        this.gopherClient.cancelFetch();
        this.pageLoadFailed(GopherError.USER_CANCELLED, null);
    }

    @Override
    public void pageLoaded(GopherPage result) {
        this.frame.setTitle(result.getUrl().getUrlString() + " (" + SystemUtility.getFileSizeString(result.getByteArray().length) + ") - " + APPLICATION_TITLE);
        String address = result.getUrl().getUrlString();
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        String prefixEnabled = configFile.getSetting("SELECTOR_PREFIX_ENABLED", "Navigation", "yes");
        if (prefixEnabled.equals("yes")) {
            GopherUrl prefixUrl = result.getUrl();
            prefixUrl.setTypePrefix(GopherItem.getTypeCode(result.getContentType()));
            address = prefixUrl.getUrlString(true);
        }
        this.navigationBar.setAddressText(address);
        if (result.getContentType() == GopherItem.GopherItemType.GOPHERMENU) {
            this.pageView.showGopherPage(result);
        } else {
            this.pageView.showGopherContent(result);
        }
        this.updateHistory(result);
        this.navigationBar.setIsLoading(false);
    }

    @Override
    public void pageLoadFailed(GopherError error, GopherUrl url) {
        if (error == GopherError.CONNECT_FAILED && url != null) {
            this.messageView.showInfo("Connection refused: " + url.getHost());
        }
        if (error == GopherError.CONNECTION_TIMEOUT && url != null) {
            this.messageView.showInfo("Connection timed out: " + url.getHost());
        }
        if (error == GopherError.HOST_UNKNOWN && url != null) {
            this.messageView.showInfo("Server not found: " + url.getHost());
        }
        if (error == GopherError.EXCEPTION) {
            this.messageView.showInfo("Ouchn, an unknown error occured.");
        }
        System.out.println("Failed to load gopher page: " + error.toString());
        this.navigationBar.setIsLoading(false);
    }

    @Override
    public void progress(GopherUrl url, long byteCount) {
        this.frame.setTitle(url.getUrlString() + " (" + SystemUtility.getFileSizeString(byteCount) + ") - " + APPLICATION_TITLE);
    }

    @Override
    public void showDownloadRequested() {
        if (this.downloadWindow.isVisible()) {
            this.downloadWindow.hide();
        } else {
            this.downloadWindow.show(this.frame);
        }
    }

    @Override
    public void setHomeGopherRequested(String url) {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        configFile.setSetting("GOPHERHOME", url, "Navigation");
        configFile.save();
    }

    @Override
    public void itemDownloadRequested(GopherItem item) {
        this.initiateDownload(item);
    }

    @Override
    public void pageSaveRequested(GopherPage page) {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Save current file", 1);
        fileDialog.setFile(page.getFileName());
        fileDialog.setVisible(true);
        String targetFileName = fileDialog.getDirectory() + fileDialog.getFile();
        if (!targetFileName.equals(null) && !targetFileName.equals("nullnull")) {
            page.saveAsFile(targetFileName);
        }
    }

    @Override
    public void selectAllTextRequested() {
        this.pageView.selectAllText();
    }

    @Override
    public void homeGopherRequested() {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        String homeGopherUrl = configFile.getSetting("GOPHERHOME", "Navigation", DEFAULT_GOPHERHOME);
        this.fetchGopherContent(homeGopherUrl, GopherItem.GopherItemType.GOPHERMENU);
        this.navigationBar.setAddressText(homeGopherUrl);
    }

    @Override
    public void pageLoadItemMismatch(GopherItem.GopherItemType requested, GopherItem.GopherItemType detected, GopherUrl url) {
        this.navigationBar.setIsLoading(false);
        this.confirmDownload(url.getUrlString(), new GopherItem(detected, url));
    }
}

