/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.net.DownloadItem;
import org.gophie.net.DownloadList;
import org.gophie.net.event.DownloadListEventListener;
import org.gophie.ui.ActionButton;
import org.gophie.ui.DownloadItemRenderer;
import org.gophie.ui.event.ActionButtonEventListener;

public class DownloadWindow
implements ActionButtonEventListener {
    private static final String ACTIONBAR_BACKGROUND = "#248AC2";
    private static final String ACTIONBAR_TEXTCOLOR = "#ffffff";
    private static final String ACTIONBAR_INACTIVE_TEXTCOLOR = "#76bce3";
    private static final String FILELIST_BACKGROUND = "#1b1b1b";
    private DownloadList list;
    private DownloadItem[] data;
    private JDialog frame;
    private JList<DownloadItem> fileListView;
    private JPanel actionBar = new JPanel();
    private ActionButton clearButton;
    private ActionButton actionButton;

    public DownloadWindow(DownloadList downloadList) {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        this.list = downloadList;
        this.list.addEventListener(new DownloadListEventListener(){

            @Override
            public void downloadListUpdated() {
                DownloadWindow.this.updateList();
            }

            @Override
            public void downloadProgressReported() {
                DownloadWindow.this.handleSelectionChange();
                DownloadWindow.this.frame.repaint();
            }
        });
        this.frame = new JDialog();
        this.frame.setTitle("Downloads");
        this.frame.setMinimumSize(new Dimension(400, 200));
        this.frame.setLayout(new BorderLayout());
        this.frame.setIconImage(ConfigurationManager.getImage("icon.png"));
        this.fileListView = new JList();
        this.fileListView.setSelectionMode(0);
        this.fileListView.setCellRenderer(new DownloadItemRenderer());
        this.fileListView.setFixedCellWidth(this.fileListView.getWidth());
        this.fileListView.setOpaque(true);
        this.fileListView.setBackground(Color.decode(configFile.getSetting("FILELIST_BACKGROUND", "Appearance", FILELIST_BACKGROUND)));
        JScrollPane listScrollPane = new JScrollPane(this.fileListView);
        listScrollPane.setOpaque(false);
        listScrollPane.getViewport().setOpaque(false);
        this.frame.add((Component)listScrollPane, "Center");
        this.clearButton = new ActionButton("\ue9e3", "Clear List", configFile.getSetting("ACTIONBAR_TEXTCOLOR", "Appearance", ACTIONBAR_TEXTCOLOR), configFile.getSetting("ACTIONBAR_INACTIVE_TEXTCOLOR", "Appearance", ACTIONBAR_INACTIVE_TEXTCOLOR));
        this.clearButton.setButtonEnabled(false);
        this.clearButton.setButtonId(1);
        this.clearButton.addEventListener(this);
        this.actionButton = new ActionButton("\uea02", "Abort", configFile.getSetting("ACTIONBAR_TEXTCOLOR", "Appearance", ACTIONBAR_TEXTCOLOR), configFile.getSetting("ACTIONBAR_INACTIVE_TEXTCOLOR", "Appearance", ACTIONBAR_INACTIVE_TEXTCOLOR));
        this.actionButton.setButtonId(0);
        this.actionButton.addEventListener(this);
        this.actionBar.setLayout(new BorderLayout());
        this.actionBar.setBorder(new EmptyBorder(8, 16, 10, 16));
        this.actionBar.setBackground(Color.decode(configFile.getSetting("ACTIONBAR_BACKGROUND", "Appearance", ACTIONBAR_BACKGROUND)));
        this.actionBar.add((Component)this.clearButton, "East");
        this.actionBar.add((Component)this.actionButton, "West");
        this.frame.add((Component)this.actionBar, "South");
        this.actionButton.setVisible(false);
        this.fileListView.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadWindow.this.handleSelectionChange();
            }
        });
        this.updateList();
    }

    private void handleSelectionChange() {
        DownloadItem selected = this.fileListView.getSelectedValue();
        if (selected == null) {
            this.actionButton.setVisible(false);
        } else {
            if (selected.getStatus() == DownloadItem.DownloadStatus.ACTIVE) {
                this.actionButton.setContent("\uea02", "Abort");
            }
            if (selected.getStatus() == DownloadItem.DownloadStatus.FAILED) {
                this.actionButton.setContent("\ue9b9", "Retry");
            }
            if (selected.getStatus() == DownloadItem.DownloadStatus.COMPLETED) {
                this.actionButton.setContent("\ue9c5", "Open");
            }
            if (selected.getStatus() == DownloadItem.DownloadStatus.IDLE) {
                this.actionButton.setContent("\ue913", "Start");
            }
            this.actionButton.setVisible(true);
            this.actionButton.setButtonEnabled(true);
        }
        if (this.list.hasNonActiveItems().booleanValue()) {
            this.clearButton.setButtonEnabled(true);
        } else {
            this.clearButton.setButtonEnabled(false);
        }
    }

    public void updateList() {
        this.data = this.list.getDownloadItemArray();
        int selectedIndex = this.fileListView.getSelectedIndex();
        this.fileListView.setListData((DownloadItem[])this.data);
        if (selectedIndex < this.data.length) {
            this.fileListView.setSelectedIndex(selectedIndex);
        } else if (this.data.length > 0) {
            this.fileListView.setSelectedIndex(this.data.length - 1);
        }
        this.handleSelectionChange();
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    public void show(JFrame parent) {
        this.updateList();
        this.frame.setLocationRelativeTo(parent);
        this.frame.setVisible(true);
    }

    @Override
    public void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            DownloadItem item = this.fileListView.getSelectedValue();
            if (item.getStatus() == DownloadItem.DownloadStatus.ACTIVE) {
                item.cancel();
                this.list.remove(item);
                item.deleteFile();
            }
            if (item.getStatus() == DownloadItem.DownloadStatus.FAILED) {
                item.start();
            }
            if (item.getStatus() == DownloadItem.DownloadStatus.COMPLETED) {
                item.openFileOnDesktop();
            }
            if (item.getStatus() == DownloadItem.DownloadStatus.IDLE) {
                item.start();
            }
        }
        if (buttonId == 1) {
            this.list.clearNonActiveItems();
        }
        this.updateList();
    }
}

