/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.gophie.config.ConfigFile;
import org.gophie.config.ConfigurationManager;
import org.gophie.config.SystemUtility;
import org.gophie.net.DownloadItem;
import org.gophie.net.GopherItem;

public class DownloadItemRenderer
extends JPanel
implements ListCellRenderer<DownloadItem> {
    private static final long serialVersionUID = 1L;
    private JLabel titleLabel = new JLabel();
    private JLabel textLabel = new JLabel();

    @Override
    public Component getListCellRendererComponent(JList<? extends DownloadItem> list, DownloadItem value, int index, boolean isSelected, boolean cellHasFocus) {
        ConfigFile configFile = ConfigurationManager.getConfigFile();
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        if (isSelected) {
            this.setOpaque(true);
            this.setBackground(Color.decode(configFile.getSetting("DOWNLOAD_SELECTED_COLOR", "Appearance", "#cf9a0c")));
        }
        GopherItem item = value.getGopherItem();
        this.titleLabel.setText(item.getFileName());
        Font titleFont = ConfigurationManager.getConsoleFont(15.0f);
        this.titleLabel.setFont(titleFont.deriveFont(titleFont.getStyle() | 1));
        this.titleLabel.setForeground(Color.decode(configFile.getSetting("DOWNLOAD_TITLE_COLOR", "Appearance", "#ffffff")));
        String statusText = "Download not started";
        String byteLoadedText = SystemUtility.getFileSizeString(value.getByteCountLoaded());
        if (value.getStatus() == DownloadItem.DownloadStatus.COMPLETED) {
            statusText = "Completed (" + byteLoadedText + ")";
        }
        if (value.getStatus() == DownloadItem.DownloadStatus.ACTIVE) {
            String transferRate = SystemUtility.getFileSizeString(value.getBytePerSecond());
            statusText = byteLoadedText + " (" + transferRate + "/sec)";
        }
        if (value.getStatus() == DownloadItem.DownloadStatus.FAILED) {
            statusText = "Failed (" + byteLoadedText + ")";
        }
        statusText = statusText + " \u2014 " + item.getHostName();
        this.textLabel.setText(statusText);
        this.textLabel.setBorder(new EmptyBorder(4, 0, 0, 0));
        this.textLabel.setForeground(Color.decode(configFile.getSetting("DOWNLOAD_TEXT_COLOR", "Appearance", "#e0e0e0")));
        Font textFont = ConfigurationManager.getConsoleFont(13.0f);
        this.textLabel.setFont(textFont);
        this.add(this.titleLabel);
        this.add(this.textLabel);
        return this;
    }
}

