/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.gophie.config.ConfigurationManager;
import org.gophie.ui.event.ActionButtonEventListener;

public class ActionButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int buttonId = 0;
    private String inactiveTextColor = "";
    private String textColor = "";
    private Boolean isEnabledButton = false;
    private ArrayList<ActionButtonEventListener> eventListenerList = new ArrayList();
    private JLabel iconLabel;
    private JLabel textLabel;

    public ActionButton(String iconText, String text, String textColorHex, String inactiveTextColorHex) {
        this.textColor = textColorHex;
        this.inactiveTextColor = inactiveTextColorHex;
        this.setLayout(new BorderLayout());
        this.setCursor(new Cursor(12));
        this.setOpaque(false);
        this.iconLabel = new JLabel(iconText);
        this.iconLabel.setBorder(new EmptyBorder(0, 0, 0, 6));
        this.iconLabel.setOpaque(false);
        this.iconLabel.setFont(ConfigurationManager.getIconFont(14.0f));
        this.iconLabel.setForeground(Color.decode(inactiveTextColorHex));
        this.add((Component)this.iconLabel, "West");
        this.textLabel = new JLabel(text);
        this.textLabel.setOpaque(false);
        this.textLabel.setFont(ConfigurationManager.getDefaultFont(12.0f));
        this.textLabel.setForeground(Color.decode(inactiveTextColorHex));
        this.add((Component)this.textLabel, "East");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                for (ActionButtonEventListener listener : ActionButton.this.eventListenerList) {
                    listener.buttonPressed(ActionButton.this.buttonId);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (ActionButton.this.isButtonEnabled().booleanValue()) {
                    ActionButton.this.iconLabel.setForeground(Color.decode(ActionButton.this.textColor));
                    ActionButton.this.textLabel.setForeground(Color.decode(ActionButton.this.textColor));
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ActionButton.this.iconLabel.setForeground(Color.decode(ActionButton.this.inactiveTextColor));
                ActionButton.this.textLabel.setForeground(Color.decode(ActionButton.this.inactiveTextColor));
            }
        });
    }

    public void setButtonId(int value) {
        this.buttonId = value;
    }

    public void addEventListener(ActionButtonEventListener listener) {
        this.eventListenerList.add(listener);
    }

    public void setContent(String iconText, String text) {
        this.iconLabel.setText(iconText);
        this.textLabel.setText(text);
    }

    public void setTextColor(String colorHex) {
        this.textColor = colorHex;
    }

    public void setInactiveTextColor(String colorHex) {
        this.inactiveTextColor = colorHex;
    }

    public void setButtonEnabled(Boolean value) {
        this.isEnabledButton = value;
        if (value.booleanValue()) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    public Boolean isButtonEnabled() {
        return this.isEnabledButton;
    }
}

