/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.net;

public class GopherUrl {
    private int port = 70;
    private String host;
    private String selector;

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getTypePrefix() {
        String itemTypeCode;
        String result = null;
        if (this.selector.length() >= 3 && this.selector.charAt(0) == '/' && this.selector.charAt(2) == '/' && (itemTypeCode = this.selector.substring(1, 2)).matches("[0-9\\+gIThis\\?]")) {
            result = itemTypeCode;
        }
        return result;
    }

    public boolean hasTypePrefix() {
        boolean result = false;
        if (this.getTypePrefix() != null) {
            result = true;
        }
        return result;
    }

    public String getUrlString() {
        return this.getUrlString(false);
    }

    public void setTypePrefix(String prefix) {
        this.selector = this.hasTypePrefix() ? (this.selector.length() > 3 ? (this.selector.substring(3, 4).equals("/") ? "/" + prefix + this.selector.substring(3) : "/" + prefix + "/" + this.selector.substring(3)) : "/" + prefix + "/") : (this.selector.length() > 0 ? (this.selector.substring(0, 1).equals("/") ? "/" + prefix + this.selector : "/" + prefix + "/" + this.selector) : "/" + prefix + "/");
    }

    public String getUrlString(boolean includeTypePrefix) {
        String result = this.host;
        if (this.port != 70) {
            result = result + ":" + this.port;
        }
        String selectorValue = this.selector;
        if (this.hasTypePrefix() && !includeTypePrefix) {
            selectorValue = selectorValue.substring(3);
        }
        if (selectorValue.length() > 0) {
            result = selectorValue.startsWith("/") ? result + selectorValue : result + "/" + selectorValue;
        }
        return result;
    }

    public GopherUrl(String url) {
        this.host = url;
        if (this.host.startsWith("gopher://")) {
            this.host = this.host.substring(9);
        }
        if (this.host.indexOf("/") > 0) {
            this.selector = this.host.substring(this.host.indexOf("/"));
            this.host = this.host.substring(0, this.host.indexOf("/"));
        } else {
            this.selector = "";
        }
        if (this.host.indexOf(":") > 0) {
            String[] valueList = this.host.split(":");
            this.host = valueList[0];
            this.port = Integer.parseInt(valueList[1]);
        }
    }
}

