/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.net;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import org.gophie.config.ConfigurationManager;
import org.gophie.net.GopherItem;
import org.gophie.net.GopherUrl;

public class GopherPage {
    private static final String GOPHERPAGE_DEFAULT_CHARSET = "UTF-8";
    private byte[] sourceCode;
    private GopherUrl url;
    private ArrayList<GopherItem> itemList;
    private GopherItem.GopherItemType contentType = GopherItem.GopherItemType.UNKNOWN;

    public GopherPage(byte[] gopherPageSourceCode, GopherItem.GopherItemType gopherContentType, GopherUrl gopherPageUrl) {
        this.sourceCode = gopherPageSourceCode;
        this.url = gopherPageUrl;
        this.itemList = new ArrayList();
        if (gopherContentType == GopherItem.GopherItemType.GOPHERMENU || gopherContentType == GopherItem.GopherItemType.UNKNOWN) {
            try {
                this.parse();
                this.contentType = GopherItem.GopherItemType.GOPHERMENU;
            }
            catch (Exception ex) {
                System.out.println("Failed to parse gophermenu: " + ex.getMessage());
                ex.printStackTrace();
                this.contentType = GopherItem.GopherItemType.TEXTFILE;
            }
        } else {
            this.contentType = gopherContentType;
        }
    }

    public GopherItem.GopherItemType getContentType() {
        return this.contentType;
    }

    public String getBase64() {
        return Base64.getEncoder().encodeToString(this.sourceCode);
    }

    public byte[] getByteArray() {
        return this.sourceCode;
    }

    public void setSourceCode(byte[] value) {
        this.sourceCode = value;
    }

    public String getSourceCode() {
        try {
            return new String(this.sourceCode, ConfigurationManager.getConfigFile().getSetting("DEFAULT_CHARSET", "Network", GOPHERPAGE_DEFAULT_CHARSET));
        }
        catch (Exception ex) {
            System.out.println("Failed to decode bytes of Gopher Page: " + ex.getMessage());
            return "";
        }
    }

    public GopherUrl getUrl() {
        return this.url;
    }

    public ArrayList<GopherItem> getItemList() {
        return this.itemList;
    }

    public String getTextContent() {
        String result = "";
        if (this.itemList.size() > 0) {
            for (GopherItem item : this.itemList) {
                result = result + item.getUserDisplayString() + "\n";
            }
        } else {
            return this.getSourceCode().replace("\r\n.\r\n", "");
        }
        return result;
    }

    public Boolean saveAsFile(String fileName) {
        Boolean result = false;
        try {
            FileOutputStream fileOutput = new FileOutputStream(fileName);
            fileOutput.write(this.getByteArray());
            fileOutput.close();
            result = true;
        }
        catch (Exception ex) {
            System.out.println("Failed to save page as file: " + ex.getMessage());
            result = false;
        }
        return result;
    }

    public String getFileName() {
        String result = this.getUrl().getUrlString();
        result = result.lastIndexOf("/") > 0 ? result.substring(result.lastIndexOf("/") + 1) : "index";
        if (result.lastIndexOf(".") == -1) {
            result = result + "." + GopherItem.getDefaultFileExt(this.getContentType());
        }
        return result;
    }

    private void parse() {
        String[] itemSourceList = this.getSourceCode().split("\n");
        for (int i = 0; i < itemSourceList.length; ++i) {
            String itemSource = itemSourceList[i];
            if (itemSource.length() <= 0 || itemSource.equals(".")) continue;
            this.itemList.add(new GopherItem(itemSource));
        }
    }
}

