/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.net;

import org.gophie.net.GopherUrl;

public class GopherItem {
    private GopherItemType itemType = GopherItemType.UNKNOWN;
    private String itemTypeCode = "?";
    private String userDisplayString = "";
    private String selector = "";
    private String hostName = "";
    private int portNumber = 70;

    public GopherItem(String line) {
        this.setItemTypeByCode(line.substring(0, 1));
        String[] property = line.replace("\r", "").replace("\n", "").split("\t");
        if (property.length > 0 && property[0].length() > 1) {
            this.userDisplayString = property[0].substring(1);
        }
        if (property.length > 1) {
            this.selector = property[1].trim();
        }
        if (property.length > 2) {
            this.hostName = property[2].trim();
        }
        if (property.length > 3) {
            try {
                this.portNumber = Integer.parseInt(property[3].trim());
            }
            catch (Exception ex) {
                System.out.println("Found what was supposed to be a port number and it did not parse into an integer: " + ex.getMessage());
            }
        }
    }

    public GopherItem(GopherItemType type, GopherUrl url) {
        this.itemType = type;
        this.hostName = url.getHost();
        this.portNumber = url.getPort();
        this.selector = url.getSelector();
        this.userDisplayString = this.getFileName();
    }

    public GopherItem(String itemTypeCode, GopherUrl url) {
        this.setItemTypeByCode(itemTypeCode);
        this.hostName = url.getHost();
        this.portNumber = url.getPort();
        this.selector = url.getSelector();
        this.userDisplayString = this.getFileName();
    }

    public GopherItem() {
    }

    public GopherItemType getItemType() {
        return this.itemType;
    }

    public String getItemTypeCode() {
        return this.itemTypeCode;
    }

    public String getUserDisplayString() {
        return this.userDisplayString;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getUrlString() {
        String result = "";
        if (this.itemType != GopherItemType.UNKNOWN && this.itemType != GopherItemType.INFORMATION) {
            if (this.selector.startsWith("URL:") || this.selector.startsWith("/URL:")) {
                result = this.selector.startsWith("/URL:") ? this.selector.substring(5) : this.selector.substring(4);
            } else {
                result = "gopher://" + this.hostName;
                if (this.portNumber != 70) {
                    result = result + ":" + this.portNumber;
                }
                if (!this.selector.startsWith("/")) {
                    result = result + "/";
                }
                result = result + this.selector;
            }
        }
        return result;
    }

    public String getFileName() {
        String result = this.getUrlString();
        if (result.lastIndexOf("/") > 0) {
            result = result.substring(result.lastIndexOf("/") + 1);
        }
        return result;
    }

    public String getFileNameWithForcedExt() {
        String result = this.getFileName();
        if (result.lastIndexOf(".") == -1) {
            result = result + "." + GopherItem.getDefaultFileExt(this.getItemType());
        }
        return result;
    }

    public String getFileExt() {
        String result = "txt";
        String fileName = this.getFileName();
        if (fileName.lastIndexOf(".") > 0) {
            result = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return result;
    }

    public Boolean isBinaryFile() {
        Boolean result = false;
        if (this.itemType == GopherItemType.BINHEX_FILE || this.itemType == GopherItemType.DOS_FILE || this.itemType == GopherItemType.UUENCODED_FILE || this.itemType == GopherItemType.BINARY_FILE || this.itemType == GopherItemType.SOUND_FILE) {
            result = true;
        }
        return result;
    }

    public static String getDefaultFileExt(GopherItemType itemType) {
        String result = "dat";
        if (itemType == GopherItemType.TEXTFILE) {
            result = "txt";
        }
        if (itemType == GopherItemType.GOPHERMENU) {
            result = "gophermap";
        }
        if (itemType == GopherItemType.CCSCO_NAMESERVER) {
            result = "ccso";
        }
        if (itemType == GopherItemType.ERRORCODE) {
            result = "error";
        }
        if (itemType == GopherItemType.BINHEX_FILE) {
            result = "hqx";
        }
        if (itemType == GopherItemType.DOS_FILE) {
            result = "dat";
        }
        if (itemType == GopherItemType.UUENCODED_FILE) {
            result = "uue";
        }
        if (itemType == GopherItemType.FULLTEXT_SEARCH) {
            result = "txt";
        }
        if (itemType == GopherItemType.TELNET) {
            result = "txt";
        }
        if (itemType == GopherItemType.BINARY_FILE) {
            result = "dat";
        }
        if (itemType == GopherItemType.MIRROR) {
            result = "txt";
        }
        if (itemType == GopherItemType.GIF_FILE) {
            result = "gif";
        }
        if (itemType == GopherItemType.IMAGE_FILE) {
            result = "jpg";
        }
        if (itemType == GopherItemType.TELNET3270) {
            result = "txt";
        }
        if (itemType == GopherItemType.HTML_FILE) {
            result = "htm";
        }
        if (itemType == GopherItemType.INFORMATION) {
            result = "txt";
        }
        if (itemType == GopherItemType.SOUND_FILE) {
            result = "wav";
        }
        return result;
    }

    public String getTypeName() {
        String result = "Unknown";
        if (this.getItemType() == GopherItemType.TEXTFILE) {
            result = "Text file";
        }
        if (this.getItemType() == GopherItemType.GOPHERMENU) {
            result = "Gopher menu";
        }
        if (this.getItemType() == GopherItemType.CCSCO_NAMESERVER) {
            result = "CCSO Nameserver";
        }
        if (this.getItemType() == GopherItemType.ERRORCODE) {
            result = "Error code";
        }
        if (this.getItemType() == GopherItemType.BINHEX_FILE) {
            result = "BinHex file (Macintosh)";
        }
        if (this.getItemType() == GopherItemType.DOS_FILE) {
            result = "DOS file";
        }
        if (this.getItemType() == GopherItemType.UUENCODED_FILE) {
            result = "uuencoded file";
        }
        if (this.getItemType() == GopherItemType.FULLTEXT_SEARCH) {
            result = "Full-text search";
        }
        if (this.getItemType() == GopherItemType.TELNET) {
            result = "Telnet";
        }
        if (this.getItemType() == GopherItemType.BINARY_FILE) {
            result = "Binary file";
        }
        if (this.getItemType() == GopherItemType.MIRROR) {
            result = "Mirror";
        }
        if (this.getItemType() == GopherItemType.GIF_FILE) {
            result = "GIF file";
        }
        if (this.getItemType() == GopherItemType.IMAGE_FILE) {
            result = "Image file";
        }
        if (this.getItemType() == GopherItemType.TELNET3270) {
            result = "Telnet 3270";
        }
        if (this.getItemType() == GopherItemType.HTML_FILE) {
            result = "HTML file";
        }
        if (this.getItemType() == GopherItemType.INFORMATION) {
            result = "Information";
        }
        if (this.getItemType() == GopherItemType.SOUND_FILE) {
            result = "Sound file";
        }
        return result;
    }

    public static String getTypeCode(GopherItemType itemType) {
        String result = "?";
        if (itemType == GopherItemType.TEXTFILE) {
            result = "0";
        }
        if (itemType == GopherItemType.GOPHERMENU) {
            result = "1";
        }
        if (itemType == GopherItemType.CCSCO_NAMESERVER) {
            result = "2";
        }
        if (itemType == GopherItemType.ERRORCODE) {
            result = "3";
        }
        if (itemType == GopherItemType.BINHEX_FILE) {
            result = "4";
        }
        if (itemType == GopherItemType.DOS_FILE) {
            result = "5";
        }
        if (itemType == GopherItemType.UUENCODED_FILE) {
            result = "6";
        }
        if (itemType == GopherItemType.FULLTEXT_SEARCH) {
            result = "7";
        }
        if (itemType == GopherItemType.TELNET) {
            result = "8";
        }
        if (itemType == GopherItemType.BINARY_FILE) {
            result = "9";
        }
        if (itemType == GopherItemType.MIRROR) {
            result = "+";
        }
        if (itemType == GopherItemType.GIF_FILE) {
            result = "g";
        }
        if (itemType == GopherItemType.IMAGE_FILE) {
            result = "I";
        }
        if (itemType == GopherItemType.TELNET3270) {
            result = "T";
        }
        if (itemType == GopherItemType.HTML_FILE) {
            result = "h";
        }
        if (itemType == GopherItemType.INFORMATION) {
            result = "i";
        }
        if (itemType == GopherItemType.SOUND_FILE) {
            result = "s";
        }
        return result;
    }

    private GopherItemType getItemTypeByCode(String code) {
        GopherItemType result = GopherItemType.UNKNOWN;
        if (code.equals("0")) {
            result = GopherItemType.TEXTFILE;
        }
        if (code.equals("1")) {
            result = GopherItemType.GOPHERMENU;
        }
        if (code.equals("2")) {
            result = GopherItemType.CCSCO_NAMESERVER;
        }
        if (code.equals("3")) {
            result = GopherItemType.ERRORCODE;
        }
        if (code.equals("4")) {
            result = GopherItemType.BINHEX_FILE;
        }
        if (code.equals("5")) {
            result = GopherItemType.DOS_FILE;
        }
        if (code.equals("6")) {
            result = GopherItemType.UUENCODED_FILE;
        }
        if (code.equals("7")) {
            result = GopherItemType.FULLTEXT_SEARCH;
        }
        if (code.equals("8")) {
            result = GopherItemType.TELNET;
        }
        if (code.equals("9")) {
            result = GopherItemType.BINARY_FILE;
        }
        if (code.equals("+")) {
            result = GopherItemType.MIRROR;
        }
        if (code.equals("g")) {
            result = GopherItemType.GIF_FILE;
        }
        if (code.equals("I")) {
            result = GopherItemType.IMAGE_FILE;
        }
        if (code.equals("T")) {
            result = GopherItemType.TELNET3270;
        }
        if (code.equals("h")) {
            result = GopherItemType.HTML_FILE;
        }
        if (code.equals("i")) {
            result = GopherItemType.INFORMATION;
        }
        if (code.equals("s")) {
            result = GopherItemType.SOUND_FILE;
        }
        if (code.equals("?")) {
            result = GopherItemType.UNKNOWN;
        }
        return result;
    }

    private void setItemTypeByCode(String code) {
        this.itemTypeCode = code;
        this.itemType = this.getItemTypeByCode(code);
    }

    public static enum GopherItemType {
        TEXTFILE,
        GOPHERMENU,
        CCSCO_NAMESERVER,
        ERRORCODE,
        BINHEX_FILE,
        DOS_FILE,
        UUENCODED_FILE,
        FULLTEXT_SEARCH,
        TELNET,
        BINARY_FILE,
        MIRROR,
        GIF_FILE,
        IMAGE_FILE,
        TELNET3270,
        HTML_FILE,
        INFORMATION,
        SOUND_FILE,
        UNKNOWN;

    }
}

