/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.net;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.gophie.io.FileSignature;
import org.gophie.net.GopherItem;
import org.gophie.net.GopherItemTypeException;
import org.gophie.net.GopherNetworkException;
import org.gophie.net.GopherPage;
import org.gophie.net.GopherUrl;
import org.gophie.net.event.GopherClientEventListener;
import org.gophie.net.event.GopherError;

public class GopherClient {
    private Thread thread;
    private Boolean cancelled = false;

    public void cancelFetch() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.cancelled = true;
        }
    }

    public Boolean isCancelled() {
        return this.cancelled;
    }

    public void downloadAsync(final String url, final String targetFile, final GopherClientEventListener eventListener) {
        final GopherClient clientObject = this;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        int read;
                        FileOutputStream fileStream = new FileOutputStream(new File(targetFile));
                        GopherUrl gopherUrl = new GopherUrl(url);
                        Socket gopherSocket = new Socket(gopherUrl.getHost(), gopherUrl.getPort());
                        byte[] gopherRequest = (gopherUrl.getSelector() + "\r\n").getBytes(StandardCharsets.US_ASCII);
                        new DataOutputStream(gopherSocket.getOutputStream()).write(gopherRequest);
                        InputStream socketStream = gopherSocket.getInputStream();
                        byte[] data = new byte[16384];
                        long totalByteCount = 0L;
                        while ((read = socketStream.read(data, 0, data.length)) != -1) {
                            ((OutputStream)fileStream).write(data, 0, read);
                            totalByteCount += (long)data.length;
                            if (clientObject.isCancelled().booleanValue() || eventListener == null) continue;
                            eventListener.progress(gopherUrl, totalByteCount);
                        }
                        gopherSocket.close();
                        ((OutputStream)fileStream).close();
                        if (!clientObject.isCancelled().booleanValue() && eventListener != null) {
                            eventListener.pageLoaded(null);
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Download failed (" + url + "):" + ex.getMessage());
                        File createdFile = new File(targetFile);
                        if (createdFile.exists()) {
                            createdFile.delete();
                        }
                        if (clientObject.isCancelled().booleanValue() || eventListener == null) break block5;
                        eventListener.pageLoadFailed(GopherError.EXCEPTION, new GopherUrl(url));
                    }
                }
            }
        });
        this.thread.start();
    }

    public void fetchAsync(final String url, final GopherItem.GopherItemType contentType, final GopherClientEventListener eventListener) {
        final GopherClient clientObject = this;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        GopherPage resultPage = GopherClient.this.fetch(url, contentType, eventListener);
                        if (!clientObject.isCancelled().booleanValue() && eventListener != null) {
                            eventListener.pageLoaded(resultPage);
                        }
                    }
                    catch (GopherNetworkException ex) {
                        if (!clientObject.isCancelled().booleanValue() && eventListener != null) {
                            eventListener.pageLoadFailed(ex.getGopherErrorType(), new GopherUrl(url));
                        }
                    }
                    catch (GopherItemTypeException ex) {
                        if (clientObject.isCancelled().booleanValue() || eventListener == null) break block5;
                        eventListener.pageLoadItemMismatch(ex.getRequestedType(), ex.getDetectedType(), new GopherUrl(url));
                    }
                }
            }
        });
        this.thread.start();
    }

    public GopherPage fetch(String url, GopherItem.GopherItemType contentType, GopherClientEventListener eventListener) throws GopherNetworkException, GopherItemTypeException {
        GopherPage result = null;
        try {
            int read;
            this.cancelled = false;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            GopherUrl gopherUrl = new GopherUrl(url);
            Socket gopherSocket = new Socket(gopherUrl.getHost(), gopherUrl.getPort());
            byte[] gopherRequest = (gopherUrl.getSelector() + "\r\n").getBytes(StandardCharsets.US_ASCII);
            new DataOutputStream(gopherSocket.getOutputStream()).write(gopherRequest);
            InputStream socketStream = gopherSocket.getInputStream();
            byte[] data = new byte[16384];
            long totalByteCount = 0L;
            while ((read = socketStream.read(data, 0, data.length)) != -1) {
                FileSignature largeSignature;
                FileSignature.FileSignatureType largeType;
                if (totalByteCount == 0L) {
                    FileSignature fileSignature = new FileSignature(data);
                    FileSignature.FileSignatureType fileType = fileSignature.getSignatureItemType();
                    if (fileType == FileSignature.FileSignatureType.IMAGE && (contentType != GopherItem.GopherItemType.IMAGE_FILE || contentType != GopherItem.GopherItemType.GIF_FILE)) {
                        contentType = GopherItem.GopherItemType.IMAGE_FILE;
                    }
                    if (fileType == FileSignature.FileSignatureType.MEDIA) {
                        throw new GopherItemTypeException(url, contentType, GopherItem.GopherItemType.SOUND_FILE);
                    }
                    if (fileType == FileSignature.FileSignatureType.BINARY) {
                        throw new GopherItemTypeException(url, contentType, GopherItem.GopherItemType.BINARY_FILE);
                    }
                }
                if ((contentType == GopherItem.GopherItemType.GOPHERMENU || contentType == GopherItem.GopherItemType.TEXTFILE || contentType == GopherItem.GopherItemType.UNKNOWN) && totalByteCount > 200000L && (largeType = (largeSignature = new FileSignature(data)).getSignatureItemType()) != FileSignature.FileSignatureType.TEXT) {
                    throw new GopherItemTypeException(url, contentType, GopherItem.GopherItemType.BINARY_FILE);
                }
                buffer.write(data, 0, read);
                totalByteCount += (long)data.length;
                if (this.isCancelled().booleanValue() || eventListener == null) continue;
                eventListener.progress(gopherUrl, totalByteCount);
            }
            gopherSocket.close();
            result = new GopherPage(buffer.toByteArray(), contentType, gopherUrl);
        }
        catch (ConnectException ex) {
            throw new GopherNetworkException(GopherError.CONNECT_FAILED, ex.getMessage());
        }
        catch (UnknownHostException ex) {
            throw new GopherNetworkException(GopherError.HOST_UNKNOWN, ex.getMessage());
        }
        catch (SocketTimeoutException ex) {
            throw new GopherNetworkException(GopherError.CONNECTION_TIMEOUT, ex.getMessage());
        }
        catch (GopherItemTypeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            System.out.println("GOPHER NETWORK EXCEPTION: " + ex.getMessage());
            throw new GopherNetworkException(GopherError.EXCEPTION, ex.getMessage());
        }
        return result;
    }
}

