/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.net;

import java.util.ArrayList;
import org.gophie.net.DownloadItem;
import org.gophie.net.event.DownloadItemEventListener;
import org.gophie.net.event.DownloadListEventListener;

public class DownloadList
extends ArrayList<DownloadItem>
implements DownloadItemEventListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<DownloadListEventListener> eventListener = new ArrayList();

    public DownloadItem[] getDownloadItemArray() {
        DownloadItem[] result = new DownloadItem[this.size()];
        for (int i = this.size() - 1; i >= 0; --i) {
            result[this.size() - 1 - i] = (DownloadItem)this.get(i);
        }
        return result;
    }

    public Boolean hasNonActiveItems() {
        Boolean result = false;
        for (DownloadItem item : this) {
            if (item.getStatus() == DownloadItem.DownloadStatus.ACTIVE) continue;
            result = true;
        }
        return result;
    }

    public void clearNonActiveItems() {
        DownloadList currentList = this;
        this.clear();
        for (DownloadItem item : currentList) {
            if (item.getStatus() != DownloadItem.DownloadStatus.ACTIVE) continue;
            this.add(item);
        }
        this.notifyUpdate();
    }

    public void addEventListener(DownloadListEventListener listener) {
        this.eventListener.add(listener);
    }

    private void notifyUpdate() {
        for (DownloadListEventListener listener : this.eventListener) {
            listener.downloadListUpdated();
        }
    }

    @Override
    public boolean add(DownloadItem e) {
        boolean result = super.add(e);
        e.addEventListener(this);
        this.notifyUpdate();
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.notifyUpdate();
    }

    @Override
    public void downloadProgressReported() {
        for (DownloadListEventListener listener : this.eventListener) {
            listener.downloadProgressReported();
        }
    }
}

