/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.net;

import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import org.gophie.net.GopherClient;
import org.gophie.net.GopherItem;
import org.gophie.net.GopherPage;
import org.gophie.net.GopherUrl;
import org.gophie.net.event.DownloadItemEventListener;
import org.gophie.net.event.GopherClientEventListener;
import org.gophie.net.event.GopherError;

public class DownloadItem
implements GopherClientEventListener {
    private GopherItem item;
    private GopherClient client;
    private String fileName;
    private Boolean openFile = false;
    private long byteCountLoaded = 0L;
    private DownloadStatus status = DownloadStatus.IDLE;
    private ArrayList<DownloadItemEventListener> eventListenerList = new ArrayList();
    private long startTimeMillis = 0L;
    private long bytePerSecond = 0L;

    public DownloadItem(GopherItem gopherItem, String targetFile, Boolean openWhenFinished) {
        this.client = new GopherClient();
        this.item = gopherItem;
        this.fileName = targetFile;
        this.openFile = openWhenFinished;
        this.start();
    }

    public void addEventListener(DownloadItemEventListener listener) {
        this.eventListenerList.add(listener);
    }

    private void notifyProgress() {
        for (DownloadItemEventListener listener : this.eventListenerList) {
            listener.downloadProgressReported();
        }
    }

    public DownloadItem() {
        this.client = new GopherClient();
        this.status = DownloadStatus.IDLE;
    }

    public void start() {
        String url = new GopherUrl(this.item.getUrlString()).getUrlString();
        this.client.downloadAsync(url, this.fileName, this);
        this.status = DownloadStatus.ACTIVE;
    }

    public void deleteFile() {
        try {
            File file = new File(this.fileName);
            file.delete();
        }
        catch (Exception ex) {
            System.out.println("Failed to delete downloaded file (" + this.fileName + "): " + ex.getMessage());
        }
    }

    public void cancel() {
        this.client.cancelFetch();
    }

    public void setTargetFile(String targetFile) {
        this.fileName = targetFile;
    }

    public void setGopherItem(GopherItem gopherItem) {
        this.item = gopherItem;
    }

    public GopherItem getGopherItem() {
        return this.item;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public long getByteCountLoaded() {
        return this.byteCountLoaded;
    }

    public long getBytePerSecond() {
        return this.bytePerSecond;
    }

    public void openFileOnDesktop() {
        try {
            if (!Desktop.isDesktopSupported()) {
                throw new Exception("Desktop not supported");
            }
            Desktop.getDesktop().open(new File(this.fileName));
        }
        catch (Exception ex) {
            System.out.println("Unable to open file after download (" + this.fileName + "):" + ex.getMessage());
        }
    }

    @Override
    public void progress(GopherUrl url, long byteCount) {
        long timeNow;
        long duration;
        if (this.startTimeMillis == 0L) {
            this.startTimeMillis = System.currentTimeMillis();
        }
        if ((duration = ((timeNow = System.currentTimeMillis()) - this.startTimeMillis) / 1000L) > 0L && byteCount > 0L) {
            this.bytePerSecond = byteCount / duration;
        }
        this.byteCountLoaded = byteCount;
        this.notifyProgress();
    }

    @Override
    public void pageLoaded(GopherPage result) {
        this.status = DownloadStatus.COMPLETED;
        if (this.openFile.booleanValue()) {
            this.openFileOnDesktop();
        }
        this.notifyProgress();
    }

    @Override
    public void pageLoadFailed(GopherError error, GopherUrl url) {
        this.status = DownloadStatus.FAILED;
        this.notifyProgress();
    }

    @Override
    public void pageLoadItemMismatch(GopherItem.GopherItemType requested, GopherItem.GopherItemType detected, GopherUrl url) {
    }

    public static enum DownloadStatus {
        IDLE,
        FAILED,
        ACTIVE,
        COMPLETED;

    }
}

