/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.io;

public class FileSignature {
    private static final char[] HEX_VALUE = "0123456789ABCDEF".toCharArray();
    private static final String[] IMAGE_SIGNATURE_LIST = new String[]{"47494638", "FFD8FF", "0000000C6A502020", "89504E470D0A1A0A", "424D", "00000100", "492049", "49492A00", "4D4D002A", "4D4D002B"};
    private static final String[] MEDIA_SIGNATURE_LIST = new String[]{"464F524D", "4F676753", "494433", "FFFA", "FFFB", "FFF3", "FFF2", "52494646", "4D546864", "664C6143", "1A45DFA3", "000001BA", "000001B3", "3026B2758E66CF11", "A6D900AA0062CE6C"};
    private static final String[] BINARY_SIGNATURE_LIST = new String[]{"526172211A07", "504B0304", "504B0506", "504B0708", "504B4C495445", "504B537058", "504B0506", "504B0708", "57696E5A6970", "504B030414000100", "377ABCAF271C", "FD377A585A00", "04224D18", "4D534346", "535A444488F02733", "28546869", "7573746172003030", "7573746172202000", "1F8B", "7801730D626260", "5349542100", "5374756666497420", "4C00000001140200"};
    private byte[] content;

    public FileSignature(byte[] fileContent) {
        this.content = fileContent;
    }

    private boolean hasSignature(String[] list, String hex) {
        boolean result = false;
        for (int i = 0; i < list.length; ++i) {
            String signature = list[i];
            if (!hex.substring(0, signature.length()).equals(signature)) continue;
            result = true;
        }
        return result;
    }

    public FileSignatureType getSignatureItemType() {
        FileSignatureType result = FileSignatureType.UNKNOWN;
        String fileHex = this.getContentHexString();
        if (this.isTextContent()) {
            result = FileSignatureType.TEXT;
        }
        if (this.hasSignature(IMAGE_SIGNATURE_LIST, fileHex)) {
            result = FileSignatureType.IMAGE;
        }
        if (this.hasSignature(MEDIA_SIGNATURE_LIST, fileHex)) {
            result = FileSignatureType.MEDIA;
        }
        if (this.hasSignature(BINARY_SIGNATURE_LIST, fileHex)) {
            result = FileSignatureType.BINARY;
        }
        if (fileHex.substring(8, 16).equals("66747970")) {
            result = FileSignatureType.MEDIA;
        }
        return result;
    }

    private boolean isTextContent() {
        boolean result = false;
        String fileHex = this.getContentHexString();
        double alphaNumCharCount = 0.0;
        double totalCharCount = 0.0;
        for (int c = 0; c < fileHex.length(); c += 2) {
            int charCode = Integer.parseInt(fileHex.substring(c, c + 2), 16);
            if (charCode == 0) continue;
            if (charCode >= 65 && charCode <= 90 || charCode >= 97 && charCode <= 122) {
                alphaNumCharCount += 1.0;
            }
            totalCharCount += 1.0;
        }
        double percent = alphaNumCharCount / totalCharCount * 100.0;
        if (percent >= 20.0) {
            result = true;
        }
        return result;
    }

    private String getContentHexString() {
        char[] hexChars = new char[this.content.length * 2];
        for (int j = 0; j < this.content.length; ++j) {
            int v = this.content[j] & 0xFF;
            hexChars[j * 2] = HEX_VALUE[v >>> 4];
            hexChars[j * 2 + 1] = HEX_VALUE[v & 0xF];
        }
        return new String(hexChars);
    }

    public static enum FileSignatureType {
        UNKNOWN,
        BINARY,
        IMAGE,
        MEDIA,
        TEXT;

    }
}

