/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.config;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.gophie.config.ConfigFile;

public class ConfigurationManager {
    private static ConfigFile configFile;
    private static final String MAIN_CONFIG_FILENAME = "config.ini";
    private static final String CONFIG_FOLDERNAME = "Gophie";

    public static ConfigFile getConfigFile() {
        if (configFile == null) {
            String configFileName = ConfigurationManager.getConfigPath() + MAIN_CONFIG_FILENAME;
            configFile = new ConfigFile(configFileName);
        }
        return configFile;
    }

    public static String getConfigPath() {
        String result = System.getProperty("user.home") + "/" + CONFIG_FOLDERNAME + "/";
        File mainConfigFile = new File(result + MAIN_CONFIG_FILENAME);
        mainConfigFile.getParentFile().mkdirs();
        return result;
    }

    public static Font getFont(String fileName, float size) {
        Font result = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            result = Font.createFont(0, classLoader.getResourceAsStream("res/" + fileName)).deriveFont(size);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            graphicsEnvironment.registerFont(result);
        }
        catch (Exception ex) {
            System.out.println("Unable to load font: " + ex.getMessage());
        }
        return result;
    }

    public static Font getIconFont(float size) {
        return ConfigurationManager.getFont("Feather.ttf", size);
    }

    public static Image getImage(String name) {
        BufferedImage result = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            result = ImageIO.read(classLoader.getResource("res/" + name));
        }
        catch (Exception ex) {
            System.out.println("Unable to load the image icon (" + name + "): " + ex.getMessage());
        }
        return result;
    }

    public static ImageIcon getImageIcon(String name) {
        ImageIcon result = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            result = new ImageIcon(classLoader.getResource("res/" + name));
        }
        catch (Exception ex) {
            System.out.println("Unable to load the image icon (" + name + "): " + ex.getMessage());
        }
        return result;
    }

    public static Font getConsoleFont(float size) {
        String fontName = ConfigurationManager.getConfigFile().getSetting("PAGE_FONT", "Appearance", "");
        Font result = fontName.isEmpty() ? ConfigurationManager.getFont("Inconsolata-Regular.ttf", size) : new Font(fontName, 0, (int)size);
        return result;
    }

    public static float getConsoleFontSize(float defaultSize) {
        float result = defaultSize;
        String fontSize = ConfigurationManager.getConfigFile().getSetting("PAGE_FONT_SIZE", "Appearance", "");
        if (!fontSize.isEmpty()) {
            result = Integer.parseInt(fontSize);
        }
        return result;
    }

    public static Font getDefaultFont(float size) {
        return ConfigurationManager.getFont("OpenSans-Regular.ttf", size);
    }

    public static String getDownloadPath() {
        return System.getProperty("user.home") + "/Downloads/";
    }
}

