/*
 * Decompiled with CFR 0.152.
 */
package org.gophie.config;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFile {
    private String fileName = "";
    HashMap<String, HashMap<String, String>> config = new HashMap();

    public ConfigFile(String configFileName) {
        this.fileName = configFileName;
        this.parse();
    }

    public String getSetting(String name, String section, String defaultValue) {
        String result = defaultValue;
        if (this.config.containsKey(section) && this.config.get(section).containsKey(name)) {
            result = this.config.get(section).get(name);
        }
        return result;
    }

    public void setSetting(String name, String value, String section) {
        if (section.length() > 0 && name.length() > 0 && value.length() > 0) {
            HashMap<String, String> settingMap = new HashMap<String, String>();
            if (this.config.containsKey(section)) {
                settingMap = this.config.get(section);
            }
            settingMap.put(name, value);
            this.config.put(section, settingMap);
        }
    }

    private String getTextContent() {
        String result = "";
        for (Map.Entry<String, HashMap<String, String>> pair : this.config.entrySet()) {
            if (result.length() > 0) {
                result = result + "\n";
            }
            result = result + "[" + pair.getKey() + "]\n";
            for (Map.Entry<String, String> settingEntry : pair.getValue().entrySet()) {
                result = result + settingEntry.getKey() + " = " + settingEntry.getValue() + "\n";
            }
        }
        return result;
    }

    public void save() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName));
            writer.write(this.getTextContent());
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("Failed to write config file: " + ex.getMessage());
        }
    }

    private void parse() {
        try {
            if (Files.exists(Paths.get(this.fileName, new String[0]), new LinkOption[0])) {
                List<String> lineList = Files.readAllLines(Paths.get(this.fileName, new String[0]), Charset.defaultCharset());
                String configSection = "NONE";
                for (String line : lineList) {
                    String[] setting;
                    String value = line.trim();
                    if (value.length() <= 0 || value.startsWith(";")) continue;
                    if (value.startsWith("[") && value.endsWith("]")) {
                        configSection = value.substring(1, value.length() - 1);
                    }
                    if (value.indexOf("=") <= 0 || (setting = value.split("=")).length != 2) continue;
                    this.setSetting(setting[0].trim(), setting[1].trim(), configSection);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to open and parse file (" + this.fileName + "): " + ex.getMessage());
        }
    }
}

