# MLB Pitch Identification with ML

[![Streamlit App](https://static.streamlit.io/badges/streamlit_badge_black_white.svg)](https://mlbpitch.streamlit.app/)

This project demonstrates one of the many uses of machine learning in baseball by creating a machine learning model capable of identifying which pitch is being thrown when given the pitcher, velocity, and movement of the pitch.

Data used is taken from [Baseball Savant](https://baseballsavant.mlb.com/).


## ML Model Notebook

The notebook file walks through the creation of both a general and pitcher-specific machine learning model, as well as an analysis of the accuracy of both models. 


## Pitch Identifier Web App

The machine learning model can be interacted with via a Streamlit web app dashboard. A user can select either the general or pitcher-specific model and by entering the pitcher (*pitcher-specific model only*), pitch velocity and movement, the model will identify and display what pitch was thrown.

Check out the web app [here](https://mlbpitch.streamlit.app/).

### General Model Demo

https://user-images.githubusercontent.com/91490989/205511262-e50e6291-2a96-43ad-b4ef-f94e1a167953.mp4

### Pitcher-Specific Model Demo

https://user-images.githubusercontent.com/91490989/205511301-85220674-341a-4059-928e-557e0f3edc5e.mp4
