/******************************************************************
 *  userinit()
 * 
 * userinit() allows you to customer to customize the Web page based on CMS user types, or specify a custom Web page.
 * 
 * This function is called by navtree init function and should contain or call other functions with all user modified variables and user functions to specify datapoints for for a given device, one or more device types, or program Id.
 * 
 * The navtree can be used to dynmaically show a navigation tree for the devices, and its datapoints, in the SmartServer IoT.  If you assign context to devices (e.g., room or area)
 * the navtree tree will show the contexts and where the device is assigned. Note, a device can be assigned to more than one context.  
 * 
 * When you click a device the default setup is to show all datapoints that have visible selected in the Datapoint Properties Widget.
 * navtree will dynamically create a dashboard and based on datapoint will show switches, charts, dropdown or input and span fields.
 * 
 * You can 
 *   
 * The userinit() allows you to define the navtree defaults and can be used to limit which datapoints are visible based on CMS user types. The default
 * settings is to show all datapoints with a visible flag selected in the datapoint Properties Widget. You can limit  
 * 
 * The CMS has three different user-types:
 *      OWNER, 
 *      SUPERVISOR
 *      USER. 
 * You can specify which datapoints user's can see based on their CMS user-type.
 * 
 * You can also define which writable datapoints ("inputs") are read only based on the CMS user-type. 
 * 
 *  
 *  If no device name, device type or program ID is specified then the dashboard shows all the datapoints for the specific device types.
 *  Replacement Device types can be specified by Device Name, Device Type Name, or by program ID.  
 *     - If using Device Name the you can specify more than one device device for each program ID.
 *     - If using Device Type Name the you can specify more than one device type for each program ID.
 *     - Only one program entry can be specified for a given.
 * 
 *  Order of checking
 *  1. Checks if replacement Web page. Replacement Web page is implemented in iframe and requires width and height specification 
 *  2. Checks if replacement datapoints or image, but uses built-in dashboard generation
 *  3. If no replacement Web page or datapoints then shows all datapoints for device using built-in dashboard generation
 * 
 *  To limit which datapoints are shown in dashboard:
 *  1. Filters datapoint based on datapoint Visible flag in Datapoint Properties Widget
 *      - Visibility filter is used for REST API GET request 
 *      - use "g_useVisibilityFilter = <user type Visibility mask>" to specify when visibility filter is used.
 *      - <user type Visibility mask> = NONE then visibility filter is never used
 *      - <user type Visibility mask> = ALL  means visibility filter is used for each user-type
 *      - All other <user type Visibility mask> values specify which user-type use visibility filter
 *  2. List the datapoints per device type using one of the device name, device type or program ID functions below
 *      - if you specify a list of datapoints then only those datapoints are shown.
 *      - First Visibility filter is applied and then the function visibility selection is applied.
 * 
 *  The following is supported:
 *  1. Use default datapoints in dashboard (show all device's datapoints)
 *      a. used for all devices unless replacement Web page, or replacement datapoints/image specified
 *    
 *  2. Add device image only to dashboard
 *      a. For SmartServer 
 *           addSmartServerImage("images/smartserver.png",250, null); // For segment controller
 *      b. For device type
 *          Format: 
 *              addDeviceTypeReplacementProgramId(programId, allVersions, url, width, height)
 *                  or
 *              addDeviceTypeReplacement(deviceType, url, width, height)
 *          Example:
 *              addDeviceTypeDpList("SC100-MP", null, "images/sc100.png",300, null); // add only image
 *  3. Add device image and Select datapoints for each device type to dashboard
 *  4. Use own custom Web page, Uses iframe and need to specify iframe width and height (in px)
 *      Example:
 *          addDeviceTypeWebPage("PulseGen", "../deviceconfig/pulsegenchart.html", 1400, 800);
 *          addProgramIdWebPage("900001153C000405", false, "../deviceconfig/pulsegenchart.html", 1400, 800);
 *      Requires: custom web page to support, ?tree=true&device=<device name>
 *          a. "tree=true" is used to remove the logout button from the custom Web page, otherwise you will see two logout buttons
 *          b.  "device=<device name>" is used to specify device being accessed
 * 
 *  Built-in functions used by this file are defined in devicetypes.js
 *  addDpObjAll(blockPath, displayElementType, userVisibility, userReadtonly, normalUserWritePriority,normalUserClearPriority)
 *      sid = SmartServer "Segment ID" or Install code
 * 
 *
 *   // User-type CONSTANTs - Most be all CAPS 
 *          - used for <user type Visibility mask>
 *              - can equal null, "NONE", "ALL" or combination of adding OWNER, SUPERVISOR and/or USER
 *          - used to determine which user-types are supported for addDpObjAll() visibility and readonly paramters
 *          
 *      ALL = 7; // owner CMS user-type
 *      OWNER = 4; // owner CMS user-type
 *      SUPERVISOR = 2;// supervisor CMS user-type
 *      USER = 1; // user CMS user-type
 *      NONE = 0; // user CMS user-type
 * 
 *   For example:  
 *      g_useVisibilityFilter = SUPERVISOR + USER; // Owner sees all datapoints, 
 *                                                  // but Supervisor and user user-types only see Datapoints with Visible flag set (Datapoint Properties Widget)
 *      g_bDisplayDevicesStatusInFooter = OWNER; // means only owener sees Device status in Footer
 *      g_bDisplayDevicesStatusInFooter = OWNER + SUPERVISOR; // means owener and supervisor user-types see Device status in Footer,
 *                                                              // user user-type doesn't see device status in footer
 *      g_bDisplayDevicesStatusInFooter = ALL; // means all user-types (owener, supervisor and user) see Device status in Footer
 *      g_bDisplayDevicesStatusInFooter = NONE; // means no user-types (owener, supervisor and user) see Device status in Footer
*/
/********************************************************************
 *  Required function - User calls their custom function from this function
 *******************************************************************/


/********************************************************************
 *  userinit() - Changes Web page defaults and datapoints shown based on specific device specific device name, program ID or device type names
 * 
 *  Not all default variables are listed, see navtree.js for most of default settings.
 *  These settings can be overwritten by specifying custom tags for a context in the Planning Widget. 
 * 
 *******************************************************************/
function userinit() {
    

        // Don't remove commented parameters, un-comment to change parameter otherwise default settings are used

    //g_iShowTreeWhenNoContexts = OWNER; // only ownwer see Web page when no contexts in Planning Widget
    //g_NoContextsMessage = "Please Contact Site Administrator"; // If no contexts in Planning Widget
    //g_bUseWebSockets = true; // true = use only with Websockets to get datapoint updates [default], false = use GET response for datapoint updates
    
    //g_useVisibilityFilter = ALL; // use user-type Constants (Must be all CAPS) - NONE - show all datapoints,show visible Datapoints using Datapoint Properties visible setting 
    //g_bHideSubscribeButton = true; //Used with g_bUseWebSockets, false=always show re-subscrive button
    g_bSingleUserType = false; // false=different device types DPs for each user type (owner,supervisor or user), true=same for all user types [default]
    g_bUseChartForAllOutputs = true;
        // UI specific
    //g_bShowDevicesInTree = ALL; // ALL [default] used to show devices in tree use user-type CONSTANTs (Must be all CAPS)
    //g_bDisplayDevicesStatusInFooter = OWNER + SUPERVISOR; // use user-type CONSTANTs (Must be all CAPS)
    //g_bShowDeviceStatusInTree = ALL; // use user-type CONSTANTs (Must be all CAPS)
    //g_bShowAllDeviceStatus = ALL; // use user-type CONSTANTs (Must be all CAPS)
    //g_showAdvancedCheckbox = OWNER + SUPERVISOR; // use user-type CONSTANTs (Must be all CAPS)
    //g_bUseChartForAllInputs = false; // false [default] Applies to scalars only (numbers)
    //g_bUseChartForAllOutputs = true; // true [default] Applies to scalars only (numbers)
    //g_iCurrentPriorityButtonType = 2; // 0=don't show, 1= "...", 2 = "P <priority>"
    //g_iDashboardDatalogRange = 1; // 0=no data logs, 1=10min, 2= 1 hour [default], 3 = 1 day. this may slow down Device Web signifantly if data log to big
    //g_iDashboardChartDuration = 0; //0= none [default], 1= 1 hour, 2 = 1 hour, 3 = 1 day
    //g_idashboardChartMaxNumberOfPointsDefault = 1000; // 0=unlimited
    //g_bShowRoomTableContextOnImage = true; // true=show table in image, false=show after image like floor
    //g_sTreeDevicesNoContent = "Click specific device";
    //g_sTreeNoContent = "No Content"; // "No Content" [default] What text to put when Campus, Building and Devices node clicked 
    

        // control write priorities
    g_OwnerUserTypeWritePriority = ">8";//"all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    g_OwnerUserTypeClearPriority = ">8";//"all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_supervisorUserWriteTypePriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_supervisorUserTypeClearPriority = "all"; //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_userUserTypeWritePriority = "all";  //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_userUserTypeClearPriority = "all";  //"all" = can write all priorities [default], "8" = write at priority 8 only, ">8" can write at priority 9 and below.
    // g_bIoxUseDefaults = true; // Use the built in IOX devices datapoints, set to false if you want to see all datapoints

        // device Type Replacement code - specify device datapoints and images
    deviceTypeReplacements();
}
/********************************************************************
 *  deviceTypeReplacements() - Add images for context or devices and change which datapoints are shown based on specific device specific device name, program ID or device type names
 * 
 *  If you specify a datapoint for a device name/program ID/device type name then you must specify all the datapoints for this item.
 *  These settings can be overwritten by specifying custom tags for a context in the Planning Widget. 
 *******************************************************************/
function deviceTypeReplacements() {
    // This function is required
    addSmartServerImage(null, "images/user/smartserver.png",250, null); // For segment controller
    return; //un comment and modify to support your different device types

    // custom webpage needs to support ?devicename={devicename}
    //addDeviceTypeReplacement("PulseGen", "../deviceconfig/pulsegenchart.html", 1400, 800);

    //"sites" have two types: "sites" -at least one context in planning Widget, and "site" - No Contexts in Planning Widget
    addImageForContext(null, "sites", null,null, null, null,"<br><br><br><h2><span style='margin-left:150px'>Monitoring and Control System</span></h2>");
    
    
    addImageForContext("17qam88", "sites",null,"images/user/starterkit.png", null, 600,"<b><span style='margin-left:150px;'>STARTER KIT</span></b><br><br>", true);
    
    //addImageForContext("17qam77,17qam88", "campus",null,"images/user/campus1map.png", 600, null,"3600 Peterson Way, Santa Clara, CA 95054,USA", false);
    addImageForContext("17qam88", "building", "BUILDING","images/user/building1.png",null, null, "South Building"), false;


    //addProgramIdWebPage(null, "900001153C000405", true,  "../deviceconfig/pulsegenchart.html", 1400, 800); // replacement Web page for PulseGen
    addProgramIdWebPage(null, "PulseGen-1", true,  "../deviceconfig/pulsegenchart.html", 1400, 800); // replacement Web page for PulseGen

    
    //addImageForContext(null, "campus",null,"images/user/campus1map.png", 600, null,"3600 Peterson Way, Santa Clara, CA 95054,USA", false);
    addImageForContext(null, "building", "BUILDING","images/user/building1.png",null, null, "South Building", false);
   
    
    // starter kit 
    addDeviceTypeDpList(null, "6kEvbMultiSensor", null, "images/user/ft6050_device.png",300, null);  // addSensorDpList("6kEvbMultiSensor"); // works but show only image// use DP subset for device type and add image
    addDeviceTypeDpList(null, "SC100-MP", null, "images/user/sc100.png",300, null); // add only image
    addDeviceTypeDpList(null, "ADAM-4150", null, "images/user/adam.png",null, 300); // add only image
    //addDeviceTypeDpList(null, "VT7200-1H1C-3", null, "images/user/tstat.png", null, 300); // add only image
    addDeviceDpList(null, "Tstat-01", null, "images/user/tstat.png", null, 300); // add only image

    
}

/********************************************************************
 ********************************************************************
 *  User Custom function - one per device type
 ********************************************************************
 *******************************************************************/
function addSensorDpList(deviceTypeName) {
    // deviceTypeName: if not "" then use for specific device type otherwise use for all device types with program ID
    // used to reduce number of datapoints displayed and adds picture
    try {
        var sid = null; // null means for all SmartServers, For specific SmartServer enter SmartServer SID as a string "x12345"
        // create datapoint list
        var dpList = [];
        dpList.push("*/*/nvoTemp*");
        dpList.push("LightSensor/0/nvoLightLevel");
        //dpList.push(addDpObjAll("Lamp/*/~iLamp", null, null, null, ">8",">8")); // user type specific requirements
        //dpList.push(addDpObjAll("Lamp/*/~iLamp", "s3", (OWNER + SUPERVISOR + USER), USER, ">8",">8")); // example for SNVT_switch user type specific requirements
        //dpList.push(addDpObj("Lamp/*/~oLamp"));
        dpList.push("Lamp/0/~Lamp");
        dpList.push(addDpObjAll("Lamp/1/~Lamp", "s4", null, null, ">8",">8")); // example for SNVT_switch user type specific requirements
        
        dpList.push("Lamp/*/~oLamp");
        dpList.push("Switch/*/nvo*");
        if(deviceTypeName !== "")
            addDeviceTypeDpList(sid, deviceTypeName, dpList, "images/user/ft6050_device.png",300,null);
        else
            addDeviceTypeProgramIdDpList(sid, "9FFFFF0501840460", dpList, "images/user/ft6050_device.png",300,null);
    }
    catch {}
}

 function addIoxDioDpList(deviceTypeName) {
    // deviceTypeName: if not "" then use for specific device type otherwise use for all device types with program ID
    // used to reduce number of datapoints displayed and adds picture
    try {

        // create datapoint list
        var dpList = [];
        dpList.push("*/*/nvoTemp*");
        dpList.push("LightSensor/0/nvoLightLevel");
        dpList.push(addDpObjAll("Lamp/*/~iLamp", null, null, null, "<8","<8", null)); // user type specific display element requirements
        dpList.push("Lamp/*/~iLamp");
        dpList.push("Lamp/*/~oLamp");
        dpList.push("Switch/*/nvo*");
        if(deviceTypeName !== "")
            addDeviceTypeDpList(deviceTypeName, dpList, "images/user/ft6050_device.png",null,null);
        else
            addDeviceTypeProgramIdDpList("9FFFFF0501840460", dpList, "images/user/ft6050_device.png",null,null);
    }
    catch {}
}


