/*************************************************************************************************
 *  navtreeplanning.js
 * 
 *  Contains code for the Planning View navigation tree.
 * 
 *  This code gets all devices and all context and then builds the navigation tree. Works well on small
 *	sites, but larger sites should probably require user to expand node before getting context and device 
 *	data
 *
 * 
 * When creating the tree, all nodes are fully expanded. A context Devices nodes has all device nodes.  
 * Devices nodes are automatically collapsed so that only context and devices nodes show up initially. 
 * Expanding the devices nodes shows the hidden device nodes. When you exapand a device then a REST call
 * is made to get the device datapoint list. 
 * 
 * It is difficult to get the tree lines to work correctly. The last node in the tree must remove the 
 * previous <ul> lines so that the lines only goes to the device and not extend down to the children.
 * When this occurs the line ends with no nodes attached.  
 * 
 * The following style must be added to the last node  <ul> of a node list in order to remove vertical dotted line
 *      style=\"border-left: 3px solid #366184;margin-left: -18px; 
 * 
 * getPlanningCampusContextTags() - gets custom Fields from campus context, only one campus is supported
 * 
 *  
 * build tree:
 * 	getplanningTreeShowTreeContext()
 * 	getplanningTreeShowTreeContextBuilderWithDatapoints() - builds the tree
 * 
 *	Clicking on tree:
 *	getPlanningTreeShowTreeDetails() - Clicking on site, campus, building, room, area nodes
 *	reeviewshowcontextdevicesinDetailsPane() - Clicking on devices node
 *	getPlanningTreeShowDashboard() - Clicking on device node
 *	showPlanningTreeCalendar() - clicking on schdedule node
 * 
 * devices Node:
 * 	treeviewShowContextDevicesInDetailsPane() - when devices node clicked
 * 	getPlanningTreeShowTreeDatapoints() - shows device datapoints in details pane
 * 	treeviewToggle1 - expands/collapse device datapoints
 *  getPlanningTreeShowDashboard() - When device clicked in tree - use custom device dashboard if specified, if not use bultin dashboard
 * 	getPlanningTreeShowTreeDatapointsRequestDataResponse() - used to process datapoint information
 * 	getPlanningTreeShowTreeDetails() - click on context
 * 	getPlanningTreeShowTreeFloorplan - floorplan (floor, room, area)
 *  getPlanningTreeShowTreeFloorplanShowDevices() - shows devices and DPs on floorplan
 * 
 *  
 * 	getPlanningFloorPlanShowContextDps() - builds dplist based on Context or g_CampusTags. This list is then used later to build dashboardDpList for this context
 * 	getPlanningContextDpsListResponse() - builds contexts dashboardDpList displaytypes based on response from GET
 * 	getPlanningGetAlarmsForDeviceResponse() - process active alarms
 * 
 *  g_displayTypeList - list context related display types
 * 
 *	Example Campus tags (tag: value)
 *	alarms: showalarms=ALL,clearalarms=ALL,alarmcolors=cyan;yellow;orange;pink
 *  devicetype_pulsegen.dp8: (900001153C000405)/device/0/nvoLuxLevel, Light Level 1, displaytype=r;c,units=lux, contexts=floor;room,dashboard=200,300
 * 
 *  Creating a tree
 * 	 tree node list not last node -  class =treeli treeviewLiActive
 * 	 tree node list last node -    class =treeli treeviewLiActiveLastChild
 * 	 tree node entry (not list) - class =treeli
 *   Copyright (C) 2021 Dialog Semiconductor.  All rights reserved.
 *	
 *	Use of this code is subject to your compliance with the terms of the 
 *	Dialog IzoT(tm) Software Developer's Kit License Agreement which is 
 *	available at www.dialog-semiconductor.com/license/izot_sdk/.  
 * 
 ***************************************************************************************************/
var g_bPlanningTreeShowDatapointNodes = true;
var g_treeviewInitialCollapseList = [];
var planningDpList = [];
var g_iPlanningPaneSelectedContextId = -1;
var g_iPlanningPaneSelectedContextType = -1; // 0=campus/building/floor/room/area, 1=devices,2=device,3=datapoints
var g_sPlanningTreeDatapointPath = "";
var g_bPlanningDpPollingEnabled = true;
var g_iPlanningPollInterval = 5;
var g_planningDpOnDemandTimerInterval = 10000; // firefox takes more time to load svg then chrome
var g_planningDpTimerId = 0; // used to initilize svg elements
var g_bPlanningShowDevice = true;
var g_bPlanningShowConfiguration = false;
var g_bPlanningShowConfigurationSingleDp = false;
var g_iPlanningTreeDivResizeTimerId = 0;
var g_iTreeDivTreeHeight = 0;
var g_iTreeDivTreeWidth = 0;
var g_sContextDpQualifierList = "";
var g_sContextDpQualifierDeviceList = []; //used for alarms
var g_displayTypeList = []; // used to use "s3" or "s4" for SNVT_switch
var g_iContextTableX = 0;
var g_iContextTableY = 0;
var g_bPlanningShowContextDpMenuButton = true;
var g_iDisplayIndex = 0;
var g_campusTags = {};


function planningInit() {
	g_iPlanningPaneSelectedContextId = -1;
	g_iPlanningPaneSelectedContextType = -1;
	g_treeviewInitialCollapseList = [];
	planningDpList = [];
	g_sPlanningTreeDatapointPath = "";
	g_bPlanningDpPollingEnabled = true;
	g_iPlanningPollInterval = 5;
	g_bPlanningShowDevice = true;
	g_bPlanningShowConfiguration = false;
	g_bPlanningShowConfigurationSingleDp = false;
	g_iPlanningTreeDivResizeTimerId = 0;
	g_iTreeDivTreeHeight = 0;
	g_iTreeDivTreeWidth = 0;
	g_sContextDpQualifierList = "";
	g_sContextDpQualifierDeviceList = []; //used for alarms
	g_displayTypeList = []; // used to use "s3" or "s4" for SNVT_switch
	g_bPlanningShowContextDpMenuButton = true;
	g_iDisplayIndex = 0;
	g_campusTags = {};
}
function getPlanningCampusContextTags(customFields) {
	
	var content = "";
	var i, j, k, m, x, y, z, iPtr, iPtr1, iTemp, id;
	var items = [], items1;
	var x1;
	var sTemp = "", sTemp1, sTemp2,name, names,type, image, width,height, location = "", above = true, sid = null, bSidFound;
	var displayType = "n";
	var obj = {}, obj1, obj2;
	var contextPath = "";
	
	var dpList = [], dpList1 = [],item, items, items1, items2, item3;
	var label = "";
	var bContinue = true;
	
	var iXoffset = 0, iYoffset = 0, iTemp; 
	var sFieldPath = "";
	g_campusTags = {}
	if(customFields === null) 
		return;
	if(customFields === "") 
		return;
	try {
		
		
		
		g_campusTags.label = "";
		g_campusTags.deviceTypesList = [];
		/*
		g_campusTags.image = {};
		g_campusTags.image.image = "";
		g_campusTags.image.height = "";
		g_campusTags.image.width = ""; */
		g_campusTags.userList = [];
		
		for(x in customFields)
		{
			x1 = x.toLowerCase();
			items = [];
			try {
				if(x1 === "label")
					label = customFields[x];
				else if (x === "offsetx") {
					sTemp1 = customFields[x];
					try {
						iTemp = Number(sTemp1);
						if(!isNaN(iTemp))
							iXoffset = iTemp;
					}
					catch {}
				}
				else if (x === "datalogrange") {
					sTemp1 = customFields[x];
					try {
						iTemp = Number(sTemp1);
						if(!isNaN(iTemp)) {
							if(iTemp > 0) {
								g_bDashboardGetDatalog = true;
								g_iDashboardDatalogRange = iTemp;

							}
							else {
								g_bDashboardGetDatalog = false;
								g_iDashboardDatalogRange = 0;
							}
						}
					}
					catch {}
				}
				else if (x === "image") {
					items = customFields[x].split(",");
					image = ""; width = null; height = null;
					location = "";
					above = true;
					sid = null;
					bSidFound = false;
					for(i=0; i < items.length; i++)
					{
						if(items[i] !== "") {
							items1 = items[i].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								if(items1[0] === "image") {
									image =items1[1].trim();
								}
								else if(items1[0] === "width") {
									width =items1[1].trim();
								}
								else if(items1[0] === "height") {
									height =items1[1].trim();
								}
								else if(items1[0] === "sid") {
									if(items[1].trim().toLowerCase() !== "null") {
										sid = items1[1].trim();
									}
									bSidFound = true;
								}
								else if(items1[0] === "location") {
									location =items1[1].trim();
								}
								else if(items1[0] === "above") {
									items1[1] = items1[1].trim().toLowerCase();
									if(items1[1] === "false")
										above = false;
								}
							}
						}
						
					}
					if(!bSidFound) 
						sid = g_iSmarserverSid;
					if(image !== "") 
						addImageForContext(sid, "CAMPUS",null, image, width, height,location, above);
				}
				else if(x1 === "contextoffsets") {
					try {
						items = customFields[x].split(",");
						for(i=0; i < items; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "offsetx") {
										if(items[1].indexOf("." === -1)) {
											iTemp = Number(items[1])
											if(!isNaN(iTemp))
												g_iContextTableX = iTemp; 
										}
									}
									else if(items1[0] === "offsety") {
										if(items[1].indexOf("." === -1)) {
											iTemp = Number(items[1])
											if(!isNaN(iTemp))
												g_iContextTableY = iTemp; 
										}
									}
								}
							}

						}
					}
					catch {}
				}
				else if((x1 === "settings") || (x1 === "settingss")) {
					items = customFields[x].split(",");
					for(i=0; i < items.length; i++)
					{
						if(items[i] !== "") {
							items1 = items[i].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								
								
								if(items1[0] === "showdplabel") {
									if(items1[1] === 0)
										g_bShowContextDpLabels = false;
									else
										g_bShowContextDpLabels = true;
								}
								
							}
						}
	
					}
				} 
				else if (x1.startsWith("devicetype_")) {
					
					// devicetype_pulsegen.dp1: (9FFFFF0501840460)/device/0/nviLamp1, Lamp1, displaytype=s4, context=floor;room
					// devicetype_pulsegen.image:  devicetype=(9FFFFF0501840460),url=images/user/ft6050_device.jpg,width=null,height=null
					
					try {
						iPtr = x1.indexOf(".")
						if((iPtr !== -1) && ((iPtr + 1) < x1.length)) {
							sTemp2 =x1.substr(iPtr + 1);
							if(sTemp2.startsWith("dp")) {
								obj = {};
								obj.name = x1 + " ";
								obj.parameters = customFields[x];
								dpList1.unshift(obj);

							}
							else if(sTemp2.startsWith("image")) {
								names = [];
								type = "";
								image = "";
								width = "";
								height = "";
								items = customFields[x].split(",");
								for(i=0; i < items.length; i++)
								{
									if(items[i] !== "") {
										items1 = items[i].split("=");
										if(items1.length === 2) {
											items1[0] = items1[0].trim().toLowerCase();
											items1[1] = items1[1].trim();
											
											
											if(items1[0] === "devicetype") {
												type = "";
												name = "";
												if((items1[1].charAt(0) !== "(") && (items[1].charAt(0) !== "[")) {
													name = items1[1].toLowerCase();
													type = "devicename";
												}
												else if(items1[1].length > 2) {
													if((items1[1].charAt(0) === "[") && (items1[1].charAt(items1[1].length - 1) === "]")) {
														name = items1[1].substr(1,items1[1].length - 2).toLowerCase();
														type = "devicetype";
													}
													else if((items1[1].charAt(0) === "(") && (items1[1].charAt(items1[1].length - 1) === ")")) {
														name = items1[1].substr(1,items1[1].length - 2).toLowerCase();
														type = "programid";
													}
												}
												if((name !== "") && (type !== "")) {
													names = [];
													if(name.indexOf(";") !== -1) {
														names = name.split(";");
													}
													else
														names.push(name);
												}
											}
											else if(items1[0] === "image") {
												image = items1[1];
											}
											else if(items1[0] === "width") {
												if(items1[1] !== "null")
													width = items1[1];
											}
											else if(items1[0] === "height") {
												if(items1[1] !== "null")
													height = items1[1];
											}
										}
									}
				
								}
								if((names.length > 0) && (type !== "") && (image !== "")) {
								// determine if device type already created
									for(i=0; i < names.length; i ++)
									{
										z = -1;
										for(k=0; k < g_campusTags.deviceTypesList.length; k++)
										{
											if((g_campusTags.deviceTypesList[k].type === type) && (g_campusTags.deviceTypesList[k].name === names[j])) {
												z = k;
												break;
											}
										}
										if(z === -1) {
											obj = {};
											obj.name = names[i];
											obj.type = type;
											obj.image = "";
											obj.width = "";
											obj.height = "";
											obj.dpList = [];
											g_campusTags.deviceTypesList.push(obj);
											z = g_campusTags.deviceTypesList.length - 1;
										}
										if(z !== -1) {
											g_campusTags.deviceTypesList[z].image = image;
											g_campusTags.deviceTypesList[z].width = width;
											g_campusTags.deviceTypesList[z].height = height;
										}
									}
								}
							}
						}
						
					}
					catch {}
					
				}
				else if (x1.indexOf(".") !== -1) {
					// user  "mike.settings:context=* / * /Entry,singlecontext=true,dashboard=false,readonly=true
					z = -1;
					iPtr = x1.indexOf(".");
					sTemp = "";
					if(iPtr !== -1) {
						sTemp = x1.substr(0, iPtr);
					}
					for(j=0; j < g_campusTags.userList.length; j++)
					{
						if(g_campusTags.userList[j].name === sTemp) {
							z = j;
							break;
						}
					}
					if(z === -1) {
						obj = {};
						obj.name = sTemp;
						obj.context = "";
						obj.showDeviceDashboard = true;
						obj.readonly = false;
						obj.singleContext = false;
						g_campusTags.userList.push(obj);
						z = g_campusTags.userList.length - 1;
					}
					if(z !== -1) {
						sTemp1 = customFields[x];
						items = sTemp1.split(",");
						for(j=0; j < items.length; j++)
						{
							items1 = items[j].split("=");
							if(items1.length === 2) {
								items1[0] = items1[0].trim().toLowerCase();
								items1[1] = items1[1].trim();
								if(items1[0] === "context") {
									g_campusTags.userList[z].context = items1[1];
								}
								else if(items1[0].startsWith("dashboard")) {
									if(items1[1] === "false")
									g_campusTags.userList[z].showDeviceDashboard = false;
								}
								else if(items1[0] === "readonly") {
									if(items1[1] === "true")
										g_campusTags.userList[z].readonly = true;
								}
								else if(items1[0] === "singlecontext") {
									if(items1[1] === "false")
										g_campusTags.userList[z].singleContext = false;
									else if(items1[1] === "true")
										g_campusTags.userList[z].singleContext = true;
								}
								
							}
						}
					}
				}
			}
			catch {}
		}
		
		
		
		 // create device Type list 
		for(i=0; i < dpList1.length; i++) 
		{
			items = [];
			items = dpList1[i].parameters.split(",");
			if(items.length > 0) {
				name = ""
				names = [];
				type = ""
				items1 = items[0].split("/");
				for(j=0; j < items1.length; j++)
				{
					items1[j]= items1[j].trim().toLowerCase();
				}
				name = items1[0];
				if((name.charAt(0) !== "(") && (name.charAt(0) !== "[")) {
					name = items[0];
					iPtr1 = name.indexOf("/")
					if(iPtr1 > 0) {
						name = name.substr(0, iPtr1)
					}
					name = name.toLowerCase();
					type = "devicename";
				}
				else if(name.length > 2) {
					if((name.charAt(0) === "[") && (name.charAt(name.length - 1) === "]")) {
						name = name.substr(1,iname.length - 2);
						type = "devicetype";
					}
					else if((name.charAt(0) === "(") && (name.charAt(name.length - 1) === ")")) {
						name = name.substr(1,name.length - 2);
						type = "programid";
					}
				}
				else 
					name = "";

				if((name !== "") && (type !== "")) {
					names = [];
					if(name.indexOf(";") !== -1) {
						names = name.split(";");
					}
					else
						names.push(name);
					obj1 = {}; // dp info, may be used more than once if multiple device names, device types or program IDs used
					for(j=0; j < names.length; j++)
					{	
						if(j === 0) {

						}
						z = -1;
						for(k=0; k < g_campusTags.deviceTypesList.length; k++)
						{
							if((g_campusTags.deviceTypesList[k].type === type) && (g_campusTags.deviceTypesList[k].name === names[j])){
								z = k;
								break;
							}
						}
						if(z === -1) {
							obj = {};
							obj.name = names[j];
							obj.type = type;
							obj.image = "";
							obj.width = "";
							obj.height = "";
							obj.dpList = [];
							g_campusTags.deviceTypesList.push(obj);
							z = g_campusTags.deviceTypesList.length - 1;
						}
						if(z !== -1) {
							if(j === 0) {
								obj2 = null;
								obj1 = {};
								obj1.contextOrder = dpList1[i].name;
								obj1.name = "";
								obj1.type = "";
								obj1.label = "";
								obj1.displayType = "";
								obj1.contextDisplayType = "";
								obj1.contexts = "";
								obj1.field = "";
								obj1.fieldPath = "";
								obj1.blockPath = "";
								obj1.datapointName = "";
								obj1.path = "";
								obj1.readonly = true;
								obj1.backgroundColor = "";
								obj1.units = "";
								obj1.x = ""; // used for Dashboard positioning
								obj1.y = ""; // Used for Dashboard positioning
								obj1.padding = "";
								obj1.paddingChar = "";
								obj1.alarmType = "";
								items1 = [];
								items1 = items[0].trim().split("/");
								
								obj1.datapointName = items1[items1.length - 1];
								for(k=1; k < items1.length; k++) {
									if((k > 1) && (k < 4)) {
										obj1.path += "/";
										obj1.name += "/";
										obj1.blockPath += "/";

									}
									items1[k] = items1[k].trim();
									
									if(items1.length > 4) {
										if(obj1.fieldPath !== "")
												obj1.fieldPath += "/";
										obj1.fieldPath += items1[k];
										if(k > 4) {
											if(obj1.field !== "")
												obj1.field += "/";
											obj1.field += items1[k];
										}

									}
									else {
										obj1.path += items1[k];
										obj1.name += items1[k];
										obj1.blockPath += items1[k];
									}
								}
								for(k=1; k < items.length; k++) {
									items1 = [];
									items1 = items[k].split("=");
									if(items1.length === 2) {
										items1[0] = items1[0].trim();
										items1[1] = items1[1].trim();
										try {
											if(items1[j].startsWith("label")) {
												obj1.label = items1[1];
											}
											if(items1[0] === "contexts") {
												if(items1[1] !== "")
													obj1.contexts = items1[1].toLowerCase();
												/* remove
												if(items1[1].indexOf(";") === -1)
													obj1.contexts = ",".push(items[1]);
												else {
													obj2 = items1[1].split(";");
													for(m=0; m < obj2.length; m++)
													{
														if(obj2[m] !== "")
															obj1.contexts.push(obj2[m].trim().toLowerCase());
													}
												}
												*/
											}
											else if(items1[j].startsWith("units")) {
												obj1.units = items1[1];
											}
											else if(items1[0] === "displaytype") {
												if(items1[1].indexOf(";") !== -1) {
													items2 = items1[1].split(";");
													if(items2.length === 2) {
														obj1.contextDisplayType = items2[0].trim();
														obj1.displayType = items2[1].trim();
														
													}
													else if(items2[0] !== "") {
														obj1.contextDisplayType = items2[0].trim();
														obj1.displayType = items2[0].trim();
													}
												}
												else {
													obj1.contextDisplayType = items1[1];
													obj1.displayType = items1[1];
												}
											}
											else if(items1[0] === "readonly") {
												if(items1[1] === "false")
													obj1.readonly = false;
												else 
													obj1.readonly = true;
											}
											else if(items1[0] === "color") {
												obj1.backgroundColor = items1[1];
											}
											else if(items1[0] === "units") {
												obj1.units = items1[1];
											}
											else if(items1[0] === "dashboard") {
												//used to add span, s1,s4 to graphics
												try {
													obj2 = {};
													obj2.x = "";
													obj2.y = "";
													obj2.graphicDisplayType = "";
													obj2.padding = "";
													obj2.paddingChar = "";
													obj2.alarmType = "";
													if(items1[1].indexOf(";") !== -1) {
														items2 = items1[1].split(";");
														for(m=0;m < items2.length; m++)
														{
															item3 = items2[m].trim();
															if(m === 0)
																obj2.x = item3;
															else if(m === 1)
																obj2.y = item3;
															else if(m === 2)
																obj2.graphicDisplayType = item3;
															else if(m === 3)
																obj2.padding = item3;
															else if(m === 4)
																obj2.paddingChar = item3;
															else if(m === 5)
																obj2.alarmType = item3;
														}
													}
												}
												catch {
													obj2 = null;
												}
												
											}
										}
										catch {}
									}
								}
								if(obj1.label === "") {
									obj1.label = obj1.datapointName;
								}
								if(obj2 !== null) {
									try {
										if((obj2.x !== "") && (obj2.y !== "")) {
											obj2.x = Number(obj2.x);
											obj2.y = Number(obj2.y);
											if(isNaN(obj2.x) || isNaN(obj2.y))
												obj2 = null;
											/*
											else if((obj1.displayType === "r") || (obj1.displayType === "n") || (obj1.displayType === "c"))
												obj1.displayType = "r";
											else if((obj1.displayType === "s2") || (obj1.displayType === "l2"))
												obj1.displayType = "l2";
											else if((obj1.displayType === "s4") || (obj1.displayType === "l4"))
												obj1.displayType = "l4";	
											else */
											else {
												if(obj2.graphicDisplayType === "") {
													obj2.graphicDisplayType = obj1.displayType;
												}
												 if(!((obj2.graphicDisplayType === "r") || (obj2.graphicDisplayType === "n") || (obj2.graphicDisplayType === "c")
												|| (obj2.graphicDisplayType === "s2") || (obj2.graphicDisplayType === "l2") || (obj2.graphicDisplayType === "s3") || (obj2.graphicDisplayType === "l3")
												|| (obj2.graphicDisplayType === "s4") || (obj2.graphicDisplayType === "l4")))
												obj2 = null;
											}
											if(obj2 !== null) {
												
												obj1.x = obj2.x;
												obj1.y = obj2.y;
												obj1.padding = obj2.padding;
												obj1.paddingChar = obj2.paddingChar;
												obj1.alarmType = obj2.alarmType;
												obj1.graphicDisplayType = obj2.graphicDisplayType;
												

											}
											
										}
									}
									catch {}
								}
								g_campusTags.deviceTypesList[z].dpList.push(JSON.parse(JSON.stringify(obj1)));
								
							}
							
							
						}
					}
				}
			}
		}
		// sort datapoint list
		for(j=0; j < g_campusTags.deviceTypesList.length; j++)
		{
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (g_campusTags.deviceTypesList[j].dpList.length - 1); i++) 
				{
					if(g_campusTags.deviceTypesList[j].dpList[i].nameOrder > g_campusTags.deviceTypesList[j].dpList[i + 1].nameOrder) {
						obj = {}
						obj = JSON.parse(JSON.stringify(g_campusTags.deviceTypesList[j].dpList[i]));
						g_campusTags.deviceTypesList[j].dpList[i] = JSON.parse(JSON.stringify(g_campusTags.deviceTypesList[j].dpList[i + 1]));
						g_campusTags.deviceTypesList[j].dpList[i + 1] = obj;
						bContinue = true;
					}
				}
			}
		}
	}
	catch {
	}
	try {
		// check for user specific features
		g_bShowAlarms = false;
		if(checkIfUserTypeSupported(g_iShowAlarms))  
			g_bShowAlarms = true;
		g_bAllowedToClearAlarms = false;
		if(!checkIfUserTypeSupported(g_iClearAlarms))
			g_bAllowedToClearAlarms = true;
		g_bShowEventCountInCalendarAllow = checkIfUserTypeSupported(g_iShowEventCountInCalendar);
		if(g_bShowEventCountInCalendarAllow) {
			if(g_bShowEventCountInCalendarDefaultShow) 
				g_bShowEventCountInCalendar = true; // can be enabled or disable by calender menu
			else 
				g_bShowEventCountInCalendar = false;
		}
		else 
			g_bShowEventCountInCalendar = false;
		
	}
	catch {}
	return;
	
}
function getPlanningContextIdFromContextPath(path) {
	var result = -1;
	var pathItems, i, index = 0, pathName;
	var list = [];
	var bFound;
	try {
		if(planningList.length > 0) {
			pathItems = path.split("/");
			list = JSON.parse(JSON.stringify(planningList));
			for(i=0; i < pathItems.length; i++)
			{
				bFound = false;
				pathName = pathItems[i].trim().toLowerCase();
				for(j=0; j < list.length; j++)
				{
					if((pathName === "*") || (list[j].name.toLowerCase() === pathName)) {
						if(i === (pathItems.length - 1)) {
							return list[j].id;
						}
						else {
							list = list[j].children;
							bFound = true;
							break;
						}
					}
				}
				if(!bFound)
					break;
			}
		}
	}
	catch {
		result = -1;
	}

	return result;
}
function getPlanningContextObjFromContextPath(path) {
	var result = null;
	var pathItems, i, index = 0, pathName;
	var list = [];
	var bFound;
	try {
		if(planningList.length > 0) {
			pathItems = path.split("/");
			list = JSON.parse(JSON.stringify(planningList));
			for(i=0; i < pathItems.length; i++)
			{
				bFound = false;
				pathName = pathItems[i].trim().toLowerCase();
				for(j=0; j < list.length; j++)
				{
					if((pathName === "*") || (list[j].name.toLowerCase() === pathName)) {
						if(i === (pathItems.length - 1)) {
							return list[j];
						}
						else {
							list = list[j].children;
							bFound = true;
							break;
						}
					}
				}
				if(!bFound)
					break;
			}
		}
	}
	catch {
		
	}

	return result;
}
function getPlanningTree() { 
	var url = "https://" + location.hostname + "/iap/context";
	planningList = [];
	contextList = [];
	g_campusTags = {};
	requestGetData(0, url, getPlanningTreeCallback, readFailCallback); // get Device list

}
function getPlanningTreeCallback(mode, requestUrlString, json){
	var paneTitle = "";
	var i, j, len,iPtr, z = -1;
	var device1, device2;
	var obj;
	var deviceObj ={};
	var iCount1 = 0, index1 = 0;
	var bAddDevice = false;
	var paneContent = "";
	var bContinue = true;
	var tempObj;
	var element;
	bivServerOnline = true;

	g_bIgnoreNewDeviceDetection = false;
	




	if((json === null) || (json.length === 0)) {
		if(!checkIfUserTypeSupported(g_iShowTreeWhenNoContexts)) {
			g_NoContextsMessage = "Please Contact Site Administrator"; 
		}
		
		if(g_bInitialization) {
			g_bInitialization = false;
			if(deviceListAll.length === 0) {
				document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
				return;
			}
			else if(mode === 0)
				planningList = [];
			
			getplanningTreeShowTree(0);
			//showDevices(); 123
		}
		else {
			g_bInitialization = false;
			if(deviceListAll.length === 0) {
				document.getElementById("gettingInfoId").innerHTML = "No data avaiable";
				return;
			}
			else if(mode === 0)
				planningList = [];
			
				getplanningTreeShowTree(0);
		}
		return;
	}
	g_bShowDeviceDashboard = true;
	try {
		planningList = json;

		// check if there are any campus contexts
		for(i=0; i < json.length; i++)
		{
			if(json[i].contextType === "CAMPUS") {
				z = i;
				break;
			}
		}
		if(z !== -1) {
			for(i=0; i < json.length; i++)
			{
				
				if(json[i].contextType === "BUILDING") {
					z = i;
					break;
				}
			}
		}

		//if(json[0].contextType === "CAMPUS") {
		if(z !== -1) {
			//get Campus tags
			getPlanningCampusContextTags(json[z].customFields);

			if(g_bCheckUser) {
				for(i=0; i < g_campusTags.userList.length; i++)
				{ 
					
					if(g_campusTags.userList[i].name === g_currentUser) {
						g_bShowDeviceDashboard = g_campusTags.userList[i].showDeviceDashboard;
						g_bReadOonly = g_campusTags.userList[i].readonly;
						contextPath = g_campusTags.userList[i].context;
						if(g_campusTags.userList[i].singleContext) {
							// find context
							
							id = getPlanningContextIdFromContextPath(contextPath);
							if(id === -1)
								alert("Error: can't find context\r\n\t" + contextPath);
							else {
								paneContent = "<div id=\"planningPaneDetails\" class=\"planningPaneDetailsShow\">";
								element = document.getElementById("main");
								if(element !== null)
									element.innerHTML = paneContent;
								getPlanningTreeShowTreeFloorplan (id);
							}
							return;
						}
						else if(contextPath !== "") {
							g_bShowUnassignedDevicesInTree = false;
							json = getPlanningContextObjFromContextPath(contextPath);
							planningList = [];
							if(json === null) {
								document.getElementById("main").innerHTML = "<h2>No Context Found</h2>";
								
								return;
							}
							else {
								planningList.push(JSON.parse(JSON.stringify(json)));
							}
						}
						break;
					}
				}
			}
		}

/*
		if(g_currentUser !== null) {
			// check if user only has access to single context
			planningList = [];
			for(i=0; i < g_campusTags.userList.length; i ++)
			{
				if(g_campusTags.userList[i].name === g_currentUser) {
					// mike.settings: context=* / * /Entry,singlecontext=true,devicedashboard=false,readonly=true
					if(g_campusTags.userList[i].context !== "") {
						index = 0;
						planningDpList = getPlanningTreeInitPlanningListForUser(0, json,g_campusTags.userList[i].context,0)
						if(planningDpList === null) {
							element = document.getElementById("main");
							if(element !== null) {
								element.innerHTML = "<div style=\"margin-left:250px;margin-top:100px\">No Context Found</div>";
							}
							return;
						}
						if(g_campusTags.userList[i].singlecontext)
							planningDpList[0].children = [];
						if(!g_campusTags.userList[i].showDeviceDashboard) 
							g_bShowDeviceDashboard = false;
					}
					break;
				}
			}
		}
		else if(mode === 0)
			planningList = json;
			*/
			
		g_bInitialization = false;
		
		
		//paneContent = prettyJson(json); //JSON.stringify(json);
		//document.getElementById("main").innerHTML = "<textarea style=\"width:100%;\" cols=\"25\">" + paneContent + "</textarea>";
		getplanningTreeShowTree(0);
		
		// navtree - remove 
		paneTitle = "<button id=\"planningTreeShowDevicesButton\" class=\"planningTreeShowDevicesButton\" onclick=\"planningExpandDevicesNodeInTree()\">";
		if(g_bPlanningShowDevice)
			paneTitle += "Show All Devices"
		else 
			paneTitle += "Hide All Devices"
		paneTitle += "</button>";
		//paneTitle += "<button onclick=\"showPlanningRefresh(0)\" style=\"margin-left:10px\">Refresh All</button>";
		paneTitle += "<div id=\"planningContextDetailsDiv\" style=\"display:inline-block;float:right;margin-left:300px\"></div>";
		getActiveAlarmsCount(0)
		//navtree document.getElementById("main-Header").innerHTML = paneTitle;
		//if(deviceList.length === 0) {
		//	getDeviceListOnlyDontDisplay();
		//}
		
	}
	catch {}
}
function getPlanningTreeInitPlanningListForUser(mode, json,path,level) {

	try {
		var i, j, k, iPtr, objs, pathItems;
		level++;
		pathItems = path.split("/");
		if(json === null)
			return null;
		for(i=0; i < json.length; i++)
		{
			if((pathItems[0] === "*") || (pathItems[0] === json[i].name)) {
				if(pathItems.length === 1) {
					objs = [];
					objs.push(JSON.parse(JSON.stringify(json[i])))
					return objs;
				}
				else {
					iPtr = path.indexOf("/")
					if((iPtr > 0) && ((iPtr + 2) < path.length)){

						path = path.substr(iPtr + 1);
						return getPlanningTreeInitPlanningListForUser(mode, json[i].children,path,level);
					}
				}
			}
		}
		json = null;
	}
	catch {
		json = null;
	}
	return json;
}
function getPlanningTreeInitializePlanningList (mode, json, path, level) {
	try {
		var i, j, k;
		level++;
		var devices = [], deviceName1, deviceName2;
		var tempObj;
		var bContinue;
		
		if(json === null)
			return null;
		for(i=0; i < json.length; i++)
		{
			if(level === 1) {
				json[i].show = true;
				
			}
			else {
				json[i].show = false;
				
			}
			if(path !== "") {
				json[i].path = path + "/" + json[i].name;
				json[i].treeLevel = level;
			}
			else {
				json[i].path = json[i].name;
				json[i].treeLevel = level;
			}
			if(mode === 0) {
				tempObj = {};
				tempObj.path = json[i].path;
				tempObj.treelevel = level;
				tempObj.id = json[i].id;
				tempObj.name = json[i].name;
				contextList.push(tempObj);
			}
			json[i].devices = [];
			devices = [];
				// list devices
			for(k=0; k < deviceListAll.length; k++) 
			{
				for(j=0; j < deviceListAll[k].contexts.length; j++)
				{
					
					if(deviceListAll[k].contexts[j] === json[i].id) 
					{
						devices.push(JSON.parse(JSON.stringify(deviceListAll[k])));
						break;
					}
				}
			}
			if(devices.length > 0) {
				// reorder based on device name
				bContinue = true;
				while(bContinue) 
				{
					bContinue = false;
					for(k=0; k < (devices.length - 1); k++)
					{
						deviceName1 = devices[k].name.toLowerCase() + " ";
						if(devices[k].category === "SC")
							deviceName1 = "0" + deviceName1; // make sure smartserver at top of list
						deviceName2 = devices[k + 1].name.toLowerCase() + " ";
						if(devices[k + 1].category === "SC")
							deviceName2 = "0" + deviceName2; // make sure smartserver at top of list
						//if(devices[k].name.toLowerCase() > devices[k + 1].name.toLowerCase()) {
						if(deviceName1 > deviceName2) {
							bContinue = true;
							tempObj = {};
							tempObj = JSON.parse(JSON.stringify(devices[k]));
							devices[k] = JSON.parse(JSON.stringify(devices[k + 1]));
							devices[k + 1] = tempObj;
						}
					}
				}
				json[i].devices = devices;
			}
			if(json[i].children !== null) {
				if(json[i].children.length > 0) {
					json[i].children = getPlanningTreeInitializePlanningList (mode, json[i].children, json[i].path, level);
				}
			}
			
		}
	} catch { sResult = ""; }
	return json;
}
function getPlanningTreeShowDashboard(mode, contextId, deviceName) {
	// use for navtree
	// Determine if customer has own device dashboard.  If so use that one in a iframe, if not then use builtin dashboard
	var i, j, k, typeId, deviceTypeName, deviceProgramId, deviceProgramId1, mask = 0xff, deviceProgramIds, deviceProgramIds1, count, match;
	var element, obj = {};
	var content = "";
	g_iMainDisplayMode = DISPLAYMODE_DASHBOARD;
	menuCloseAll();
	g_bEditModeEnabled = false;
	g_bDeviceDataLogGetInProgress = false;
	if(g_iShowEditButton > 0) {
		if(g_iShowEditButton === 2) 
			g_bEditModeEnabled = true;
	}
	g_iDashboardBackButtonContextId = null;
	if(mode === 10) {
		g_iDashboardBackButtonContextId = g_iPlanningPaneSelectedContextId;
		
	}
	
		
	try {
		// change color of tree context to indicate selected
		if((mode === 0) && (g_iPlanningPaneSelectedContextId !== -1)) {
			treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
			if(treeContext !== null) {
				treeContext.classList.remove("treeSelected")
				//treeContext.style.backgroundColor = "white";
				
			}
		}
		treeContext = document.getElementById("planningTreeContext_" + contextId);
		if(treeContext !== null) {
			treeContext.classList.add("treeSelected")
			//treeContext.style.backgroundColor = "red";
		}
		if(contextId !== "")
			g_iPlanningPaneSelectedContextId = contextId;
		element = document.getElementById("planningPaneDetails");
		if(element !== null) {
			element.className = "planningPaneDetailsShow";
		}
	
		for(i=0; i < deviceListAll.length; i++)
		{
			if(deviceListAll[i].name === deviceName) {
				if(deviceListAll[i].category === "SC") {
					//custom Web page found
					content = "<div style=\"display: inline-block;\">";
					//remove content = "<div style=\"display: inline-block;width:" + g_deviceTypesReplacementsProgramId[j].width;
					//remove content += "px;height:" + g_deviceTypesReplacementsProgramId[j].height + "px;\">";
					content += "Dashboard: SmartServer Segment Controller<br><br>";
					if(g_smartServerImage !== null) {
						content += "<div style=\"float:left;display:inline-block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  g_smartServerImage + "\" alt=\"device image\"";
						if(g_smartServerImageWidth !== null)
							content += " width=\"" + g_smartServerImageWidth + "px\"";
						if(g_smartServerImageHeight !== null)
							content += " height=\"" + g_smartServerImageHeight + "px\"";
						content += "></div>";
						
					}
					if(element !== null) {
						element.innerHTML = content;
						element.style.marginLeft = "0px";
					}
					return;
				}
				
				typeId = deviceListAll[i].typeId;
				if(typeof deviceListAll[i].programId === "undefined") {
					for(j=0; j < deviceTypeList.length; j++)
					{
						if(typeId === deviceTypeList[j].id) {
							deviceListAll[i].deviceTypeName = deviceTypeList[j].name;
							deviceListAll[i].programId = deviceTypeList[j].programId;
							break;
						}
					}
				}
				deviceTypeName = deviceListAll[i].deviceTypeName.toLowerCase();
				for(j=0; j < g_deviceTypesReplacementsDeviceType.length; j++)
				{
					if(g_deviceTypesReplacementsDeviceType[j].deviceTypeName.toLowerCase() === deviceTypeName) {
						//custom Web page found
						content = "<div style=\"display: inline-block;width:" + g_deviceTypesReplacementsDeviceType[j].width;
						content += "px;height:" + g_deviceTypesReplacementsDeviceType[j].height + "px;\">";
						content += "<iframe src=\"" + g_deviceTypesReplacementsDeviceType[j].url + "?device=" + deviceListAll[i].name + "&embedded=true\" scrolling=\"no\" FrameBorder=\"0\" width=\"";
						content += (g_deviceTypesReplacementsDeviceType[j].width + 50).toString() +"\"";
						content += " height=\"100%\"></iframe></div>";
						if(element !== null) {
							element.innerHTML = content;
							element.className = "planningPaneDetailsIframeShow";
							
						}
						return;
					}
				}
				for(j=0; j < g_deviceTypesReplacementsProgramId.length; j++)
				{
					deviceProgramId = deviceListAll[i].programId.toLowerCase();
					deviceProgramId1 = g_deviceTypesReplacementsProgramId[j].programId.toLowerCase();
					deviceProgramIds = deviceProgramId.split(":");
					deviceProgramIds1 = deviceProgramId1.split(":");
					if(deviceProgramIds.length === deviceProgramIds1.length) {
						count = deviceProgramIds.length - 1;
						if(g_deviceTypesReplacementsProgramId[j].allVersions) {
							count ++;
						}
						match = true;
						for(k=0; k < count; k++)
						{
							if(deviceProgramIds[k] !== deviceProgramIds1[k]) {
								match = false;
								break;
							}
						}
						if(match) {
							//custom Web page found
							content = "<div style=\"display: inline-block;width:" + g_deviceTypesReplacementsProgramId[j].width;
							content += "px;height:" + g_deviceTypesReplacementsProgramId[j].height + "px;\">";
							content += "<iframe src=\"" + g_deviceTypesReplacementsProgramId[j].url + "?device=" + deviceListAll[i].name + "&embedded=true\" scrolling=\"no\" FrameBorder=\"0\" width=\"";
							content += (g_deviceTypesReplacementsProgramId[j].width + 50).toString() +"\"";
							content += " height=\"100%\"></iframe></div>";
							if(element !== null) {
								element.innerHTML = content;
								element.className = "planningPaneDetailsIframeShow";
								
								
							}
							return;
						}
					}
				}
				/*
				// didn't find a custom dashboard so use default
				element = document.getElementById("planningPaneDetails");
				if(element !== null) {
					element.style.marginLeft = "30px";
				}
				*/
				//get datapoint list and call showDashboard
				deviceDpList = [];
				g_bBuildDashboardDps = true; 
				if(g_bShowAlarms) {
					obj = {};
					obj.mode = 12;
					obj.deviceName = deviceName;
					obj.deviceId = deviceListAll[i].id;
					getPlanningGetAlarmsForDevice(obj);
				}
				else
					showDashboard(1, deviceName, deviceListAll[i].id);
			}
		}
	}
	catch {}
}
function getPlanningGetAlarmsForDevice(mode) {
	var	url = "";
	try {
	if(mode !== null)
		url = "https://" + location.hostname + "/iap/alarms/device/" + mode.deviceId;
		requestGetData(mode, url, getPlanningGetAlarmsForDeviceResponse, getPlanningGetAlarmsForDeviceFailCallback);
	}
	catch {}

}
function getPlanningGetAlarmsForDeviceResponse(mode, requestUrlString, json) {
	try {
		var i, j, k, url, z = -1, json1 = [],type,details,datapointPath, iPtr, iPtr1, obj,obj1;
		if(json !== null) {
			// determine datapoints path
			for(i=0; i < json.length; i++) 
			{
				if(json[i].alarmTargetType === "DEVICE") {
					json1.push(JSON.parse(JSON.stringify(json[i])))
					
					z = json1.length - 1;
					type = json1[z].type;
					details = json[z].details;
					json[i].pathname = "";
					json[i].warningLevel = 0;
					json[i].warningMessage = "";
					json[i].warningValue = "";
					iPtr = details.indexOf(" limit");
					if(iPtr > 1) {
						json[i].warningMessage = details.substr(0, iPtr);
						if(json[i].warningMessage.toLowerCase().startsWith("high error"))
							json[i].warningLevel = 4
						else if(json[i].warningMessage.toLowerCase().startsWith("high warning"))
							json[i].warningLevel = 3
						else if(json[i].warningMessage.toLowerCase().startsWith("low error"))
							json[i].warningLevel = 1
						else if(json[i].warningMessage.toLowerCase().startsWith("low warning"))
							json[i].warningLevel = 2
						iPtr = details.indexOf("\"");
						if(iPtr !== -1) {
						//iPtr += " limit ".length;
							iPtr1 = details.indexOf(" exceeded for ");
							if(iPtr1 !== -1) {
								json[i].warningValue = details.substr(iPtr, iPtr1-iPtr);
							}
						}

						if(json[i].warningLevel > 0) {
							
							datapointPath = "";
							iPtr1 = details.indexOf("exceeded for ");
							if(iPtr1 !== -1) {
								iPtr1 += "exceeded for ".length + 1;
								iPtr1 = details.indexOf(" ",iPtr1);
								if(iPtr1 !== -1) {
									iPtr1 ++;
									iPtr = details.lastIndexOf(". Triggered value is ")
									if(iPtr > 0) {
										datapointPath = details.substr(iPtr1, (iPtr - iPtr1));
										iPtr = 0;
										// replace "." with "/" note iox and CT uses "." so only replace last three "."
										for(j=0; j < 3; j++)
										{
											if(j=== 0)
												iPtr = datapointPath.lastIndexOf(".");
											else if(j=== 1)
												iPtr = datapointPath.lastIndexOf(" ",iPtr);
											else
												iPtr = datapointPath.lastIndexOf(".",iPtr);
											if(iPtr !== -1) {
												datapointPath = datapointPath.substr(0, iPtr) + "/" + datapointPath.substr(iPtr + 1);
												iPtr--;
											}
										}
									}
	
								}
							}
							json[i].pathname = datapointPath;
						}
					}
					if(json1.length > 0) {
						z = -1;
						// look for device
						for(j=0; j < g_deviceAlarmsList.length; j++)
						{
							if(g_deviceAlarmsList[j].deviceId === mode.deviceId) {
								for(k=0; k < g_deviceAlarmsList[j].alarms.length; k++)
								{
									if(g_deviceAlarmsList[j].alarms[k].pathname  === json[i].pathname) {
										g_deviceAlarmsList[j].alarms[k] = JSON.parse(JSON.stringify(json[i]));
										z = k;
									}
								}
								if(z === -1) {
									g_deviceAlarmsList[j].alarms.push(JSON.parse(JSON.stringify(json[i])));
								}
								z = j;
								break;
							}
						}
						if(z === -1){
							obj = {};
							obj.deviceId = mode.deviceId;
							obj.deviceName = mode.deviceName;
							obj.alarms = [];
							obj.alarms.push(JSON.parse(JSON.stringify(json[i])));
							g_deviceAlarmsList.push(obj);
						}
					}

				}
			}
			
		}
	}
	catch {}
	if(mode !== null) {
		if(mode.mode !== 55) {
			// contexts can have more than one device, dashboards has only one device
			if((mode.mode === 11) || (mode.mode === 12)) {
				if(g_sContextDpQualifierDeviceList.length > 0) { 
					obj1 = g_sContextDpQualifierDeviceList[0];
					g_sContextDpQualifierDeviceList.shift();
					obj = {};
					obj.mode = 11;
					obj.deviceName = obj1.deviceName;
					obj.deviceId = obj1.deviceId;
					getPlanningGetAlarmsForDevice(obj);
					return;
				}
			}
			if(mode.mode === 11) {
				url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sContextDpQualifierList + "/*?noxs=true";
				requestGetData(0, url, getPlanningContextDpsListResponse, null);
			}
			else
				showDashboard(1, mode.deviceName, mode.deviceId);
		}
	}
}
function getPlanningGetAlarmsForDeviceFailCallback(mode, requestUrlString, json) {
	try {
		var url;
		if(mode !== null) {
			// contexts can have more than one device, dashboards has only one device
			if(typeof mode.mode !== "undefined") {
				if((mode.mode === 11) || (mode.mode === 12)) {
					if(g_sContextDpQualifierDeviceList.length > 0) {
						obj1 = g_sContextDpQualifierDeviceList[0];
						g_sContextDpQualifierDeviceList.shift();
						obj = {};
						obj.mode = 11;
						obj.deviceName = obj1.deviceName;
						obj.deviceId = obj1.deviceId;
						getPlanningGetAlarmsForDevice(obj);
						return;
					}
					
				}
				if(mode.mode === 11) {
					url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sContextDpQualifierList + "/*?noxs=true";
					requestGetData(0, url, getPlanningContextDpsListResponse, null);
				}
				else
					showDashboard(1, mode.deviceName, mode.deviceId);
			}
		}
	}
	catch {}
}

function getplanningTreeShowTree(mode) {
//planningContext, planningContextRoot
	var paneContent = "", temp = "";
	var i,j, k;
	var tempStr;
	var sidebar = null;
	try{
		if(planningList.length > 0) {
			//no planning contexts so add site in tree with only devices list
			planningList = getPlanningTreeInitializePlanningList(mode, planningList, "", 0);
		}
		paneContent = getplanningTreeShowTreeContext(planningList, 0) + "<br><br>";
		
		
	}
	catch {}
	
	// tree
	temp  = "<div>";
	temp += "<button id=\"planningTreeShowDevicesButton\" class=\"planningTreeShowDevicesButton\" onclick=\"planningExpandDevicesNodeInTree()\">";
	if(g_bPlanningShowDevice)
		temp += "Show All Devices"
	else 
		temp += "Hide All Devices"
	temp += "</button>";
	//temp += "<button onclick=\"showPlanningRefresh(0)\" style=\"margin-left:10px\">Refresh All</button><br><br>";
	temp += "</div>"
	////paneTitle += "<div id=\"planningContextDetailsDiv\" style=\"display:inline-block;float:right;margin-left:300px\"></div>";
	//document.getElementById("main-Header").innerHTML = paneTitle;

	//paneContent = "<div style=\"display:flex\"><div id=\"treeDiv\" style=\"float:left;border: 1px black; white-space:nowrap; overflow:auto\">" + paneContent;
	


	paneContent = "<div style=\"display:flex\"><div id=\"treeDiv\">" + temp + "<div id=\"treeDivTreeResize\" style=\"position:relative\"><div id=\"treeDivTree\" onmousedown=\"treeDivTreeMouseDownEvent(this)\" onmouseup=\"treeDivTreeMouseUpEvent(this)\">" + paneContent + "</div>";
	
	// add resize divs
	paneContent += "<div id=\"treeDivResizeRightDiv\" class=\"resizeRightDiv\" onmousedown=\"mouseDownTreeResizeRightHandler(event)\"></div>";
	paneContent += "<div id=\"treeDivResizeBottomDiv\" class=\"resizeBottomDiv\" onmousedown=\"mouseDownTreeResizeBottomHandler(event)\"></div>";
	paneContent += "</div>";
	paneContent += '<br>Legend:<br>';
	paneContent +='<span class="dot" style="background-color:lawngreen"></span> Device Up';
	paneContent += '<br><span class="dot" style="background-color:red"></span> All Devices Down';
	paneContent += '<br><span class="dot" style="background-color:yellow"></span> Some Devices Down';
	paneContent += '<br><span class="dot" style="background-color:cyan"></span> Device Provisioning';
	paneContent += '<br><span class="dot" style="background-color:blue"></span> Device Unprovisioned';
	paneContent += '<br><span class="dot" style="background-color:#BA55D3"></span> Device Not Licensed';
	paneContent += "</div>";
	// may add back		paneContent += "<div class=\"verticalline\"></div>";
	paneContent += "<div id=\"planningPaneDetails\" class=\"planningPaneDetailsShow\">";
	paneContent += "No Contexts Selected</div>"
	paneContent += "</div>"
	paneContent += addTopButton();
	document.getElementById("main").innerHTML = paneContent;
	var iDivWidth = document.getElementById("treeDivTree").offsetWidth;
	//document.getElementById("treeDivTree").style.minWidth = iDivWidth + "px"; 
	document.getElementById("treeDivTree").style.width = iDivWidth + "px"; 
	treeviewNodesCollapseNodesInInialCollapseList();
	treeviewSitesPaneContent();
	// adding context to devicesList
	if(planningList.length > 0) {
		if(mode === 0) {
			if(g_iSmartServerVersion >= 280000) {
				try {
					for(i=0; i < deviceList.length; i++)
					{
						if(deviceList[i].contextStr === null) {
							tempStr = "";
							if(!(typeof deviceList[i].contexts === "undefined")) {
								for(k=0; k < deviceList[i].contexts.length; k++)
								{
									for(j=0; j < contextList.length; j++) 
									{
										if(contextList[j].id === deviceList[i].contexts[k]) {
											if(tempStr !== "")
												tempStr += "<br>"
											tempStr += contextList[j].name; //contextList[j].path;
											break;
										}
									}
									
								}
								deviceList[i].contextStr = tempStr;
							}
						}
					}
				}
				catch
				{
					
				}
			}
		}
	}
}
function getplanningTreeShowTreeContext(json, level) {
	var result = null;
	if(g_bPlanningTreeShowDatapointNodes) {
		g_treeviewInitialCollapseList = [];
		result =  getplanningTreeShowTreeContextBuilderWithDatapoints(json, -1, null, level,false);
		
	}
	else
		result =  getplanningTreeShowTreeContextBuilderWithDevices(json, level,false);
	
	
	return result;
}
function getplanningTreeShowTreeContextBuilderWithDatapoints(json, devicesId, deviceList, level, bLastChild) {
	// This is the main code for building Planning Tree with Devices, FBs and datapoints in tree.
	// devicesId: this is the previous context id used for the tree
	var sResult = "", sResult1 = "";
	var i,j, k, index, len, obj;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0, iUnLicensed = 0;
	var devicesNoContext = [],devicesPByProgramIdList;
	var bContinue = false;
	
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
			sResult = "<ul class=\"treeul\">";  // may have a problem with two campuses
			if(planningList.length > 0) {
				for(i=0; i < deviceListAll.length; i++)
				{
					if(deviceListAll[i].contexts.length === 0) {
						// later on test if hidden
						devicesNoContext.push(JSON.parse(JSON.stringify(deviceListAll[i])));
					}
				}
			}
			else 
				devicesNoContext = deviceListAll;

		}
		else {
			if(bLastChild)
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		if(planningList.length > 0) {
			if(devicesId !== -1) {// add devices node
				// device status count
				sResult1 = "";
				if(deviceList.length > 0) {
					//sResult1 += " [" + json[i].devices.length + " Devices]";
					sResult1 += " [" + deviceList.length + "]";
					if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
						sResult1 += "<span id=\"planningTreeContextDeviceStatus_" + devicesId + "\">"
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
						for(k=0; k < deviceList.length; k++)
						{
							if(deviceList[k].status.state === "provisioned") {
								if(deviceList[k].status.health === "normal")
									iUp ++;
								else {
									if(deviceList[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else if(deviceList[k].status.state === "unlicensed")
									iUnLicensed ++;
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === deviceList.length))
							sResult1 += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult1 += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult1 += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
						sResult1 += "</span>";
					}
				}


				sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
				sResult += "<button id=\"treeDevicesButton_" + devicesId + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				g_treeviewInitialCollapseList.push("treeDevicesButton_" + devicesId); // used to initially collapse all devices and device nodes 
				sResult += "<a class=\"context-devices\" href=\"#\"></a>";
				sResult += "<span id=\"planningTreeContext_Devices_" + devicesId + "\" onclick=\"treeviewShowContextDevicesInDetailsPane('Devices_" + devicesId + "')\">Devices" + sResult1 + "</span></p>";
				sResult += "<ul id=\"treeblocks_" + devicesId + "\" class=\"treeul treeviewNested treeviewActive\">";
				if(deviceList !== null) {
					for(j=0; j < deviceList.length; j++)
					{
						sResult += "<li class=\"treeli";
						if(j === (deviceList.length - 1))
							sResult += " treeviewLiActive";
						sResult += "\"><p>";
						if(deviceList[j].category === "SC") 
							sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
						else {
							//sResult += "<button id=\"treeDeviceButton_" + deviceList[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + deviceList[j].id +  "','" + deviceList[j].name  + "')\"></button>";
							sResult += "<button id=\"treeDeviceButton_" + deviceList[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + deviceList[j].id +  "','" + deviceList[j].name  + "')\"></button>";
							g_treeviewInitialCollapseList.push("treeDeviceButton_" + deviceList[j].id); // used to initially collapse all devices and device nodes 
						}

				
						sResult += treeviewAddDeviceStatusDot("deviceStatus_" + deviceList[j].id, deviceList[j].name, deviceList[j].status.state , deviceList[j].status.health, deviceList[j].category);
						sResult += "<span id=\"planningTreeContext_Device_" + deviceList[j].id;
						//sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + deviceList[j].id + "', '" + deviceList[j].name + "')\">";
						sResult += "\" onclick=\"getPlanningTreeShowDashboard(0, 'Device_" + deviceList[j].id + "', '" + deviceList[j].name + "')\">"; // changed 4/20/22
						sResult += deviceList[j].name + "</span></p>"
						sResult += "<ul id=\"treeblocks_Device_" + deviceList[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
						if(j === (deviceList.length - 1))
							sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
						sResult += ">";
						sResult += "</ul></li>";
					}
				}
				sResult += "</ul>";
				sResult += "</li>";
				
			}
			
			for(i=0; i < json.length; i++)
			{
				
				if(json[i].children.length > 0) { 
					
					
					// sort children
					if(json[i].children.length === 1)
						bContinue = false;
					else
						bContinue = true;
					while(bContinue)
					{
						bContinue = false;
						len = json[i].children.length - 1;
						for(k=0; k < len; k++)
						{
							if(json[i].children[k].name.toLowerCase() > json[i].children[k + 1].name.toLowerCase()) {
								bContinue = true;
								obj = {};
								obj = JSON.parse(JSON.stringify(json[i].children[k]));
								json[i].children[k] = JSON.parse(JSON.stringify(json[i].children[k + 1]));
								json[i].children[k + 1] = obj;
							}
						}
					}

					//if(i === lastIndex) {
					if( (i === lastIndex) && (((level === 1) && (devicesNoContext.length === 0) && !g_bShowCalendar) || (level !== 1))) {
						
						sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
						bLastChild = true;
					}
					else 
						sResult += "<li class=\"treeli treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					switch(json[i].contextType.toLowerCase()) {
						case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
						case "building": sResult += "<a class=\"context-building\" href=\"#\"></a>"; break;
						case "floor": sResult += "<a class=\"context-floor\"  href=\"#\"></a>"; break;
						case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
						case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
					}
					sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
					
					sResult += "</span></p>";
					devicesId = -1;
					if(json[i].devices.length > 0)
						devicesId = json[i].id;
					sResult += getplanningTreeShowTreeContextBuilderWithDatapoints(json[i].children, devicesId, json[i].devices, level, bLastChild);
					sResult += "</li>";
				}
				else if ((json[i].devices.length > 0) && (checkIfUserTypeSupported(g_bShowDevicesInTree))) {
					// no child contexts but has devices
					if(i === lastIndex) {
						sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
						bLastChild = true;
					}
					else  
						sResult += "<li class=\"treeli treeviewLiActive\" ><p>";
					sResult += "<button id=\"treeContextButton_" + json[i].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					
					switch(json[i].contextType.toLowerCase()) {
						case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
						case "building": sResult += "<a class=\"context-building\"  href=\"#\"></a>"; break;
						case "floor": sResult += "<a class=\"context-floor\" href=\"#\"></a>"; break;
						case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
						case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
					}
					sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
					sResult1 = "";
					if(json[i].devices.length > 0) {
						sResult1 += "   [" + json[i].devices.length + "]";
						if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
							sResult1 += "<span id=\"planningTreeContextDeviceStatus_" + json[i].id + "\">"
							iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
							for(k=0; k < json[i].devices.length; k++)
							{
								if(json[i].devices[k].status.state === "provisioned") {
									if(json[i].devices[k].status.health === "normal")
										iUp ++;
									else {
										if(json[i].devices[k].category === "SC")
											iUp ++;
										else 
											iDown ++;
									}
								}
								else if(json[i].devices[k].status.state === "provisioned")
									iUnLicensed ++;
								else
									iUnProvisioned ++;
							}
							if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
								sResult1 += '<span class="dot" style="background-color:red"></span>';
							else if(iDown > 0)
								sResult1 += '<span class="dot" style="background-color:yellow"></span>';
							if(iUnProvisioned > 0)
								sResult1 += '<span class="dot" style="background-color:blue"></span>';
							if(iUnLicensed > 0)
								sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
							sResult1 += "</span>";
						}
					}
					
					sResult += "</span></p>";
					
					// add devices node
					sResult += "<ul class=\"treeul treeviewNested  treeviewActive treeviewDevices\"";
					if(bLastChild)
						sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
					sResult += ">"
					sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
					sResult += "<button id=\"treeDevicesButton_" + json[i].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					g_treeviewInitialCollapseList.push("treeDevicesButton_" + json[i].id); // used to initially collapse all devices and device nodes 
					sResult += "<a class=\"context-devices\" href=\"#\"></a>";
					sResult += "<span id=\"planningTreeContext_Devices_" + json[i].id + "\" onclick=\"treeviewShowContextDevicesInDetailsPane('Devices_" + json[i].id + "')\">Devices" + sResult1 + "</span></p>";
					sResult += "<ul id=\"treeblocks_" + json[i].id + "\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";
					// add device list to tree
					
					for(j=0; j < json[i].devices.length; j++)
					{
						sResult += "<li class=\"treeli treeviewLiActive\"><p style=\"padding-left:5px\">";
						/* remove for navtree
						if(json[i].devices[j].category === "SC") 
							sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
						else {
							//sResult += "<button id=\"treeDeviceButton_" + json[i].devices[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + json[i].devices[j].id +  "','" + json[i].devices[j].name  + "')\"></button>";
							sResult += "<button id=\"treeDeviceButton_" + json[i].devices[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + json[i].devices[j].id +  "','" + json[i].devices[j].name  + "')\"></button>";
							g_treeviewInitialCollapseList.push("treeDeviceButton_" + json[i].devices[j].id); // used to initially collapse all devices and device nodes 
						}
						*/
						
						sResult += treeviewAddDeviceStatusDot("deviceStatus_" + json[i].devices[j].id, json[i].devices[j].name, json[i].devices[j].status.state , json[i].devices[j].status.health, json[i].devices[j].category);
						sResult += "<span id=\"planningTreeContext_Device_" + json[i].devices[j].id + "\"";
						sResult += "\" onclick=\"getPlanningTreeShowDashboard(0, 'Device_" + json[i].devices[j].id + "', '" + json[i].devices[j].name + "')\">";
						// remove for navtree sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + json[i].devices[j].id + "', '" + json[i].devices[j].name + "')\">";
						
						sResult += json[i].devices[j].name + "</span></p>"
						sResult += "<ul id=\"treeblocks_Device_" + json[i].devices[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
						if(j === (json[i].devices.length - 1)) 
							sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
						sResult += ">";
						sResult += "</ul></li>";
					}
					
					sResult += "</ul>";
					sResult += "</li></ul>";
						
					
					sResult += "</li>";
				}
				else { 
					// no child contexts and no devices
					sResult += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					sResult += "<span class=\"treeviewSpanNoChildren\"></span>";
					switch(json[i].contextType.toLowerCase()) {
						case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
						case "building": sResult += "<a class=\"context-building\"  href=\"#\"></a>"; break;
						case "floor": sResult += "<a class=\"context-floor\" href=\"#\"></a>"; break;
						case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
						case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
					}
					sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
					sResult += "</span></p>";
					sResult += "</li>";
				}

			} // for(i=0; i < json.length; i++)
		} // if(planningList.length > 0)
		if(level === 1) {
			// add unassinged devices - devices with no context assigned
			g_bShowDeviceListBasedOnProgramId = false;
			if(g_bShowUnassignedDevicesInTree) {
				if(devicesNoContext.length > 0) {
					if(planningList.length > 0) {
						sResult1 = "";
						if(devicesNoContext.length > 0) {
							sResult1 += "   [" + devicesNoContext.length + "]";
							if(g_bShowDeviceStatusInTree) {
								sResult1 += "<span id=\"planningTreeContextDeviceStatus__NoContext\">"
								iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
								for(k=0; k < devicesNoContext.length; k++)
								{
									if(devicesNoContext[k].status.state === "provisioned") {
										if(devicesNoContext[k].status.health === "normal")
											iUp ++;
										else {
											if(devicesNoContext[k].category === "SC")
												iUp ++;
											else 
												iDown ++;
										}
									}
									else if(devicesNoContext[k].status.state === "unlicensed")
										iUnLicensed ++;
									else 
										iUnProvisioned ++;
								}
								if((iDown > 0) && ((iDown + iUnProvisioned) === devicesNoContext.length))
									sResult1 += '<span class="dot" style="background-color:red"></span>';
								else if(iDown > 0)
									sResult1 += '<span class="dot" style="background-color:yellow"></span>';
								if(iUnProvisioned > 0)
									sResult1 += '<span class="dot" style="background-color:blue"></span>';
								if(iUnLicensed > 0)
									sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
								sResult1 += "</span>";
							}
						}



						if(g_bShowCalendar)
							sResult += "<li class=\"treeli treeviewLiActive\" ><p>";
						else
							sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
						sResult += "<button id=\"treeContextButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
						sResult += "<span id=\"planningTreeContext__NoContext\" onclick=\"getPlanningTreeShowTreeDetails(0, '_NoContext')\">Un-assigned Devices" + sResult1;
						sResult += "</span></p>";
	//navtree remove??					g_treeviewInitialCollapseList.push("planningTreeContext__NoContext"); // used to initially collapse all devices and device nodes navtree not sure this works
						// add devices node
						sResult += "<ul class=\"treeul treeviewNested  treeviewActive treeviewDevices\"";
						//if(bLastChild)
						if(!g_bShowCalendar)
							sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
						sResult += ">"
					}

					bContinue = false;
					
					devicesPByProgramIdList = [];
					obj = {};
					if(g_bShowDeviceListBasedOnProgramId) {
						obj = sortDeviceList(0,devicesNoContext);
						if(obj.valid) {
							devicesPByProgramIdList = JSON.parse(JSON.stringify(obj.deviceList));
							bContinue = true;
						}
					}
					if(bContinue) {
						// device programId list
						sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
						sResult += "<button id=\"treeDevicesButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
						g_treeviewInitialCollapseList.push("treeDevicesButton__NoContext"); // used to initially collapse all devices and device nodes 
						sResult += "<a class=\"context-devices\" href=\"#\"></a>";
						sResult += "<span id=\"planningTreeContext_Devices__NoContext" + "\" onclick=\"treeviewShowContextDevicesInDetailsPane('_NoContext')\">Device Types</span></p>";
						sResult += "<ul id=\"treeblocks_NoContext\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";


						for(k=0; k < devicesPByProgramIdList.length; k++)
						{
							sResult1 = devicesPByProgramIdList[k].deviceTypeName + " [" + devicesPByProgramIdList[k].deviceList.length + "]";

							if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
								sResult1 += "<span id=\"planningTreeContextDeviceStatus__NoContext\">"
								iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
								for(j=0; j < devicesPByProgramIdList[k].deviceList.length; j++)
								{
									if(devicesPByProgramIdList[k].deviceList[j].status.state === "provisioned") {
										if(devicesPByProgramIdList[k].deviceList[j].status.health === "normal")
											iUp ++;
										else {
											if(devicesPByProgramIdList[k].deviceList[j].category === "SC")
												iUp ++;
											else 
												iDown ++;
										}
									}
									else if(devicesPByProgramIdList[k].deviceList[j].status.state === "unlicensed")
										iUnLicensed ++;
									else 
										iUnProvisioned ++;
								}
								if((iDown > 0) && ((iDown + iUnProvisioned) === devicesPByProgramIdList[k].deviceList.length))
									sResult1 += '<span class="dot" style="background-color:red"></span>';
								else if(iDown > 0)
									sResult1 += '<span class="dot" style="background-color:yellow"></span>';
								if(iUnProvisioned > 0)
									sResult1 += '<span class="dot" style="background-color:blue"></span>';
								if(iUnLicensed > 0)
									sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
								sResult1 += "</span>";
							}



							sResult += "<li class=\"treeli treeviewLiActive treeviewDevices\"><p>";
							sResult += "<button id=\"treeDevicesButton__NoContext\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
							g_treeviewInitialCollapseList.push("treeDevicesButton__NoContext"); // used to initially collapse all devices and device nodes 
							sResult += "<a class=\"context-devices\" href=\"#\"></a>";
							sResult += "<span id=\"planningTreeContext_Devices__NoContext" + "\" onclick=\"treeviewShowContextDevicesInDetailsPane('_NoContext')\">" + sResult1 + "</span></p>";
							sResult += "<ul id=\"treeblocks_NoContext\" class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";
							for(j=0; j < devicesPByProgramIdList[k].deviceList.length; j++)
							{ 
								sResult += "<li class=\"treeli treeviewLiActive\"><p style=\"padding-left:5px\">";
								sResult += treeviewAddDeviceStatusDot("deviceStatus_" + devicesPByProgramIdList[k].deviceList[j].id, devicesPByProgramIdList[k].deviceList[j].name, 
									devicesPByProgramIdList[k].deviceList[j].status.state , devicesPByProgramIdList[k].deviceList[j].status.health, devicesPByProgramIdList[k].deviceList[j].category);
								sResult += "<span id=\"planningTreeContext_Device_" + devicesPByProgramIdList[k].deviceList[j].id + "\"";
								sResult += "\" onclick=\"getPlanningTreeShowDashboard(0, 'Device_" + devicesPByProgramIdList[k].deviceList[j].id + "', '" + devicesPByProgramIdList[k].deviceList[j].name + "')\">";
								// remove navtree sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + devicesNoContext[j].id + "', '" + devicesNoContext[j].name + "')\">";
								
								sResult += devicesPByProgramIdList[k].deviceList[j].name + "</span></p>"
								sResult += "<ul id=\"treeblocks_Device_" + devicesPByProgramIdList[k].deviceList[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
								if(j === (devicesPByProgramIdList[k].deviceList.length - 1)) 
									sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
								sResult += ">";
								sResult += "</ul></li>";
							}
							sResult += "</ul>";
							sResult += "</li>";
						}
						sResult += "</ul>";
						sResult += "</li>";

					}
					else {
						// one big device list
						for(j=0; j < devicesNoContext.length; j++)
						{
							sResult += "<li class=\"treeli treeviewLiActive\"><p style=\"padding-left:5px\">";
							/* remove for navtree
							
							if(devicesNoContext[j].category === "SC") 
								sResult += "<span class=\"treeviewSpanNoChildrenSegmentController\"></span>";
							else {
								//sResult += "<button id=\"treeDeviceButton_" + devicesNoContext[j].id + "\" class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + devicesNoContext[j].id +  "','" + devicesNoContext[j].name  + "')\"></button>";
								sResult += "<button id=\"treeDeviceButton_" + devicesNoContext[j].id + "\" class=\"treeviewCaret\" onclick=\"treeviewToggle1(this,'treeblocks_Device_" + devicesNoContext[j].id +  "','" + devicesNoContext[j].name  + "')\"></button>";
								g_treeviewInitialCollapseList.push("treeDeviceButton_" + devicesNoContext[j].id); // used to initially collapse all devices and device nodes 
							}
							*/
							sResult += treeviewAddDeviceStatusDot("deviceStatus_" + devicesNoContext[j].id, devicesNoContext[j].name, devicesNoContext[j].status.state , devicesNoContext[j].status.health, devicesNoContext[j].category);
							sResult += "<span id=\"planningTreeContext_Device_" + devicesNoContext[j].id + "\"";
							sResult += "\" onclick=\"getPlanningTreeShowDashboard(0, 'Device_" + devicesNoContext[j].id + "', '" + devicesNoContext[j].name + "')\">";
							// remove navtree sResult += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + devicesNoContext[j].id + "', '" + devicesNoContext[j].name + "')\">";
							
							sResult += devicesNoContext[j].name + "</span></p>"
							sResult += "<ul id=\"treeblocks_Device_" + devicesNoContext[j].id + "\" class=\"treeul treeviewNested treeviewActive\"";
							if(j === (devicesNoContext.length - 1)) 
								sResult += " style=\"border-left: 3px solid white;margin-left: -18px;\"";
							sResult += ">";
							sResult += "</ul></li>";
						}
					}
						
					if(planningList.length > 0)
						sResult += "</ul></li>";
				}
			} //g_bShowUnassignedDevicesInTree
			if(g_bShowCalendar) {
				sResult += "<li class=\"treeli\" ><p style=\"padding-left:30px\">";
				// navtree remove sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p>";
				sResult += "<img src=\"images/navtree/calendarIcon1.png\">"; //sResult += "<a class=\"context-schedule\" href=\"#\"></a>";
				sResult += "<span id=\"planningTreeContext__TreeSchedules\" onclick=\"showPlanningTreeCalendar(0)\" style=\"margin-left:10px\">Schedules</span></p></li>";
			}
		}
		sResult += "</ul>";
	} catch (err) {
		 sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult1 = "Sites";
		if(json.length === 0)
			sResult1 = "Site";
		sResult = "<span id=\"planningTreeContext___sites__\"  onclick=\"getPlanningTreeShowTreeDetails(0, '__sites__')\">" + sResult1 + "</span><br>" + sResult; //"Sites<br><div style=\"padding-left:17px\">" + sResult + "</div>"; 
	}
	return sResult;
}

function getplanningTreeShowTreeContextBuilderWithDevices(json, level, bLastChild) {
	// This is the main code for building Planning Tree which shows devices in detail pane but not in the tree
	var sResult = "";
	var i,j, k, index, len, obj;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0, iUnLicensed = 0;
	var bContinue = false;
	
	try {
		level++;
		if(json === null)
			return "";
		var lastIndex = json.length - 1;
		if(level === 1) {
			//if(json.length === 1)
			//	sResult = "<ul style=\"border-left: 1px solid #366184;margin-left: -17px;\">"; // try height:8px;
			//else
				sResult = "<ul class=\"treeul\">";  // may have a problem with two campuses
		}
		else {
			//if((level === 2) && bLastChild)
			//	sResult = "<ul class=\"treeviewNested treeviewActive\" style=\"border-left: 1px solid #366184;height:0px\">"; // needed as issue on some display with Site line too long
			//else if(bLastChild)
			if(bLastChild)
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\" style=\"border-left: 3px solid white;margin-left: -18px;\">";

			else
				sResult = "<ul class=\"treeul treeviewNested treeviewActive\">";
		}
		bLastChild = false;
		
		for(i=0; i < json.length; i++)
		{
			if(json[i].children.length > 0) { 
				// sort children
				if(json[i].children.length === 1)
					bContinue = false;
				else
					bContinue = true;
				while(bContinue)
				{
					bContinue = false;
					len = json[i].children.length - 1;
					for(k=0; k < len; k++)
					{
						if(json[i].children[k].name.toLowerCase() > json[i].children[k + 1].name.toLowerCase()) {
							bContinue = true;
							obj = {};
							obj = JSON.parse(JSON.stringify(json[i].children[k]));
							json[i].children[k] = JSON.parse(JSON.stringify(json[i].children[k + 1]));
							json[i].children[k + 1] = obj;
						}
					}
				}


				if(i === lastIndex) {
					//sResult += "<li class=\"treeviewLiActive\" style=\"border-bottom:0px\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					sResult += "<li class=\"treeli treeviewLiActiveLastChild\" ><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
					bLastChild = true;
				}
				else 
					sResult += "<li class=\"treeli treeviewLiActive\"><p><button class=\"treeviewCaret treeviewCaret-down\" onclick=\"treeviewToggle(this)\"></button>";
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\" href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\"  href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				//sResult += "<img class=\"icon-context-type-building\" src=\"\" width=\"1\" height=\"1\">"; 
					//sResult += "<li class=\"icon1-context-type-building\"></li>";  // Test
					//sResult += "<span class=\"material-icons icon-context-type-building\"></span>";  // Test
				//sResult += "<span class=\"context-icons\">&#x00E;</span>";  // Test
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
				if(json[i].devices.length > 0) {
					sResult += " [" + json[i].devices.length + " Devices]";
					if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else if(json[i].devices[k].status.state === "provisioned")
									iUnLicensed ++;
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
					}
				}
				sResult += "</span></p>";
				sResult += getplanningTreeShowTreeContextBuilderWithDevices(json[i].children, level, bLastChild);
				sResult += "</li>";
			}
			else { 
				
				sResult += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
				switch(json[i].contextType.toLowerCase()) {
					case "campus": sResult += "<a class=\"context-campus\" href=\"#\"></a>"; break;
					case "building": sResult += "<a class=\"context-building\"  href=\"#\"></a>"; break;
					case "floor": sResult += "<a class=\"context-floor\" href=\"#\"></a>"; break;
					case "room": sResult += "<a class=\"context-room\"  href=\"#\"></a>"; break;
					case "area": sResult += "<a class=\"context-area\"  href=\"#\"></a>"; break;
				}
				sResult += "<span id=\"planningTreeContext_" + json[i].id + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].id + ")\">" + json[i].name;
				//sResult += "        (" + json[i].contextType.toLowerCase() + ")";
				if(json[i].devices.length > 0) {
					sResult += "   [" + json[i].devices.length + " Devices]";
					if(checkIfUserTypeSupported(g_bShowDeviceStatusInTree)) {
						iTotal = 0; iUp = 0; iProvisioned = 0; iUnProvisioned = 0; iDown = 0; iUnLicensed = 0;
						for(k=0; k < json[i].devices.length; k++)
						{
							if(json[i].devices[k].status.state === "provisioned") {
								if(json[i].devices[k].status.health === "normal")
									iUp ++;
								else {
									if(json[i].devices[k].category === "SC")
										iUp ++;
									else 
										iDown ++;
								}
							}
							else if(json[i].devices[k].status.state === "unlicensed")
									iUnLicensed ++;
							else 
								iUnProvisioned ++;
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === json[i].devices.length))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult1 += '<span class="dot" style="background-color:#BA55D3"></span>';
					}
				}
				sResult += "</span></p></li>";
			}
		}
		sResult += "</ul>";
	} catch { sResult = "<ul></ul>"; }
	if(level === 1) {
		sResult = "Sites<br>" + sResult; //"Sites<br><div style=\"padding-left:17px\">" + sResult + "</div>"; 
	}
	return sResult;
}
function getPlanningTreeShowDeviceDetails() {

}
function getPlanningTreeShowTreeDevices(id) {
	try {
		var sResult = "", i;
		var list = [];
		var bContinue = false;
		var json, json1;
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
		else {
			// sort
			
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			list = json["devices"];
			if(list.length === 0 ){
				document.getElementById("planningPaneDetails").innerHTML = "<br>" + json['path'] + "<br><br>No Devices";
			}
			else {
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "', '" + list[i].protocol  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					document.getElementById("planningPaneDetails").innerHTML = sResult;
					//sortTable(0); 
				}
				if(sResult !== "") {
					for(i = 0; i < list.length; i++)
					{
						deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category,list[i].deviceStatus);
						//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
					}
				}
			}
		}
	}
	catch {}
}
function getPlanningTreeShowTreeDatapoints(mode, id, programmaticPathname) {
	var json;
	var sResult = "";
	var sTemp;
	var bContinue = false;
	var sResults;
	var x, i;
	var treeContext = null;
	try {
		if(programmaticPathname === "")
			return;
		planningDpList = [];
		g_iPlanningPaneSelectedContextType = 2;
		planningMenuCancel();
		testDeviceCancel();
		if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
		g_sPlanningTreeDatapointPath = programmaticPathname; // only used for Devices and Datapoints nodes
		document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
		document.getElementById("planningRefreshButton").style.visibility = "hidden";
		if(mode === 0) {
			// change color of tree context to indicate selected
			if(g_iPlanningPaneSelectedContextId !== -1) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext !== null) {
					treeContext.classList.remove("treeSelected")
					//treeContext.style.color = "white";
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + id);
			if(treeContext !== null) {
				//treeContext.style.color = "red";
				treeContext.classList.add("treeSelected")
			}
		}
		g_iPlanningPaneSelectedContextId = id;
		document.getElementById("planningPaneDetails").innerHTML = "Getting Datapoint information...";
		getPlanningTreeShowTreeDatapointsRequest(0, programmaticPathname); 
		
	}
	catch {}
}
function getPlanningTreeShowTreeDatapointsRequest(mode, path) {
	try {
 		var url = "/iap/devs/*+name==";
		var iPtr = path.indexOf("/");
		var obj = {}; 
		if(mode > 0)
			path = g_sPlanningTreeDatapointPath;
		iPtr = path.indexOf("/");
		if(iPtr === -1) 
			url += path + "/if/*/*/*";
		else {
			url += path.substr(0, iPtr) + "/if" + path.substr(iPtr);
			url = encodeNameStr(url);
			if(g_iSmartServerVersion >= 320114) {
				iPtr = url.lastIndexOf("/");
				if(iPtr > 0) {
					iPtr ++;
					url = url.substr(0, iPtr) + "*+xifName==" + url.substr(iPtr);
				}
			}
			
		}
		url += "/*"
		if(mode === 3)
			url += "?max_age=0&noxs=true";
		else
			url += "?noxs=true";
		if(checkIfUserTypeSupported(g_useVisibilityFilter))
			url += "&visible=true";
		obj.mode = mode;
		obj.path = path;
		if(mode === 0)
			cursorSetWait();
 		requestGetData(obj, url, getPlanningTreeShowTreeDatapointsRequestDataResponse, getPlanningTreeRequestFailure);
	}
	catch (err) {}

}

function getPlanningTreeShowTreeDatapointsRequestProcessWebSocketData(mode, requestUrl, json) {
	var obj = {};
	obj.mode = mode;
	obj.path = g_sPlanningTreeDatapointPath;
	getPlanningTreeShowTreeDatapointsRequestDataResponse(obj, requestUrl, json);
}
function getPlanningTreeShowTreeDatapointsRequestDataResponse(obj, requestUrl, json) {
	// mode: 0=creat table, 1= 2=Websocket, 3= on demandfollowup request, 4=refresh [same as 0 but don't create table]
	// Table data
	try {
		
		var iPtr, i, j, z, index = 0;
		var buttonPathname = "", buttonProgrammaticPathname = "", pathname, protocol = "lon";
		var dpPath = "", value, valueStr, fullPath,z, lon_cfg, temp, id = -1, bRequestFollowupRead = false;
		var bDevice = false, bContinue = true, bContinue1 = false, timestamp1,local,utc, bHasPresets, name1, deviceName = "";
		var bSingleDp = false, sTemp = "";
		var element;
		var content = "<br><br><table id=\"myTable\"><thead><tr><th onclick=\"sortTable(0)\">#</th>";
		var path = obj.path;
		var mode = obj.mode;
		var newPath = path;
		var obj, bLonProtocol = false;;
		var d = new Date;
		var sortIndex = 0;
		var t = d.toTimeString();
		//var date = d.toLocaleDateString();
		//var dates = date.split("/");
		var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " ";//dates[2] + "-" + dates[1] + "-" +  dates[0] + " ";
		iPtr = t.indexOf(" ");
		t = t.substr(0, iPtr);
		currentTime += t;
		
		if(g_sPlanningTreeDatapointPath !== path)
			return;
		if(mode > 0) {
			if(planningDpList.length === 0)
				return;
		}
		if(json.length === 0) {
			if(mode === 0) {
				cursorClearWait();
			}
			document.getElementById("planningPaneDetails").innerHTML = "No Datapoints For this Device";
			return;
		}
		
		if(mode === 0) {
			g_bPlanningShowConfigurationSingleDp = false;
			content += "<th><div style=\"display:flex\"><input type=\"checkbox\" id=\"favoritesCheckbox\" onclick=\"planningFavoritesCheckbox()\">FAV</div></th>";
			content += "<th>Menu</th><th onclick=\"sortTable(3)\">Datapoint Path</th><th onclick=\"sortTable(4)\">Datapoint</th><th onclick=\"sortTable(5)\">Value</th>"; 
			content += "<th onclick=\"sortTable(4)\">Priority</th>";
			sortIndex = 5;
			bLonProtocol = false;
			if(json.length > 1) {
				if(typeof json[0]["lon.cfg"] !== "undefined") 
					bLonProtocol = true;
					
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Units</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Direction</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Type</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">XIF DP Path</th>";
				//content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">DP Properties (Device Type)</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Property</th>";
				if(bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Property For</th>";
				
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Read-only</th>"
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Rate</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Event</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Throttle</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Heartbeat</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor Threshold</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Monitor ReceiveTimeout</th>";
				if(bLonProtocol) {
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Throttle</th>";
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Heartbeat</th>";
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Propagation Threshold</th>";
				}
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Localization</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Presets</th>";
				if(bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Description</th>";
				if(!bLonProtocol)
					content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Default</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Initial Value</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Write Initial</th>";
				content += "<th class=\"tablePropertyHideCol tableHideCol\" onclick=\"sortTable(" + (++sortIndex).toString() + ")\">Interface</th>"

			}
			
			content += "</tr></thead><tbody>";
		}
		if(mode === 2) {
			for(i=0; i < json.length; i++)
			{ // check if in
				z = -1; 
				for(j=0; j < planningDpList.length; j++)
				{
					if(json[i].datapointQualifier === planningDpList[j].dpQualifier) {
						json[i].bProcess = true;
						json[i].dpPath = planningDpList[j].dpPath;
						json[i].dpName = planningDpList[j].dpName;
						json[i].pathname = planningDpList[j].pathname;
						json[i].block = planningDpList[j].block;
						json[i].programmaticPathname = planningDpList[j].programmaticPathname; 
						json[i].urlPath = planningDpList[j].urlPath;
						z = j;
						break;
					}
				}
				if(z === -1)
					json[i].bProcess = false;
			}
		}
		else {
			iPtr = path.indexOf("/");
			if(mode === 3) {
				mode = 1;
				bRequestFollowupRead = true;
			}
			
			if(iPtr === -1) {
				bDevice = true;
				
				
			}
			else {
				
			}
		}
		if(mode === 0) {
			planningDpList = [];
			temp = "";
			if(bDevice) {
				id = -1;
				for(i=0; i < deviceListAll.length; i++)
				{
					if(deviceListAll[i].name === path) {
						id = deviceListAll[i].id;
						newPath += " [" + deviceListAll[i].deviceTypeName + " (" + deviceListAll[i].protocol  + ")]";
						protocol = deviceListAll[i].protocol;
						deviceName = deviceListAll[i].name;
						break;
					}
				}
				temp = "<button onclick=\"showDashboard(1, '" + path + "', " + id + ")\" style=\"margin-left:0px\">Dashboard</button>";
			}
			else 
				temp = "<button onclick=\"planningshowDashboard()\" style=\"margin-left:0px\">Dashboard</button>";
			temp += "<button onclick=\"showDashboard(3,'Favorites',-1)\">FAV Dashboard</button>";
			if(bDevice)
				//temp += "<button  onclick=\"showDataLogForDevice('" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "',null)\">Logs</button>";
				temp += "<button  onclick=\"showDataLog3('" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "',null)\">Logs</button>";
			else if(json.length === 1) {
				buttonPathname = json[0].deviceName + "/" + json[0].blockName + "/" + json[0].blockIndex + "/";
				if(typeof json[0].name === "")
					buttonPathname +=  json[0].datapointName;
				if(json[0].name === null)
					buttonPathname +=  json[0].datapointName;
				else
					buttonPathname +=  json[0].name;
				buttonProgrammaticPathname = json[0].deviceName + "/" + json[0].blockName + "/" + json[0].blockIndex + "/" + json[0].datapointName;
				newPath = buttonPathname;
				temp += "<button onclick=\"showDataLog3('" + buttonPathname + "','" + buttonProgrammaticPathname + "',null)\">Logs</button>";
			}
			if(bDevice) {
				temp += "<button onclick=\"showDeviceDpsByDeviceName(0,'" + deviceName + "')\">Datapoints</button>";
			}
			else {
				temp += "<button  onclick=\"planningshowDpInShowDatapoints(0,'" + buttonPathname + "','" + buttonProgrammaticPathname + "')\">Datapoints</button>";
			}
			temp += "<button id=\"planningDpInfoButton\" "; 
			if(bDevice)
				temp += "onclick=\"showDpInfo1(1,'" + g_sPlanningTreeDatapointPath + "','" + g_sPlanningTreeDatapointPath + "')\"";
			else if(json.length === 1) {
				
				temp += "onclick=\"showDpInfo1(1,'" + buttonPathname + "','" + buttonProgrammaticPathname + "')\"";
			}
			temp += ">DP Info</button>"
			if(bDevice) {
				temp += "<button id=\"testButton_" + g_sPlanningTreeDatapointPath + "\" onclick=\"testDevice(6, this," + id + ", '" + g_sPlanningTreeDatapointPath + "')\">Test</button>";
				temp += "<button  onclick=\"winkDevice(" + id + ", '" + g_sPlanningTreeDatapointPath + "')\"";
				if(protocol !== "lon")
					temp += " disabled";
				temp += ">Wink</button>";
			} 
			if(json.length === 1) 
				temp += "<input type=\"checkbox\" id=\"planningConfigCheckbox\"  onchange=\"treeShowConfiguration()\"";
			else 
				temp += "<input type=\"checkbox\" id=\"planningConfigCheckbox\"  onchange=\"treeShowConfigurationAll()\"";
			if(g_bPlanningShowConfiguration) 
				temp += " checked";
			temp += ">Properties";
			
			temp += "<input type=\"checkbox\" id=\"planningPollCheckbox\"  onchange=\"planningPollCheckBox()\"";
			if(g_bPlanningDpPollingEnabled) 
				temp += " checked";
			temp += ">Poll";
			temp += "<input id=\"planningPollrate\" onchange=\"planningPollCheckBox()\" value=\"" + g_iPlanningPollInterval + "\" size=\"4\"></div>";
			temp += "<button onclick=\"getPlanningTreeShowTreeDatapointsRequest(3, '')\">On Demand</button>";
			temp += "<button onclick=\"subscribeRequest()\">Re-Subscribe</button>";
			
			temp += "<button onclick=\"getPlanningTreeShowTreeDatapointsRequest(1, '')\">Refresh</button>";
				// remove hiddencheckbox only in datapoints view temp += "<input type=\"checkbox\" id=\"hiddencheckbox\"  onchange=\"planningShowHiddenCheckBox()\"";
				//if(g_bPlanningDpPollingEnabled) 
				//	temp += " checked";
				//temp += ">Show Hidden DPs";
			
			
			content = newPath + "<br><br>" + temp + content; //json[0].deviceName + temp + content;
			
		}
			
		for(i=0; i < json.length; i++)
		{
			// a lot of the additions are for favorites view
			if(typeof json[i].values !== "undefined") {
				if(typeof json[i].values.level !== "undefined") {
					if(typeof json[i].values.level === "string") 
						json[i].values.level = Number(json[i].values.level);
				}
			}
			if(mode !== 2) {
				dpPath = json[i].blockName + "/" + json[i].blockIndex + "/"
				if(typeof json[i].name !== "undefined"){
					if(json[i].name !== null){
						dpPath += json[i].name;
					}
					else {
						dpPath += json[i].datapointName;
						json[i].name = json[i].datapointName;
					}
				}
				else {
					dpPath += json[i].datapointName;
					json[i].name = json[i].datapointName;
				}
				json[i].dpPath = dpPath;
				json[i].dpName = json[i].name;
				json[i].pathname = json[i].deviceName + "/" + dpPath;
				json[i].block = json[i].blockName + "/" + json[i].blockIndex;
				json[i].programmaticPathname = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName; 
				json[i].urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
				if(g_iSmartServerVersion >= 320114)
					json[i].urlPath += "*+xifName==";
				json[i].urlPath += json[i].datapointName;
				try {
					json[i].priority = json[i].values.level;
				}
				catch (err) {}
				
			}
			if(mode === 0) {
				try {
					json[i].priority = json[i].values.level;
				}
				catch (err) {}
				try { 
					if(!json[i].hasOwnProperty("hidden")) {
						json[i].hidden = false;
					}
					json[i].unit = "";
					if(json[i].hasOwnProperty("lon.cfg")) {
						lon_cfg = json[i]["lon.cfg"];
						json[i].unit = lon_cfg.unit;
						json[i].hidden = lon_cfg.hidden;
					}
				} catch (err) 	{
					json[i].unit = "";
					json[i].hidden = false;
				} 
			}
			if(typeof json[i].locValue === "number")
				json[i].valueStr = json[i].value.toString();
			else
				json[i].valueStr = JSON.stringify(json[i].value);
			try { 
				if(!(typeof json[i].locValue === "undefined")) {
					json[i].locValue = json[i].value; // GET request
					if(json[i].locValue !== null) {
						if(json[i].locValue !== "")
							if(typeof json[i].locValue === "number")
								json[i].locValueStr = json[i].locValue.toString();
							else
								json[i].locValueStr = JSON.stringify(json[i].locValue);
						}
						else 
							json[i].locValueStr = "";
					}
				else 
					json[i].locValueStr = "";
			} catch (err) {}
			
			try {
				if(typeof json[i].local === "undefined") {
					local = currentTime;
					utc = "";
				}
				else 
					local = json[i].local;

				timestamp1 = local;
				local = timestamp1;
				iPtr = timestamp1.lastIndexOf("[");
				if(iPtr > 0) {
					iPtr = timestamp1.lastIndexOf("-",iPtr);
					if(iPtr > 0) {
						timestamp1 = timestamp1.substr(0, iPtr);
						timestamp1 = timestamp1.replace(/T/g," ");
					}
				}
				json[i].timestampStr = timestamp1;
			}
			catch (err) {}
			try{
				if(typeof json[i].presetValue === "undefined")
					json[i].presetValue = "";
				else if (json[i].presetValue === null)
					json[i].presetValue = "";
			} catch(err) {}
			
			
			
		}
		
		if(mode === 0) {
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (json.length - 1); i++)
				{
					if(json[i].dpPath > json[i + 1].dpPath) {
						obj = {};
						obj = JSON.parse(JSON.stringify(json[i]));
						json[i] = JSON.parse(JSON.stringify(json[i + 1]));
						json[i + 1] = obj;
						bContinue = true;
					}
				}
			}
		}
		

		
		for(i=0; i < json.length; i++)
		{
			
			bContinue = false;
			
			dpPath = json[i].dpPath;
			if(mode === 2)
				bContinue = json[i].bProcess;
			else {
				if(bDevice) {
					if(json[i].deviceName === path) {
						bContinue = true;
					}
				}
				else {
					//fullPath = json[i].deviceName + "/" + dpPath;
					//if(fullPath === path)
					if(json[i].programmaticPathname === path)
						bContinue = true;
				}
			}


			if(bContinue) {

				valueStr = JSON.stringify(json[i].locValue);
				if(typeof json[i].presetValue === "undefined") {
					if(json[i].presetValue !== null)
						valueStr = json[i].presetValue;
				}
				
				if(mode === 0) {
					planningDpList.push(json[i]);
					index ++; // 3.2 supports hidden flag so don't show hidden datapoints
					content += "<tr><td>" + index.toString() + "</td>";
					pathname = json[i].pathname;
					z = -1;
					// check if dp already in favorites list
					for(j=0; j < favDpList.length; j++ )
					{
						if(json[i].pathname === favDpList[j]. pathname) {
							z = j;
							break;
						}
					}
					content += "<td><input type=\"checkbox\" id=\"fav_" + json[i].pathname + "\" onclick=\"addToFavorites1(1, '" + json[i].pathname + "')\"";
					if(z !== -1)
						content += " checked";
					content += "></td>";
					
					content += "<td><button id=\"dpMenu_" + json[i].pathname + "\" style=\"margin-left:5px;margin-right:5px;\" onclick=\"menuDp1(1, event, ";  // may need to ffixx
					content += "0, ";
					content += i + ", '" + json[i].pathname + "', '" + json[i].programmaticPathname + "')\">...</button></td>";
					
					content += "<td>" + dpPath + "</td><td>" + json[i].name + "</td><td>";
					if(json[i].cat === "out")
						content += "<div id=\"localValue_" + pathname + "\" class=\"treeTdValueDiv\">" + valueStr  + "</div>";
					else if(json[i].cat === "in") {   
						content += "<div class=\"treeTdValueWriteDiv\">";
						content += "<input id=\"localValue_" + pathname + "\" class=\"treeTdValueInput\" size=\"50\" "; 
						bHasPresets = false;
						if(typeof json[i].presets !== "undefined") {
							if(json[i].presets !== null) {
								if(json[i].presets.enabled) {
									if(json[i].presets.map.length > 0) {
										bHasPresets = true;
										content += " list='dpNewValuePresetList_" + pathname + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathname + "'>"
										for(k=0; k <json[i].presets.map.length; k++)
										{
											name1 = json[i].presets.map[k].name;
											content += "<option value='" + name1 + "'>"  + name1 + "</option>";
										}
										content += "<option value='" + valueStr + "'>Raw Value</option>";
										content += "</datalist>";
									}
								}
							} 
						}
						if(!bHasPresets) {
							content += " list='dpNewValuePresetList_" + pathname + "' value='" + valueStr + "'><datalist id='dpNewValuePresetList_" + pathname + "'>";
							content += "<option value='" + valueStr + "'>Raw Value</option>";
							content += "</datalist>";
						} 
						content += "<button style=\"margin-left:10px\" onclick=\"inputBoxSendValue1(1, this, event, " + i + ", '" + pathname + "')\">Send</button></div>";
					}
					content += "</td>";
					if(json[i].cat === "out") {
						content += '<td></td>';
					   // tablePaneContent += "<td><span id=\"priority_" + pathname + "\">" + dashboardDpList[i].priority + "</span></td>";
					}
					else { // in
						//content += "<td ><div style=\"display:flex\"><input id=\"priority_" + pathname + "\" value=\"" + json[i].priority + "\" size=\"3\">";
						content += "<td><div class=\"treeTdPriorityDiv\"><select id=\"priority_" + pathname + "\">";
						for(s=1; s < 17; s++)
						{
							content += "<option value=\"" + s + "\"";
							if(json[i].priority === s)
								content += " selected";
							content += ">" + s + "</option>";
						}
						content += "<option value=\"17\"";
						if(json[i].priority === 17)
							content += " selected";
						content += ">" + "Normal" + "</option>";
						content += "</select>"
						content += "<button id=\"dpValueMenu_" + pathname + "\" style=\"margin-left:10px\" onclick=\"menuDpValue1(13,this, " + i + ", '" + json[i].programmaticPathname + "')\">...</button></div></td>";
					}
					
					if(json.length > 1) {
						try {
							content += "<td class=\"tableHideCol\">";
							if(bLonProtocol)
								content +=  json[i]["lon.cfg"].unit;
							content +=  "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].cat + "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].type + "</td>";
							content += "<td class=\"tableHideCol\">" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName + "</td>";

							//content += "<td><button class=\"menuDivButton\" onclick=\"showDlaByName1(1,'" + json[i].pathname + "','" + json[i].programmaticPathname + "')\">Show</button></td>";
							content += "<td class=\"tableHideCol\">";
							if(typeof json[i].property !== "undefined") 
								content +=  json[i].property;
							content += "</td>";
							
							if(bLonProtocol) {
								content += "<td class=\"tableHideCol\">";
								if(typeof json[i]["lon.cfg"].relatesTo !== "undefined") {
									content += json[i]["lon.cfg"].relatesTo;
								}
								content += "</td>";
							}
							
							content += "<td class=\"tableHideCol\">";
							
							if(typeof json[i]["read-only"] !== "undefined") 
								content += json[i]['read-only'];
							content += "</td>";
							if(typeof json[i].monitor === "undefined") {
								if(bLonProtocol) {
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
								}
								else {
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td><td class=\"tableHideCol\"></td>";
									content += "<td class=\"tableHideCol\"></td><td class=\"tableHideCol\">";
								}
							}
							else {
								content += "<td class=\"tableHideCol\">" + json[i].monitor.rate + "</td>";
								content += "<td class=\"tableHideCol\">"
								try {
									if(typeof json[i].monitor.event !== "undefined")
										content +=  json[i].monitor.event;
								} catch {}
								content += "</td>"
								content += "<td class=\"tableHideCol\">" + json[i].monitor.throttle + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.heartbeat + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.threshold + "</td>";
								content += "<td class=\"tableHideCol\">" + json[i].monitor.receiveTimeout + "</td>";
								if(bLonProtocol) {
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationThrottle + "</td>";
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationHeartbeat + "</td>";
									content += "<td class=\"tableHideCol\">" + json[i].monitor["lon.cfg"].propagationThreshold + "</td>";
								}
								
							}
							content += "<td class=\"tableHideCol\"><div>"
							try {
								if(typeof json[i].localization !== "undefined") {
									if(json[i].localization === null)
									{}
									else if(typeof json[i].localization === "object") {
										sTemp = JSON.stringify(json[i].localization);
										if(sTemp !== "{}")
											content += sTemp;
									}
									else 
										content += json[i].localization;
									
								}
							} catch {}
							content += "</div></td>";
							content += "<td class=\"tableHideCol\"><div>";
							if(typeof json[i].presets !== "undefined") {
								if(json[i].presets !== null) {
									if(json[i].presets.map.length > 0) {
										content += JSON.stringify(json[i].presets.map);
									}
								}
							}
							content += "<div></td>";
							if(bLonProtocol)
								content += "<td class=\"tableHideCol\"><div>" + json[i].desc + "</div></td>";
							if(!bLonProtocol){
								content += "<td class=\"tableHideCol\"><div>";
								if(typeof json[i].default !== "undefined") {
									if(json[i].default === null)
									{}
									else if(typeof json[i].default === "object")
										content += JSON.stringify(json[i].default);
									else
										content += jon[i].default;
									
								}
									content += "</div></td>";
							}
							content += "<td class=\"tableHideCol\"><div>"
							try {
								if(typeof json[i]["Initial Value"] !== "undefined") {
									if(json[i]["Initial Value"] === null)
									{}
									else if(typeof json[i]["Initial Value"] === "object")
										content += JSON.stringify(json[i]["Initial Value"]);
									else
										content += jon[i]["Initial Value"];
									
								}
							} catch {}
							content += "</div></td>";
							content += "<td class=\"tableHideCol\">"
							try {
								if(typeof json[i]["Write Initial"] !== "undefined") {
									content += json[i]["Write Initial"];
									
								}
							} catch {}
							content += "</td>";
							content += "<td class=\"tableHideCol\">"
							try {
								if(typeof json[i].interfaceType !== "undefined")
									content += json[i].interfaceType;
								
							} catch {}
							content += "</td>";
						}
						catch {}

					}


					content += "</tr>";

					if(json.length === 1) {
						// single datapoint show configuration in separate table
						bSingleDp = true;
						g_bPlanningShowConfigurationSingleDp = true;
						content += "</tbody></table>";
						content += "<br>";
						content += "<div id=\"treeDpProperty\" style=\"display:";
						if(g_bPlanningShowConfiguration)
							content += "inline-block\">";
						else
							content += "none\">";
						
						content += "<hr>";
						content += "<br>Properties:";
						//content += "<button style=\"50px\" onclick=\"showDlaByName1(1,'" + json[i].pathname + "','" + json[i].programmaticPathname + "')\">Device Type DP Properties</button><br>";
						content += "<br>";
						content += "<table id=\"treeDpProperties\"><thead><tr><th class=\"tablePropertyHideCol\">Property</th><th class=\"tablePropertyHideCol\">Value</th></tr></thead><tbody>";
						try {
							content += "<tr><td>Type</td><td>" + json[i].type + "</td></tr>";
							//if(json[i].hasOwnProperty("lon.cfg")) {
							if(typeof json[i]["lon.cfg"] !== "undefined") {
								content += "<tr><td>Units</td><td>" + json[i]["lon.cfg"].unit + "</td></tr>";
							}
							if(typeof json[i]["read-only"] !== "undefined") 
								content += "<tr><td>Read-only</td><td>" + json[i]["read-only"] + "</td></tr>";
							content += "<tr><td>Direction</td><td>" + json[i].cat + "</td></tr>";
							content += "<tr><td>Property</td><td>" + json[i].property + "</td></tr>";
							if(typeof json[i]["lon.cfg"] !== "undefined") {
								if(typeof json[i]["lon.cfg"].relatesTo !== "undefined") {
									content += "<tr><td>Property For</td><td>" + json[i]["lon.cfg"].relatesTo + "</td></tr>";
								}
							}
							if(typeof json[i].desc !== "undefined")
								content += "<tr><td>Description</td><td>" + json[i].desc + "</td></tr>";
							
							if(typeof json[i].monitor !== "undefined") {
								content += "<tr><td>Monitor Poll Rate</td><td>" + json[i].monitor.rate + "</td></tr>";
								content += "<tr><td>Monitor Event</td><td>"
								try {
									if(typeof json[i].monitor.event !== "undefined")
										content +=  json[i].monitor.event;
								} catch {}
								
								content += "</td></tr>";
								content += "<tr><td>Monitor Rate</td><td>" + json[i].monitor.rate + "</td></tr>";
								content += "<tr><td>Monitor Throttle</td><td>" + json[i].monitor.throttle + "</td></tr>";
								content += "<tr><td>Monitor Heartbeat</td><td>" + json[i].monitor.heartbeat + "</td></tr>";
								content += "<tr><td>Monitor Threshold</td><td>" + json[i].monitor.threshold + "</td></tr>";
								content += "<tr><td>Monitor ReceiveTimeout</td><td>" + json[i].monitor.receiveTimeout + "</td></tr>";
								try {
									if(typeof json[i].monitor["lon.cfg"] !== "undefined") {
										content += "<tr><td>Propagation Throttle</td><td>" + json[i].monitor["lon.cfg"].propagationThrottle + "</td></tr>";
										content += "<tr><td>Propagation Heartbeat</td><td>" + json[i].monitor["lon.cfg"].propagationHeartbeat + "</td></tr>";
										content += "<tr><td>Propagation Threshold</td><td>" + json[i].monitor["lon.cfg"].propagationThreshold + "</td></tr>";
									}
								} catch {}
							}
							
							
							try {
								if(typeof json[i].localization !== "undefined") {
									content += "<tr><td>Localization</td><td><div>";
									if(json[i].localization === null)
									{}
									else if(typeof json[i].localization === "object") {
										sTemp = JSON.stringify(json[i].localization);
											if(sTemp !== "{}")
												content += sTemp;
									}
									else 
										content += json[i].localization;
									content +=  "</div></td></tr>";
								}
							} catch {}
							content += "<tr><td>Presets</td><td>";
							try {
								if(typeof json[i].presets !== "undefined") {
									if(json[i].presets !== null) {
										if(json[i].presets.map.length > 0) {
											content += JSON.stringify(json[i].presets.map);
										}
									}
								}
							} catch {}
							content +=  "</td></tr>";
							try {
								if(typeof json[i].default !== "undefined") {
									content += "<tr><td>Default</td><td><div>";
									if(json[i].default === null)
									{}
									else if(typeof json[i].default === "object")
										content += JSON.stringify(json[i].default);
									else
										content += jon[i].default;
									content +=  "</div></td></tr>";
								}
							} catch {}
							try {
								if(typeof json[i]["Initial Value"] !== "undefined") {
									content += "<tr><td>Initial Value</td><td><div>";
									if(json[i]["Initial Value"] === null)
									{}
									else if(typeof json[i]["Initial Value"] === "object")
										content += JSON.stringify(json[i]["Initial Value"]);
									else
										content += jon[i]["Initial Value"];
									content +=  "</div></td></tr>";
								}
							} catch {}
							
							
							try {
								if(typeof json[i]["Write Initial"] !== "undefined") {
									content += "<tr><td>Write Initial</td><td>";
									content += json[i]["Write Initial"];
									content +=  "</td></tr>";
								}
							} catch {}
							if(typeof json[i].interfaceType !== "undefined")
								content += "<tr><td>Interface</td><td>" + json[i].interfaceType + "</td></tr>";
						} catch {}
						
						content += "</tbody></table></div>";
					}

				}
				else {
					if((mode !== 2) || ((mode === 2) && json[i].bProcess)) {
						z = -1;
						for(j=0; j < planningDpList.length; j++)
						{
							if(planningDpList[j].pathname === json[i].pathname) {
								z = j;
								break;
							}
						}
						if(z !== -1) {
							bContinue1 = false;
							if (mode === 1) {
								element = document.getElementById("planningPollCheckbox");
								if(element !== null) {
									if(!element.checked) {
										bContinue1 = true;
									}
								}
							}
							if(isNotEqual(planningDpList[z].value, json[i].value) || bContinue1) {
								planningDpList[z].value = json[i].value;
								planningDpList[z].valueStr = json[i].valueStr;
								planningDpList[z].locValue = json[i].locValue;
								planningDpList[z].locValueStr = json[i].locValueStr;
								planningDpList[z].timestampStr = json[i].timestampStr;
								planningDpList[z].presetValue = json[i].presetValue;
								
								element = document.getElementById("localValue_" + json[i].pathname);
								if(element !== null) {
									if(planningDpList[z].cat === "out")
										element.innerHTML = valueStr;
									else
										element.value = valueStr;
								}
							}
							
							if(mode === 1) { //refresh
								if(isNotEqual(planningDpList[z].values,json[i].values))
									planningDpList[z].values = json[i].values;
								if(typeof json[i].priority === "number") {
									if(planningDpList[z].priority !== json[i].priority) {
										planningDpList[z].priority = json[i].priority;
									}
									element = document.getElementById("priority_" + json[i].pathname);
									if(element !== null) {
										if(Number(element.value) !== json[i].priority)
											element.value = json[i].priority;
									}
									
								}
								
							}
							
						}
						
					}
				}
			}
		}
		if(mode === 0) {
			content += "</tbody></table>";
			document.getElementById("planningPaneDetails").innerHTML = content; 
			
			createRequestString(planningDpList);
			subscribeRequest();
			planningPollCheckBox();
			
			
		}
		if(mode === 0) {
			if(bSingleDp)
				treeShowConfiguration();
			else
				treeShowConfigurationAll();
			
		}
		if(bRequestFollowupRead) {
			if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
			//g_timerId = window.setTimeout("timerHandler()",g_planningDpOnDemandTimerInterval); 
		}
		
		
	}
	catch(err) {}
	if(mode === 0)
		cursorClearWait();
		
}
function getPlanningTreeRequestFailure(mode, requestUrl, json) {
	
	if(mode === 0)
		cursorClearWait();
	document.getElementById("planningPaneDetails").innerHTML = "";
}
function getPlanningTreeShowTreeDatapointsUpdatePrioritesResponse(mode, requestUrl, json) {
	// mode: 0=creat table, 1= 2=Websocket, 3= on demandfollowup request, 4=refresh [same as 0 but don't create table]
	// Table data
	try {
		var i, j, z;
		if(!(mode === 23) || (mode === 24))
			return;
		
		for(i=0; i < json.length; i++)
		{ // check if in
			z = -1; 
			for(j=0; j < planningDpList.length; j++)
			{
				if(json[i].dpQualifier === planningDpList[j].dpQualifier) {
					if(json[i].cat === "in") {
						if(typeof json[i].values !== "undefined") {
							if(typeof json[i].values.level !== "undefined") {
								if(typeof json[i].values.level === "string") 
									json[i].values.level = Number(json[i].values.level); // required dued to bug in current shipping iox
								if((planningDpList[j].priority !== json[i].values.level) 
									|| (planningDpList[j].values.level !== json[i].values.level)
									|| (isNotEqual(planningDpList[j].values.level, json[i].values.level))) {
									
									planningDpList[j].priority = json[i].values.level;
									planningDpList[j].values = JSON.parse(JSON.stringify(json[i].values));
									element = document.getElementById("priority_" + planningDpList[j].programmaticPathname);
									if(element !== null) {
										element.value = json[i].values.level;
									}
								}
							}
						}
					}
					break;
				}
			}
		}
	}
	catch(err) {}
}
function getPlanningTreeShowTreeDetails(mode, id) {
	var json;
	var sResult = "";
	var sTemp, sTemp1, items, items1;
	var bContinue = false;
	var sResults;
	var x, i, j, m, n;
	var treeContext = null;
	var sidItems = [];
	var bAbove = false;
	var image = "",width=-1, height=-1,location ="";
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	try {
		g_sPlanningTreeDatapointPath = ""; // only used for Devices and Datapoints nodes
		g_iPlanningPaneSelectedContextType = 0;
		if(mode === 61) {
			mode = 1; // called do to a resize event
			menuCloseAll1(1);
		}
		else {
			menuCloseAll();
			g_bEditModeEnabled = false;
			if(g_iShowEditButton > 0) {
				if(g_iShowEditButton === 2) 
					g_bEditModeEnabled = true;
			}
		}
		planningDpList = [];
		g_bPollingEnabled = false;
		ivbWsProcessDatapointUpdate = false;
		g_PollingType = 0;
		if(g_planningDpTimerId !== 0)
			clearTimeout(g_planningDpTimerId);

		//document.getElementById("planningContextDetailsDiv").style.visibility = "visible";
		//document.getElementById("planningRefreshButton").style.visibility = "visible";
		cursorClearWait();
		if(mode === 0) {
			// change color of tree context to indicate selected
			if(g_iPlanningPaneSelectedContextId !== -1) {
				treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
				if(treeContext !== null) {
					treeContext.classList.remove("treeSelected")
					//treeContext.style.color = "white";
				}
			}
			treeContext = document.getElementById("planningTreeContext_" + id);
			if(treeContext !== null) {
				//treeContext.style.color = "red";
				treeContext.classList.add("treeSelected")
			}
		}

		g_iPlanningPaneSelectedContextId = id;
		if(g_iPlanningPaneSelectedContextId === "__sites__") {
			treeviewSitesPaneContent();
			return;
		}

		if(id === "_NoContext") {
			document.getElementById("planningPaneDetails").innerHTML = "Un-assigned Devices<br><br>Devices which are not assigned to a Context";
			return; // un-assigned node in tree
		}
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		if((g_iPlanningTreeShowDevices === 1) || (json.contextType === "CAMPUS") || (json.contextType === "BUILDING")) { 
			json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0); 
			sTemp = g_sTreeNoContent;
			bContinue = true;
				// check if context has image
			if((json.customFields !== null) &&  (json.contextType !== "CAMPUS")){
				if(json.customFields.hasOwnProperty("image")) {
					bContinue = false; // found image 
					sTemp1 = json.customFields["image"];
					if(sTemp1.indexOf(",") !== -1) {
						// single tag with all image inforation
						items = sTemp1.split(",");
						image = ""; width = -1; height = -1;
						location = "";
						above = true;
						sid = null;
						for(i=0; i < items.length; i++)
						{
							if(items[i] !== "") {
								items1 = items[i].split("=");
								if(items1.length === 2) {
									items1[0] = items1[0].trim().toLowerCase();
									items1[1] = items1[1].trim();
									if(items1[0] === "image") {
										image =items1[1].trim();
									}
									else if(items1[0] === "width") {
										width =items1[1].trim();
									}
									else if(items1[0] === "height") {
										height =items1[1].trim();
									}
									/*else if(items1[0] === "sid") {
										if(items[1].trim().toLowerCase() !== "null") {
											sid = items1[1].trim();
										}
										bSidFound = true;
									} */
									else if(items1[0] === "location") {
										location =items1[1].trim();
									}
									else if(items1[0] === "above") {
										items1[1] = items1[1].trim().toLowerCase();
										if(items1[1] === "false")
											above = false;
									}
								}
							}
						}
						if(image !== "") {
							sTemp = "";
							if((location !== "") && above) {
								sTemp += location;
							}
							sTemp += "<div style=\"display:block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  image + "\" alt=\"";
							sTemp += json.contextType + "image\"";
							if(!isNaN(width)) {
								width = Number(width);
								if(width > 0)
									sTemp += " width=\"" + width + "px\"";
							}
							if(!isNaN(height)) {
								height = Number(height);
								if(height > 0)
									sTemp += " height=\"" + height + "px\"";
							}
							sTemp += "></div>";
							if((location !== "") && !above) {
								sTemp += location;
							}
						}
					}
					else {
						if(json.customFields.hasOwnProperty("above")) {
							if(json.customFields["above"]) 
								bAbove = true;
						}
						if(bAbove) {
							if(json.customFields.hasOwnProperty("location")) {
								if(json.customFields["location"] !== "") {
									sTemp += g_contextImages[j].location;
								}
							}
						}
						if(json.customFields["image"] !== "") {
							sTemp += "<div style=\"display:block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  json.customFields["image"] + "\" alt=\"";
							sTemp += json.contextType + "image\"";
							if(json.customFields.hasOwnProperty("width")) {
								sTemp1 = json.customFields["width"];
								try {
									sTemp1 = Number(sTemp1);
									if(!isNaN(sTemp1)) {
										sTemp += " width=\"" + sTemp1 + "px\"";
									}
								}
								catch {}
								
									
							}
							if(json.customFields.hasOwnProperty("height")) {
								sTemp1 = json.customFields["height"];
								try {
									sTemp1 = Number(sTemp1);
									if(!isNaN(sTemp1)) 
										sTemp += " height=\"" + sTemp1 + "px\"";
								}
								catch {}
							}
							sTemp += "></div>";
							
						}
						if(!bAbove) {
							if(json.customFields.hasOwnProperty("location")) {
								if(json.customFields["location"] !== "") {
									sTemp += g_contextImages[j].location;
								}
							}
						}
					}
					
				}
			}
			if(bContinue) {
				// check if images specified in user.js
				for(n=0; n < 2; n++)
				{
					for(j=0; j < g_contextImages.length; j++)
					{
						
						if(json.contextType.toLowerCase() === g_contextImages[j].contextType) {
						
							bContinue = false;
							
							if(n === 0) {
								// check if sid defined
								if(g_contextImages[j].sid !== null) {

									if(g_contextImages[j].sid.indexOf(",") !== -1) {
										sidItems = g_contextImages[j].sid.indexOf(",");
									}
									else {
										sidItems.push(g_contextImages[j].sid);
										
									}
									for(m=0; m < sidItems.length; m++)
									{
										if(g_iSmarserverSid === sidItems[m]) {
											bContinue = getPlanningTreeShowTreeDetailsCheckContext(g_contextImages[j].contextType, json.contextType.toLowerCase());
											if(bContinue)
												break;
										}
									}
								}
							}
							else if(n === 1) {
								// sid not defined
								bContinue = getPlanningTreeShowTreeDetailsCheckContext(g_contextImages[j].contextType, json.contextType.toLowerCase());
								
							}
							
							if(bContinue) {
								sTemp = "";
								if(g_contextImages[j].bLocationAboveImage) {
									if(g_contextImages[j].location !== null) {
										sTemp += g_contextImages[j].location;
									}
								}
								if(g_contextImages[j].image !== null) {
									sTemp += "<div style=\"display:block;margin-left:50 px;margin-top:10px;margin-right:10px\"><img src=\"" +  g_contextImages[j].image + "\" alt=\"device image\"";
									if(g_contextImages[j].width !== null)
										sTemp += " width=\"" + g_contextImages[j].width + "px\"";
									if(g_contextImages[j].height !== null)
										sTemp += " height=\"" + g_contextImages[j].height + "px\"";
									sTemp += "></div>";
									
								}
								if(!g_contextImages[j].bLocationAboveImage) {
									if(g_contextImages[j].location !== null) {
										sTemp += g_contextImages[j].location;
									}
								}
								break;
							}
							
						}
						
					}
					if(bContinue)
						break;
				}
			}
			
			sTemp = json['path'] + "<br><br>" + sTemp;
			if((json.contextType !== "CAMPUS") && (json.contextType !== "BUILDING"))
				sTemp = "<br>" + sTemp;
			

			document.getElementById("planningPaneDetails").innerHTML = sTemp;
			//getPlanningTreeShowTreeDevices(id); yyyy
			
			//showContextDevices(id);
			return;
		}
		else if(g_iPlanningTreeShowDevices === 0) {
			getPlanningTreeShowTreeFloorplan(id);
			//showContextDevices(id);
			return;
		}

		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObj(planningList, id, 0);
		
		if(json === null)
			document.getElementById("planningPaneDetails").innerHTML = "Details<br><br>No Details";
		else {
			// sort
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < json.length; i)
				{

				}
			}
			for (x in json)
			{
				if(x === "devices") {
					sResult += "<tr><td>Devices</td><td>" + json[x].length + "</td></tr>";
				}
				else if(typeof json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if (json[x] === null )
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(json[x] === "undefined")
					sResult += "<tr><td>" + x + "</td><td></td></tr>";
				else if(x === "treeLevel")
					sResult += "<tr><td>Tree Level</td><td>" + json[x] + "</td></tr>"; 
				else if(x === "children")
					sResult += "<tr><td>Number of children</td><td>" + json[x].length + "</td></tr>";
				else if(x === "image")  {
					
					sResult += "<tr><td>images</td><td>" + json[x].length + "</td></tr>";
				}
				else if((typeof json[x] === "object")  || Array.isArray(json[x])) {
					sTemp = JSON.stringify(json[x]);
					sResult += "<tr><td>" + x + "</td><td>" + sTemp + "</td></tr>"; 
				}
				else 
					sResult += "<tr><td>" + x + "</td><td>" + json[x] + "</td></tr>"; 
			}
			if(sResult !== "") {
				sResult = "<table id=\"myTable\"><thead><tr><th>Property</th><th>Value</th></tr></thead><tbody>" + sResult + "</tbody></table>"; 
				sResult = "<br>" + json['path'] + "<br><br>Details<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices</button><br><br>" + sResult;
				sResult += addTopButton();
				document.getElementById("planningPaneDetails").innerHTML = sResult;
				sortTable(0); 
			}
		}
		
	}
	catch {}
	cursorClearWait();
}
function getPlanningTreeShowTreeDetailsCheckContext(contexts, context) {
	var bResult = false;
	var i;
	var contextItems = [];
	try { 
		if((contexts === null) || (context === null)){

		}
		else {
			if(contexts.indexOf(",") === -1) {
				contextItems.push(contexts);
			}
			else {
				contextItems = contexts.split(",");
			}
			for(i=0; i < contextItems.length; i++)
			{
				if(contextItems[i] === context) {
					bResult = true;
					break;
				}
			}
		}
	}
	catch {}
	return bResult;

}
function getPlanningTreeShowTreeDetailsGetObj(json, id, level) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					jsonResult = getPlanningTreeShowTreeDetailsGetObj(json[i].children, id, level);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json, id, level, image) {
	var i;
	var jsonResult = null;
	level ++;
	if(json === null)
		return null;
	try {
		for(i=0; i < json.length; i++)
		{
			if(json[i].id === id) {
				jsonResult = JSON.parse(JSON.stringify(json[i]));
				if((jsonResult.image.image === null) || (jsonResult.image.image === null)) {
				
					if(image !== null)
						jsonResult.image = image;
				}
				break;
			}
			else if (json[i].children !== null) {
				if(json[i].children.length > 0) {
					if(json[i].contextType === "FLOOR") {
						if((json[i].image.image !== null) && (json[i].image.image !== null)) 
							image = json[i].image;
							image.floorId = json[i].contextualEntityId;
					}
					jsonResult = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(json[i].children, id, level, image);
					if(jsonResult !== null) 
						break;
				}
			}
		}
	}
	catch { jsonResult = null;}
	
	return jsonResult;
}
function getPlanningTreeShowTreeFloorplan (id) {
	try { 
		var sTemp = "";
		var floorId = -1;
		var decodedImagestringAtoB = null;
		var json;
		var imageStr = "";
		
		g_planningFloorplanObjs = {};
		g_planningFloorplanGroups = [];
		document.getElementById("planningPaneDetails").style.display = "inline-block";
		json = getPlanningTreeShowTreeDetailsGetObjPlusFloorplan(planningList, id, 0, null);
		if((json.contextType === "CAMPUS") || (json.contextType === "BUILDING")){
			sTemp = "Floor plans not supported for " + json.contextType + "<br><br>Supported Floorplans: floor, and rooms and areas inside a floor";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
			return;
		}
		else if(json.contextType === "FLOOR") {
			floorId = json.contextualEntityId;
		}
		else {
			if(json.image !== null) 
				floorId = json.image.floorId;
		}
		g_iContextTableX = 0; //used to locate datapoint table in room or area
		g_iContextTableY = 0;
		json.browserFloorId = floorId;
		if(json.image.image === null) {
		//if((json.image.image === null) || (json.image.imageType === null)) {
			document.getElementById("planningPaneDetails").innerHTML = "";
			return;
		}
		
		if( json.image.imageType === null) {
			if(json.image.image.length > 10) {
				imageStr = json.image.image.substr(0,10);
				decodedImagestringAtoB = atob(imageStr)
				decodedImagestringAtoB = decodedImagestringAtoB.substr(1,3)
				if(decodedImagestringAtoB.startsWith("PNG")) {
					json.image.imageType = "png";
				}
				else 
					json.image.imageType = "jpeg";
			}
		}
		else if( json.image.imageType === "null") {
			if(json.image.image.length > 10) {
				imageStr = json.image.image.substr(0,10);
				decodedImagestringAtoB = atob(imageStr)
				decodedImagestringAtoB = decodedImagestringAtoB.substr(1,3)
				if(decodedImagestringAtoB.startsWith("PNG")) {
					json.image.imageType = "png";
				}
				else 
					json.image.imageType = "jpeg";
			}
		}
		
		if(( json.image.imageType !== "png") && ( json.image.imageType !== "jpeg")) {
			document.getElementById("planningPaneDetails").innerHTML = ""; // not supported yet
				return;
		}
		if(json.contextualEntityId === null) {
			if( json.image.imageType === "png")
				sTemp = "<img src=\"data:image/png;base64," + json.image.image + "\">";
			else if( json.image.imageType === "jpeg")
				sTemp = "<img src=\"data:image/jpeg;base64," + json.image.image + "\">";
			document.getElementById("planningPaneDetails").innerHTML = sTemp;
		}
		else {
			document.getElementById("planningPaneDetails").innerHTML = "Getting floor plan ....";
			sTemp = "/iap/zones/*+floor.id==" + json.browserFloorId; //json.contextualEntityId;
			requestGetData(json, sTemp, getPlanningTreeShowTreeFloorplanShowPolygons, readFailCallback);
		}

	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygons (contextobj, url, json) {
	try { 
		var sTemp = "";
		var obj = {}
		sTemp = "<div id=\"floorplanTitle\">" + contextobj.path;
		sTemp += "<br><br> Getting Floor plan ....</div><br><div id=\"floorplanimageDiv\"><img id=\"floorplanimage\" src=\"data:image/png;base64," + contextobj.image.image + "\" style=\"visibility:hidden\"></div>";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;
		obj.contextobj = JSON.parse(JSON.stringify(contextobj));
		obj.floorplan = JSON.parse(JSON.stringify(json));
		sTemp = "/iap/devs?floorid=" + contextobj.browserFloorId;//contextobj.contextualEntityId;
		requestGetData(obj, sTemp, getPlanningTreeShowTreeFloorplanShowDevices, readFailCallback);

	}
	catch {}
}

function getPlanningTreeShowTreeFloorplanShowDevices(floorplanObjs, url, json1) {
	// had to wait for device list as need time for image to load.
	var i, j, k, m, z;
	var coordinates;
	var top=0,left=0;
	var sTemp, sTemp1;
	var detailImage = null; //document.getElementById("planningPaneDetails");
	var offsets = null; //detailDiv.getBoundingClientRect(); 
	var contextualEntityId;
	var x, y, x1, x2, y1, y2; // used to determine full size of canvas and set canas width and lenght
	var coordList = [], obj, obj1;
	var contextobj;
	var width = 20;
	var multiplier = 1;
	var color;
	var bContinue = false;
	var floorId = -1;
	var minImageWidth = 800; //px
	var changeColor = "";
	var groupNum;
	var json;
	var r,w;
	var url;
	var planningCount, count = 0;
	
	try {
		cursorSetWait();
		
		contextobj = floorplanObjs.contextobj;
		contextualEntityId = contextobj.contextualEntityId;
		floorId = contextobj.browserFloorId;
		json = floorplanObjs.floorplan;
		//sTemp = "<div>" + contextobj.path + "</div><div><span id=\"planningDeviceCount\" style=\"visibility:hidden;margin-left:20px\">  [ 0 devices]</span>";
		sTemp = "<div>" + contextobj.path + "</div><div><span id=\"planningDeviceCount\" style=\"display:none;margin-left:20px\">  [ 0 devices]</span>";
		if(g_iShowEditButton > 0) {
			//g_iShowEditButton: 0=disabled, 1=show switch (default readonly), 2=show switch(default write)
			sTemp += "<div class=\"editButtonDiv\">(<input id=\"editButton\" type=\"checkbox\" onclick=\"dashboardEditCheckBox()\"";
			if(g_bEditModeEnabled)
				sTemp += " checked";
			sTemp += "> edit)</div>";
		}
		//if()
		//	sTemp
		sTemp += "</div>"
		document.getElementById("floorplanTitle").innerHTML = sTemp;
		
		sTemp = "";
		detailImage = document.getElementById("floorplanimage"); //("floorplanimageDiv");
		offsets = detailImage.getBoundingClientRect(); 
		// zoom in if image width is less than 1000
		if(offsets.width > 0 ) {
			if(offsets.width < minImageWidth) {
				multiplier = (minImageWidth / offsets.width);
				multiplier =  Math.ceil(multiplier);
				if(multiplier > 1) {
					detailImage.width = (offsets.width * multiplier);
					detailImage.height = (offsets.height * multiplier);
					offsets = detailImage.getBoundingClientRect(); 
				}
				else 
					multiplier = 1;


			}
		}
		detailImage.style.visibility = "visible";
		
		if(json !== null) {
			

			for(i=0; i < json.length; i++)
			{ // get x1,x2, y1 and y2 to figure out width and height
				bContinue = false;
				obj = {};
				obj.x1 = -1;
				obj.x2 = -1;
				obj.y1 = -1;
				obj.y2 = -1;
				obj.width = 0;
				obj.height = 0;
				if((contextobj.contextType === "FLOOR") || ((contextobj.contextType === "ROOM") && (contextobj.children.length > 0)))
					bContinue = true;
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					for(j=0; j < coordinates.length; j++) 
					{
						var cordinate = coordinates[j];
						if(j==0) {
							x1 = x2 = cordinate['0'];
							y1 = y2 = cordinate['1'];
							//sTemp= x1 + "," + y1;
						}
						else {
							
							if(x1 > cordinate['0'])
								x1 = cordinate['0'];
							if(x2 < cordinate['0'])
								x2 = cordinate['0'];
							if(y1 > cordinate['1'])
								y1 = cordinate['1'];
							if(y2 < cordinate['1'])
								y2 = cordinate['1'];
							//sTemp += " " +  cordinate['0'] + "," +  cordinate['1'];
						}
					}
					obj.x1 = x1;
					obj.x2 = x2;
					obj.y1 = y1;
					obj.y2 = y2;
					obj.width = x2 - x1;
					obj.height = y2 - y1;
					
				}
				
				coordList.push(obj);
			}
		
			for(i=0; i < json.length; i++)
			{
				bContinue = false;
				if(contextobj.contextType === "FLOOR")
					bContinue = true;
				else if((contextobj.contextType === "ROOM") && (contextobj.children.length > 0)) {
					for(j=0; j < contextobj.children.length; j++) 
					{
						if(contextobj.children[j].id === json[i].contextId) {
							bContinue = true;
							break;
						}
					}
					
				}
				else if(contextobj.contextualEntityId === json[i].id)
					bContinue = true;
				if(bContinue) {
					coordinates = json[i].polygon.coordinates['0'];
					sTemp = "";
					x = coordList[i].x1;
					y = coordList[i].y1;
					for(j=0; j < coordinates.length; j++) 
					{
						var coordinate = coordinates[j];
						sTemp += " " +  ((coordinate['0'] - x) * multiplier) + "," +  ((coordList[i].height - (coordinate['1'] - y)) * multiplier);
					}
					x = offsets.x + window.pageXOffset + (coordList[i].x1 * multiplier);
					//y = offsets.y + offsets.height + window.pageYOffset - (obj.height + obj.y1); //offsets.y + window.pageYOffset + coordList[i].y1;
					y = offsets.bottom + window.pageYOffset - ((coordList[i].height + coordList[i].y1) * multiplier);
					//sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:" + json[i].color + ";stroke-width:3\" opacity=\"0.3\"/>";
					sTemp = "<polygon points=\"" + sTemp + "\" style=\"fill:" + json[i].color + ";stroke:black;stroke-width:3\" opacity=\"0.3\" />"
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:4\"> <svg width=\"" + ( coordList[i].width * multiplier) + "\" height=\"" + (coordList[i].height * multiplier) + "\">" + sTemp + "</svg></div>";				

					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					
				}
		
			}
		}
		
		if(json1 !== null) {
			for(i=0; i < json1.length; i++)
			{
				if(json1[i].hasOwnProperty('floorCoordinates')) {
					//if(json1[i].floorCoordinates.floorId === contextualEntityId) {
					bContinue = false;
					if(contextobj.contextType !== "FLOOR") {
						//room or area, determine if device in room/area
						for(j=0; j < json1[i].contexts.length; j++)
						{
							if(json1[i].contexts[j] === contextobj.id) {
								bContinue = true;
								break;
							}
							else {
								for(k =0; k < contextobj.children.length; k++) 
								{
									if(contextobj.children[k].id === json1[i].contexts[j]) {
										bContinue = true;
										break;
									}
								}
							}
						}
					}


					if((json1[i].floorCoordinates.floorId === floorId) && ((contextobj.contextType === "FLOOR") || ((contextobj.contextType !== "FLOOR") && bContinue))) {
						// if floor show all devices on floor, if room/area only show its devices
						count ++;
						var coordinate = json1[i].floorCoordinates;
						// check if more than one device at same location, if so only add one and assign device to group
						z = -1;
						if(json1[i].status.state === "provisioned") {
							if((json1[i].status.health === "normal") || (json1[i].category === "SC"))
								color = "lawngreen";
							else if(json1[i].status.health === "down")
								color = "red";
							else if(json1[i].status.health === "suspect")
								color = "yellow";
							else
								color = "darkred";
						}
						else if(json1[i].status.state === "unlicensed")
							color = "#BA55D3";
						else if(json1[i].status.state === "provisioning")
							color = "cyan";
						else 
							color = "blue";
						for(j=0; j < g_planningFloorplanGroups.length; j++) 
						{
							if((g_planningFloorplanGroups[j].x === coordinate['x']) && (g_planningFloorplanGroups[j].y === coordinate['y'])) {
								g_planningFloorplanGroups[j].deviceList.push(JSON.parse(JSON.stringify(json1[i])));
								if(g_planningFloorplanGroups[j].color !== color) {
									if(((g_planningFloorplanGroups[j].color === "blue") || (g_planningFloorplanGroups[j].color === "cyan") || (g_planningFloorplanGroups[j].color === "#BA55D3"))
										&& ((color === "blue") || (color === "cyan") || (color === "#BA55D3")))
										changeColor = "blue";
									else
										changeColor = "yellow";
								}
								/*
								if((color === "red") && (g_planningFloorplanGroups[j].color !== "red"))
									changeColor = color;
								else if((color === "#BA55D3") && (g_planningFloorplanGroups[j].color !== "#BA55D3"))
									changeColor = color;
								else if((color === "yellow") && (g_planningFloorplanGroups[j].color !== "red") && (g_planningFloorplanGroups[j].color !== "yellow"))
									changeColor = color;
								else if((color === "cyan") && (g_planningFloorplanGroups[j].color !== "red") && (g_planningFloorplanGroups[j].color !== "yellow") && (g_planningFloorplanGroups[j].color !== "cyan"))
									changeColor = color;
								else if((color === "blue") && (g_planningFloorplanGroups[j].color !== "red") && (g_planningFloorplanGroups[j].color !== "yellow") && (g_planningFloorplanGroups[j].color !== "cyan")
									&& (g_planningFloorplanGroups[j].color !== "blue"))
									changeColor = color;
								else if(color !== g_planningFloorplanGroups[j].color)
									changeColor = color;
*/
								if(changeColor !== "") {
									g_planningFloorplanGroups[j].color = changeColor;
									document.getElementById(g_planningFloorplanGroups[j].displayId).style.fill = changeColor;
								}
								z = j;
								break;
							}
						}
						if(z === -1) {
							var x = offsets.x + window.pageXOffset + (coordinate['y'] * multiplier) - (width / 2);
							var y = offsets.bottom + window.pageYOffset - (coordinate['x'] * multiplier) + (width / 2);
							groupNum = g_planningFloorplanGroups.length;
							sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
							//sTemp += "<svg height=\"32\" width=\"32\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							//sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\">"
							sTemp += "<svg height=\"32\" width=\"32\">";
							sTemp += "<g><title>" + json1[i].name  + "</title>";
							sTemp += "<circle id=\"deviceMenu_" + json1[i].name + "\"  cx=\"16\" cy=\"16\" r=\"14\" stroke=\"black\" stroke-width=\"3\" fill=\"" + color + "\"";
							sTemp += " onclick=\"getPlanningFloorplanMenu(" + groupNum + ")\" />";
							//sTemp += " onclick=\"menuDevice(2, event," + json1[i].id + ", '" + json1[i].name  + "', '" + json1[i].typeId  + "')\">";
							//sTemp += " /></svg> </div>";
							sTemp += "</g>";
							sTemp += "</svg> </div>";
							
							obj = {};
							obj.displayId = "deviceMenu_" + json1[i].name;
							obj.color = color;
							obj.deviceList = [];
							obj.x = coordinate['x'];
							obj.y = coordinate['y'];
							obj.textX = x;
							obj.textY = y;
							obj.deviceList.push(JSON.parse(JSON.stringify(json1[i])));
							g_planningFloorplanGroups.push(obj);
							document.getElementById("planningPaneDetails").innerHTML += sTemp;
							if(contextobj.contextType !== "FLOOR") {
								if(getPlanningTreeShowTreeFloorplanShowDevicesCheckContext(contextobj.id, json1[i].contexts)) {
									if(g_iContextTableX === 0) {
										g_iContextTableX = x;
										
									}
									else if(x < g_iContextTableX)
										g_iContextTableX = x;
									if(g_iContextTableY === 0) {
										g_iContextTableY = y;
										
									}
									else if(y > g_iContextTableY) {
										g_iContextTableY = y;
										
									}
									contextobj.iContextTableX = g_iContextTableX;
									contextobj.iContextTableY = g_iContextTableY;
								}
							}


						}
						
					}
				}
			}
			for(i=0; i < g_planningFloorplanGroups.length; i ++) {
				if(g_planningFloorplanGroups[i].deviceList.length > 1) {
					if(g_planningFloorplanGroups[i].deviceList.length < 10) {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 8;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 12;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					else  {
						x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (width / 2) - 15;
						y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) + (width / 2) + 5;
					}
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:black\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">" + g_planningFloorplanGroups[i].deviceList.length + "</div>";
					//sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:8; color:white; cursor:default\" onclick=\"getPlanningFloorplanMenu(" + i + ")\">888</div>";
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					// rename id for groups of devices
					document.getElementById("deviceMenu_" + g_planningFloorplanGroups[i].deviceList[0].name).id = "deviceMenu1_" + i;  // change id for groups so no conflict with devicemenu_<name>
					
					/*
					// keep for future grahics
					if(g_planningFloorplanGroups[i].deviceList.length < 10) {
						r = 10;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 5);
						y1 = ((w / 2) + 5);
						x2 = 6;
						y2 = 0;
					}
					else if(g_planningFloorplanGroups[i].deviceList.length < 100) {
						r = 12;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 8);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 4;
					}
					else  {
						r = 15;
						w = (2 * r) +  4;
						x1 = ((w / 2) - 12);
						y1 = ((w / 2) + 5);
						x2 = 8;
						y2 = 2;
					}
					var x = offsets.x + window.pageXOffset + (g_planningFloorplanGroups[i].y * multiplier) + (w - x2);
					var y = offsets.bottom + window.pageYOffset - (g_planningFloorplanGroups[i].x * multiplier) - ((w / 4) - y2);
					sTemp = "<div style=\"position:absolute;left:" + x +"px;top:" + y + "px;z-index:7\">";
					sTemp += "<svg height=\"" + w + "\" width=\"" + w + "\"> <circle id=\"deviceMenu_" + json1[i].name + "\" cx=\"" + (w / 2) + "\" cy=\"" + (w / 2) + "\" r=\"" + r + "\" stroke=\"yellow\" stroke-width=\"3\" fill=\"yellow\" />";
					sTemp += "<text x=\"" + x1 + "\" y=\"" + y1 + "\">" + g_planningFloorplanGroups[i].deviceList.length + "</text></svg></div>"
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
					*/
				}
				
			}
			
		} 
		planningCount = document.getElementById("planningDeviceCount");
		g_iDisplayIndex = 0;
		if(planningCount !== null) {
			g_sContextDpQualifierList = "";
			g_sContextDpQualifierDeviceList = []; //used for alarms
			g_displayTypeList = []; // used to use "s3" or "s4" for SNVT_switch
			if((contextobj.contextType === "CAMPUS") || (contextobj.contextType === "BUILDING"))
				getPlanningFloorPlanShowContextDps(contextobj); // added for navtree
			if((contextobj.contextType === "FLOOR") || (count === 0)) {
				planningCount.innerText = "  [" + count + " devices]";
				try {
					for(m=0; m < floorplanObjs.contextobj.children.length; m++)
					{
						if(floorplanObjs.contextobj.children[m].children.length > 0) { 
							// floor/room/area
							for(m1=0; m1 < floorplanObjs.contextobj.children[m].children.length; m1++)
							{
								getPlanningFloorPlanShowContextDps(floorplanObjs.contextobj.children[m].children[m1], true); 
						
							}
						}
						getPlanningFloorPlanShowContextDps(floorplanObjs.contextobj.children[m], true); // room or area
					}
				}
				catch {}
				getPlanningFloorPlanShowContextDps(contextobj,true); // added for navtree

			}
			else if((contextobj.contextType === "ROOM") || (count > 0)) {
				planningCount.innerText = "  [" + count + " devices]";
				try {
					//room/area
					for(m=0; m < floorplanObjs.contextobj.children.length; m++)
					{
						getPlanningFloorPlanShowContextDps(floorplanObjs.contextobj.children[m], false); // room or area
					}
				}
				catch {}
				getPlanningFloorPlanShowContextDps(contextobj,false); // added for navtree
				//getPlanningFloorPlanShowContextDps(contextobj,true); // added for navtree

			}
			else {
				planningCount.innerText = "  [" + contextobj.devices.length + "/" + count + " floor devices]";
				getPlanningFloorPlanShowContextDps(contextobj, false); // added for navtree
			}
			planningCount.style.visibility = "visible";
			
			
			/*
			if(sTemp !== "") {
				if((contextobj.contextType === "FLOOR") || (!g_bShowRoomTableContextOnImage)) {
					document.getElementById("planningPaneDetails").innerHTML += "<br>" + sTemp;
					//document.getElementById("planningPaneDetails").innerHTML += "<div style=\"inline-block\">" + sTemp + "</div>";
				}
				else {
					//room and area
					g_iContextTableX += iTableOffsetX;
					g_iContextTableY += iTableOffsetY;
					sTemp = "<div style=\"position:absolute;left:" + g_iContextTableX +"px;top:" + g_iContextTableY + "px; background-color: white;padding:5px;z-index:10\">" + sTemp + "</div>"
					document.getElementById("planningPaneDetails").innerHTML += sTemp;
				}
			}
			*/
			if(g_bShowAlarms && (g_sContextDpQualifierDeviceList.length > 0)) {
			
				obj1 = g_sContextDpQualifierDeviceList[0];
				g_sContextDpQualifierDeviceList.shift();
				obj = {};
				obj.mode = 11;
				obj.deviceName = obj1.deviceName;
				obj.deviceId = obj1.deviceId;
				getPlanningGetAlarmsForDevice(obj);
			}
			else if(g_sContextDpQualifierList !== "") {
				url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-" + g_sContextDpQualifierList + "/*?noxs=true";
				requestGetData(0, url, getPlanningContextDpsListResponse, null);
			}
		}
	}
	catch {}
	cursorClearWait();
}
function getPlanningTreeShowTreeFloorplanShowDevicesCheckContext(currentContextId,list) {
	// check if ContextId is in list
	var bResult = false;
	var i;
	try {
		if(list !== null) {
			for(i=0; i < list.length; i++)
			{
				if(currentContextId === list[i]) {
					bResult = true;
					break;
				}
			}
		}
	}
	catch {}
	return bResult;
}
function getPlanningFloorplanMenu(groupNum) {
	try {
		var sTemp = "", i, list, sResult = "", jon1, status = "";
		if(groupNum < g_planningFloorplanGroups.length) {
			if(g_planningFloorplanGroups[groupNum].deviceList.length === 1) {
				menuDeviceFloorplan(2, null, g_planningFloorplanGroups[groupNum].deviceList[0].id , g_planningFloorplanGroups[groupNum].deviceList[0].name, g_planningFloorplanGroups[groupNum].deviceList[0].typeId, g_planningFloorplanGroups[groupNum].deviceList[0].protocol);
			}
			else {
				// create Div to show all datapoints
				list = g_planningFloorplanGroups[groupNum].deviceList;
				for(i = 0; i < list.length; i++)
				{
					
					if(typeof list[i].id !== "number") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].name !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					else if (typeof list[i].deviceTypeName !== "string") {
						jon1 = list[i];
						temp = JSON.stringify(jon1);
					}
					//sResult += "<tr class=\"planningdevicetableTr\"><td><button class=\"clickabletext\" onclick=\"showDeviceByName(0, '" + list[i].name + "')\">" + list[i].name + "</button></td></tr>"; //ffix
					
					
					sResult += "<tr class=\"planningdevicetableTr\"><td class=\"planningdevicetableTd\">";
					sResult += "<div><canvas id=\"canvas_" + list[i].name +"\" width=\"12\" height=\"12\"></canvas></div>"; 
					

					sResult += "</td><td class=\"planningdevicetableTd\"><button id=\"deviceMenu_" + list[i].name + "\" class=\"clickabletext\"";
					//sResult += " onclick=\"menuDevice(1, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "')\">";
					sResult += " onclick=\"menuDeviceFloorplan(2, event," + list[i].id + ", '" + list[i].name  + "', '" + list[i].deviceTypeName  + "', '" + list[i].protocol  + "')\">";
					sResult += list[i].name + "</button></td></tr>"; 
				}
				
				if(sResult !== "") { 
					//sResult = "<hr><div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					sResult = "<div class=\"planningdevicetableDiv\"><table id=\"myTablePlanningTree\" class=\"planningdevicetable\"><tbody>" + sResult + "</tbody></table></div>";
					//sResult = "<br>" + json['path'] + "<button style=\"margin-left:40px;\" onclick=\"showContextDevices(" + id + ")\">Show Devices Detail</button><br><br>" + sResult;
					
					//sortTable(0); 
				}
				

				for(i=0; i < g_planningFloorplanGroups[groupNum].deviceList.length; i ++)
				{
					
					sTemp += "<div>" + g_planningFloorplanGroups[groupNum].deviceList[i].name;
				}
				
				var x = 0;
				var y = 0;
		
				var menuContent ="<div style=\"display:flex;width:300px\"><div style=\"display:inline-block;float:left\">Devices: ";
				menuContent += g_planningFloorplanGroups[groupNum].deviceList.length;
				menuContent +=  "</div><div style=\"display:inline-block;float:right\"><button class=\"closeButton\" onclick=\"planningMenuCancel()\">X</button></div></div><br>";
				g_bAlwaysIngnoreMouseClick = false;
				g_menuDivXOffset = 35;
				g_menuDivYOffset = 30;
				g_menuDivWidth = 150;
				
				menuContent += "<div>" + sResult + "</div>";
				var menuButton = document.getElementById("deviceMenu1_" + groupNum);
				var offsets;
				
				if(menuButton !== null) {
					offsets = menuButton.getBoundingClientRect(); 
					if((offsets.x + offsets.width + window.pageXOffset + g_menuDivWidth) > (window.pageXOffset + window.innerWidth)) 
						x = offsets.x + window.pageXOffset - g_menuDivWidth - 10; // takes into account viewport (scrolling)
					else
						x = offsets.x + offsets.width + window.pageXOffset + g_menuDivXOffset; // takes into account viewport (scrolling)
					y = offsets.y + window.pageYOffset - g_menuDivYOffset; // takes into account viewport (scrolling)
					document.getElementById("planningDiv").style.left = x.toString() + "px";
					document.getElementById("planningDiv").style.top = y.toString() + "px";
					document.getElementById("planningDiv").innerHTML = menuContent;
					if(sResult !== "") {
						for(i = 0; i < list.length; i++)
						{
							status = "normal";
							if(typeof list[i].deviceStatus === "undefined") {
								if(list[i].category === "SC") {
								}
								else if(list[i].status.state === "provisioned") {
									status = list[i].status.health;
								}
								else {
									status = list[i].status.state;
								}

							}
							else {
								status = list[i].deviceStatus;
							}
							deviceStatusColorCanvas("canvas_" + list[i].name, list[i].category, status);
							//deviceStatusColor("canvas_" + list[i].id, list[i].deviceStatus);
						}
					}
					document.getElementById("planningDiv").className = "planningDivShow"; // doesn't currently guaranty that menu is shown in viewport
					g_bInoreMouseClick = true;
					//document.addEventListener("click", planningMenuCancel);
					menuOverlayDivShow(1, null);
				}
				
					
				 
			}
		}

		
	}
	catch {}
}
function getPlanningTreeShowTreeFloorplanShowPolygonsFail (id) {
	try { 
		var 
		sTemp = "<br>Problem getting floorplan info";
		document.getElementById("planningPaneDetails").innerHTML = sTemp;

	}
	catch {}
}

function getPlanningFloorPlanShowContextDps(contextobj, bFloor) {
	//ffix hhhhh
	var content = "";
	var i, j, k, m, x=null, y = null, z;
	var items = [];
	var x1;
	var sTemp = "", sTemp1, sTemp2;
	var customFields = {};
	var displayType = "n";
	var obj = {};
	var bAddBr = false;
	var nameItems = [];
	var iDpDisplayType = 0; // 0=show as table, 1 show as textonly
	var dpList = [], dpList1 = [];
	var label = "";
	var bContinue = true;
	var tempObj;
	var bShow = true;
	var bShowFloor = true;
	var units = "";
	var color = "";
	var item;
	var writeable = "";
	var bReadonly;
	var bWrite = false;
	var iXoffset = 0, iYoffset = 0, iTemp; 
	var bLocalContextSettingsUsed = true;
	var bAtLeastOneDeviceFound = false;
	
	if(contextobj === null) 
		return;
	try {
		customFields = contextobj.customFields;
		if(contextobj.contextType !== "FLOOR")
			iDpDisplayType = 1;

		for(x in customFields)
		{
			x1 = x.toLowerCase();
			if(x1 === "label")
				label = customFields[x];
			else if (x === "offsetx") {
				sTemp1 = customFields[x];
				try {
					iTemp = Number(sTemp1);
					if(!isNaN(iTemp))
						iXoffset = iTemp;
				}
				catch {}
			}
			else if (x === "offsety") {
				sTemp1 = customFields[x];
				try {
					iTemp = Number(sTemp1);
					if(!isNaN(iTemp))
						iYoffset = iTemp;
				}
				catch {}
			}
			else if (x === "show") {
				
				if(customFields[x].toLowerCase() === "false")
					bShow = false;
			}
			else if (x === "floor") {
				
				if(customFields[x].toLowerCase() === "false")
					bShowFloor = false;
			}
			else if(x.startsWith("dp")) {
				obj = {};
				obj.name = x + " ";
				obj.parameters = customFields[x];
				dpList1.push(obj);
			}
		}
		x = null;
		if(contextobj.contextType === "FLOOR") {
			if(!bShowFloor)
				return; // don't show on floor context
		}
		else {
			if(!bShow)
				return; // don't show on floor context
		}
		if(label !== "")
			sTemp += label + "<br>"; 
		if(dpList1.length > 0) {
			// reorder
			for(i=0; i < dpList1.length; i++)
			{
				dpList.unshift(dpList1[i]);
			}
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (dpList.length - 1); i++)
				{
					if(dpList[i].name > dpList[i + 1].name) {
						tempObj = JSON.parse(JSON.stringify(dpList[i]));
						dpList[i] = JSON.parse(JSON.stringify(dpList[i + 1]));
						dpList[i + 1] = tempObj;
						bContinue = true;
					}
				}
			}
		}
		if(dpList1.length === 0) {
			// no context dps so use campus tags
			bLocalContextSettingsUsed = false;
			if(g_campusTags !== null) {
				if(g_campusTags.deviceTypesList.length > 0) {
					devices = contextobj.devices;
					if(devices.length > 0) {
						for(i=0; i < devices.length; i++)
						{
							for(k=0; k < g_campusTags.deviceTypesList.length; k++)
							{
								for(m=0; m < g_campusTags.deviceTypesList[k].dpList.length; m++)
								{
									for(j=0; j < 3; j++)
									{		
										if(j===0) {
											// looks for device name
											if((g_campusTags.deviceTypesList[k].type === "devicename") && (g_campusTags.deviceTypesList[k].name === devices[i].name.toLowerCase())) {
												if((bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("floor") !== -1))
													|| (!bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("room") !== -1))) {
														obj = {};
														obj = JSON.parse(JSON.stringify((g_campusTags.deviceTypesList[k].dpList[m])))
														obj.name = devices[i].name + "/" + obj.name;
														dpList.push(obj);
														break;
												}
											}
										}
										else if(j===1) {
											// look for device type
											if((g_campusTags.deviceTypesList[k].type === "devicetype") && (g_campusTags.deviceTypesList[k].name === devices[i].deviceTypeName.toLowerCase())) {
												if((bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("floor") !== -1))
													|| (!bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("room") !== -1))) {
														obj = {};
														obj = JSON.parse(JSON.stringify((g_campusTags.deviceTypesList[k].dpList[m])))
														obj.name = devices[i].name + "/" + obj.name;
														dpList.push(obj);
														break;
												}
											}
										}
										else  {
											// look for programid
											if((g_campusTags.deviceTypesList[k].type === "programid") && (g_campusTags.deviceTypesList[k].name === devices[i].programId.toLowerCase())) {
												if((bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("floor") !== -1))
													|| (!bFloor && (g_campusTags.deviceTypesList[k].dpList[m].contexts.indexOf("room") !== -1))) {
														obj = {};
														obj = JSON.parse(JSON.stringify((g_campusTags.deviceTypesList[k].dpList[m])))
														obj.name = devices[i].name + "/" + obj.name;
														dpList.push(obj);
														break;
												}
											}
										}
									}
								}
							}
						}
						// reorder based on context
						if(dpList.length > 0) {
							bContinue = true;
							while(bContinue)
							{
								bContinue = false;
								for(i=0; i < (dpList.length - 1); i++)
								{
									if(dpList[i].contextOrder > dpList[i + 1].contextOrder) {
										tempObj = JSON.parse(JSON.stringify(dpList[i]));
										dpList[i] = JSON.parse(JSON.stringify(dpList[i + 1]));
										dpList[i + 1] = tempObj;
										bContinue = true;
									}
								}
							}
						}
					}
				}
			}
		}
		for(k=0; k < dpList.length; k++)
		{
			displayType = "r";
			label = "";
			units = "";
			color = "";
			sTemp1 = "";
			bReadonly = false; //bReadonly = true;
			try {
				if(bLocalContextSettingsUsed) {
					if(dpList[k].parameters !== "") {
						
						sTemp1 = dpList[k].parameters;
						bWrite = false;
						
						if(sTemp1.indexOf(",") !== -1)
							items = sTemp1.split(",");
						else 
							items.push(sTemp1);
							
							
						try {
							for(i=0; i < items.length; i++)
							{
								item = items[i].trim();
								if(i===0) {
									//datapoint path
								}
								else if(item.startsWith("label=")) {
									label = item.substr("label=".length).trim();
								}
								else if(item.startsWith("displaytype=")) {
									
									displayType = item.substr("displaytype=".length).toLowerCase();
									if((displayType === "l2") || (displayType === "l3") || (displayType === "l4") || (displayType === "s2") || (displayType === "s3") || (displayType === "s4")){
										// datapoint needs to be SNVT_switch
									}
									else if(displayType === "r") {
										// read-only "n"
									}
									else
										displayType = "n";
								}
								else if(item.startsWith("units=")) {
									units = item.substr("units=".length);
								}
								else if(item.startsWith("color=")) {
									color = item.substr("color=".length);
								}
								else if(item.startsWith("write=")) {
									// need to take into account write priorities
									// all datapoints are read-only unless specifed by write.  valid "all", "none", or combination of "o" = owner, "s" = supervisor, "u" = user
									//   e.g.,   "write=owner" means write for only owner, "write=super" means write for owner and supervisor, 
									sTemp1 = item.substr("write=".length).toLowerCase();
									writeable = 0;
									if(sTemp1 === "all")
										writeable = 7;
									else {
										
										if(sTemp1 === "none") {
										}
										else if(sTemp1 === "owner")
											writeable = 4;
										else if(sTemp1 === "super")
											writeable = 6;
									}
									bWrite = false;
									if(g_bSingleUserType)
										bWrite = checkIfUserTypeSupported(writeable);
									else if(writeable === "all")
										bWrite = true;
								}
								else if(item.startsWith("readonly=")) {
									sTemp1 = item.substr("readonly=".length);
									if(sTemp1 === "false")
										bReadonly = false;
								}
							} // for(i=0; i < items.length; i++)
						}
						catch {}
							
						obj = {};
						obj.displayType = displayType; 
						obj.field = "";
						obj.fieldPath = "";
						sTemp1 = items[0].trim();
						sTemp1 = getPlanningFloorPlanShowContextDpsDeviceName(sTemp1, contextobj);
						
					}
				}
				else { 	//Use Campus Tags bLocalContextSettingsUsed = false;
					sTemp1 = dpList[k].name;
					displayType = dpList[k].contextDisplayType;
					label = dpList[k].label
					units = dpList[k].units;
					color = dpList[k].backgroundColor;
					bReadonly = dpList[k].readonly;
					
				}

				if(sTemp1 !== "") { // full path using device name
					obj = {};
					obj.displayType = displayType; 
					obj.field = "";
					obj.fieldPath = "";
					
					nameItems = sTemp1.split("/");
					sTemp1 = "";
					for(i=0; i < nameItems.length; i++)
					{
						nameItems[i] = nameItems[i].trim();
						if(i !== 0) {
							sTemp1 += "/";
							obj.fieldPath += "/";
						}
						sTemp1 += nameItems[i];
						if(i > 3) {
							if(obj.field !== "")
								obj.field += "/";
							obj.field += nameItems[i];
						}
						
						obj.fieldPath += nameItems[i];
					}
					if(label === "")
						label = nameItems[nameItems.length - 1]
					obj.label = label;
					g_iDisplayIndex ++;
					obj.path = nameItems[0] + "/" + nameItems[1] + "/" + nameItems[2] + "/" + nameItems[3];
					obj.displayIndex = g_iDisplayIndex;
					obj.fieldPath = sTemp1;
					obj.displayId = g_iDisplayIndex + "__"  + sTemp1;
					obj.divDisplayId = "";
					obj.readonly = bReadonly;
					//obj.bWriteable = bWrite; // "" = read-only
					obj.backgroundColor = color;

					if(iDpDisplayType === 0) {
						sTemp += "<tr id=\"contextDpDivRow_" + g_iDisplayIndex + "__"  + sTemp1 + "\"><td>";
						sTemp += "<div id=\"datapointName_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\" style=\"display:flex\">"
						sTemp += "<div id=\"bell_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\"></div>"
						sTemp += label + "</div></td><td>";
						sTemp += "<div  id=\"contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1 + "\" ></div>"
						obj.divDisplayId = "contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1;
						
						if(units !== "") 
							sTemp += "&nbsp;" + units;
						sTemp += "</td></tr>";
					}
					else {
						//if((sTemp !== "") && bAddBr)
						//	sTemp += "<br>"
						if(displayType === "r") {
							
							sTemp += "<div class=\"contextDpDivRow\">";
							sTemp += "<div id=\"datapointName_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\" style=\"display:flex\">"
							sTemp += "<div id=\"bell_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\"></div>"
							sTemp += "<div class=\"contextDpDivLabel\">";
							if(g_bShowContextDpLabels)
								sTemp +=  label + ": ";
							sTemp +=  "</div></div>";
							//sTemp += "<span id=\"localValue_" + g_iDisplayIndex + "__" + sTemp1 + "\" ></span>";
							
							sTemp += "<div  class=\"contextDpDivValue\" id=\"contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1 + "\" ></div>";
							
							obj.divDisplayId = "contextDpDiv_" + g_iDisplayIndex + "__" + sTemp1;
							bAddBr = true;
						}
						else {
							sTemp += "<div class=\"contextDpDivRow\">";
							sTemp += "<div id=\"datapointName_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\" style=\"display:flex\">"
							sTemp += "<div id=\"bell_" +  + g_iDisplayIndex + "__"  + sTemp1 + "\"></div>"
							sTemp += "<div class=\"contextDpDivLabel\">";
							if(g_bShowContextDpLabels)
								sTemp +=  label + ": "; 
							sTemp +=  "</div></div>";
							sTemp += "<div  class=\"contextDpDivValue\" id=\"contextDpDiv_" + g_iDisplayIndex + "__"  + sTemp1 + "\" ></div>";
							
							obj.divDisplayId = "contextDpDiv_" + g_iDisplayIndex + "__" + sTemp1;
							
							bAddBr = false;
						}
						if(units !== "") 
							sTemp += "<div>&nbsp;" + units + "</div>";
						sTemp += "</div>"
					}
					
					g_displayTypeList.push(obj); // used to use "s3" or "s4" for SNVT_switch
					for(i=0; i < deviceListAll.length; i ++)
					{

						if(deviceList[i].name.toLowerCase() === nameItems[0].toLowerCase()) {
							
							z = -1;
							for(j=0; j< g_sContextDpQualifierDeviceList.length; j++)
							{
								if(g_sContextDpQualifierDeviceList[j].deviceId === deviceListAll[i].id) {
									bAtLeastOneDeviceFound = true;
									z = j;
									break;
								}
							}
							if(z === -1) {
								obj = {};
								obj.deviceId = deviceListAll[i].id;
								obj.deviceName = deviceListAll[i].name; //deviceListAll[i].deviceName;
								g_sContextDpQualifierDeviceList.push(obj); // used for alarms
								bAtLeastOneDeviceFound = true; // needed for single datapoint
							}


							if(g_sContextDpQualifierList !== "")
								g_sContextDpQualifierList += ",";
							g_sContextDpQualifierList += encodeUriString(g_iSmarserverSid + "/" +  deviceListAll[i].protocol + "/" + deviceListAll[i].DID + "/" + nameItems[1] + "/" + nameItems[2] + "/" + nameItems[3]);
							break;
						}
					}
				}
			}
			catch {}
			
		} //for(k=0; k < dpList.length; k++)
		if(sTemp !== "") {  
			if(iDpDisplayType === 0)
				content = "<table class=\"tableInContext\">" + sTemp + "</table>";
			else
				content = sTemp;
		}
	}
	catch {
		content = "";
	}
	// place on image
	try {
		if(content !== "") {
			if((contextobj.contextType === "FLOOR") || (!g_bShowRoomTableContextOnImage)) {
				document.getElementById("planningPaneDetails").innerHTML += "<br>" + content;
				//document.getElementById("planningPaneDetails").innerHTML += "<div style=\"inline-block\">" + sTemp + "</div>";
			}
			else {
				//room and area
				z = -1;
				x = null;
				y = null;
				for(i=0; i <g_planningFloorplanGroups.length; i++)
				{
					for(j=0; j < g_planningFloorplanGroups[i].deviceList.length; j++)
					{
						for(k=0; k < g_planningFloorplanGroups[i].deviceList[j].contexts.length; k++)
						{
							if(g_planningFloorplanGroups[i].deviceList[j].contexts[k] === contextobj.id) {
								x = g_planningFloorplanGroups[i].textX;
								y = g_planningFloorplanGroups[i].textY;
								z = contextobj.id;
								break;
							}
						}
						if(z !== -1)
							break;
					}
					if(z !== -1)
							break;
				}
				if((x !== null) && (y !== null) && bAtLeastOneDeviceFound) {

					//x += g_iContextTableOffsetX; // + contextobj.iContextTableX;
					//y += g_iContextTableOffsetY; // + contextobj.iContextTableY;
					sTemp = "<div style=\"position:absolute;left:";
					if((iXoffset === 0) && (iYoffset === 0))
						sTemp += (x + g_iContextTableOffsetX);
					else
						sTemp += (x + iXoffset);
					sTemp += "px;top:";
					if((iXoffset === 0) && (iYoffset === 0))
						sTemp += (y + g_iContextTableOffsetY);
					else
						sTemp += (y + iYoffset);
					content = sTemp + "px; background-color:white;padding:5px;border-radius:10px;border: 1px solid black;z-index:5\">" + content + "</div>"
					document.getElementById("planningPaneDetails").innerHTML += content;
				}
			}
		}
	}
	catch {}
	return content;
}
function getPlanningFloorPlanShowContextDpsDeviceName(path, contextobj) {
	// check if device name, device type starts with "[", or program ID starts with "("
	var sResult = path, device;
	var i, iPtr; 
	var blockpath = "";
	var devices = [];
	var bDeviceType = false;
	try {
		sResult = sResult.trim();
		if(contextobj.contextType === "FLOOR")
			devices = deviceListAll;
		else 	if(contextobj.devices !== null) 
			devices = contextobj.devices;
		if(devices.length > 0)	{
			iPtr = path.indexOf("/");
			if(iPtr > 2) { //   {x}/ or [x]/
				device = path.substr(0, iPtr).toLowerCase();
				blockpath = path.substr(iPtr);
				sResult = "";
				if((device.charAt(0) === "[") || (device.charAt(0) === "(")) {
					if(device.charAt(0) === "[")
						bDeviceType = true;
					device = device.substr(1, iPtr - 2).toLowerCase();
					for(i=0; i < devices.length; i++)
					{
						if(bDeviceType) { //sResult.charAt(0) === "[") {
							//check against device types
							if(device === devices[i].deviceTypeName.toLowerCase()) {
								sResult = devices[i].name + blockpath;
								break;
							}

						}
						else {
							// check against program ID
							if(device === devices[i].programId.toLowerCase()) {
								sResult = devices[i].name + blockpath;
								break;
							}

						}
					}
				}
				else  {
					sResult = "";
					for(i=0; i < devices.length; i++)
					{
						
						if(device === devices[i].name.toLowerCase()) {
							sResult = devices[i].name + blockpath;
							break;
						}

					}
				}
			}
			
		}
		else
			sResult = "";
	} catch { sResult = path; }
	return sResult;
}
function getPlanningContextDpsListResponse(mode, requestUrl, json) {
	// got context datapoint (e.g, floor, room, area)
	var i, z, j, k;
	var missingValueDps = [];
    var missingSnvtTypes = [];
	try {
		if(json === null)
			return;
		if(json.length === 0)
			return;
		obj = {};
		obj.mode = mode;
		dashboardDpList = JSON.parse(JSON.stringify(json));
		// check if any have value = null
		for(i=0; i < json.length; i++)
		{
			if(json[i].value === null) {
				missingValueDps.push(JSON.parse(JSON.stringify(json[i])))
				
			}
		}
		if(missingValueDps.length > 0){
			//alert("showDashboardUi at least one \"value=null\""); // remove
		   
			for(i=0; i < missingValueDps.length; i++)
			{
				z = -1;
				for(j=0; j < missingSnvtTypes.length; j++)
				{
					if(missingValueDps[i].type ===  missingSnvtTypes[j]) {
						z = j;
						break;
					}
				}
				if(z === -1 )
				missingSnvtTypes.push(JSON.parse(JSON.stringify(missingValueDps[i].type)));
			}
			if(missingSnvtTypes.length > 0) {
				// check if already have SNVT type
				k = 0;
				if(g_snvtTypes.length > 0) {
					z = -1;
					for(i=0; i < missingSnvtTypes; i++)
					{
						for(j=0; j < g_snvtTypes.length; j++)
						{
							if(g_snvtTypes[j].typeId === missingSnvtTypes[i]) {
								z = j;
								break;
							}

						}
					}
					if(z === -1)
						k++;
				}
				else {
					k = missingValueDps.length;
				}
			}
			//alert("Count Dps with value=null: " + missingValueDps.length + ",\r\nmissingSnvtTypes: " + missingSnvtTypes.length + ",\r\nNot In SnvtTypesList: " + k);
			if(k !== 0) {
				if(missingSnvtTypes.length === 1) {
					// get only the missing SNVT Type
					showDashboardUiGetSnvtType(0, obj, missingSnvtTypes[0]);
				}
				else {
					// get all SNVT types
					showDashboardUiGetAllSnvtType(0, obj)
				}
				return;
			}
			
		}
		if(dashboardDpList.length > 0)
			getPlanningContextDpsListResponseBuildUi(obj);
	}
	catch {}
}
function getPlanningContextDpsListResponseBuildUi(objList) {
	// got context datapoint (e.g, floor, room, area)
	// When first starting up or device just added it is posible that the datapoint value is null, so need to leave element blank until value read
	try {
		// use s1 for span with 
		var i, j, k, m, s, w, x, z, z1;
		var json, mode;
		var pathname, programmaticPathname, presetValue, sTemp, colorElement, color,colorType;
		var value, valueStr, locValue, locValueStr;
		var iPtr;
		var d = new Date();
		var currentTimeMs = d.getTime();
		var t = d.toTimeString();
		var date = d.toLocaleDateString();
		var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
		var currentTime1 = currentTime + "T";
		var utcTime = d.toUTCString();
		var element, element1, obj, obj1;
		var displayElement = {};
		var displayIndex = 0, displayId, displayElementIndex;
		var bContinue,bContinue2, field, fieldItems;
		
		currentTime += " ";
		iPtr = t.indexOf(" ");
		t = t.substr(0, iPtr);
		currentTime += t + ".000";
		currentTime1 += t + ".000Z[UTC]";

		if(dashboardDpList === null)
			return;
		if(dashboardDpList.length === 0)
			return;
		mode = objList.mode;
		json = JSON.parse(JSON.stringify(dashboardDpList));
		dashboardDpList = [];
		for(i=0; i < json.length; i++)
		{
			z = -1;
			programmaticPathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].datapointName; 
			for(j=0; j < dashboardDpList.length; j++) 
			{
				if(dashboardDpList[j] === programmaticPathname) {
					z = j;
					break;
				}
			}
			if(z === -1) {
				// create dp obj
				obj = {};
				obj = JSON.parse(JSON.stringify(json[i]));
				colorElement = null; color = ""; colorType = "";
				
				//obj.cat = "out"; // Only want DPs, writes not supported
				obj.datapointQualifier = json[i].dpQualifier;
				obj.updateDpValue = true;
				
				pathname = json[i].deviceName + "/" + json[i].blockName  + "/" + json[i].blockIndex  + "/" + json[i].name;
				obj.programmaticPathname = programmaticPathname;
				obj.pathname = pathname;
				obj.block = json[i].blockName  + "/" + json[i].blockIndex;
				obj.urlPath = json[i].deviceName + "/if/" + json[i].blockName + "/" + json[i].blockIndex + "/";
				if(g_iSmartServerVersion >= 320114)
					obj.urlPath += "*+xifName==";
				obj.urlPath += json[i].datapointName;
				obj.dpName = json[i].name;
				try { 
					presetValue = json[i].presetValue;
					if(presetValue === null)
						presetValue = "";
				} catch (err) {}
				obj.presetValue = presetValue;
				obj.bStructure = false;
				obj.bNumber = false;
				obj.bString = false; // enum
				obj.alarm = null;
				obj.displayElements = []; // add one entry for each display element -- used to support fields, or see datapoint more than once on web page
				obj.writePriority = g_OwnerUserTypeWritePriority;
				obj.clearPriority = g_OwnerUserTypeClearPriority;
				obj.custom = {};
				obj.custom.useDefaults = true;
				if(g_currentUser === "SUPERVISOR") {
					obj.writePriority = g_supervisorUserWriteTypePriority;
					obj.clearPriority = g_supervisorUserTypeClearPriority;
				}
				else if(g_currentUser === "USER") {
					obj.writePriority = g_userUserTypeWritePriority;
					obj.clearPriority = g_userUserTypeClearPriority;
				}
				obj.writePriorityStart = 1; 
				obj.writePriorityEnd = 17;
				obj.writePriorityNormal = true;
				if(obj.cat === "in") {
					if(obj.writePriority !== "all") {
						try {
							z = obj.writePriority;
							if(obj.writePriority.charAt(0) !== ">") {
									// single priority
									obj.writePriorityStart = Number(z);
									if((obj.writePriorityStart > 0) && (obj.writePriorityStart < 18)) {
										jobj.writePriorityEnd = obj.writePriorityStart + 1;
										obj.writePriorityNormal = false;
									}
							}
							else {
								// priority 
								if(z.length > 1) {
									z = z.substr(1);
									obj.writePriorityStart = Number(z);
									if((obj.writePriorityStart > 0) && (obj.writePriorityStart < 18)) {
										obj.writePriorityNormal = true;
									}
								}
							}
						}
						catch {
							obj.writePriorityStart = 1
							objwritePriorityEnd = 17;
							obj.writePriorityNormal = true;
						}
					}
				}


				// check if alarm
				for(m=0; m < g_deviceAlarmsList.length; m++)
				{
					if(g_deviceAlarmsList[m].deviceId === obj.deviceId) {
						for(k=0; k < g_deviceAlarmsList[m].alarms.length; k++)
						{
							if(g_deviceAlarmsList[m].alarms[k].pathname === obj.pathname) {
								obj.alarm = JSON.parse(JSON.stringify(g_deviceAlarmsList[m].alarms[k]));
								m = g_deviceAlarmsList.length + 2;
								break;
							}
						   
						}
					}
				}  



				dashboardDpList.push(obj);
				z = dashboardDpList.length - 1;
			
				value = dashboardDpList[z].value;
			
				value = dashboardDpList[z].value;
				displayIndex ++;
				displayId = displayIndex + dashboardDpList[z].programmaticPathname;
				z1 = -1;
				for(k=0; k < g_snvtTypes.length; k++)
				{
					if(obj.type === g_snvtTypes[k].typeId) {
						z1 = k;
						dashboardDpList[z].snvtType = JSON.parse(JSON.stringify(g_snvtTypes[k]))
						break;
					}
				}
				if(z1 !== -1) {
					obj1 = JSON.parse(JSON.stringify(g_snvtTypes[z1]));
					
					if(obj1.valueType.toLowerCase() === "object") {
						dashboardDpList[z].bStructure = true;
					}
					else if(obj1.valueType.toLowerCase() === "boolean") {
						dashboardDpList[z].bNumber = true;
						//dashboardDpList[z].bBoolean = true;
						
					}
					else if(obj1.valueType.toLowerCase() === "enum") {
						dashboardDpList[z].bEnum = true;
						dashboardDpList[z].enums = JSON.parse(JSON.stringify(obj1.typeJson.enum));
					}
					else if(obj1.valueType.toLowerCase() === "string") {
						dashboardDpList[z].bString = true;
					}
					else if((obj1.valueType.toLowerCase() === "integer") || (obj1.valueType.toLowerCase() === "float")){
						dashboardDpList[z].bNumber = true;
					}
				}
				if(dashboardDpList[z].value === null) {
					valueStr = "";
					locValue = "";
					locValueStr = "";
					
					
				}
				else {
					try {
						if(!(typeof dashboardDpList[z].locValue === "undefined"))  {
							locValue = dashboardDpList[z].locValue;
							locValueStr = locValue;
							if(locValue !== null) {
								if(typeof locValue === "number") {
									locValueStr = locValue.toString();
									dashboardDpList[z].bNumber = true;
								}
								else if(typeof locValue === "object") {
									dashboardDpList[z].bStructure = true;
									locValueStr = JSON.stringify(locValue);
									if(locValueStr.length > 2) {
										if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
											dashboardDpList[z].bStructure = true;
											locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
										}
									}
								}
							}
						}	
					} 	catch (err) {}


					
					if(typeof value === "number")
						valueStr = value;
					else
						valueStr = JSON.stringify(value);
				}
				dashboardDpList[z].valueStr = valueStr;
				dashboardDpList[z].locValue = locValue;
				dashboardDpList[z].locValueStr = locValueStr;
				// check displaytype
				
				for(j=0; j < g_displayTypeList.length; j++)
				{ //check device types 
					try {
						// currently only support read only
						if(g_displayTypeList[j].path === dashboardDpList[z].programmaticPathname) {
							displayElementIndex = -1;
							displayElement = {};
							displayElement.dashboardType =g_displayTypeList[j].displayType; // normal
							displayElement.defaultDashboardType = ""; // normal
							displayElement.field = g_displayTypeList[j].field;
							displayElement.fieldPath = g_displayTypeList[j].fieldPath;
							displayElement.backgroundColor = "";
							if(g_displayTypeList[j].backgroundColor !== "")
								displayElement.backgroundColor = g_displayTypeList[j].backgroundColor;
							displayElement.displayIndex = g_displayTypeList[j].displayIndex
							displayElement.displayId = g_displayTypeList[j].displayId;
							displayElement.bNumber = false;
							displayElement.bEnum = false;
							displayElement.enums = [];
							displayElement.bStructure = false;
							displayElement.bString = false;
							displayElement.bBoolean = false;
							displayElement.readonly = g_displayTypeList[j].readonly;
							displayElement.writeable = false; // should be able to rmove this
							displayElement.chartIndex = null;
							displayElement.bHasPriorityButton = false;
							displayElement.dpTypeNotAssigned = true;
							
							if(typeof dashboardDpList[z].snvtType !== "undefined") {
								dpTypeParams = readSnvtTypeFieldValue(dashboardDpList[z].snvtType, displayElement.field);
								if(dpTypeParams.valid) {
									displayElement.dpTypeNotAssigned = false;
									if(dpTypeParams.data.valueType.toLowerCase() === "object") {
										displayElement.bStructure = true;
									}
									else if(dpTypeParams.data.valueType.toLowerCase() === "boolean") {
										displayElement.bBoolean = true;
										
									}
									else if(dpTypeParams.data.valueType.toLowerCase() === "bitfield") {
										displayElement.bNumber = true;
										
									}
									else if(dpTypeParams.data.valueType.toLowerCase() === "enum") {
										displayElement.bEnum = true;
										displayElement.enums = JSON.parse(JSON.stringify(dpTypeParams.data.typeJson.enum));
									}
									else if(dpTypeParams.data.valueType.toLowerCase() === "string") {
										displayElement.bString = true;
									}
									else if((dpTypeParams.data.valueType.toLowerCase() === "integer") || (dpTypeParams.data.valueType.toLowerCase() === "float")){
										displayElement.bNumber = true;
									}
								}
							}
							else {
								if(dashboardDpList[z].value !== null) {
									if(typeof dashboardDpList[z].value === "object")
										dashboardDpList[z].bStructure = true;
								}
							}
							bContinue = true;
							if((displayElement.field !== "")  && dashboardDpList[z].bStructure) {
								locValue = dashboardDpList[z].locValue;
								
									
								if(dashboardDpList[z].value === null) {
                                    //fix need to support value=null by looking at SNVT type
                                    
                                    locValueStr = "";
                                    if(typeof dashboardDpList[z].snvtType !== "undefined")
                                    	bContinue = false;
                                }
								else if(typeof locValue === "object") {
									fieldItems = readFieldValue(locValue,displayElement.field);
                                    if(fieldItems.valid) {
                                        locValue = fieldItems.data;
                                        bContinue = true;
                                    }
								}
								else 
									bContinue = false;
								
							}
							else {
								
								
								
							}
							if(bContinue) {
								if(typeof dashboardDpList[z].snvtType === "undefined") {
									if(typeof locValue === "string") {
										displayElement.bString = true;
	
									}
									else if(typeof locValue === "number") {
										displayElement.bNumber = true;
										
									}
									else if(typeof locValue === "boolean") {
										displayElement.bBoolean = true;
										
									}
								}
							}
							if(bContinue) {
								if(typeof dashboardDpList[z].snvtType === "undefined") {

								}
								if(displayElement.bStructure) { //if(typeof locValue === "object") {
									if(g_displayTypeList[j].displayType === "r")
										g_displayTypeList[j].displayType = ""; //
									locValueStr = JSON.stringify(locValue);
									if(locValueStr.length > 2) {
										if((locValueStr.charAt(0) === "{") && (locValueStr.charAt(locValueStr.length - 1) === "}")) {
											locValueStr = locValueStr.substr(1, (locValueStr.length - 2));
										}
									}
								}
								else if(typeof locValue === "number") {
									locValueStr = locValue.toString();
								}
								else if(typeof locValue === "boolean") {
									locValueStr = locValue.toString();
								}
								
								//tablePaneContent += "<td id=\"datapointName_" + displayId + "\"";
								//w = 0;
								


								element = document.getElementById(g_displayTypeList[j].divDisplayId)
								if(element !== null) {
									displayElement.dashboardType = "r";
									dashboardDpList[z].displayElements.push(displayElement);
									displayElementIndex = dashboardDpList[z].displayElements.length - 1;

									if(dashboardDpList[z].alarm !== null) { 
										if((dashboardDpList[z].alarm.warningLevel < 5) && ((g_iAlarmDisplayType === 1) || (g_iAlarmDisplayType === 3)))  {
											//element = document.getElementById("contextDpDivRow_" + g_displayTypeList[j].divDisplayId);
											element1 = document.getElementById("datapointName_" + displayElement.displayId);
											if(element1 !== null) {
												element1.style.backgroundColor = g_alarmColors[dashboardDpList[z].alarm.warningLevel]; 
												// add vell
												
												sTemp = "<img src=\"images/navtree/Bellred.gif\" alt=\"alarmimage\"onclick=\"alarmMenu(";
												if(!dashboardDpList[z].displayElements[displayElementIndex].readonly && ((displayElement.dashboardType === "s1") || (displayElement.dashboardType === "s2")  
													|| (displayElement.dashboardType === "s3")   || (displayElement.dashboardType === "s4")))
													sTemp += 1; // writable -- use menudpvalue
												else
													sTemp += 0; // readonly -- show only alarm state
												sTemp += ",this," + z + "," + displayElementIndex + ",'bell_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\"";
												sTemp += "><span style=\"margin-left:5px\"></span>";
												element1 = document.getElementById("bell_" + displayElement.displayId);
												if(element1 !== null)
													element1.innerHTML = sTemp;
												//w = 1;
											}
										}
									}




									if(g_displayTypeList[j].displayType === "d") { 
										dashboardDpList[z].displayElements[displayElementIndex].dashboardType = g_displayTypeList[j].displayType;
										sTemp = "";
										//sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" >" + locValueStr + "</span>";
										//if((g_bPlanningShowContextDpMenuButton) && (dashboardDpList[z].cat === "in"))
										//	sTemp += '<button class="planningContextDpMenuButton">...</button>';
										

										if(dashboardDpList[z].displayElements[displayElementIndex].bEnum) {
											//if((field === "") && dashboardDpList[i].isEnum) { // remove
											sTemp += "<div style=\"display:flex\"><select id=\"localValue_" + displayElement.displayId + "\" onchange=\"dashboardDropdownSelected(this," + z + ", " + displayElementIndex + ", '" + dashboardDpList[z].programmaticPathname + "','" + displayElement.displayId + "')\">"; 
											bHasPresets = false;
											valueStr = null; 
											if((field === "") && (dashboardDpList[z].presetValue !== ""))
												valueStr = dashboardDpList[z].presetValue;
											else {
												if(field === "")
													dashboardDpList[z].locValueStr;
												else
													valueStr = dashboardDpList[z].displayElements[displayElementIndex].locValueStr;
											}
											if((field === "") && (typeof dashboardDpList[z].presets !== "undefined")) {
												if(dashboardDpList[z].presets !== null) {
													if(dashboardDpList[z].presets.enabled) {
														if(dashboardDpList[z].presets.map.length > 0) {
															bHasPresets = true;
															for(s=0; s < dashboardDpList[z].presets.map.length; s++)
															{
																name1 = dashboardDpList[z].presets.map[s].name;
																sTemp += "<option value='" + name1 + "'"; 
																if(valueStr === name1)
																	sTemp += " selected";
																sTemp += ">"  + name1 + "</option>";
															}
															
														}
													}
												} 
											}
											enums = [];
											if(dashboardDpList[z].displayElements[displayElementIndex].enums.length > 0) 
												enums = JSON.parse(JSON.stringify(dashboardDpList[z].displayElements[displayElementIndex].enums));
											else {
												for(s=0; s < g_snvtTypes.length; s++)
												{
													if(dashboardDpList[z].type === g_snvtTypes[s].typeId) {
														enums = g_snvtTypes[s];
														temp = readSnvtTypeFieldValue(g_snvtTypes[s], field);
														if(temp.valid) {
															enums = JSON.parse(JSON.stringify(temp.datatypeJson.enum));
														}
													}
												}
											}
												
											for(s = 0; s < enums.length; s++)
											{
												sTemp += "<option value='" + enums[s].id + "'";
												if(valueStr === enums[s].id)
													sTemp += " selected";
												sTemp += ">"  + enums[s].id + "</option>";
											}
											sTemp += "</select>";
											addElementToEditButtonElementList("localValue_" + displayElement.displayId, "d", "disable");
											if(g_bPlanningShowContextDpMenuButton) {
												sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
												addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
											}
											sTemp += "</div>";
										}
										element.innerHTML = sTemp;
									}
									
									else if(g_displayTypeList[j].displayType === "r") { //mainly used for context datapoints
										dashboardDpList[z].displayElements[displayElementIndex].dashboardType = g_displayTypeList[j].displayType;
										
										sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" >" + locValueStr + "</span>";
										//if((g_bPlanningShowContextDpMenuButton) && (dashboardDpList[z].cat === "in"))
										//	sTemp += '<button class="planningContextDpMenuButton">...</button>';
										element.innerHTML = sTemp;
										
									}
									else if(g_displayTypeList[j].displayType === "n") {
										dashboardDpList[z].displayElements[displayElementIndex].dashboardType = g_displayTypeList[j].displayType;
										
										if((dashboardDpList[z].cat === "in") && !displayElement.readonly) {
											//element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpanInput\" onclick=\"menuDpShow(1)\">" + locValueStr + "</span>";

											if(dashboardDpList[z].displayElements[displayElementIndex].bStructure) {
												
												element.innerHTML = "<div style=\"display:flex\"><span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;border: 1px solid black;;overflow:hidden;white-space:nowrap\"";
												sTemp += " onclick=\"menuDpValue1(14, this, " + z + ", " + displayElementIndex + ", 'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s1";
												dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												addElementToEditButtonElementList("localValue_" + displayId, "s1", "disable");
                                    			if(g_bPlanningShowContextDpMenuButton) {
													sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
													addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
												}
												sTemp += "</div>"
											}
											else {
												//element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\">" + locValueStr + "</span>";
												sTemp = "<input id=\"localValue_" + displayElement.displayId + "\" value=\"" + locValueStr + "\"";
												z1=0;
												if(dashboardDpList[z].displayElements[displayElementIndex].field === "") {
													if(typeof dashboardDpList[z].presets !== "undefined") {
														if(dashboardDpList[z].presets.map.length > 0) {
															sTemp += " onclick=\"menuDpValue1(11,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\""
															sTemp += " readonly"; 
															z1 = 1;
														}
													}
												}
												if(z1 === 0) {
													sTemp += "	onkeyup=\"inputBoxKey(this, event, " + z + "," +  displayElementIndex + ",'" + displayElement.displayId + "')\"";
												}
												sTemp += ">";
												addElementToEditButtonElementList("localValue_" + displayElement.displayId, "i", "disable");
												if(g_bPlanningShowContextDpMenuButton) {
														sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
														addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
												}
												
												
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "n";
												
											}
											element.innerHTML = sTemp;
										}
										else {
											/*
											element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpan\"";
											if(typeof locValue === "object")
												element.innerHTML += " onclick=\"menuDpShow(0)\"";
											element.innerHTML += ">" + locValue + "</span>"; */

											dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "r";
											//class not working sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpan\"";
											if(typeof locValue === "object") {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;overflow:hidden;white-space:nowrap\"";
												sTemp += " onclick=\"menuDpPlanningShowStructuredDp(10,this," + z + "," + displayElementIndex + ",'" + programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s0";
											}
											else {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\">" + locValueStr + "</span>";
											}
											element.innerHTML = sTemp;
											
											
										}
										
									}
									else if((g_displayTypeList[j].displayType === "l2") || (g_displayTypeList[j].displayType === "l3") || (g_displayTypeList[j].displayType === "l4")
										|| (g_displayTypeList[j].displayType === "s2") ||(g_displayTypeList[j].displayType === "s3") || (g_displayTypeList[j].displayType === "s4")) {

											

											if(g_displayTypeList[j].displayType === "l2")	{ 
												
												if( (((dashboardDpList[z].type ===  "binary") || (dashboardDpList[z].type ===  "scalar") || (dashboardDpList[z].type ===  "boolean") || (dashboardDpList[z].type.toLowerCase() ===  "bit")
													|| (dashboardDpList[i].type ===  "SNVT_count")) && (displayElement.field === "")) 
														|| ((displayElement.field !== "") && displayElement.bNumber) ) {
													sTemp = '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													//sTemp = '<span id="localValue_' + displayElement.displayId + '"'; 
													if(dashboardDpList[z].value === null) {

													}
													else if(typeof locValue === "number") {
														if(locValue === 0)
															sTemp += ' class="ledDotOff"';
														else {
															sTemp += ' class="ledDotOn"';
															if(displayElement.backgroundColor !== ""){
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															}
														}
													}
													else if(typeof locValue === "bit") {
														if(locValue === 0)
															sTemp += ' class="ledDotOff"';
														else {
															sTemp += ' class="ledDotOn"';
															if(displayElement.backgroundColor !== ""){
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															}
														}
													}
													else if(typeof locValue === "boolean") {
														if(typeof locValue ===  "boolean") {
															if(locValue === 0)
																sTemp += ' class="ledDotOff"';
															else {
																sTemp += ' class="ledDotOn"';
																if(displayElement.backgroundColor !== ""){
																	sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
																}
															}
																
														}
														else {
															if(locValue === 0)
																sTemp += ' class="ledDotOff"';
															else {
																sTemp += ' class="ledDotOn"';
																if(displayElement.backgroundColor !== ""){
																	sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
																}
															}
																
														}
													}
													sTemp += '>';
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "l2";
												}
											}
											else if(g_displayTypeList[j].displayType === "s2")	{ // "l4"
												
												if((((dashboardDpList[i].type ===  "binary") || (dashboardDpList[i].type ===  "scalar") || (dashboardDpList[i].type ===  "boolean") || (dashboardDpList[i].type.toLowerCase() ===  "bit")
													|| (dashboardDpList[i].type ===  "SNVT_count"))  && (displayElement.field === "") ) || ((displayElement.field !== "") && displayElement.bNumber)) {
													//sTemp = '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													if((dashboardDpList[i].type ===  "boolean") && (typeof dashboardDpList[i].locValue === "string")) {
														sTemp = "<div style=\"display:flex\">";
														sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
														sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
														sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
														if(dashboardDpList[z].value === null) {

														}
														else if(locValue !== "false") {
															sTemp += ' checked';
														}
														sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
														if(dashboardDpList[i].backgroundColor !== "false"){
															if(locValue) 
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															
														}
														sTemp += '></span></label></div>';
														addElementToEditButtonElementList1("localValueSwitch_" + displayElement.displayId, "s2", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
														if(g_bPlanningShowContextDpMenuButton) {
															sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
															addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "disable");
														}
														stemp += "</div>";
													}
													else if(typeof locValue === "boolean") {
														sTemp = "<div style=\"display:flex\">";
														sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
														sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
														sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
														if(dashboardDpList[z].value === null) {

														}
														else if(locValue) {
															sTemp += ' checked';
														}
														sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
														if(dashboardDpList[z].value === null) {

														}
														else if(displayElement.backgroundColor !== ""){
															if(locValue) 
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															
														}
														sTemp += '></span></label></div>';
														addElementToEditButtonElementList1("localValueSwitch_" + displayElement.displayId, "s2", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
														if(g_bPlanningShowContextDpMenuButton) {
															sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
															addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "disable");
														}
														stemp += "</div>";
													}
													else  {
														sTemp = "<div style=\"display:flex\">";
														sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
														sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
														sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
														if(dashboardDpList[z].value === null) {

														}
														else if(locValue !== 0) {
															sTemp += ' checked';
														}
														sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
														if(dashboardDpList[z].value === null) {

														}
														else if(displayElement.backgroundColor !== "") {
															if(locValue !== 0) 
																sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
															
														}
														sTemp += '></span></label></div>';
														addElementToEditButtonElementList1("localValueSwitch_" + displayElement.displayId, "s2", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
														if(g_bPlanningShowContextDpMenuButton) {
															sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
															addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "disable");
														}
														sTemp += "</div>";
													}
													
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s2";
													dashboardDpList[z].displayElements[displayElementIndex].defaultDashboardType = "s2";
													dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												}
											}
											else if((dashboardDpList[z].type === "SNVT_switch") && (displayElement.field === "")) {
												if(g_displayTypeList[j].displayType === "l3")	{ // "l4"
													sTemp = "<div style=\"display:flex\">";
													sTemp += "<div>"; //sTemp += "<div style=\"width:70px\">"
													sTemp += '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' class="ledDotOn"';
														if(displayElement.backgroundColor !== ""){
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														}
													}
													else 
														sTemp += ' class="ledDotOff"';
													
													sTemp += '></span></div>';
													sTemp += '<div id="localValue_' + displayElement.displayId + '" style="margin-left:10px;width:30px;">' + locValue.value.toString() + '</div>'; 
																					
													sTemp += '</div>';
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "l3";
												}
												else if(g_displayTypeList[j].displayType === "s3")	{ // "l4"
													sTemp = "<div style=\"display:flex\">";
													sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">"; //sTemp += "<div style=\"width:70px\">"
													sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
													sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' checked';
													}
													sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
													if(displayElement.backgroundColor !== ""){
														if(locValue.state === 1) 
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														
													}
													sTemp += '></span></label></div>';
													sTemp += '<input id="localValue_' + displayElement.displayId + '" style="margin-left:10px;width:30px;"';
													if(dashboardDpList[z].value !== null) 
														sTemp += 'value="' + locValue.value.toString() + '"';
													sTemp += "	onkeyup=\"inputBoxKey(this, event, " + z + "," +  displayElementIndex + ",'" + displayElement.displayId + "')\"";
													sTemp += '>'; 
													addElementToEditButtonElementList1("localValueSwitch_" + displayElement.displayId, "s3", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
													addElementToEditButtonElementList("localValue_" + displayElement.displayId, "i", "disable");
													if(g_bPlanningShowContextDpMenuButton) {
														sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
														addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
													}
													sTemp += '</div>';
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s3";
													dashboardDpList[z].displayElements[displayElementIndex].defaultDashboardType = "s3";
													dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												}
												else if(g_displayTypeList[j].displayType === "l4")	{ 
													sTemp = '<span id="localValueSwitch_' + displayElement.displayId + '"'; 
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' class="ledDotOn"';
														if(displayElement.backgroundColor !== ""){
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														}
													}
													else 
														sTemp += ' class="ledDotOff"';
													
													sTemp += '>';
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "l4";
												}
												else if(g_displayTypeList[j].displayType === "s4")	{ 
													sTemp = "<div style=\"display:flex\">";
													sTemp += "<div id=\"sliderSwitch_" +  displayElement.displayId  + "\">";
													sTemp += "<label class=\"sliderSwitch\" ><input type=\"checkbox\"";
													sTemp += " id=\"localValueSwitch_" + displayElement.displayId + "\" onclick=\"sliderSwitchClicked(this, '" + displayElement.displayId + "', " + i + "," + displayElementIndex + ")\" class=\"sliderInput\" ";
													if(dashboardDpList[z].value === null) {

													}
													else if(locValue.state === 1) {
														sTemp += ' checked';
													}
													sTemp += '><span id="localValueSpan_' + displayElement.displayId + '" class="sliderSlider sliderRound"';
													if(dashboardDpList[z].value === null) {

													}
													else if(displayElement.backgroundColor !== ""){
														if(locValue.state === 1) 
															sTemp += " style=\"background-color:" + displayElement.backgroundColor + "\"";
														
													}
													sTemp += '></span></label></div>';
													addElementToEditButtonElementList1("localValueSwitch_" + displayElement.displayId, "s4", "disable", "localValueSpan_" + displayElement.displayId, z, displayElementIndex, displayElement.displayId);
													addElementToEditButtonElementList("localValue_" + displayElement.displayId, "s4", "disable");
													if(g_bPlanningShowContextDpMenuButton) {
														sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14,this, " + z + "," + displayElementIndex +  ",'localValueSwitch_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
														addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
													}
													sTemp += "</div>";
													element.innerHTML = sTemp;
													dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s4";
													dashboardDpList[z].displayElements[displayElementIndex].defaultDashboardType = "s4";
													dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
													element.classList.add("planningContextDpDiv");//	element.style.padding = "2px 2px";
												}
											}
											else {
												element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" >" + locValueStr + "</span>";
											}

									}
									else {
										if((dashboardDpList[z].cat === "in") && !dashboardDpList[z].displayElements[displayElementIndex].readonly) {
											//class not working element.innerHTML = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpanInput\" onclick=\"menuDpShow(1)\">" + locValueStr + "</span>";
											if(dashboardDpList[z].displayElements[displayElementIndex].bStructure) {
												
												sTemp =  "<div style=\"display:flex\"><span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;border: 1px solid black;;overflow:hidden;white-space:nowrap;text-overflow:ellipsis\"";
												sTemp += " onclick=\"menuDpValue1(14, this, " + z + ", " + displayElementIndex + ", 'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s1";
												dashboardDpList[z].displayElements[displayElementIndex].readonly = false;
												addElementToEditButtonElementList("localValue_" + displayElement.displayId, "s1", "disable");
												if(g_bPlanningShowContextDpMenuButton) {
													sTemp += "<button id=\"menu_" + displayElement.displayId + "\" class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(14, this, " + z + ", " + displayElementIndex + ", 'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
													addElementToEditButtonElementList("menu_" + displayElement.displayId, "menu", "visible");
												}
												sTemp += "</div>";
											}
											else {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\">" + locValueStr + "</span>";
												if(g_bPlanningShowContextDpMenuButton)
														sTemp += "<button class=\"planningContextDpMenuButton\" onclick=\"menuDpValue1(13,this, " + z + "," + displayElementIndex +  ",'localValue_" + displayElement.displayId + "','" + dashboardDpList[z].programmaticPathname + "')\">...</button>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "n";
											}
											element.innerHTML = sTemp;
										}
										else {
											dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "r";
											//class not working sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" class=\"contextDpSpan\"";
											if(typeof locValue === "object") {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\" style=\"display:inline-block;width:150px;overflow:hidden;white-space:nowrap;text-overflow:ellipsis\"";
												sTemp += " onclick=\"menuDpPlanningShowStructuredDp(10,this," + z + "," + displayElementIndex + ",'" + programmaticPathname + "')\">";
												sTemp += locValueStr + "</span>";
												dashboardDpList[z].displayElements[displayElementIndex].dashboardType = "s0";
											}
											else {
												sTemp = "<span id=\"localValue_" + displayElement.displayId + "\">" + locValueStr + "</span>";
											}
											element.innerHTML = sTemp;
										}
									}
									
								} // if(element !== null)
							} // if(bContinue)
							break;
						}
					}
					catch {}
					
				}
				/*
				if(dashboardDpList[i].dashboardType === "n") {
					element = document.getElementById("localValue_" + dashboardDpList[i].programmaticPathname);
					if(element !== null) {
						element.innerHTML = locValueStr;
					}
				}
				*/
			} // z=== -1
			
		} //for(i=0; i < dashboardDpList.length; i++)
		dashboardEditButtonProcess();
		createRequestString(dashboardDpList);
		if(bivUseWebSockets) {
			if(g_bAutoSubscribe) {
				if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
					subscribeRequest();
			}
		}
		g_bDashboardDataLogGetInProgress = false;
		dashboardProcessWebSocketDpData(currentTime, d.getTime(),  dashboardDpList);
		g_bPollingEnabled = true;
		g_iPollingRequestCount = g_iPollingRequestCountMax;
		ivbWsProcessDatapointUpdate = true; 
		try {
			// ivGetDeviceList(); // IOT get device list later
			if(g_timerId === 0)
				g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
		} catch (err) {} 
	}
	catch {}
}
function goBackToContext(contextId) {
	
	g_iPlanningPaneSelectedContextId = -1;
	getPlanningTreeShowTreeDetails(0, contextId);
}
function planningExpandDevicesNodeInTree() {
	var i, n;
	try {
		for(i=0; i < g_treeviewInitialCollapseList.length; i++)
		{
			if(g_treeviewInitialCollapseList[i].indexOf("treeDevicesButton") !== -1) {
				if(g_bPlanningShowDevice) {
					n = document.getElementById(g_treeviewInitialCollapseList[i]);
					if(n !== null) {
						if(!n.parentNode.parentElement.querySelector(".treeviewNested").classList.contains("treeviewActive")) {
							n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
							//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
							if(n.parentElement !== null ) {
								if(n.parentElement.parentElement !== null) {  
									if(n.parentElement.parentElement.nextSibling !== null) {
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
									}
									else { // last Li 
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
									}
								}
							}
							n.classList.toggle("treeviewCaret-down");
						}
					}
				}
				else {
					n = document.getElementById(g_treeviewInitialCollapseList[i]);
					if(n !== null) {
						if(n.parentNode.parentElement.querySelector(".treeviewNested").classList.contains("treeviewActive")) {
							n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
							//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
							if(n.parentElement !== null ) {
								if(n.parentElement.parentElement !== null) {  
									if(n.parentElement.parentElement.nextSibling !== null) {
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
									}
									else { // last Li 
										n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
									}
								}
							}
							n.classList.toggle("treeviewCaret-down");
						}
					}
				}
			}
		}

	}
	catch(err) {}
	if(g_bPlanningShowDevice) {
		g_bPlanningShowDevice = false;
		document.getElementById("planningTreeShowDevicesButton").innerHTML = "Hide All Devices"
	}
	else {
		g_bPlanningShowDevice = true;
		document.getElementById("planningTreeShowDevicesButton").innerHTML = "Show All Devices"
	}

}
function planningFavoritesCheckbox() {
	//remove not supported
	try {
		var checked,i;
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			checked = document.getElementById("favoritesCheckbox").checked;
			for(i=0; i < planningDpList.length; i ++)
			{
				document.getElementById("fav_" + planningDpList[i].pathname).checked = checked;
				addToFavorites1(1, planningDpList[i].pathname);
			}
		}
	}
	catch {}
}
function planningFavoritesReassign() {
	//remove not supported
	try { 
		var i, j;
		if(g_iMainDisplayMode === DISPLAYMODE_PLANNING) {
			if((planningDpList.length > 0) && (g_sPlanningTreeDatapointPath !== "")) {
				checked = document.getElementById("favoritesCheckbox").checked;
				for(i=0; i < planningDpList.length; i ++)
				{
					for(j=0; j < favDpList.length; j++ )
					{
						if(planningDpList[i].pathname === favDpList[j]. pathname) {
							document.getElementById("fav_" + planningDpList[i].pathname).checked = true;
							break;
						}
					}
					
					
				}
			}
		}
	}
	catch {}
}
function planningPollCheckBox() {
	var pollRate = document.getElementById("planningPollrate");
	var min;
	if(g_idpGetRequestIndex === -1)
		return;
	if(g_dpGetRequestArr[0] === "") 
		return;
	if(pollRate === null)
		return;
	
	pollRate = pollRate.value;

	if(pollRate === "") {
		alert("Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	if(isNaN(pollRate)) {
		alert("Error: Invalid poll rate value please enter a number (2 or greater)\r\n\r\n" + pollRate);
		return;
	}
	g_iPlanningPollInterval = document.getElementById("planningPollrate").value;
	
	
	if(planningDpList.length > 0) { 
		if(document.getElementById("planningPollCheckbox").checked) {
			g_bPlanningDpPollingEnabled = true;
			pollRate  = Number(pollRate );
			if(isNaN(pollRate ))
				return;
			g_iPollRate = pollRate;
			g_iPollingRequestCountMax = pollRate;
			min = Math.ceil(planningDpList.length / g_iMaxOfDpsToPollPerInterval);
			if(pollRate < (min * g_iBackgroundPollingRequestCountMax)) 
				g_iPollingRequestCountMax = min + 1;
			g_PollingType = g_iMainDisplayMode;
			//if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
			//	subscribeRequest();
			g_iBackgroundPollingRequestCount = 0; // wait as most time you are just moving back and forth to different DPs in the tree
			g_idpGetRequestIndex = 0;
			g_bPollingEnabled = true;
			
			ivbWsProcessDatapointUpdate = true;
			try {
				// ivGetDeviceList(); // IOT get device list later
				if(g_timerId === 0)
					g_timerId = window.setInterval("timerHandler()", g_iTimerInterval);
			} catch (err) {} 
		}
		else {
			g_bPlanningDpPollingEnabled = false;
			g_bPollingEnabled = false;
			ivbWsProcessDatapointUpdate = false;
			g_PollingType = 0;
		}
	}
}
function planningshowDashboard() {
	dashboardDpList = JSON.parse(JSON.stringify(planningDpList));
	//showDashboard(0, "", -1);
	g_bBuildDashboardDps = true;
	showDashboard(4, "", -1);
}
function planningshowDpInShowDatapoints(mode,pathname, programmaticPathname) {
	var pathItems;
	var url = "";
	try {
		pathItems = pathname.split("/");
		clearDpFilter(2,0,0);
		g_oDpFilter.device = pathItems[0];
		if(pathItems.length > 3){
			g_oDpFilter.blockName = pathItems[1];
			g_oDpFilter.blockIndex = pathItems[2];
			g_oDpFilter.datapointName = pathItems[3];
		}
		
		showAllDps(6);
		g_iMainDisplayMode = DISPLAYMODE_DPS;
		document.getElementById("displayLabel").innerHTML = "Device Datapoints: " + pathname;
		dpList = [];
		ivbWsProcessDatapointUpdate = true;
		pathItems = programmaticPathname.split("/");
		url = "/iap/devs/*+name==" + pathItems[0] + "/if/" + pathItems[1] + "/" + pathItems[2] + "/" + pathItems[3] + "/*";
		url = encodePathString(url);
		getOnDemandDpValues(0, url);
	}
	catch (err) {}
}
function  showPlanningTree() {
	showPlanningTreePane(0)
}
function showPlanningTreeCalendar(mode) {
	var id = "_TreeSchedules";
	try {
		g_iMainDisplayMode = DISPLAYMODE_SCHEDULE;
		menuCloseAll();
		document.getElementById("planningPaneDetails").innerHTML = "Getting Schedule data...";
		g_bPlanningDpPollingEnabled = false;
		g_bPollingEnabled = false;
		if(g_datalogWsClient !== null)	{
			g_datalogWsClient.close();
		}
		ivbWsProcessDatapointUpdate = false;
		g_bDeviceDataLogGetInProgress = false;
		g_PollingType = 0;
		g_scheduleDiv = 0;
		g_iScheduleView = 3; 
		g_editButtonElementList = [];
		// change color of tree context to indicate selected
		if(g_iPlanningPaneSelectedContextId !== -1) {
			treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
			if(treeContext !== null) {
				treeContext.classList.remove("treeSelected")
				//treeContext.style.color = "white";
			}
		}
		treeContext = document.getElementById("planningTreeContext_" + id);
		if(treeContext !== null) {
			//treeContext.style.color = "red";
			treeContext.classList.add("treeSelected")
		}
		g_iPlanningPaneSelectedContextId = id;
		showCalendar(0);
	}
	catch {}
}
function showPlanningTreeDetails(value) {
	g_iPlanningTreeShowDevices = Number(value);
	try {
		document.getElementById("planningDiv").className = "testDivHide";
		document.getElementById("planningOverlayDiv").className = "testDivHide";
	}
	catch {}
	if(g_iPlanningPaneSelectedContextId !== -1)
		getPlanningTreeShowTreeDetails(1, g_iPlanningPaneSelectedContextId);
}
function showPlanningTreePane(mode) {
	// mode: 4, show planning tree, get device list and then get planning data
	var i, element, color="lawngreen";
	var paneTitle = "<label>Planning</label><button id=\"planningTreeShowDevicesButton\" class=\"planningTreeShowDevicesButton\" onclick=\"planningExpandDevicesNodeInTree()\">";
	var displayObj = null;
	if(g_bPlanningShowDevice)
		paneTitle += "Show All Devices"
	else 
		paneTitle += "Hide All Devices"
	paneTitle += "</button>";
	savePrevousHtmlContent();
	if(mode === 4)
		initializeDisplay(4);
	else
		initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	//paneTitle += "<button onclick=\"showPlanningRefresh(0)\" style=\"float:right\">Refresh All</button>";
	//paneTitle += "<button id=\"planningRefreshButton\" onclick=\"showPlanningRefresh(1)\" style=\"float:right\">Refresh</button><button onclick=\"showPlanningRefresh(0)\" style=\"float:right\">Refresh All</button>";
	if(false) {
		paneTitle += "<div id=\"planningContextDetailsDiv\" style=\"display:inline-block;float:right;margin-left:300px\">";
		paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonDevice\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"0\"";
		if(g_iPlanningTreeShowDevices === 0)
			paneTitle += " checked";
		paneTitle += "> Floorplan (all Devices) ";
		paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonDevice\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"1\"";
		if(g_iPlanningTreeShowDevices === 1)
			paneTitle += " checked";
		paneTitle += "> Context Devices ";
		paneTitle += "<input type=\"radio\" id=\"planningTreeRadioButtonContextDetails\" name=\"planningTreeRadioButton\" onclick=\"showPlanningTreeDetails(this.value)\" value=\"2\"";
		if(g_iPlanningTreeShowDevices === 2)
			paneTitle += " checked";
		paneTitle += "> Context Details</div>";
	}
	var paneContent = "<div style=\"text-align:center\"><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting Planning and device Info ...</span></div>";
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;
	if(mode === 4)
		return;
	if(g_sPlanningPaneContent !== "") {
		document.getElementById("main").innerHTML = g_sPlanningPaneContent;
		//if((g_sPlanningPaneContent !== "") && (planningDpList.length === 0) && (g_iPlanningPaneSelectedContextId.indexOf("Device_") !== 0)) {
		if(g_sPlanningPaneContent !== "") {
			if(planningDpList.length !== 0) 
				document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
			else {
				if(typeof g_iPlanningPaneSelectedContextId === "string") {
					if(g_iPlanningPaneSelectedContextId.indexOf("Devices_") === 0) 
						document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
				}

			}
			//document.getElementById("planningRefreshButton").style.visibility = "hidden";
		}
		planningFavoritesReassign();
		// check if device status changed while looking at other view, ifso update tree
		for(i=0; i < deviceListAll.length; i++)
		{
			if(typeof deviceListAll[i].statusChanged !== "undefined") {
				if(deviceListAll[i].statusChanged) {
					element = document.getElementById("deviceStatus_" + deviceListAll[i].id);
					if(element !== null) {
						if(deviceListAll[i].category !== "SC")
							color = deviceStatusColor (status);
						element.style.backgroundColor = color;
						treeUpdateContextDeviceStatus(-1, deviceListAll[i].id);
					}
				}
			}
		}
		//reenable checkboxes
		element = document.getElementById("planningConfigCheckbox");
		if(element !== null) {
			if(g_bPlanningShowConfiguration)
				element.checked = true;
/*				
			if(g_bPlanningShowConfigurationSingleDp)
				treeShowConfiguration();
			else
				treeShowConfigurationAll();*/
		}
		element = document.getElementById("planningPollrate");
		if(element !== null)
			element.value = g_iPlanningPollInterval;
		element = document.getElementById("planningPollCheckbox");
		if(element !== null) {
			if(g_bPlanningDpPollingEnabled) {
				element.check = true;
				if(planningDpList.length > 0) {
					createRequestString(planningDpList);
					subscribeRequest();
					planningPollCheckBox();
				}
			}
		}
				
		return;
	}
	if(planningList !== null) {
		if(planningList.length > 0) {
			getplanningTreeShowTree(1);
			cursorClearWait();
			if(g_iPlanningPaneSelectedContextId !== -1) {
				// add focus code
				getPlanningTreeShowTreeDetails(0, g_iPlanningPaneSelectedContextId);
			}
			else {
				displayObj = document.getElementById("planningPaneDetails");
				if(displayObj !== null) {
					displayObj.innerHTML = "No Context Selected";
				}
			}
			return;
		}
	}
	getPlanningTree();
	
}
function showPlanningRefresh(mode) {
	try {
		var element = null;
		menuCloseAll();
		planningList = [];
		deviceListAll = [];
		g_deviceAlarmsList = [];
		g_contextImages = [];
		g_iPlanningPaneSelectedContextId = -1;
		g_bPlanningShowDevice = true;
		element = document.getElementById("planningTreeShowDevicesButton");
		if(element !== null) 
			element.innerHTML = "Show All Devices";
	
		if(mode === 0) {
			cursorSetWait();
			getDeviceListOnlyDontDisplay();
		}
		else
			showPlanningTree();
	} catch {}
}
function treeviewSitesPaneContent() {
	// searches first to see if sid is defined for this SmartServer, if not check for all SmartServers sid = null
	var sTemp = "", j, k, m, element, bContinue = true, sidItems = [], bNoSidDefined;
	//__sites__
	try {
		element = document.getElementById("planningPaneDetails") 
		if(element !== null) {

			for(k=0; k < 3; k++)
			{
				for(j=0; j < g_contextImages.length; j++)
				{

				
					bContinue = false;
					if(k=== 0) {
						// check if sid defined
						if(g_contextImages[j].sid !== null) {

							if(g_contextImages[j].sid.indexOf(",") !== -1) {
								sidItems = g_contextImages[j].sid.indexOf(",");
							}
							else {
								sidItems.push(g_contextImages[j].sid);
								
							}
							for(m=0; m < sidItems.length; m++)
							{
								if(g_iSmarserverSid === sidItems[m]) {
									bContinue = treeviewSitesPaneContentCheckContext(g_contextImages[j].contextType);
									if(bContinue)
										break;
								}
							}
						}
					}
					else if(k === 1) {
						// sid not defined
						bContinue = treeviewSitesPaneContentCheckContext(g_contextImages[j].contextType);
						
					}
					if(bContinue) {
						//check if context matches 
						sTemp = "";
						if(g_contextImages[j].bLocationAboveImage) {
							if(g_contextImages[j].location !== null) {
								sTemp += g_contextImages[j].location;
							}
						}
						if(g_contextImages[j].image !== null) {
							sTemp += "<div style=\"display:block;margin-left:50 px;margin-right:10px\"><img src=\"" +  g_contextImages[j].image + "\" alt=\"device image\"";
							if(g_contextImages[j].width !== null)
								sTemp += " width=\"" + g_contextImages[j].width + "px\"";
							if(g_contextImages[j].height !== null)
								sTemp += " height=\"" + g_contextImages[j].height + "px\"";
							sTemp += "></div>";
							
						}
						if(!g_contextImages[j].bLocationAboveImage) {
							if(g_contextImages[j].location !== null) {
								sTemp += g_contextImages[j].location;
							}
						}
						
						break;
					}
				}
				if(bContinue) {
					break;
				}
			}
			if(sTemp === "")
				sTemp += "No Contexts Selected</div>"
			element.innerHTML = sTemp;
			
		}
		
	}
	catch {}
}
function treeviewSitesPaneContentCheckContext(contexts) {
	var bResult = false;
	var i;
	var searchStr = "sites"
	var contextItems = [];
	try { 
		if(contextList.length === 0)
			searchStr = "site";
		if(contexts.indexOf(",") === -1) {
			contextItems.push(contexts);
		}
		else {
			contextItems = contexts.split(",");
		}
		for(i=0; i < contextItems.length; i++)
		{
			if(contextItems[i] === searchStr) {
				bResult = true;
				break;
			}
		}
	}
	catch {}
	return bResult;

}
function treeShowConfiguration() {
	var element = document.getElementById("planningConfigCheckbox");
	var element1 = document.getElementById("treeDpProperty");
	try {
		if(element !== null) {
			g_bPlanningShowConfiguration = element.checked;
			if(element1 !== null) {
				if(g_bPlanningShowConfiguration) {
					element1.style.display = "inline-block";
				}
				else {
					element1.style.display = "none";
				}
				
			}
		}
	}
	catch {}
}
function treeDivTreeMouseDownEvent(n) {
	//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
	if(g_iPlanningPaneSelectedContextType === 0) {
		g_iTreeDivTreeWidth = n.offsetWidth;
		g_iTreeDivTreeHeight = n.offsetHeight;
	}
}
function treeDivTreeMouseUpEvent(n){
	if(g_bMouseTreeRightResizeActive) {
		mouseUpTreeRightResizeHandler(); //treedDiv resize finished
		return;
	}
	if(g_bMouseTreeBottomResizeActive) {
		mouseUpTreeBottomResizeHandler(); //treedDiv resize finished
		return;
	}
	
	//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
	if(g_iPlanningPaneSelectedContextType === 0) {
		if((g_iTreeDivTreeHeight !== 0) && (g_iTreeDivTreeWidth !== 0)) {
			if((g_iTreeDivTreeWidth !== n.offsetWidth) || (g_iTreeDivTreeHeight !== n.offsetHeight)) {
				try {
					if(typeof g_iPlanningPaneSelectedContextId === "number") {
						g_iTreeDivTreeWidth = 0
						g_iTreeDivTreeHeight = 0;
						getPlanningTreeShowTreeDetails(1, g_iPlanningPaneSelectedContextId)
					}
				}
				catch {}
			}
		}
	}

}
function treeDivTreeResizeEvent() {
	
	if(g_iPlanningTreeDivResizeTimerId !== 0)
		clearTimeout(g_iPlanningTreeDivResizeTimerId);
	//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
	if(g_iPlanningPaneSelectedContextType === 0) {
		g_iPlanningTreeDivResizeTimerId = setTimeout(treeDivTreeResizeTimer, 500);
	}
	
}
function treeDivTreeResizeTimer() {
	//getPlanningTreeShowTreeDetails(); //7777
	try {
		g_iPlanningTreeDivResizeTimerId = 0;
		//if((g_iMainDisplayMode === DISPLAYMODE_PLANNING) && (g_iPlanningPaneSelectedContextType === 0)) {
		if(g_iPlanningPaneSelectedContextType === 0) {
			if(typeof g_iPlanningPaneSelectedContextId === "number") {
				g_iTreeDivTreeWidth = 0
				g_iTreeDivTreeHeight = 0;
				getPlanningTreeShowTreeDetails(61, g_iPlanningPaneSelectedContextId)
			}
		}
	}
	catch {}

}
function treeShowConfigurationAll() {
	var i;
	var element = document.getElementById("planningConfigCheckbox");
	var nodes = null;
	try {
		if(element !== null) {
			g_bPlanningShowConfiguration = element.checked;
			nodes = document.getElementsByClassName("tableHideCol");
			for(i=0; i < nodes.length; i++)
			{
				if(g_bPlanningShowConfiguration)
					nodes[i].style.display = "table-cell";
				else 
					nodes[i].style.display = "none";
			}
			
		}
	}
	catch {}
}
function treeviewShowDatapoints(n) {
	//fixxxx
}
function treeviewToggle(n) {
	try {
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
function treeviewToggle1(n, displayId, path) {
	try {
		var url;
		var element = document.getElementById(displayId);
		if(!n.classList.contains("treeviewCaret-down")) {
			// only do if currently node collapsed
			if(element !== null) {
				if(element.innerHTML === "") {
					// need to get child data
					if(path.indexOf("/") === -1) {
						// device
						cursorSetWait();
						path = encodeNameStr(path);
						url = "https://" + location.hostname + "/iap/devs/*+name==" + path + "/if/*/*/*/*";
						requestGetData(displayId, url, treeViewGetDeviceDatapointsResponse, treeViewGetFailResponse);
						
					}
				}
			}
		}
		n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
		//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
		if(n.parentElement !== null ) {
			if(n.parentElement.parentElement !== null) {  
				if(n.parentElement.parentElement.nextSibling !== null) {
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
				}
				else { // last Li 
					n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
				}
			}
		}
		n.classList.toggle("treeviewCaret-down");
	} catch {}
}
function treeViewGetDeviceDatapointsResponse(mode, requestUrlString, json){
	var element,obj, i, bContinue, content = "";
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) 
		return;
	if(mode === "")
		return;
	cursorClearWait()
	try {
		if(json.length === 0)
			return;
		var element = document.getElementById(mode);
		if(element !== null) {
			//sort datapoints
			for(i=0; i < json.length; i++) 
			{
				json[i].dpPath = json[i].blockName +  "/" + json[i].blockIndex +  "/" + json[i].datapointName;
				json[i].dpBlockPath = json[i].blockName +  "/" + json[i].blockIndex +  "/";
				json[i].path = json[i].deviceName + "/" + json[i].dpPath;
				json[i].pathname = json[i].deviceName + "/" + json[i].blockName +  "/" + json[i].blockIndex +  "/";
				if(typeof json[i].name === "undefined") {
					json[i].pathname += json[i].datapointName;
					json[i].dpBlockPath += json[i].datapointName;
				}
				else if(json[i].name === null) {
					json[i].pathname += json[i].datapointName;
					json[i].dpBlockPath += json[i].datapointName;
				}
				else { 
					json[i].pathname += json[i].name;
					json[i].dpBlockPath += json[i].name;
				}
			}
			bContinue = true;
			while(bContinue)
			{
				bContinue = false;
				for(i=0; i < (json.length - 1); i++) 
				{
					if(json[i].path > json[i + 1].path) {
						obj = JSON.parse(JSON.stringify(json[i]));
						json[i] = JSON.parse(JSON.stringify(json[i + 1]));
						json[i + 1] = obj;
						bContinue = true;
					}
				}
			}
			for(i=0; i < json.length; i++) 
			{
				if(false) { //i === (json.length - 1)) {
					//content += "<li class=\"treeli treeviewLiActiveLastChild\">" + json[i].dpPath + "</li>";
					content += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					content += "<span id=\"planningTreeContextDp_" + json[i].path + "\" onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].path + ")\">" + json[i].dpPath;
					content += "</span></p></li>";
				}
				else {
					//content += "<li class=\"treeli treeviewLiActive\">" + json[i].dpPath + "</li>";
					content += "<li class=\"treeli\"><p class=\"treeviewNoChildren\">";
					content += "<span id=\"planningTreeContext_DeviceDp_" + json[i].path + "\"";
					//content += " onclick=\"getPlanningTreeShowTreeDetails(0, " + json[i].path + ")\">";
					content += "\" onclick=\"getPlanningTreeShowTreeDatapoints(0, 'DeviceDp_" + json[i].path + "', '" + json[i].path + "')\">";
					content += json[i].dpBlockPath; //json[i].dpPath; //json[i].pathname;
					content += "</span></p></li>";
				}
			}
			element.innerHTML = content;
		} 
	}
	catch (err) {}
}
function treeViewGetFailResponse(mode, requestUrlString, json) {
	cursorClearWait()
}
function treeviewAddDeviceStatusDot(id, name, state, health, category) {
	var str = "lawngreen";
	try {
		if(state === "provisioned") {
			if(health === "normal")
				str = "lawngreen";
			else {
				if(category === "SC")
					str = "lawngreen";
				else 
					str = "red";
			}
		}
		else if(state === "unlicensed") 
			str = "#BA55D3"
		else if(state === "provisioning") 
			str = "cyan";
		else 
			str = "blue";
	}
	catch (err) {}
	if(category === "SC")
		str = '<span id=\"' + id + '\" class="treeviewDeviceSquare" style="background-color:' + str + '"';
	else
		str = '<span id=\"' + id + '\" class="treeviewDeviceDot" style="background-color:' + str + '"';

	//str += " onclick=\"getPlanningTreeShowTreeDatapoints(0, 'Device_" + id + "', '" + name + "')\"></span>";
	str += "></span>";

	return str;
}
function treeviewNodesCollapseNodesInInialCollapseList() {
	var i, n, bExpandAllDevices = true;
	try {
		// only collapse if context is available
		if(planningList.length > 0)
			bExpandAllDevices = false;
		else {
			for(i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].contexts.length > 0) {
					bExpandAllDevices = true;
					break;
				}
			}
		}

		
		for(i=0; i < g_treeviewInitialCollapseList.length; i++)
		{
			n = document.getElementById(g_treeviewInitialCollapseList[i]);
			if(!bExpandAllDevices || (bExpandAllDevices && (g_treeviewInitialCollapseList[i].indexOf("treeDeviceButton") !== -1))) {
				if(n !== null) {
					n.parentNode.parentElement.querySelector(".treeviewNested").classList.toggle("treeviewActive");
					//n.parentElement.parentElement.classList.toggle("treeviewLiActive");
					if(n.parentElement !== null ) {
						if(n.parentElement.parentElement !== null) {  
							if(n.parentElement.parentElement.nextSibling !== null) {
								n.parentElement.parentElement.classList.toggle("treeviewLiNotActive");
							}
							else { // last Li 
								n.parentElement.parentElement.classList.toggle("treeviewLiNotActiveLastChild");
							}
						}
					}
					//n.classList.toggle("treeviewCaret-down");
					if(g_treeviewInitialCollapseList[i].indexOf("treeDeviceButton") === -1)
						n.classList.remove("treeviewCaret-down");
				}
			}
		}
		
		if(bExpandAllDevices) {
			g_bPlanningShowDevice = false;
			document.getElementById("planningTreeShowDevicesButton").innerHTML = "Hide All Devices"
		}
	}
	catch(err) {}
}
function treeviewfindContextObj(id, objList) {
	result = null;
	var i;
	try {
		if(objList === null)
			return result;
		for(i=0; i < objList.length; i ++)
		{
			if(objList[i].id === id) {
				result = JSON.parse(JSON.stringify(objList[i]));
				return result;
			}
			else if(objList[i].children.length > 0) {
				result = treeviewfindContextObj(id, objList[i].children)
				if(result !== null)
					return result;
			}
		}
	}
	catch (err) {result = null;}
	return result;

}
function treeUpdateContextDeviceStatus(index, deviceId) {
	var i, j, z = -1, z1 = -1, contextId, contextObj, iTotal, iUp, iDown, iUnProvisioned, iUnLicensed;
	var status, element, sResult = "";
	try {
		//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		//	return;
		if((deviceListAll.length === 0) || (planningList.length === 0))
			return;
		if(index !== -1) {
			if(index < deviceListAll.length) {
				if(deviceListAll[index].id === deviceId)
					z = index;
			}
		}
		if(z === -1) {
			for(i=0; i < deviceListAll.length; i ++)
			{
				if(deviceListAll[i].id === deviceId) {
					z = i;
					break;
				}
			}
		}
		if(z !== -1) {
			for(i=0; i < deviceListAll[z].contexts.length; i ++)
			{
				contextId = deviceListAll[z].contexts[i];
				contextObj = treeviewfindContextObj(contextId, planningList);
				if(contextObj !== null) {
					element = document.getElementById("planningTreeContextDeviceStatus_" + contextObj.id);
					if(element !== null) {
						sResult = "";
						iTotal = contextObj.devices.length; iUp = 0; iDown = 0; iUnProvisioned = 0; iUnLicensed = 0;
						for(j=0; j < contextObj.devices.length; j ++)
						{
							for(k=0; k < deviceListAll.length; k++)
							{
								if(contextObj.devices[j].id === deviceListAll[k].id) {
									if(deviceListAll[k].status.state === "provisioned") {
										if(deviceListAll[k].status.health === "normal")
											iUp ++;
										else {
											if(deviceListAll[k].category === "SC")
												iUp ++;
											else 
												iDown ++;
										}
									}
									else if(deviceListAll[k].status.state === "unlicensed") 
										iUnLicensed ++;
									else 
										iUnProvisioned ++;
									break;
								}
							}
						}
						if((iDown > 0) && ((iDown + iUnProvisioned) === iTotal))
							sResult += '<span class="dot" style="background-color:red"></span>';
						else if(iDown > 0)
							sResult += '<span class="dot" style="background-color:yellow"></span>';
						if(iUnProvisioned > 0)
							sResult += '<span class="dot" style="background-color:blue"></span>';
						if(iUnLicensed > 0)
							sResult += '<span class="dot" style="background-color:#663399"></span>';
						element.innerHTML = sResult;
					}
					
					
				}
			}
		}

	}
	catch (err) {}

}
function treeviewShowContextDevicesInDetailsPane(contextId){
	
	var url = "";
	
	var treeContext = null;
	g_iMainDisplayMode = DISPLAYMODE_PLANNING;
	g_bPollingEnabled = false;
	ivbWsProcessDatapointUpdate = false;
	menuCloseAll();
	
	
	if(g_iPlanningPaneSelectedContextId !== -1) {
		treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
		if(treeContext !== null) {
			treeContext.classList.remove("treeSelected")
			//treeContext.style.color = "white";
		}
	}
	treeContext = document.getElementById("planningTreeContext_" + contextId);
	if(treeContext !== null) {
		//treeContext.style.color = "red";
		treeContext.classList.add("treeSelected")
	}

	g_iPlanningPaneSelectedContextId = contextId;

	document.getElementById("planningPaneDetails").innerHTML = "Devices<br><br>" + g_sTreeDevicesNoContent;

	return; //navtree
	if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING) {
		return;
	}
	
	try {
		
		planningDpList = [];
		g_iPlanningPaneSelectedContextType = 1;
		planningMenuCancel();
		testDeviceCancel();
		if(g_planningDpTimerId !== 0)
				clearTimeout(g_planningDpTimerId);
		g_sPlanningTreeDatapointPath =""; // only used for Devices and Datapoints nodes
		document.getElementById("planningContextDetailsDiv").style.visibility = "hidden";
		document.getElementById("planningRefreshButton").style.visibility = "hidden";
		
		// change color of tree context to indicate selected
		if(g_iPlanningPaneSelectedContextId !== -1) {
			treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
			if(treeContext !== null) {
				treeContext.style.backgroundColor = "white";
				//treeContext.style.color = "white";
			}
		}
		g_iPlanningPaneSelectedContextId = "Devices_" + contextId;
		treeContext = document.getElementById("planningTreeContext_" + g_iPlanningPaneSelectedContextId);
		if(treeContext !== null) {
			//treeContext.style.color = "red";
			treeContext.style.backgroundColor = "red";
		}
		
	}
	catch(err) {}

	if(contextId === -1) {
		document.getElementById("planningPaneDetails").innerHTML = "No Devices";
		return;
	}
	if((deviceListAll !== null) && (planningList !== null)) {
		//if((deviceListAll.length > 0) && (planningList.length > 0)) {
		if(deviceListAll.length > 0) {
			if(deviceTypeList.length === 0){
				url = "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc";
				requestGetData(contextId, url, treeviewShowContextDevicesInDetailsPaneDeviceTypeResponse, getPlanningTreeRequestFailure);
			}
			else 
				treeviewShowContextDevicesInDetailsPaneShow(contextId);
		}
	}
}
function treeviewShowContextDevicesInDetailsPaneDeviceTypeResponse(mode, url, json) {
	try {
		
		//if(g_iMainDisplayMode !== DISPLAYMODE_PLANNING)
		//	return;

		cursorClearWait();
		deviceTypeList = json;
		treeviewShowContextDevicesInDetailsPaneShow(mode);
	}
	catch(err) {}
}

function treeviewShowContextDevicesInDetailsPaneShow(contextId) {

	var paneContent = "";
	var i,j,k, path, sTemp, obj;;
	var contextPath = "";
	var tempStr;
	var iTotal = 0, iUp = 0, iProvisioned = 0, iUnProvisioned = 0, iDown = 0;
	var contextObj = null;
	var treeContext = null;
	if((deviceListAll !== null) && (planningList !== null)) {
		//if((deviceListAll.length > 0) && (planningList.length > 0)) {
		if(deviceListAll.length > 0) {
			try {
				if(contextId === "_NoContext") {
					// unassigned devices
					contextObj = {};
					contextObj.path = "Un-assigned Devices";
					contextObj.devices = [];
					for(i= 0; i < deviceListAll.length; i ++)
					{
						if(deviceListAll[i].contexts.length === 0) {
							contextObj.devices.push(JSON.parse(JSON.stringify(deviceListAll[i])));
						}
					}
					// sort
					bContinue = true;
					while(bContinue)
					{
						bContinue = false;
						for(i= 0; i < (contextObj.devices.length - 1); i ++)
						{
							if(contextObj.devices[i].name > contextObj.devices[i + 1].name) {
								bContinue = true;
								obj = {};
								obj = JSON.parse(JSON.stringify(contextObj.devices[i]));
								contextObj.devices[i] = JSON.parse(JSON.stringify(contextObj.devices[i + 1]));
								contextObj.devices[i + 1] = obj;
							}
						}
					}
				}
				else
					contextObj = treeviewfindContextObj(contextId, planningList);
				if(contextObj === null) {
					document.getElementById("planningPaneDetails").innerHTML = "No Devices";
					return;
				}
				contextPath = contextObj.path;
				paneContent += "<tr><th onclick=\"sortTable(0)\">#</th>";
				paneContent += "<th>Menu</th>"; 
				paneContent += "<th onclick=\"sortTable(1)\">Device Name</th><th onclick=\"sortTable(2)\">Device Status</th>";
				paneContent += "<th onclick=\"sortTable(3)\">Device Type</th><th onclick=\"sortTable(6)\">UID</th>";
				paneContent += "<th onclick=\"sortTable(4)\">Program ID</th>";
				paneContent += "<th onclick=\"sortTable(5)\">Last Update</th><th onclick=\"sortTable(6)\">Protocol</th>"
				//paneContent += "<th onclick=\"sortTable(9)\">Category</th><th onclick=\"sortTable(10)\">SID</th><th onclick=\"sortTable(11)\">Address</th><th>Menu</th></tr>"; 
				paneContent += "<th onclick=\"sortTable(7)\">Category</th>";
				
				
				paneContent += "</tr>"; 
				for(k=0; k < contextObj.devices.length; k++) 
				{
					for(i= 0; i < deviceListAll.length; i ++)
					{	
						if(deviceListAll[i].id === contextObj.devices[k].id) {
							iTotal ++;
							path = "";
							paneContent += "<tr><td>" + iTotal.toString() + "</td>";
							
							if(deviceListAll[i].category	== "SC") {
								paneContent += "<td>";
								paneContent += "<button id=\"deviceMenu_" + deviceListAll[i].name + "\" onclick=\"menuDeviceSmartServer(0, event," + deviceListAll[i].id + ", '" + deviceListAll[i].name  + "')\">...</button>";
								paneContent += "</td>";
								iUp ++;
							}
							else {
								paneContent += "<td><button id=\"deviceMenu_" + deviceListAll[i].name + "\" onclick=\"menuDevice(0, event," + deviceListAll[i].id + ", '" + deviceListAll[i].name  + "', '" + deviceListAll[i].deviceTypeName  + "', '" + deviceListAll[i].protocol  + "')\">...</button></td>";
								if(deviceListAll[i].status.state === "provisioned") {
									if(deviceListAll[i].status.health === "normal")
										iUp ++;
									else
										iDown ++;
								}
								else
									iUnProvisioned ++;
							}
							paneContent += "<td>" + deviceListAll[i].name + "</td>";
							if(deviceListAll[i].category === "SC") {
								paneContent += "<td></td><td></td>";
								paneContent += "<td>" + deviceListAll[i].SID + "</td>";
								paneContent += "<td></td><td></td><td></td>";
							}
							else {
								paneContent += "<td>" + deviceListAll[i].deviceStatus + "</td>";
								paneContent += "<td>" + deviceListAll[i].deviceTypeName  + "</td><td>" + deviceListAll[i].uid  + "</td>";
								z = 0;
								for(j=0; j < deviceTypeList.length; j++)
								{
									if(deviceListAll[i].typeId === deviceTypeList[j].id) {
										paneContent += "<td>" + deviceTypeList[j].programId + "</td>";
										z = 1;
										break;
									}
								}
								if(z === 0)
									paneContent += "<td></td>";
								
								paneContent += "<td>" + deviceListAll[i].mru  + "</td>";
								paneContent += "<td>" + deviceListAll[i].protocol + "</td>";
							}
							paneContent += "<td>" + deviceListAll[i].category + "</td>";
							
							
							paneContent += "</tr>";
							
						}
					}
				}
				sTemp = "Total Devices [" + iTotal + "]: UP = " + iUp + ", Down = " + iDown + ", Unprovisioned = " + iUnProvisioned;
				
				sTemp = "<br><br>" + sTemp +"<br>"
				paneContent = "Devices: " + contextPath + sTemp + "<br><table id=\"myTable\">" + paneContent + "</table>";
				
				document.getElementById("planningPaneDetails").innerHTML = paneContent;
				
			}
			catch {}
		}
		else
			document.getElementById("planningPaneDetails").innerHTML = "No Devices";
	}
	else
		document.getElementById("planningPaneDetails").innerHTML = "No Devices";
		
}