/********************************************************************************
 * 
 *  Datalog Chart 
 *      -Some functions in browser.js, and browsersvg.js
 * 
 *  This file mostly covers just populating the Data Log View Chart.  Most of the Data log code is in the browser.js file
 * 
 *   g_iDatalogPollMode: (browser.js)
 *      0: get data log, if polling enabled then continuously get new logs at the specifed rate
 *      1: get data log, if polling enabled then live data
 *      2: immediately get live data if polling is enabled.
 * 
 *   createDataLogClientWebSocketConnection(mode, request) - Defined in navtree.js is used to get data log data
 * 
 *  Device log - is used for device datalog
 *  Functions
 *      addLogChart()
 *      createDeviceLogChartObject() 
 * 
 */


var g_chartList = []; // currently used for datalog and dashboard
var g_zoomChartList = []; // zoom in chartList
var g_chartListLogs = []; // used for device datapoints with logging enabled 
var g_enumsList = [];
var g_chartLineList = [];
var g_oDeviceLogSnvtList = []; // used to get dp types (also called snvt types)
var g_datalogDisplayId = "";
var g_datalogSvgDoc = null;
var g_datalogChartInfo = {};
var g_enumsListNewValue = .8;
var g_bMouseDown = false;
var g_bDatalogChartZoomInProgress = false;
var g_bDeviceDataLogGetInProgress = false; // used for device logs and navtree log node
var g_sDeviceDataLogDeviceName = "";
var g_bDeviceLogRangeCheckbox = false;
var g_sDeviceLogRangeType = "last hour";
var g_mouseClickTimerVar = null;
var g_bCreateChartLegend = false;
var g_bDataLogChartUpdateLastEntryToCurrentTimestamp = false;
var g_iDatalogChartLineSelectedYaxis = 0; // 0=single, 1=Y1-only, 2=y2 only, 3= both controlled by radio button, only needed if both Y1 and Y2 are used
var g_iDatalogChartLineShowYaxis = 0; // 0= single Y axis --show all datapoint on Y1, 1 = only show datapoints on Y1, 2 = only show datapoints on Y2, show both Y1 and Y2.
var g_bDatalogChartAddZeroLineForNegNumbers = true;
var g_bChartZoomEnabled = true;
var g_zoomFontSize = "35px";
var g_bAddZoomChart = true;
var g_iTooltipTextMaxLen1 = 9;
var g_iTooltipTextMaxLen2 = 18;
var g_bMaxDataLogReachedShowPrompt = true;
var g_bImagesLoadedCount = 2; // number of svg images to load
var g_bImagesLoaded = [];
var g_bFirstTimeRunningZoomChart = true;

function _chartInit() {
    g_bDatapointMenuShowPreset = false;
    g_bMaxDataLogReachedShowPrompt = true;
    if(g_bChartZoomEnabled) {
        g_bAddZoomChart = true;
		// add zoom chart
		_addZoomChart();
	}
}

function chartZoomClose() {
    try {
		document.getElementById("chartZoomDiv").className = "menuDivHide";
	}
	catch {}
}

function _addZoomChart() {
	try {
		var image = new Image();
        var image1 = new Image();
        if(g_bAddZoomChart) {
            g_bAddZoomChart = false;
            if(!g_bImagesLoaded[0]) {
                image.src = "images/navtree/chart9.svg";
                if(image.complete) {
                    g_bImagesLoaded[0] = true;
                    _addZoomChartCheck()
                }
                else {
                    image.onload = () => {
                        g_bImagesLoaded[0] = true;
                        _addZoomChartCheck()
                        };
                    image.onerror = () => {
                        g_bZoomChartSupported = false;
                        return;
                    };
                }
            }
            if(!g_bImagesLoaded[1]) {
                image1.src = "images/navtree/chart10.svg";
                if(image1.complete) {
                    g_bImagesLoaded[1] = true;
                    _addZoomChartCheck()
                }
                else {
                    image1.onload = () => {
                        g_bImagesLoaded[1] = true;
                        _addZoomChartCheck()
                        };
                    image1.onerror = () => {
                        g_bZoomChartSupported = false;
                        return;
                    };
                }
            }
        }
	}
	catch {}
}
function _addZoomChartCheck() {
    try {
        var i, bContinue = true;
        for(i=0; i< g_bImagesLoaded.length; i++)
        {
            if(!g_bImagesLoaded[i]) {
                bContinue = false;
                break;
            }
        }
        if(bContinue)
            
            _addZoomChart1();
    }
    catch {}
}
function _addZoomChart1() {
	try {
		var elem, content = "";
		var image = new Image();
        var menuButton;
		var chartZoomDiv = document.getElementById("chartZoomDiv"); 
		if(chartZoomDiv !== null) {
			chartZoomDiv.innerHTML = "";
		}
		else {
			elem = document.createElement("div");
			elem.id = "chartZoomDiv";
			document.body.appendChild(elem)
			chartZoomDiv = document.getElementById("chartZoomDiv");
		}
        content += "<div id=\"chartZoomDivBorder\">";
		content += "<div>";
		content += "<div style=\"float:right\"><button onclick=\"_chartZoomDivClose()\">X</div>";
		content += "<div>Chart</div>";
		content += "</div>";

		
		//content += '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
        content += '<div style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
        //content += '<div style="display:block;margin-left:10px;margin-top:10px">';
		content += '<div  style="float:left;display:inline-block">';
		content += '<div style="margin-left: 50px">';
		content += '<span id="zoomDpName" style="margin-left: 200px"></span>';
		content += '<span id=\"zoomValue\" style=\"float:right;display:block;margin-right:30px\"></span>';
		content += '<br><span id=\"zoomDpField\"style="margin-left: 200px"></span>'
		content += '</div>';
		content += '<div style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
		//content += '<object id="zoomChartSvg" type="image/svg+xml" style="width: 930px;" data-izot-textcolor="white" data="images/navtree/chart9.svg"></object>';
        content += '<object id="zoomChartSvg" type="image/svg+xml" class=\"zoomChart\" data-izot-textcolor="white" data="images/navtree/chart9.svg"></object>';
		content += '</div>';

        // add zoomer chart
        content += '<hr>';
        content += "<div>Zoom Chart (select area to zoom in)</div>";
        content += '<div style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
        content += '<object id="zoomPanelChartSvg" type="image/svg+xml" class=\"zoomChart\" data-izot-textcolor="white" data="images/navtree/chart10.svg"></object>';
		//content += '<object id="zoomPanelChartSvg" type="image/svg+xml" style="height: 510px;" data-izot-textcolor="white" data="images/navtree/chart9.svg"></object>';
		content += '</div>';

		content += '</div>';
		content += '</div>';
        content += '</div>';
        content += '<div style=\"height:50px;\"></div>';
        chartZoomDiv.innerHTML = content;
		chartZoomDiv.className = "menuDivHide";
        g_bZoomChartSupported = true;
        /*
        menuButton = document.getElementById("planningPaneDetails");
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
			
			chartZoomDiv.style.left = x.toString() + "px";
			chartZoomDiv.style.top = y.toString() + "px";
            
        }
        */
        setTimeout(_addZoomChart2,2000);
	}
	catch {}
}
function _addZoomChart2() {
    // required for chrome otherwise first time going to zoom chart doesn't work 
    try {
        ivInitializeChart1(true, "zoomChartSvg", 0, 0, null, null, "black", g_zoomFontSize, "both");
    }
    catch {}
    try {
        ivInitializeChart1(true, "zoomPanelChartSvg", 0, 0, null, null, "black", g_zoomFontSize, "both");
    }
    catch {}
}

function _chartMenu(mode, n, dp, label, displayElementId) {
    // read only datapoints
    //mode: 0 = dashboard, 1=devicelog
    //  defaultField: If structure Dp use this default for field dropdown
	try {
		var iPtr, i;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var bPaused = false;
		var index = -1;
		var menuContent = "";
		var offsets;
		var xOffset = 40;
		var yOffset = 20;
		var width = 100;
		var elem;
		var iPtr, name = dp;
        var style, zI, zIndex, element;

		if(mode === 0) {
            for(i=0; i < g_dashboardChartList.length; i++)
            {
                if(g_dashboardChartList[i].displayId === displayElementId) {
                    index = i;
                    break;
                }
            }
        }
        else
            index = displayElementId;
		if(index === -1) {
			alert("No chart data yet")
			return;
		}
		iPtr = name.indexOf("(");
		if(iPtr !== -1)
			name = name.substr(0,iPtr);
		

		menuContent = "<div class=\"menuChartDivShowContent\"><div class=\"menuDivDpPathName\">"
        menuContent += "<button style=\"margin-left:30px;float:right\" onclick=\"menuDivClose()\">X</button><br>";
        if(label !== "")
            menuContent += label;
        else 
		    menuContent += name;
        
		menuContent += "</div>";
		
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">dpMenu_" + dp + "</span>";
		menuContent += "<br><br>";
        if(mode === 0) {
            menuContent += "<button id=\"pause_" + index + "\" class=\"menuDivButton\" onclick=\"_chartPauseSingle(" + index  + ")\">";
            if(g_dashboardChartList[index].paused)
                menuContent += "Continue";
            else
                menuContent += "Pause"
            menuContent + "</button><br>";
        }
		if(g_bZoomChartSupported)
			menuContent += "<button class=\"menuDivButton\" onclick=\"_chartZoom(" + mode + "," + index + ",'" + dp + "','" + label + "')\">Zoom</button><br>";
        if(g_bAllowSaveChartData)
            menuContent += "<button class=\"menuDivButton\" onclick=\"saveData1(0,0," + index + ",'" + dp + "','" + label + "')\">Save</button>";
        if(mode === 0)
		    menuContent += "<button class=\"menuDivButton\" onclick=\"_clearDashboardChart(1," + index + ")\">Clear Chart</button><br>";
		
		menuContent += "<br><br></div>";
		var menuButton = n; //document.getElementById("planningPaneDetails"); //n;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + width) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - width - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + xOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - yOffset; // takes into account viewport (scrolling)

			var menuDiv = document.getElementById("menuDiv");
            /*
			if(menuDiv === null) {
				// add chartMenuDiv
				elem = document.createElement("div");
				elem.id = "chartMenuDiv";
				document.body.appendChild(elem)
				menuDiv = document.getElementById("chartMenuDiv");
			} */
			menuDiv.innerHTML = menuContent;
			
			menuDiv.style.left = x.toString() + "px";
			menuDiv.style.top = y.toString() + "px";
            if(mode === 1) {
                menuDiv.className = "menuChartDiv1";  // doesn't currently guaranty that menu is shown in viewport
            }
            else 
			    menuDiv.className = "menuChartDiv";  // doesn't currently guaranty that menu is shown in viewport
            

            if(g_bChartZoomEnabled && g_bAddZoomChart) {
                //g_bAddZoomChart = false;
                // add zoom chart
                _addZoomChart();
            }
			
		}
	}
	catch {}
}
function _chartMenuInputDp(mode, n, dp, label, displayElementId, dpIndex, displayElementIndex) {
    // read/write datapoints, 
    //mode: 0 = dashboard, 1=devicelog
    //  defaultField: If structure Dp use this default for field dropdown
	try {
		var iPtr, i;
		var x = 0; // = event.clientX;
		var y = 0;// = event.clientY;
		var bPaused = false;
		var index = -1;
		var menuContent = "";
		var offsets;
		var xOffset = 40;
		var yOffset = 20;
		var width = 100;
		var elem;
		var iPtr, name = dp;
        var style, zI, zIndex, element;

		if(mode === 0) {
            if(g_bEditModeEnabled) {
                menuDpValue1(0, n, dpIndex , displayElementIndex , "dpValueMenu_" + displayElementId, dp);
                return;
            }
            for(i=0; i < g_dashboardChartList.length; i++)
            {
                if(g_dashboardChartList[i].displayId === displayElementId) {
                    index = i;
                    break;
                }
            }
        }
        else
            index = displayElementId;

        
		if(index === -1) {
			alert("No chart data yet")
			return;
		}
		iPtr = name.indexOf("(");
		if(iPtr !== -1)
			name = name.substr(0,iPtr);
		

		menuContent = "<div class=\"menuChartDivShowContent\"><div class=\"menuDivDpPathName\">"
        menuContent += "<button style=\"margin-left:30px;float:right\" onclick=\"menuDivClose()\">X</button><br>";
        if(label !== "")
            menuContent += label;
        else 
		    menuContent += name;
        
		menuContent += "</div>";
		
		menuContent += "<span id=\"menuDivType\" style=\"display:none\">dpMenu_" + dp + "</span>";
		menuContent += "<br><br>";
        if(mode === 0) {
            menuContent += "<button id=\"pause_" + index + "\" class=\"menuDivButton\" onclick=\"_chartPauseSingle(" + index  + ")\">";
            if(g_dashboardChartList[index].paused)
                menuContent += "Continue";
            else
                menuContent += "Pause"
            menuContent + "</button><br>";
        }
		if(g_bZoomChartSupported)
			menuContent += "<button class=\"menuDivButton\" onclick=\"_chartZoom(" + mode + "," + index + ",'" + dp + "','" + label + "')\">Zoom</button><br>";
        if(g_bAllowSaveChartData)
            menuContent += "<button class=\"menuDivButton\" onclick=\"saveData1(0,0," + index + ",'" + dp + "','" + label + "')\">Save</button>";
        if(mode === 0) {
		    menuContent += "<button class=\"menuDivButton\" onclick=\"_clearDashboardChart(1," + index + ")\">Clear Chart</button><br>";
            if(g_bEditModeEnabled) {
                menuContent += "<button id=\"dpValueMenu_" + displayElementId + "_1\" style=\"float:right;display:block;margin-right:30px\" onclick=\"menuDpValue1(0, this, " + dpIndex + "," + displayElementIndex + ", 'dpValueMenu_" + displayElementId + "', '" + dp + "')\">Information</button><br>";
            }
        }
		menuContent += "<br><br></div>";
		var menuButton = n; //document.getElementById("planningPaneDetails"); //n;
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			if((offsets.x + offsets.width + window.pageXOffset + width) > (window.pageXOffset + window.innerWidth)) 
				x = offsets.x + window.pageXOffset - width - 10; // takes into account viewport (scrolling)
			else
				x = offsets.x + offsets.width + window.pageXOffset + xOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset - yOffset; // takes into account viewport (scrolling)

			var menuDiv = document.getElementById("menuDiv");
            /*
			if(menuDiv === null) {
				// add chartMenuDiv
				elem = document.createElement("div");
				elem.id = "chartMenuDiv";
				document.body.appendChild(elem)
				menuDiv = document.getElementById("chartMenuDiv");
			} */
			menuDiv.innerHTML = menuContent;
			
			menuDiv.style.left = x.toString() + "px";
			menuDiv.style.top = y.toString() + "px";
            if(mode === 1) {
                menuDiv.className = "menuChartDiv1";  // doesn't currently guaranty that menu is shown in viewport
            }
            else 
			    menuDiv.className = "menuChartDiv";  // doesn't currently guaranty that menu is shown in viewport
            

            if(g_bChartZoomEnabled && g_bAddZoomChart) {
                //g_bAddZoomChart = false;
                // add zoom chart
                _addZoomChart();
            }
			
		}
	}
	catch {}
}
function _chartMenuDivClose() {
	try {
		var menuDiv = document.getElementById("chartMenuDiv");
		if(menuDiv !== null)
			menuDiv.className = "menuDivHide";
	}
	catch {}

}
function _chartPauseSingle(index) {
	var i, dpIndex, displayElementIndex,obj, value, locValue, presetValue = "";
	try {
		var element = document.getElementById("pause_" + index);
		if(index < g_dashboardChartList.length){
			if(g_dashboardChartList[index].paused) {
				g_dashboardChartList[index].paused = false;
                dpIndex = g_dashboardChartList[index].dpIndex;
                displayElementIndex =  g_dashboardChartList[index].displayElementIndex; 
				if(element !== null) {
					element.innerText = "Pause";
                    if(g_dashboardChartList[index].data.length > 0) {
                        value = g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].value;
    
                        if(g_bDashboardMinMaxDecimalPlaces !== -1) {
                            if(typeof value === "number")
                                value = dashboardNumToFixedLength(value, g_iDashboardDecimalPlaces);
                        }
                        
                        if(dashboardDpList[dpIndex].displayElements[displayElementIndex].field === "")
                            presetValue = dashboardDpList[dpIndex].presetValue;
                        document.getElementById("chartvalue_" + dashboardDpList[dpIndex].displayElements[displayElementIndex].displayId).innerHTML = value;
                        document.getElementById("chartpreset_" + dashboardDpList[dpIndex].displayElements[displayElementIndex].displayId).innerHTML = presetValue;
                        dashboardUpdateCharts(index, value, null);
                        if((dashboardType === "t") || (dashboardType === "l")) {
                            obj = dashboardDpList[dpIndex];
                            if(dashboardType === "l") {
                                if(g_dashboardChartList[index].maxValue > obj.max) {
                                    obj.max = g_dashboardChartList[index].maxValue;
                                    ivInitializeThermometer(0, obj.displayId, i, value, obj.min, obj.max, obj.unit);
                                    //ivInitializeThermometer(0, obj.displayId, i, obj.locValue, obj.min, obj.max, obj.unit)
                                }
                            }
                            ivSetThermometerValue(obj.displayId, value, obj.min, obj.max, obj.svgMin, obj.svgMax)
                            //ivSetThermometerValue(obj.displayId, obj.locValue, obj.min, obj.max, obj.svgMin, obj.svgMax)
                        }
                    }
				}
			}
			else {
				g_dashboardChartList[index].paused = true;
				if(element !== null) {
					element.innerText = "Continue";
				}
			}
		}
		
		
	}
	catch {}
    
}
function _chartZoom(mode, index, dp, label) {
    // mode: 0=dashboard chart, 1=device log chart
	try {
		var elem;
		var content = "",menuDiv, element, menuButton, x, y;

		if(!g_bZoomChartSupported)
			return;
		var menuDiv = document.getElementById("chartZoomDiv"); 
		_chartMenuDivClose();
        if(mode === 0) {
            if(index >= g_dashboardChartList.length)
                return;
        }
        else if(mode === 1) {
            if(index >= g_chartListLogs.length)
                return;
        }
        else 
            return;

		
        if(menuDiv === null) {
            return;
        }

        menuButton = document.getElementById("planningPaneDetails");
		
		if(menuButton !== null) {
			offsets = menuButton.getBoundingClientRect(); 
			x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
			y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
			
			menuDiv.style.left = x.toString() + "px";
			menuDiv.style.top = y.toString() + "px";
            
        }


        menuDiv.className = "chartZoomDiv";
        menuDiv = document.getElementById("zoomDpName"); 
        if(menuDiv !== null) {
            if(label !== "")
                menuDiv.innerHTML = label;
            else
                menuDiv.innerHTML = dp;
        }
        element = document.getElementById("zoomDpField");
        if(element !== null) {
            if((g_dashboardChartList[index].field === "") || (label !== ""))
                element.innerHTML = "";
            else 
                element.innerHTML = "Field: " + g_dashboardChartList[index].field;
        }

        menuOverlayDivShow(5, null);
        if(g_bFirstTimeRunningZoomChart && (navigator.userAgent.match(/Chrome/))) {
            setTimeout(function() {_InitializeZoomChartElement1(mode, index);}, 100);
        }
        else
            _InitializeZoomChartElement1(mode, index);
		g_bFirstTimeRunningZoomChart = false;

	}
	catch {}
}
function _chartZoomDivClose() {
	try {
		var menuDiv = document.getElementById("chartZoomDiv");
		if(menuDiv !== null) {
			menuDiv.className = "menuDivHide";
            menuDiv = document.getElementById("chartZoomOverlayDiv");
            if(menuDiv !== null)
                menuDiv.className = "menuOverlayDivHide";
        }
	}
	catch {}

}
function _clearDashboardChart(mode, index) {
    //mode: 0=clear all, 1=clear only one
    var i, value, timestampMs, obj, presetValue = null, fvalue, fvalue1;
    var d = new Date();
    var ms = d.getTime();
    // remove datalog data
    try {
        if(index >= g_dashboardChartList.length)
            return;
		value = "";
        if(mode === 1) {
            if(!confirm("Clear Chart Data - press OK to continue"))
                return;
        }


        if(g_dashboardChartList[index].data.length > 0) {
            value = g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].value;
            timestampMs = g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].timestamp;
            if(typeof g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].presetValue !== "undefined")
                presetValue = g_dashboardChartList[index].data[g_dashboardChartList[index].data.length - 1].presetValue;
            
        }
        
        g_dashboardChartList[index].data = [];
        g_dashboardChartList[index].maxValue = null;
        g_dashboardChartList[index].minValue = null;
        obj = {};
        obj.value = value;
        if(presetValue !== null)
            obj.presetValue = presetValue;
        obj.timestamp = ms;
        g_dashboardChartList[index].data.push(obj);
        g_dashboardChartList[index].dataCurrentEntries = 1;
        g_dashboardChartList[index].startTimestamp = ms;
        g_dashboardChartList[index].endTimestamp = ms;
        dashboardDetermineChartMinMaxValuesForChart(3, index, value, true);
        ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_dashboardChartList[index].displayId, g_dashboardChartList[index].minValue, 
            g_dashboardChartList[index].maxValue, null, null, g_chartTextColor, null, g_dashboardChartList[index].chartLabels);
        dashboardUpdateCharts(index, value, null);
    
        if(mode === 1)
            menuDivClose();
    }
    catch {}
    
}
function _dashboardUpdateCharts(chartIndex) {
	_dashboardUpdateCharts1(0, chartIndex)
}
function _dashboardUpdateCharts1(mode, chartIndex) {
    // mode:0=normal chart, 1= zoom, 2 = zoom panel
    
	var chartObj = {};
	var chartObjList = [];
	var temp = 1;
	var sExtraStr = "";  //used to specify duration
	var lineWidth = 5;
    var startTimestamp, endTimestamp, min, max, obj, data = [];
    try {
        if(mode === 0)
            chartObj = JSON.parse(JSON.stringify(g_dashboardChartList[chartIndex]));
        else if(mode === 1) {
            chartObj = JSON.parse(JSON.stringify(g_zoomDashboardChartList[0]));
            lineWidth = 3;
        }
        else if(mode === 2){
            
            chartObj = JSON.parse(JSON.stringify(g_zoomDashboardChartList[1]));
            chartObj.lineWidth = 2;
            
            chartObjList.push(JSON.parse(JSON.stringify(chartObj)));
            
            startTimestamp = g_zoomDashboardChartList[0].startTimestamp;
            endTimestamp = g_zoomDashboardChartList[0].endTimestamp;
            min = g_zoomDashboardChartList[1].minValue;
            max = g_zoomDashboardChartList[1].maxValue;
            obj = {};
            obj.timestamp = startTimestamp;
            obj.value = min;
            data.push(JSON.parse(JSON.stringify(obj)));
            obj.value = max;
            data.push(JSON.parse(JSON.stringify(obj))); 
            obj.timestamp = endTimestamp;
            data.push(JSON.parse(JSON.stringify(obj))); 
            obj.value = min;
            data.push(JSON.parse(JSON.stringify(obj)));
            obj.timestamp = startTimestamp;
            data.push(JSON.parse(JSON.stringify(obj)));
            chartObj.data = data;
            chartObj.bPolygon = true;
            chartObj.fill = "salmon";
            chartObj.opacity = .25;
            chartObj.lineWidth = 3;
            chartObj.color = "red";
            chartObj.lineName = "line2";
            chartObj.lineColor = "red";
            chartObj.pathname = "zoomwindow";
            chartObj.dataCurrentEntries = data.length;
            chartObj.endPtr = data.length - 1;
            if(g_zoomDashboardChartList[0].creatChartLine)
                g_zoomDashboardChartList[0].creatChartLine = false;
            if(g_zoomDashboardChartList[1].creatChartLine)
                g_zoomDashboardChartList[1].creatChartLine = false;
        }
        chartObjList.push(JSON.parse(JSON.stringify(chartObj)));
        
        if(mode === 2)
            ivUpdateChartsDatalogChart3TwoYaxis1(chartObj.displayId, sExtraStr, g_idashboardChartType, 0, chartObjList,  null,chartObj.minValue, chartObj.maxValue, null, null, 
            chartObj.startTimestamp, chartObj.endTimestamp,null, false, "both", ivChartXLengthLargeChart10, ivChartYLengthLargeChart10);
        else
            ivUpdateChartsDatalogChart3TwoYaxis(chartObj.displayId, sExtraStr, g_idashboardChartType, 0, chartObjList,  null,chartObj.minValue, chartObj.maxValue, null, null, 
                chartObj.startTimestamp, chartObj.endTimestamp,lineWidth, true, "both");
    }
    catch {}

}
function _getDeviceDatalogChartResponse(mode, request, datalog) {
    try {
        var element = document.getElementById("scheduleDiv");
        var paneContent = "";
        var d, d2, i,j, k, x, y, z, temp, obj, tempObj, sTemp, label, shortPathname, pathname, items, deviceName, iCount = 0, sTemp, snvtTypeName;
        g_bDeviceDataLogGetInProgress = false;
        if((mode === 0) || (mode === 1)) {

            if(element !== null) {
                if(mode === 0) {
                    d2 = new Date();
                    d = new Date(d2.getTime() - (60 * 60 * 1000));


                    g_bDeviceLogRangeCheckbox = false;
                    g_sDeviceLogRangeType = "last hour";
                    paneContent += "Device Data Logs: " + g_sDeviceDataLogDeviceName;
                    paneContent += "<div style=\"float:right\">"
                    paneContent += "<input id=\"devicelograngecheckbox\" type=\"checkbox\" style=\"margin-left:20px\" value=\"" + g_bDeviceLogRangeCheckbox + "\" onchange=\"devicelograngechanged()\"> Dates "
                    
                    paneContent += "<div id=\"zoomchartstartend\" style=\"display:";
                    if(g_bDeviceLogRangeCheckbox)
                        paneContent += "inline-block";
                    else 
                        paneContent += "none";
                    sTemp = d.getFullYear() + "-" + (d.getMonth() + 1).toString().padStart(2,'0') +"-" + d.getDate().toString().padStart(2,'0');
                    paneContent += "\"> Start: <input id=\"zoomstartdate\" type=\"date\" value=\"" + sTemp + "\">";
                    sTemp = d.getHours().toString().padStart(2,'0') + ":" + d.getMinutes().toString().padStart(2,'0');
                    paneContent += " <input id=\"zoomstarttime\" type=\"time\" value=\"" + sTemp + "\" style=\"margin-right:10px\">";
                    sTemp = d2.getFullYear() + "-" + (d2.getMonth() + 1).toString().padStart(2,'0') +"-" + d2.getDate().toString().padStart(2,'0');
                    paneContent += "End: <input id=\"zoomenddate\" type=\"date\" value=\"" + sTemp + "\">";
                    sTemp = d2.getHours().toString().padStart(2,'0') + ":" + d2.getMinutes().toString().padStart(2,'0');
                    paneContent += " <input id=\"zoomendtime\" type=\"time\" value=\"" + sTemp + "\"></div>";
                    
                    paneContent += "<div id=\"zoomchartlast\" style=\"display:";
                    if(g_bDeviceLogRangeCheckbox)
                        paneContent += "none";
                    else 
                        paneContent += "inline-block";
                    paneContent += "\"><select id=\"deviceloglogrange\">";
                    paneContent += "<option value=\"last 10 min\">last 10 min</option>"
                    paneContent += "<option value=\"last hour\" selected>Last hour</option>"
                    paneContent += "<option value=\"last 4 hours\">last 4 hours</option>"
                    paneContent += "<option value=\"today\">today</option>"
                    paneContent += "<option value=\"yesterday\">yesterday</option>"
                    paneContent += "</select></div>";
                

                    paneContent += " <button onclick=\"devicelogGetLogs('" + g_sDeviceDataLogDeviceName + "')\">Get</button> "  + "<button onclick=\"menuScheduleDivClose()\" style=\"margin-left:20px\">X</button></div><br><br><div id=\"deviceLogChartsDiv\">processing data ...</div>";
                    element.innerHTML = paneContent;
                }
                g_sDeviceDataLogDeviceName = "";
                    
                g_chartListLogs = [];
                if(datalog.length === 0) {
                    element = document.getElementById("deviceLogChartsDiv");
                    if(element !== null)
                        element.innerHTML = "<br>No logs available";
                    return;
                }
                for(i=0; i < datalog.length; i++)
                {
                    z = -1;
                    for(j=0; j < g_chartListLogs.length; j++)
                    {
                        if(datalog[i].dpQualifier === g_chartListLogs[j].dpQualifier) {
                            z = j;
                            break;
                        }
                    }
                    if(z === -1) {
                        obj = {};
                        obj.dpQualifier = datalog[i].dpQualifier;
                        obj.datalogData = [];
                        obj.snvtType = null;
                        obj.snvtTypeName = "";
                        g_chartListLogs.push(obj);
                        z = g_chartListLogs.length - 1;
                    }
                    data = {};
                    data.value = datalog[i].localizedValue; //g_dashboardDatalogData[i].value;
                    data.utc = datalog[i].utc;
                    data.local = datalog[i].local;

                    if(typeof datalog[i].presetValue !== "undefined") {
                        if(datalog[i].presetValue !== "")
                            data.presetValue = datalog[i].presetValue;
                    }
                    temp = datalog[i].utc;
                    data.timestamp = Date.parse(temp.substr(0,(temp.length - 5)));
                    //data.timestamp = d1.getTime();
                    g_chartListLogs[z].datalogData.unshift(data);
                    
                }
                bContinue = true;
                while(bContinue)
                {
                    bContinue = false;
                    for(i=0; i < g_chartListLogs.length - 1; i++)
                    {
                        if(g_chartListLogs[i].dpQualifier > g_chartListLogs[i + 1].dpQualifier) {
                            tempObj = JSON.parse(JSON.stringify(g_chartListLogs[i + 1]));
                            g_chartListLogs[i + 1] = JSON.parse(JSON.stringify(g_chartListLogs[i]));
                            g_chartListLogs[i] = tempObj;
                            bContinue = true;
                        }
                    }
                }
                // verify if data any out of order
                for(i=0; i < g_chartListLogs.length; i++)
                {
                    bContinue = true;
                    while(bContinue)
                    {
                        bContinue = false;
                        for(j=0; j < g_chartListLogs[i].datalogData.length - 1; j++)
                        {
                            if(g_chartListLogs[i].datalogData[j].timestamp > g_chartListLogs[i].datalogData[j + 1].timestamp) {
                                iCount++;
                                tempObj = JSON.parse(JSON.stringify(g_chartListLogs[i].datalogData[j + 1]));
                                g_chartListLogs[i].datalogData[j + 1] = JSON.parse(JSON.stringify(g_chartListLogs[i].datalogData[j]));
                                g_chartListLogs[i].datalogData[j] = tempObj;
                                bContinue = true;
                            }
                        }
                    }
                }
                // determine if already have snvt type
                g_oDeviceLogSnvtList = [];
                for(i=0; i < g_chartListLogs.length; i++)
                {
                    z = -1;
                    // find datapoint
                    for(j=0; j < g_oDeviceDpList.dps.length; j++)
                    {
                        if(g_chartListLogs[i].dpQualifier === g_oDeviceDpList.dps[j].dpQualifier) {
                            z = -1;
                            g_chartListLogs[i].snvtTypeName = g_oDeviceDpList.dps[j].type;
                            for(k=0; k < g_snvtTypes.length; k++)
                            {
                                if(g_snvtTypes[k].typeId === g_chartListLogs[i].snvtTypeName) {
                                    z = k;
                                   break;
                                }
                                
                            }
                            if(z === -1)
                                g_oDeviceLogSnvtList.push(g_chartListLogs[i].snvtTypeName); // don't have snvt type so get it
                            break;
                        }
                    }

                    
                }
                if(g_oDeviceLogSnvtList.length > 0) {
                    snvtTypeName = g_oDeviceLogSnvtList.pop();
                    obj = {};
                    obj.mode = 0;
                    showDashboardUiGetSnvtType(2, obj, snvtTypeName); // get missing snvt types
                }
                else 
                    _getDeviceDatalogChartResponseProcesslogs(mode);
            }
        }
    }
    catch {}
}
function _getDeviceDatalogChartResponseGetSnvtTypes(mode) {
    try {
        var element = document.getElementById("deviceLogChartsDiv");
        if(element !== null) {
            if(g_oDeviceLogSnvtList.length > 0) {
                snvtTypeName = g_oDeviceLogSnvtList.pop();
                obj = {};
                obj.mode = 0;
                showDashboardUiGetSnvtType(2, obj, snvtTypeName);
            }
            else
                _getDeviceDatalogChartResponseProcesslogs(mode.mode);
        }
    }
    catch {}
}
function _getDeviceDatalogChartResponseProcesslogs(mode) {
    // mode: 0=initial, 1=don't change menu bar
    var element = document.getElementById("deviceLogChartsDiv");
    var paneContent = "";
    var d, d2, i,j, x, y, n, p, z, temp, obj, tempObj, sTemp, label, shortPathname, pathname, items, deviceName, iCount = 0, sTemp;
    var field = "",  fieldList = [], bGetSnvtList = false;
    var url;
    var defaultField = "";
    var value, value1, defaultValue;
    g_bDeviceDataLogGetInProgress = false;
    if((mode === 0) || (mode === 1)) {

        if(element !== null) {
            paneContent = "";
            for(i=0; i < g_chartListLogs.length; i++)
            {
                // get label from dashboard dp list
                sTemp = g_chartListLogs[i].dpQualifier
                items = sTemp.split("/");
                if(items.length === 6) {
                    iPtr = sTemp.lastIndexOf("/");
                    sTemp = 
                    g_chartListLogs[i].displayId = "devicelog_" + sTemp;
                    label = "";
                    
                    deviceName = "";
                    for(j=0; j < deviceListAll.length; j++)
                    {
                        if((items[1] === deviceListAll[j].protocol) && ((items[2] === deviceListAll[j].DID))) {
                            deviceName = deviceListAll[j].name;
                            break
                        }
                    }
                    sTemp = items[3] + "/" + items[4] + "/" + items[5];
                    g_chartListLogs[i].dpBlockPath = sTemp;
                    shortPathname = deviceName + "/" + sTemp;
                    pathname = deviceName + "/" + sTemp;
                    g_chartListLogs[i].pathname = pathname;
                    
                    for(k=0; k < g_snvtTypes.length; k++)
                    {
                        if(g_snvtTypes[k].typeId === g_chartListLogs[i].snvtTypeName) {
                            g_chartListLogs[i].snvtType = JSON.parse(JSON.stringify(g_snvtTypes[k]));
                            break;
                        }
                        
                    }

                    field = "";
                    fieldList = [];
                    defaultField = "";
                    z = g_chartListLogs[i].datalogData.length - 1;
                    presetValue = "";
                    value = g_chartListLogs[i].datalogData[z].value;
                    if(typeof g_chartListLogs[i].datalogData[z].presetValue !== "undefined")
                        presetValue = g_chartListLogs[i].datalogData[z].presetValue;
                    if(typeof g_chartListLogs[i].datalogData[z].value === "object"){
                            fieldList = createFieldListFromSnvtType(g_chartListLogs[i].snvtType);
                            //fieldList = Object.keys(g_chartListLogs[i].datalogData[z].value);
                            defaultField = fieldList[0];
                            // check if this datapoint already used and field !== ""
                            for(n=0; n < dashboardDpList.length; n++)
                            {
                                if(dashboardDpList[n].bStructure) {
                                    if(dashboardDpList[n].pathname === pathname) {
                                        for(p=0; p < dashboardDpList[n].displayElements.length; p++)
                                        {
                                            if(dashboardDpList[n].displayElements[p].field !== "") {
                                                defaultField = dashboardDpList[n].displayElements[p].field;
                                                n = dashboardDpList.length + 1;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            value1 = readFieldValue(g_chartListLogs[i].datalogData[z].value, defaultField);
                            if(value1.valid)
                                value =  value1.data;
                            else 
                                value = "";
                            // to support enums need to change fieldlist to obj = {} obj.name and obj.bEnums, if enum add enum  values
                    }
                    
                    g_chartListLogs[i].field = defaultField;
                    paneContent += addLogChart(g_chartListLogs[i].displayId, i, 0, label, shortPathname, pathname, field, fieldList, defaultField, value, presetValue, false, false, 0);
                    createDeviceLogChartObject(i, g_chartListLogs[i].displayId, pathname, defaultField, null, null, null, true, null, "both");
                }

                
            }
            element = document.getElementById("deviceLogChartsDiv");
            if(element !== null) {
                //element.innerHTML = "Number of Datapoints = " + g_chartListLogs.length + ", total logs = " + datalog.length + "<br><br>" + paneContent;
                element.innerHTML = paneContent;
                if(paneContent !== "") {
                    try {
                        
                        // add selected dropdown
                        for(i=0; i< g_chartListLogs.length; i++)
                        {
                            if(g_chartListLogs[i].field !== ""){
                                element = document.getElementById("datapointfieldselect_" + g_chartListLogs[i].displayId);
                                if(element !== null) {
                                    element.value = g_chartListLogs[i].field;
                                }
                            }
                        }
                        if(bGetSnvtList) {
                            if(g_snvtTypes.length === 0) {
                                //get enums
                                var url = "https://" + location.hostname + "/iap/dp/types?datapointsPresence=true";
		                        requestGetData(0, url, _getDeviceDatalogChartResponse1, _getDeviceDatalogChartResponse1Fail);
                                return;
                            }
                            //if(snvtli)
                        }
                        window.setTimeout("timerHandlerDeviceChart()", 1000);
                    } catch (err) {} 
                }
            }
        }
        
    }
}
function _getDeviceDatalogChartResponse1(mode, request, json) {
    try {
        g_snvtTypes = JSON.parse(JSON.stringify(json));
        window.setTimeout("timerHandlerDeviceChart()", 100);
    }
    catch {}
}
function _getDeviceDatalogChartResponse1Fail(mode, request, json) {
    window.setTimeout("timerHandlerDeviceChart()", 100);
}
function _InitializeZoomChartElement(i) {
    _InitializeZoomChartElement1(0, i)
}
function _InitializeZoomChartElement1(mode, i) {
	//i= dashboardDpList index 
    // g_zoomDashboardChartList: [0] = main zoom chart with tool tips, 
	var lastIndex, element, index;
	try {
        g_zoomDashboardChartList = [];
        if(mode === 0) {
            if(i >=  g_dashboardChartList.length) 
                return;
            g_zoomDashboardChartList.push(JSON.parse(JSON.stringify(g_dashboardChartList[i])));
            g_zoomDashboardChartList.push(JSON.parse(JSON.stringify(g_dashboardChartList[i])));
        }
        else if(mode === 1) {
            if(i >=  g_chartListLogs.length) 
                return;
            g_zoomDashboardChartList.push(JSON.parse(JSON.stringify(g_chartListLogs[i].chartObj)));
            g_zoomDashboardChartList.push(JSON.parse(JSON.stringify(g_chartListLogs[i].chartObj)));
        }
        g_zoomDashboardChartList[0].displayId = "zoomChartSvg";
        g_zoomDashboardChartList[0].creatChartLine = true;
        
        ivInitializeChart1(true, g_zoomDashboardChartList[0].displayId, g_zoomDashboardChartList[0].minValue, g_zoomDashboardChartList[0].maxValue, null, null, "black", g_zoomFontSize, g_zoomDashboardChartList[0].chartLabels);
        _InitializeZoomChartToolTipFontSize(g_zoomDashboardChartList[0].displayId);
            // add id to chart object parent
        element = document.getElementById(g_zoomDashboardChartList[0].displayId);
        if(element !== null) {
            element.parentNode.id = "chartParentDiv_" + g_zoomDashboardChartList[0].displayId;
            dashboardMouseEventsAddToChart(g_zoomDashboardChartList[0].displayId, "chartParentDiv_" + g_zoomDashboardChartList[0].displayId, "z0");
        }
        element = document.getElementById("zoomValue");
        if(element !== null) {
            lastIndex = g_zoomDashboardChartList[0].data.length - 1;
            if(g_zoomDashboardChartList[0].bEnum || g_zoomDashboardChartList[0].bString)
                element.innerHTML = g_zoomDashboardChartList[0].data[lastIndex].str;
            else 
                element.innerHTML = g_zoomDashboardChartList[0].data[lastIndex].value;
        }
        _dashboardUpdateCharts1(1, null);

            // zoomer chart
        index = 1;
        g_zoomDashboardChartList[index].displayId = "zoomPanelChartSvg";
        g_zoomDashboardChartList[index].creatChartLine = true;
        
        ivInitializeChart1(true, g_zoomDashboardChartList[index].displayId, g_zoomDashboardChartList[index].minValue, g_zoomDashboardChartList[index].maxValue, null, null, "black", g_zoomFontSize, g_zoomDashboardChartList[index].chartLabels);
        
            // add id to chart object parent
        element = document.getElementById(g_zoomDashboardChartList[index].displayId);
        if(element !== null) {
            element.parentNode.id = "chartParentDiv_" + g_zoomDashboardChartList[index].displayId;
            datalogChartAddEventListener(g_zoomDashboardChartList[index].displayId);
            //dashboardMouseEventsAddToChart(g_zoomDashboardChartList[index].displayId, "chartParentDiv_" + g_zoomDashboardChartList[index].displayId, "z0");
        }
        _dashboardUpdateCharts1(2, null);
        g_zoomDashboardChartList[index].initialMinValue = g_zoomDashboardChartList[index].minValue;
        g_zoomDashboardChartList[index].initialMaxValue = g_zoomDashboardChartList[index].maxValue;
	}
	catch {}
}
function _InitializeZoomChartToolTipFontSize(nameId) {
	try {
		var svgObj = null, svgDoc = null;
		var fontsize = "35px";
		//var linesize = 
		if(fontsize === null)
			return;
		if(navigator.userAgent.match(/Chrome/))	
		{		
			svgObj = document.getElementById(nameId);
			svgDoc = svgObj.contentDocument;
		}
		else
			svgDoc = document.getElementById(nameId).getSVGDocument();
		if(typeof svgDoc === "undefined")
			return;

			svgDoc.getElementById("tspanY3").setAttribute('y', 105); //y=120
		svgDoc.getElementById("tspanY2").setAttribute('y', 500); //y=530

		svgDoc.getElementById("tspanX1").setAttribute('x', 450);
		svgDoc.getElementById("tspanX1").setAttribute('y', 980);
		svgDoc.getElementById("tspanX1b").setAttribute('x', 450);
		svgDoc.getElementById("tspanX1b").setAttribute('y', 1030);

		
		svgDoc.getElementById("tspanX2").setAttribute('y', 980);
		svgDoc.getElementById("tspanX2b").setAttribute('y', 1030);


		svgDoc.getElementById("tspanX3").setAttribute('x', 2000);
		svgDoc.getElementById("tspanX3").setAttribute('y', 980);
		svgDoc.getElementById("tspanX3b").setAttribute('x', 2000);
		svgDoc.getElementById("tspanX3b").setAttribute('y', 1030);

		
		svgDoc.getElementById("tooltiptext").style.fontSize = fontsize;  // change text font size
		svgDoc.getElementById("tooltiptext").setAttribute('width', 300); 
		svgDoc.getElementById("tooltiptextrect").setAttribute('width', 250);
		svgDoc.getElementById("tooltiptextrect").setAttribute('height', 125);
		svgDoc.getElementById("tooltiptextrect").setAttribute('rx', 25);
		svgDoc.getElementById("tooltiptextrect").setAttribute('ry', 25);
		svgDoc.getElementById("tooltiptext1").setAttribute('y', 100);
		svgDoc.getElementById("tooltiptext2").setAttribute('y', 200);
		svgDoc.getElementById("tooltiptext2").setAttribute('dy', 50);
		
		
	}
	catch {}
}

/************************************************************************************************* 
 * OLD
*/
function showDataLog() {
	showDataLog2("", "", null);
}
function showDataLog0(mode) {
	if(mode === 0)
		g_sDataLogDpPath = "Datapoints List";
	else if(mode === 1)
		g_sDataLogDpPath = "Favorite DPs List";	
	showDataLog1("", "", null);
}
function showDataLogForDevice(dpPath, dpProgrammaticPath, dpPathList) {
	
	showDataLog1(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog1(dpPath, dpProgrammaticPath, dpPathList) {
	datalogLiveDataDpList = [];
	dataLogList = [];
	datalogPaneContent = "";
	if(g_iDatalogPollMode !== 2) {
		g_bDatalogStartGetRequest = true;
	}
	showDataLog2(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog3(dpPath, dpProgrammaticPath, dpPathList) {
	datalogLiveDataDpList = [];
	dataLogList = [];
	datalogPaneContent = "";
	if(g_iDatalogPollMode === 2) {
		g_iDatalogPollMode = 1;
	}
	g_bDatalogStartGetRequest = true;
	showDataLog2(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog4(dpPath, dpProgrammaticPath, dpPathList) {
	datalogLiveDataDpList = [];
	dataLogList = [];
	datalogPaneContent = "";
	if(g_iDatalogPollMode === 2) {
		g_iDatalogPollMode = 1;
	}
	g_bDatalogStartGetRequest = true;
	if(dpPath !== "")
		g_sDataLogDpPath = dpPath;
	else if(dpProgrammaticPath !== "")
	g_sDataLogDpPath = "xifname:" + programmaticPathname;
	showDataLog2(dpPath, dpProgrammaticPath, dpPathList);
}
function showDataLog2(dpPath, dpProgrammaticPath, dpPathList) {
	// dpPathList is used for favorites
	var paneTitle = "<label id=\"displayLabel\">Data Log</label>";
	var paneContent = "";
	var temp, temp1;
	var i, j, z, url, url1;
	var url;
	var obj;
	var d = new Date();
	//var dateItems = d.toLocaleDateString().split("/");
	var currentDate = ""; //dateItems[2] + "-" + dateItems[0] + "-" +dateItems[1];
	var currentTimestamp = ""; //currentDate + " " + d.toTimeString().substr(0,8);
	var currentTimeUtc = d.toISOString();
	var startOfDay; // = new Date(currentDate);
	var startOfDayStr = ""; // = startOfDay.toISOString();
	savePrevousHtmlContent();
	initializeDisplay();
	g_iMainDisplayMode = DISPLAYMODE_DATALOG;
	g_bDataLogChartUpdateLastEntryToCurrentTimestamp = false;
	g_bCreateChartLines = false;
	g_iDatalogChartMode = 0;
	g_PollingType = 0;
	g_bdatalogLiveDataConfigured = false;
	g_sWebSocketSubscribePayload_oldvalue = "";
	ivChartXLengthLargeChart = ivChartXLengthLargeChart3; // chart8
	ivChartYLengthLargeChart = ivChartYLengthLargeChart3;
	g_bDatalogUrlChanged = false; // used for datalog live polling, When checking the polled checked box, and this variable set then need to restart
	try {
		//currentDate = dateItems[2] + "-" + dateItems[0] + "-" +dateItems[1];
		currentDate = d.getFullYear().toString() + "-" + (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
		startOfDay = new Date(currentDate);
		startOfDayStr = startOfDay.toISOString();
		currentTimestamp = currentDate + " " + d.toTimeString().substr(0,8);
	}
	catch {}
	if(g_bEnableDataLogLiveData) {
		if(g_iDatalogPollMode === 2)
			g_bPollingEnabled = false;
		paneTitle += "<span style=\"margin-right:10px\">:</span><input type=\"radio\" id=\"datalogPollButtonlog\" name=\"datalogPollRadioButton\" onclick=\"datalogChangePollMode(this.value)\" value=\"0\"";
		if(g_iDatalogPollMode === 0)
			paneTitle += " checked";
		paneTitle += "> log only";
		paneTitle += "<input type=\"radio\" id=\"datalogPollRadioButtonlogLive\" name=\"datalogPollRadioButton\" onclick=\"datalogChangePollMode(this.value)\" value=\"1\"";
		if(g_iDatalogPollMode === 1)
			paneTitle += " checked";
		paneTitle += "> log + live ";
		paneTitle += "<input type=\"radio\" id=\"datalogPollRadioButtonlive\" name=\"datalogPollRadioButton\" onclick=\"datalogChangePollMode(this.value)\" value=\"2\"";
		if(g_iDatalogPollMode === 2)
			paneTitle += " checked";
		paneTitle += "> live only";
		paneTitle += "<input id=\"datalogPoll\" type=\"checkbox\" style=\"margin-left:30px\" onchange=\"datalogEnablePolling(0)\"";
		if(g_bDatalogPollingEnabled) {
			paneTitle += " checked";
			if(g_iDatalogPollMode === 2)
				g_PollingType = DISPLAYMODE_DATALOGLIVEPOLL;
		}
		paneTitle += ">Poll";
		paneTitle += " <input id=\"datalogRate\" onblur=\"datalogEnablePolling(0)\" value=\"" + g_iDataLogPollrate + "\"> sec";
		paneTitle += "<br><br><span style=\"width:100px\"></span>";
		paneTitle += "<button onclick=\"subscribeRequest()\" style=\"visibility:";
		if(g_iDatalogPollMode > 0)
			paneTitle += "visible";
		else
			paneTitle += "hidden";
		paneTitle += "\">Re-Subscribe</button>";

	}
	if(dpPathList !== null) {
		paneTitle += "<span style=\"display:inline-block;margin-left:20px\">Datapoints:</span>"; 
		//paneTitle += "<span style=\"display:inline-block;width:150px;margin-left:20px\">Datapoints:</span>"; 
		if(g_datalogUrlDpXifList.length === 0)
			g_datalogUrlDpXifList = dpPathList;
		else {
			for(i=0; i < dpPathList.length; i++) 
			{
				z = -1;
				for(j=0; j < g_datalogUrlDpXifList.length; j++) 
				{
					if( g_datalogUrlDpXifList[j].dpPath === dpPath) {
						z = j;
						break;
					}
				}
				if(z === -1) {
					obj = {};
					obj.dpPath = dpPathList[i].dpPath;
					obj.dpProgrammaticPath = dpPathList[i].dpProgrammaticPath;
					g_datalogUrlDpXifList.push(obj);
				}
			}
		}
	}
	else if(dpPath === "")
		paneTitle += "<span style=\"display:inline-block;margin-left:20px\">Datapoint:</span>"; 
		//paneTitle += "<span style=\"display:inline-block;width:150px;margin-left:20px\">Datapoint:</span>"; 
	else {
		paneTitle += "<span style=\"display:inline-block;margin-left:20px\">Datapoint:</span>";
		g_sDataLogDpPath = dpPath;
		dataLogList = [];
		if(dpPath.indexOf("/") !== 0) {
			if(dpPathList !== null)
				g_datalogUrlDpXifList = dpPathList;
			else {
				if(dpProgrammaticPath !== "") {
					if(dpProgrammaticPath.indexOf("/") !== 0) {
						if((dpPath.indexOf(",") === -1) && (dpProgrammaticPath.indexOf(",") === -1))
						z = -1;
						for(i=0; i < g_datalogUrlDpXifList.length; i++) 
						{
							if( g_datalogUrlDpXifList === dpPath) {
								z = i;
								break;
							}
						}
						if(z === -1) {
							obj = {};
							obj.dpPath = dpPath;
							obj.dpProgrammaticPath = dpProgrammaticPath;
							g_datalogUrlDpXifList.push(obj);
						}
					}

				}
			}
		}
		
	}
	if (g_sDataLogDpPath === "")
		g_sDataLogDpPath = "All DPs";
	dpPath = g_sDataLogDpPath;
	
	if(g_sDataLogDate === "")
		g_sDataLogDate = "1 hours";
	try {
		
		if(dpPath !== "") {
			paneTitle += "<input type=\"text\" id=\"dataLogDpUrl\" list=\"dataLogDpUrlList\" class=\"dataLogDp\" value=\"" + dpPath + "\" onchange=\"dataLogDpUrlChanged()\">";
			
			z = -1;
			for(i=0; i < dataLogDpUrlList.length; i ++)
			{
				if(dataLogDpUrlList[i] === dpPath) {
					z = i;
					break;
				}
			}
			if(z === -1)
				dataLogDpUrlList.push(dpPath);
		}
		else {
			paneTitle += "<input type=\"text\" id=\"dataLogDpUrl\" list=\"dataLogDpUrlList\" class=\"dataLogDp\" onchange=\"dataLogDpUrlChanged()\">";
			
		}
		
	} catch {}
	paneTitle += "<datalist id=\"dataLogDpUrlList\">";
	for(i=0; i < dataLogDpUrlList.length; i++)
	{
			paneTitle += "<option value=\"" + dataLogDpUrlList[i] + "\">";
	}
	//paneTitle += "<option value='All Logs'>";
	paneTitle += "<option value='All DPs'>";
	paneTitle += "<option value=\"Sensor1/LightSensor/0/nvoLuxLevel\">";
	paneTitle += "<option value=\"PulseGen/device/0/nvoPulseOut\">";
	paneTitle += "<option value=\"xifname:MS-01/Lamp/0/nvoValueFb\">";
	paneTitle += "<option value=\"/iap/ws?dev=*+name==MS-01&blockName=*+name==Lamp&blockIndex=0&dpName=*+name==nvoLampFb_1&value=*+utc>2021-04-22T08:00:00.000&utc<=2021-04-25T21:39:44.000\">";
	paneTitle += "<option value=\"/iap/ws?dev=%2A%2Bname%3D%3DMS-01&blockName=Lamp&blockIndex=0&dpName=nvoValueFb&value=%2A%2Butc%3E2021-04-22T08:00:00.000\">";
	paneTitle += "<option value=\"/iap/ws?dev=%2A%2Bname%3D%3DPulseGen 1&blockName=%2A%2Bname%3D%3Ddevice&blockIndex=0&dpName=%2A%2Bname%3D%3DnvoLuxLevel&value=%2A%2Butc%3E2021-04-22T08:00:00.000%26utc%3C%3D2021-04-22T21:39:44.000\">";
	paneTitle += "<option value=\"Datapoints List\">";
	paneTitle += "<option value=\"Favorite DPs List\">";
	paneTitle += "<option value=\"*/*/*/nvoLuxLevel\">";
	paneTitle += "<option value=\"Get First Entry\">";
	paneTitle += "<option value=\"Get Last Entry\">";
	paneTitle += "</datalist>";
	paneTitle += "<span style=\"display:inline-block;width:75px;margin-left:10px\">Duration:</span>";
	paneTitle += "<input type=\"text\" id=\"dataLogDpDate\" list=\"dataLogDateList\" class=\"dataLogDate\" value = \"" + g_sDataLogDate + "\">";
	paneTitle += "<datalist id=\"dataLogDateList\">";
	paneTitle += "<option value='All Logs'>";
	try {
		for(i=0; i < dataLogDateList.length; i++)
		{
			paneTitle += "<option value='" + dataLogDateList[i] + "'>";
		}
	} catch {}
	paneTitle += "<option value=\"1 minutes\">";
	paneTitle += "<option value=\"1 hours\">";
	paneTitle += "<option value=\"1 days\">";
	paneTitle += "<option value=\"Yesterday\">";

	paneTitle += "<option value=\">" + currentDate + "\">";		
	paneTitle += "<option value=\">" + currentDate + " 01:00:00.000\">";
	paneTitle += "<option value=\"" + currentDate + " 01:00:00.000 thru " + currentTimestamp + "\">";
	paneTitle += "<option value=\"" + startOfDayStr + " thru " + currentTimeUtc + "\">";
	//paneTitle += "<option value=\">2020-04-25 10:58:28.728\">";
	//paneTitle += "<option value=\"2020-04-25 10:58:28.728 thru 2020-04-25 10:58:28.728\">";
	//paneTitle += "<option value=\"2020-04-25T10:58:28.728Z thru 2020-04-25T10:58:28.728Z\">";
	//paneTitle += "<option value=\"2020-04-25\">";
	paneTitle += "</datalist>";
	paneTitle += "<button id=\"datalogRequestButton\" onclick=\"dataLogRequest()\">Get</button><hr></div>";

	
	//paneContent = "<div><button onclick=\"datalogSmartSort()\">DP sort</button><button onclick=\"clearTable()\">Clear Log</button><br>";
	paneContent = "<table id=\"datalogData\"></table><br><span id=\"gettingInfoId\" class=\"gettingInfo\"></span></div>";
	
	if(g_bDataLogGetInProgress) {
		if(g_datalogWsClient != null) {
			g_datalogWsClient.close();
			g_datalogWsClient = null;
		}
		g_bDataLogGetInProgress = false;
		paneContent = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Previous Get DataLog Data Already in progres ...</span>";
	}
	document.getElementById("main-Header").innerHTML = paneTitle;
	document.getElementById("main").innerHTML = paneContent;

	if(g_bEnableDataLogLiveData) {
		if(g_iDatalogPollMode === 2) {
			document.getElementById("datalogRequestButton").disabled = true;
		}
		else {
			
		}
	}
	if(g_iDatalogPollMode === 0)
		temp = "Getting Logs";
	else if(g_iDatalogPollMode === 1)
		temp = "Getting Logs plus live data";
	else if(g_iDatalogPollMode === 2)
		temp = "Getting Live data";
	if(dpPath.toLowerCase() === "favorite dps list") {
		if(favDpList.length === 0) {
			document.getElementById("main").innerHTML = temp + " stopped as \"Favorite DPs\" list is empty - go to \"Favorites DPs\" View to add datapoint list";
			return;
		}
	
	}
	else if(dpPath.toLowerCase() === "datapoints list") {
		if(dpList.length === 0) {
			document.getElementById("main").innerHTML = temp + " stopped as \"Datapoints\" list is empty - go to \"Datapoints\" View to add datapoint list";
			return;
		}
	
	}

	if(!g_bDataLogGetInProgress) {
		if(dataLogList !== null) {
			if(dataLogList.length > 0) {
				if(dataLogDpList.length > 0) {
					if(g_iDatalogPollMode > 0) {
						datalogLiveDataDpList = JSON.parse(JSON.stringify(dataLogDpList));
						createRequestString(datalogLiveDataDpList);
						g_bdatalogLiveDataConfigured = true;
					}
				}
				if(datalogPaneContent !== "") {
					document.getElementById("main").innerHTML = datalogPaneContent;
					if(g_bShowDatalogChart) {
						if(dataLogDpList.length > 0) {
							// add datalog chart
							g_bUpdateCharts = true;
							g_bCreateChartLegend = true;
							// SVG lines need to be re-created 
							ivChart3ZeroLineAlreadyCreated = false;
							g_bCreateChartLines = true;
							
							try {
								window.setTimeout("timerHandlerChart()", 1000);
							} catch (err) {} 
						}
					}

				}
				else 
					datalogResponseProcessData(3, "", null);
			}
			else {
				// add code for live only for datapoints, favorites or device
				if(g_iDatalogPollMode == 2) {
					// live polling
					dataLogDpList = [];
					g_chartList = [];
					if(g_bDatalogPollingEnabled) {
						url = document.getElementById("dataLogDpUrl");
						if(url !== null) {
							url = url.value;
							url1 = url.toLowerCase();
							paneContent = "<button onclick=\"dataLogAbort()\">Abort</button><br><br><span id=\"gettingInfoId\" class=\"gettingInfo\">Get live Data in progres ...</span>";
							document.getElementById("main").innerHTML = paneContent;
							
							if(url1 === "favorite dps list") {
								datalogStartLiveData(0); //dataLogRequest();
							}
							else if(url1 === "datapoints list") {
								datalogStartLiveData(0); //dataLogRequest();
							}
							else if (url.indexOf("/") !== -1) {
								datalogStartLiveData(0); //datalogGetDpListFromDpInstanceNamesCheck(url);
							}
							else if(dataLogCheckIfUrlIsForDevice(url)) {
								datalogStartLiveData(0); //dataLogRequest();
							}
							else {
								temp = "\"live only\" supports only:<br><br>Device Name (single Device)<br>Datapoints List<br>";
								temp += "Favorite DPs List<br>Datapoints List \(comma separated): PulseGen 1/Light/0/nviLamp";
								document.getElementById("main").innerHTML = temp;
							}
						}
					}
				}
				else if(g_bDatalogStartGetRequest) {

					dataLogDpList = [];
					g_chartList = [];
					dataLogRequest();
				}
			}
		}
	}
	
}
function showDataLogGetDpsFromDeviceType (bFixed, deviceType, pathname) {
	try {
		menuCancel();
		if(deviceTypeList.length > 0)
			showDataLogGetDpsFromDevice_getDpInfo(bFixed, deviceType, pathname);
		else {
			url = "https://" + location.hostname + "/iap/devTypes/*?short=false&sortBy=name&sortOrder=asc"; //8888
			obj = {};
			obj.bFixed = bFixed;
			obj.deviceType = deviceType;
			obj.pathname = pathname;
			requestGetData(obj, url, showDataLogGetDpsFromDeviceTypeResponse, null);
		}
	}
	catch (err) {}
}
function showDataLogGetDpsFromDeviceTypeResponse(mode, requestUrl, json) {
	var bFixed, deviceType, pathname;
	bFixed = mode.bFixed;
	deviceType = mode.deviceType;
	pathname = mode.pathname;
	deviceTypeList = json;
	showDataLogGetDpsFromDevice_getDpInfo(bFixed, deviceType, pathname)
}
function showDataLogGetDpsFromDevice_getDpInfo(bFixed, deviceType, pathname) {
	// deviceType: fixed = deviceName, relative = devicetype, pathname = block Name/Block Index/DP XiF Name
	var i,j, k, z, typeId, bcontinue = false, sDpQualifierPathList = "", newEntry, url, programmaticPathname = ""; //123455
	
	try {
		//create dp qualifier list
		if(bFixed) {
			for (i=0; i < deviceListAll.length; i++)
			{
				if(deviceListAll[i].name === deviceType) {
					//if(deviceListAll[i].status.state === "provisioned") {
						programmaticPathname = deviceListAll[i].name + "/" + pathname;
						showDataLog3(programmaticPathname, "", null);
						return;
					//}
					break;
				}
			}
		}
		else {
			for (j=0; j < deviceTypeList.length; j++) 
			{
				if(deviceTypeList[j].name === deviceType) {
					typeId = deviceTypeList[j].id;
					for (i=0; i < deviceListAll.length; i++)
					{
						if(deviceListAll[i].typeId === typeId) {
							z = -1;
							if(programmaticPathname += "")
								programmaticPathname += ",";
							programmaticPathname += deviceListAll[i].name + "/" + pathname;
						}
					}
					break;
				}
			}
			g_sDataLogDpPath = "xifname:" + programmaticPathname;
			showDataLog3("", "", null);
		}
		
	}
	catch {}
}
function showDeviceLogs(index, devicename) {
    var timespan = 1 * 60 * 60 * 1000;
    menuDivClose(); // close the Datapoint Dp menu if open
    if(!g_bMaxDataLogSizeNotReached && g_bMaxDataLogReachedShowPrompt) {
        showDeviceLogsConfirm(index, devicename, timespan);
        return;
    }
    addChartUi(0, devicename, timespan, null, null);
}
function showDeviceLogsConfirm(index, devicename, timespan) {
    // this is for the navtree device logs and navtree log node
    // mode: 0=log node, 1=device log
    try {
        var element = document.getElementById("planningPaneDetails_Details");
        var offsets = element.getBoundingClientRect(); 
        var x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
        var y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
        var sTemp = "";
        element = document.getElementById("scheduleDiv");
        if(element != null) {
            menuOverlayDivShow(6, null);
            element.className = "showScheduleConfirmDiv";
            element.style.left = x.toString() + "px";
            element.style.top = y.toString() + "px";
            sTemp = "<br>Getting Log Data<br>";
            sTemp += "<br>There are a lot of data logs so this may take a couple of minutes"
            sTemp += "<br><br><input id=\"showdevicelogshidepopup\" type=\"checkbox\">Don't show me this anymore";
            sTemp += "<br><br><button onclick=\"showDeviceLogsConfirmContinue(" + index + ",'" + devicename + "'," + timespan + ")\">Continue</button>";
            sTemp += "<button style=\"margin-left:20px\" onclick=\"showDeviceLogsConfirmCancel()\">Cancel</button>"
            element.innerHTML = sTemp;
        }
    }
    catch {}
}
function showDeviceLogsConfirmContinue(index, devicename, timespan) {
    var element = document.getElementById("showdevicelogshidepopup");
    if(element !== null) {
        if(element.checked)
            g_bMaxDataLogReachedShowPrompt = false;
    }
    addChartUi(0, devicename, timespan, null, null);
}
function showDeviceLogsConfirmCancel() {
    menuScheduleDivClose();
}

/************************************************************************ 
 * DataLog Chart
**************************************************************************/ 
function datalogChartUpdate(mode) {
    //mode: 0 = initial show of chart, 1=determine new min max values changed (, or min max) or datapoints selected and unselected, 2=redraw
    var bExtendLinetoEndTimestamp = false; // false for data log, true for live data
    if(mode == 0)
            datalogChartAddEventListener("dataLogChartSvg");
    if(g_PollingType === DISPLAYMODE_DATALOGLIVEPOLL)
        bExtendLinetoEndTimestamp = true;
    if(g_bDatalogChartZoomInProgress) {
        if(mode < 2) {
            determineMinMaxForZoomChartList(1);
            ivInitializeChart3("dataLogChartSvg", g_datalogChartInfo.zoomMinValue, g_datalogChartInfo.zoomMaxValue, g_datalogChartInfo.zoomMinValue2nd, 
                g_datalogChartInfo.zoomMaxValue2nd, g_bDatalogChartAddZeroLineForNegNumbers, g_iDatalogChartLineSelectedYaxis, null, null, "white", null, "both");
        }    
        ivUpdateChartsDatalogChart3TwoYaxis(g_datalogChartInfo.displayId, "Zoom: ", g_iDatalogChartLineType, g_iDatalogChartLineSelectedYaxis, g_zoomChartList, null, 
            g_datalogChartInfo.zoomMinValue, g_datalogChartInfo.zoomMaxValue,g_datalogChartInfo.zoomMinValue2nd, g_datalogChartInfo.zoomMaxValue2nd,
            g_datalogChartInfo.zoomStartTimestamp, g_datalogChartInfo.zoomEndTimestamp, 5, bExtendLinetoEndTimestamp, "both");
    }
    else {
        if(mode < 2) {
            determineMinMaxForChartList(1);
            ivInitializeChart3("dataLogChartSvg", g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue, g_datalogChartInfo.minValue2nd, g_datalogChartInfo.maxValue2nd,
                g_bDatalogChartAddZeroLineForNegNumbers, g_iDatalogChartLineSelectedYaxis, null, null, "white", null, "both");
        }
        ivUpdateChartsDatalogChart3TwoYaxis(g_datalogChartInfo.displayId, "", g_iDatalogChartLineType, g_iDatalogChartLineSelectedYaxis, g_chartList, null,
            g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue, g_datalogChartInfo.minValue2nd, g_datalogChartInfo.maxValue2nd,
            g_datalogChartInfo.startTimestamp, g_datalogChartInfo.endTimestamp, 5, bExtendLinetoEndTimestamp, "both");
    }
}
function datalogChartInit(mode, displayId) {
    if(mode == 0) {
        ivChartAllowTwoYaxis = true;
        ivChartUseTwoYaxis = false;
        g_bDatalogChartYMinMax = true;
        ivChartLines = [];
        ivChartLines[0] = {};
        ivChartLines[0].created = true;
        ivChartLines[0].name = "polyline1";
        ivChartLines[0].color = "blue";
        datalogPaneContent = "";
        g_bCreateChartLegend = false;
        g_iDataLogChartYaxisDisplayed = 0; // 0=only y1, 1=only y2, 2=y1 and y2 
        g_bDataLogChartUpdateLastEntryToCurrentTimestamp = false;
        g_enumsList = [];
        g_enumsListNewValue = .8;
        g_iDatalogChartLineSelectedYaxis = 0; // controlled by radio button, only needed if both Y1 and Y2 are used
    }
    else if(mode < 2) {
        g_chartLineList = [];
        ivChartLineColorsIndex = 0;
        g_iDatalogChartLineType = 1;
        g_bDataLogChartUsesTwoYaxis = false;
        ivChart3ZeroLineAlreadyCreated = false;
        g_iDatalogChartLineShowYaxis = 0; // what is shown in chart
    }
    
    ivChartNeedTwoYaxis = false;
    g_bDatalogChartZoomInProgress = false;
    bDataLogGetInProgress = false;
    g_datalogSvgDoc = null;
    g_chartList = [];
    g_zoomChartList = [];
    g_datalogChartInfo = {};
    g_datalogChartInfo.displayId = displayId;
    g_datalogChartInfo.minValue = null;
    g_datalogChartInfo.maxValue = null;
    g_datalogChartInfo.minValue2nd = null; //yAxis2 - if ivChartUseTwoYaxis
    g_datalogChartInfo.maxValue2nd = null; //yAxis2
    g_datalogChartInfo.startTimestamp = null;
    g_datalogChartInfo.endTimestamp = null;
    g_datalogChartInfo.zoomMinValue = null;
    g_datalogChartInfo.zoomMaxValue = null;
    g_datalogChartInfo.zoomMinValue2nd = null; //yAxis2
    g_datalogChartInfo.zoomMaxValue2nd = null; //yaxis2
    g_datalogChartInfo.zoomStartTimestamp = null;
    g_datalogChartInfo.zoomEndTimestamp = null;
    g_datalogChartInfo.mouseDownX1 = null; // window coordinates used for zoom start of window
    g_datalogChartInfo.mouseDownY1 = null;
    g_datalogChartInfo.mouseDownX2 = null; // window coordinates used for zoom start of window
    g_datalogChartInfo.mouseDownY2 = null;
    g_datalogChartInfo.datapointsWithEnum = 0;
    g_datalogChartInfo.zoomDatapointsWithEnum = 0;
    g_datalogChartInfo.datapointsOnY1 = 0;
    g_datalogChartInfo.datapointsOnY2 = 0;  // datapoint value must be between 0 and 1.
    g_datalogChartInfo.zoomDatapointsOnY1 = 0;
    g_datalogChartInfo.zoomDatapointsOnY2 = 0;  // datapoint value must be between 0 and 1.
    g_datalogChartInfo.bNeedTwoYaxis = false;


}
function chartLineAllEnable() {
    try {
        var i, j, displayId, displayObj;
        var checked = document.getElementById("chartLineAllEnable").checked;
        for(i=0; i < g_chartList.length; i++)
        {
            g_chartList[i].display = checked;
            g_chartList[i].show = checked;
            displayId = "line_" + g_chartList[i].pathname + "__field_" + g_chartList[i].field;
            lineListIndex = g_chartList[i].lineColorIndex;
            if((g_chartLineList[lineListIndex].pathname == g_chartList[i].pathname) && (g_chartLineList[lineListIndex].field == g_chartList[i].field)) {
                g_chartLineList[lineListIndex].show = g_chartList[i].display;
                if((g_iDatalogChartLineSelectedYaxis == 0) || (g_iDatalogChartLineSelectedYaxis == 3))
                    g_chartList[i].show = g_chartList[i].display;
                else if(g_iDatalogChartLineSelectedYaxis == 1) {
                    if(g_chartList[i].yAxis == 1)
                        g_chartList[i].show = g_chartList[i].display;
                    else
                        g_chartList[i].show = false;
                }
                else if(g_iDatalogChartLineSelectedYaxis == 2) {
                    if(g_chartList[i].yAxis == 2)
                        g_chartList[i].show = g_chartList[i].display;
                    else
                        g_chartList[i].show = false;
                }
                g_chartLineList[lineListIndex].show = g_chartList[i].display; // legend checkvox
                if(g_bDatalogChartZoomInProgress) {
                    if((g_zoomChartList[i].pathname == pathname) && (g_zoomChartList[i].field == field)) {
                        g_zoomChartList[i].show = g_chartList[i].show;
                        g_zoomChartList[i].display = g_chartList[i].display;
                        
                    }
                }
            }
            displayObj = document.getElementById(displayId);
            if(displayObj != null)
                displayObj.checked = checked;
        }
        datalogChartUpdate(1);
    }
    catch {}
}
function chartLineEnable(chartListId, pathname, field) {
    try {
        var displayId, lineListIndex;
        if((g_chartList[chartListId].pathname == pathname) && (g_chartList[chartListId].field == field)) {
            displayId = "line_" + g_chartList[chartListId].pathname + "__field_" + g_chartList[chartListId].field;
            lineListIndex = g_chartList[chartListId].lineColorIndex;
            if((g_chartLineList[lineListIndex].pathname == pathname) && (g_chartList[chartListId].field == field)) {
                g_chartList[chartListId].display = document.getElementById(displayId).checked; // legend checkbox
                g_chartLineList[lineListIndex].show = g_chartList[chartListId].display;
                if((g_iDatalogChartLineSelectedYaxis == 0) || (g_iDatalogChartLineSelectedYaxis == 3))
                    g_chartList[chartListId].show = g_chartList[chartListId].display;
                else if(g_iDatalogChartLineSelectedYaxis == 1) {
                    if(g_chartList[chartListId].yAxis == 1)
                        g_chartList[chartListId].show = g_chartList[chartListId].display;
                    else
                        g_chartList[chartListId].show = false;
                }
                else if(g_iDatalogChartLineSelectedYaxis == 2) {
                    if(g_chartList[chartListId].yAxis == 2)
                        g_chartList[chartListId].show = g_chartList[chartListId].display;
                    else
                        g_chartList[chartListId].show = false;
                }
                g_chartLineList[lineListIndex].show = g_chartList[chartListId].display; // legend checkvox
                if(g_bDatalogChartZoomInProgress) {
                    if((g_zoomChartList[chartListId].pathname == pathname) && (g_zoomChartList[chartListId].field == field)) {
                        g_zoomChartList[chartListId].show = g_chartList[chartListId].show;
                        g_zoomChartList[chartListId].display = g_chartList[chartListId].display;
                        
                    }
                }
                datalogChartUpdate(1);
            }

        }
    }
    catch {}
}
function createChartLegend() {
    try {
        var displayId;
        var legend = document.getElementById("chartLegend");
        var legendStr = "";
        var max = 10;
        var count = 0;
        var bAddDivEnd = false;
        var divCount = 1;
        
        if(legend != null) {
            //legend.style.backgroundColor = "#dcdcdc";
            //legend.style.color = "black";
           if(g_chartList != null) {

                for(i=0; i < g_chartList.length; i++)
                {
                    if(g_chartList[i].display)
                        count++;
                    else
                        break;
                }

                legendStr += "<div style=\"text-align:center\">";
                legendStr += "<input type=\"checkbox\" id=\"chartLineAllEnable\"";
                legendStr += " onchange=\"chartLineAllEnable()\"";
                if(count == g_chartList.length)
                    legendStr += " checked";
                legendStr += "> Legend [<span id=\"legendDpCount\">" + g_chartList.length + "</span> Datapoints/Fields]</div><br><div id=\"legendLineDivs\" style=\"display:flex\">";
                count = 0;
                for(i=0; i < g_chartList.length; i++)
                {
                    if(count == 0) {
                        if(bAddDivEnd) {
                            legendStr += "</div>";
                            divCount ++;
                        }
                        legendStr += "<div id=\"legendDiv_" + divCount + "\" style=\"margin-left:5px;min-width:400px\">"
                        bAddDivEnd = true;
                    }
                    displayId = "line_" + g_chartList[i].pathname + "__field_" + g_chartList[i].field;
                    
                    legendStr += "<br><input type=\"checkbox\" id=\"" + displayId + "\"";
                    legendStr += " onchange=\"chartLineEnable(" + i + ",'" +  g_chartList[i].pathname + "', '" + g_chartList[i].field + "')\"";
                    if(g_chartList[i].display)
                        legendStr += " checked";
                    legendStr += "><label style=\"color:" + g_chartList[i].color + ";background-color:#dcdcdc\">";
                    legendStr += g_chartList[i].pathnameUI;
                    if(g_chartList[i].field != "") {
                        legendStr += " [" + g_chartList[i].field + "]";
                    }
                    legendStr += "</label>";
                    i
                    count ++;
                    if(count > max)
                        count = 0;
                    
                }
                if(bAddDivEnd == 0)
                    legendStr += "</div>"
                
            }
            else
                legendStr += "<div style=\"text-align:center\">Legend [0 Datapoints/Fields]";
            legend.innerHTML = legendStr + "</div>";
        }
    }
    catch {}
}

function createChartObjectLargeChart(mode, index, displayId, pathname, valueList, min, max, hasDynmaicRange, linecolor, chartLabels) {
    // single line chart2.svg
    // mode: 0= current end date, 1= has end date
    try {
        var fvalue, fvalue1;
        var chart = {};
        var polygoncolor;
        var obj, obj1;
        var i, iCount = 0;
        var ptr;
        var temp, bAddToChartData = true;
        if(dataLogDpList[index].pathname != pathname)
            return;
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathname = pathname;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.chartLabels = "both";
        chart.data = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = dataLogDpList[index].hasNegativeNumbers; 
        chart.paused = false;
        if(valueList != null) {
            ptr = valueList.length;
            for(i=0; i < valueList.length; i++)
            {
                ptr --;
                bAddToChartData = true;
                // only add to chart.data if value is different from previous value, if same value then change timestamp - this will greatly reduce number of datapoints to chart
                if(i > 2) {
                    //if(valueList[ptr].value == chart.data[chart.data.length - 1].value) {
                        if(valueList[i].value == chart.data[0].value) {
                            chart.data[0].timestamp = valueList[i].timestamp; // don't use
                            bAddToChartData = false;
                    }
                }
                if(bAddToChartData) {
                    iCount ++;
                    obj = {};
                    obj1 = {};
                    obj = valueList[i];
                    temp = JSON.stringify(obj);
                    obj1 = JSON.parse(temp);
                    chart.data.unshift(obj1);
                }
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i])));
                if(iCount > ivChartTotalEntriesLargeChart)
                    break;
            }
            //if(mode == 0)
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i]))); // repeat last line 
        }
        chart.endPtr = chart.data.length - 1;
        chart.dataCurrentEntries = chart.data.length;
        if(max != null) {
            fvalue = parseFloat(max);
            if(fvalue < 0) 
                fvalue1 = 0;
            else if(fvalue < 1) 
                fvalue1 = 1;
            if(fvalue < 5)
                fvalue1 = 5;
            else if(fvalue > 1) 
                fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
			max = fvalue1;
        }
        if(hasDynmaicRange) {
            if(min != null) {
                fvalue = parseFloat(min);
                if(fvalue < 0) 
                fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                else if(fvalue < 1) 
                    fvalue1 = 0;
                if(fvalue < 5)
                    fvalue1 = 0;
                else if(fvalue > 1) 
                    fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                min = fvalue1;
            }
        }
        else {
            min = 0;
            if (dataLogDpList[index].hasNegativeNumbers) {
                min = dataLogDpList[index].min;
            }
        }
        g_datalogChartInfo.minValue = min;
        g_datalogChartInfo.maxValue = max; 
        g_datalogChartInfo.startTimestamp = chart.data[0].timestamp;
        g_datalogChartInfo.endTimeStamp = chart.data[chart.data.length - 1].timestamp;
        chart.maxValue = max;
        chart.minValue = min;
        chart.dynamicRange = hasDynmaicRange;
        chart.chartLabels = chartLabels;
        if(linecolor == null) {
            linecolor = "blue";
        }
        polygoncolor = "light" + linecolor;
        chart.lineColor = linecolor;
        chart.polygoncolor = polygoncolor;
        g_chartList.push(chart);
        
    }
    catch {}
}
function createChartObjectLargeChart3(binitial, mode, index, displayId, chartDpList) {
    // chart3.svg
    // this function takes a dplist and creates a line for each scalar datapoint or field that is a scalar [1 level deep]
    // multiline field support
    // mode: 0= current end date, 1= has end date
    // create one chart entry per datapoint field
    try {
        var i, k;
        var obj, obj1;
        var temp, bAddNewEntry, bUpdateLastEntry;
        var atleastoneY1Datapoint = false, atleastoneY2Datapoint = false;
        if(chartDpList == null)
            return;
        if(chartDpList.length == null)
            return;
        datalogChartInit(2, displayId);
        ivChartLineColorsIndex = 0;
        ivChartNeedTwoYaxis = false;
        for(k=0; k < chartDpList.length; k++) {
            if(chartDpList[k].valueList != null) {
                if(chartDpList[k].valueList.length > 0) {
                    if((typeof chartDpList[k].valueList[0].value === "number") || (typeof chartDpList[k].valueList[0].value === "string")){
                        createChartObjectLargeChartLine(mode, index, displayId, chartDpList[k].pathname, chartDpList[k].pathnameUI, "", chartDpList[k].valueList); // string is a enum
                    }
                    else {
                        // field so create a chart line for each field
                        createChartObjectLargeChartFieldLines(mode, index, displayId, chartDpList[k].pathname, chartDpList[k].pathnameUI, chartDpList[k].valueList);
                    }

                } //if(chartDpList[k].valueList.length > 0) {
            }
        } // for(k=0; k < chartDpList; k++)
        for(i=0; i < g_chartList.length; i++)
        {
            if(i==0) {
                g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
            }
            else {
                if(g_datalogChartInfo.startTimestamp > g_chartList[i].startTimestamp)
                    g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                if(g_datalogChartInfo.endTimestamp < g_chartList[i].endTimestamp)
                    g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
            }
        }
        if(g_bDataLogChartUpdateLastEntryToCurrentTimestamp) {
            for(i=0; i < g_chartList.length; i++)
            {
                bAddNewEntry = false;
                bUpdateLastEntry = false;
                if((g_chartList[i].endPtr == 0) && (g_chartList[i].data[g_chartList[i].endPtr].timestamp < g_datalogChartInfo.endTimestamp))
                    bAddNewEntry = true;
                if(g_chartList[i].data[g_chartList[i].endPtr].timestamp < g_datalogChartInfo.endTimestamp) {
                    if(g_chartList[i].dataCurrentEntries > 1) {
                        if(g_chartList[i].data[g_chartList[i].endPtr].value != g_chartList[i].data[g_chartList[i].endPtr - 1].value) {
                            // add new entry
                            bAddNewEntry = true;
                        }
                        else 
                            bUpdateLastEntry = true;
                    }
                    else 
                        bAddNewEntry = true;
                }
                    if(bAddNewEntry) {
                        obj = {};
                        obj1 = {};
                        obj = g_chartList[i].data[g_chartList[i].endPtr];
                        temp = JSON.stringify(obj);
                        obj1 = JSON.parse(temp);
                        g_chartList[i].data.push(obj1);
                        g_chartList[i].endPtr ++;
                        g_chartList[i].dataCurrentEntries = g_chartList[i].data.length;

                    }
                    if(bAddNewEntry || bUpdateLastEntry) 
                        g_chartList[i].data[g_chartList[i].endPtr].timestamp = g_datalogChartInfo.endTimestamp;
                
            }
        }
        if(binitial) {
            // determine if both axis used
            g_bDataLogChartUsesTwoYaxis = false;
            for(i=0; i < g_chartList.length; i++)
            {
                if((g_chartList[i].minValue >= 0) && (g_chartList[i].maxValue > 0) && (g_chartList[i].maxValue <= 1)) 
                    atleastoneY2Datapoint = true;
                else 
                    atleastoneY1Datapoint = true;
            }
            if(atleastoneY1Datapoint && atleastoneY2Datapoint) {
                g_bDataLogChartUsesTwoYaxis = true;
                g_iDatalogChartLineSelectedYaxis = 3;
            }
            else 
                g_iDatalogChartLineSelectedYaxis = 0;
        }
        determineMinMaxForChartList(1);
    }
    catch {}
}
function determineMinMaxForChartList(mode) {
        // Determine if min max values and whether one axis, or both axis are used
        //mode: 0=hidden and visible, 1= visible (show)
        // need to determine if two y-axis are needed and then based on g_iDatalogChartLineSelectedYaxis
    try {
        var i;
        
        g_datalogChartInfo.startTimestamp = null;
        g_datalogChartInfo.endTimestamp = null;
        g_datalogChartInfo.minValue = null;
        g_datalogChartInfo.maxValue = null;
        g_datalogChartInfo.minValue2nd = null;
        g_datalogChartInfo.maxValue2nd = null;
        ivChartNeedTwoYaxis = false;
        g_datalogChartInfo.datapointsOnY1 = 0;
        g_datalogChartInfo.datapointsOnY2 = 0;
        for(i=0; i < g_chartList.length; i++)
        {
            if((mode == 0) || ((mode == 1) && g_chartList[i].show)) {
                if(g_datalogChartInfo.startTimestamp == null) {
                    g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                    g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
                }
                else {
                    if(g_datalogChartInfo.startTimestamp > g_chartList[i].startTimestamp)
                        g_datalogChartInfo.startTimestamp = g_chartList[i].startTimestamp;
                    if(g_datalogChartInfo.endTimestamp < g_chartList[i].endTimestamp)
                        g_datalogChartInfo.endTimestamp = g_chartList[i].endTimestamp;
                }
                if(g_chartList[i].isEnum)
                    g_datalogChartInfo.datapointsWithEnum ++;
                if(g_iDatalogChartLineSelectedYaxis > 0) { //(ivChartAllowTwoYaxis) {
                    if(((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) 
                        && (g_chartList[i].minValue >= 0) && (g_chartList[i].maxValue > 0) && (g_chartList[i].maxValue <= 1)) {
                        //ivChartAllowTwoYaxis = true;
                        //ivChartUseTwoYaxis = false;
                        if(g_datalogChartInfo.minValue2nd == null) {
                            g_datalogChartInfo.minValue2nd = g_chartList[i].minValue;
                            g_datalogChartInfo.maxValue2nd = g_chartList[i].maxValue;
                        }
                        else {
                            if(g_datalogChartInfo.minValue2nd > g_chartList[i].minValue)
                                g_datalogChartInfo.minValue2nd = g_chartList[i].minValue;
                            if(g_datalogChartInfo.maxValue2nd < g_chartList[i].maxValue)
                                g_datalogChartInfo.maxValue2nd = g_chartList[i].maxValue;
                        }
                        g_datalogChartInfo.datapointsOnY2 ++;
                    }
                    else {
                        if(g_iDatalogChartLineSelectedYaxis != 2) {
                            if(g_datalogChartInfo.minValue == null) {
                                g_datalogChartInfo.minValue = g_chartList[i].minValue;
                                g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                            }
                            else {
                                if(g_datalogChartInfo.minValue > g_chartList[i].minValue)
                                    g_datalogChartInfo.minValue = g_chartList[i].minValue;
                                if(g_datalogChartInfo.maxValue < g_chartList[i].maxValue)
                                    g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                            }
                            g_datalogChartInfo.datapointsOnY1++;
                        }
                    }
                }
                else {
                    if(g_datalogChartInfo.minValue == null) {
                        g_datalogChartInfo.minValue = g_chartList[i].minValue;
                        g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                    }
                    else {
                        if(g_datalogChartInfo.minValue > g_chartList[i].minValue)
                            g_datalogChartInfo.minValue = g_chartList[i].minValue;
                        if(g_datalogChartInfo.maxValue < g_chartList[i].maxValue)
                            g_datalogChartInfo.maxValue = g_chartList[i].maxValue;
                    }
                }
                
            }
        }
        if((g_datalogChartInfo.datapointsOnY1 > 0) && (g_datalogChartInfo.datapointsOnY2 > 0))
            g_datalogChartInfo.bNeedTwoYaxis = true;
       

        
        
        if((g_datalogChartInfo.minValue2nd != null) && (g_datalogChartInfo.maxValue2nd != null)) {
            if((g_datalogChartInfo.minValue != null) && (g_datalogChartInfo.maxValue != null)) {
                ivChartNeedTwoYaxis = true;
                for(i=0; i < g_chartList.length; i++)
                {
                    if((mode == 0) || ((mode == 1) && g_chartList[i].show)) {
                        if((g_chartList[i].minValue >= 0) && (g_chartList[i].maxValue > 0) && (g_chartList[i].maxValue <= 1)) {
                            g_chartList[i].yAxis = 2;
                        }
                        else 
                            g_chartList[i].yAxis = 1;
                    }
                }
            }
            else { // only Y2 used
                ivChartNeedTwoYaxis = false;
                for(i=0; i < g_chartList.length; i++)
                {
                    g_chartList[i].yAxis = 2;
                    
                }
                //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
                //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
            }
        }
        else { // only Y1 used
            ivChartNeedTwoYaxis = false;
            for(i=0; i < g_chartList.length; i++)
            {
                g_chartList[i].yAxis = 1;
                
            }
            //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
            //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
        }
        if((g_datalogChartInfo.maxValue !== null)  && (g_datalogChartInfo.minValue !== null)) {
            g_datalogChartInfo.maxValue = calculatechartMaxValue(g_datalogChartInfo.maxValue);
            if(g_bDatalogChartYMinMax)
                g_datalogChartInfo.minValue = calculatechartMinValue(g_datalogChartInfo.minValue);
        }
        if(ivChartNeedTwoYaxis) {
            if((g_datalogChartInfo.maxValue2nd !== null) && (g_datalogChartInfo.minValue2nd !== null)) {
                g_datalogChartInfo.maxValue2nd = calculatechartMaxValue(g_datalogChartInfo.maxValue2nd);
                if(g_bDatalogChartYMinMax)
                    g_datalogChartInfo.minValue2nd = calculatechartMinValue(g_datalogChartInfo.minValue2nd);
            }
        }
    }
    catch {}
}
function determineMinMaxForZoomChartList(mode) {
    // Determine if min max values and whether one axis, or both axis are used
    //mode: 0=hidden and visible, 1= visible (show)
    // need to determine if two y-axis are needed and then based on g_iDatalogChartLineSelectedYaxis
try {
    var i;
    
    g_datalogChartInfo.zoomStartTimestamp = null;
    g_datalogChartInfo.zoomEndTimestamp = null;
    
    g_datalogChartInfo.zoomMinValue = null;
    g_datalogChartInfo.zoomMaxValue = null;
    g_datalogChartInfo.zoomMinValue2nd = null;
    g_datalogChartInfo.zoomMaxValue2nd = null;
    ivChartNeedTwoYaxis = false;
    g_datalogChartInfo.zoomDatapointsOnY1 = 0;
    g_datalogChartInfo.zoomDatapointsOnY2 = 0;
    for(i=0; i < g_zoomChartList.length; i++)
    {
        if(g_zoomChartList[i].data.length > 0) {
            if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                if(g_datalogChartInfo.zoomStartTimestamp == null) {
                    g_datalogChartInfo.zoomStartTimestamp = g_zoomChartList[i].startTimestamp;
                    g_datalogChartInfo.zoomEndTimestamp = g_zoomChartList[i].endTimestamp;
                }
                else {
                    if(g_datalogChartInfo.startTimestamp > g_zoomChartList[i].startTimestamp)
                        g_datalogChartInfo.startTimestamp = g_zoomChartList[i].startTimestamp;
                    if(g_datalogChartInfo.endTimestamp < g_zoomChartList[i].endTimestamp)
                        g_datalogChartInfo.endTimestamp = g_zoomChartList[i].endTimestamp;
                }
                if(g_zoomChartList[i].isEnum)
                    g_datalogChartInfo.zoomDatapointsWithEnum ++;
                if(g_iDatalogChartLineSelectedYaxis > 0) { //(ivChartAllowTwoYaxis) {
                    if(((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) 
                        && (g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        //ivChartAllowTwoYaxis = true;
                        //ivChartUseTwoYaxis = false;
                        if(g_datalogChartInfo.zoomMinValue2nd == null) {
                            g_datalogChartInfo.zoomMinValue2nd = g_zoomChartList[i].minValue;
                            g_datalogChartInfo.zoomMaxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        else {
                            if(g_datalogChartInfo.zoomMinValue2nd > g_zoomChartList[i].minValue)
                                g_datalogChartInfo.zoomMinValue2nd = g_zoomChartList[i].minValue;
                            if(g_datalogChartInfo.zoomMaxValue2nd < g_zoomChartList[i].maxValue)
                                g_datalogChartInfo.zoomMaxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        g_datalogChartInfo.zoomDatapointsOnY2 ++;
                    }
                    else {
                        if(g_iDatalogChartLineSelectedYaxis != 2) {
                            if(g_datalogChartInfo.zoomMinValue == null) {
                                g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                                g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                            }
                            else {
                                if(g_datalogChartInfo.zoomMinValue > g_zoomChartList[i].minValue)
                                    g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                                if(g_datalogChartInfo.zoomMaxValue < g_zoomChartList[i].maxValue)
                                    g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                            }
                            g_datalogChartInfo.zoomDatapointsOnY1++;
                        }
                    }
                }
                else {
                    if(g_datalogChartInfo.zoomMinValue == null) {
                        g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                    else {
                        if(g_datalogChartInfo.zoomMinValue > g_zoomChartList[i].minValue)
                            g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        if(g_datalogChartInfo.zoomMaxValue < g_zoomChartList[i].maxValue)
                            g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                }
                
            }
        }
    }
    if((g_datalogChartInfo.zoomDatapointsOnY1 > 0) && (g_datalogChartInfo.zoomDatapointsOnY2 > 0))
        g_datalogChartInfo.bNeedTwoYaxis = true;
   

    
    
    if((g_datalogChartInfo.zoomMinValue2nd != null) && (g_datalogChartInfo.zoomMaxValue2nd != null)) {
        if((g_datalogChartInfo.zoomMinValue != null) && (g_datalogChartInfo.zoomMaxValue != null)) {
            ivChartNeedTwoYaxis = true;
            for(i=0; i < g_zoomChartList.length; i++)
            {
                if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                    if((g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        g_zoomChartList[i].yAxis = 2;
                    }
                    else 
                        g_zoomChartList[i].yAxis = 1;
                }
            }
        }
        else { // only Y2 used
            ivChartNeedTwoYaxis = false;
            for(i=0; i < g_zoomChartList.length; i++)
            {
                g_zoomChartList[i].yAxis = 2;
                
            }
            //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
            //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
        }
    }
    else { // only Y1 used
        ivChartNeedTwoYaxis = false;
        for(i=0; i < g_zoomChartList.length; i++)
        {
            g_zoomChartList[i].yAxis = 1;
            
        }
    }
    g_datalogChartInfo.zoomMaxValue = calculatechartMaxValue(g_datalogChartInfo.zoomMaxValue);
    if(g_bDatalogChartYMinMax)
        g_datalogChartInfo.zoomMinValue = calculatechartMinValue(g_datalogChartInfo.zoomMinValue);
    if(ivChartNeedTwoYaxis) {
        g_datalogChartInfo.zoomMaxValue2nd = calculatechartMaxValue(g_datalogChartInfo.zoomMaxValue2nd);
        if(g_bDatalogChartYMinMax)
            g_datalogChartInfo.zoomMinValue2nd = calculatechartMinValue(g_datalogChartInfo.zoomMinValue2nd);
    }
}
catch {}
}
function determineMinMaxForZoomChartList_old(mode) {  //remove if new one works
    // Determine if min max values and whether one axis, or both axis are used
    //mode: 0=hidden and visible, 1= visible (show)
    // need to determine if two y-axis are needed and then based on g_iDatalogChartLineSelectedYaxis
try {
    var i;
    
    g_datalogChartInfo.zoomStartTimestamp = null;
    g_datalogChartInfo.zoomEndTimestamp = null;
    g_datalogChartInfo.zoomMinValue = null;
    g_datalogChartInfo.zoomMaxValue = null;
    g_datalogChartInfo.zoomMinValue2nd = null;
    g_datalogChartInfo.zoomMaxValue2nd = null;
    ivChartNeedTwoYaxis = false;
    g_datalogChartInfo.zoomDatapointsOnY1 = 0;
    g_datalogChartInfo.zoomDatapointsOnY2 = 0;
    for(i=0; i < g_zoomChartList.length; i++)
    {
        if(g_zoomChartList[i].data.length > 0) {
            if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                if(g_datalogChartInfo.zoomStartTimestamp == null) {
                    g_datalogChartInfo.zoomStartTimestamp = g_zoomChartList[i].startTimestamp;
                    g_datalogChartInfo.zoomEndTimestamp = g_zoomChartList[i].endTimestamp;
                }
                else {
                    if(g_datalogChartInfo.startTimestamp > g_zoomChartList[i].startTimestamp)
                        g_datalogChartInfo.startTimestamp = g_zoomChartList[i].startTimestamp;
                    if(g_datalogChartInfo.endTimestamp < g_zoomChartList[i].endTimestamp)
                        g_datalogChartInfo.endTimestamp = g_zoomChartList[i].endTimestamp;
                }
                if(g_zoomChartList[i].isEnum)
                    g_datalogChartInfo.zoomDatapointsWithEnum ++;
                if(g_iDatalogChartLineSelectedYaxis > 0) { //(ivChartAllowTwoYaxis) {
                    if(((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) 
                        && (g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        //ivChartAllowTwoYaxis = true;
                        //ivChartUseTwoYaxis = false;
                        if(g_datalogChartInfo.minValue2nd == null) {
                            g_datalogChartInfo.minValue2nd = g_zoomChartList[i].minValue;
                            g_datalogChartInfo.maxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        else {
                            if(g_datalogChartInfo.minValue2nd > g_zoomChartList[i].minValue)
                                g_datalogChartInfo.minValue2nd = g_zoomChartList[i].minValue;
                            if(g_datalogChartInfo.maxValue2nd < g_zoomChartList[i].maxValue)
                                g_datalogChartInfo.maxValue2nd = g_zoomChartList[i].maxValue;
                        }
                        g_datalogChartInfo.zoomDatapointsOnY2 ++;
                    }
                    else {
                        if(g_iDatalogChartLineSelectedYaxis != 2) {
                            if(g_datalogChartInfo.minValue == null) {
                                g_datalogChartInfo.minValue = g_zoomChartList[i].minValue;
                                g_datalogChartInfo.maxValue = g_zoomChartList[i].maxValue;
                            }
                            else {
                                if(g_datalogChartInfo.minValue > g_zoomChartList[i].minValue)
                                    g_datalogChartInfo.minValue = g_zoomChartList[i].minValue;
                                if(g_datalogChartInfo.maxValue < g_zoomChartList[i].maxValue)
                                    g_datalogChartInfo.maxValue = g_zoomChartList[i].maxValue;
                            }
                            g_datalogChartInfo.zoomDatapointsOnY1++;
                        }
                    }
                }
                else {
                    if(g_datalogChartInfo.zoomMinValue == null) {
                        g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                    else {
                        if(g_datalogChartInfo.zoomMinValue > g_zoomChartList[i].minValue)
                            g_datalogChartInfo.zoomMinValue = g_zoomChartList[i].minValue;
                        if(g_datalogChartInfo.zoomMaxValue < g_zoomChartList[i].maxValue)
                            g_datalogChartInfo.zoomMaxValue = g_zoomChartList[i].maxValue;
                    }
                }
                
            }
        }
    }
    if((g_datalogChartInfo.zoomDatapointsOnY1 > 0) && (g_datalogChartInfo.zoomDatapointsOnY2 > 0))
        g_datalogChartInfo.bNeedTwoYaxis = true;
   

    
    
    if((g_datalogChartInfo.minValue2nd != null) && (g_datalogChartInfo.maxValue2nd != null)) {
        if((g_datalogChartInfo.minValue != null) && (g_datalogChartInfo.maxValue != null)) {
            ivChartNeedTwoYaxis = true;
            for(i=0; i < g_zoomChartList.length; i++)
            {
                if((mode == 0) || ((mode == 1) && g_zoomChartList[i].show)) {
                    if((g_zoomChartList[i].minValue >= 0) && (g_zoomChartList[i].maxValue > 0) && (g_zoomChartList[i].maxValue <= 1)) {
                        g_zoomChartList[i].yAxis = 2;
                    }
                    else 
                        g_zoomChartList[i].yAxis = 1;
                }
            }
        }
        else {
            ivChartNeedTwoYaxis = false;
            //g_datalogChartInfo.minValue =  g_datalogChartInfo.minValue2nd;
            //g_datalogChartInfo.maxValue = g_datalogChartInfo.maxValue2nd;
        }
    }
    g_datalogChartInfo.maxValue = calculatechartMaxValue(g_datalogChartInfo.maxValue);
    if(g_bDatalogChartYMinMax)
        g_datalogChartInfo.minValue = calculatechartMinValue(g_datalogChartInfo.minValue);
    if(ivChartNeedTwoYaxis) {
        g_datalogChartInfo.maxValue2nd = calculatechartMaxValue(g_datalogChartInfo.maxValue2nd);
        if(g_bDatalogChartYMinMax)
            g_datalogChartInfo.minValue2nd = calculatechartMinValue(g_datalogChartInfo.minValue2nd);
    }
}
catch {}
}
function calculatechartMaxValue(max) {
    var result = max;
    var fvalue;
    try {
        if(max != null) {
            fvalue = parseFloat(max);
            if(fvalue < 0) 
                fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
            else if(fvalue < 1) 
                fvalue1 = 1;
            else if(fvalue < 2)
                fvalue1 = 2;
            else if(fvalue < 5)
                fvalue1 = 5;
            else if(fvalue > 1) 
                fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
            max = fvalue1;
        }
    }
    catch {result = max;}
    return max;
}
function calculatechartMinValue(min) {
    var result = min;
    var fvalue;
    try {
        if(min != null) {
            fvalue = parseFloat(min);
            if(fvalue < 0) 
                fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
            else if(fvalue < 1) 
                fvalue1 = 0;
            else if(fvalue < 5)
                fvalue1 = 0;
            else if(fvalue > 1) 
                fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
            min = fvalue1;
        }
    }
    catch {result = min;}
    return min;
}
function createChartObjectLargeChartFieldLines(mode, index, displayId, pathname, pathnameUI, valueList) {
    // multiline field support
    // mode: 0= current end date, 1= has end date
    // create one chart entry per datapoint field
    try {
        var fvalue, fvalue1;
        var chart = {};
        var polygoncolor, show = true;
        var lineNumber = 0, lineName,dpValue, value, valueStr;
        var obj, obj1;
        var i, iCount = 0, z = -1, j, k, field, z;
        var color;
        var ptr,lineObj;
        var charts = []; // one obj for each scalar field
        var temp, baddToChart, bAddToChartData = true;
        if(valueList == null)
            return;
        if(valueList.length == null)
            return;
        // determine fields
        temp = valueList[0].locValue;
        for(field in temp) 
        {
            baddToChart = false;
            if(typeof temp[field] === "number") 
                baddToChart = true;
            else if(typeof temp[field] === "string") {
                if(temp[field].indexOf(" ") == -1)
                    baddToChart = true; // enums don't have spaces
            }
            else if(typeof temp[field] === "boolean") {
                baddToChart = true; // enums don't have spaces
            }
            if(baddToChart)
            {
                chart = {};
                chart.startPtr = 0;
                chart.endPtr = 0;
                chart.pathname = pathname;
                chart.pathnameUI = pathnameUI;
                chart.field = field;
                chart.dashboardDpIndex = index;
                chart.displayId = displayId;
                chart.data = [];
                chart.dataCurrentEntries = 1; //iottest
                chart.hasNegativeNumbers = false; //dataLogDpList[index].hasNegativeNumbers; 
                chart.show = true; // controlled by chart.display and g_iDatalogChartLineSelectedYaxis
                chart.display = true; // controlled by checkbox
                chart.yAxis = 1;
                chart.dashboardDpIndex = index;
                chart.displayId = displayId;
                chart.paused = false;
                
                color = "blue";
                lineName = "";
                chart.creatChartLine = false;
                z = -1;
                for(i=0; i < g_chartLineList.length; i ++) 
                {
                    if((g_chartLineList[i].pathname == pathname) && (g_chartLineList[i].field == field)){
                        lineName = g_chartLineList[i].lineName;
                        color = g_chartLineList[i].color;
                        show = g_chartLineList[i].show;
                        z = i;
                        break;
                    }
                }
                if(z == -1) {
                    lineNumber = g_chartLineList.length + 1;
                    lineName = "polyline" + lineNumber;
                    if(lineNumber != 1)  { // line number 1 is there by default
                        // may need to add code to check if line is already created
                        ivChartLineColorsIndex ++;
                        if(ivChartLineColorsIndex >= ivChartLineColors.length)
                            ivChartLineColorsIndex = 0;
                        color = ivChartLineColors[ivChartLineColorsIndex];
                        chart.creatChartLine = true; //ivCreateNewPolyline(displayId, lineName, color, 5);
                    }
                    lineObj = {};
                    lineObj.lineName = lineName;
                    lineObj.color = color;
                    lineObj.pathname = pathname;
                    lineObj.field = field;
                    lineObj.show = true;
                    g_chartLineList.push(lineObj);  // not sure this is needed
                    z = g_chartLineList.length - 1;
                }
                chart.lineColorIndex = z;
                chart.lineName = lineName; //"polyline" + lineNumber;
                chart.color = color;
                chart.show = show;
                chart.isEnum = false;
                chart.isBoolean = false;
                if(typeof temp[field] === "boolean")
                    chart.isBoolean = true;

                charts.push(chart);
            }
        }
        //chart.fields = [];
        if(valueList != null) {
            ptr = valueList.length;
            for(i=0; i < valueList.length; i++)
            {
                ptr --;
                dpValue = valueList[i].locValue;
                dpValue1 = valueList[i].value;
                for(k=0; k < charts.length; k++)
                { // individual fields
                        
                    bAddToChartData = true;

                    value = dpValue[charts[k].field];
                    valuestr = "";
                    if(charts[k].isEnum) {
                        valueStr = value;
                        value = determineEnumValue(value);
                    }
                    else if(chart.isBoolean) {
                        valuestr = value;
                        if(value)
                            value = 1;
                        else 
                            value = 0;
                    }
                    // only add to chart.data if value is different from previous value, if same value then change timestamp - this will greatly reduce number of datapoints to chart
                    if(i > 2) {
                        //if(valueList[ptr].value == chart.data[chart.data.length - 1].value) {
                        if(value == charts[k].data[0].value) {
                            if(value == charts[k].data[1].value) {  //used to show start and end times of group of updates with same value
                                charts[k].data[0].timestamp = valueList[i].timestamp; // don't use
                                bAddToChartData = false;
                            }
                        }
                        
                    }
                    if(bAddToChartData) {
                        if(i==0) {
                            charts[k].maxValue = value;
                            charts[k].minValue = value;
                        }
                        else {
                            if(value > charts[k].maxValue)
                                charts[k].maxValue = value;
                            if(value < charts[k].minValue)
                                charts[k].minValue = value;
                        }
                        if(value < 0)
                            charts[k].hasNegativeNumbers = true;
                        obj = {};
                        obj1 = {};
                        obj = valueList[i];
                        temp = JSON.stringify(obj);
                        obj1 = JSON.parse(temp);
                        obj1.locValue = value;
                        obj1.locValueStr = value;
                        obj1.value = dpValue1[charts[k].field];
                        obj1.valueStr = obj1.value;
                        if(charts[k].isEnum) {
                            obj1.locValueStr = valueStr;
                        }

                        charts[k].data.unshift(obj1);
                    }
                    
                }
                for(k=0; k < charts.length; k++)
                {
                    
                    if(charts[k].data.length > ivChartTotalEntriesLargeChart) {
                        i = valueList.length + 10; //done
                        break;
                    }
                }
            }
            
        }
        for(k=0; k < charts.length; k++)
        {
            charts[k].endPtr = charts[k].data.length - 1;
            charts[k].dataCurrentEntries = charts[k].data.length;
            charts[k].startTimestamp = charts[k].data[0].timestamp;
            charts[k].endTimestamp = charts[k].data[charts[k].data.length - 1].timestamp;
            g_chartList.push(charts[k]);
        }
    }
    catch {}
}
function createChartObjectLargeChartLine(mode, index, displayId, pathname, pathnameUI, field, valueList) {
    // multiline field support
    // mode: 0= current end date, 1= has end date
    // create one chart entry per datapoint field
    try {
        var fvalue, fvalue1;
        var chart = {};
        var polygoncolor, show = true, display = true;
        var lineNumber = 0, lineName, value, valuestr = "";
        var obj, obj1;
        var i, iCount = 0, z = -1;
        var color;
        var ptr,lineObj;
        var temp, bAddToChartData = true;
        if(valueList == null)
            return;
        if(valueList.length == null)
            return;
        
        chart = {};
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathname = pathname;
        chart.pathnameUI = pathnameUI;
        chart.field = field;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.paused = false;
        chart.data = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = false; //dataLogDpList[index].hasNegativeNumbers; 
        chart.show = true; // controlled by chart.display and g_iDatalogChartLineSelectedYaxis
        chart.display = true; // controlled by checkbox
        chart.yAxis = 1;
        
        color = "blue";
        lineName = "";
        chart.creatChartLine = false;
        for(i=0; i < g_chartLineList.length; i ++) 
        {
            if((g_chartLineList[i].pathname == pathname) && (g_chartLineList[i].field == field)){
                lineName = g_chartLineList[i].lineName;
                color = g_chartLineList[i].color;
                show = g_chartLineList[i].show; // legend checkbox
                display = show;
                z = i;
                break;
            }
        }
        if(z == -1) {
            lineNumber = g_chartLineList.length + 1;
            lineName = "polyline" + lineNumber;
            if(lineNumber != 1)  { // line number 1 is there by default
                // may need to add code to check if line is already created
                ivChartLineColorsIndex ++;
                if(ivChartLineColorsIndex >= ivChartLineColors.length)
                    ivChartLineColorsIndex = 0;
                color = ivChartLineColors[ivChartLineColorsIndex];
                chart.creatChartLine = true; //ivCreateNewPolyline(displayId, lineName, color, 5);
            }
            lineObj = {};
            lineObj.lineName = lineName;
            lineObj.color = color;
            lineObj.pathname = pathname;
            lineObj.field = field;
            lineObj.show = true;  // legend checkbox
            g_chartLineList.push(lineObj);  // not sure this is needed
            z = g_chartLineList.length - 1;
        }
        chart.lineColorIndex = z;
        chart.lineName = lineName; //"polyline" + lineNumber;
        chart.color = color;
        chart.show = show;
        chart.display = display; //checkbox
        chart.isEnum = false;
        chart.isBoolean = false;
        //chart.fields = [];
        if(valueList != null) {
            ptr = valueList.length;
            if(typeof valueList[0].value === "string") {
                // make sure no spaces, if spaces then not an enum
                if(valueList[0].value.indexOf(" ") != -1)
                    return; // not an enum
                else    
                    chart.isEnum = true;
            }
            else if(typeof valueList[0].value === "boolean") {
                // make sure no spaces, if spaces then not an enum
                    chart.isBoolean = true;
            }
            for(i=0; i < valueList.length; i++)
            {
                ptr --;
                bAddToChartData = true;
                valuestr = "";
                value = valueList[i].value;
                if(chart.isEnum) {
                    valuestr = value;
                    value = determineEnumValue(value);
                }
                else if(chart.isBoolean) {
                    valuestr = value;
                    if(value)
                        value = 1;
                    else 
                        value = 0;
                }
                // only add to chart.data if value is different from previous value, if same value then change timestamp - this will greatly reduce number of datapoints to chart
                if(i > 2) {
                    //if(valueList[ptr].value == chart.data[chart.data.length - 1].value) {
                    if(value == chart.data[0].value) {  //data is added to beginning of que so use data index 0
                        if(value == chart.data[1].value) {  //used to show start and end times of group of updates with same value
                            chart.data[0].timestamp = valueList[i].timestamp; // don't use
                            bAddToChartData = false;
                        }
                    }
                }
                if(bAddToChartData) {
                    if(i==0) {
                        chart.maxValue = value;
                        chart.minValue = value;
                    }
                    else {
                        if(value > chart.maxValue)
                            chart.maxValue = value;
                        if(value < chart.minValue)
                            chart.minValue = value;
                    }
                    if(value < 0)
                        chart.hasNegativeNumbers = true;
                    iCount ++;
                    obj = {};
                    obj1 = {};
                    obj = valueList[i];
                    temp = JSON.stringify(obj);
                    obj1 = JSON.parse(temp);
                    if(valueStr != "")
                        obj1.enum = valueStr;
                    chart.data.unshift(obj1);
                }
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i])));
                if(iCount > ivChartTotalEntriesLargeChart)
                    break;
            }
            //if(mode == 0)
                //chart.data.push(JSON.parse(Json.stringify(valueList[ptr -  i]))); // repeat last line 
        }
        
        chart.endPtr = chart.data.length - 1;
        chart.dataCurrentEntries = chart.data.length;
        chart.startTimestamp = chart.data[0].timestamp;
        chart.endTimestamp = chart.data[chart.data.length - 1].timestamp;
        g_chartList.push(chart);
        
    }
    catch {}
}
function datalogChartAddEventListener(displayId) {
    var svgObj, svgDoc;
    g_datalogDisplayId = displayId;
    if(navigator.userAgent.match(/Chrome/))	
    {		
        svgObj = document.getElementById(displayId);
        svgDoc = svgObj.contentDocument;
    }
    else
        svgDoc = document.getElementById(displayId).getSVGDocument();
    g_datalogSvgDoc = svgDoc;
    
    //svgDoc.addEventListener("mousemove",dataLogChartMouseMove); // when using mouse down can't use mousemove and doubleclick
    //svgDoc.addEventListener("dblclick",dataLogChartMouseDoubleClick);  // to zoom all the way out
    svgDoc.addEventListener("mousedown",dataLogChartMouseDown);
    svgDoc.addEventListener("mouseup",dataLogChartMouseUp);
    
   // svgDoc.addEventListener("mouseout",dataLogChartMouseOut);
    
    //svgChartRectangle.addEventListener("mousemove",dataLogChartMouseMove);
    //g_datalogSvgDoc = svgChartRectangle;
}
function datalogChartDisplayValue(eClientX, eClientY) {
    // Need to add enums zzzzzzzzzz
    var svgObj, svgDoc, svgChartRectangle;
    var str = "", value;
    var d, time, dates, timestamp = 0;
    var chartList = [];
    var startPtr; //= g_chartList[0].startPtr;
    var endPtr; //= g_chartList[0].endPtr;
    var startTimestampMicroSec; //= g_chartList[0].data[startPtr].timestamp;
    var endTimestampMicroSec; //= g_chartList[0].data[endPtr].timestamp;
    var xRange; //= endTimestampMicroSec - startTimestampMicroSec; // MicroSec
    var range, rangeY2; //= g_chartList[0].maxValue - g_chartList[0].minValue;
    var min, max, minY2, maxY2;

    if(g_bDatalogChartZoomInProgress) {
        if(g_zoomChartList == null) 
            return;
        if(g_zoomChartList.length == 0)
            return; 
        chartList = g_zoomChartList;
        if(g_iDatalogChartLineSelectedYaxis != 2) {
            min = g_datalogChartInfo.zoomMinValue;
            max = g_datalogChartInfo.zoomMaxValue;
            
        }
        if((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) {
            minY2 = g_datalogChartInfo.zoomMinValue2nd;
            maxY2 = g_datalogChartInfo.zoomMaxValue2nd;
        }
        startTimestampMicroSec = g_datalogChartInfo.zoomStartTimestamp; //chartList[0].data[startPtr].timestamp;
        endTimestampMicroSec = g_datalogChartInfo.zoomEndTimestamp;//chartList[0].data[endPtr].timestamp;
    }
    else {
        if(g_chartList == null) 
            return;
        if(g_chartList.length == 0)
            return;
        chartList = g_chartList;
        if(g_iDatalogChartLineSelectedYaxis != 2) {
            min = g_datalogChartInfo.minValue;
            max = g_datalogChartInfo.maxValue;
           
        }
        if((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) {
            minY2 = g_datalogChartInfo.minValue2nd;
            maxY2 = g_datalogChartInfo.maxValue2nd;
            
        }
        startTimestampMicroSec = g_datalogChartInfo.startTimestamp;
        endTimestampMicroSec = g_datalogChartInfo.endTimestamp;
    }
    
    xRange = endTimestampMicroSec - startTimestampMicroSec; // MicroSec

    if(navigator.userAgent.match(/Chrome/))	
    {		
        svgObj = document.getElementById(g_datalogDisplayId);
        svgDoc = svgObj.contentDocument;
    }
    else
        svgDoc = document.getElementById(g_datalogDisplayId).getSVGDocument();
    svgChartRectangle = svgDoc.getElementById("rect1");
    //svgP = svgPoint(svgChartRectangle, e.clientX, e.clientY);
    svgP = svgPoint(svgChartRectangle, eClientX, eClientY);
    if(svgP != null) {
        if((svgP.x >= 0) && (svgP.y >= 0)) {
            //str = "Display [" + e.clientX + ", " + e.clientY + "] = SVG Coordinates [" + svgP.x + ", " + svgP.y + "], value";
            if(g_iDatalogChartLineSelectedYaxis != 2) {
                if((min != null) && (max != null)) {
                    range = max - min;
                    value = (svgP.x / ivChartYLengthLargeChart) * range;
                    value += min;
                    str += "[";
                    if(minY2 != null)
                        str += "Y1: ";
                    if(min > 10)
                        str += value.toFixed(0);
                    else if(max > 50)
                        str += value.toFixed(0);
                    else if(max >= 1)
                        str += value.toFixed(1);
                    else if(min > 1)
                        str += value.toFixed(1);
                    else
                        str += value;
                }
            }
            if((g_iDatalogChartLineSelectedYaxis == 2) || (g_iDatalogChartLineSelectedYaxis == 3)) {
                if((minY2 != null) && (maxY2 != null)) {
                    min = minY2;
                    max = maxY2;
                    rangeY2 = maxY2 - minY2;
                    value = (svgP.x / ivChartYLengthLargeChart) * rangeY2;
                    value += min;
                    if(str == "")
                        str += "[";
                    else 
                        str += ", Y2: ";
                    if(min > 10)
                        str += value.toFixed(0);
                    else if(max > 50)
                        str += value.toFixed(0);
                    else if(max >= 1)
                        str += value.toFixed(1);
                    else if(min > 1)
                        str += value.toFixed(1);
                    else
                        str += value;
                }
            }
            str += ", ";
            
            timestamp = (svgP.y / ivChartXLengthLargeChart) * xRange;
            timestamp += startTimestampMicroSec;
            d = new Date();
            d.setTime(timestamp);
            time = d.toLocaleTimeString();
            //dates = d.toLocaleDateString().split("/");
            
            //str += dates[2] + "-" +  ivPadStart(dates[0], "0", 2) + "-" +  ivPadStart(dates[1], "0", 2) + " " + time + "]";
            str += d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0) + " " + time + "]";
            document.getElementById("mouseInfoLabel").innerHTML = str;   
            //svgDoc.getElementById("tspanX4").textContent = str; // + "   " + lineInfo;
        }
    }
}
function datalogChartDisplayValue1() {
    g_mouseClickTimerVar = null;
    datalogChartDisplayValue(g_datalogChartInfo.mouseDownX1, g_datalogChartInfo.mouseDownY1);
    g_datalogChartInfo.mouseDownX1 = null;
    g_datalogChartInfo.mouseDownY1 = null;
}
function dataLogChartMouseMove(e) {
    //if(!g_bMouseDown)
    //    datalogChartDisplayValue(e.clientX, e.clientY);
}
function dataLogChartMouseDown(e) {
    g_datalogChartInfo.mouseDownX1 = e.clientX; // window coordinates used for zoom start of window
    g_datalogChartInfo.mouseDownY1 = e.clientY;
    g_bMouseDown = true;
}
function dataLogChartMouseUp(e) {
    if((g_datalogChartInfo.mouseDownX1 == null) || (g_datalogChartInfo.mouseDownY1 == null))
        return;
    g_bMouseDown = false;
    if((Math.abs(e.clientX - g_datalogChartInfo.mouseDownX1) < 10) && (Math.abs(e.clientY - g_datalogChartInfo.mouseDownY1) < 10)) {
        if(g_mouseClickTimerVar != null) {
            // doubleclick
            clearTimeout(g_mouseClickTimerVar);
            g_mouseClickTimerVar = null;
            g_bDatalogChartZoomInProgress = false;
            g_bMouseDown = false;
            g_datalogChartInfo.mouseDownX1 = null;
            g_datalogChartInfo.mouseDownY1 = null;
            g_datalogChartInfo.zoomMinValue = null;
            g_datalogChartInfo.zoomMaxValue = null;
            g_datalogChartInfo.zoomMinValue2nd = null; //yAxis2
            g_datalogChartInfo.zoomMaxValue2nd = null; //yaxis2
            g_datalogChartInfo.zoomStartTimestamp = null;
            g_datalogChartInfo.zoomEndTimestamp = null;
            //document.getElementById("mouseInfoLabel").innerHTML = "";
            _chartZoomDoubleClickIntialize();
            //datalogChartUpdate(1); // browser chart
        }
        else // maybe single click or doubleclick -- single click go to function below.
            g_mouseClickTimerVar = setTimeout(function() {datalogChartDisplayValue1()}, 500);
        
    }
    else {
        g_datalogChartInfo.mouseDownX2 = e.clientX; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY2 = e.clientY;
        //datalogChartZoomIntialize();  // brower data log
        chartZoomIntialize(1);
        
        
    }
}
function dataLogChartMouseOut(e) {
    g_datalogChartInfo.mouseDownX1 = null;
    g_datalogChartInfo.mouseDownY1 = null;
    g_bMouseDown = false;
}
function dataLogChartMouseDoubleClick(e) {
    g_bDatalogChartZoomInProgress = false;
    g_bMouseDown = false;
    g_datalogChartInfo.mouseDownX1 = null;
    g_datalogChartInfo.mouseDownY1 = null;
    ivInitializeChart("dataLogChartSvg", g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue, null, null, "white", null, "both");
	ivUpdateChartsDatalog(g_datalogChartInfo.displayId, "", g_iDatalogChartLineType, 0, g_chartList, null, g_datalogChartInfo.minValue, g_datalogChartInfo.maxValue,
        g_datalogChartInfo.startTimestamp, g_datalogChartInfo.endTimeStamp);
}
function datalogChartZoomIntialize() {
    try {
        var chartList = [];
        var min = 0, max = 0, bSetMinMax = true, startTimestamp, endTimestamp, i, z, fvalue, startIndex = -1, endIndex = -1, show, xRange, str = "", k;
        var  pathname = "", field = "";
        var x1 = g_datalogChartInfo.mouseDownX1; // window coordinates used for zoom start of window
        var y1 = g_datalogChartInfo.mouseDownY1;
        var x2 = g_datalogChartInfo.mouseDownX2; // window coordinates used for zoom start of window
        var y2 = g_datalogChartInfo.mouseDownY2;
        var svgPstart, svgPend, newStartTime, newEndTime, startLocalTime, endLocalTime;

        g_datalogChartInfo.mouseDownX1 = null; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY1 = null;
        g_datalogChartInfo.mouseDownX2 = null; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY2 = null;
        g_datalogChartInfo.zoomDatapointsOnY1 = 0; // zzzzzzzz add y1 and y2 count, add count  chart.yAxis
        g_datalogChartInfo.zoomDatapointsOnY2 = 0;  // datapoint value must be between 0 and 1.
        g_datalogChartInfo.zoomDatapointsWithEnum = 0; 

        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(g_datalogDisplayId);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(g_datalogDisplayId).getSVGDocument();
        svgChartRectangle = svgDoc.getElementById("rect1");
        //svgP = svgPoint(svgChartRectangle, e.clientX, e.clientY);
        svgPstart = svgPoint(svgChartRectangle, x1, y1); // zoom window
        svgPend = svgPoint(svgChartRectangle, x2, y2);

        // convert new times to location, later convert to timestamps
        if(svgPstart.y < svgPend.y) {
            // left to right
            newStartTime = svgPstart.y; // y is horizontal and x is vertical
            newEndTime = svgPend.y;
        }
        else {
            // right to left
            newStartTime = svgPend.y;
            newEndTime = svgPstart.y;
        }

        // determine current min max values  zoom window
        if(g_bDatalogChartZoomInProgress) {
            // this is a zoom of a zoom
            chartList = JSON.parse(JSON.stringify(g_zoomChartList));
            min = g_datalogChartInfo.zoomMinValue;
            max = g_datalogChartInfo.zoomMaxValue
            startTimestamp = g_datalogChartInfo.zoomStartTimestamp;
            endTimestamp = g_datalogChartInfo.zoomEndTimestamp;
            
        }
        else {
            chartList = JSON.parse(JSON.stringify(g_chartList));
            
            min = g_datalogChartInfo.minValue;
            max = g_datalogChartInfo.maxValue
            startTimestamp = g_datalogChartInfo.startTimestamp;
            endTimestamp = g_datalogChartInfo.endTimestamp;
        }
        // convert new times to timestamps
        var xRange = endTimestamp - startTimestamp; // MicroSec
        newStartTime = (newStartTime / ivChartXLengthLargeChart) * xRange;
        newStartTime += startTimestamp;
        newEndTime = (newEndTime / ivChartXLengthLargeChart) * xRange;
        newEndTime += startTimestamp;

        d = new Date();
        d.setTime(startTimestamp);
        str = d.toLocaleTimeString() + " " + d.toLocaleDateString();
        d.setTime(endTimestamp);
        str += " thru " + d.toLocaleTimeString() + " " + d.toLocaleDateString() + " ";
        d.setTime(newStartTime);
        startLocalTime = d.toLocaleTimeString() + " " + d.toLocaleDateString();
        d.setTime(newEndTime);
        endLocalTime = d.toLocaleTimeString() + " " + d.toLocaleDateString();
        document.getElementById("mouseInfoLabel").innerHTML = "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";
        //document.getElementById("mouseInfoLabel").innerHTML = str + "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";
        //svgDoc.getElementById("tspanX4").textContent = str + "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";

        g_zoomChartList = [];
        // currently only care about timestamps, add zoom on min max later
        for(k=0; k < chartList.length; k++) 
        {
            if(chartList[k].data.length > 0) {
                startIndex = -1;
                endIndex = -1;
                g_zoomChartList[k] = {};
                g_zoomChartList[k].data = [];
                g_zoomChartList[k].creatChartLine = false;
                g_zoomChartList[k].show = false;
                g_zoomChartList[k].startPtr = -1;
                g_zoomChartList[k].endPtr = -1;
                g_zoomChartList[k].dataCurrentEntries = 0;
                pathname = chartList[k].pathname;
                field = chartList[k].field;
                g_zoomChartList[k].pathname = pathname;
                g_zoomChartList[k].field = field;
                g_zoomChartList[k].isEnum = chartList[k].isEnum;
                g_zoomChartList[k].isBoolean = chartList[k].isBoolean;
                // determine linename
                z = -1;
                for(i=0; i < g_chartLineList.length; i ++) 
                {
                    if((g_chartLineList[i].pathname == pathname) && (g_chartLineList[i].field == field)){
                        g_zoomChartList[k].lineName = g_chartLineList[i].lineName;
                        g_zoomChartList[k].color = g_chartLineList[i].color;
                        g_zoomChartList[k].show = g_chartLineList[i].show;
                        z = i;
                        break;
                    }
                }
                show = false; // true if in zoom window
                if(z == -1) {
                    //bug this shouldn't happen
                }
                for(i=0; i < chartList[k].data.length; i ++)
                {
                    if(chartList[k].data[i].timestamp >= newStartTime) {
                        startIndex = i;
                        break;
                    }
                }
                if(startIndex != -1) {
                    for(i=startIndex; i < chartList[k].data.length; i ++)
                    {
                        if(chartList[k].data[i].timestamp >= newEndTime) {
                            if(chartList[k].data[i].timestamp > newEndTime)
                                endIndex = i - 1;
                            else 
                                endIndex = i;
                            break;
                        }
                    }
                    if(endIndex > -1) {
                        show = true;
                        
                        if(chartList[k].data[startIndex].timestamp > newStartTime) {
                            if(startIndex > 0) {
                                g_zoomChartList[k].data.unshift(chartList[k].data[startIndex - 1]);
                                g_zoomChartList[k].data[0].timestamp = newStartTime;
                            }
                        }
                        for(i=startIndex; i <= endIndex; i ++)
                        {
                            g_zoomChartList[k].data.push(chartList[k].data[i]);
                        }
                        if(chartList[k].data[endIndex].timestamp < newEndTime){
                            if((endIndex + 1) < chartList[k].data.length) {
                                g_zoomChartList[k].data.push(chartList[k].data[endIndex + 1]);
                                g_zoomChartList[k].data[g_zoomChartList[k].data.length - 1].timestamp = newEndTime;
                            }
                        }
                        // determine new min and max for datapoint during this zoom window
                        min = g_zoomChartList[k].data[0].value;
                        max = min;
                        
                        for(i=0; i < g_zoomChartList[k].data.length; i ++)
                        {
                            fvalue = g_zoomChartList[k].data[i].value;
                            if(fvalue > max)
                                max = fvalue;
                            if(fvalue < min)
                                min = fvalue;
                        }
                        g_zoomChartList[k].startPtr = 0;
                        g_zoomChartList[k].endPtr = g_zoomChartList[k].data.length - 1;
                        g_zoomChartList[k].dataCurrentEntries = g_zoomChartList[k].data.length;
                        g_zoomChartList[k].startTimestamp = g_zoomChartList[k].data[0].timestamp;
                        g_zoomChartList[k].endTimestamp = g_zoomChartList[k].data[ g_zoomChartList[k].endPtr].timestamp;
                        g_zoomChartList[k].minValue = min;
                        g_zoomChartList[k].maxValue = max;
                        if(chartList[k].yAxis == 1)
                            g_datalogChartInfo.zoomDatapointsOnY1 ++; 
                        else 
                            g_datalogChartInfo.zoomDatapointsOnY2 ++;

                        if(chartList[k].isEnum) 
                            g_datalogChartInfo.zoomDatapointsWithEnum ++;
                    
                    }
                    if(show && g_zoomChartList[k].show)
                        g_zoomChartList[k].show = true;
                    else
                        g_zoomChartList[k].show = false;
                }
            }
        }
        /*
        g_datalogChartInfo.zoomMinValue = min;
        g_datalogChartInfo.zoomMaxValue = max;
        g_datalogChartInfo.zoomMinValue2 = null; //yAxis2
        g_datalogChartInfo.zoomMaxValue2 = null; //yaxis2
        g_datalogChartInfo.zoomStartTimestamp = newStartTime;
        g_datalogChartInfo.zoomEndTimestamp = newEndTime;
        */
        datalogChartZoomIn();
    }
    catch {}
}
function datalogChartZoomIn() {
    g_bDatalogChartZoomInProgress = true;
    datalogChartUpdate(1);
}
function determineEnumValue (str) {
    try {
        var result = 0;
        var i;
        var str1, obj, bContinue = true, decrementValue = .1, z = -1;
        if(str == "")
            return 0.4;
        str1 = str.toLowerCase();
        for(i=0; i < g_enumsList.length; i++)
        {
            if(str1 == g_enumsList[i].name)
                return g_enumsList[i].value;
        }
        obj = {};
        obj.name = str1;
        if(str1 == "on") {
            obj.value = 1;
            bContinue = false;
        }
        else if(str1.indexOf("on") > 0) {
            obj.value = .9;

        } 
        else if(str1 == "off") {
            obj.value = .1;
            bContinue = false;
        }
        else if(str1.indexOf("off") > 0) {
            obj.value = .2;

        } 
        else if(str1 == "mid") {
            obj.value = .5;
            bContinue = false;
        }
        else if(str1.indexOf("mid") > 0) {
            obj.value = .5;

        } 
        else if(str1 == "auto") {
            obj.value = .6;
            bContinue = false;
        }
        else if(str1.indexOf("auto") > 0) {
            obj.value = .6;

        } 
        
        while(bContinue) 
        {
            g_enumsListNewValue -= decrementValue;
            if(g_enumsListNewValue <= .1) 
                g_enumsListNewValue = .9;
                
            
            if((g_enumsListNewValue == 1) || (g_enumsListNewValue == .9) || (g_enumsListNewValue == .6) || (g_enumsListNewValue == .5) || (g_enumsListNewValue == .1)) {
                
                // reserved values
            }
            else {
                z = -1;
                for(i=0; i < g_enumsList.length; i++)
                {
                    if(g_enumsListNewValue == g_enumsList[i].value) {
                        z = i;
                        break;
                    }
                }
                if(z == -1) {
                    obj.value = g_enumsListNewValue;
                    break;
                }
            }
        }
        g_enumsList.push(ob);
        result = obj.value;
    }
    catch {result = .4;}
    return result;
}
function svgPoint(element, x, y) {
    // translate page to SVG co-ordinates
    if(g_datalogSvgDoc == null) 
        return null;
     //   var pt = g_datalogSvgDoc.createSVGPoint();
    var pt = g_datalogSvgDoc.documentElement.createSVGPoint();
    pt.x = x;
    pt.y = y;
    return pt.matrixTransform(element.getScreenCTM().inverse());

}
/************************************************************************************************
* Chart Code for device log and navtree log node
* 
*/
function timerHandlerDeviceChart() {
    // used only once
    var i;
    
    try {
        if(g_iMainDisplayMode === DISPLAYMODE_DASHBOARD) {
            // mode: 1= timer    
            initializeSvgDevicelogChart(); 
            /*
            for(i=0; i <  g_chartListLogs.length; i++)
            {
                
                if(g_chartListLogs[i].iDynamicRangeCount > 0) {
                    g_chartListLogs[i].iDynamicRangeCount --;
                    if(g_chartListLogs[i].iDynamicRangeCount === 1) {
                        deviceLogDetermineChartMinMaxValuesForChart(0, i, null, true);
                        g_chartListLogs[i].iDynamicRangeCount = 0;
                    }
                }
                
                deviceLogUpdateCharts(i, null, null);
            }
            */
        }
    }
    catch (err) {}
    
}
function addChartUi(mode, devicename, timespan, start,end) {
    // this is for the navtree device logs and navtree log node
    // mode: 0=log node, 1=device log
    try {
        var d, t, t1 = 1, iPtr, n, wsUrl = "/iap/ws?";
        var element = document.getElementById("planningPaneDetails_Details");
        var offsets = element.getBoundingClientRect(); 
        var x = offsets.x + window.pageXOffset; // takes into account viewport (scrolling)
        var y = offsets.y + window.pageYOffset; // takes into account viewport (scrolling)
        g_chartListLogs = []; // device data logs
        element = document.getElementById("scheduleDiv");
        if(element != null) {
            menuOverlayDivShow(6, null);
            element.className = "showScheduleDiv";
            element.style.left = x.toString() + "px";
            element.style.top = y.toString() + "px";
            element.innerHTML = "<br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting data logs ....</span>";
            //enhancements change wsUrl for device or specific datapoint
                    
            d = new Date();
            if(timespan !== null)
            d.setTime(d.getTime() - timespan); // 10 min

            wsUrl += "dev=%2A%2Bname==" + encodeNameStr(devicename);
            wsUrl += "&value="
            n = d.toISOString();
            n = n.substr(0, n.length - 1);
            if(n !== "") {
                n = n.replace(/:/g,"%3A")
                wsUrl += "%2A%2Butc%3E" + n;
            }
            g_bDeviceDataLogGetInProgress = true;
            g_sDeviceDataLogDeviceName = devicename;
            createDataLogClientWebSocketConnection(0, wsUrl);
        }
    }
    catch {}
}
function addLogChart(displayId, index, displayElementIndex, label, shortPathname, pathname, field, fieldList, defaultField, value, presetValue,bAddDeviceName) {
    // for device log and navtree log node charts
    //pathname is programmaticPathname
    // alarmWarningLevel: 0=no alarm, otherwise low error, low warning, high warning and high error
    var iPtr, i;
    var content = '<div class="group"   style="float:left;display:inline-block;margin-left:10px;margin-top:10px">';
    
	content += '<div  style="float:left;display:inline-block">';
    content += '<div style="margin-left: 50px">';
    content += "<button id=\"dpValueMenu_" + displayId + "\" style=\"float:right;display:block;margin-right:30px\" onclick=\"_chartMenu(1,this,'" + pathname +  "','" + label +  "'," + index + ")\">...</button>";
    content += '<span id=\"chartvalue_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + value + '</span>';
    content += '<span id=\"chartpreset_' + displayId + '\" style=\"float:right;display:block;margin-right:30px\">' + presetValue + '</span>';
   
	content += '</div>';
    content += '<div id="chartParentDiv_' + displayId + '" style="clear:both; display:block; margin-top:30px; text-align:center; z-index: 5; ">';
    content += '<object id="chartSvg_' + displayId + '" type="image/svg+xml" style="height: 170px;" data-izot-textcolor="' + g_chartTextColor + '" data="images/navtree/' + g_sDashboardUseNewChartname + '"></object>';
    content += '</div>';

    
    content += "<div id=\"datapointName_" + displayId + "\" style=\"display:flex;";
    content += "\">";
   
    
	content += '<span style="margin-left: 10px">';
    if(bAddDeviceName) {
        if(label === "")
            content += shortPathname;
        else
            content += label + " [" + shortPathname + "]";
    }
    else {
        iPtr = shortPathname.indexOf("/")
        if(iPtr !== -1) {
            if((iPtr + 1) < shortPathname.length) {
                if(label === "")
                    content += shortPathname.substr(iPtr + 1);
                else
                    content += label + " [" + shortPathname.substr(iPtr + 1) + "]";
            }
        }
    }
    content += '</span>';
    content += "</div><br>";
    content += "<div id=\"datapointfield_" + displayId + "\" style=\"display:flex;";
    content += "\">";
    if(fieldList.length > 0) 
        content += "Field: ";
    content += "<select id=\"datapointfieldselect_" + displayId + "\" ";
    if(fieldList.length === 0) 
        content += " style=\"visibility:hidden\"";
    else
        content += " onchange=\"deviceLogChangeField(" + index + ",'" + displayId + "','datapointfieldselect_" + displayId + "')\"";
    content += ">";
    if(field === "") {
        defaultField = defaultField.toLowerCase();
        for(i=0; i < fieldList.length; i++)
        {
            content += '<option value=\"' + fieldList[i] + '\""';
            if(defaultField !== "") {
                if(defaultField === fieldList[i].toLowerCase())
                    content+= ' selected';
            }
            content += '>'+ fieldList[i] + '</option>';
        }
    }
    content += '</select>';
    
    content += '</div>';
    content += '<br>';
	content += '</div>';
    content += '</div>';
    return content;
}
function createDeviceLogChartObject(index, displayId, pathname, field, value, min, max, hasDynmaicRange, linecolor, chartLabels) {
    try {
        var fvalue, fvalue1, value1;
        var chart = {}, minmaxObj, obj;
        var d, i, j, z;
        var polygoncolor;
        var type, snvtType = null;
        var iDetermineMinMax = -1, bContinue;
        
        if(index >= g_chartListLogs.length)
            return;
        if(g_chartListLogs[index].displayId !== displayId)
            return;
        chart.dpIndex = index;
        chart.paused = false;
        chart.startPtr = 0;
        chart.endPtr = 0;
        chart.pathname = pathname;
        chart.dashboardDpIndex = index;
        chart.displayId = displayId;
        chart.displayId1 = "chartSvg_" + displayId; // used for mouse
        chart.data = [];
        chart.dataCurrentEntries = 1; //iottest
        chart.hasNegativeNumbers = false; 
        chart.bMinMaxEqual = true;
        chart.iDynamicRangeCount = ivChartTotalEntries + 2;
        chart.bString = false;
        chart.bEnum = false;
        if(g_bDashboardSupportLogData)
            chart.iDynamicRangeCount = 2;

        chart.creatChartLine = true;
        chart.lineName = "line1"
        chart.color = "blue";
        
        /*
        type = dashboardDpList[index].dashboardType;
        if (type === "t")
            chart.color = "darkred";
        else if (type === "l")
            chart.color = "green";
        */           
        chart.show = true;
        chart.chartLabels = "both";

        chart.bPolygon = !g_bDashboardChartDynamicRange;
        chart.startTimestamp = null; //time in milli seconds
        chart.endTimestamp = null; //time in milli seconds
        if(g_bDashboardSupportLogData) {
            bDetermineMinMax = true;
            if(typeof g_chartListLogs[index].datalogData !== "undefined") {
                if(g_chartListLogs[index].datalogData.length > 0) {
                    if(field === "")
                        chart.data = JSON.parse(JSON.stringify(g_chartListLogs[index].datalogData));
                    else {
                        for(i=0; i < g_chartListLogs[index].datalogData.length; i++)
                        {
                            obj = {};
                            obj = JSON.parse(JSON.stringify(g_chartListLogs[index].datalogData[i]));
                            value1 = readFieldValue(obj.value, field);
                            if(value1.valid) 
                                obj.value = value1.data;
                            chart.data.push(obj);
                        }
                    }
                    if(!chart.bString && !chart.bEnum) {
                        // check if data is string or null
                        if(typeof g_chartListLogs[index].snvtType !== "undefined") {
                            if(g_chartListLogs[index].snvtType !== null) {
                                snvtType = g_chartListLogs[index].snvtType;
                                if(snvtType !== null) {
                                    if(field !== "") {
                                        snvtType = readSnvtTypeFieldValue(snvtType, field);
                                        if(snvtType.valid) {
                                            snvtType = snvtType.data;
                                            if(snvtType.type === "enum") {
                                                chart.bEnum = true;
                                                chart.enums = JSON.parse(JSON.stringify(snvtType.enum)); // enum[0].id and enum[0].value
                                            }
                                            else if(snvtType.type === "string") {
                                                chart.bString = true;
                                                chart.strings = [];
                                            }
                                        }
                                    }
                                    else {
                                        if(snvtType.valueType === "ENUM") {
                                            chart.bEnum = true;
                                            chart.enums = JSON.parse(JSON.stringify(snvtType.typeJson.enum)); // enum[0].id and enum[0].value
                                        }
                                        else if(snvtType.valueType === "STRING") {
                                            chart.bString = true;
                                            chart.strings = [];
                                        }
                                    }
                                }
                                
                            }
                        }
                    }
                }
            }
            if(value !== null) {
                obj = {};
                obj.value = value;
                obj.presetValue = "";
                
                d = new Date();
                obj.timestamp = d.getTime();
                chart.data.push(obj);
            } 
            if(chart.bEnum || chart.bString) {
                chartLabels = "x";
                // convert strings and enums
                for(i=0; i < chart.data.length; i++)
                {
                    if(chart.bEnum) {
                        value = chart.data[i].value;
                        z = -1;
                        for(j=0; j < chart.enums.length; j++) {
                            if(value === chart.enums[j].id) {
                                z = j;
                                break;
                            }
                        }
                        chart.data[i].str = value;
                        if(z !== -1) {
                            value = chart.enums[z].value;
                            chart.data[i].value = value;
                        }
                        else {
                            obj = {};
                            obj.str = value;
                            value1 = 1;
                            if(typeof value === "number") {
                                // check if value matches other values
                                // pick new value to show
                                value1 = value;
                                while(bContinue)
                                {
                                    bContinue = false;
                                    for(j=0; j < chart.enums.length; j++)
                                    {
                                        if(value1 === chart.enums[j].value) {
                                            value1 ++;
                                            bContinue = true;
                                        }
                                    }
                                }
                            }
                            // check if value matches other values
                            obj.value = value1;
                            chart.enums.push(obj);
                            value = obj.value;
                            chart.data[i].value = value;
                        }
                    }
                    else if(chart.bString) {
                        value = chart.data[i].value;
                        z = -1;
                        for(j=0; j < chart.strings.length; j++) {
                            if(value === chart.strings[j].str) {
                                z = j;
                                break;
                            }
                        }
                        chart.data[i].str = value;
                        if(z !== -1) {
                            value = chart.strings[z].value;
                            chart.data[i].value = value;
                        }
                        else {
                            obj = {};
                            obj.str = value;
                            obj.value = chart.strings.length;
                            chart.strings.push(obj);
                            value = obj.value;
                            chart.data[i].value = value;
                        }
                    }
                }
            }
            iDetermineMinMax = 3;
            
            chart.endPtr = chart.data.length - 1;
            chart.dataCurrentEntries = chart.data.length;
            if(chart.data.length > 0) {
                chart.startTimestamp = chart.data[0].timestamp; //time in milli seconds
                chart.endTimestamp = chart.data[chart.data.length - 1].timestamp; //time in milli seconds
            }
        }
        else {

            chart.data[0] = {};
            chart.data[0].value = value;
            chart.data[0].timestamp = null;
            if(typeof value === "string")
                value = Number(value);
            if(value < 0)
                chart.hasNegativeNumbers = true; 

            if(g_bDashboardChartDynamicRange) {
                iDetermineMinMax = 2;
                
            }   
            else { 
                if(max === null) {
                    fvalue = parseFloat(value);
                    if(g_bDashboardMinMaxUsePadding) {
                        if(fvalue < 0) 
                            fvalue1 = 0;
                        else if(fvalue < 1) 
                            fvalue1 = 1;
                        else if(fvalue < 5)
                            fvalue1 = 5;
                        else if(fvalue > 1) 
                            fvalue1 = (Math.round(fvalue / 10) + 1) * 10;
                    }
                    max = fvalue1;
                }
                if(min === null) {
                    fvalue = parseFloat(value);
                    if(g_bDashboardMinMaxUsePadding) {
                        if(fvalue < 0) 
                        fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                        else if(fvalue < 1) 
                            fvalue1 = 0;
                        else if(fvalue < 5)
                            fvalue1 = 0;
                        else if(fvalue > 1) 
                            fvalue1 = (Math.round(fvalue / 10) - 1) * 10;
                    }
                    min = fvalue1;
                }
                chart.maxValue = max;
                chart.minValue = min;
                if(min === max)
                    chart.bMinMaxEqual = true;
                else
                    chart.bMinMaxEqual = false;
            }
        }
        
        chart.dynamicRange = hasDynmaicRange;
        chart.chartLabels = chartLabels;
        if(linecolor === null) {
            linecolor = "blue";
        }
        polygoncolor = "light" + linecolor;
        chart.lineColor = linecolor;
        chart.polygoncolor = polygoncolor;
        g_chartListLogs[index].chartObj = chart;
        if(iDetermineMinMax !== -1) {
            if((iDetermineMinMax === 0) || (iDetermineMinMax === 3))
                value = null;
            else
                value = parseFloat(value);
            minmaxObj =  deviceLogDetermineChartMinMaxValuesForChart(iDetermineMinMax, index, value, true);
        }
    }
    catch {}
}
function deviceLogDetermineChartMinMaxValuesForChart(mode, index, value, bSaveChanges) {
    // mode: 0= check all, 1= compare last, 2= initial value so use value, 3=same as 0 but init chart
    var results = {};
    var bNoChanged = true;
    var bUpdateChart = true
    var min, max, value, i, fvalue1;
    var bChange = false;
    var index, maxDecimalPlaces = 3;
    results.min = value;
    results.max = value;
	try {
        if(mode === 3) {
            bUpdateChart = false;
            mode = 0;
        }
		
		if((mode === 2) || ((mode === 1) && (index <  g_chartListLogs.length)) || (mode === 0 && ( g_chartListLogs[index].chartObj.data !== null))) {
            if(mode === 0) {
                for(i=0; i < g_chartListLogs[index].chartObj.data.length; i ++)
                {
                    if(i === 0) {
                        
                        min = g_chartListLogs[index].chartObj.data[i].value;
                        max = min;
                    }
                    else {
                        value = g_chartListLogs[index].chartObj.data[i].value;
                        if(value < min)
                            min = value;
                        if (value > max)
                            max = value;
                    }
                }
                if(min === max) {
                    g_chartListLogs[index].chartObj.bMinMaxEqual = true;
                    max = Math.round((max * 10) + 1) / 10;
                    min = Math.ceil((min * 10) - 1) / 10;
                }
                else 
                    g_chartListLogs[index].chartObj.bMinMaxEqual = false;
                bChange = true;
            }
            else if (mode === 1) {
                bNoChange = true;
                max =  g_chartListLogs[index].chartObj.maxValue;
                min =  g_chartListLogs[index].chartObj.minValue;
                if(g_chartListLogs[index].chartObj.bMinMaxEqual) {
                    lastIndex =  g_chartListLogs[index].chartObj.data.length - 1;
                    if(lastIndex > 0) {
                        if(g_chartListLogs[index].chartObj.data[lastIndex - 1].value !== g_chartListLogs[index].chartObj.data[lastIndex].value) {
                            max = g_chartListLogs[index].chartObjdata[lastIndex - 1].value;
                            min = max;
                            g_chartListLogs[index].chartObj.bMinMaxEqual = false;
                            bNoChanged = false;
                        }
                    }
                }
                if(value >= max){
                    max = value;
                    bNoChanged = false;
                }
                if(value <= min){
                    min = value;
                    bNoChanged = false;
                }
                if(bNoChanged)
                    return results;
            }
            else {
                g_chartListLogs[index].chartObj.bMinMaxEqual = true;
                min = max = value;
                max = Math.round((max * 10) + 1) / 10;
                min = Math.ceil((min * 10) - 1) / 10;
            }
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(max) > 100)
                    fvalue1 = (Math.round(max / 10) + 1) * 10;
                else if(Math.abs(max) > 1)
                    fvalue1 = Math.ceil(max + 1);
                else 
                    fvalue1 = Math.ceil((max * 10) + 1) / 10;
            }
            else
                fvalue1 = max;
            if(g_bDashboardMinMaxDecimalPlaces) {
                maxDecimalPlaces = -1;
                if(Math.abs(min) > 2)
                    maxDecimalPlaces = g_iDashboardDecimalPlaces;
                fvalue1 = numToFixedLength(fvalue1, 8, maxDecimalPlaces, true)
            }
            if(mode < 2) {
                if(g_chartListLogs[index].chartObj.maxValue !== fvalue1) {
                    if(bSaveChanges)
                        g_chartListLogs[index].chartObj.maxValue = fvalue1;
                    bChange = true;
                    
                }
            }
            results.max = fvalue1;
            if(g_bDashboardMinMaxUsePadding) {
                if(Math.abs(min) > 100)
                    fvalue1 = (Math.round(min / 10) - 1) * 10;
                else if(Math.abs(min) > 1)
                    fvalue1 = Math.ceil(min - 1);
                else 
                    fvalue1 = Math.ceil((min * 10) - 1) / 10;
            }
            else
                fvalue1 = min;
            if(g_bDashboardMinMaxDecimalPlaces) {
                
                fvalue1 = numToFixedLength(fvalue1, 8, maxDecimalPlaces, false)
            }
            if(mode < 2) {
                if(g_chartListLogs[index].chartObj.minValue !== fvalue1) {
                    if(bSaveChanges)
                        g_chartListLogs[index].chartObj.minValue = fvalue1;
                    bChange = true;
                }
            }
            results.min = fvalue1;
            if(bChange) {
                if(g_chartListLogs[index].chartObj.dynamicRange) {
                    g_chartListLogs[index].chartObj.iDynamicRangeCount = ivChartTotalEntries + 2;
                }
            }
            if(mode  < 2) {
                if(bChange && bUpdateChart && !g_bdashboardChartPause && !g_dashboardChartList[index].paused && bSaveChanges) {
                    try {
                        ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_chartListLogs[index].chartObj.displayId, g_chartListLogs[index].chartObj.minValue, g_chartListLogs[index].chartObj.maxValue, null, null, null, null, g_chartListLogs[index].chartObj.chartLabels);
                        
                    } catch (err) {}
                }
            }
			
		}
	}
    catch {}
    return results;
}
function initializeSvgDevicelogChart() {
    try {
        var i, j;
        var fValue, fValue1;
        var value;
        var chartIndex;
        var type;
        var obj;
        for(i=0; i < g_chartListLogs.length; i ++)
        {
            try {
                chartIndex = i;
                ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_chartListLogs[i].chartObj.displayId, g_chartListLogs[i].chartObj.minValue, g_chartListLogs[i].chartObj.maxValue, null, null, g_chartTextColor, null, g_chartListLogs[i].chartObj.chartLabels);
                deviceLogMouseEventsAddToChart("chartSvg_" + g_chartListLogs[i].chartObj.displayId, "chartParentDiv_" + g_chartListLogs[i].chartObj.pathname, chartIndex);
                deviceLogUpdateCharts(i, null, null);
                //deviceLogUpdateCharts(i, g_chartListLogs[i].locValue, null);
                
            }
            catch {}
        }
    }
    catch {}
}
function deviceLogUpdateCharts(chartIndex, value, timestamp) {
    if(g_bDashboardNeedToInitializeSvg)
        return;
    if(g_bDashboardSupportLogData && g_bDashboardUseNewChart) {
        //ffix change to using dynmic timestamp charting
        //ivUpdateCharts(chartIndex, value, null);
        var chartObj = g_chartListLogs[chartIndex].chartObj;
        var chartObjList = [];
        var temp = 1;
        var sExtraStr = "";  //used to specify duration
        chartObjList.push(chartObj);
        //ivUpdateChartsDatalog(chartObj.displayId, sExtraStr, g_idashboardChartType, chartIndex, g_dashboardChartList, null,chartObj.minValue, chartObj.maxValue, chartObj.startTimestamp, chartObj.endTimestamp);
        ivUpdateChartsDatalogChart3TwoYaxis("chartSvg_" + chartObj.displayId, sExtraStr, g_idashboardChartType, 0, chartObjList,  null,chartObj.minValue, chartObj.maxValue, null, null, 
            chartObj.startTimestamp, chartObj.endTimestamp, giDashboardChartLineWidth, true, "both");
        
    }
    else
        ivUpdateCharts(chartIndex, value, null);
}
function deviceLogMouseEventsAddToChart(displayId, parentDivId, chartIndex) {
    // SVG must be in a parent DIV by itself
    var meterObj;
    var meterSvgDoc;
    if(navigator.userAgent.match(/Chrome/))	
    {		
      meterObj = document.getElementById(displayId);
      meterSvgDoc = meterObj.contentDocument;
    }
    else
    meterSvgDoc = document.getElementById(displayId).getSVGDocument();
    
    meterSvgDoc.getElementById("rect1").chartIndex = chartIndex;
    meterSvgDoc.getElementById("rect1").parentDivId = parentDivId;
      
    meterSvgDoc.getElementById("rect1").addEventListener("mousemove",deviceLogMousemove);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseenter",deviceLogMouseenter);
    meterSvgDoc.getElementById("rect1").addEventListener("mouseout",deviceLogMouseout);
}
function deviceLogMouseenter(e) {
    if(g_bDashboardDisplayMouseToolTip) {
        deviceLogMousemove(e);
    }
    e.preventDefault();
}
function deviceLogMousemove(e) {
    //chartIndex: z0=zoomchart
    try {
        var mode = 0;
        var parentDivId, chartIndex;
        if(g_bDashboardDisplayMouseToolTip) {
            parentDivId = e.target.parentDivId;
            chartIndex = e.target.chartIndex;
            if(chartIndex === "z0")
				mode = 1; // ffixmouse
                dashboardMousePositionChartDisplayValue(4, chartIndex, parentDivId, e.clientX, e.clientY);
        }
        e.preventDefault();
    }
catch (err) {}
}
function deviceLogMouseout(e) {
    try {
        if(g_bDashboardDisplayMouseToolTip) {
            var svgObj, svgDoc;
            var tooltip, displayId = "zoomChartSvg";
            var chartIndex = e.target.chartIndex;
            if(g_chartListLogs == null) 
                return "";
            if(g_chartListLogs.length == 0)
                return "";
            if(chartIndex >= g_chartListLogs.length)
                return;
            if(chartIndex !== "z0")
                displayId = g_chartListLogs[chartIndex].chartObj.displayId1;
            if(navigator.userAgent.match(/Chrome/))	
            {		
                svgObj = document.getElementById(displayId);
                svgDoc = svgObj.contentDocument;
            }
            else
                svgDoc = document.getElementById(displayId).getSVGDocument();
            tooltip = svgDoc.getElementById("tooltip");
            if(tooltip !== null) 
                tooltip.setAttributeNS(null, "visibility", "hidden");
        }
        e.preventDefault();
    }
    catch {}
}
function deviceLogChangeField(index, displayId, fieldDisplayId) {
    try {
        var element = document.getElementById(fieldDisplayId);
        var field = "";
        if(element !== null) {
            field = element.value;
            if(g_chartListLogs == null) 
                return "";
            if(g_chartListLogs.length == 0)
                return "";
            if(index >= g_chartListLogs.length)
                return;
            if(g_chartListLogs[index].displayId = displayId) {  
                g_chartListLogs[index].field = field;
                createDeviceLogChartObject(index, g_chartListLogs[index].displayId, g_chartListLogs[index].pathname, field, null, null, null, true, null, "both");
                ivInitializeChart1(g_bDashboardSupportLogData, "chartSvg_" + g_chartListLogs[index].chartObj.displayId, g_chartListLogs[index].chartObj.minValue, g_chartListLogs[index].chartObj.maxValue, null, null, g_chartTextColor, null, g_chartListLogs[index].chartObj.chartLabels);
                deviceLogUpdateCharts(index, null, null);
            }
        }
    }
    catch {}
}
function devicelogGetLogs(devicename) {
    var d, d0, d1, d3, n, wsUrl = "/iap/ws?",element, timespan, sTemp, sTemp1, bContinue = false;
    g_sDeviceDataLogDeviceName = devicename;

    try {
        element = document.getElementById("deviceLogChartsDiv");
        if(element != null) {
            
            element.innerHTML = "<br><span id=\"gettingInfoId\" class=\"gettingInfo\">Getting data logs ....</span>";
            //enhancements change wsUrl for device or specific datapoint
            wsUrl += "dev=%2A%2Bname==" + encodeNameStr(devicename);
            wsUrl += "&value="
            element = document.getElementById("devicelograngecheckbox");
            if(element !== null) {
                if(element.checked) {
                    g_bDeviceLogRangeCheckbox = true;
                    sTemp = document.getElementById("zoomstartdate").value;
                    if(sTemp !== "") {
                        sTemp1 = document.getElementById("zoomstarttime").value;
                        if(sTemp1 !== "") {
                            d =  new Date(sTemp + " " + sTemp1);
                            n = d.toISOString();
                            n = n.substr(0, n.length - 1);
                            if(n !== "") {
                                n = n.replace(/:/g,"%3A")
                                wsUrl += "%2A%2Butc%3E" + n;
                            }
                            else {
                                alert("Error: invalid starttime")
                                return;
                            }
                            sTemp = document.getElementById("zoomenddate").value;
                            if(sTemp !== "") {
                                sTemp1 = document.getElementById("zoomendtime").value;
                                if(sTemp1 !== "") {
                                    d =  new Date(sTemp + " " + sTemp1);
                                    n = d.toISOString();
                                    n = n.substr(0, n.length - 1);
                                    if(n !== "") {
                                        n = n.replace(/:/g,"%3A")
                                        wsUrl += "%26utc%3C%3D" + n;
                                        bContinue = true;
                                    }
                                    else {
                                        alert("Error: invalid endtime")
                                        return;
                                    }
                                }
                            }
                        } 
                    }
                    if(!bContinue) {
                        alert("Error: invalid datse or times")
                        return;
                    }
            
                }
                else {
                    g_bDeviceLogRangeCheckbox = false;
                    d = new Date();
                    g_sDeviceLogRangeType = document.getElementById("deviceloglogrange").value;
                    if(g_sDeviceLogRangeType === "today") {
                        d1 = new Date(d.getFullYear(), d.getMonth(), d.getDate(), 0, 0, 0, 0);
                        n = d1.toISOString();
                        n = n.substr(0, n.length - 1);
                        if(n !== "") {
                            n = n.replace(/:/g,"%3A")
                            wsUrl += "%2A%2Butc%3E" + n;
                        }
                        else {
                            alert("Error: invalid starttime")
                            return;
                        }
                        

                    }
                    else if(g_sDeviceLogRangeType === "yesterday") {

                        d1 = new Date(d.getFullYear(), d.getMonth(), d.getDate(), 0, 0, 0, 0);
                        d3 = d1.getTime() - (24 * 60 * 60 * 1000);
                        d0 = new Date(d3);
                        n = d0.toISOString();
                        n = n.substr(0, n.length - 1);
                        if(n !== "") {
                            n = n.replace(/:/g,"%3A")
                            wsUrl += "%2A%2Butc%3E" + n;
                        }
                        else {
                            alert("Error: invalid starttime")
                            return;
                        }
                        n = d1.toISOString();
                        n = n.substr(0, n.length - 1);
                        if(n !== "") {
                            n = n.replace(/:/g,"%3A")
                            wsUrl += "%26utc%3C%3D" + n;
                        }
                        else {
                            alert("Error: invalid endtime")
                            return;
                        }
                    }
                    else {
                        if(g_sDeviceLogRangeType === "last 10 min")
                            timespan = 10 * 60 * 1000;
                        else if(g_sDeviceLogRangeType === "last 4 hours")
                            timespan = 4 * 60 * 60 * 1000;
                        else if(g_sDeviceLogRangeType === "last hour")
                            timespan = 60 * 60 * 1000;
                        else {
                            alert("Not Supported")
                            return;
                        }
                        d = new Date();
                        if(timespan !== null)
                        d.setTime(d.getTime() - timespan); // 10 min
        
                        
                        n = d.toISOString();
                        n = n.substr(0, n.length - 1);
                        if(n !== "") {
                            n = n.replace(/:/g,"%3A")
                            wsUrl += "%2A%2Butc%3E" + n;
                        }
                        else {
                            alert("Error: invalid endtime")
                            return;
                        }
                    }
                    

                    
                }
                g_chartListLogs = []; // device data logs
                g_bDeviceDataLogGetInProgress = true;
                g_sDeviceDataLogDeviceName = devicename;
                createDataLogClientWebSocketConnection(1, wsUrl);
            }
        }
    }
    catch {}

}
function devicelograngechanged() {
    try {
        var element = document.getElementById("devicelograngecheckbox")
        if(element !== null) {
            if(element.checked) {
              g_bDeviceLogRangeCheckbox = true;
              document.getElementById("zoomchartstartend").style.display = "inline-block";
              document.getElementById("zoomchartlast").style.display = "none";
            }
            else {
                g_bDeviceLogRangeCheckbox = false;
                document.getElementById("zoomchartstartend").style.display = "none";
                document.getElementById("zoomchartlast").style.display = "inline-block";
            }
        }
    }
    catch {}
}
function chartZoomIntialize(mode) {
    //mode: 3=browser data log chart, 1= dashboard or devicelog chart
    try {
        var chartList = [];
        var index;
        var iSearchMode = 0; //0=look for starting log entry, 1=look for ending log entry, 2 = done
        var min = 0, max = 0,  bSetMinMax = true, startTimestamp, endTimestamp, b, b1, i, k, m, z, fvalue, startIndex = -1, endIndex = -1, show, xRange, str = "";
        var  pathname = "", field = "", element;
        var x1 = g_datalogChartInfo.mouseDownX1; // window coordinates used for zoom start of window
        var y1 = g_datalogChartInfo.mouseDownY1;
        var x2 = g_datalogChartInfo.mouseDownX2; // window coordinates used for zoom start of window
        var y2 = g_datalogChartInfo.mouseDownY2;
        var svgPstart, svgPend, newStartTime, newEndTime, startLocalTime, endLocalTime;

        g_datalogChartInfo.mouseDownX1 = null; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY1 = null;
        g_datalogChartInfo.mouseDownX2 = null; // window coordinates used for zoom start of window
        g_datalogChartInfo.mouseDownY2 = null;
        g_datalogChartInfo.zoomDatapointsOnY1 = 0; // zzzzzzzz add y1 and y2 count, add count  chart.yAxis
        g_datalogChartInfo.zoomDatapointsOnY2 = 0;  // datapoint value must be between 0 and 1.
        g_datalogChartInfo.zoomDatapointsWithEnum = 0; 

        if(navigator.userAgent.match(/Chrome/))	
        {		
            svgObj = document.getElementById(g_datalogDisplayId);
            svgDoc = svgObj.contentDocument;
        }
        else
            svgDoc = document.getElementById(g_datalogDisplayId).getSVGDocument();
        svgChartRectangle = svgDoc.getElementById("rect1");
        //svgP = svgPoint(svgChartRectangle, e.clientX, e.clientY);
        svgPstart = svgPoint(svgChartRectangle, x1, y1); // zoom window
        svgPend = svgPoint(svgChartRectangle, x2, y2);

        // convert new times to location, later convert to timestamps
        if(svgPstart.y < svgPend.y) {
            // left to right
            newStartTime = svgPstart.y; // y is horizontal and x is vertical
            newEndTime = svgPend.y;
        }
        else {
            // right to left
            newStartTime = svgPend.y;
            newEndTime = svgPstart.y;
        }

        
        // determine current min max values  zoom window
        if(mode === 1) {
            min =  g_zoomDashboardChartList[1].minValue;
            max =  g_zoomDashboardChartList[1].maxValue
            startTimestamp = g_zoomDashboardChartList[1].data[0].timestamp;
            endTimestamp = g_zoomDashboardChartList[1].data[g_zoomDashboardChartList[1].data.length - 1].timestamp;
        }
        else if((mode === 3) && (g_bDatalogChartZoomInProgress)) {
            // this is a zoom of a zoom
            chartList = JSON.parse(JSON.stringify(g_zoomChartList));
            min = g_datalogChartInfo.zoomMinValue;
            max = g_datalogChartInfo.zoomMaxValue
            startTimestamp = g_datalogChartInfo.zoomStartTimestamp;
            endTimestamp = g_datalogChartInfo.zoomEndTimestamp;
            
        }
        else if(mode === 3) {
            
            chartList = JSON.parse(JSON.stringify(g_chartList));
            min = g_datalogChartInfo.minValue;
            max = g_datalogChartInfo.maxValue
            startTimestamp = g_datalogChartInfo.startTimestamp;
            endTimestamp = g_datalogChartInfo.endTimestamp;

            
       }
        // convert new times to timestamps
        if(mode === 1) {
            xRange = endTimestamp - startTimestamp; // MicroSec
            newStartTime = (newStartTime / ivChartXLengthLargeChart9) * xRange;
            newStartTime += startTimestamp;
            newEndTime = (newEndTime / ivChartXLengthLargeChart9) * xRange;
            newEndTime += startTimestamp;
        }
        else {
            xRange = endTimestamp - startTimestamp; // MicroSec
            newStartTime = (newStartTime / ivChartXLengthLargeChart) * xRange;
            newStartTime += startTimestamp;
            newEndTime = (newEndTime / ivChartXLengthLargeChart) * xRange;
            newEndTime += startTimestamp;
        }

        
        
        //document.getElementById("mouseInfoLabel").innerHTML = str + "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";
        //svgDoc.getElementById("tspanX4").textContent = str + "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";
        if(mode === 1) {
            if(g_zoomDashboardChartList.length === 2) {
                g_zoomDashboardChartList[0].data = [];
                
                
                // create subset of original data
                for(k=0; k < g_zoomDashboardChartList[1].data.length; k++) 
                {
                    if(iSearchMode === 0) {
                        if(g_zoomDashboardChartList[1].data[k].timestamp == newStartTime) {
                            g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k - 1])));
                            g_zoomDashboardChartList[0].data[0].timestamp = newStartTime;
                            iSearchMode = 1;
                            if(g_zoomDashboardChartList[1].data.length === 1) {
                                max = g_zoomDashboardChartList[0].data[0].value;
                                min = max;
                            }
                        }
                        else if(g_zoomDashboardChartList[1].data[k].timestamp >= newStartTime) {
                            if(g_zoomDashboardChartList[1].data[k].timestamp < newEndTime) {
                                if(k > 0) {
                                    
                                    g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k - 1])));
                                    g_zoomDashboardChartList[0].data[0].timestamp = newStartTime;
                                    if(g_idashboardChartType === 0) { //0=trend, 1=stepline
                                        m = (g_zoomDashboardChartList[1].data[k].value - g_zoomDashboardChartList[1].data[k - 1].value) / (g_zoomDashboardChartList[1].data[k].timestamp - g_zoomDashboardChartList[1].data[k - 1].timestamp);
                                        b = g_zoomDashboardChartList[1].data[k].value - (m * g_zoomDashboardChartList[1].data[k].timestamp);
                                        g_zoomDashboardChartList[0].data[0].value = (m * newStartTime) + b;
                                            // fix decimal places
                                        if(!Number.isInteger(g_zoomDashboardChartList[0].data[0].value)) {
                                            z = (g_zoomDashboardChartList[1].data[k].value - g_zoomDashboardChartList[1].data[k - 1].value);
                                            if(Math.abs(z) > 0) {
                                                // limit to 2 decimal places
                                                g_zoomDashboardChartList[0].data[0].value = parseFloat((g_zoomDashboardChartList[0].data[0].value + 0.005).toFixed(2));
                                            }
                                            else if(g_zoomDashboardChartList[1].data[k].value === g_zoomDashboardChartList[1].data[k - 1].value) {
                                                // same value
                                            }
                                            else {
                                                b = g_zoomDashboardChartList[1].data[k].value.toString().split(".")[1].length || 0;
                                                b1 = g_zoomDashboardChartList[1].data[k - 1].value.toString().split(".")[1].length || 0;
                                                if(b === b1) {
                                                    b1 = (g_zoomDashboardChartList[1].data[k] - g_zoomDashboardChartList[1].data[k - 1].value).toString().split(".")[1].length || 0;
                                                    m = 1;
                                                    for(i=0; i < m; i)
                                                    { m /= 10;}
                                                    if(m < b1)
                                                       b = b + 1;
                                                }
                                                else if(b < b1)
                                                    b = b1;
                                                g_zoomDashboardChartList[0].data[0].value = parseFloat(g_zoomDashboardChartList[0].data[0].value.toFixed(b));
                                            }
                                        }
                                    }
                                    max = g_zoomDashboardChartList[0].data[0].value;
                                    min = max;
                                    
                                }
                                g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k])));
                                iSearchMode = 1;
                                if(g_zoomDashboardChartList[1].data.length === 1) {
                                    max = g_zoomDashboardChartList[0].data[0].value;
                                    min = max;
                                }
                                else {
                                    fvalue = g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value;
                                    if(fvalue > max)
                                        max = fvalue;
                                    if(fvalue < min)
                                        min = fvalue;
                                }
                            }
                            else { // point is after both start and end time so need to calculate points
                                
                                if(k > 0) {
                                    g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k - 1])));
                                    g_zoomDashboardChartList[0].data[0].timestamp = newStartTime;
                                    g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k])));
                                    g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].timestamp = newEndTime;
                                    if(g_zoomDashboardChartList[1].data[k].value === g_zoomDashboardChartList[1].data[k - 1].value) {
                                        // same value
                                        max = g_zoomDashboardChartList[0].data[0].value;
                                        min = max;
                                        max = Math.round((max * 10) + 1) / 10;
                                        min = Math.ceil((min * 10) - 1) / 10;
                                    }
                                    else if(g_idashboardChartType === 0) { //0=trend, 1=stepline
                                        m = (g_zoomDashboardChartList[1].data[k].value - g_zoomDashboardChartList[1].data[k - 1].value) / (g_zoomDashboardChartList[1].data[k].timestamp - g_zoomDashboardChartList[1].data[k - 1].timestamp);
                                        b = g_zoomDashboardChartList[1].data[k].value - (m * g_zoomDashboardChartList[1].data[k].timestamp);
                                        g_zoomDashboardChartList[0].data[0].value = (m * newStartTime) + b;
                                            // fix decimal places
                                        if(!Number.isInteger(g_zoomDashboardChartList[0].data[0].value)) {
                                            z = (g_zoomDashboardChartList[1].data[k].value - g_zoomDashboardChartList[1].data[k - 1].value);
                                            if(Math.abs(z) > 0) {
                                                // limit to 2 decimal places
                                                g_zoomDashboardChartList[0].data[0].value = parseFloat((g_zoomDashboardChartList[0].data[0].value + 0.005).toFixed(2));
                                            }
                                            else {
                                                b = g_zoomDashboardChartList[1].data[k].value.toString().split(".")[1].length || 0;
                                                b1 = g_zoomDashboardChartList[1].data[k - 1].value.toString().split(".")[1].length || 0;
                                                if(b === b1) {
                                                    b1 = (g_zoomDashboardChartList[1].data[k] - g_zoomDashboardChartList[1].data[k - 1].value).toString().split(".")[1].length || 0;
                                                    m = 1;
                                                    for(i=0; i < m; i)
                                                    { m /= 10;}
                                                    if(m < b1)
                                                       b = b + 1;
                                                }
                                                else if(b < b1)
                                                    b = b1;
                                                g_zoomDashboardChartList[0].data[0].value = parseFloat(g_zoomDashboardChartList[0].data[0].value.toFixed(b));
                                                g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value = parseFloat(g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value.toFixed(b));
                                            }
                                        }
                                        max = g_zoomDashboardChartList[0].data[0].value;
                                        min = max;
                                        fvalue = g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value;
                                        if(fvalue > max)
                                            max = fvalue;
                                        if(fvalue < min)
                                            min = fvalue;
                                    }
                                   
                                    
                                    iSearchMode = 2;
                                    break;
                                    
                                    
                                }
                                else {
                                    // no points in zoom window
                                    iSearchMode = 2;
                                    break;
                                }

                            }
                        }
                    }
                    else if(iSearchMode === 1) {
                        if(g_zoomDashboardChartList[1].data[k].timestamp === newEndTime) {
                            g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k])));
                            fvalue = g_zoomDashboardChartList[1].data[k].value;
                            if(fvalue > max)
                                max = fvalue;
                            if(fvalue < min)
                                min = fvalue;
                            iSearchMode = 2;
                            break;
                        }
                        else if(g_zoomDashboardChartList[1].data[k].timestamp > newEndTime) {
                            g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k])));
                            g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].timestamp = newEndTime;
                            if(g_idashboardChartType === 0) { //0=trend, 1=stepline
                                m = (g_zoomDashboardChartList[1].data[k].value - g_zoomDashboardChartList[1].data[k - 1].value) / (g_zoomDashboardChartList[1].data[k].timestamp - g_zoomDashboardChartList[1].data[k - 1].timestamp);
                                b = g_zoomDashboardChartList[1].data[k].value - (m * g_zoomDashboardChartList[1].data[k].timestamp);
                                g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value = (m * newEndTime) + b;
                                if(!Number.isInteger(g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value)) {
                                    z = (g_zoomDashboardChartList[1].data[k].value - g_zoomDashboardChartList[1].data[k - 1].value);
                                    if(Math.abs(z) > 0) {
                                        // limit to 2 decimal places
                                        g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value = parseFloat((g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value + 0.005).toFixed(2));
                                    }
                                    else if(g_zoomDashboardChartList[1].data[k].value === g_zoomDashboardChartList[1].data[k - 1].value) {
                                        // same value
                                    }
                                    else {
                                        // different value so use line formula y = mx + b to determine zoom window value
                                        b = g_zoomDashboardChartList[1].data[k].value.toString().split(".")[1].length || 0;
                                        b1 = g_zoomDashboardChartList[1].data[k - 1].value.toString().split(".")[1].length || 0;
                                        if(b === b1) {
                                            b1 = (g_zoomDashboardChartList[1].data[k] - g_zoomDashboardChartList[1].data[k - 1].value).toString().split(".")[1].length || 0;
                                            m = 1;
                                            for(i=0; i < m; i)
                                            { m /= 10;}
                                            if(m < b1)
                                                b = b + 1;
                                        }
                                        else if(b < b1)
                                            b = b1;
                                        g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value = parseFloat(g_zoomDashboardChartList[0].data[g_zoomDashboardChartList[0].data.length - 1].value.toFixed(b));
                                    }
                                }
                            }
                            fvalue = g_zoomDashboardChartList[1].data[k].value;
                            if(fvalue > max)
                                max = fvalue;
                            if(fvalue < min)
                                min = fvalue;
                            iSearchMode = 2;
                            break;
                        }
                        else {
                            g_zoomDashboardChartList[0].data.push(JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data[k])));
                            fvalue = g_zoomDashboardChartList[1].data[k].value;
                            if(fvalue > max)
                                max = fvalue;
                            if(fvalue < min)
                                min = fvalue;
                        }
                    }
                   
                }
            }
            index = 0;
            g_zoomDashboardChartList[index].minValue = min;
            g_zoomDashboardChartList[index].maxValue = max;
            g_zoomDashboardChartList[index].startPtr = 0;
            g_zoomDashboardChartList[index].endPtr = g_zoomDashboardChartList[index].data.length - 1;
            g_zoomDashboardChartList[index].dataCurrentEntries = g_zoomDashboardChartList[index].data.length;
            g_zoomDashboardChartList[index].startTimestamp = g_zoomDashboardChartList[index].data[0].timestamp;
            g_zoomDashboardChartList[index].endTimestamp = g_zoomDashboardChartList[index].data[ g_zoomDashboardChartList[index].endPtr].timestamp;
            

            ivInitializeChart1(true, g_zoomDashboardChartList[index].displayId, g_zoomDashboardChartList[index].minValue, g_zoomDashboardChartList[index].maxValue, null, null, "black", g_zoomFontSize, g_zoomDashboardChartList[index].chartLabels);
            _dashboardUpdateCharts1(1, null);
            element = document.getElementById("zoomValue");
            if(element !== null) {
                if(g_zoomDashboardChartList[index].bEnum || g_zoomDashboardChartList[index].bString)
                    element.innerHTML = g_zoomDashboardChartList[index].data[g_zoomDashboardChartList[index].data.length - 1].str;
                else 
                    element.innerHTML = g_zoomDashboardChartList[index].data[g_zoomDashboardChartList[index].data.length - 1].value;
            }

            _dashboardUpdateCharts1(2, null);


        }
        else if (mode === 3) {
            d = new Date();
            d.setTime(startTimestamp);
            str = d.toLocaleTimeString() + " " + d.toLocaleDateString();
            d.setTime(endTimestamp);
            str += " thru " + d.toLocaleTimeString() + " " + d.toLocaleDateString() + " ";
            d.setTime(newStartTime);
            startLocalTime = d.toLocaleTimeString() + " " + d.toLocaleDateString();
            d.setTime(newEndTime);
            endLocalTime = d.toLocaleTimeString() + " " + d.toLocaleDateString();
            document.getElementById("mouseInfoLabel").innerHTML = "[zoom window: " + startLocalTime + " - " + endLocalTime + "]";
            g_zoomChartList = [];
            // currently only care about timestamps, add zoom on min max later
            for(k=0; k < chartList.length; k++) 
            {
                if(chartList[k].data.length > 0) {
                    startIndex = -1;
                    endIndex = -1;
                    g_zoomChartList[k] = {};
                    g_zoomChartList[k].data = [];
                    g_zoomChartList[k].creatChartLine = false;
                    g_zoomChartList[k].show = false;
                    g_zoomChartList[k].startPtr = -1;
                    g_zoomChartList[k].endPtr = -1;
                    g_zoomChartList[k].dataCurrentEntries = 0;
                    pathname = chartList[k].pathname;
                    field = chartList[k].field;
                    g_zoomChartList[k].pathname = pathname;
                    g_zoomChartList[k].field = field;
                    g_zoomChartList[k].isEnum = chartList[k].isEnum;
                    g_zoomChartList[k].isBoolean = chartList[k].isBoolean;
                    // determine linename
                    z = -1;
                    for(i=0; i < g_chartLineList.length; i ++) 
                    {
                        if((g_chartLineList[i].pathname == pathname) && (g_chartLineList[i].field == field)){
                            g_zoomChartList[k].lineName = g_chartLineList[i].lineName;
                            g_zoomChartList[k].color = g_chartLineList[i].color;
                            g_zoomChartList[k].show = g_chartLineList[i].show;
                            z = i;
                            break;
                        }
                    }
                    show = false; // true if in zoom window
                    if(z == -1) {
                        //bug this shouldn't happen
                    }
                    for(i=0; i < chartList[k].data.length; i ++)
                    {
                        if(chartList[k].data[i].timestamp >= newStartTime) {
                            startIndex = i;
                            break;
                        }
                    }
                    if(startIndex != -1) {
                        for(i=startIndex; i < chartList[k].data.length; i ++)
                        {
                            if(chartList[k].data[i].timestamp >= newEndTime) {
                                if(chartList[k].data[i].timestamp > newEndTime)
                                    endIndex = i - 1;
                                else 
                                    endIndex = i;
                                break;
                            }
                        }
                        if(endIndex > -1) {
                            show = true;
                            
                            if(chartList[k].data[startIndex].timestamp > newStartTime) {
                                if(startIndex > 0) {
                                    g_zoomChartList[k].data.unshift(chartList[k].data[startIndex - 1]);
                                    g_zoomChartList[k].data[0].timestamp = newStartTime;
                                }
                            }
                            for(i=startIndex; i <= endIndex; i ++)
                            {
                                g_zoomChartList[k].data.push(chartList[k].data[i]);
                            }
                            if(chartList[k].data[endIndex].timestamp < newEndTime){
                                if((endIndex + 1) < chartList[k].data.length) {
                                    g_zoomChartList[k].data.push(chartList[k].data[endIndex + 1]);
                                    g_zoomChartList[k].data[g_zoomChartList[k].data.length - 1].timestamp = newEndTime;
                                }
                            }
                            // determine new min and max for datapoint during this zoom window
                            min = g_zoomChartList[k].data[0].value;
                            max = min;
                            
                            for(i=0; i < g_zoomChartList[k].data.length; i ++)
                            {
                                fvalue = g_zoomChartList[k].data[i].value;
                                if(fvalue > max)
                                    max = fvalue;
                                if(fvalue < min)
                                    min = fvalue;
                            }
                            g_zoomChartList[k].startPtr = 0;
                            g_zoomChartList[k].endPtr = g_zoomChartList[k].data.length - 1;
                            g_zoomChartList[k].dataCurrentEntries = g_zoomChartList[k].data.length;
                            g_zoomChartList[k].startTimestamp = g_zoomChartList[k].data[0].timestamp;
                            g_zoomChartList[k].endTimestamp = g_zoomChartList[k].data[ g_zoomChartList[k].endPtr].timestamp;
                            g_zoomChartList[k].minValue = min;
                            g_zoomChartList[k].maxValue = max;
                            if(chartList[k].yAxis == 1)
                                g_datalogChartInfo.zoomDatapointsOnY1 ++; 
                            else 
                                g_datalogChartInfo.zoomDatapointsOnY2 ++;

                            if(chartList[k].isEnum) 
                                g_datalogChartInfo.zoomDatapointsWithEnum ++;
                        
                        }
                        if(show && g_zoomChartList[k].show)
                            g_zoomChartList[k].show = true;
                        else
                            g_zoomChartList[k].show = false;
                    }
                }
            }
            /*
            g_datalogChartInfo.zoomMinValue = min;
            g_datalogChartInfo.zoomMaxValue = max;
            g_datalogChartInfo.zoomMinValue2 = null; //yAxis2
            g_datalogChartInfo.zoomMaxValue2 = null; //yaxis2
            g_datalogChartInfo.zoomStartTimestamp = newStartTime;
            g_datalogChartInfo.zoomEndTimestamp = newEndTime;
            */
            datalogChartZoomIn();
        }
        
        
    }
    catch (err){
        var errStr = err.toString();
    }
}
function _chartZoomDoubleClickIntialize() {
    
    try {
            var index = 0, lastIndex;
            var element;
            g_zoomDashboardChartList[0].data = JSON.parse(JSON.stringify(g_zoomDashboardChartList[1].data));
            g_zoomDashboardChartList[0].minValue = g_zoomDashboardChartList[1].minValue;
            g_zoomDashboardChartList[0].maxValue = g_zoomDashboardChartList[1].maxValue;
            g_zoomDashboardChartList[0].startPtr = g_zoomDashboardChartList[1].startPtr;
            g_zoomDashboardChartList[0].endPtr = g_zoomDashboardChartList[1].endPtr;
            g_zoomDashboardChartList[0].dataCurrentEntries = g_zoomDashboardChartList[1].dataCurrentEntries;
            g_zoomDashboardChartList[0].startTimestamp = g_zoomDashboardChartList[1].startTimestamp;
            g_zoomDashboardChartList[0].endTimestamp = g_zoomDashboardChartList[1].endTimestamp;
            

            ivInitializeChart1(true, g_zoomDashboardChartList[index].displayId, g_zoomDashboardChartList[index].minValue, g_zoomDashboardChartList[index].maxValue, null, null, "black", g_zoomFontSize, g_zoomDashboardChartList[index].chartLabels);
            _dashboardUpdateCharts1(1, null);

            _dashboardUpdateCharts1(2, null);
            element = document.getElementById("zoomValue");
            if(element !== null) {
                lastIndex = g_zoomDashboardChartList[0].data.length - 1;
                if(g_zoomDashboardChartList[0].bEnum || g_zoomDashboardChartList[0].bString)
                    element.innerHTML = g_zoomDashboardChartList[0].data[lastIndex].str;
                else 
                    element.innerHTML = g_zoomDashboardChartList[0].data[lastIndex].value;
            }
    }
    catch {}
}