/********************************************************************
 *  Built-in functions don't change
 *******************************************************************/
function addDeviceTypeWebPage(sid, deviceType, url, width, height) {
    // used for replacement web page shown in iframe
    try {
        if((deviceType === null) || (url === null) || (width === null) || (height === null))
            return;
        var obj = {};
        obj.sid = sid;
        obj.deviceTypeName = deviceType;
        obj.url = url;
        obj.width = width;
        obj.height = height;
        g_deviceTypesReplacementsDeviceType.push(obj);
    }
    catch {}
}
function addProgramIdWebPage(sid, programId, allVersions, url, width, height) {
    // used for replacement web page shown in iframe
    try {
        if((programId === null) || (url === null) || (width === null) || (height === null))
            return;
        var obj = {};
        obj.sid = sid;
        obj.programId = programId;
        obj.allVersions = allVersions
        obj.url = url;
        obj.width = width;
        obj.height = height;
        g_deviceTypesReplacementsProgramId.push(obj);
    }
    catch {}
}
function addDeviceDpList(sid, deviceName, dpList, image, width, height) {
    try {
        addTypeToDeviceTypeDpList(sid, "d", deviceName, dpList, image, width, height);
    }
    catch {}
   
}
function addDeviceTypeProgramIdDpList(sid, programId, dpList, image, width, height) {
    try {
        addTypeToDeviceTypeDpList(sid, "p", programId, dpList, image, width, height);
    }
    catch {}
   
}
function addDeviceTypeDpList(sid, deviceType, dpList, image, width, height) {
    try {
        addTypeToDeviceTypeDpList(sid, "dt", deviceType, dpList, image, width, height);
    }
    catch {}
}
function addTypeToDeviceTypeDpList(sid, type, name, dpList, image, width, height) {
    // type: "dt" = device type, "d" = device name, "p" = program Id
    try {
        var i;
        var obj = {};
        obj.sid = sid;
        obj.type = type
        obj.name = name;
        //obj.deviceTypeName = deviceType;
        obj.image = image;
        obj.width = width;
        obj.height = height;

        obj.dpList = [];
        if(dpList !== null) {
            for(i=0; i < dpList.length; i++){
                if(typeof dpList[i] !== "object")
                    dpList[i] = addDpObj(dpList[i]);
                dpList[i].blockPath = dpList[i].blockPath.trim().toLowerCase();
            }
            obj.dpList = dpList;
        }
        g_deviceTypesReplacementsDpList.push(obj);
    }
    catch {}
}
function addSmartServerImage(sid, image, width, height) {
    g_smartServerImage = image;
    g_smartServerImageWidth = width;
    g_smartServerImageHeight = height;
}
function addDpObj(blockPath) {
    return addDpObjAll(null, blockPath, null, null, null, null, null, null);  
}
function addDpObjAll(sid, blockPath, displayElementType, userVisibility, userReadtonly, normalUserWritePriority,normalUserClearPriority, units) {
    //displayElementType: c=chart, d=dropdown (only if datapoint has presets, enums are automatically "d"), d1=dropdown use dropdownList
    //          s1= slider, s2 = slider switch (binary), s3 = slider switch (SNVT_switch), s4 = slider switch (SNVT_switch 0 0 or 1 100 only), 
    //          l2 = led, l3 = led (SNVT_switch, led for state, span for value), l4 = LED SNVT_switch state only
    var items, i;
    var obj = {}
    obj.sid = sid;
    obj.blockPath = blockPath;
    obj.field = "";
    obj.fieldPath = "";
    obj.units = "";
    if(units !== null)
        obj.units = units;
    items = blockPath.split("/");
    if(items.length > 3) {
        obj.blockPath = items[0].trim(); + "/" + items[1].trim() + "/" + items[2].trim();
        
        for(i=0; i < items.length; i++)
        {
            items[i] = items[i].trim();
            if(i > 3) {
                if(obj.field !== "")
                    obj.field += "/";
                obj.field += items[i];
            }
            if(obj.fieldPath !== "")
                obj.fieldPath += "/";
            obj.fieldPath += items[i];
            
        }
    }
    if(userVisibility === null)
        userVisibility = 0;
    if(userReadtonly === null)
        userReadtonly = 0;
    obj.visibility = userVisibility; // null or 0=all, 1=owner only, 2=owner + supervisor, 3=user only
    obj.userReadonly = userReadtonly; // applies to inputs only, null or 0=writable, 1=user only, 2=user + supervisor, 3=readable only
    obj.dashboardType = displayElementType; 
    obj.UserTypeWritePriority = normalUserWritePriority; // only applies to the user user-type, doesn't apply to owner or supervisor
    obj.userClearPriority = normalUserClearPriority
    obj.dropdownList = [];
    return obj; 
}
function addImageForContext(sid, contextType,contextName,image,imageWidth,imageHeight,location, bLocationAboveImage) {
    // only supports campus and building
    try {
        var obj = {};

        obj.bLocationAboveImage = true;
        if(bLocationAboveImage !== null) {
            if(typeof bLocationAboveImage === "boolean")
                obj.bLocationAboveImage = bLocationAboveImage;
        }
        obj.sid = sid;
        if(contextType !== null) {
            contextType = contextType.toLowerCase();
        }
        if(contextName !== null) {
            contextName = contextName.toLowerCase();
        }
        obj.contextType = contextType
        obj.contextName = contextName;
        //obj.deviceTypeName = deviceType;
        obj.image = image;
        obj.width = imageWidth;
        obj.height = imageHeight;
        obj.location = location;
        g_contextImages.push(obj);
    }
    catch {}
}
