/*
	maindriver.js (version 0.019) - Only use for 3.1
	
	This driver is used for SmartServer 3.1 and shouldn't be used for SmartServer 3.2+ as the REST API has changed for writing datapoints.
	For SmartServer 3.1 the URI used to read and write specific datapoints used XIF names
		/api/devs/0/if/{block name}/{block index}/{datapoint XIF name}
	For SmartServer 3.2 the URI has changed, it now is uses datapoint instance names
		/api/devs/0/if/{block Instance name}/{block index}/{datapoint Instance name}

	# Copyright (C) 2021 Dialog Semiconductor.  All rights reserved.
	#
	# Use of this code is subject to your compliance with the terms of the 
	# Dialog IzoT(tm) Software Developer's Kit License Agreement which is 
	# available at www.dialog-semiconductor.com/license/izot_sdk/. 
	
	This is a generic Web page driver for the SmartServer IoT which can use to create Custom Web pages.  This driver allows datpoint substitution tags to be used in order
	to create a single web page to support mulitple devices of the same device type where only one device is displayed at a time

	This code will first issue GET request to get a list of Devices based on a device type you specify. It uses this device list to create a list of dpQualifiers based on datapoint paths 
	that you specify init1() in the custom js file
		+qualifier=-<list of dp qualifiers>
	
	
	dpQualifiers are based on the datapoint XIF name and not datapoint name.  In the CMS Datapoint Browser Widget it shows the datapoint name.
	if change the Datapoint Browser to show the datapoint details then you will see the XIF datapoint name and dqQualifer.  Your init1() needs to specify each of the 
	datapoints in your Web page using a datapoint path with the following format (with or without substitution tags) 

		   <device name>/<datapoint Block Name>/<datapoint Block Index>/<datapoint XIF name>

	The maindriver.js code will generate the correct dpQualifier for the specified datapoint paths

	URI Tokens:
	A URI token of URI token "device=<device name>", which means only do a GET request for the specific device
	A token of "embedded=true" means remove log out button

	For substitution tags if you specify URI token "deviceName=<device name>" and the {x} substitution tag is used for device name, and the display id = deviceName then
	the Web page will automatically populate for that name

	presets are only supported when the HTML element supports the entire datapoint value (no fields) and g_bPresetsSupported is true

	For "Send" buttons with both input and output datapoint, there are two ways to get input datapoint. Use a "noop" element type or find dpname by substitution name

	GET responses are processed in 
		getDpValueResponse(mode, requestUrlString, json);
	
*/
"use strict";
	// ------------------- user settable variables --------------------
var g_bUseWebSockets = false; // *** Custom Web page #3  *** -- change xyz to your company tagname, and simple to your Web page tag value
var g_bCalculatePollRate = true; // false = use default or manually set, true= calculate g_timerInternal and g_iMax_Age based on 
								// 	number of datapoints and whether there are non max_age and/or max_age periodic polling datapoints
var g_iMax_Age = 2; // value must be 2 or greater 	  
var g_bPeriodicReadOneTimeReads = false; // Not Supported yet. if Web page is expected to be open a long time you may want to periodically read the one times
var g_bAddSendEventToInputElement = false; // automatically adds event listener for Input Elements, write done after pressing enter key
var g_bAddSendEventToFieldInputElement = false; // when changing a datapoint field, you may want to allow all changes before submittin
												// false = user will submit write
												// true = automatically send update with specific datapoint field changed 
var g_sDevice = ""; // Device substitution tag - current device
var g_bTreeView = false;
var g_sDefaultSpanAndInputValue = ""; // if not "" then used to clear old values out of span and inputs when changing device names due substitution tags
var g_iWritePriority = -1;  // -1, don't use priority. 1-17 use write priority at this priority level
var g_iWritePriorityDefault = 17; // -1 don't use, 1-17 used when requestWriteData priority is null 
var g_bUseLocalization = true; // true=always use localization, false=always use non-localization
var g_iFeedbackDelayTime = 10000; // ms 10000 = 10s
var g_bPresetsSupported = true;
var g_bPresetsPopulateInputandDropdowns = true;
var g_bAutoAddPrioritySliderSwitchClickEvent = true;
var g_bShowWriteWariningIfHigherPriorityActive = true;
var g_sPriorityRelinquishPermissions = "all"; // this is used to limit what priority overrides that user can relinquish
var g_bShowRelinquishValue = true; // Relinquish value shows IAP value, but value can be localizaed or presets and so may not match what is shown. 
var g_iPriorityMenuDpNameType = 2; //0=Don't show, 1=full name, 2=block/dpname, 3=dpname
	// ---------------- Program variables --------------------------------
let g_iSmartServerVersion = 0;
var g_bChartsSupported = false;
var g_showSingleDeviceOnly = false;
var g_timerInterval = 1000; // even though polling has a minium of 2 seconds, any chart needs to be updated every second
var g_iMaxOfDpsToPollPerInterval = 10;
var g_bInitializing = true;
var g_sPriorityRelinquishPermissionsString = "";
var g_arrPriorityRelinquishPermissions = [];
var g_sWebpageOneTime = ""; // created at run time";
var g_sWebpageMaxAge = "";// created at run time";
var g_sWebpageMaxAgeOneTime = ""; // created at run time";
var g_arrDpTypeNameList = []; // Used during initialization only: DpTarrays of DP namesarrays  0=normal,1=onetime,2=maxage,3=maxontime
var g_arrTagList = []; // used by timer if available the order is nomaxage,maxage,maxageonetime,nomaxageonetime
var g_iTimerTagListCount = 0;  // The count of Get Array items to count  --al it is upto 4 GET tags, onetime tags are decremented after intial processing
var g_iCurrentTagListPtr = -1;  // Used during Initialization (0-3) g_arrDpTypeNameList and timer (0-1) g_arrTagList
var g_arrJsFunctionList = []; // use for Functions that use 2 or more datapoints, may not be tied to a specific html element
var g_arrDpChangeJsFunctionList = []; // indicates which js Functions to process during this GET request -- at least one DP value changed 
var g_imageList = [];
var g_bNeedToSubscribe = true;
var g_bServerOnline = false;
var g_bAtLeastOneElementUsesPriority = false; //If any priority_span or clearoverride_button then driver periodically needs to read properties instead of just value 
var g_bGetPropertiesRequest = true; //true to get priority array, set false to do GET for values
var g_iBackgroundPollingRequestCount = -1; // time between GET requests
var g_iBackgroundPollingRequestCountMax = 2; // fixed time between GET requests (2 second polling rate)
var g_iBackgroundPollingRequestExtended = 0;
var g_iPollingRequestCount = -1; // controlled by polling checkbox -1=disabled
var g_iPollingRequestCountMax = 2; // UI controlled Polling interval  (e.g., 10 datpoint, polling interval is 30, so g_iPollingRequestCountMax = 30, g_iBackgroundPollingRequestCountMax)
var g_iSlowPollingRequestCount = -1; // controlled by polling checkbox -1=disabled
var g_iSlowPollingRequestCountMax = 2; // UI controlled Polling interval  (e.g., every 1 hour)
var g_dpEnumsList = [];

var g_iAddDisplayElementErrors = 0; //Exception errors while building up g_dpList	
var g_iDpCountNormal = 0;  // g_iMax_Age: -1 or 0, used for all dps; 1 or greater than one used for noMaxAge
var g_iDpCountOneTime = 0;  // read once DPs
var g_iDpCountMaxAge = 0;
var g_iDpCountMaxAgeOneTime = 0;  // read once DPs
//var g_bInitialGetNormal = false;  // g_iMax_Age: -1 or 0, used for all dps; 1 or greater than one used for noMaxAge
var g_iInitialGetNormalOneTime = false;  // read once DPs
var g_bInitialGetMaxAge = false;
var g_bInitialGetMaxAgeOneTime = false;  // read once DPs
var g_bMaxAgeOneTime = false; // max age one time requires initial GET request with max_age=0 and then read values once 10 seconds later
var g_dtMaxAgeOneTimeTimeout; 
var ivMaxPollingRate = 5; // 5 datapoints polled per second
var g_bAddTagToDatapoints = true;
var g_sDeviceType = "";
var g_substitutionList = [];
var g_deviceList = [];
var g_dpList = []; // created by user, due to substitution tags a datapoint may show up once. Once for specific datapoint and one or more due to substitution tags. 
					// stores only one value which can be value or locValue based on g_bUseLocalValue 
var g_dpGetList = [];  // created using g_dpList so datapoint shows up only once, . has both value and locValue
var g_getInitialGetDpList = []; // Initial Get request with all datapoints
var g_getPeriodicGetDpList = []; // 
var g_getSlowPeriodicDpList = []; // used every 1-4 hours
var g_sWebSocketSubscribePayload = "";
var g_sWebSocketSubscribePayload_oldvalue = "";
var g_sOnDemandDpRequestUrl = "";
var g_sInitialGetRequest = "";
var g_dpGetRequestArr = [];
var g_idpGetRequestIndex = -1;
var g_bReadInProgress = 0;  // true for Single GET request if no pagination, true for multiple request if pagination used
var g_iReadInProgressCount = 0; // used if backed up or lost request
var g_iIgnoreLastRead = false;  // this is used when you write to a value that a read in progress doesn't toggle the value back to the old value, so just ignore last response
								// doesn't affect WebSocket data, only GET response
var g_dpListIndex = -1;
var g_writeTimeout = 10000; //time (ms) to wait after a write to DP before updating value with latest read
var g_cookie = "";
var g_timerVar = null;
var g_iRequestErrCount = 0;
var g_iRequestMaxErr = 1;
var g_sUrlTag = ""; //leave blank - used for GET request
var g_sTagValue = ""; 
var g_sWriteTagPayload = ""; // leave blank - used to add tag to datapoint
var g_bRetryInitialGetRequest = false;  //
var g_arrPaginationResponse = [];  //
var g_iPaginationPage = 0; // Used for GET pagination
var g_iPaginationPageSize = 20; // Used for GET pagination
var g_iPaginationSnapsnotNumber = 0; // Used for GET pagination
var g_iarrDpTypeNoMaxAgeIndex = 0;
var g_iarrDpTypeNoMaxAgeOneTimeIndex = 1;
var g_iarrDpTypeMaxAgeIndex = 2;
var g_iarrDpTypeMaxAgeOnetimeIndex = 3;
var g_sTreeSubstituitonTag = "";
var g_sTreeDisplayId = "";
var g_sDropdownDisplayId = "";
var g_UrlTokens = [];  
var g_bFeedbackDelaysInProgress = 0;
var g_oFeedbackDelayObjs = new Array(); // contains a list of all Dps that can have a feedback delay
var g_iFeedbackOutputElementCount = 0;


//************************************************************************************************************** */
//  Initialization Functions
//************************************************************************************************************** */
function init() {
	var i;
	var image;
	var url;
	var iPtr, bGetDeviceList = false;
	var tokens = [];
	var temp;
	var displayElement = null;
	g_iSmartServerVersion = 0;
	g_bInitializing = true;
	g_sPriorityRelinquishPermissions = "all"; //""=means none, "all"=can clear all permissions (1-16), ">8 = can clear priorities 1-7, <8 = can clear priorities 9-16", "<8,5" = can clear 5, and 9-16
	g_sPriorityRelinquishPermissionsString = "";
	g_arrPriorityRelinquishPermissions = [];
	g_iAddDisplayElementErrors  = 0; // exception errors found while building up g_dpList
	g_arrDpTypeNameList = []; // Used during initialization only: DpTarrays of DP namesarrays  0=normal,1=onetime,2=maxage,3=maxontime
	g_arrTagList = []; // used by timer if available the order is nomaxage,maxage,maxageonetime,nomaxageonetime
	g_arrJsFunctionList = []; // use for Functions that use 2 or more datapoints, may not be tied to a specific html element
	g_showSingleDeviceOnly = false;
	g_sWebSocketSubscribePayload = "";
	g_sWebSocketSubscribePayload_oldvalue = "";
	g_sOnDemandDpRequestUrl = "";
	g_sInitialGetRequest = "";
	g_dpGetRequestArr = [];
	g_idpGetRequestIndex = -1;
	g_dpGetRequestArr[0] = "";
	g_substitutionList = [];
	g_sDeviceType = "";
	g_bNeedToSubscribe = true;
	g_deviceList = [];
	g_dpList = []; // created by user, due to substitution tags a datapoint may show up once. Once for specific datapoint and one or more due to substitution tags.
	g_dpGetList = []; 
	g_getInitialGetDpList = []; // Initial Get request with all datapoints
	g_getPeriodicGetDpList = []; // 
	g_getSlowPeriodicDpList = [];
	g_sTreeSubstituitonTag = "";
	g_sTreeDisplayId = "";
	g_sDropdownDisplayId = "";
	g_bServerOnline = false;
	g_sDevice = "";
	g_bChartsSupported = false;
	// parse users url
	url = window.location.href;
	iPtr = url.indexOf("?");
	if(iPtr > 0) {
		tokens = url.substr(iPtr + 1).split("&");
		for(i=0; i < tokens.length; i++)
		{
			temp = tokens[i].split("=");
			if(temp.length === 1)
				temp[1] = "";
			g_UrlTokens[temp[0]] = temp[1];
			if(temp[0].toLowerCase() === "device") { // only show one device
				if(temp[1] !== "") {
					g_sDevice = temp[1].replace(/%20/g, " ");
					displayElement = document.getElementById("deviceName");
					if(displayElement !== null)
						displayElement.innerText = g_sDevice;
					bGetDeviceList = false;
					g_showSingleDeviceOnly = true;
				}
			}
			else if(temp[0].toLowerCase() === "devicename") {  // specify initial device from list of devices
				if(temp[1] !== "") {
					g_sDevice = temp[1].replace(/%20/g, " ");
					displayElement = document.getElementById("deviceName");
					if(displayElement !== null)
						displayElement.innerText = g_sDevice;
				}
			}
			else if(temp[0].toLowerCase() === "embedded") {  // specify initial device from list of devices
				if(temp[1] === "true") {
					displayElement = document.getElementById("logoutbutton");
					if(displayElement !== null)
						displayElement.style.display = "none";
				}
			} 
		}
	}

	init1();

	if(g_sDevice !== "") {
		for(i=0; i < g_substitutionList.length; i++)
		{
			if((g_substitutionList[i].name === "x") && (g_substitutionList[i].displayId === "deviceName")) {
				g_substitutionList[i].value = g_sDevice;
				break;
			}

		}
	}
	
	// preload all images to speed up imageswappers
	if(g_imageList.length > 0) {
		for(i=0; i < g_imageList.length; i ++)
		{
			image = new Image();
			image.src = g_imageList[i];
		}
	}

	// create three more Tagnames, needed to support: noMaxAge,noMaxAgeOneTime, MaxAge,MaxAgeOneTime tags for 4 GET requests
	

	// Determine priority permissions string
	g_sPriorityRelinquishPermissionsString = "";
	if(g_sPriorityRelinquishPermissions === "")
		g_sPriorityRelinquishPermissions = "No permission to relinquish overrides";
	else if(g_sPriorityRelinquishPermissions === "all") {

	} 
	else {
		_determinePermissionsString();
	}

	
	// not Web page specific changes
	initAddExtraItemsToDpList();
	clearOldHtmlElements();
	if(g_iAddDisplayElementErrors !== 0)
		console.log("Error: AddDisplayElementErrors = " + g_iAddDisplayElementErrors);
	
	getSmartServerVersion(bGetDeviceList);	
	/* FFix Remove
	if(bGetDeviceList)
		getDeviceList();
	else 
		getDevice();  // single device using g_sDevice
		*/
}
function initAddExtraItemsToDpList() {
	// additional items used during runtime
	var i, j, k, iPtr;
	var name = "", option;
	var displayId = "", element;

	// check if charts supported
	
	if(g_bChartsSupported) {
		// means at least one HTML chart element
		if(typeof dashboardDpList === "undefined") 
			g_bChartsSupported = false; // chart.js not available
		else {
			_chartInit();
		}
	}
	
	for(i=0; i < g_dpList.length; i++)
	{
		if(g_dpList[i] !== null) {
			name = g_dpList[i].dpName;
			if(name !== "")
			{
				iPtr = name.indexOf("/");
				if(iPtr > 0)
				{	
					g_dpList[i].dpUrl = name.substr(0,iPtr) + "/if" + name.substr(iPtr);
				}
				g_dpList[i].writeTimestamp = 0;  // after writing value, need to wait before updating Web page, otherwise values flickers 
				g_dpList[i].value = ""; // last saved value
				g_dpList[i].bGotValue = false;  // used to check if DP already has Web page tag
				g_dpList[i].state = ""; //"not found" if missing datapoint, or deviceState
				g_dpList[i].dpValueChanged = false; // indicates whether value changed this GET request
				g_dpList[i].dpQualifier = "";
				

				var bReadOnlyOnceDp = false;
				var bAtLeastOneNonReadOnlyOnceDp = false;
					// add onchange event for drop downs that are scalars (not structured fields)
				for(j=0; j < g_dpList[i].displayElements.length; j++)
				{
					try {
						if(g_dpList[i].displayElements[j].iDisplayEnums === 1)
						{
							g_dpList[i].getDpEnums = true;
						}
						//if(((g_dpList[i].displayElements[j].field === "") || g_bAddSendEventToFieldInputElement) && (g_dpList[i].displayElements[j].readWriteType !== "r")) {
						if(((g_dpList[i].displayElements[j].field === "") || g_dpList[i].displayElements[j].autoWrite) && (g_dpList[i].displayElements[j].readWriteType !== "r")) {

							if((g_dpList[i].displayElements[j].displayType === "dropdown_text")
								|| (g_dpList[i].displayElements[j].displayType === "dropdown_number")) {
									displayId = g_dpList[i].displayElements[j].displayId;
									if(g_dpList[i].displayElements[j].autoWrite)
										document.getElementById(displayId).addEventListener("change",dropdownWrite);
									
							}
							else if(g_dpList[i].displayElements[j].displayType === "input") {
								// no longer works if(undefined === document.getElementById(g_dpList[i].displayElements[j].displayId).onkeyup) {
									displayId = g_dpList[i].displayElements[j].displayId;
									if(g_dpList[i].displayElements[j].autoWrite)
										document.getElementById(displayId).addEventListener("keyup", function(event) {
											inputBoxKey(event.target, event); });
								//}
							}
						}
						if(g_dpList[i].displayElements[j].displayType === "noop"){
							// only used to make sure we have substitution tag for send button commands
						}
						else if(g_dpList[i].displayElements[j].displayType === "priority_span")
							g_bAtLeastOneElementUsesPriority = true;      
						else if(g_dpList[i].displayElements[j].displayType === "priority_indicator") {
							g_bAtLeastOneElementUsesPriority = true;
							g_dpList[i].displayElements[j].priorityIndicatorType = "prioritydot"; 
							displayId = g_dpList[i].displayElements[j].displayId;
							element = document.getElementById(displayId);
							if(element !== null) {
								element.style.visibility = "hidden"; // hide all priority override buttons
							}
						}
						else if(g_dpList[i].displayElements[j].displayType === "priorityall_button") {
							// user may add their own onclick event
							g_bAtLeastOneElementUsesPriority = true;
							g_dpList[i].displayElements[j].displayType = "priority_indicator";
							g_dpList[i].displayElements[j].priorityIndicatorType = "priorityallbutton"; // shows highest priority
							displayId = g_dpList[i].displayElements[j].displayId;
							element = document.getElementById(displayId);
							if(element !== null) {
								element.style.visibility = "hidden"; // hide all priority override buttons
								element.addEventListener("click",function() {_showPriorityArrayRelinquishAll(this);});
							}
						}
						else if(g_dpList[i].displayElements[j].displayType === "priority_button") {
							// user may add their own onclick event
							g_bAtLeastOneElementUsesPriority = true;
							g_dpList[i].displayElements[j].displayType = "priority_indicator";
							g_dpList[i].displayElements[j].priorityIndicatorType = "prioritybutton"; // shows highest priority
							displayId = g_dpList[i].displayElements[j].displayId;
							element = document.getElementById(displayId);
							if(element !== null) {
								element.style.visibility = "hidden"; // hide all priority override buttons
								element.addEventListener("click",function() {_showPriorityArrayRelinquish(this);});
							}
						}
						else if(g_dpList[i].displayElements[j].displayType === "clearpriority_button") {
							g_bAtLeastOneElementUsesPriority = true;
							g_dpList[i].displayElements[j].displayType = "clearoverride_button";
							g_dpList[i].displayElements[j].clearoverrideType = "prioritybutton"; // shows highest priority
							displayId = g_dpList[i].displayElements[j].displayId;
							element = document.getElementById(displayId);
							if(element !== null) {
								element.style.visibility = "hidden"; // hide all priority override buttons
								element.addEventListener("click",function() {_clearOverrides(this,'b');});
							}
						}
						else if(g_dpList[i].displayElements[j].displayType === "clearoverride_button") {
							g_bAtLeastOneElementUsesPriority = true;
							g_dpList[i].displayElements[j].clearoverrideType = "button";
							displayId = g_dpList[i].displayElements[j].displayId;
							element = document.getElementById(displayId);
							if(element !== null) {
								element.style.visibility = "hidden"; // hide all priority override buttons
								element.addEventListener("click",function() {_clearOverrides(this,'b');});
							}
						}
						else if(g_dpList[i].displayElements[j].displayType === "clearoverride_switch") {
							g_bAtLeastOneElementUsesPriority = true;
							g_dpList[i].displayElements[j].displayType = "clearoverride_button";
							g_dpList[i].displayElements[j].clearoverrideType = "switch";
							displayId = g_dpList[i].displayElements[j].displayId;
							element = document.getElementById(displayId);
							if(element !== null) {
								element.checked = false; // hide all priority override buttons
								element.addEventListener("click",function() {_clearOverrides(this,'s');});
							}
						}
						
						else if (g_dpList[i].displayElements[j].writePrioirtyHtmlElelement !== null) {
							if(g_dpList[i].displayElements[j].writePriorityType === 1) {
								element = document.getElementById(g_dpList[i].displayElements[j].writePrioirtyHtmlElelement);
								if(element !== null) { 
									if(element.length === 0) {
										for(k=1; k < 17; k++)
										{
											option = document.createElement("option");
											option.text = k;
											element.add(option);
										}
										option = document.createElement("option");
										option.text = "normal";
										element.add(option);
										option = document.createElement("option");
										option.text = "no change";
										element.add(option);
									}
								}
							}
						}
						else if((g_dpList[i].displayElements[j].readWriteType === "ro") || (g_dpList[i].displayElements[j].readWriteType === "row") || (g_dpList[i].displayElements[j].readWriteType === "w"))
							bReadOnlyOnceDp = true;  // "w" is needed for read mod writes even though it is not displayed
						else
							bAtLeastOneNonReadOnlyOnceDp = true;
						if(g_dpList[i].displayElements[j].writeDp.indexOf("{") !== -1) {
							g_dpList[i].hasSubstitutionTags = true;
							// ffixx add code to get substitution tags from writeDps
						}
					}
					catch (err) {}
				}
			}
		}
	}
} 
  
//************************************************************************************************************** */
//  All other functions
//************************************************************************************************************** */
function addDisplayElementToDpObject(dpObject, displayId, fieldName, readWriteType, displayType, extraParameter) {
	return addDisplayElementToDpObjectPlusWriteDp (dpObject, displayId, fieldName, readWriteType, displayType, extraParameter, "");
}
function addDisplayElementToDpObjectPlusWriteDp (dpObject, displayId, fieldName, readWriteType, displayType, extraParameter, writeDp) {
	return addDisplayElementToDpObjectPlusWriteExtraDp (dpObject, displayId, fieldName, readWriteType, displayType, extraParameter, writeDp, 0);
}
function addDisplayElementToDpObjectPlusWriteExtraDp (dpObject, displayId, fieldName, readWriteType, displayType, extraParameter, writeDp, writeType) {
	return addDisplayElementToDpObjectAll (dpObject, displayId, fieldName, readWriteType, displayType, extraParameter, writeDp, writeType, 
		-1, 0, null, 0, null, null);
}
function addDisplayElementToDpObjectAll (dpObject, displayId, fieldName, readWriteType, displayType, extraParameter, writeDp, writeType, 
	writePriority, writePriorityType, writePrioirtyHtmlElelement, presetSupportType, enumerationSupportType, additionParameters) {
		// writePriority: -1= non specified, 0=current default, 1-17 priority
		// writeType: 0=means user code sends data, 1=maindriver automatically sends data; 
		// writePriorityType: 0=not used, 1 use dropdown
		//additionalParameters not currently used
		// presetSupportType: null or 0, follow g_bPresetsSupported, 1=add, 2=don't use
		// enumerationSupportType: null or 0 don't use, 1=show enumeration
	var element;
	var displayElement = {};
	try {
		displayElement.displayId = displayId; // eg. "opcDev.1/uiTestTarget2/0/nviLampSw/state";
		displayElement.field = fieldName; // ""=entire value, not equal "" means field value, e.g., "state" = use state field
		displayElement.readWriteType = readWriteType; //rw = read/write, ro=readonce, row=readonce-write, r=readonly, w=write only
		displayElement.displayType = displayType; // input, span, dropdown_text, function, jsfunction, priority_span, clearoverride_button
		displayElement.function = null;  // used for html elements that need a function to process like image swappers
		displayElement.decimalPlaces = null;
		displayElement.priorityNum = null; // 0=all (0-16)
		displayElement.writePriorityNum = -1; // used with drop down to select priority to use, 0=use current priority
		displayElement.writeDp = writeDp; // only used if two datapoints are used for this html element. writeDp: "" = none, otherwise refers to output datapoint
		displayElement.WriteDpSubstitionTag = writeDp;
		displayElement.autoWrite = false;  // 0= follow g_bAddSendEventToInputElement, 1= always add event listener, 2 = never add  
		displayElement.writePriorityType = writePriorityType; // for dropdown or text box: 0=none, 1=dropdown override priority,
		displayElement.writePrioirtyHtmlElelement = writePrioirtyHtmlElelement;
		displayElement.bUsePresets = false;
		displayElement.iDisplayPreset = 0;  // for dropdown or comboboxes:  0= no, 1=preset, 2=preset + value
		displayElement.iAddPresets = -1; // -1=don't add, 0= added, 1=need to add used with .iDisplayPreset
		displayElement.iDisplayEnums = 0; // for dropdown or comboboxe: 0 = no
		displayElement.presets = [];
		displayElement.text = ""; // used for priority button or clear priority button
		displayElement.dashboardDpListIndex = -1;
		if(writePriority !== null) {
			if(typeof writePriority === "number") {
				if((writePriority > -1) && (witePriority < 18)) {
					displayElement.writePriorityNum = defaultWritePriority;
				}
			}
			
		}
		
		if((displayType === "input") || (displayType === "dropdown")) {
			if(writeType === 0)
				displayElement.autoWrite = g_bAddSendEventToInputElement;
			else if(writeType === 1)
				displayElement.autoWrite = true;  // auto adds event handler
			else if(writeType === 2)
				displayElement.autoWrite = false;  // auto adds event handler
		}
		if(displayType === "function") {
			if(extraParameter !== null) {
				if(typeof extraParameter === "function") {
					displayElement.function = extraParameter;
				}
			}
		}
		if((displayType === "dropdown") || (displayType === "datalist")) {
			if(enumerationSupportType)
				displayElement.iDisplayEnums = 1;
		}
		else if((displayType === "presets_datalistvalue") || (displayType === "presets_datalist")) {
			if(g_bPresetsSupported) {
				if(presetSupportType === null)
					displayElement.iAddPresets = 1;
				else if(presetSupportType === 0)
					displayElement.iAddPresets = 1;
				else if(presetSupportType === 1)
					displayElement.iAddPresets = 1;
				else if(presetSupportType === 2)
					displayElement.iAddPresets = -1;
				if(displayType === "presets_datalistvalue") {
					displayElement.iDisplayPreset = 2;
					displayElement.displayType = "presets_datalist";
				}
				else	
					displayElement.iDisplayPreset = 1;
				
			}
			if(enumerationSupportType)
				displayElement.iDisplayEnums = 1;
		}
		else if(extraParameter !== null) {
			if(extraParameter === "") {

			}
			else if(typeof extraParameter === "number") {
				if((displayType === "clearoverride_button") || (displayType === "clearpriority_button") || (displayType === "priority_button") 
					|| (displayType === "priorityall_button") || (displayType === "clearoverride_switch") || (displayType === "priority_indicator")) {
					displayElement.priorityNum = extraParameter;
				}
				else
					displayElement.decimalPlaces = extraParameter;
			}
			else if ((displayType === "clearoverride_button") || (displayType === "clearpriority_button") || (displayType === "priority_button") 
				|| (displayType === "priorityall_button") || (displayType === "clearoverride_switch") || (displayType === "priority_indicator")) {
				if(typeof extraParameter === "string") {
					extraParameter = extraParameter.toLowerCase();
					if(extraParameter === "all")
						displayElement.priorityNum = 0; // 0-16
					else 
						displayElement.priorityNum = -1;
				}
			}
			if((displayType === "priority_button") || (displayType === "priorityall_button") || (displayType === "clearpriority_button")) {
				element = document.getElementById(displayId);
				if(element !== null) {
					displayElement.text = element.innerText;
				}
			}
		}
		dpObject.displayElements.push(displayElement);
	}
	catch (err) 
	{
		dpObject = null;
		g_iAddDisplayElementErrors ++;
		alert("addDisplayElementToDpObjectAll exception: " + displayId + "\r\n\r\n" + err.toString());
	}
	return dpObject;
}
function addChartElement (dpObject, displayId, fieldName, presetSupportType, enumerationSupportType, bDataLog, maxCount, maxDurationMinutes) {
		// writePriority: -1= non specified, 0=current default, 1-17 priority
		// writeType: 0=means user code sends data, 1=maindriver automatically sends data; 
		// writePriorityType: 0=not used, 1 use dropdown
		//additionalParameters not currently used
		// presetSupportType: null or 0, follow g_bPresetsSupported, 1=add, 2=don't use
		// enumerationSupportType: null or 0 don't use, 1=show enumeration
	var element;
	var displayElement = {};
	try {
		g_bChartsSupported = true;
		displayElement.displayId = displayId; // eg. "opcDev.1/uiTestTarget2/0/nviLampSw/state";
		displayElement.field = fieldName; // ""=entire value, not equal "" means field value, e.g., "state" = use state field
		displayElement.readWriteType = "r"; //rw = read/write, ro=readonce, row=readonce-write, r=readonly, w=write only
		displayElement.displayType = "chart"; // input, span, dropdown_text, function, jsfunction, priority_span, clearoverride_button
		displayElement.function = null;  // used for html elements that need a function to process like image swappers
		displayElement.decimalPlaces = null;
		displayElement.priorityNum = null; // 0=all (0-16)
		displayElement.writePriorityNum = -1; // used with drop down to select priority to use, 0=use current priority
		displayElement.writeDp = ""; // only used if two datapoints are used for this html element. writeDp: "" = none, otherwise refers to output datapoint
		displayElement.WriteDpSubstitionTag = "";
		displayElement.autoWrite = 2;  // 0= follow g_bAddSendEventToInputElement, 1= always add event listener, 2 = never add  
		displayElement.writePriorityType = 0; // for dropdown or text box: 0=none, 1=dropdown override priority,
		displayElement.writePrioirtyHtmlElelement = "";
		displayElement.bUsePresets = false;
		displayElement.iDisplayPreset = 0;  // for dropdown or comboboxes:  0= no, 1=preset, 2=preset + value
		displayElement.iAddPresets = -1; // -1=don't add, 0= added, 1=need to add used with .iDisplayPreset
		displayElement.iDisplayEnums = 0; // for dropdown or comboboxe: 0 = no
		displayElement.presets = [];
		displayElement.text = ""; // used for priority button or clear priority button
		displayElement.dashboardDpListIndex = -1; 
		displayElement.min = null;
		displayElement.max = null;
		displayElement.hasDynmaicRange = true;
		displayElement.linecolor = "blue";
		displayElement.chartlabels = "both";
		if(maxCount === null)
			maxCount = ivChartTotalEntriesLargeChart;
		if(maxCount > ivChartTotalEntriesLargeChart)
			maxCount = ivChartTotalEntriesLargeChart;
		displayElement.chartMaxCount = maxCount;
		displayElement.chartMaxDuration = null;
		if(maxDurationMinutes !== null)
			displayElement.chartMaxDuration = maxDurationMinutes * 60 * 1000; //minutes
		
		dpObject.displayElements.push(displayElement);
	}
	catch (err) 
	{
		dpObject = null;
		g_iAddDisplayElementErrors ++;
		alert("addDisplayElementToDpObjectAll exception: " + displayId + "\r\n\r\n" + err.toString());
	}
	return dpObject;
}
function addDisplayElementJsFunctionToDpObject(dpObject, displayId, fieldName, readWriteType, displayType, jsFunctionIndex) {
	// function that uses 1 or more datapoints and may or may not be associated to a specific HTML element
	var displayElement = {};
	displayElement.displayId = displayId; // eg. "opcDev.1/uiTestTarget2/0/nviLampSw/state";
	displayElement.field = fieldName; // ""=entire value, not equal "" means field value, e.g., "state" = use state field
	displayElement.readWriteType = readWriteType; //rw = read/write, ro=readonce, row=readonce-write, r=readonly, w=write only
	displayElement.displayType = displayType; // input, span, dropdown_text,
	displayElement.function = jsFunctionIndex;
	displayElement.writeDp = "";
	dpObject.displayElements.push(displayElement);
	return dpObject;
}
function addJavascriptFunctionTojsFunctionObject(jsFunctionParameters,  displayId, datapointList, functionName) {
	var i, j;
	var dpObj;
	var jsDpObj;
	var dplistIndex = -1;
	var jsFunction = {};
	var index = g_arrJsFunctionList.length;
	jsFunction.id = index;
	jsFunction.jsFunctionParameters = jsFunctionParameters;
	jsFunction.displayId = displayId; // eg. "opcDev.1/uiTestTarget2/0/nviLampSw/state";
	jsFunction.function = functionName;
	jsFunction.dpList = [];
	if(datapointList !== null) {
		for(i=0; i < datapointList.length; i++)
		{
			dplistIndex = -1;
			for(j=0; j < g_dpList.length; j++)
			{
				if(datapointList[i].dpName === g_dpList[j].dpName)
				{
					dplistIndex = j;
					break;
				}
			}
			if(dplistIndex === -1) {
				// add new dp
				dpObj = new dpObject(datapointList,datapointList[i].useMaxAge);
				g_dpList.push(dpObj);
				dplistIndex = g_dpList.length - 1;
				g_dpList[dplistIndex].writeTimestamp = 0;  // after writing value, need to wait before updating Web page, otherwise values flickers 
				g_dpList[dplistIndex].value = ""; // last saved value
				g_dpList[dplistIndex].bGotValue = false;  // used to check if DP already has Web page tag
				g_dpList[dplistIndex].state = ""; //"not found" if missing datapoint, or deviceState
				g_dpList[dplistIndex].dpValueChanged = false; // indicates whether value changed this GET request
				
				
	
			}
			else {
				if(datapointList[i].useMaxAge) {
					g_dpList[dplistIndex].useMaxAge = datapointList[i].useMaxAge;
				}
			}
			if(dplistIndex !== -1) {
				var displayElement = {};
				displayElement.displayId = displayId; // eg. "opcDev.1/uiTestTarget2/0/nviLampSw/state";
				displayElement.field = ""; // ""=entire value, not equal "" means field value, e.g., "state" = use state field
				displayElement.readWriteType = ""; //rw = read/write, ro=readonce, row=readonce-write, r=readonly, w=write only
				displayElement.displayType = "jsfunction"; // input, span, dropdown_text
				displayElement.function = index; // numeric pointer
				g_dpList[dplistIndex].displayElements.push(displayElement);

				jsDpObj = {};
				jsDpObj.dpName = g_dpList[dplistIndex].dpName;
				jsDpObj.dpListIndex = dplistIndex;
				jsDpObj.value = "";
				jsDpObj.state = "";
				jsDpObj.dpValueChanged = false;
				jsFunction.dpList.push(jsDpObj);
			}
		}
		
		g_arrJsFunctionList.push(jsFunction)
	}
}
function _addIfandXifNameToDatapointName(pathName) {
	
	// verify that /if not already included, if not add /if
	// mode: 0=add xifname if 3.20.114+, 1=always add xifname, 2= never add XIF name not used yet
	var pathNames  = [];
	try {
		var iPtr1;
		var origPath = pathName;
		if(g_iSmartServerVersion >= 320114) {
			pathName = pathName.trim();
			pathNames = pathName.split("/");
			if(pathNames.length === 4) {
				pathName = pathNames[0].trim();
				pathName += "/if/*+xifName==" + pathNames[1].trim();
				pathName +=  "/" + pathNames[2].trim();
				pathName +=   "/*+xifName==" + pathNames[3].trim();
			}
			else if(pathNames.length === 3) { 
				pathName =  "*+xifName==" + pathNames[0].trim();
				pathName += "/" + pathNames[1].trim();
				pathName += "/*+xifName==" + pathNames[2].trim();
			}
		}
	}
	catch {pathName = origPath;}
	return pathName;

}
function chechifValidPreset(writeDpName, value) {
	var bResult = false, i, j;
	try {
		if(writeDpName !== null) {
			if(writeDpName !== "") { //12345
				if(typeof value === "string") {
					for(i=0; i < g_dpList.length; i ++)
					{
						if(g_dpList[i].dpName === writeDpName) {
							if(typeof g_dpList[i].presets !== "undefined") {
								if(typeof g_dpList[i].presets !== null) {
									if(typeof g_dpList[i].presets.map !== "undefined") {
										if(typeof g_dpList[i].presets.map !== null) {
											if(g_dpList[i].presets.map.length > 0) {
												if(value.charAt(0) !== "{") {
													for(j=0; j < g_dpList[i].presets.map.length; j++)
													{
														if(g_dpList[i].presets.map[j].name.toLowerCase() === value.toLowerCase()) {
															return true;
														}
													}
												}
											}
										}
									}
								}
							}
							break;
						}
					}
				}
			}
		}
	}
	catch (err) { }
	return bResult;
}
function clearOldHtmlElements() {
	try {
		var i, j;
		if(g_sDefaultSpanAndInputValue !== "") {
			if(g_dpList === null)
				return;
			for(i=0; i < g_dpList.length; i++)
			{
				for(j=0; j < g_dpList[i].displayElements.length; j++)
				{
					if(g_dpList[i].displayElements[j].displayType === "input") {
						document.getElementById(g_dpList[i].displayElements[j].displayId).value = g_sDefaultSpanAndInputValue;
					}
					else if(g_dpList[i].displayElements[j].displayType === "span") {
						document.getElementById(g_dpList[i].displayElements[j].displayId).innerHTML = g_sDefaultSpanAndInputValue;
					}
				}
			}
		}
	}
	catch {}
}
function _clearOverrides(n, type) {
	_clearOverrides1(n, type, null);
}
function _clearOverrides1(n, type, priority) {
	// n=this
	// type: "b" = button, "s" = sliderswitch
	var element;
	var displayId;
	var i,j, k, dp, dpPath, obj, priority = null, key, keys, value, levels = [], levels1 = [];
	var url = "https://" + location.hostname + "/iap/devs/*+name==", url1;
	try {
		displayId = n.id;
		for(i=0; i < g_dpList.length; i++)
		{
			for(j=0; j < g_dpList[i].displayElements.length; j++)
			{
				if(g_dpList[i].displayElements[j].displayId === displayId) {
					if(priority === null)
						priority = g_dpList[i].displayElements[j].priorityNum;
					if(priority === null){

					}
					else if(priority === -1) {
						// invalid selection
					}
					else if (priority === 0) {
						// clear all active
						element = document.getElementById(displayId);
						if((element !== null) && (priority !== null)) {
							
							obj = g_dpList[i];
							dp = obj.dpName;
							dp = encodePathNames(dp);
							dpPath = dp.split("/");
							levels = g_dpList[i].values.levels;
							keys = Object.keys(g_dpList[i].values.levels);
							levels1 = JSON.parse(JSON.stringify(levels));
							for(k=(keys.length - 1); k >= 0; k --)
							{ // relinquish lower priorities first so that only priority 17 value gets sent out
								key = Number(keys[k]);
								if(key === 17) {
									
								}
								else {
									if((g_sPriorityRelinquishPermissions === "all") || g_arrPriorityRelinquishPermissions[key - 1].permission) {
										delete levels1[key];
										url1 = url + dpPath[0] + "/if/" + dpPath[1] + "/" + dpPath[2] + "/" + dpPath[3] + "/overrides/" + key + "/value"; 
										requestDeleteData(0, url1, "", null, null); 
									}
								}
							}
							g_iIgnoreLastRead = true; // used to remove datapoint value flicker
							key = Object.keys(g_dpList[i].values.levels)[0];
							if(key === 17) {
								if(type = "b")
									element.style.visibility = "hidden"; //1234
								else if(type = "s")
									element.disabled = "true"; //1234
							}
							g_dpList[i].values.level = key;
							g_dpList[i].priority = key;
							g_dpList[i].values.levels = levels1;
							g_dpList[i].value = levels1[key];
							updateAllDisplayElements(0, g_dpList[i].dpName, i, null, null, false, true, null, null);
						}
					}
					else { // single priority
						element = document.getElementById(displayId);
						if((element !== null) && (priority !== null)) {
							if(type = "b")
								element.style.visibility = "hidden"; //1234
							else if(type = "s")
								element.disabled = "true"; //1234
							obj = g_dpList[i];
							dp = obj.dpName;
							dp = encodePathNames(dp);
							dpPath = dp.split("/");
							url1 = url +  dpPath[0] + "/if/" + dpPath[1] + "/" + dpPath[2] + "/" + dpPath[3] + "/overrides/" + priority + "/value"; 
							requestDeleteData(0, url1, "", null, null); 
							g_iIgnoreLastRead = true; // used to remove datapoint value flicker
							delete g_dpList[i].values.levels[priority];
							key = Object.keys(g_dpList[i].values.levels)[0];
							g_dpList[i].values.level = key;
							g_dpList[i].priority = key;
							value = g_dpList[i].values.levels[key];
							g_dpList[i].value = value;
							updateAllDisplayElements(0, g_dpList[i].dpName, i, null, null, false, true, null, null);
						}
					}
					i = g_dpList.length + 2;
					break;
				}
			}
		}
	}
	catch (err) {}
}
function createDeviceList(sustitutionTag, treeElementId, dropdownElementId) {
	g_sTreeSubstituitonTag = sustitutionTag;
	if(treeElementId !== "") {
		g_sTreeDisplayId = treeElementId;
		g_bTreeView = true;
	}
	if(dropdownElementId !== "") 
		g_sDropdownDisplayId = dropdownElementId;
}
function createDpGetList() {
	try {
		var dpList = [];
		var obj;
		var i, j, k, iPtr, obj;
		var z;
		var dpQualifier, readWriteType, deviceName;
		var dpPath, writePath;
		var blockPath;
		var re;
		

		
		g_bNeedToSubscribe = false;
		if(g_bUseWebSockets)
			g_bNeedToSubscribe = true; // list changing so subscribe to new list
		g_getInitialGetDpList = [];
		g_getPeriodicGetDpList = [];
		g_getSlowPeriodicDpList = [];
		g_dpGetList = [];
		
		if(g_bChartsSupported) {
			dashboardDpList = [];
			g_bDashboardDataLogGetInProgress = true;
		}

		for(i=0; i < g_dpList.length; i++) 
		{

			dpPath = g_dpList[i].dpName;
			
					
			if(g_dpList[i].hasSubstitutionTags) {
				g_dpList[i].bGotValue = false; // used to make sure at least one value changed
				g_dpList[i].value = null;
				g_dpList[i].valueStr = "";
				// determine new datapoint name
				dpPath = g_dpList[i].substitutionDpName;
				/*
				for(j=0; j < g_dpList[i].substitutionTags.length; j++) 
				{ 
					//re = / + "{" + g_dpList[i].substitutionTags[j] + "}" + /g;
					re = "{" + g_dpList[i].substitutionTags[j] + "}";
					for(k=0; k < g_substitutionList.length; k++) 
					{
						if(g_dpList[i].substitutionTags[j] = g_substitutionList[k].name) {
							dpPath = dpPath.split(re).join(g_substitutionList[k].value);
							//dpPath = dpPath.replace(re,g_substitutionList[k].value);
							break;
						}
					}
				}
				*/
				for(k=0; k < g_substitutionList.length; k++) 
				{
					re = "{" + g_substitutionList[k].name + "}";
					dpPath = dpPath.split(re).join(g_substitutionList[k].value);
				}

				g_dpList[i].dpName = dpPath;

				iPtr = dpPath.indexOf("/");
				deviceName = dpPath.substr(0,iPtr);
				blockPath = dpPath.substr(iPtr + 1);
				g_dpList[i].dpQualifier = "";
					// get device info
				for(k=0; k < g_deviceList.length; k ++)
				{
					if(g_deviceList[k].name === deviceName) {
						g_dpList[i].dpQualifier = g_deviceList[k].scId + "/" + g_deviceList[k].protocol + "/" + g_deviceList[k].DID + dpPath.substr(iPtr);
						break;
					}
				}
					// substitution tags for write datapoints
				for(j=0; j < g_dpList[i].displayElements.length; j++)
				{
					writePath = g_dpList[i].displayElements[j].WriteDpSubstitionTag;
					for(k=0; k < g_substitutionList.length; k++) 
					{
						re = "{" + g_substitutionList[k].name + "}";
						writePath = writePath.split(re).join(g_substitutionList[k].value);
					}
					g_dpList[i].displayElements[j].writeDp = writePath;
					if(g_bChartsSupported) {
						// chart 
						if(g_dpList[i].displayElements[j].displayType === "chart") {
							obj = {};
							obj.displayId = g_dpList[i].displayElements[j].displayId;
							obj.dpName = g_dpList[i].dpName;
							obj.dpPath = dpPath;
							obj.pathName = dpPath;
							obj.deviceName = deviceName;
							obj.blockPath = blockPath;
							obj.dpQualifier = g_dpList[i].dpQualifier;
							obj.min = g_dpList[i].displayElements[j].min;
							obj.max = g_dpList[i].displayElements[j].max;
							obj.hasDynmaicRange = g_dpList[i].displayElements[j].hasDynmaicRange;
							obj.linecolor = g_dpList[i].displayElements[j].linecolor;
							obj.chartlabels = g_dpList[i].displayElements[j].chartlabels;
							obj.datalogData = [];
							obj.livePreDatalogData = []; // live data received while waitig for data log data responses
							obj.chartMaxCount = g_dpList[i].displayElements[j].chartMaxCount;
							obj.chartMaxDuration = g_dpList[i].displayElements[j].chartMaxDuration;
							obj.bCreateChart = true;
							dashboardDpList.push(obj);
							g_dpList[i].displayElements[j].dashboardDpListIndex = dashboardDpList.length - 1;
						}
					}
				}
			} // if(g_dpList[i].hasSubstitutionTags) {
			else { 
				// fix Dp List
				if(g_dpList[i].dpQualifier === "") {
					iPtr = dpPath.indexOf("/");
					deviceName = dpPath.substr(0,iPtr);
					for(k=0; k < g_deviceList.length; k ++)
					{
						if(g_deviceList[k].name === deviceName) {
							g_dpList[i].dpQualifier = g_deviceList[k].scId + "/" + g_deviceList[k].protocol + "/" + g_deviceList[k].DID + dpPath.substr(iPtr);
							break;
						}
					}
				}

			}
			
			dpQualifier = g_dpList[i].dpQualifier;
			if(dpQualifier !== "") {
				z=-1;
				for(j=0; j < g_dpGetList.length; j ++)
				{
					if(g_dpGetList[j].dpQualifier === dpQualifier) {
						z = j;
						break;
					}
				}
				if(z === -1) {
					// new entry
					
					obj = {};
					obj.dpName = dpPath;
					obj.readType = "initial";
					obj.feedbackTimeout = 0;
					obj.values = {}; // priority obj with level and priority array levels 

					for(k=0; k < g_dpList[i].displayElements.length; k++)
					{
						readWriteType = g_dpList[i].displayElements[k].readWriteType; //rw = read/write, ro=readonce, row=readonce-write, r=readonly, w=write only
						if(obj.readType === "slowperiodic") {
							if((readWriteType === "r") || (readWriteType === "rw"))
								obj.readType = "periodic";
						}
						else if(obj.readType === "periodic") {
						}
						else {

							if((readWriteType === "ro") || (readWriteType === "row"))
								obj.readType = "slowperiodic";
							else if((readWriteType === "r") || (readWriteType === "rw"))
								obj.readType = "periodic";
						}
					}
					obj.dplistIndexes = [];
					obj.dplistIndexes.push(i);
					obj.dpQualifier = g_dpList[i].dpQualifier;
					g_dpGetList.push(obj);
				}
				else {
					//already exists add new dpList
					g_dpGetList[z].dplistIndexes.push(i);
					for(k=0; k < g_dpList[i].displayElements.length; k++)
					{
						readWriteType = g_dpList[i].displayElements[k].readWriteType; //rw = read/write, ro=readonce, row=readonce-write, r=readonly, w=write only
						if(g_dpGetList[z].readType === "slowperiodic") {
							if((readWriteType === "r") || (readWriteType === "rw"))
								g_dpGetList[z].readType = "periodic";
						}
						else if(g_dpGetList[z].readType === "periodic") {
						}
						else {

							if((readWriteType === "ro") || (readWriteType === "row"))
								g_dpGetList[z].readType = "slowperiodic";
							else if((readWriteType === "r") || (readWriteType === "rw"))
								g_dpGetList[z].readType = "periodic";
						}
					}
				}
			} //if(dpQualifier !== "") 
		}
		if(g_dpGetList.length > 0) {
			for(i=0; i < g_dpGetList.length; i++)
			{
				g_getInitialGetDpList.push(g_dpGetList[i].dpQualifier);
				if((g_dpGetList[i].readType === "slowperiodic") || (g_dpGetList[i].readType === "periodic")) {
					g_getSlowPeriodicDpList.push(g_dpGetList[i].dpQualifier);
				}
				if(g_dpGetList[i].readType === "periodic") {
					g_getPeriodicGetDpList.push(g_dpGetList[i].dpQualifier);
				}
				

			}
			g_sInitialGetRequest = g_getInitialGetDpList.join(",");
			g_sInitialGetRequest = g_sInitialGetRequest.replace(/\//g,"%2F");
			createRequestString(0, g_getInitialGetDpList);
			getAllDpValues(0);
			if(g_bChartsSupported)
				_getChartDatalogData(0);
		}
	}
	catch (err) {
		var sErr = err.toString();
	}
}
function createRequestString(mode, objList) {
	// mode: 0=initial request - websocket subscribe only sent once, 1=periodic request (slow and fast)
	try {
		var iCount = 0, index = 0, i;
		if(mode === 0) {
			g_sWebSocketSubscribePayload = "";
			g_sWebSocketSubscribePayload_oldvalue = "";
			
		}
	
		g_sOnDemandDpRequestUrl = "";
		g_dpGetRequestArr = [];
		g_idpGetRequestIndex = -1;
		g_dpGetRequestArr[index] = "";
		if(objList.length > 0) {
			g_idpGetRequestIndex = 0;
			for (i=0; i <objList.length; i++)
			{
				if(g_sOnDemandDpRequestUrl !== "")
					g_sOnDemandDpRequestUrl += ",";
				g_sOnDemandDpRequestUrl += objList[i];
				if(mode === 0) {
					if(g_sWebSocketSubscribePayload !== "") 
						g_sWebSocketSubscribePayload += ",";
						g_sWebSocketSubscribePayload += "\"" + objList[i] + "\"";
				}
				if(typeof g_dpGetRequestArr[index] === "undefined")
					g_dpGetRequestArr[index] = "";
				else if(g_dpGetRequestArr[index] !== "")
					g_dpGetRequestArr[index] += ",";
				g_dpGetRequestArr[index] += objList[i];
				iCount ++;
				if(iCount >= g_iMaxOfDpsToPollPerInterval) {
					iCount = 0;
					index ++;
				}
			}
			if(mode === 0) {
				if(g_sWebSocketSubscribePayload !== "") 
					g_sWebSocketSubscribePayload = "[" + g_sWebSocketSubscribePayload + "]";
			}
			
			if(g_sOnDemandDpRequestUrl !== "") {
				g_sOnDemandDpRequestUrl = g_sOnDemandDpRequestUrl.replace(/\//g,"%2F");
				for(i=0; i < g_dpGetRequestArr.length; i++)
				{
					g_dpGetRequestArr[i] = g_dpGetRequestArr[i].replace(/\//g,"%2F");
				}
			}
		}
	} catch {}
}
function currentDpPriority(dpName){
	var priority = -1; // means can't find DP, ""=means DP value hasn't been read yet
	var i;
	try {
		for(i=0; i < g_dpList.length; i++)
		{
			if(g_dpList[i].dpName === dpName) {
				priority = g_dpList[i].values.level;
				break;
			}
		}
	}
	catch(e) {}
	return priority;
}
function currentDpValue(dpName) {
	var value = null; // means can't find DP, ""=means DP value hasn't been read yet
	var i;
	try {
		for(i=0; i < g_dpList.length; i++)
		{
			if(g_dpList[i].dpName === dpName) {
				value = g_dpList[i].value;
				break;
			}
		}
	}
	catch(e) {}
	return value;
}
function currentDpValueByElementId(displayId) {
	var dpInfo = {};
	dpInfo.value = null; // means can't find DP, ""=means DP value hasn't been read yet
	dpInfo.dpName = "";
	var i, j;
	try {
		for(i=0; i < g_dpList.length; i++)
		{
			if(g_dpList[i].displayElements !== null) {
				for(j=0; j < g_dpList[i].displayElements.length; j++)
				{
					if(g_dpList[i].displayElements[j].displayId === displayId) {
						dpInfo.value = g_dpList[i].value;
						dpInfo.dpName = g_dpList[i].dpName;
						dpInfo.name = g_dpList[i].dpName; // dp XIF name
						if(typeof g_dpList[i].name !== "undefined")
							dpInfo.name = g_dpList[i].name; //dp instance name
						dpInfo.writeDp = g_dpList[i].displayElements[j].writeDp;
						dpInfo.readWriteType = g_dpList[i].displayElements[j].readWriteType;
						dpInfo.bStructured = g_dpList[i].bStructured
						dpInfo.bNumber = g_dpList[i].bNumber
						dpInfo.presets = g_dpList[i].presets;
						dpInfo.priority = -1;
						dpInfo.values = null;
						dpInfo.presetValue = g_dpList[i].presetValue;
						if(typeof g_dpList[i].priority !== "undefined")
							dpInfo.priority = g_dpList[i].priority; // only available for write datapoints
						if(typeof g_dpList[i].values !== "undefined")
							dpInfo.values = JSON.parse(JSON.stringify(g_dpList[i].values));	// only available for write datapoints
						dpInfo.dpIndex = i;
						dpInfo.displayIndex = j;
						i = g_dpList.length + 2;
						break;
					}
				}
			}
		}
	}
	catch(e) {}
	return dpInfo;
}
function dpObject(dpName,bUseMaxAge) {
	var i, iPtr, iPtr1;
	var pathObjects;
	var substitutionTag;
	this.dpName = dpName;  // dp XIF path - dpName is same as the element Id (name after substitution tags processed)
	this.useMaxAge = bUseMaxAge;
	this.displayElements = [];  // list of HTML element using this DP, create one entry per HTML element (e.g., span, input)
	this.hasSubstitutionTags = false;
	this.substitutionDpName = dpName;  // original DP Path including substitution tags
	this.substitutionTags = [];
	this.presets = {};
	this.bStructured = false;
	this.bNumber = false;
	this.bString = false; // most likely an enum
	this.presetValue = null;
	this.getDpEnums = false;
	this.enum = []; // enum list
	if(dpName.indexOf("{") !== -1) {
		pathObjects = dpName.split("/");
		for(i=0; i <pathObjects.length; i++)
		{
			iPtr = pathObjects[i].indexOf("{");
			if(iPtr !== -1) {
				iPtr1 = pathObjects[i].indexOf("}", iPtr);
				if(iPtr1 !== -1) {
					if(iPtr1 !== (iPtr + 1)){
						this.hasSubstitutionTags = true;
						iPtr ++;
						substitutionTag = pathObjects[i].substr(iPtr, iPtr1 - iPtr);
						this.substitutionTags.push(substitutionTag);
					}
				}
			}
		} 
	}
	
}
function _determinePermissionsString() {
	
	try {
		
		var permissionList = []; //12345
		var obj, permission, i, j;
		var bPartOfRange = false;
		var iPreviousNum = -1;
		var iFirstNum = -1;
		g_arrPriorityRelinquishPermissions = [];  // 0 =based so index is (permission - 1)
		for(i=1; i < 17; i++)
		{
			obj = {};
			obj.priority = i;
			obj.permission = false;
			g_arrPriorityRelinquishPermissions.push(obj);
		}
		
		if(g_sPriorityRelinquishPermissions !== "") {
			
			permissionList = g_sPriorityRelinquishPermissions.split(",");
			for(i=0; i < permissionList.length; i++)
			{
				permission = permissionList[i];
				if(permission != "") {
					if(permission.charAt(0) === ">") {
						if(permission.length > 1) {
							permission = permission.substr(1);
							if(/^\d+$/.test(permission)) {
								permission = Number(permission);
								for(j = 1; j < permission; j ++)
								{
									g_arrPriorityRelinquishPermissions[j - 1].permission = true;
								}
							}
						}
					}
					else if(permission.charAt(0) === "<") {
						if(permission.length > 1) {
							permission = permission.substr(1);
							if(/^\d+$/.test(permission)) {
								permission = Number(permission);
								for(j = 16; j > permission; j --)
								{
									g_arrPriorityRelinquishPermissions[j - 1].permission = true;
								}
							}
						}
					}
					else if(permission.charAt(0) === "=") {
						if(permission.length > 1) {
							permission = permission.substr(1);
							if(/^\d+$/.test(permission)) {
								permission = Number(permission);
								g_arrPriorityRelinquishPermissions[permission - 1].permission = true;
							}
						}
					}
					else {
						if(/^\d+$/.test(permission)) {
							permission = Number(permission);
							g_arrPriorityRelinquishPermissions[permission - 1].permission = true;
						}
					}
				}
			}
			bPartOfRange = false;
			iPreviousNum = -1;
			iFirstNum = -1;
			
			for(i=0; i < 16; i++)
			{
				
				if(bPartOfRange) {
					if(i === 15) {
						if(g_arrPriorityRelinquishPermissions[i].permission) {
							g_sPriorityRelinquishPermissionsString +=  "-" + g_arrPriorityRelinquishPermissions[i].priority;
						}
						else 
							g_sPriorityRelinquishPermissionsString +=  "-" + iPreviousNum;
					}
					else {
						if(g_arrPriorityRelinquishPermissions[i].permission) {
							iPreviousNum = g_arrPriorityRelinquishPermissions[i].priority;
						}
						else {
							if(iFirstNum !== iPreviousNum) {
								g_sPriorityRelinquishPermissionsString +=  "-" + iPreviousNum;
							}
							bPartOfRange = false;
							iPreviousNum = -1;
							iFirstNum = -1; //12345
						}
					}
				}
				else if(g_arrPriorityRelinquishPermissions[i].permission) {
					if((g_sPriorityRelinquishPermissionsString !== "") && (!bPartOfRange)) {
						g_sPriorityRelinquishPermissionsString += ",";
					}
					g_sPriorityRelinquishPermissionsString += g_arrPriorityRelinquishPermissions[i].priority;
					if(i < 15) {
						if(g_arrPriorityRelinquishPermissions[i + 1].permission) {
							bPartOfRange = true;
							iFirstNum = i;
							iPreviousNum = i;
						}
					}
				}
			}
			
		} 
		
	}
	catch (err) {}
	
}
function dropdownWrite() {
	try {
		var displayId = this.id;
		var i,oldValue;
		var displayInfo = findDisplayIndexByDisplayId(displayId);
		var currentTime = new Date();
		
		if(Object.keys(displayInfo).length |= 0) {
			var iIndex = displayInfo.dpListIndex;
			if(g_dpList[iIndex].displayElements[displayInfo.displayElementsIndex].field === "") {
				var value = document.getElementById(g_dpList[iIndex].displayElements[displayInfo.displayElementsIndex].displayId).value;
				if(value !== "_nochange_") {
					url = "https://" + location.hostname; // + ":8443";
					url += "/iap/devs/*+name==" + g_dpList[iIndex].dpUrl + "/value";
					oldValue = g_dpList[iIndex].value;
					g_dpList[iIndex].value = value; //"{" + value + "}";
					
					if(g_dpList[iIndex].displayElements[displayInfo.displayElementsIndex].displayType === "dropdown_text")
						payload = "\"" + value + "\""; // add quoates for enums
					else if(g_dpList[iIndex].displayElements[displayInfo.displayElementsIndex].displayType === "dropdown_number") {
						var value1;
						if(isNaN(sceneNum))
							value1 = "\"" + value + "\"";
						else
							value1 = Number(value);
						payload = value1; 
					}
					else 
						payload = value;
					g_dpList[iIndex].writeTimestamp = currentTime;
					g_dpList[iIndex].feedbackTimestamp = currentTime.getTime() + g_iFeedbackDelayTime; 
					for(i=0; i < g_dpGetList.length; i++)
					{
						if(g_dpGetList[i].dpQualifier === g_dpList[iIndex].dpQualifier) {
							g_dpGetList[i].feedbackTimeout = currentTime.getTime() + g_iFeedbackDelayTime;
							g_dpGetList[i].feedbackDelayOldValue = g_dpGetList[i].value;
							break;
						}
					}
					requestWritePutData(0, url, payload, null, null);
				}
				else { 
					var value1 = g_dpList[iIndex].value;
					if(g_dpList[iIndex].displayElements[displayInfo.displayElementsIndex].displayType === "dropdown_text")
						value1 = value1.replace(/\"/g,"");
					document.getElementById(g_dpList[iIndex].displayElements[displayInfo.displayElementsIndex].displayId).value = value1;
				}
			}
		}
	} catch (err) {}
}
function encodePathNames(path) {
	return path.replace(/\[/g,"%5B").replace(/\]/g,"%5D");; //1234
}
function getDevice() { 
	var url = "/iap/devs/*+name==" + g_sDevice + "?short=true&sortBy=name&noxs=true";
	g_deviceList = [];
	requestGetData(1, url, getDeviceListCallback, readFailCallback); // get Device list
}
function getDeviceList() { 
	var url = "/iap/devs?short=true&sortBy=name&noxs=true";
	if(g_sDeviceType !== "") {
		url = "/iap/devs/*+typeName==" + g_sDeviceType.replace(/ /g,"%20") + "?short=true&sortBy=name&noxs=true"; // get device of only this type
	}
	g_deviceList = [];
	requestGetData(0, url, getDeviceListCallback, readFailCallback); // get Device list
}
function getDeviceListCallback(mode, requestUrlString, json){
	// mode: 0=all devices 1=single device 4=don't change display
	var i;
	var sTree = "", sDropdown = "";
	var treeView = null;
	var toggler = null;
	g_bServerOnline = true;
	if((json === null) || (json.length === 0)) {
		if(mode !== 4)
			alert("No devices Found");
		return;
	}
	
	try {
		if((mode === 0) || (mode === 1)) {
			g_deviceList = JSON.parse(JSON.stringify(json));
			if(g_deviceList.length === 0)
				return; // no devices
			if(g_bUseWebSockets) {
				if(typeof ivWebSocketInit !== "undefined") {
					ivWebSocketInit();  // needed to make sure at least first REST request was successful
				}
			}
			if(mode !== 1) {
				if((mode === 0) || (!g_bUseWebSockets) || ((mode === 2) && g_bUseWebSockets)) {
					if((g_sDevice !== "") || (g_sDeviceType !== "")) {

						if(((g_sTreeDisplayId !== "") || (g_sTreeDisplayId !== "")) && (g_sTreeSubstituitonTag !== "")) {
							// create device tree, dropdown or both
							for(i=0; i < json.length; i++)
							{
								if(g_sTreeDisplayId !== "")
								{
									sTree += '<li onclick="showTreeDevice(this,\'' + g_sTreeSubstituitonTag + '\')">' + json[i].name + '</li>';
								}
								if(g_sDropdownDisplayId !== "")
								{
									if(sDropdown === "")
										sDropdown += '<option selected="selected" value="' + json[i].name + '">' + json[i].name + '</option>';
									else 
										sDropdown += '<option value="' + json[i].name + '">' + json[i].name + '</option>';
								}
							}
							if(sTree !== "")
								document.getElementById(g_sTreeDisplayId).innerHTML = sTree;
							if(sDropdown !== "")
								document.getElementById(g_sDropdownDisplayId).innerHTML = sDropdown;
							
						}
					}
				}
			}
		}
		if(mode === 0) {
			try {
				treeView = document.getElementById("devicetree");
				if(treeView !== null) {
					toggler = document.getElementsByClassName("caret");
					if(g_bTreeView) {
						for (i = 0; i < toggler.length; i++) {
							toggler[i].addEventListener("click", function() {
							this.parentElement.querySelector(".nested").classList.toggle("active");
							this.classList.toggle("caret-down");
							});
						}
					}
				}
			}
			catch {}
			if(g_substitutionList.length > 0) {
				if(!(typeof g_substitutionList[0].displayId === "undefined")) {
					if(g_substitutionList[0].displayId !== "") {
						if(g_substitutionList[0].value === "")
							g_substitutionList[0].value = g_deviceList[0].name;
						document.getElementById(g_substitutionList[0].displayId).innerHTML = g_substitutionList[0].value;
					}
				}
			}
		}
		//create GET datapoint list
		createDpGetList(); // creates, subscribes, Get first request
		
	}
	catch {}
}
function getAllDpValues(mode) {
	var i,k;
	var url = "https://" + location.hostname + "/iap/devs/*/if/*/*/*+qualifier=-";
	try {
		if(mode === 0) {
			url += g_sInitialGetRequest + "/*?max_age=0&noxs=true";
			requestGetData(mode, url, getDpValueResponse, getDpValueResponseFailure);	
		}
		else if(g_idpGetRequestIndex !== -1) {
			if(g_dpGetRequestArr[0] !== "") {
				if(g_bUseWebSockets) {
					if(g_sWebSocketSubscribePayload === "")
						return;
					if(g_sWebSocketSubscribePayload !== g_sWebSocketSubscribePayload_oldvalue)
						subscribeRequest();
				}
				
				if(mode === 0) {
					url += g_sInitialGetRequest + "/*?max_age=0&noxs=true";	
				}
				else {
					if(g_idpGetRequestIndex === 0) {
						if((mode === 1) && g_bAtLeastOneElementUsesPriority)
							g_bGetPropertiesRequest = true;
					}
					if(g_bGetPropertiesRequest) { //123
						mode = 3;
						url += g_dpGetRequestArr[g_idpGetRequestIndex] + "/*?max_age=" + g_iMax_Age + "&noxs=true";	
					}
					else
						url += g_dpGetRequestArr[g_idpGetRequestIndex] + "/value?max_age=" + g_iMax_Age + "&noxs=true";			
					g_idpGetRequestIndex ++;
					g_iBackgroundPollingRequestCount = 0;
					if(g_idpGetRequestIndex >= g_dpGetRequestArr.length) {
						if(g_iPollingRequestCount !== -1) {
							g_iBackgroundPollingRequestCount = -1;
							g_iPollingRequestCount = 0;
						}
						else {
							g_iBackgroundPollingRequestCount = 0;
						}
						g_idpGetRequestIndex = 0;
					}
				}
			}
			requestGetData(mode, url, getDpValueResponse, getDpValueResponseFailure);
		}
	}
	catch {}
}
function getAllDpValuesResponse(mode, requestUrlString, json) {
	// used for pagination - not used at the moment
	var url;
	getNextPageInfo(mode, requestUrlString, json);
	if((g_iPaginationPage === 0) || (g_iPaginationSnapsnotNumber === 0))
	{
		getDpValueResponse(mode, requestUrlString, g_arrPaginationResponse);
		g_arrPaginationResponse = [];
		
	}
	else 
	{
		var iPtr,k;
		url = requestUrlString;
		iPtr = requestUrlString.indexOf("?pg=");
		if(iPtr > 0)
			url = requestUrlString.substr(0, iPtr);
		url += "?pg=" + g_iPaginationPage + "&sz=" + g_iPaginationPageSize + "&xs=" + g_iPaginationSnapsnotNumber;
		requestGetData(0, url, getAllDpValuesResponse, getDpValueResponseFailure);
	}
	
}
function getDpEnums() {
	try {
		var i, bAtLeastOnemore = false;
		var url = "https://" + location.hostname + "/iap/dp/types?dpTypeName=";
		if(g_dpEnumsList.length > 0) {
			for(i=0; i < g_dpEnumsList.length; i++)
			{
				if(g_dpEnumsList[i].bGet) {
					g_dpEnumsList[i].bGet = false;
					url += g_dpEnumsList[i].name;
					requestGetData(0, url, getDpEnumsResponse, getDpEnumsFailResponse);
				}
			}
		} 
	}
	catch(err) {

	}
}
function getDpEnumsResponse(mode, requestUrlString, json) {
	try {
		var i, j, k, m, n, s, sTemp = "", element;
		var url = "https://" + location.hostname + "/iap/dp/types?dpTypeName=";
		if(g_dpEnumsList.length > 0) {
			for(i=0; i < json.length; i++)
			{
				for(j=0; j < g_dpEnumsList.length; j++)
				{
					if(g_dpEnumsList[j].name === json[i].typeId) {
						g_dpEnumsList[j].enum = json[i].typeJson.enum;
						if(g_dpEnumsList[j].enum !== null) {
							try {
								for(k=0; k < g_dpEnumsList[j].dpList.length; k++)
								{
								// add enums to displayelements
									for(m=0; m < g_dpList.length; m++)
									{
										if(g_dpList[m].dpName === g_dpEnumsList[j].dpList[k]) {
											if(g_dpList[m].snvtType === g_dpEnumsList[j].name) {
												g_dpList[m].enum = g_dpEnumsList[j].enum;
												for(n=0; n < g_dpList[m].displayElements.length; n++)
												{ //123456
													if(g_dpList[m].displayElements[n].iDisplayEnums === 1) {
														g_dpList[m].displayElements[n].iDisplayEnums = 0;
														try {
															
															element = document.getElementById(g_dpList[m].displayElements[n].displayId);
															if(element != null) {
																for(s=0; s < g_dpEnumsList[j].enum.length; s++)
																{
																	sTemp += "<option";
																	if(g_dpList[m].value === g_dpEnumsList[j].enum[s].id)
																		sTemp = " selected";
																	sTemp += ">" +  g_dpEnumsList[j].enum[s].id + "</option>";
																}
																if(sTemp !== "") {
																	element.innerHTML = element.innerHTML + sTemp;
																}
															}
														}
														catch (err) {}
													}
												}
											}
										}
									}
								}
							}
							catch(err) {}
						}
					}
				}
			}
		} 
	}
	catch(err) {

	}
	getDpEnums();
}
function getDpEnumsFailResponse(mode, requestUrlString, json) {
	getDpEnums();
}
function getDpValueResponse(mode, requestUrlString, json) {
	//mode: 0=initial GET request, 1=on-demand Get value, 2=Websocket update, 3=on-demand GET properties, 5= on-demand GET properties and update value and priorities
	var iIndex = 0;
	var i,j, k, m, z, obj, index, pathName;
	var bFound = false;
	var jsFunctionIndex = -1;
	var jsonValue;
	var value = "";
	var bPriorityUpdate = false;  
	var value1 = null;
	var currentTime, currentTimeMs, presetValue = null;
	var bUpdateValue;
	g_arrDpChangeJsFunctionList = [];
	if(g_iIgnoreLastRead){
		g_iIgnoreLastRead = false;
		if(mode !== 0)
			return;
	}
	if(json !== null)
	{
		currentTime = new Date();
		currentTimeMs = currentTime.getTime();
		for(j=0; j < g_dpGetList.length; j++)
		{
			g_dpGetList[j].dpValueChanged  = false;
		}
		for(i = 0; i < json.length; i++)
		{
			try
			{
				//var dpPath = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].datapointName;
				for(j=0; j < g_dpGetList.length; j++)
				{
					if(g_dpGetList[j].dpQualifier === json[i].dpQualifier)
					{ 
						bUpdateValue = false;
						try {
							bPriorityUpdate = false;
							if((!g_bUseWebSockets) || (g_bUseWebSockets && (mode === 2))  || (mode === 0) || (mode === 5)) { 
								presetValue = null;
								if(mode === 0) {
									g_dpGetList[j].name = json[i].deviceName + "/" + json[i].blockName + "/" + json[i].blockIndex + "/" + json[i].name;
								}
								if(g_bUseLocalization) {
									if(typeof json[i].locValue === "number")
										value = json[i].locValue;
									else {
										value = JSON.stringify(json[i].locValue);
										
									}
									//var value1 = JSON.stringify(g_dpList[j].value);
									jsonValue = json[i].locValue;
								}
								else {
									if(typeof json[i].value === "number")
										value = json[i].value;
									else {
										value = JSON.stringify(json[i].value);
										
									}
									//var value1 = JSON.stringify(g_dpList[j].value);
									jsonValue = json[i].value;
								}
								
								
								value1 = g_dpGetList[j].value;
							
								if(g_dpGetList[j].feedbackTimeout > 0) {
									if(currentTimeMs > g_dpGetList[j].feedbackTimeout) {
										g_dpGetList[j].feedbackTimeout = 0;
										bUpdateValue = true;
									}
									else if (isNotEqual(jsonValue, value1) && isNotEqual(g_dpGetList[j].feedbackDelayOldValue, value1)) {
										g_dpGetList[j].feedbackTimeout = 0;
										bUpdateValue = true;
									}
								}
								
								if( (mode === 0) || bUpdateValue || ((g_dpGetList[j].feedbackTimeout === 0) && isNotEqual(jsonValue, value1)) )
								{
									if(g_dpGetList[j].feedbackTimeout > 0)
										g_dpGetList[j].feedbackTimeout = 0;
									g_dpGetList[j].value = jsonValue;
									for(k=0; k < g_dpGetList[j].dplistIndexes.length; k++) //substitution tags can cause a DP to show up more than once
									{
										z = g_dpGetList[j].dplistIndexes[k];
										if(!g_dpList[z].bGotValue)
											g_dpList[z].bGotValue = true;
										if(mode === 0) {
											g_dpList[z].snvtType = json[i].type;
											g_dpList[z].type = json[i].type;
											if(typeof json[i].value === "number")
												g_dpList[z].bNumber = true;
											else if(typeof json[i].value === "string")
												g_dpList[z].bString = true; // most likely an enum
											else 
												g_dpList[z].bStructured = true;;
											
											if(typeof json[i].presets !== "undefined")
												g_dpList[z].presets = json[i].presets;
											
											
										}
										if(typeof json[i].presetValue !== "undefined") {
											g_dpList[z].presetValue = json[i].presetValue;
											presetValue = g_dpList[z].presetValue;
										}
										updateAllDisplayElements(0, g_dpList[z].dpName, z, jsonValue, presetValue, true, false, null, null);
										
									}
								}
								else if(g_bChartsSupported) {
									// if value same as last but new timestamp
									try {
										
										for(k=0; k < g_dpGetList[j].dplistIndexes.length; k++) //substitution tags can cause a DP to show up more than once
										{
											z = g_dpGetList[j].dplistIndexes[k];
											for(m=0; m < g_dpList[z].displayElements.length; m++)
											{
												if(g_dpList[z].displayElements[m].displayType === "chart") {
													index = g_dpList[z].displayElements[m].dashboardDpListIndex;
													pathName = g_dpList[z].dpName;
													_chartNewUpdateSameValueDifferentTime(index, pathName,value,presetValue, currentTimeMs);
												}
											}
										}
									}
									catch {}
								}
							}
							if((mode === 0) || (mode === 3) || (mode === 5)) {
								// check if prioity values changed.
								
								if(typeof json[i].values !== "undefined") {
									
									if((mode === 0) || (isNotEqual(g_dpGetList[j].values, json[i].values))) {
										g_dpGetList[j].values = json[i].values;
										g_dpGetList[j].priority = json[i].values.level;

										for(k=0; k < g_dpGetList[j].dplistIndexes.length; k++) //substitution tags can cause a DP to show up more than once
										{
											z = g_dpGetList[j].dplistIndexes[k];
											g_dpList[z].values = json[i].values;
											g_dpList[z].priority = json[i].values.level;

											updateAllDisplayElements(0, g_dpList[z].dpName, z, null, null, false, true, null, null);
										}
									}
								}
							}
							break;
						} catch(err) {}
						
					}
				}
			}
			catch(err)
			{}
		}
		processJsFunctions(); // need all Dp objects updated first, contains a list of jsFunctions that had at least one DP value changed
		if(mode === 0) {
			g_bInitializing = false;
			g_iBackgroundPollingRequestCount = 0;
			for(i=0; i <g_dpList.length; i++)
			{
				if(g_dpList[i].getDpEnums) {
					g_dpList[i].getDpEnums = false;
					z = -1;
					for(j=0; j < g_dpEnumsList; j++)
					{
						if(g_dpList[i].snvtType === g_dpEnumsList[j].name) {
							z = j;
							break
						}
					}
					if(z === -1) {
						obj = {};
						obj.name = g_dpList[i].snvtType;
						obj.bGet = true;
						obj.enum = [];
						obj.dpList = [];
						obj.dpList.push(g_dpList[i].dpName);
						g_dpEnumsList.push(obj);
					}
					else 
						g_dpEnumsList[j].dpList.push(g_dpList[i].dpName);
					
				}
			}
			if(g_dpEnumsList.length > 0) {
				getDpEnums();
			}
			if(g_timerVar === null)
				g_timerVar = setInterval(timerHandler, g_timerInterval);
			
		}
	}
}
function getDpValueResponseFailure(mode, requestUrlString, json) {
}
function getNextPageInfo(mode, requestUrlString, json) {
	// 
		// get how many more pages
	var iSnapshot = json['snapshot'];
	var resources = json['resources'];
	if(resources.length === 0)
	{ // no data
		g_bReadInProgress = false;
			g_iPaginationPage = 0;
		return;
	}
	else
		g_arrPaginationResponse = g_arrPaginationResponse.concat(resources); // Get results
	var pagesLeft = json['remainingPages'];
	
	if(g_iPaginationPage > 1)
	{
		if(iSnapshot !== g_iPaginationSnapsnotNumber)
		{ // error wrong snapshot so wrong data
			g_bReadInProgress = false;
			g_iPaginationPage = 0;
			return;
		}
	}
	else 
		g_iPaginationSnapsnotNumber = iSnapshot;
	if(pagesLeft === 0)	
	{
		g_bReadInProgress = false;
		g_iPaginationPage = 0;
	}
	else 
		g_iPaginationPage ++;	
}
function getInitialAllDpValues() {
	
	var i,k;
	var sUrlTag = "";
	var bMaxAge = false;
	var bOneTime = false;
	g_iCurrentTagListPtr = -1;
	// check if all initial TAG GET requests processed
	for(i=0; i < g_arrTagList.length; i ++) 
	{
		if(g_arrTagList[i].bInitialRequest) {
			g_iCurrentTagListPtr = i;  // used by checkIfTagAssignedToDp()
			sUrlTag = g_arrTagList[i].urlTag;
			bMaxAge = g_arrTagList[i].useMaxAge;
			//g_arrTagList[i].bInitialRequest = false;
			
			if(g_arrTagList[g_iCurrentTagListPtr].name === "maxageonetime") {
				bOneTime = true;
			}
			break;
		}
	}
	if(sUrlTag === "") { // all GET tags processed
		g_iCurrentTagListPtr = -1; // now used by timer
		g_bAddTagToDatapoints = false; // no more GET tags to process
			// start maxage onetime timeout -- needed as requires initial request to send max_age to poll Device and second to read new value
		for(i=0; i < g_arrTagList.length; i ++) 
		{
			if(g_arrTagList[i].name === "maxageonetime") {
				g_dtMaxAgeOneTimeTimeout = new Date(Date.now() + 10000); 
				break;
			}
		}
		return;
	}
	
	g_iPaginationPage = 1; // Used for GET pagination
	g_arrPaginationResponse = [];
	var url = "https://" + location.hostname; // + ":8443";
	//url += "/iap/devs/*/if/*/*/*+tag==" + g_sUrlTag + "/value?pg=1&sz=" + g_iPaginationPageSize;
	url += "/iap/devs/*/if/*/*/*+tag==" + sUrlTag + "/value?pg=1&sz=" + g_iPaginationPageSize;
	if(bMaxAge) {
		if(g_iMax_Age >= 0) {
			url += "&max_age=";
			if(bOneTime)
				url += "0";
			else
				url += g_iMax_Age;
		}
	}
	requestGetData(0, url, getInitialAllDpValuesResponse, getInitialAllDpValuesResponseFailure);
	
}
function getInitialAllDpValuesResponse(mode, requestUrlString, json) {
	getNextPageInfo(mode, requestUrlString, json);
	if((g_iPaginationPage !== 0) && (g_iPaginationSnapsnotNumber !== 0))
	{
		var iPtr,k;
		url = requestUrlString;
		iPtr = requestUrlString.indexOf("?pg=");
		if(iPtr > 0)
			url = requestUrlString.substr(0, iPtr);
		url += "?pg=" + g_iPaginationPage + "&sz=" + g_iPaginationPageSize + "&xs=" + g_iPaginationSnapsnotNumber;
		requestGetData(0, url, getInitialAllDpValuesResponse, getDpValueResponseFailure);
	}
	else
	{
		//removeUnwantedDps(g_arrPaginationResponse);
		getDpValueResponse(mode, requestUrlString, g_arrPaginationResponse);
		checkIfTagAssignedToDp(g_arrPaginationResponse); // start check
		g_arrPaginationResponse = [];
		getInitialAllDpValues(); // check for next GET tag, upto 4 tags
	}
	
}
function getInitialAllDpValuesResponseFailure(mode, requestUrlString, json) {
	g_bRetryInitialGetRequest = true;
}
function getInitialSingleDpValueResponse(mode, requestUrlString, json) {
	getDpValueResponse(mode, requestUrlString, json);
	
}
function getSingleDpValueResponse(mode, requestUrlString, json) {
	getDpValueResponse(mode, requestUrlString, json);
	
}
function getSingleDpValueResponseFailure(mode, requestUrlString, json) {
}
function getSmartServerVersion(bGetDeviceList) {
	var url = "https://" + location.hostname + "/iap/version";
	var mode = 1;
	if(bGetDeviceList)
		mode = 0;
	requestGetData(mode, url, getSmartServerVersionCallback, null); // paginagion does't work on device list get Device list
}
function getSmartServerVersionCallback(mode, requestUrlString, json) {
	
	var versionList;
	try { 
		g_iSmartServerVersion = json.value;
		versionList = g_iSmartServerVersion.split(".")
		g_iSmartServerVersion = (Number(versionList[0]) * 100000) + (Number(versionList[1]) * 1000) + Number(versionList[2]); 
		if(mode === 0)
			getDeviceList();
		else 
			getDevice();
		
	}
	catch (err) {}
	
}
function findDpIndex(dpName) {
	var dpIndex = -1; // -1=not found
	var i;
	for(i=0; i < g_dpList.length; i ++)
	{
		if(g_dpList[i].dpName === dpName) {
			dpIndex = i;
			break;
		}
	}
	return dpIndex;
}
function findDpIndexFromSubstitutionDpName(dpName) {
	var dpIndex = -1; // -1=not found
	var i;
	for(i=0; i < g_dpList.length; i ++)
	{
		if(g_dpList[i].substitutionDpName === dpName) {
			dpIndex = i;
			break;
		}
	}
	return dpIndex;
}
function findDpNameFromSubstitutionDpName(dpName) {
	var name = dpName; // -1=not found
	var i;
	for(i=0; i < g_dpList.length; i ++)
	{
		if(g_dpList[i].substitutionDpName === dpName) {
			name = g_dpList[i].dpName;
			break;
		}
	}
	return name;
}
function findDpIndexByDisplayId(displayId) {
	var dpIndex = -1; // -1=not found
	var i,j;
	for(i=0; i < g_dpList.length; i ++)
	{
		for(j=0; j < g_dpList[i].displayElements.length; j ++)
		{
		
			if(g_dpList[i].displayElements[j].displayId === displayId) {
				dpIndex = i;
				i = g_dpList.length + 5;
				break;
			}
		}
	}
	return dpIndex;
}

function findDisplayIndexByDisplayId(displayId) {
	var dpIndex = {}; // -1=not found
	var i,j;
	for(i=0; i < g_dpList.length; i ++)
	{
		for(j=0; j < g_dpList[i].displayElements.length; j ++)
		{
		
			if(g_dpList[i].displayElements[j].displayId === displayId) {
				dpIndex.dpListIndex = i;
				dpIndex.displayElementsIndex = j;
				i = g_dpList.length + 5;
				break;
			}
		}
	}
	return dpIndex;
}
function inputBoxKey(n, e) {
		//alert("onKey");
	var evtobj=window.event? event : e; // distiguish between IE explicit event an Firefox implicit
	var unicode = evtobj.char? evtobj.charCode : evtobj.keyCode;
	var actualkey=String.fromCharCode(unicode);
		//alert("key [" + unicode + "]: " + actualkey);
	if (unicode === 13)
	{ // enter key causes datapoint change
		inputBoxValueChanged(n)
	}
	
}

function inputBoxValueChanged(n) {
	var displayId = "";
	var dpIndex = -1, displayElementIndex = -1;
	var readDp = "";
	var writeDp = "";
	var fieldValue = "";
	var valueStr = "";
	var value1 = "";
	var field = "";
	var bContinue = true;
	var snvtType = "";
	var i, j;
	
	
	try {

		if(g_dpList.length === 0)
			return;
		
		displayId = n.id;
		for(i=0; i < g_dpList.length; i++)
		{
			for(j=0; j < g_dpList[i].displayElements.length; j++)
			{
				if(g_dpList[i].displayElements[j].displayId === displayId) {
					dpIndex = i;
					displayElementIndex = j;
					readDp = g_dpList[i].dpName;
					writeDp = g_dpList[i].displayElements[j].writeDp;
					if(writeDp === "")
						writeDp = readDp;
					field = g_dpList[i].displayElements[j].field;
					snvtType = g_dpList[i].snvtType;
					valueStr = document.getElementById(displayId).value;
					try {
						if(field !== "") {
							value = g_dpList[i].value;
							if(typeof value[field] === "number")
								valueStr = Number(valueStr);
							value[field] = valueStr;
							valueStr = JSON.stringify(value);
						}
						else {
							if(typeof value === "number")
								valueStr = Number(valueStr);
							else if(g_dpList[i].bStructured) {
								valueStr = "{" + valueStr + "}";
							}
							
						}
						
					}
					catch { bContinue = false; }
					i = g_dpList.length + 5;
					break;
				}
			}
		}
	
		
		if(bContinue) {
			
			
			if(typeof validateData === "function")
			{ // user provided function to check for valid data
				try {
					if(!validateData(0, readDp, displayId, snvtType, field, valueStr)) {
						//
						alert("Error: incorrectly formated value:\r\n\r\n" + valueStr);
						return;
					}
				}
				catch {}
			}
			if(writeDp !== "")
				requestWriteData(writeDp, valueStr);
		}
		
	} catch (err) {}
}
function isNotEqual (obj1, obj2) {
	return !isEqual(obj1, obj2);
}
function isEqual(obj1, obj2) {
	try {
		var newObj1, newObj2;
		var i, len1, len2;
		var objKeys;
		var key;
		if(obj1 === null) {
			if(obj2 === null)
				return true;
			else 
				return false;
		}
		else if(obj2 === null)
			return false;
		
		if(typeof obj1 !== typeof obj2)
			return false;
		if(Array.isArray(obj1)) {
			if(obj1.length !== obj2.length)
				return false; 
			for(i = 0; i < obj1.length; i ++)
			{
				
				if(!isEqual(obj1[i], obj2[i]))
					return false;
			}
			return true;
		}
		else if (typeof obj1 === "object") {
			len1 = Object.keys(obj1).length;
			len2 = Object.keys(obj2).length;
			if(len1 !== len2)
				return false; 
			for(i = 0; i < len1; i ++)
			{
				key = Object.keys(obj1)[i];
				if(obj2.hasOwnProperty(key)) {
					if(!isEqual(obj1[key], obj2[key]))
						return false; 
				}
				else 
					return false;
			}
			return true;
		}
		else if(obj1 === obj2)
			return true;
		else 
			return false;
	}
	catch { return false; }
}
function login() {
	var loginUrl = "https://" + window.location.hostname + "/user/login.html?next=";
	loginUrl += document.URL; //document.location;
	window.open(loginUrl,'_self',false);
} 
function logout() {
	var logoutUrl = "https://" + window.location.hostname + "/iap/auth/logout";
	requestWritePostData(0, logoutUrl, "", null, null);
	login();
} 
function priorityDropdown(n) {
	// only used in case user touches priority by mistake, just show current value.
	try {

	}
	catch (err) {}
}
function processJsFunctions() {
	// process any jsFunction which has at least one Dp value changed
	//  g_arrDpChangeJsFunctionList list all jsFunctions that had at least one DP value changed
	try 
	{
		var i,j,k ;
		var jsFunctionIndex;
		var dpListIndex;
		var dpList;
		if(g_arrDpChangeJsFunctionList === null)
			return;
		if(g_arrDpChangeJsFunctionList.length > 0) {
			
			for(i=0; i < g_arrDpChangeJsFunctionList.length; i++)
			{
				jsFunctionIndex = g_arrDpChangeJsFunctionList[i];
				
				for(j=0; j < g_arrJsFunctionList.length; j++)
				{
					if(jsFunctionIndex === g_arrJsFunctionList[j].id) {
						if(g_arrJsFunctionList[j].dpList !== null) {
							// clear change flag -- only indicates that DP value changed, not if field changed
							for(k=0; k < g_arrJsFunctionList[j].dpList.length; k++)
							{ 
								g_arrJsFunctionList[j].dpList[k].dpValueChanged = false;
							}
							for(k=0; k < g_arrJsFunctionList[j].dpList.length; k++)
							{ 
								dpListIndex = g_arrJsFunctionList[j].dpList[k].dpListIndex;
								if(g_arrJsFunctionList[j].dpList[k].dpName === g_dpList[dpListIndex].dpName) {
									g_arrJsFunctionList[j].dpList[k].dpValueChanged = g_dpList[dpListIndex].dpValueChanged;
									g_arrJsFunctionList[j].dpList[k].value = g_dpList[dpListIndex].value;
									g_arrJsFunctionList[j].dpList[k].presetValue = g_dpList[dpListIndex].presetValue;
								}
							}
							try 
							{
								g_arrJsFunctionList[j].function(g_arrJsFunctionList[j].jsFunctionParameters, g_arrJsFunctionList[j].displayId, 
									g_arrJsFunctionList[j].dpList);
							}
							catch(e) 
							{
								var sErr = e;
							}
						}
					}
				}
			}
		}
	}
	catch (e) {}
	g_arrDpChangeJsFunctionList = [];
}
function readFailCallback(mode, requestUrlString, status){
	// dummy callback
}
function requestGetData(mode, requestUrlString, callback, failCallback) {
	try
	{
		var i,k;
		var bNoPagination = true;
		g_bReadInProgress = true; // if no pagination, get set to false after response, for pagination cleared after last response
		if(requestUrlString.includes("&sz="))
			bNoPagination = false;
		
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status === 200) {
				// success
				if(bNoPagination)
					g_bReadInProgress = false;
				g_iRequestErrCount = 0;
				var json = null;
				if(this.responseText !== "")
					json = JSON.parse(this.responseText); 
				if(callback && typeof(callback) === "function") {
					callback(mode, requestUrlString,  json);
				}
			}
			else if(xhr.readyState === 4 && xhr.status === 401)
			{  // not logged in
				g_bReadInProgress = false;
				g_iRequestErrCount ++;
				//alert(xhr.status + ", " + xhr.statusText); 
				if(g_iRequestErrCount >= g_iRequestMaxErr)
					clearTimeout(g_timerVar);
				login();
			}
			else if(xhr.readyState === 4 && xhr.status === 404)
			{ // not found
				g_bReadInProgress = false;
				g_iRequestErrCount ++;
				//alert(xhr.status + ", " + xhr.statusText); 
				if(g_iRequestErrCount >= g_iRequestMaxErr)
					clearTimeout(g_timerVar);
				if(failCallback && typeof(failCallback) === "function") {
					failCallback(mode, requestUrlString,  xhr.status);
				}
			}
			else if(xhr.readyState === 4)
			{
				g_bReadInProgress = false;
				g_iRequestErrCount ++;
				if(g_iRequestErrCount >= g_iRequestMaxErr)
					clearTimeout(g_timerVar);
				if(failCallback && typeof(failCallback) === "function") {
					failCallback(mode, requestUrlString, xhr.status);
				}
			}					
		};
		xhr.open("GET", requestUrlString, true);
		xhr.send();
	}
	catch(err) {}	
}
function requestWriteData(dpName, payload) {
	requestWriteDataWithPriority2Dps(dpName, payload, null, null);
}
function requestWriteData2Dps(dpName, payload, outputDpName) {
	requestWriteDataWithPriority2Dps(dpName, payload, null, outputDpName);
}
function requestWriteDataWithPriority(dpName, payload, priority) {
	requestWriteDataWithPriority2Dps(dpName, payload, priority, null);
}
function requestWriteDataWithPriority2Dps(dpName, payload, priority, outputDpName) {
	// All Modbus, all BACnet, and many LON html elements have a single datapoint.
	// Since many LON input datapoints have a feedback html elements for these inputs may display the feedback (output) datapoints but use the input to make a change
	// For html elements with two datapoints, you need to provide a feedback timout for both the input and output datapoint otherwise you will see the html flicker back and forth between values  
	try  //Supports substitution tags
	{
		var i, j;
		var deviceName, datapointName, priorityValue = null, presetValue = null, presetValue_value = null, bIsPresetValue = false;
		var bWriteToDpGetList = true;
		var payloadJson = payload; // payload can be a string
		var bWriteIsPreset = false;
		var currentTime = new Date();
		var dpIndex = findDpIndex(dpName)
		var url = "https://" + location.hostname + "/iap/devs/*+name==";
		var iPtr = dpName.indexOf("/");
		var sWriteType = "value";
		
		
		if(typeof payload === "string") {
			for(i=0; i < g_dpList.length; i ++)
			{
				if(g_dpList[i].dpName === dpName) {
					if(g_bPresetsSupported) {
						if(typeof g_dpList[i].presets !== "undefined") {
							if(typeof g_dpList[i].presets !== null) {
								if(typeof g_dpList[i].presets.map !== "undefined") {
									if(typeof g_dpList[i].presets.map !== null) {
										if(g_dpList[i].presets.map.length > 0) {
											if(payload.charAt(0) !== "{") {
												for(j=0; j < g_dpList[i].presets.map.length; j++)
												{
													if(g_dpList[i].presets.map[j].name.toLowerCase() === payload.toLowerCase()) {
														presetValue = g_dpList[i].presets.map[j].name;
														presetValue_value = g_dpList[i].presets.map[j].value;
														payload = presetValue;
														bIsPresetValue = true;
														i = g_dpList.length + 2; // break out of for(i loop
														break;

													}
												}
											}
										}
									}
								}
							}
						}
					}
					if(!bIsPresetValue){
						if(g_dpList[i].bNumber) {

						}
						else if(g_dpList[i].bString) {
							payload = "\"" + payload + "\"";  // needed for enumerations
						}
					}
				}
			}
		}
		
		if((g_iWritePriority > 0) && (g_iWritePriority < 18))
			priority = g_iWritePriority;
		if(priority === null) {
			if((g_iWritePriorityDefault > 0) && (g_iWritePriorityDefault < 18))
				priority = g_iWritePriorityDefault;
		}
		
		if( iPtr !== 0) {
			deviceName = dpName.substr(0, iPtr);
			deviceName = deviceName.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			datapointName = dpName.substr(iPtr + 1);
			datapointName = datapointName.replace(/ /g,"%20").replace(/\[/g,"%5B").replace(/\]/g,"%5D");
			if(g_iSmartServerVersion >= 320000) {
				datapointName = _addIfandXifNameToDatapointName(datapointName); // adds *+xifName==
			}
			if(priority === null) {
				if(bIsPresetValue) 
					url += deviceName + "/if/" + datapointName + "/presets/value";
				else if(g_bUseLocalization)
					url += deviceName + "/if/" + datapointName + "/localization/value";
				else
					url += deviceName + "/if/" + datapointName + "/value";
			}
			else {
				if(bIsPresetValue) 
					url += deviceName + "/if/" + datapointName +  "/overrides/" + priority + "/presets/value";
				else if(g_bUseLocalization)
					url += deviceName + "/if/" + datapointName +  "/overrides/" + priority + "/localization/value";
				else
					url += deviceName + "/if/" + datapointName +  "/overrides/" + priority + "/value";
			}

			requestWritePutData(0, url, payload, null, null);
			g_iIgnoreLastRead = true; // used to reduce the chance of the value fliping back and forth between new, old and then new value.
			if(bIsPresetValue) {
				payload = presetValue_value;
			}
			requestWriteDataWithPriority2UpdateDisplaysAndAddFeedback(0, dpName, payload, payloadJson, presetValue, currentTime);
			if(outputDpName !== null)
				requestWriteDataWithPriority2UpdateDisplaysAndAddFeedback(1, outputDpName, payload, payloadJson, presetValue, currentTime);
			processJsFunctions(); // need all Dp objects updated first, contains a list of jsFunctions that had at least one DP value changed
		}
		
	}
	catch(e) {}
}
function requestWriteDataWithPriority2UpdateDisplaysAndAddFeedback(mode, dpName,payload, payloadJson, presetValue,currentTime) {
	// mode: 0=update priority, 1=don't update priority
	var bWriteToDpGetList = true;
	var oldValue;
	var i,j;
	try {
		for(i=0; i < g_dpList.length; i++)
		{
			if(g_dpList[i].dpName === dpName) {  // a datapoint name may show up more than once if substitution tags are used
				oldValue = g_dpList[i].value;
				g_dpList[i].value = payload; //"{" + value + "}";
				g_dpList[i].presetValue = presetValue;
				g_dpList[i].writeTimestamp = currentTime.toLocaleString(); // 
				g_dpList[i].feedbackTimestamp = currentTime.getTime() + g_iFeedbackDelayTime; // feedback delay to eliminate flicker
				if(bWriteToDpGetList) {
					for(j=0; j < g_dpGetList.length; j++)
					{
						if(g_dpGetList[j].dpQualifier === g_dpList[i].dpQualifier) {
							g_dpGetList[j].feedbackTimeout = currentTime.getTime() + g_iFeedbackDelayTime;
							g_dpGetList[j].feedbackDelayOldValue = g_dpGetList[j].value;
							
							bWriteToDpGetList = false;
							if(typeof payload === "number")
								g_dpGetList[j].value = payload;
							else {
								g_dpGetList[j].value = JSON.parse(payload);
								payloadJson = g_dpGetList[j].value;
							}
							break;
						}
					}
				}
				updateAllDisplayElements(1, dpName, i, payloadJson, presetValue, true, false, null, null);
				if(mode === 0) { 
					//html elements that have an input and output datapoint, only update priority for input datapoint
					if(priority !== null) {
						if(priority < g_dpList[i].values.level) {
							g_dpList[i].priority = priority;
							g_dpList[i].values.level = priority;
						}
						priorityValue = payload;
						if(typeof payload === "string")
							priorityValue = JSON.parse(payload);
						
						g_dpList[i].values.levels[priority] = priorityValue;
						updateAllDisplayElements(1, dpName, i, null, null, false, true, null, null); 
					}
				}
			}
		}
	}
	catch {}
}

function requestWritePutData(mode, requestUrlString, payload, callback, failCallback) {
	// PUT
	try
	{
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status === 204) {
				// Write successful
				if(callback && typeof(callback) === "function") {
					callback(mode, requestUrlString);
				}
			}
			else if(xhr.readyState === 4 && xhr.status === 401)
			{
				login();
			}
			else if(xhr.readyState === 4)
			{
				if(failCallback && typeof(failCallback) === "function") {
					failCallback(mode, requestUrlString, xhr.status);
				}
			}
		};
		xhr.open("PUT", requestUrlString, true);
		xhr.setRequestHeader('Content-type','application/json; charset=utf-8');
		xhr.send(payload);
	}
	catch (err) {}
}
function requestWritePutDataFailureResponse(mode, requestUrlString, json) {
	// Currently not used
	try
	{
		
	}
	catch (err) {}
}
function requestWritePostData(mode, requestUrlString, payload, callback, failCallback) {
	try
	{
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status === 204) {
				// Write successful
				if(callback && typeof(callback) === "function") {
					callback(mode, requestUrlString);
				}
			}
			else if(xhr.readyState === 4 && xhr.status === 401)
			{
				login();
			}
			else if(xhr.readyState === 4)
			{
				//alert(xhr.status + ", " + xhr.statusText);
				if(failCallback && typeof(failCallback) === "function") {
					failCallback(mode, requestUrlString, xhr.status);
				}
			}
		};
		xhr.open("POST", requestUrlString, true);
		xhr.setRequestHeader('Content-type','application/json; charset=utf-8');
		xhr.send(payload);
	}
	catch (err) {}
}
function requestDeleteData(mode, requestUrlString, payload, callback, failCallback) {
	try
	{
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function() {
			if (xhr.readyState === 4 && xhr.status === 204) {
				// Write successful
				if(callback && typeof(callback) === "function") {
					callback(mode, requestUrlString);
				}
			}
			else if(xhr.readyState === 4 && xhr.status === 401)
			{
				login();
			}
			else if(xhr.readyState === 4)
			{
				if(failCallback && typeof(failCallback) === "function") {
					failCallback(mode, requestUrlString, xhr.status);
				}
			}
		};
		xhr.open("DELETE", requestUrlString, true);
		xhr.setRequestHeader('Content-type','application/json; charset=utf-8');
		xhr.send(payload);
	}
	catch (err) {}
}
function setTagResponse(mode, url){
	
}
function showDevice(n) {
	g_sDevice = n.innerHTML;
	document.getElementById("deviceName").innerText = g_sDevice;

}
function showDropdownDevice(n,substitutionTag) {
	try {
		// select device
		var substitutionValue = n.value;
		var i;
		for(i=0; i <  g_substitutionList.length; i++) 
		{
			if(g_substitutionList[i].name === substitutionTag) {
				if(g_substitutionList[i].value !== substitutionValue) {
					g_substitutionList[i].value = substitutionValue;
					if(!(typeof g_substitutionList[i].displayId === "undefined")) {
						if(g_substitutionList[i].displayId !== "") {
							document.getElementById(g_substitutionList[i].displayId).innerHTML = substitutionValue;
						}
					}
					clearOldHtmlElements();
					createDpGetList();
					break;
				}
			}

		}
	}
	catch {}
}
function showPriorityArrayAlert(displayId) {
	//displayId = any displayId for the datapoint you are interested in
	var keys, dpInfo,sTemp1,i, levels;
	var sTemp = "", bAddComma = false;
	try {
		if(displayId === null)
			return;
		if(displayId === "")
			return;
		dpInfo = currentDpValueByElementId(displayId);  // returns an object with dp to write to and current value that needs to be swapped
		if(dpInfo !== null){
			if(dpInfo.dpName !== "") {
				sTemp = dpInfo.name;
				
				if(dpInfo.values !== null) {
					sTemp += "\r\n\r\nCurrent Priority: ";
					if(dpInfo.values.level === 17)
						sTemp += "Normal";
					else
						sTemp += dpInfo.values.level;
					sTemp += "\r\n\r\nActive Priorities:";
					keys = Object.keys(dpInfo.values.levels)
					levels = dpInfo.values.levels;
					if(dpInfo.values.level === 17)
						sTemp += " none";
				
					for(i=0; i < keys.length; i++)
					{
						
						if(keys[i] !== "17") {
							if(bAddComma)
								sTemp += ",";
							else
								bAddComma = true;
							sTemp += "\r\n\t" + keys[i] + ": ";
						}
						else 
							sTemp += "\r\n\r\nnormal: ";
						if(typeof levels[keys[i]] === "number")
							sTemp += levels[keys[i]];
						else if(typeof levels[keys[i]] === "string") {
							if(levels[keys[i]].length > 50) 
								sTemp += levels[keys[i]].substr(0,50) + " ...";
							else
								sTemp += levels[keys[i]];
						}
						else if (typeof levels[keys[i]] === "object") {
							sTemp1 = JSON.stringify(levels[keys[i]]);
							if(sTemp1.length > 50) 
								sTemp += sTemp1.substr(0,50) + " ...";
							else
								sTemp += sTemp1;
						}
					}
					sTemp += "\r\n\r\n";
				}
				else
					sTemp += "\r\n\r\nNo Priority array available";
				alert("Priority Array: " + sTemp);
			}
			else 
				alert("Error: Datapoint name not specified");
		}
		else
			alert("Error: dpInfo = null");
	}
	catch(err) {}
}
function _showPriorityArrayRelinquishAll(n) {
	//displayId = any displayId for the datapoint you are interested in
	var keys, dpInfo,sTemp1,i, levels, displayId = null;
	var sTemp = "Relinquish Priority Overrides\r\n\r\n", bAddComma = false;
	try {
		displayId = n.id;
		if(displayId === null)
			return;
		if(displayId === "")
			return;
		dpInfo = currentDpValueByElementId(displayId);  // returns an object with dp to write to and current value that needs to be swapped
		if(dpInfo !== null){
			if(dpInfo.dpName !== "") {
				sTemp += dpInfo.name;
				
				if(dpInfo.values !== null) {
					sTemp += "\r\n\r\nCurrent Priority: ";
					if(dpInfo.values.level === 17)
						sTemp += "Normal";
					else
						sTemp += dpInfo.values.level;
					sTemp += "\r\n\r\nActive Priorities:";
					keys = Object.keys(dpInfo.values.levels);
				
					levels = dpInfo.values.levels;
					if(dpInfo.values.level === 17)
						sTemp += " none";
					for(i=0; i < keys.length; i++)
					{
						
						if(keys[i] !== "17") {
							if(bAddComma)
								sTemp += ",";
							else
								bAddComma = true;
							sTemp += "\r\n\t" + keys[i] + ": ";
							if(dpInfo.values.level === 17)
								break;
						}
						else 
							sTemp += "\r\n\r\nnormal: ";
						if(typeof levels[keys[i]] === "number")
							sTemp += levels[keys[i]];
						else if(typeof levels[keys[i]] === "string") {
							if(levels[keys[i]].length > 50) 
								sTemp += levels[keys[i]].substr(0,50) + " ...";
							else
								sTemp += levels[keys[i]];
						}
						else if (typeof levels[keys[i]] === "object") {
							sTemp1 = JSON.stringify(levels[keys[i]]);
							if(sTemp1.length > 50) 
								sTemp += sTemp1.substr(0,50) + " ...";
							else
								sTemp += sTemp1;
						}
					}
					sTemp += "\r\n\r\n";
				}
				else
					sTemp += "\r\n\r\nNo Priority array available";
				
				
				if(g_sPriorityRelinquishPermissionsString !== "")
					sTemp += "\r\nRelinquish Permissions: " + g_sPriorityRelinquishPermissionsString;
				sTemp += "\r\n\r\nPress:\r\n\tOK - to relinquish all active priority overrides\r\n\tCancel - to cancel request"
				if(confirm(sTemp)) { 
					_clearOverrides(n, 'b');
				}
			}
			else 
				alert("Error: Datapoint name not specified");
		}
		else
			alert("Error: dpInfo = null");
	}
	catch(err) {}
}
function showTreeDevice(n,substitutionTag) {
	try {
		// li device
		var substitutionValue = n.innerHTML;
		var i;
		for(i=0; i <  g_substitutionList.length; i++) 
		{
			if(g_substitutionList[i].name === substitutionTag) {
				if(g_substitutionList[i].value !== substitutionValue) {
					g_substitutionList[i].value = substitutionValue;
					if(!(typeof g_substitutionList[i].displayId === "undefined")) {
						if(g_substitutionList[i].displayId !== "") {
							document.getElementById(g_substitutionList[i].displayId).innerHTML = substitutionValue;
						}
					}
					clearOldHtmlElements();
					createDpGetList();
					break;
				}
			}

		}
	}
	catch {}
}
function subscribeRequest() {  
	// used to speed up 
	// see if any of the datapoints have a category of d2
	if(g_sWebSocketSubscribePayload === "")
		return;
	var url = "https://" + location.hostname; // + ":8443";
		url += "/iap/dp/updates/subscribe";
	
	g_sWebSocketSubscribePayload_oldvalue =	g_sWebSocketSubscribePayload;
	var Rsp = requestPutData(0, url, g_sWebSocketSubscribePayload,  ivSubScribeCallback, null); 

}
function ivSubScribeCallback(mode, requestUrlString, json){
	g_bNeedToSubscribe = false;
	
}
function timerHandler () {
	
	try {
		if(g_bInitializing)
			return;
		if(g_iBackgroundPollingRequestCount !== -1)
			g_iBackgroundPollingRequestCount ++;  // used for GET request rate 
		if(g_iPollingRequestCount !== -1)
			g_iPollingRequestCount ++; // used for background ondemamdn request controlled by poll rate
		if(g_bReadInProgress)
		{	// needed for fast updates, otherwise user interface gets locked out
			g_iReadInProgressCount ++;
			if(g_iReadInProgressCount > 60)
				g_iReadInProgressCount = 0;
			else
				return;
					
		}
		if(g_iRequestErrCount !=0)
		{
			g_iRequestErrCount ++;  // 
			if(g_iRequestErrCount > g_iRequestMaxErr)
				g_iRequestErrCount = 0; // may also need to restart timer
		}
		if((!g_bReadInProgress) && (g_iRequestErrCount === 0))
		{
			if(g_iSlowPollingRequestCount !== -1) { // slow background polling (e.g., once an hour)
				if(g_iSlowPollingRequestCount > g_iSlowPollingRequestCountMax){
					g_iSlowPollingRequestCount = 0; // next timer tick go get request - only set to zero when complete
					g_iPollingRequestCount = 0;
					getAllDpValues(4); // not supported yet
				}
			}  // used when ondemand DP request and there are more than 10 dps
			else if(g_iPollingRequestCount !== -1) { // normal background polling
				if(g_iPollingRequestCount > g_iPollingRequestCountMax){
					g_iPollingRequestCount = 0; // next timer tick go get request
					g_iBackgroundPollingRequestCount = (g_iBackgroundPollingRequestCountMax + g_iBackgroundPollingRequestExtended + 10)
				}
			}  // used when ondemand DP request and there are more than 10 dps
			if(g_iBackgroundPollingRequestCount !== -1) { // minumum delay between GET requests
				// Each Ondemand request or background polling may require
				if((g_iBackgroundPollingRequestCount >= (g_iBackgroundPollingRequestCountMax + g_iBackgroundPollingRequestExtended))
						&& g_bServerOnline) {
					g_iBackgroundPollingRequestCount = 0;
					getAllDpValues(1);
					
				}
			}
		}
	}
	catch {}
}
function updateAllDisplayElements(mode, dpName, dpListIndex, value, presetValue, bUpdateValue, bUpdatePriority, priority, priorityValues) {
	// mode: not used anymore  /0= check feedback writeTimeptamp, 1=ignore feedback writeTimestamp
	// bUpdateValue: 
	//       If using WebSockets: set true if WebSocket response, set to false for GET responses except first GET response which is used to setup graphics.
	//       If not using WebSockets: Set to true for GET response
	// bUpdatePriority:  only GET with datapoint properties have priority info, Websockets and GET value don't include priority info
	//                  Set to true if using priorities when writing to datapoint values
	// priority: only used when writing to datapoint
	// value: json number, string or number
	try {
		var k, s, z, jsFunctionIndex, iIndex, iPtr;
		var j = dpListIndex;
		var json;
		var value1 = value, element, sTemp, sTemp1, valueStr, origValue, origValueStr, origPresetValue;
		var obj;
		var element;
		var bActive, priorityNum, bVisibility, bContiue = true; 
		var d = new Date();
		var currentTimeMs = d.getTime();
		var t = d.toTimeString();
		var currentTime = d.getFullYear().toString() + "-" +  (d.getMonth() + 1).toString().padStart(2,0) + "-" + d.getDate().toString().padStart(2,0);
		var currentTime1 = currentTime + "T";
		var utcTime = d.toUTCString();
		currentTime += " ";
		iPtr = t.indexOf(" ");
		t = t.substr(0, iPtr);
		currentTime += t + ".000";
		currentTime1 += t + ".000Z[UTC]"; 

		if(!g_bUseWebSockets)
			bUpdateValue = true;
		if(j === null)
			j = findDpIndex(dpName);
		if((value === null) && (presetValue === null)) {
			value = g_dpList[j].value;
			valueStr = g_dpList[j].valueStr;
			presetValue = g_dpList[j].presetValue;
		}
		else if(presetValue !== null) {
			if(g_bPresetsSupported) {
				if(presetValue !== null) {
					
					if(typeof g_dpList[j].presets !== "undefined") {
						if(typeof g_dpList[j].presets.map !== "undefined") {
							for(z=0; z < g_dpList[j].presets.map.length; z++)
							{
								if(g_dpList[j].presets.map[z].name.toLowerCase() === presetValue.toLowerCase()) {
									value = g_dpList[j].presets.map[z].value;
									g_dpList[j].presetValue = presetValue;
									g_dpList[j].value = value;
									valueStr = value;
									if(g_dpList[j].bStructured) 
										valueStr = JSON.stringify(value);
									else if(g_dpList[j].bString) {
										if((valueStr.indexOf("\"") !== -1) && (valueStr.length > 1)) {
												valueStr = valueStr.substr(1, valueStr.length - 2);
										}
									}
									g_dpList[j].valueStr = valueStr;
									g_dpList[j].dpValueChanged = true;
									break;
								}
							}
						}
					}
				}
			}
		}
		else if(value !== null) {
			if(value !== null) {
				valueStr = value;
				presetValue = null;
				g_dpList[j].presetValue = presetValue;
				if(g_dpList[j].bStructured) 
					valueStr = JSON.stringify(value);
				else if(g_dpList[j].bString) {
					if((valueStr.indexOf("\"") !== -1) && (valueStr.length > 1)) {
							valueStr = valueStr.substr(1, valueStr.length - 2);
							
					}
				}
				g_dpList[j].value = value;
				g_dpList[j].valueStr = valueStr;
				g_dpList[j].dpValueChanged = true;
			}
			
		}
		else {
			value = g_dpList[j].value;
			valueStr = g_dpList[j].valueStr;
			presetValue = g_dpList[j].presetValue;
		}
		origValue = value;
		origValueStr = valueStr;
		origPresetValue = presetValue;
		if(bUpdatePriority) { 
			if(priorityValues !== null) {
				g_dpList[j].values = priorityValues;
				if(priority === null) {
					if(g_dpList[j].priority !== g_dpList[j].values.level)
						g_dpList[j].priority = g_dpList[j].values.level; 
				}
			}
			if(priority !== null) {
				if(typeof priority === "string")
					priority = Number(priority);
				g_dpList[j].priority = priority;
				g_dpList[j].values.level = priority; 
				if(typeof g_dpList[j].values !== "undefined") {
					if(typeof g_dpList[j].values.levels !== "undefined") {
						if(bUpdateValue)
							g_dpList[j].values.levels[priority] = value;
					}
				}
			}
		}
		
		if(g_dpList[j].displayElements !== null)
		{
			for(k=0; k < g_dpList[j].displayElements.length; k++)
			{
				try
				{
					//repopulate values as previous displayElement may have been a field
					value = origValue;
					valueStr = origValueStr;
					presetValue = origPresetValue;

					if(bUpdatePriority) {
						if(g_dpList[j].displayElements[k].displayType === "noop") { 
								// do nothing as this is a place holder for send button needing new name
						}
						else if(g_dpList[j].displayElements[k].displayType === "priority_span") { 
							// span current datapoint priority
							
							priority = null;
							if(typeof g_dpList[j].values !== "undefined") {
								if(typeof g_dpList[j].values.level !== "undefined")
									priority = g_dpList[j].values.level;
							}
							if(priority !== null) {
								if(document.getElementById(g_dpList[j].displayElements[k].displayId).innerHTML !== priority)
									document.getElementById(g_dpList[j].displayElements[k].displayId).innerHTML = priority;
							}
							
						}
						else if(g_dpList[j].displayElements[k].displayType === "priority_indicator") { 
							if(typeof g_dpList[j].priority !== "undefined") {
								priorityNum = g_dpList[j].displayElements[k].priorityNum;
								if(priorityNum !== -1) {
									bActive = false;
									if(priorityNum === 0)
										priorityNum = 17;
									if(g_dpList[j].priority < priorityNum) 
										bActive = true;
									element = document.getElementById(g_dpList[j].displayElements[k].displayId);
									if(element !== null) {
										if(window.getComputedStyle(element).visibility === "hidden") {
											if(bActive) {
												element.style.visibility = "visible";
											}
										}
										else {
											if(!bActive) {
												element.style.visibility = "hidden";
											}
										}
										if((g_dpList[j].displayElements[k].priorityIndicatorType === "prioritybutton") 
											|| (g_dpList[j].displayElements[k].priorityIndicatorType === "priorityallbutton")) {
											if(bActive) {
												priority = null;
												if(typeof g_dpList[j].values !== "undefined") {
													if(typeof g_dpList[j].values.level !== "undefined")
														priority = g_dpList[j].values.level;
												}
												if(priority !== null) {
													if(priority === 17) {
														
													}
													else {
														if(element.innerHTML !== g_dpList[j].displayElements[k].text + priority)
															element.innerHTML = g_dpList[j].displayElements[k].text + priority;
													}
												}
											}
										}
									}
								}
							}
						}
						else if(g_dpList[j].displayElements[k].displayType === "clearoverride_button") { 
							// make visible button based on whether priority is actve
							
							if(typeof g_dpList[j].priority !== "undefined") {
								priorityNum = g_dpList[j].displayElements[k].priorityNum;
								if(priorityNum !== -1) {
									if(typeof g_dpList[j].values !== "undefined") {
										if(typeof g_dpList[j].values.levels !== "undefined") {
											bActive = false;
											if(priorityNum === 0) {
												// any priorities
												if(g_dpList[j].values.level < 17)
													bActive = true;
											}
											else {
												// single priority
												if(g_dpList[j].values.levels.hasOwnProperty(priorityNum))
													bActive = true;
											}
											if((g_dpList[j].displayElements[k].clearoverrideType === "button") 
												|| (g_dpList[j].displayElements[k].clearoverrideType === "prioritybutton")) {
												element = document.getElementById(g_dpList[j].displayElements[k].displayId);
												if(element !== null) {
													if(window.getComputedStyle(element).visibility === "hidden") {
														if(bActive)
															element.style.visibility = "visible";
													}
													else {
														if(!bActive)
															element.style.visibility = "hidden";
													}
													if(g_dpList[j].displayElements[k].clearoverrideType === "prioritybutton") {
														if(bActive) {
															priority = null;
															if(typeof g_dpList[j].values !== "undefined") {
																if(typeof g_dpList[j].values.level !== "undefined")
																	priority = g_dpList[j].values.level;
															}
															if(priority !== null) {
																if(priority === 17) {
																	
																}
																else {
																	if(element.innerHTML !== g_dpList[j].displayElements[k].text + priority)
																		element.innerHTML = g_dpList[j].displayElements[k].text + priority;
																}
															}
														}
													}
												}
											}
											else if(g_dpList[j].displayElements[k].clearoverrideType === "switch") {
												element = document.getElementById(g_dpList[j].displayElements[k].displayId);
												if(element !== null) {
													if(element.checked) {
														if(!bActive) {
															element.checked = false;
															element.disabled = true;

														}
													}
													else {
														if(bActive) {
															element.checked = true;
															element.disabled = false;
														}
													}
												}
											}
										}
									}
								}
							}
							
						}
					}
					if(bUpdateValue) {
						
						if(g_dpList[j].displayElements[k].displayType === "noop") { 
								// do nothing as this is a place holder for send button needing new name
						}
						else if(g_dpList[j].displayElements[k].displayType === "priority_span") {
							// don't do anything
						}
						else if(g_dpList[j].displayElements[k].displayType === "priority_indicator") { 

						}
						else if(g_dpList[j].displayElements[k].displayType === "clearoverride_button") { 
							// don't do anything
						}
						else if(g_dpList[j].displayElements[k].displayType === "presets_datalist") { 
							
							if(g_dpList[j].displayElements[k].iAddPresets === 1) {
								g_dpList[j].displayElements[k].iAddPresets = 0;
								try {
									if(g_dpList[j].displayElements[k].iDisplayPreset > 0) {
										sTemp = "";
										if(typeof g_dpList[j].presets !== "undefined") {
											if(g_dpList[j].presets !== null) {
												if(typeof g_dpList[j].presets.map !== "undefined") {
													if(g_dpList[j].presets.map !== null) {
														if(g_dpList[j].presets.map.length > 0) {
															element = document.getElementById(g_dpList[j].displayElements[k].displayId);
															if(element != null) {
																for(s=0; s < g_dpList[j].presets.map.length; s++)
																{
																	sTemp += "<option>" + g_dpList[j].presets.map[s].name + "</option>";
																}
																if(g_dpList[j].displayElements[k].iDisplayPreset === 2) {
																	sTemp1 = g_dpList[j].value;
																	if(typeof sTemp1 === "number") {
																		sTemp += "<option>" + sTemp1 + "</option>";
																	}
																	else {
																		sTemp1 = JSON.stringify(sTemp1)
																		if(sTemp1.length > 1) {
																			if((sTemp1.charAt(0) === "{") && (sTemp1.charAt(0) === "}")) {
																				sTemp1 = sTemp1.substr(1, (sTemp1.length - 2));
																			}
																			sTemp += "<option>" + sTemp1 + "</option>";
																		}
																	}
																}
																if(sTemp !== "") {
																	element.innerHTML = element.innerHTML + sTemp;
																}
															}
														}
													}
												}
											}
										}
									}
								}
								catch (err) {}
							}
						}
						else if(g_dpList[j].displayElements[k].readWriteType !== "w")
						{
							
							
							if(g_dpList[j].displayElements[k].field !== "")
							{
								value = value[g_dpList[j].displayElements[k].field];
								valueStr = value;
								if(typeof value === "object")
									valueStr = JSON.stringify(value);
							}
							else {
								if(g_bPresetsSupported) {
									if(g_dpList[j].presetValue !== null) {
										if(g_dpList[j].presetValue !== "")
											valueStr = g_dpList[j].presetValue;
									}
								}
								//else // ffix may need this
								//	valueStr = value1;
							}
							if((!g_dpList[j].displayElements[k].readWriteType.includes("w"))
								|| (g_dpList[j].displayElements[k].displayType === "dropdown_text"))
							{
								if(!(typeof valueStr === "number"))
									valueStr = valueStr.replace(/\"/g,"");
							}
							if(!(typeof valueStr === "number"))
								valueStr = valueStr.replace(/{|}/g,"");
							if(g_dpList[j].displayElements[k].decimalPlaces !== null) {
								if(g_dpList[j].displayElements[k].decimalPlaces !== -1)
									var decimalPlaces = g_dpList[j].displayElements[k].decimalPlaces;
									if(typeof value === "number")
										valueStr = valueStr.toFixed(decimalPlaces);
									else if(typeof value === "string") {
										valueStr = Number(valueStr).toFixed(decimalPlaces);
									}
							}
							if(g_dpList[j].displayElements[k].displayType === "function") {
								try {
									g_dpList[j].displayElements[k].function(g_dpList[j].displayElements[k].displayId,
										g_dpList[j].dpName,
										g_dpList[j].displayElements[k].field,
										value);
								}
								catch {}
							}
							else if(g_dpList[j].displayElements[k].displayType === "jsfunction") {
								try 
								{
									iIndex = -1;
									if(typeof g_dpList[j].displayElements[k].function === "number") {
										iIndex = g_dpList[j].displayElements[k].function;
										jsFunctionIndex = -1;
										for(z=0; z < g_arrDpChangeJsFunctionList.length; z++)
										{
											if(iIndex === g_arrDpChangeJsFunctionList[z]) {
												jsFunctionIndex = z;
												break;
											}
										}
										if(jsFunctionIndex === -1) {
											g_arrDpChangeJsFunctionList.push(iIndex);
										}
									}
								}
								catch (e) {}
							}
							else if(g_dpList[j].displayElements[k].displayType === "input")
								document.getElementById(g_dpList[j].displayElements[k].displayId).value = valueStr;
							else if (g_dpList[j].displayElements[k].displayType === "dropdown_text") {
									document.getElementById(g_dpList[j].displayElements[k].displayId).value = valueStr; //jsonValue;
							}
							else if(g_dpList[j].displayElements[k].displayType === "dropdown_number") {
								document.getElementById(g_dpList[j].displayElements[k].displayId).value = valueStr;
							}
							else if(g_dpList[j].displayElements[k].displayType === "span")
								document.getElementById(g_dpList[j].displayElements[k].displayId).innerHTML = valueStr;
							else if(g_dpList[j].displayElements[k].displayType === "chart") {
								if(g_bChartsSupported) {
									try {
										iIndex = g_dpList[j].displayElements[k].dashboardDpListIndex;
										
										if((iIndex !== -1) && (iIndex < dashboardDpList.length)) {
											if(g_dpList[j].dpName === dashboardDpList[iIndex].dpPath) {
												_chartNewUpdate(iIndex,g_dpList[j].dpName,value,presetValue,currentTimeMs);
												
											}
											
										}
									}
									catch {}
								}
							}
						}
						
					}
				}
				catch(err)
				{}
			}
		}
	}
	catch(e) {}
}
